<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        // First, ensure the database connection uses UTF-8
        DB::statement('SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci');
        
        // Update the table charset and collation
        DB::statement('ALTER TABLE account_transactions CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
        
        // Update specific columns that store Kurdish text
        Schema::table('account_transactions', function (Blueprint $table) {
            // Update note column to support Kurdish text properly
            $table->text('note')->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->nullable()->change();
            
            // Update person_name column to support Kurdish text properly  
            $table->string('person_name')->charset('utf8mb4')->collation('utf8mb4_unicode_ci')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        // Revert to default charset
        DB::statement('ALTER TABLE account_transactions CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci');
        
        Schema::table('account_transactions', function (Blueprint $table) {
            $table->text('note')->charset('utf8')->collation('utf8_general_ci')->nullable()->change();
            $table->string('person_name')->charset('utf8')->collation('utf8_general_ci')->nullable()->change();
        });
    }
};


