<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('currencies', function (Blueprint $table) {
            $table->decimal('buy_rate', 10, 2)->nullable()->after('rate');
            $table->decimal('sell_rate', 10, 2)->nullable()->after('buy_rate');
        });
    }

    public function down()
    {
        Schema::table('currencies', function (Blueprint $table) {
            $table->dropColumn(['buy_rate', 'sell_rate']);
        });
    }
};
