<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        // Update the ENUM type to add 'fee'
        Schema::table('account_transactions', function (Blueprint $table) {
            DB::statement("ALTER TABLE `account_transactions` CHANGE `transaction_type` `transaction_type` ENUM('deposit','withdrawal','transfer','fee') NOT NULL");
        });
    }

    public function down()
    {
        // Revert the ENUM type to remove 'fee'
        Schema::table('account_transactions', function (Blueprint $table) {
            DB::statement("ALTER TABLE `account_transactions` CHANGE `transaction_type` `transaction_type` ENUM('deposit','withdrawal','transfer') NOT NULL");
        });
    }
};
