<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('transaction_fees', function (Blueprint $table) {

            $table->dropForeign(['transaction_id']);  // Drop the foreign key constraint

            // Now safely drop the 'transaction_id' column
            $table->dropColumn('transaction_id');

            // Add polymorphic columns
            $table->unsignedBigInteger('feeable_id');
            $table->string('feeable_type');

            // You may want to remove 'transaction_id' as it's no longer needed in the morph
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transaction_fees', function (Blueprint $table) {
            // Drop polymorphic columns
            $table->unsignedBigInteger('transaction_id');

            // Re-add the foreign key constraint
            $table->foreign('transaction_id')->references('id')->on('transactions')->onDelete('cascade');
    
            $table->dropColumn(['feeable_id', 'feeable_type']);

            // Restore 'transaction_id' if rolling back
        });
    }
};
