<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('transaction_fees', function (Blueprint $table) {
            $table->id();
            $table->foreignId('transaction_id')->constrained('account_transactions')->onDelete('cascade');
            $table->decimal('fee_amount', 15, 2); // Fee amount, with a precision of 15 and 2 decimal places
            $table->enum('fee_type', ['deposit_fee', 'withdrawal_fee', 'transfer_fee'])->nullable(); // Type of fee
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('transaction_fees');
    }
};
