<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table
                ->foreign('cashier_shift_id')
                ->references('id')
                ->on('cashier_shifts');

            $table
                ->foreign('from_currency')
                ->references('id')
                ->on('currencies');

            $table
                ->foreign('to_currency')
                ->references('id')
                ->on('currencies');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropForeign(['cashier_shift_id']);
            $table->dropForeign(['from_currency']);
            $table->dropForeign(['to_currency']);
        });
    }
};
