<?php

namespace Database\Factories;

use App\Models\Transaction;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

class TransactionFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Transaction::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'transaction_date' => $this->faker->date(),
            'transaction_time' => $this->faker->time(),
            'transaction_amount' => $this->faker->randomNumber(1),
            'transaction_type' => 'sell',
            'from_currency' => \App\Models\Currency::factory(),
            'to_currency' => \App\Models\Currency::factory(),
            'cashier_shift_id' => \App\Models\CashierShift::factory(),
        ];
    }
}
