<?php

namespace Database\Factories;

use App\Models\Customer;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

class CustomerFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Customer::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'customer_name' => $this->faker->text(255),
            'phone_number' => $this->faker->phoneNumber(),
            'second_phone' => $this->faker->text(255),
            'address' => $this->faker->address(),
            'note' => $this->faker->text(),
            'user_id' => \App\Models\User::factory(),
        ];
    }
}
