<?php

namespace Database\Factories;

use App\Models\Currency;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

class CurrencyFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Currency::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'currency_name' => $this->faker->sentence(10),
            'code' => $this->faker->text(255),
            'rate' => $this->faker->randomNumber(1),
        ];
    }
}
