<?php

namespace App\Traits;

trait HasUtf8Encoding
{
    /**
     * Ensure proper UTF-8 encoding for all string properties
     */
    public function ensureUtf8Encoding($data)
    {
        if (is_string($data)) {
            return mb_convert_encoding($data, 'UTF-8', 'auto');
        }
        
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                $data[$key] = $this->ensureUtf8Encoding($value);
            }
        }
        
        if (is_object($data)) {
            foreach (get_object_vars($data) as $key => $value) {
                $data->$key = $this->ensureUtf8Encoding($value);
            }
        }
        
        return $data;
    }
    
    /**
     * Ensure all public properties are properly UTF-8 encoded
     */
    public function encodeAllProperties()
    {
        $reflection = new \ReflectionClass($this);
        $properties = $reflection->getProperties(\ReflectionProperty::IS_PUBLIC);
        
        foreach ($properties as $property) {
            $propertyName = $property->getName();
            if (isset($this->$propertyName)) {
                $this->$propertyName = $this->ensureUtf8Encoding($this->$propertyName);
            }
        }
    }
}

