<?php

namespace App\Providers;

use Illuminate\Pagination\Paginator;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Route;
use Livewire\Livewire;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        Paginator::useBootstrap();
    }

    /**
     * Bootstrap any application services.
     */
    public function boot()
    {
        require_once app_path('Helpers/NumberToWords.php');
        
        // Fix UTF-8 encoding issues with Livewire
        Response::macro('utf8', function ($content) {
            return response($content)->header('Content-Type', 'text/html; charset=UTF-8');
        });
        
        // Ensure proper encoding for all responses
        Response::macro('ensureUtf8', function ($content) {
            if (is_string($content)) {
                $content = mb_convert_encoding($content, 'UTF-8', 'auto');
            }
            return response($content)->header('Content-Type', 'text/html; charset=UTF-8');
        });
        
        // Configure Livewire for proper UTF-8 handling
        Livewire::addPersistentMiddleware([
            \App\Http\Middleware\LocaleMiddleware::class,
        ]);
        
        // Ensure Livewire responses have proper UTF-8 encoding
        Livewire::setUpdateRoute(function ($handle) {
            return Route::post('/livewire/update', $handle)->middleware([
                'web',
                \App\Http\Middleware\LocaleMiddleware::class,
            ]);
        });
    }
}
