<?php

namespace App\Policies;

use App\Models\User;
use App\Models\ReturnItem;
use Illuminate\Auth\Access\HandlesAuthorization;

class ReturnItemPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the returnItem can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasPermissionTo('list returnitems');
    }

    /**
     * Determine whether the returnItem can view the model.
     */
    public function view(User $user, ReturnItem $model): bool
    {
        return $user->hasPermissionTo('view returnitems');
    }

    /**
     * Determine whether the returnItem can create models.
     */
    public function create(User $user): bool
    {
        return $user->hasPermissionTo('create returnitems');
    }

    /**
     * Determine whether the returnItem can update the model.
     */
    public function update(User $user, ReturnItem $model): bool
    {
        return $user->hasPermissionTo('update returnitems');
    }

    /**
     * Determine whether the returnItem can delete the model.
     */
    public function delete(User $user, ReturnItem $model): bool
    {
        return $user->hasPermissionTo('delete returnitems');
    }

    /**
     * Determine whether the user can delete multiple instances of the model.
     */
    public function deleteAny(User $user): bool
    {
        return $user->hasPermissionTo('delete returnitems');
    }

    /**
     * Determine whether the returnItem can restore the model.
     */
    public function restore(User $user, ReturnItem $model): bool
    {
        return false;
    }

    /**
     * Determine whether the returnItem can permanently delete the model.
     */
    public function forceDelete(User $user, ReturnItem $model): bool
    {
        return false;
    }
}
