<?php

namespace App\Policies;

use App\Models\User;
use App\Models\OrderList;
use Illuminate\Auth\Access\HandlesAuthorization;

class OrderListPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the orderList can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasPermissionTo('list orderlists');
    }

    /**
     * Determine whether the orderList can view the model.
     */
    public function view(User $user, OrderList $model): bool
    {
        return $user->hasPermissionTo('view orderlists');
    }

    /**
     * Determine whether the orderList can create models.
     */
    public function create(User $user): bool
    {
        return $user->hasPermissionTo('create orderlists');
    }

    /**
     * Determine whether the orderList can update the model.
     */
    public function update(User $user, OrderList $model): bool
    {
        return $user->hasPermissionTo('update orderlists');
    }

    /**
     * Determine whether the orderList can delete the model.
     */
    public function delete(User $user, OrderList $model): bool
    {
        return $user->hasPermissionTo('delete orderlists');
    }

    /**
     * Determine whether the user can delete multiple instances of the model.
     */
    public function deleteAny(User $user): bool
    {
        return $user->hasPermissionTo('delete orderlists');
    }

    /**
     * Determine whether the orderList can restore the model.
     */
    public function restore(User $user, OrderList $model): bool
    {
        return false;
    }

    /**
     * Determine whether the orderList can permanently delete the model.
     */
    public function forceDelete(User $user, OrderList $model): bool
    {
        return false;
    }
}
