<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Cashier;
use Illuminate\Auth\Access\HandlesAuthorization;

class CashierPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the cashier can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasPermissionTo('list cashiers');
    }

    /**
     * Determine whether the cashier can view the model.
     */
    public function view(User $user, Cashier $model): bool
    {
        return $user->hasPermissionTo('view cashiers');
    }

    /**
     * Determine whether the cashier can create models.
     */
    public function create(User $user): bool
    {
        return $user->hasPermissionTo('create cashiers');
    }

    /**
     * Determine whether the cashier can update the model.
     */
    public function update(User $user, Cashier $model): bool
    {
        return $user->hasPermissionTo('update cashiers');
    }

    /**
     * Determine whether the cashier can delete the model.
     */
    public function delete(User $user, Cashier $model): bool
    {
        return $user->hasPermissionTo('delete cashiers');
    }

    /**
     * Determine whether the user can delete multiple instances of the model.
     */
    public function deleteAny(User $user): bool
    {
        return $user->hasPermissionTo('delete cashiers');
    }

    /**
     * Determine whether the cashier can restore the model.
     */
    public function restore(User $user, Cashier $model): bool
    {
        return false;
    }

    /**
     * Determine whether the cashier can permanently delete the model.
     */
    public function forceDelete(User $user, Cashier $model): bool
    {
        return false;
    }
}
