<?php

namespace App\Policies;

use App\Models\User;
use App\Models\AccountTransaction;
use Illuminate\Auth\Access\HandlesAuthorization;

class AccountTransactionPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the accountTransaction can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasPermissionTo('list accounttransactions');
    }

    /**
     * Determine whether the accountTransaction can view the model.
     */
    public function view(User $user, AccountTransaction $model): bool
    {
        return $user->hasPermissionTo('view accounttransactions');
    }

    /**
     * Determine whether the accountTransaction can create models.
     */
    public function create(User $user): bool
    {
        return $user->hasPermissionTo('create accounttransactions');
    }

    /**
     * Determine whether the accountTransaction can update the model.
     */
    public function update(User $user, AccountTransaction $model): bool
    {
        return $user->hasPermissionTo('update accounttransactions');
    }

    /**
     * Determine whether the accountTransaction can delete the model.
     */
    public function delete(User $user, AccountTransaction $model): bool
    {
        return $user->hasPermissionTo('delete accounttransactions');
    }

    /**
     * Determine whether the user can delete multiple instances of the model.
     */
    public function deleteAny(User $user): bool
    {
        return $user->hasPermissionTo('delete accounttransactions');
    }

    /**
     * Determine whether the accountTransaction can restore the model.
     */
    public function restore(User $user, AccountTransaction $model): bool
    {
        return false;
    }

    /**
     * Determine whether the accountTransaction can permanently delete the model.
     */
    public function forceDelete(User $user, AccountTransaction $model): bool
    {
        return false;
    }
}
