<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TransactionUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'transaction_date' => ['required', 'date'],
            'transaction_time' => ['required', 'date_format:H:i:s'],
            'transaction_amount' => ['required', 'numeric'],
            'transaction_type' => ['required', 'in:sell,buy'],
            'from_currency' => ['required', 'exists:currencies,id'],
            'to_currency' => ['required', 'exists:currencies,id'],
        ];
    }
}
