<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CurrencyUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'currency_name' => ['required', 'max:255', 'string'],
            'code' => ['nullable', 'image', 'mimes:jpeg,png,jpg,gif', 'max:2048'], // Code is nullable when updating
            // 'rate' => ['required'], // Validate that rate is either 0 or 1
            'type' => ['nullable', 'string'], 
            'use_division_for_buy' => ['nullable'],
        ];
    }
}
