<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CurrencyStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'currency_name' => ['required', 'max:255', 'string'],
            'code' => ['required', 'image', 'mimes:jpeg,png,jpg,gif', 'max:2048'], // Image validation for 'code'
            // 'rate' => ['required'], // Validate that rate is either 0 or 1
            'type' => ['nullable', 'string'],   
            'use_division_for_buy' => ['nullable'],   
        ];
    }
}
