<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Utf8EncodingMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);
        
        // Ensure proper UTF-8 encoding for all responses
        if ($response->headers->get('Content-Type')) {
            $contentType = $response->headers->get('Content-Type');
            
            // For HTML responses, ensure UTF-8 charset
            if (str_contains($contentType, 'text/html')) {
                if (!str_contains($contentType, 'charset=UTF-8')) {
                    $response->headers->set('Content-Type', $contentType . '; charset=UTF-8');
                }
                
                // Add UTF-8 meta tag to HTML content if not present
                $content = $response->getContent();
                if (is_string($content) && !str_contains($content, 'charset=UTF-8')) {
                    $content = str_replace('<head>', '<head><meta charset="UTF-8">', $content);
                    $response->setContent($content);
                }
            }
            
            // For JSON responses, ensure proper encoding
            if (str_contains($contentType, 'application/json')) {
                $response->headers->set('Content-Type', $contentType . '; charset=UTF-8');
            }
        }
        
        // Add UTF-8 encoding header
        $response->headers->set('X-Content-Type-Options', 'nosniff');
        
        return $response;
    }
}

