<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class LocaleMiddleware
{
  /**
   * Handle an incoming request.
   *
   * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
   */
  public function handle(Request $request, Closure $next): Response
  {
    // Get locale from session or cookie, default to 'en'
    $locale = session()->get('locale') ?? $request->cookie('locale') ?? 'en';
    
    // Validate and set locale
    if (in_array($locale, ['en', 'ku'])) {
      app()->setLocale($locale);
      
      // Set RTL mode based on locale (Kurdish is RTL, English is LTR)
      $isRTL = ($locale === 'ku');
      
      // Update session and cookie if they don't match the locale
      if (!session()->has('myRTLMode') || session()->get('myRTLMode') !== $isRTL) {
        session()->put('myRTLMode', $isRTL);
      }
    } else {
      // Set default locale to English if invalid locale
      app()->setLocale('en');
      session()->put('locale', 'en');
      session()->put('myRTLMode', false);
    }

    // Ensure proper UTF-8 encoding for Kurdish characters
    $response = $next($request);
    
    if ($response->headers->get('Content-Type') && str_contains($response->headers->get('Content-Type'), 'text/html')) {
      $response->headers->set('Content-Type', 'text/html; charset=UTF-8');
    }
    
    // Add UTF-8 meta tag to HTML responses
    if ($response->headers->get('Content-Type') && str_contains($response->headers->get('Content-Type'), 'text/html')) {
      $content = $response->getContent();
      if (is_string($content) && !str_contains($content, 'charset=UTF-8')) {
        $content = str_replace('<head>', '<head><meta charset="UTF-8">', $content);
        $response->setContent($content);
      }
    }

    return $response;
  }
}
