<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Account;
use App\Models\Customer;
use App\Models\AccountTransaction;
use App\Models\Transaction;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function check_balance(Account $account)
    {
        return view('app.customers.kashf',compact('account')); // The Blade view that includes the Livewire component
    }
    
    
    public function upload(Request $request)
    {
        $image = $request->input('image'); // Base64 image data
    
        if (!$image) {
            return response()->json(['error' => 'No image data found'], 400);
        }
    
        try {
            // Decode and save the image
            $imageName = 'customer_accounts_' . time() . '.png';
            $folder = 'whatsapp'; // Or 'customers' depending on the use case
            $directoryPath = public_path($folder);
    
            // Ensure the directory exists
            if (!is_dir($directoryPath)) {
                mkdir($directoryPath, 0755, true); // Recursive creation
            }
    
            $filePath = $directoryPath . '/' . $imageName;
            $image = explode(',', $image)[1]; // Remove the data URL prefix
            file_put_contents($filePath, base64_decode($image));
    
            $imageUrl = asset($folder . '/' . $imageName);
            return response()->json(['image_url' => $imageUrl], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
    

    public function transaction_invoice_pos($id)
    {
        $select_transaction = Transaction::where('id',$id)->first();
        return view('app.transactions.invoice-pos',compact('select_transaction')); // The Blade view that includes the Livewire component
    }
    public function transaction_invoice($id)
    {
        $select_transaction = Transaction::where('id',$id)->first();
        // dd($select_transaction);
        return view('app.transactions.invoice',compact('select_transaction')); // The Blade view that includes the Livewire component
    }
    public function invoice($id)
    {
        $select_transaction = AccountTransaction::where('id',$id)->first();
        // dd($select_transaction);
        return view('app.customers.invoice',compact('select_transaction')); // The Blade view that includes the Livewire component
    }
    
    public function profit()
    {
        return view('app.accounts.profit');
    }
    public function profit_report()
    {
        return view('app.accounts.profit-report');
    }
    public function account_transactions_transfer()
    {
        return view('app.account_transactions.new-create-transfer');
    }
    public function show_currency_user()
    {
        return view('app.currencies.show-currency-user');
    }
    public function show_customer(Customer $customer)
    {
        return view('app.customers.check-customer', compact('customer'));
    }
    public function invoice_transfer($id)
    {
        $select_transaction = AccountTransaction::where('id',$id)->first();
        // dd($select_transaction);
        return view('app.customers.invoice-transfer',compact('select_transaction')); // The Blade view that includes the Livewire component
    }
    public function cashbox_transaction()
    {
        return view('app.accounts.cashbox-transaction');
    }

    public function order_currency()
    {
        return view('app.currencies.order');
    }
    public function show_currency()
    {
        return view('app.currencies.show-currency');
    }
    public function owner_accounts()
    {
        return view('app.accounts.owner-cash-box');
    }

    public function account_transactions()
    {
        return view('app.account_transactions.new-create');
    }
    public function search()
    {
        return view('app.search.search');
    }
    
    public function transaction_form_report()
    {
        return view('app.accounts.transaction-form-report'); // The Blade view that includes the Livewire component
    }

    public function transaction_report()
    {
        return view('app.accounts.transaction-report'); // The Blade view that includes the Livewire component
    }
    
    public function account_transfer()
    {
        return view('app.accounts.account-transfer'); // The Blade view that includes the Livewire component
    }

    public function logs(Request $request)
    {
        // $this->authorize('view-any', Item::class);
        $search = $request->get('search', '');
        $event = $request->get('event', '');
        $user_id = $request->get('user_id', '');
        $subject_type = $request->get('subject_type', '');
        $date_filter = $request->get('date_filter', '');
        $per_page = $request->get('per_page', 50);

        $query = \Spatie\Activitylog\Models\Activity::query();

        // Search in description and properties
        if ($search) {
            $query->where(function($q) use ($search) {
                $q->where('description', 'like', "%{$search}%")
                  ->orWhere('properties', 'like', "%{$search}%")
                  ->orWhere('subject_type', 'like', "%{$search}%");
            });
        }

        // Filter by event type (created, updated, deleted)
        if ($event) {
            $query->where('event', $event);
        }

        // Filter by user
        if ($user_id) {
            $query->where('causer_id', $user_id);
        }

        // Filter by model type
        if ($subject_type) {
            $query->where('subject_type', 'like', "%{$subject_type}%");
        }

        // Date range filters
        if ($date_filter) {
            switch ($date_filter) {
                case 'today':
                    $query->whereDate('created_at', today());
                    break;
                case 'yesterday':
                    $query->whereDate('created_at', today()->subDay());
                    break;
                case 'last_7_days':
                    $query->where('created_at', '>=', now()->subDays(7));
                    break;
                case 'last_30_days':
                    $query->where('created_at', '>=', now()->subDays(30));
                    break;
                case 'this_month':
                    $query->whereMonth('created_at', now()->month)
                          ->whereYear('created_at', now()->year);
                    break;
                case 'last_month':
                    $query->whereMonth('created_at', now()->subMonth()->month)
                          ->whereYear('created_at', now()->subMonth()->year);
                    break;
            }
        }

        $activities = $query->with('causer')
            ->orderByDesc('created_at')
            ->paginate($per_page)
            ->appends($request->query());

        // Get all users for filter dropdown
        $users = \App\Models\User::select('id', 'name')->get();

        // Get unique model types
        $modelTypes = \Spatie\Activitylog\Models\Activity::select('subject_type')
            ->distinct()
            ->pluck('subject_type')
            ->map(function($type) {
                return substr($type, strrpos($type, "\\") + 1);
            })
            ->unique()
            ->sort();

        return view('app.logs.index', compact('activities', 'search', 'event', 'user_id', 'subject_type', 'date_filter', 'users', 'modelTypes', 'per_page'));
    }

    public function log_search(Request $request)
    {
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');
        $search = $request->get('search', '');
        $event = $request->get('event', '');
        $user_id = $request->get('user_id', '');
        $subject_type = $request->get('subject_type', '');
        $per_page = $request->get('per_page', 50);

        $query = \Spatie\Activitylog\Models\Activity::query();

        // Date range filter
        if ($startDate && $endDate) {
            $query->whereBetween('created_at', [$startDate, $endDate . ' 23:59:59']);
        }

        // Search filter
        if ($search) {
            $query->where(function($q) use ($search) {
                $q->where('description', 'like', "%{$search}%")
                  ->orWhere('properties', 'like', "%{$search}%")
                  ->orWhere('subject_type', 'like', "%{$search}%");
            });
        }

        // Filter by event type
        if ($event) {
            $query->where('event', $event);
        }

        // Filter by user
        if ($user_id) {
            $query->where('causer_id', $user_id);
        }

        // Filter by model type
        if ($subject_type) {
            $query->where('subject_type', 'like', "%{$subject_type}%");
        }

        $activities = $query->with('causer')
            ->orderByDesc('created_at')
            ->paginate($per_page)
            ->appends($request->query());

        // Get all users for filter dropdown
        $users = \App\Models\User::select('id', 'name')->get();

        // Get unique model types
        $modelTypes = \Spatie\Activitylog\Models\Activity::select('subject_type')
            ->distinct()
            ->pluck('subject_type')
            ->map(function($type) {
                return substr($type, strrpos($type, "\\") + 1);
            })
            ->unique()
            ->sort();

        return view('app.logs.index', compact('activities', 'search', 'event', 'user_id', 'subject_type', 'users', 'modelTypes', 'per_page', 'startDate', 'endDate'));
    }

    public function exportLogs(Request $request)
    {
        $search = $request->get('search', '');
        $event = $request->get('event', '');
        $user_id = $request->get('user_id', '');
        $subject_type = $request->get('subject_type', '');
        $date_filter = $request->get('date_filter', '');

        $query = \Spatie\Activitylog\Models\Activity::query();

        // Apply same filters as the main logs method
        if ($search) {
            $query->where(function($q) use ($search) {
                $q->where('description', 'like', "%{$search}%")
                  ->orWhere('properties', 'like', "%{$search}%")
                  ->orWhere('subject_type', 'like', "%{$search}%");
            });
        }

        if ($event) {
            $query->where('event', $event);
        }

        if ($user_id) {
            $query->where('causer_id', $user_id);
        }

        if ($subject_type) {
            $query->where('subject_type', 'like', "%{$subject_type}%");
        }

        if ($date_filter) {
            switch ($date_filter) {
                case 'today':
                    $query->whereDate('created_at', today());
                    break;
                case 'yesterday':
                    $query->whereDate('created_at', today()->subDay());
                    break;
                case 'last_7_days':
                    $query->where('created_at', '>=', now()->subDays(7));
                    break;
                case 'last_30_days':
                    $query->where('created_at', '>=', now()->subDays(30));
                    break;
                case 'this_month':
                    $query->whereMonth('created_at', now()->month)
                          ->whereYear('created_at', now()->year);
                    break;
                case 'last_month':
                    $query->whereMonth('created_at', now()->subMonth()->month)
                          ->whereYear('created_at', now()->subMonth()->year);
                    break;
            }
        }

        $activities = $query->with('causer')->orderByDesc('created_at')->get();

        // Generate CSV
        $filename = 'system_logs_' . now()->format('Y-m-d_His') . '.csv';
        
        $headers = [
            'Content-Type' => 'text/csv',
            'Content-Disposition' => 'attachment; filename="' . $filename . '"',
        ];

        $callback = function() use ($activities) {
            $file = fopen('php://output', 'w');
            
            // Add BOM for UTF-8
            fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
            
            // Add headers
            fputcsv($file, ['ID', 'Type', 'Action', 'Description', 'User', 'Date & Time']);

            foreach ($activities as $activity) {
                $row = [
                    $activity->id,
                    substr($activity->subject_type, strrpos($activity->subject_type, "\\") + 1),
                    ucfirst($activity->event),
                    strip_tags($activity->description ?? '-'),
                    $activity->causer->name ?? 'System',
                    $activity->created_at->format('Y-m-d H:i:s'),
                ];
                
                fputcsv($file, $row);
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }

    public function cashier_shift()
    {
        return view('app.cashiers.cashier-shift'); // The Blade view that includes the Livewire component
    }
    public function show_cashbox(Account $account)
    {
        return view('app.accounts.cash-box',compact('account')); // The Blade view that includes the Livewire component
    }
    
    public function cashbox()
    {
        return view('app.accounts.cashbox'); // The Blade view that includes the Livewire component
    }
    
    public function customer_transactions()
    {
        return view('app.accounts.customer-transactions'); // The Blade view that includes the Livewire component
    }
    

    public function transaction_list()
    {
        return view('app.transactions.index'); // The Blade view that includes the Livewire component
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }
}
