<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Models\User;
use App\Traits\ApiResponse;

class NotificationPreferencesController extends Controller
{
    use ApiResponse;

    /**
     * Get user's notification preferences
     */
    public function getPreferences(Request $request): JsonResponse
    {
        $user = $request->user();
        
        return $this->successResponse([
            'notifications_enabled' => $user->notifications_enabled,
            'transaction_notifications' => $user->transaction_notifications,
            'currency_rate_notifications' => $user->currency_rate_notifications,
            'account_update_notifications' => $user->account_update_notifications,
        ], 'Notification preferences retrieved successfully');
    }

    /**
     * Update user's notification preferences
     */
    public function updatePreferences(Request $request): JsonResponse
    {
        $request->validate([
            'notifications_enabled' => 'boolean',
            'transaction_notifications' => 'boolean',
            'currency_rate_notifications' => 'boolean',
            'account_update_notifications' => 'boolean',
        ]);

        $user = $request->user();
        
        $user->update([
            'notifications_enabled' => $request->boolean('notifications_enabled', $user->notifications_enabled),
            'transaction_notifications' => $request->boolean('transaction_notifications', $user->transaction_notifications),
            'currency_rate_notifications' => $request->boolean('currency_rate_notifications', $user->currency_rate_notifications),
            'account_update_notifications' => $request->boolean('account_update_notifications', $user->account_update_notifications),
        ]);

        return $this->successResponse([
            'notifications_enabled' => $user->notifications_enabled,
            'transaction_notifications' => $user->transaction_notifications,
            'currency_rate_notifications' => $user->currency_rate_notifications,
            'account_update_notifications' => $user->account_update_notifications,
        ], 'Notification preferences updated successfully');
    }

    /**
     * Toggle all notifications on/off
     */
    public function toggleAll(Request $request): JsonResponse
    {
        $request->validate([
            'enabled' => 'required|boolean',
        ]);

        $user = $request->user();
        $enabled = $request->boolean('enabled');
        
        $user->update([
            'notifications_enabled' => $enabled,
            'transaction_notifications' => $enabled,
            'currency_rate_notifications' => $enabled,
            'account_update_notifications' => $enabled,
        ]);

        return $this->successResponse([
            'notifications_enabled' => $user->notifications_enabled,
            'transaction_notifications' => $user->transaction_notifications,
            'currency_rate_notifications' => $user->currency_rate_notifications,
            'account_update_notifications' => $user->account_update_notifications,
        ], $enabled ? 'All notifications enabled' : 'All notifications disabled');
    }
}
