<?php

namespace App\Http\Controllers\Api;

use App\Models\Currency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\TransactionResource;
use App\Http\Resources\TransactionCollection;

class CurrencyTransactionsController extends Controller
{
    public function index(
        Request $request,
        Currency $currency
    ): TransactionCollection {
        $this->authorize('view', $currency);

        $search = $request->get('search', '');

        $transactions = $currency
            ->transactions2()
            ->search($search)
            ->latest()
            ->paginate();

        return new TransactionCollection($transactions);
    }

    public function store(
        Request $request,
        Currency $currency
    ): TransactionResource {
        $this->authorize('create', Transaction::class);

        $validated = $request->validate([
            'transaction_date' => ['required', 'date'],
            'transaction_time' => ['required', 'date_format:H:i:s'],
            'transaction_amount' => ['required', 'numeric'],
            'transaction_type' => ['required', 'in:sell,buy'],
        ]);

        $transaction = $currency->transactions2()->create($validated);

        return new TransactionResource($transaction);
    }
}
