<?php

namespace App\Http\Controllers\Api;

use App\Models\Currency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\AccountResource;
use App\Http\Resources\AccountCollection;

class CurrencyAccountsController extends Controller
{
    public function index(
        Request $request,
        Currency $currency
    ): AccountCollection {
        $this->authorize('view', $currency);

        $search = $request->get('search', '');

        $accounts = $currency
            ->accounts()
            ->search($search)
            ->latest()
            ->paginate();

        return new AccountCollection($accounts);
    }

    public function store(Request $request, Currency $currency): AccountResource
    {
        $this->authorize('create', Account::class);

        $validated = $request->validate([
            'account_number' => ['required', 'max:255', 'string'],
            'balance' => ['required', 'numeric'],
            'customer_id' => ['required', 'exists:customers,id'],
            'account_type' => ['required', 'in:savings,checking'],
        ]);

        $account = $currency->accounts()->create($validated);

        return new AccountResource($account);
    }
}
