<?php

namespace App\Http\Controllers\Api;

use App\Models\CashierShift;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\TransactionResource;
use App\Http\Resources\TransactionCollection;

class CashierShiftTransactionsController extends Controller
{
    public function index(
        Request $request,
        CashierShift $cashierShift
    ): TransactionCollection {
        $this->authorize('view', $cashierShift);

        $search = $request->get('search', '');

        $transactions = $cashierShift
            ->transactions()
            ->search($search)
            ->latest()
            ->paginate();

        return new TransactionCollection($transactions);
    }

    public function store(
        Request $request,
        CashierShift $cashierShift
    ): TransactionResource {
        $this->authorize('create', Transaction::class);

        $validated = $request->validate([
            'transaction_date' => ['required', 'date'],
            'transaction_time' => ['required', 'date_format:H:i:s'],
            'transaction_amount' => ['required', 'numeric'],
            'transaction_type' => ['required', 'in:sell,buy'],
            'from_currency' => ['required', 'exists:currencies,id'],
            'to_currency' => ['required', 'exists:currencies,id'],
        ]);

        $transaction = $cashierShift->transactions()->create($validated);

        return new TransactionResource($transaction);
    }
}
