<?php

namespace App\Http\Controllers\Api;

use App\Models\Cashier;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\CashierShiftResource;
use App\Http\Resources\CashierShiftCollection;

class CashierCashierShiftsController extends Controller
{
    public function index(
        Request $request,
        Cashier $cashier
    ): CashierShiftCollection {
        $this->authorize('view', $cashier);

        $search = $request->get('search', '');

        $cashierShifts = $cashier
            ->cashierShifts()
            ->search($search)
            ->latest()
            ->paginate();

        return new CashierShiftCollection($cashierShifts);
    }

    public function store(
        Request $request,
        Cashier $cashier
    ): CashierShiftResource {
        $this->authorize('create', CashierShift::class);

        $validated = $request->validate([
            'supervisor_id' => ['required', 'exists:users,id'],
            'start_time' => ['required', 'date_format:H:i:s'],
            'end_time' => ['required', 'date_format:H:i:s'],
            'starting_amount' => ['required', 'numeric'],
            'ending_amount' => ['required', 'numeric'],
        ]);

        $cashierShift = $cashier->cashierShifts()->create($validated);

        return new CashierShiftResource($cashierShift);
    }
}
