<?php

namespace App\Http\Controllers\Api;

use App\Models\Account;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\AccountTransactionResource;
use App\Http\Resources\AccountTransactionCollection;

class AccountAccountTransactionsController extends Controller
{
    public function index(
        Request $request,
        Account $account
    ): AccountTransactionCollection {
        $this->authorize('view', $account);

        $search = $request->get('search', '');

        $accountTransactions = $account
            ->accountTransactions()
            ->search($search)
            ->latest()
            ->paginate();

        return new AccountTransactionCollection($accountTransactions);
    }

    public function store(
        Request $request,
        Account $account
    ): AccountTransactionResource {
        $this->authorize('create', AccountTransaction::class);

        $validated = $request->validate([
            'transaction_type' => [
                'required',
                'in:deposit,withdrawal,transfer',
            ],
            'transaction_amount' => ['required', 'numeric'],
            'transaction_date' => ['required', 'date'],
            'transaction_time' => ['required', 'date_format:H:i:s'],
            'note' => ['required', 'max:255', 'string'],
        ]);

        $accountTransaction = $account
            ->accountTransactions()
            ->create($validated);

        return new AccountTransactionResource($accountTransaction);
    }
}
