<?php
if (!function_exists('convertNumberToWordsKurdishSorani')) {
    function convertNumberToWordsKurdishSorani($number) {
        // Units, tens, hundreds
        $units = [
            '', 'یەک', 'دوو', 'سێ', 'چوار', 'پێنج', 'شەش', 'حەوت', 'هەشت', 'نۆ'
        ];
        $tens = [
            '', 'دە', 'بیست', 'سی', 'چل', 'پەنجا', 'شەست', 'حەفتا', 'هەشتا', 'نەوەد'
        ];
        $teens = [
            11 => 'یازدە', 12 => 'دوازدە', 13 => 'سیزدە', 14 => 'چواردە',
            15 => 'پازدە', 16 => 'شازدە', 17 => 'حەڤدە', 18 => 'هەژدە', 19 => 'نۆزدە'
        ];
        $hundreds = [
            '', 'سەد', 'دووسەد', 'سێسەد', 'چوارسەد', 'پێنجسەد', 'شەشسەد', 'حەوتسەد', 'هەشتسەد', 'نۆسەد'
        ];

        // If number is zero, return the word 'سفر' (zero in Sorani)
        if ($number == 0) {
            return 'سفر';
        }

        $words = '';
        $decimalWords = ''; // To hold fractional part (if any)

        // Ensure $number is treated as a numeric value
        $number = ltrim($number, '0'); // Remove leading zeros

        // Check if the number has a decimal point
        if (strpos($number, '.') !== false) {
            // Split the number into the whole part and the fractional part
            list($wholeNumber, $decimalPart) = explode('.', $number);

            // Convert the whole part (before the decimal) to words
            $words = convertWholeNumberToWords($wholeNumber, $units, $tens, $teens, $hundreds);

            // Convert the fractional part (after the decimal) to words
            $decimalWords = convertWholeNumberToWords($decimalPart, $units, $tens, $teens, $hundreds);

            // Add "و" (and) only if there are both whole and fractional parts
            if (!empty($decimalWords)) {
                $words .= ' و ' . $decimalWords;
            }
        } else {
            // If no decimal part, just convert the whole number
            $words = convertWholeNumberToWords($number, $units, $tens, $teens, $hundreds);
        }

        return $words;
    }

    // Helper function to convert the whole number part to words (before the decimal)
    function convertWholeNumberToWords($number, $units, $tens, $teens, $hundreds) {
        $segments = []; // To store individual segments of the number in words

        // Ensure $number is an integer
        $number = (int) $number;

        // Handle billions and beyond
        if ($number >= 1000000000) {
            $billionIndex = floor($number / 1000000000);
            $segments[] = convertWholeNumberToWords($billionIndex, $units, $tens, $teens, $hundreds) . ' ملیار';
            $number %= 1000000000;
        }

        // Handle millions
        if ($number >= 1000000) {
            $millionIndex = floor($number / 1000000);
            $segments[] = convertWholeNumberToWords($millionIndex, $units, $tens, $teens, $hundreds) . ' ملیۆن';
            $number %= 1000000;
        }

        // Handle thousands
        if ($number >= 1000) {
            $thousandIndex = floor($number / 1000);
            if ($thousandIndex > 1) { // Skip adding "یەک هەزار"
                $segments[] = convertWholeNumberToWords($thousandIndex, $units, $tens, $teens, $hundreds) . ' هەزار';
            } else {
                $segments[] = 'هەزار';
            }
            $number %= 1000;
        }

        // Handle special case for numbers 11-19
        if ($number >= 11 && $number <= 19) {
            $segments[] = $teens[$number];
            $number = 0;
        }

        // Handle hundreds
        if ($number >= 100) {
            $hundredIndex = floor($number / 100);
            $segments[] = $hundreds[$hundredIndex];
            $number %= 100;
        }

        // Handle tens
        if ($number >= 10) {
            $tenIndex = floor($number / 10);
            $segments[] = $tens[$tenIndex];
            $number %= 10;
        }

        // Handle units
        if ($number > 0) {
            $segments[] = $units[$number];
        }

        // Join all segments with "و" (and) but avoid adding it at the end
        return implode(' و ', $segments);
    }
}
?>
