<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\Api\StatisticsController;

class RecordCurrencyRates extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'currency:record-rates';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Record current currency rates to history';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Recording current currency rates...');

        $controller = new StatisticsController();
        $result = $controller->recordCurrentRates();

        if ($result['success']) {
            $this->info("✅ Recorded {$result['recorded']} currency rates at {$result['timestamp']}");
            return Command::SUCCESS;
        }

        $this->error('❌ Failed to record currency rates');
        return Command::FAILURE;
    }
}

