<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Account;
use App\Models\User;
use App\Models\Customer;

class CheckAccount2 extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'check:account2';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check account ID 2 ownership and details';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('=== CHECKING ACCOUNT ID 2 ===');

        try {
            // Check if account ID 2 exists
            $account = Account::with(['customer', 'currency'])->find(2);
            
            if (!$account) {
                $this->error('Account ID 2 does not exist');
                return;
            }
            
            $this->info("✅ Account ID 2 found:");
            $this->line("   - Account Title: {$account->account_title}");
            $this->line("   - Account Number: {$account->account_number}");
            $this->line("   - Customer ID: {$account->customer_id}");
            $this->line("   - Currency: " . ($account->currency ? $account->currency->currency_name : 'NULL'));
            $this->line("   - Balance: {$account->balance}");
            
            if ($account->customer) {
                $this->info("✅ Customer details:");
                $this->line("   - Customer Name: {$account->customer->customer_name}");
                $this->line("   - Customer Email: {$account->customer->email}");
                
                // Check if this customer has a user
                $user = User::where('customer_id', $account->customer_id)->first();
                if ($user) {
                    $this->info("✅ User found:");
                    $this->line("   - User ID: {$user->id}");
                    $this->line("   - Email: {$user->email}");
                } else {
                    $this->warn("⚠️ No user found for customer ID {$account->customer_id}");
                }
            } else {
                $this->error("❌ No customer found for account ID 2");
            }
            
            // Test the account statement logic
            $this->info("\n=== TESTING ACCOUNT STATEMENT LOGIC ===");
            $customerId = 1; // Assuming we're testing with customer ID 1
            $this->line("Testing with customer ID: $customerId");
            
            $customerAccount = Account::where('id', 2)
                ->where('customer_id', $customerId)
                ->first();
                
            if ($customerAccount) {
                $this->info("✅ Account ID 2 belongs to customer ID $customerId");
            } else {
                $this->error("❌ Account ID 2 does NOT belong to customer ID $customerId");
                $this->line("Account belongs to customer ID: {$account->customer_id}");
            }

        } catch (\Exception $e) {
            $this->error("Error: " . $e->getMessage());
            $this->line("Stack trace: " . $e->getTraceAsString());
        }

        $this->info('=== CHECK COMPLETE ===');
    }
}
