# al-aman - Financial Management System

A comprehensive financial management system built with Laravel backend and React Native mobile app.

## 🚀 Features

### Backend (Laravel + Livewire)
- **Account Management**: Multi-currency account support
- **Transaction Processing**: Deposits, withdrawals, transfers
- **User Management**: Role-based access control
- **Real-time Updates**: Livewire components for instant updates
- **Reporting**: Comprehensive transaction reports
- **API Integration**: RESTful API for mobile app

### Mobile App (React Native)
- **Cross-platform**: iOS and Android support
- **Authentication**: Secure login/registration
- **Account Overview**: Real-time balance checking
- **Transaction Management**: Create and view transactions
- **Offline Support**: Cached data for offline viewing
- **Native Performance**: Optimized for mobile devices

## 📱 Project Structure

```
cash-nrx/
├── app/                    # Laravel backend
│   ├── Http/Controllers/Api/  # Mobile API controllers
│   ├── Livewire/            # Livewire components
│   └── Models/              # Eloquent models
├── mobile-app/             # React Native mobile app
│   ├── src/screens/        # Mobile app screens
│   ├── src/services/       # API services
│   └── src/store/          # State management
├── routes/api.php          # API routes
└── ...
```

## 🛠️ Quick Start

### Backend Setup
```bash
# Install dependencies
composer install

# Setup environment
cp .env.example .env
php artisan key:generate

# Run migrations
php artisan migrate

# Start server
php artisan serve
```

### Mobile App Setup
```bash
# Navigate to mobile app
cd mobile-app

# Install dependencies
npm install

# Start Metro bundler
npm start

# Run on Android
npm run android

# Run on iOS (macOS only)
npm run ios
```

## 📖 Documentation

- **Backend API**: See `routes/api.php` for available endpoints
- **Mobile App**: See `mobile-app/SETUP.md` for detailed setup
- **Database**: Check `database/migrations/` for schema

## 🔧 Development

### Backend Development
- Laravel 10 with Livewire 3
- MySQL database
- Laravel Sanctum for API authentication
- Spatie permissions for role management

### Mobile Development
- React Native with TypeScript
- Zustand for state management
- React Navigation for routing
- React Native Paper for UI components

## 📦 Deployment

### Backend
- Deploy to your preferred hosting (Digital Ocean, AWS, etc.)
- Configure environment variables
- Run migrations and seeders

### Mobile App
- Build for production
- Submit to App Store and Google Play Store
- Update API endpoints for production

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## 📄 License

This project is licensed under the MIT License.

---

<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/laravel-logolockup-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

<p align="center">
<a href="https://github.com/laravel/framework/actions"><img src="https://github.com/laravel/framework/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/dt/laravel/framework" alt="Total Downloads"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/v/laravel/framework" alt="Latest Stable Version"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/l/laravel/framework" alt="License"></a>
</p>

Laravel is a web application framework with expressive, elegant syntax. We believe development must be an enjoyable and creative experience to be truly fulfilling. Laravel takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://laravel.com/docs/routing).
- [Powerful dependency injection container](https://laravel.com/docs/container).
- Multiple back-ends for [session](https://laravel.com/docs/session) and [cache](https://laravel.com/docs/cache) storage.
- Expressive, intuitive [database ORM](https://laravel.com/docs/eloquent).
- Database agnostic [schema migrations](https://laravel.com/docs/migrations).
- [Robust background job processing](https://laravel.com/docs/queues).
- [Real-time event broadcasting](https://laravel.com/docs/broadcasting).

Laravel is accessible, powerful, and provides tools required for large, robust applications.

## Learning Laravel

Laravel has the most extensive and thorough [documentation](https://laravel.com/docs) and video tutorial library of all modern web application frameworks, making it a breeze to get started with the framework.

You may also try the [Laravel Bootcamp](https://bootcamp.laravel.com), where you will be guided through building a modern Laravel application from scratch.

If you don't feel like reading, [Laracasts](https://laracasts.com) can help. Laracasts contains over 2000 video tutorials on a range of topics including Laravel, modern PHP, unit testing, and JavaScript. Boost your skills by digging into our comprehensive video library.

## Laravel Sponsors

We would like to extend our thanks to the following sponsors for funding Laravel development. If you are interested in becoming a sponsor, please visit the Laravel [Patreon page](https://patreon.com/taylorotwell).

### Premium Partners

- **[Vehikl](https://vehikl.com/)**
- **[Tighten Co.](https://tighten.co)**
- **[Kirschbaum Development Group](https://kirschbaumdevelopment.com)**
- **[64 Robots](https://64robots.com)**
- **[Cubet Techno Labs](https://cubettech.com)**
- **[Cyber-Duck](https://cyber-duck.co.uk)**
- **[Many](https://www.many.co.uk)**
- **[Webdock, Fast VPS Hosting](https://www.webdock.io/en)**
- **[DevSquad](https://devsquad.com)**
- **[Curotec](https://www.curotec.com/services/technologies/laravel/)**
- **[OP.GG](https://op.gg)**
- **[WebReinvent](https://webreinvent.com/?utm_source=laravel&utm_medium=github&utm_campaign=patreon-sponsors)**
- **[Lendio](https://lendio.com)**

## Contributing

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
