-- Database backup created on 2025-06-15 20:07:33
-- ------------------------------------------------------------

-- Table structure for table `account_transactions`
DROP TABLE IF EXISTS `account_transactions`;
CREATE TABLE `account_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` varchar(255) DEFAULT NULL,
  `transaction_group_id` char(36) DEFAULT NULL,
  `transaction_type` enum('deposit','withdrawal','transfer','fee') NOT NULL,
  `transaction_amount` decimal(20,2) NOT NULL,
  `transaction_date` date NOT NULL,
  `transaction_time` time NOT NULL,
  `note` varchar(255) DEFAULT NULL,
  `get_fee` decimal(15,2) DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `person_name` varchar(255) DEFAULT NULL,
  `sender_name` varchar(255) DEFAULT NULL,
  `receiver_name` varchar(255) DEFAULT NULL,
  `sender_phone` varchar(255) DEFAULT NULL,
  `receiver_phone` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `from_account_id` bigint(20) unsigned DEFAULT NULL,
  `to_account_id` bigint(20) unsigned DEFAULT NULL,
  `exchange_rate` decimal(10,4) DEFAULT NULL,
  `transaction_category` enum('buy','sell') DEFAULT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'approved',
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `moneyTransferOnly` tinyint(1) NOT NULL DEFAULT 0,
  `approved_by` bigint(20) unsigned DEFAULT NULL,
  `approved_at` timestamp NULL DEFAULT NULL,
  `rejected_by` bigint(20) unsigned DEFAULT NULL,
  `rejected_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_user_id_foreign` (`user_id`),
  KEY `account_transactions_from_account_id_foreign` (`from_account_id`),
  KEY `account_transactions_to_account_id_foreign` (`to_account_id`),
  KEY `account_transactions_transaction_group_id_index` (`transaction_group_id`),
  KEY `account_transactions_approved_by_foreign` (`approved_by`),
  KEY `account_transactions_rejected_by_foreign` (`rejected_by`),
  CONSTRAINT `account_transactions_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`),
  CONSTRAINT `account_transactions_from_account_id_foreign` FOREIGN KEY (`from_account_id`) REFERENCES `accounts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `account_transactions_rejected_by_foreign` FOREIGN KEY (`rejected_by`) REFERENCES `users` (`id`),
  CONSTRAINT `account_transactions_to_account_id_foreign` FOREIGN KEY (`to_account_id`) REFERENCES `accounts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `account_transactions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38958 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `account_transactions`
INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(10577, NULL, '4fbe57db-ffef-49ad-82cf-1906841b65cd', 'withdrawal', 1659244.00, '2025-02-02', '09:12:58', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:12:58', '2025-02-02 09:12:58', 469, 67, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10578, NULL, '4fbe57db-ffef-49ad-82cf-1906841b65cd', 'deposit', 1659244.00, '2025-02-02', '09:12:58', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:12:58', '2025-02-02 09:12:58', 67, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10579, NULL, '4fbe57db-ffef-49ad-82cf-1906841b65cd', 'deposit', 0.00, '2025-02-02', '09:12:58', 'Fee collected for transfer', 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:12:58', '2025-02-02 09:12:58', 68, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10580, NULL, 'c694b81f-886f-4e88-a0c7-7775e19a72bc', 'withdrawal', 7049534.00, '2025-02-02', '09:14:05', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:14:05', '2025-02-02 09:14:05', 471, 444, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10581, NULL, 'c694b81f-886f-4e88-a0c7-7775e19a72bc', 'deposit', 7049534.00, '2025-02-02', '09:14:05', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:14:05', '2025-02-02 09:14:05', 444, 471, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10582, NULL, 'c694b81f-886f-4e88-a0c7-7775e19a72bc', 'deposit', 0.00, '2025-02-02', '09:14:05', 'Fee collected for transfer', 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:14:05', '2025-02-02 09:14:05', 445, 471, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10583, NULL, '1f40a3dd-c2d8-4520-a586-9ae76aaef32e', 'withdrawal', 50594.00, '2025-02-02', '09:14:46', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:14:46', '2025-02-02 09:14:46', 473, 4, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10584, NULL, '1f40a3dd-c2d8-4520-a586-9ae76aaef32e', 'deposit', 50594.00, '2025-02-02', '09:14:46', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:14:46', '2025-02-02 09:14:46', 4, 473, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10585, NULL, '1f40a3dd-c2d8-4520-a586-9ae76aaef32e', 'deposit', 0.00, '2025-02-02', '09:14:46', 'Fee collected for transfer', 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:14:46', '2025-02-02 09:14:46', 457, 473, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10586, NULL, 'a01d8c86-e390-4a97-800c-37a19e74b49a', 'withdrawal', 28491.00, '2025-02-02', '09:15:34', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:15:34', '2025-02-02 09:15:34', 468, 71, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10587, NULL, 'a01d8c86-e390-4a97-800c-37a19e74b49a', 'deposit', 28491.00, '2025-02-02', '09:15:34', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:15:34', '2025-02-02 09:15:34', 71, 468, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10588, NULL, 'a01d8c86-e390-4a97-800c-37a19e74b49a', 'deposit', 0.00, '2025-02-02', '09:15:34', 'Fee collected for transfer', 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:15:34', '2025-02-02 09:15:34', 72, 468, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10589, NULL, 'ea78c951-7044-4b20-b98d-cb331f4cadc7', 'withdrawal', 1065078.00, '2025-02-02', '09:16:35', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:16:35', '2025-02-02 09:16:35', 467, 73, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10590, NULL, 'ea78c951-7044-4b20-b98d-cb331f4cadc7', 'deposit', 1065078.00, '2025-02-02', '09:16:35', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:16:35', '2025-02-02 09:16:35', 73, 467, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10591, NULL, 'ea78c951-7044-4b20-b98d-cb331f4cadc7', 'deposit', 0.00, '2025-02-02', '09:16:35', 'Fee collected for transfer', 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:16:35', '2025-02-02 09:16:35', 74, 467, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10592, NULL, 'f770157e-cf8b-4394-b400-92c95a4c96e2', 'withdrawal', 11213742.00, '2025-02-02', '09:17:35', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:17:35', '2025-02-02 09:17:35', 475, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10593, NULL, 'f770157e-cf8b-4394-b400-92c95a4c96e2', 'deposit', 11213742.00, '2025-02-02', '09:17:35', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:17:35', '2025-02-02 09:17:35', 69, 475, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10594, NULL, 'f770157e-cf8b-4394-b400-92c95a4c96e2', 'deposit', 0.00, '2025-02-02', '09:17:35', 'Fee collected for transfer', 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:17:35', '2025-02-02 09:17:35', 70, 475, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10595, NULL, 'a7b6f353-9c0e-46cb-82bc-2ec32acea401', 'withdrawal', 862614.00, '2025-02-02', '09:19:13', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:19:13', '2025-02-02 09:19:13', 470, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10596, NULL, 'a7b6f353-9c0e-46cb-82bc-2ec32acea401', 'deposit', 862614.00, '2025-02-02', '09:19:13', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:19:13', '2025-02-02 09:19:13', 18, 470, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10597, NULL, 'a7b6f353-9c0e-46cb-82bc-2ec32acea401', 'deposit', 0.00, '2025-02-02', '09:19:13', 'Fee collected for transfer', 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:19:13', '2025-02-02 09:19:13', 63, 470, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10598, NULL, 'f01befe2-a667-4720-9727-7c631eb8b63c', 'withdrawal', 3703512.00, '2025-02-02', '09:20:11', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:20:11', '2025-02-02 09:20:11', 474, 75, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10599, NULL, 'f01befe2-a667-4720-9727-7c631eb8b63c', 'deposit', 3703512.00, '2025-02-02', '09:20:11', NULL, 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:20:11', '2025-02-02 09:20:11', 75, 474, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10600, NULL, 'f01befe2-a667-4720-9727-7c631eb8b63c', 'deposit', 0.00, '2025-02-02', '09:20:11', 'Fee collected for transfer', 0.00, 1, 'gwastnawa bo qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:20:11', '2025-02-02 09:20:11', 76, 474, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10617, NULL, 'd9749fdf-4242-4d86-97c0-350c6caa7eaa', 'withdrawal', 2010000.00, '2025-02-02', '09:57:30', NULL, 0.00, 1, 'qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:57:30', '2025-02-02 09:57:30', 469, 67, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10618, NULL, 'd9749fdf-4242-4d86-97c0-350c6caa7eaa', 'deposit', 2010000.00, '2025-02-02', '09:57:30', NULL, 0.00, 1, 'qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:57:30', '2025-02-02 09:57:30', 67, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10619, NULL, 'd9749fdf-4242-4d86-97c0-350c6caa7eaa', 'deposit', 0.00, '2025-02-02', '09:57:30', 'Fee collected for transfer', 0.00, 1, 'qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:57:30', '2025-02-02 09:57:30', 68, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10620, NULL, 'c9df822a-5ead-437e-acaf-d11cb7ee11bf', 'withdrawal', 1000000.00, '2025-02-02', '09:58:49', NULL, 0.00, 1, 'qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:58:49', '2025-02-02 09:58:49', 468, 71, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10621, NULL, 'c9df822a-5ead-437e-acaf-d11cb7ee11bf', 'deposit', 1000000.00, '2025-02-02', '09:58:49', NULL, 0.00, 1, 'qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:58:49', '2025-02-02 09:58:49', 71, 468, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10622, NULL, 'c9df822a-5ead-437e-acaf-d11cb7ee11bf', 'deposit', 0.00, '2025-02-02', '09:58:49', 'Fee collected for transfer', 0.00, 1, 'qasa', NULL, NULL, NULL, NULL, '2025-02-02 09:58:49', '2025-02-02 09:58:49', 72, 468, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10655, NULL, '25ee516f-9e0b-4303-99bd-2b3c0514b17f', 'deposit', 15000.00, '2025-02-02', '10:48:41', NULL, 0.00, 136, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-02 10:48:41', '2025-02-02 10:48:41', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10656, NULL, '25ee516f-9e0b-4303-99bd-2b3c0514b17f', 'deposit', 15000.00, '2025-02-02', '10:48:41', NULL, 0.00, 136, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-02 10:48:41', '2025-02-02 10:48:41', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10699, NULL, '97442a57-c51c-47ea-b1fb-da242577e51d', 'deposit', 6000.00, '2025-02-02', '11:53:17', NULL, 0.00, 136, 'mahmud yunis ', NULL, NULL, NULL, NULL, '2025-02-02 11:53:17', '2025-02-02 11:53:17', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10700, NULL, '97442a57-c51c-47ea-b1fb-da242577e51d', 'deposit', 6000.00, '2025-02-02', '11:53:17', NULL, 0.00, 136, 'mahmud yunis ', NULL, NULL, NULL, NULL, '2025-02-02 11:53:17', '2025-02-02 11:53:17', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10771, NULL, '00bfbdaf-3701-42f5-8a88-5e3ffd6003bd', 'withdrawal', 25000000.00, '2025-02-02', '14:01:24', NULL, 0.00, 1, 'ida3', NULL, NULL, NULL, NULL, '2025-02-02 14:01:24', '2025-02-02 14:01:24', 470, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10772, NULL, '00bfbdaf-3701-42f5-8a88-5e3ffd6003bd', 'deposit', 25000000.00, '2025-02-02', '14:01:24', NULL, 0.00, 1, 'ida3', NULL, NULL, NULL, NULL, '2025-02-02 14:01:24', '2025-02-02 14:01:24', 18, 470, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10773, NULL, '00bfbdaf-3701-42f5-8a88-5e3ffd6003bd', 'deposit', 0.00, '2025-02-02', '14:01:24', 'Fee collected for transfer', 0.00, 1, 'ida3', NULL, NULL, NULL, NULL, '2025-02-02 14:01:24', '2025-02-02 14:01:24', 63, 470, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10790, NULL, '725b3eb2-4053-44dd-af85-420e974f55ce', 'withdrawal', 25000000.00, '2025-02-02', '14:35:37', NULL, 0.00, 1, 'ida3 dijla', NULL, NULL, NULL, NULL, '2025-02-02 14:35:37', '2025-02-02 14:35:37', 470, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10791, NULL, '725b3eb2-4053-44dd-af85-420e974f55ce', 'deposit', 25000000.00, '2025-02-02', '14:35:37', NULL, 0.00, 1, 'ida3 dijla', NULL, NULL, NULL, NULL, '2025-02-02 14:35:37', '2025-02-02 14:35:37', 18, 470, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10792, NULL, '725b3eb2-4053-44dd-af85-420e974f55ce', 'deposit', 0.00, '2025-02-02', '14:35:37', 'Fee collected for transfer', 0.00, 1, 'ida3 dijla', NULL, NULL, NULL, NULL, '2025-02-02 14:35:37', '2025-02-02 14:35:37', 63, 470, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10793, NULL, '7ede692f-43e6-4c06-9e7e-5b558f3731c6', 'deposit', 1496.00, '2025-02-02', '14:37:17', NULL, 0.00, 136, 'Aram ', NULL, NULL, NULL, NULL, '2025-02-02 14:37:17', '2025-02-02 14:37:17', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10794, NULL, '7ede692f-43e6-4c06-9e7e-5b558f3731c6', 'deposit', 1496.00, '2025-02-02', '14:37:17', NULL, 0.00, 136, 'Aram ', NULL, NULL, NULL, NULL, '2025-02-02 14:37:17', '2025-02-02 14:37:17', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10861, NULL, '13c3e1c2-dd30-4588-8e5d-e86f4dbd1693', 'withdrawal', 1000000.00, '2025-02-02', '15:46:38', NULL, 0.00, 144, 'ida3', NULL, NULL, NULL, NULL, '2025-02-02 15:46:38', '2025-02-02 15:46:38', 467, 73, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10862, NULL, '13c3e1c2-dd30-4588-8e5d-e86f4dbd1693', 'deposit', 1000000.00, '2025-02-02', '15:46:38', NULL, 0.00, 144, 'ida3', NULL, NULL, NULL, NULL, '2025-02-02 15:46:38', '2025-02-02 15:46:38', 73, 467, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(10863, NULL, '13c3e1c2-dd30-4588-8e5d-e86f4dbd1693', 'deposit', 0.00, '2025-02-02', '15:46:38', 'Fee collected for transfer', 0.00, 144, 'ida3', NULL, NULL, NULL, NULL, '2025-02-02 15:46:38', '2025-02-02 15:46:38', 74, 467, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11036, NULL, 'b5006be0-3bfd-41c2-9b69-da7735645ecc', 'deposit', 11458.00, '2025-02-02', '17:44:19', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:44:19', '2025-02-02 17:44:19', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11037, NULL, 'b5006be0-3bfd-41c2-9b69-da7735645ecc', 'deposit', 11458.00, '2025-02-02', '17:44:19', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:44:19', '2025-02-02 17:44:19', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11038, NULL, 'b5006be0-3bfd-41c2-9b69-da7735645ecc', 'deposit', 0.00, '2025-02-02', '17:44:19', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:44:19', '2025-02-02 17:44:19', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11041, NULL, 'abefb4da-ee49-40ea-88aa-ffde19040979', 'deposit', 955.00, '2025-02-02', '17:46:04', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:46:04', '2025-02-02 17:46:04', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11042, NULL, 'abefb4da-ee49-40ea-88aa-ffde19040979', 'deposit', 955.00, '2025-02-02', '17:46:04', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:46:04', '2025-02-02 17:46:04', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11043, NULL, 'abefb4da-ee49-40ea-88aa-ffde19040979', 'deposit', 0.00, '2025-02-02', '17:46:04', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:46:04', '2025-02-02 17:46:04', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11044, NULL, '297ddbdb-7b14-4388-bb88-d222e2f6a122', 'deposit', 713250.00, '2025-02-02', '17:46:31', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:46:31', '2025-02-02 17:46:31', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11045, NULL, '297ddbdb-7b14-4388-bb88-d222e2f6a122', 'deposit', 713250.00, '2025-02-02', '17:46:31', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:46:31', '2025-02-02 17:46:31', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11046, NULL, '297ddbdb-7b14-4388-bb88-d222e2f6a122', 'deposit', 0.00, '2025-02-02', '17:46:31', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:46:31', '2025-02-02 17:46:31', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11053, NULL, 'c880bc47-cc5e-4754-b1a7-7e29ecf777be', 'deposit', 1086.00, '2025-02-02', '17:51:09', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:51:09', '2025-02-02 17:51:09', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11054, NULL, 'c880bc47-cc5e-4754-b1a7-7e29ecf777be', 'deposit', 1086.00, '2025-02-02', '17:51:09', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:51:09', '2025-02-02 17:51:09', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11055, NULL, 'c880bc47-cc5e-4754-b1a7-7e29ecf777be', 'deposit', 0.00, '2025-02-02', '17:51:09', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:51:09', '2025-02-02 17:51:09', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11060, NULL, 'efd4fb94-ddae-4ee2-97bd-85497764a2f2', 'withdrawal', 10.00, '2025-02-02', '17:52:11', NULL, 0.00, 1, 'asiacell', NULL, NULL, NULL, NULL, '2025-02-02 17:52:11', '2025-02-02 17:52:11', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11061, NULL, 'efd4fb94-ddae-4ee2-97bd-85497764a2f2', 'withdrawal', 10.00, '2025-02-02', '17:52:11', NULL, 0.00, 1, 'asiacell', NULL, NULL, NULL, NULL, '2025-02-02 17:52:11', '2025-02-02 17:52:11', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11062, NULL, 'efd4fb94-ddae-4ee2-97bd-85497764a2f2', 'deposit', 0.00, '2025-02-02', '17:52:11', 'Fee collected for withdrawal', 0.00, 1, 'asiacell', NULL, NULL, NULL, NULL, '2025-02-02 17:52:11', '2025-02-02 17:52:11', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11067, NULL, 'cd872e67-3ed7-4fee-b9e8-76de0a2d448e', 'deposit', 869.00, '2025-02-02', '17:53:58', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:53:58', '2025-02-02 17:53:58', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11068, NULL, 'cd872e67-3ed7-4fee-b9e8-76de0a2d448e', 'deposit', 869.00, '2025-02-02', '17:53:58', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:53:58', '2025-02-02 17:53:58', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11069, NULL, 'cd872e67-3ed7-4fee-b9e8-76de0a2d448e', 'deposit', 0.00, '2025-02-02', '17:53:58', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:53:58', '2025-02-02 17:53:58', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11080, NULL, 'bcc55aca-0302-48ac-8ecc-e06765bf86a2', 'withdrawal', 305000.00, '2025-02-02', '17:55:43', NULL, 5000.00, 1, 'samarra-shada badr', NULL, NULL, NULL, NULL, '2025-02-02 17:55:43', '2025-02-02 17:55:43', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11081, NULL, 'bcc55aca-0302-48ac-8ecc-e06765bf86a2', 'withdrawal', 305000.00, '2025-02-02', '17:55:43', NULL, 5000.00, 1, 'samarra-shada badr', NULL, NULL, NULL, NULL, '2025-02-02 17:55:43', '2025-02-02 17:55:43', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11082, NULL, 'bcc55aca-0302-48ac-8ecc-e06765bf86a2', 'deposit', 5000.00, '2025-02-02', '17:55:43', 'Fee collected for withdrawal', 0.00, 1, 'samarra-shada badr', NULL, NULL, NULL, NULL, '2025-02-02 17:55:43', '2025-02-02 17:55:43', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11083, NULL, '87e6597e-67c9-44ed-93a3-29137447b8a1', 'withdrawal', 291000.00, '2025-02-02', '17:56:32', NULL, 1000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-02 17:56:32', '2025-02-02 17:56:32', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11084, NULL, '87e6597e-67c9-44ed-93a3-29137447b8a1', 'withdrawal', 291000.00, '2025-02-02', '17:56:32', NULL, 1000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-02 17:56:32', '2025-02-02 17:56:32', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11085, NULL, '87e6597e-67c9-44ed-93a3-29137447b8a1', 'deposit', 1000.00, '2025-02-02', '17:56:32', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-02 17:56:32', '2025-02-02 17:56:32', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11086, NULL, '353a7921-7e3f-4cf2-9cfc-39b8a672de7e', 'deposit', 1826.00, '2025-02-02', '17:57:56', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:57:56', '2025-02-02 17:57:56', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11087, NULL, '353a7921-7e3f-4cf2-9cfc-39b8a672de7e', 'deposit', 1826.00, '2025-02-02', '17:57:56', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:57:56', '2025-02-02 17:57:56', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11088, NULL, '353a7921-7e3f-4cf2-9cfc-39b8a672de7e', 'deposit', 0.00, '2025-02-02', '17:57:56', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:57:56', '2025-02-02 17:57:56', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11089, NULL, '4230749d-278c-46d9-9a09-1dd096cc486f', 'deposit', 98.00, '2025-02-02', '17:58:19', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 17:58:19', '2025-02-02 17:58:19', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11090, NULL, '4230749d-278c-46d9-9a09-1dd096cc486f', 'deposit', 98.00, '2025-02-02', '17:58:19', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 17:58:19', '2025-02-02 17:58:19', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11091, NULL, '4230749d-278c-46d9-9a09-1dd096cc486f', 'deposit', 0.00, '2025-02-02', '17:58:19', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 17:58:19', '2025-02-02 17:58:19', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11094, NULL, '0129cf25-ddcf-4821-b74b-06f0faf408f5', 'withdrawal', 727.00, '2025-02-02', '17:59:59', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:59:59', '2025-02-02 17:59:59', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11095, NULL, '0129cf25-ddcf-4821-b74b-06f0faf408f5', 'withdrawal', 727.00, '2025-02-02', '17:59:59', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:59:59', '2025-02-02 17:59:59', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11096, NULL, '0129cf25-ddcf-4821-b74b-06f0faf408f5', 'deposit', 0.00, '2025-02-02', '17:59:59', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 17:59:59', '2025-02-02 17:59:59', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11097, NULL, '27ec144e-be8c-4b35-95fe-1d9748c32ebf', 'withdrawal', 1205.00, '2025-02-02', '18:00:33', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 18:00:33', '2025-02-02 18:00:33', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11098, NULL, '27ec144e-be8c-4b35-95fe-1d9748c32ebf', 'withdrawal', 1205.00, '2025-02-02', '18:00:33', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 18:00:33', '2025-02-02 18:00:33', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11099, NULL, '27ec144e-be8c-4b35-95fe-1d9748c32ebf', 'deposit', 0.00, '2025-02-02', '18:00:33', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 18:00:33', '2025-02-02 18:00:33', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11102, NULL, '47dd09b8-a3cb-425a-98a1-46bce6ad835d', 'withdrawal', 1496.00, '2025-02-02', '18:02:48', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:02:48', '2025-02-02 18:02:48', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11103, NULL, '47dd09b8-a3cb-425a-98a1-46bce6ad835d', 'withdrawal', 1496.00, '2025-02-02', '18:02:48', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:02:48', '2025-02-02 18:02:48', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11104, NULL, '47dd09b8-a3cb-425a-98a1-46bce6ad835d', 'deposit', 0.00, '2025-02-02', '18:02:48', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:02:48', '2025-02-02 18:02:48', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11105, NULL, '91fb2841-5dc8-48db-9083-24027a96f258', 'withdrawal', 3021000.00, '2025-02-02', '18:03:13', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:03:13', '2025-02-02 18:03:13', 179, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11106, NULL, '91fb2841-5dc8-48db-9083-24027a96f258', 'withdrawal', 3021000.00, '2025-02-02', '18:03:13', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:03:13', '2025-02-02 18:03:13', 2, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11107, NULL, '91fb2841-5dc8-48db-9083-24027a96f258', 'deposit', 0.00, '2025-02-02', '18:03:13', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:03:13', '2025-02-02 18:03:13', 23, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11108, NULL, 'a3d740a9-e947-4c2a-bebd-5615e0ecb311', 'deposit', 4893.00, '2025-02-02', '18:04:19', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:04:19', '2025-02-02 18:04:19', 214, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11109, NULL, 'a3d740a9-e947-4c2a-bebd-5615e0ecb311', 'deposit', 4893.00, '2025-02-02', '18:04:19', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:04:19', '2025-02-02 18:04:19', 1, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11110, NULL, 'a3d740a9-e947-4c2a-bebd-5615e0ecb311', 'deposit', 0.00, '2025-02-02', '18:04:19', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:04:19', '2025-02-02 18:04:19', 22, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11111, NULL, '006bde30-f732-4a0f-bda8-eb23315ea553', 'withdrawal', 33.00, '2025-02-02', '18:05:26', NULL, 0.00, 1, 'KOREK INTERNET', NULL, NULL, NULL, NULL, '2025-02-02 18:05:26', '2025-02-02 18:05:26', 214, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11112, NULL, '006bde30-f732-4a0f-bda8-eb23315ea553', 'withdrawal', 33.00, '2025-02-02', '18:05:26', NULL, 0.00, 1, 'KOREK INTERNET', NULL, NULL, NULL, NULL, '2025-02-02 18:05:26', '2025-02-02 18:05:26', 1, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11113, NULL, '006bde30-f732-4a0f-bda8-eb23315ea553', 'deposit', 0.00, '2025-02-02', '18:05:26', 'Fee collected for withdrawal', 0.00, 1, 'KOREK INTERNET', NULL, NULL, NULL, NULL, '2025-02-02 18:05:26', '2025-02-02 18:05:26', 22, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11114, NULL, 'e9d73fcd-2e79-477c-8896-80969942f19c', 'deposit', 715000.00, '2025-02-02', '18:06:31', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:06:31', '2025-02-02 18:06:31', 78, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11115, NULL, 'e9d73fcd-2e79-477c-8896-80969942f19c', 'deposit', 715000.00, '2025-02-02', '18:06:31', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:06:31', '2025-02-02 18:06:31', 2, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11116, NULL, 'e9d73fcd-2e79-477c-8896-80969942f19c', 'deposit', 0.00, '2025-02-02', '18:06:31', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 18:06:31', '2025-02-02 18:06:31', 23, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11172, NULL, '5e57cbcb-5ffd-46ab-8438-f31044b21bd3', 'deposit', 301500.00, '2025-02-02', '18:53:44', 'SHADA BADR HASAN', 1500.00, 1, 'AMARA', NULL, NULL, NULL, NULL, '2025-02-02 18:53:44', '2025-02-02 18:53:44', 78, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11173, NULL, '5e57cbcb-5ffd-46ab-8438-f31044b21bd3', 'deposit', 301500.00, '2025-02-02', '18:53:44', 'SHADA BADR HASAN', 1500.00, 1, 'AMARA', NULL, NULL, NULL, NULL, '2025-02-02 18:53:44', '2025-02-02 18:53:44', 2, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11174, NULL, '5e57cbcb-5ffd-46ab-8438-f31044b21bd3', 'deposit', 1500.00, '2025-02-02', '18:53:44', 'Fee collected for deposit', 0.00, 1, 'AMARA', NULL, NULL, NULL, NULL, '2025-02-02 18:53:44', '2025-02-02 18:53:44', 23, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11175, NULL, '8beaddfd-7bbe-413a-9025-fa9ce48b425c', 'deposit', 35035000.00, '2025-02-02', '18:54:16', NULL, 35000.00, 1, 'OMER SHWAF', NULL, NULL, NULL, NULL, '2025-02-02 18:54:16', '2025-02-02 18:54:16', 78, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(11176, NULL, '8beaddfd-7bbe-413a-9025-fa9ce48b425c', 'deposit', 35035000.00, '2025-02-02', '18:54:16', NULL, 35000.00, 1, 'OMER SHWAF', NULL, NULL, NULL, NULL, '2025-02-02 18:54:16', '2025-02-02 18:54:16', 2, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11177, NULL, '8beaddfd-7bbe-413a-9025-fa9ce48b425c', 'deposit', 35000.00, '2025-02-02', '18:54:16', 'Fee collected for deposit', 0.00, 1, 'OMER SHWAF', NULL, NULL, NULL, NULL, '2025-02-02 18:54:16', '2025-02-02 18:54:16', 23, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11192, NULL, 'b5558758-aa9a-41a5-9f3b-73fcc55f16da', 'withdrawal', 35000000.00, '2025-02-02', '18:57:19', NULL, 0.00, 1, 'muhamad ibrahem', NULL, NULL, NULL, NULL, '2025-02-02 18:57:19', '2025-02-02 18:57:19', 78, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11193, NULL, 'b5558758-aa9a-41a5-9f3b-73fcc55f16da', 'withdrawal', 35000000.00, '2025-02-02', '18:57:19', NULL, 0.00, 1, 'muhamad ibrahem', NULL, NULL, NULL, NULL, '2025-02-02 18:57:19', '2025-02-02 18:57:19', 2, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11194, NULL, 'b5558758-aa9a-41a5-9f3b-73fcc55f16da', 'deposit', 0.00, '2025-02-02', '18:57:19', 'Fee collected for withdrawal', 0.00, 1, 'muhamad ibrahem', NULL, NULL, NULL, NULL, '2025-02-02 18:57:19', '2025-02-02 18:57:19', 23, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11199, NULL, '25e55502-8ccc-4867-9f7f-71f8dae70bf7', 'deposit', 16962500.00, '2025-02-02', '19:00:50', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:00:50', '2025-02-02 19:00:50', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11200, NULL, '25e55502-8ccc-4867-9f7f-71f8dae70bf7', 'deposit', 16962500.00, '2025-02-02', '19:00:50', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:00:50', '2025-02-02 19:00:50', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11201, NULL, '25e55502-8ccc-4867-9f7f-71f8dae70bf7', 'deposit', 0.00, '2025-02-02', '19:00:50', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:00:50', '2025-02-02 19:00:50', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11202, NULL, '951be4b2-8811-4e87-8ecd-2ab0bc577ee8', 'withdrawal', 35000.00, '2025-02-02', '19:01:19', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:01:19', '2025-02-02 19:01:19', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11203, NULL, '951be4b2-8811-4e87-8ecd-2ab0bc577ee8', 'withdrawal', 35000.00, '2025-02-02', '19:01:19', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:01:19', '2025-02-02 19:01:19', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11204, NULL, '951be4b2-8811-4e87-8ecd-2ab0bc577ee8', 'deposit', 0.00, '2025-02-02', '19:01:19', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:01:19', '2025-02-02 19:01:19', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11209, NULL, '9bc6f3fd-1187-40fd-97ea-51e8d3c18614', 'withdrawal', 1001500.00, '2025-02-02', '19:02:15', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:02:15', '2025-02-02 19:02:15', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11210, NULL, '9bc6f3fd-1187-40fd-97ea-51e8d3c18614', 'withdrawal', 1001500.00, '2025-02-02', '19:02:15', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:02:15', '2025-02-02 19:02:15', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11211, NULL, '9bc6f3fd-1187-40fd-97ea-51e8d3c18614', 'deposit', 1500.00, '2025-02-02', '19:02:15', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:02:15', '2025-02-02 19:02:15', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11212, NULL, '5d567584-3514-4248-bc89-afc687c0d877', 'deposit', 25000000.00, '2025-02-02', '19:02:30', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-02 19:02:30', '2025-02-02 19:02:30', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11213, NULL, '5d567584-3514-4248-bc89-afc687c0d877', 'deposit', 25000000.00, '2025-02-02', '19:02:30', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-02 19:02:30', '2025-02-02 19:02:30', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11214, NULL, '5d567584-3514-4248-bc89-afc687c0d877', 'deposit', 0.00, '2025-02-02', '19:02:30', 'Fee collected for deposit', 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-02 19:02:30', '2025-02-02 19:02:30', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11219, NULL, 'a8d69893-ffd6-4c15-af7c-a5760fd04295', 'withdrawal', 3625500.00, '2025-02-02', '19:03:48', NULL, 5500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:03:48', '2025-02-02 19:03:48', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11220, NULL, 'a8d69893-ffd6-4c15-af7c-a5760fd04295', 'withdrawal', 3625500.00, '2025-02-02', '19:03:48', NULL, 5500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:03:48', '2025-02-02 19:03:48', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11221, NULL, 'a8d69893-ffd6-4c15-af7c-a5760fd04295', 'deposit', 5500.00, '2025-02-02', '19:03:48', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:03:48', '2025-02-02 19:03:48', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11230, NULL, '1960863c-7c23-48a7-bc35-fbd32d404381', 'withdrawal', 1353750.00, '2025-02-02', '19:04:38', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:04:38', '2025-02-02 19:04:38', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11231, NULL, '1960863c-7c23-48a7-bc35-fbd32d404381', 'withdrawal', 1353750.00, '2025-02-02', '19:04:38', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:04:38', '2025-02-02 19:04:38', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11232, NULL, '1960863c-7c23-48a7-bc35-fbd32d404381', 'deposit', 2000.00, '2025-02-02', '19:04:38', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:04:38', '2025-02-02 19:04:38', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11233, NULL, '9d5b2678-73ec-44df-be93-2b37724d0fcd', 'withdrawal', 1353750.00, '2025-02-02', '19:05:06', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:05:06', '2025-02-02 19:05:06', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11234, NULL, '9d5b2678-73ec-44df-be93-2b37724d0fcd', 'withdrawal', 1353750.00, '2025-02-02', '19:05:06', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:05:06', '2025-02-02 19:05:06', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11235, NULL, '9d5b2678-73ec-44df-be93-2b37724d0fcd', 'deposit', 2000.00, '2025-02-02', '19:05:06', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:05:06', '2025-02-02 19:05:06', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11296, NULL, 'a99ab607-cfb5-4e0c-8170-0e9a1b7e63cd', 'deposit', 4637.00, '2025-02-02', '19:35:00', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:35:00', '2025-02-02 19:35:00', 200, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11297, NULL, 'a99ab607-cfb5-4e0c-8170-0e9a1b7e63cd', 'deposit', 4637.00, '2025-02-02', '19:35:00', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:35:00', '2025-02-02 19:35:00', 1, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11298, NULL, 'a99ab607-cfb5-4e0c-8170-0e9a1b7e63cd', 'deposit', 0.00, '2025-02-02', '19:35:00', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:35:00', '2025-02-02 19:35:00', 22, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11299, NULL, '5b0cfee2-e8f0-478f-a5a7-cfb0c6e8831a', 'deposit', 33452500.00, '2025-02-02', '19:35:01', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:35:01', '2025-02-02 19:35:01', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11300, NULL, '5b0cfee2-e8f0-478f-a5a7-cfb0c6e8831a', 'deposit', 33452500.00, '2025-02-02', '19:35:01', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:35:01', '2025-02-02 19:35:01', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11301, NULL, '5b0cfee2-e8f0-478f-a5a7-cfb0c6e8831a', 'deposit', 0.00, '2025-02-02', '19:35:01', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:35:01', '2025-02-02 19:35:01', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11302, NULL, '51495850-0c81-4753-ac88-b41125f2cd33', 'deposit', 3550.00, '2025-02-02', '19:35:40', NULL, 0.00, 1, 'K AHMED', NULL, NULL, NULL, NULL, '2025-02-02 19:35:40', '2025-02-02 19:35:40', 200, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11303, NULL, '51495850-0c81-4753-ac88-b41125f2cd33', 'deposit', 3550.00, '2025-02-02', '19:35:40', NULL, 0.00, 1, 'K AHMED', NULL, NULL, NULL, NULL, '2025-02-02 19:35:40', '2025-02-02 19:35:40', 1, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11304, NULL, '51495850-0c81-4753-ac88-b41125f2cd33', 'deposit', 0.00, '2025-02-02', '19:35:40', 'Fee collected for deposit', 0.00, 1, 'K AHMED', NULL, NULL, NULL, NULL, '2025-02-02 19:35:40', '2025-02-02 19:35:40', 22, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11305, NULL, 'e1f312a3-d732-45e6-97dc-2a324537b226', 'deposit', 17000000.00, '2025-02-02', '19:36:16', NULL, 0.00, 1, 'K AHMED', NULL, NULL, NULL, NULL, '2025-02-02 19:36:16', '2025-02-02 19:36:16', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11306, NULL, 'e1f312a3-d732-45e6-97dc-2a324537b226', 'deposit', 17000000.00, '2025-02-02', '19:36:16', NULL, 0.00, 1, 'K AHMED', NULL, NULL, NULL, NULL, '2025-02-02 19:36:16', '2025-02-02 19:36:16', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11307, NULL, 'e1f312a3-d732-45e6-97dc-2a324537b226', 'deposit', 0.00, '2025-02-02', '19:36:16', 'Fee collected for deposit', 0.00, 1, 'K AHMED', NULL, NULL, NULL, NULL, '2025-02-02 19:36:16', '2025-02-02 19:36:16', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11316, NULL, '309aab30-d531-4f18-9175-68ee87ebb74e', 'withdrawal', 1560.00, '2025-02-02', '19:38:12', '2400000-153750', 0.00, 1, 'HAZARE', NULL, NULL, NULL, NULL, '2025-02-02 19:38:12', '2025-02-02 19:38:12', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11317, NULL, '309aab30-d531-4f18-9175-68ee87ebb74e', 'withdrawal', 1560.00, '2025-02-02', '19:38:12', '2400000-153750', 0.00, 1, 'HAZARE', NULL, NULL, NULL, NULL, '2025-02-02 19:38:12', '2025-02-02 19:38:12', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11318, NULL, '309aab30-d531-4f18-9175-68ee87ebb74e', 'deposit', 0.00, '2025-02-02', '19:38:12', 'Fee collected for withdrawal', 0.00, 1, 'HAZARE', NULL, NULL, NULL, NULL, '2025-02-02 19:38:12', '2025-02-02 19:38:12', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11325, NULL, '5a93e791-b426-44fb-b817-2b18c447bff0', 'withdrawal', 2574000.00, '2025-02-02', '19:41:13', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:41:13', '2025-02-02 19:41:13', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11326, NULL, '5a93e791-b426-44fb-b817-2b18c447bff0', 'withdrawal', 2574000.00, '2025-02-02', '19:41:13', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:41:13', '2025-02-02 19:41:13', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11327, NULL, '5a93e791-b426-44fb-b817-2b18c447bff0', 'deposit', 4000.00, '2025-02-02', '19:41:13', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 19:41:13', '2025-02-02 19:41:13', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11330, NULL, '9ff3ed75-fa57-45db-8ebb-4c54606d2944', 'withdrawal', 877625.00, '2025-02-02', '19:43:05', NULL, 2625.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:43:05', '2025-02-02 19:43:05', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11331, NULL, '9ff3ed75-fa57-45db-8ebb-4c54606d2944', 'withdrawal', 877625.00, '2025-02-02', '19:43:05', NULL, 2625.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:43:05', '2025-02-02 19:43:05', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11332, NULL, '9ff3ed75-fa57-45db-8ebb-4c54606d2944', 'deposit', 2625.00, '2025-02-02', '19:43:05', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:43:05', '2025-02-02 19:43:05', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11337, NULL, 'b4181647-0f88-460b-88ef-fc2d173f6fc3', 'withdrawal', 151000.00, '2025-02-02', '19:44:27', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:44:27', '2025-02-02 19:44:27', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11338, NULL, 'b4181647-0f88-460b-88ef-fc2d173f6fc3', 'withdrawal', 151000.00, '2025-02-02', '19:44:27', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:44:27', '2025-02-02 19:44:27', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11339, NULL, 'b4181647-0f88-460b-88ef-fc2d173f6fc3', 'deposit', 1000.00, '2025-02-02', '19:44:27', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:44:27', '2025-02-02 19:44:27', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11340, NULL, '85b36539-04b9-47cd-a047-6ba94692e1bc', 'deposit', 625.00, '2025-02-02', '19:44:48', NULL, 0.00, 1, 'HMULA', NULL, NULL, NULL, NULL, '2025-02-02 19:44:48', '2025-02-02 19:44:48', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11341, NULL, '85b36539-04b9-47cd-a047-6ba94692e1bc', 'deposit', 625.00, '2025-02-02', '19:44:48', NULL, 0.00, 1, 'HMULA', NULL, NULL, NULL, NULL, '2025-02-02 19:44:48', '2025-02-02 19:44:48', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11342, NULL, '85b36539-04b9-47cd-a047-6ba94692e1bc', 'deposit', 0.00, '2025-02-02', '19:44:48', 'Fee collected for deposit', 0.00, 1, 'HMULA', NULL, NULL, NULL, NULL, '2025-02-02 19:44:48', '2025-02-02 19:44:48', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11351, NULL, '6b764f40-a4fb-4605-8079-61392ad1ed44', 'deposit', 1189.00, '2025-02-02', '19:48:26', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 19:48:26', '2025-02-02 19:48:26', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11352, NULL, '6b764f40-a4fb-4605-8079-61392ad1ed44', 'deposit', 1189.00, '2025-02-02', '19:48:26', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 19:48:26', '2025-02-02 19:48:26', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11353, NULL, '6b764f40-a4fb-4605-8079-61392ad1ed44', 'deposit', 0.00, '2025-02-02', '19:48:26', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-02 19:48:26', '2025-02-02 19:48:26', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11354, NULL, '0f58163f-7873-426c-872d-ff7eb49b14f3', 'withdrawal', 7912000.00, '2025-02-02', '19:49:45', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:49:45', '2025-02-02 19:49:45', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11355, NULL, '0f58163f-7873-426c-872d-ff7eb49b14f3', 'withdrawal', 7912000.00, '2025-02-02', '19:49:45', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:49:45', '2025-02-02 19:49:45', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11356, NULL, '0f58163f-7873-426c-872d-ff7eb49b14f3', 'deposit', 0.00, '2025-02-02', '19:49:45', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 19:49:45', '2025-02-02 19:49:45', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11357, NULL, '1449dbf4-1fb1-41a8-ad2c-ad3a70bd32a4', 'deposit', 401500.00, '2025-02-02', '19:51:12', NULL, 1500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:51:12', '2025-02-02 19:51:12', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11358, NULL, '1449dbf4-1fb1-41a8-ad2c-ad3a70bd32a4', 'deposit', 401500.00, '2025-02-02', '19:51:12', NULL, 1500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:51:12', '2025-02-02 19:51:12', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11359, NULL, '1449dbf4-1fb1-41a8-ad2c-ad3a70bd32a4', 'deposit', 1500.00, '2025-02-02', '19:51:12', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:51:12', '2025-02-02 19:51:12', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11360, NULL, 'd687d818-cf38-4df3-8416-b2780b4acb77', 'deposit', 150500.00, '2025-02-02', '19:51:41', NULL, 500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:51:41', '2025-02-02 19:51:41', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11361, NULL, 'd687d818-cf38-4df3-8416-b2780b4acb77', 'deposit', 150500.00, '2025-02-02', '19:51:41', NULL, 500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:51:41', '2025-02-02 19:51:41', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11362, NULL, 'd687d818-cf38-4df3-8416-b2780b4acb77', 'deposit', 500.00, '2025-02-02', '19:51:41', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:51:41', '2025-02-02 19:51:41', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11363, NULL, '89f5bae0-9f0b-4ade-bb81-857e7f33568f', 'deposit', 150500.00, '2025-02-02', '19:52:01', NULL, 500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:52:01', '2025-02-02 19:52:01', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11364, NULL, '89f5bae0-9f0b-4ade-bb81-857e7f33568f', 'deposit', 150500.00, '2025-02-02', '19:52:01', NULL, 500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:52:01', '2025-02-02 19:52:01', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11365, NULL, '89f5bae0-9f0b-4ade-bb81-857e7f33568f', 'deposit', 500.00, '2025-02-02', '19:52:01', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 19:52:01', '2025-02-02 19:52:01', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11372, NULL, '52033837-d9b4-46bc-9d08-c3bef2a21816', 'deposit', 8000.00, '2025-02-02', '19:58:20', NULL, 0.00, 132, 'Muhamad slah hamad ', NULL, NULL, NULL, NULL, '2025-02-02 19:58:20', '2025-02-02 19:58:20', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11373, NULL, '52033837-d9b4-46bc-9d08-c3bef2a21816', 'deposit', 8000.00, '2025-02-02', '19:58:20', NULL, 0.00, 132, 'Muhamad slah hamad ', NULL, NULL, NULL, NULL, '2025-02-02 19:58:20', '2025-02-02 19:58:20', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11390, NULL, 'dc50c592-0ff6-4a57-b86e-940d886a02a1', 'deposit', 5218804.00, '2025-02-02', '20:12:26', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:12:26', '2025-02-02 20:12:26', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11391, NULL, 'dc50c592-0ff6-4a57-b86e-940d886a02a1', 'deposit', 5218804.00, '2025-02-02', '20:12:26', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:12:26', '2025-02-02 20:12:26', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11392, NULL, 'dc50c592-0ff6-4a57-b86e-940d886a02a1', 'deposit', 0.00, '2025-02-02', '20:12:26', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:12:26', '2025-02-02 20:12:26', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11393, NULL, '04293c2b-1e4a-4f81-a713-702e8ce3e412', 'deposit', 36075.00, '2025-02-02', '20:12:27', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:12:27', '2025-02-02 20:12:27', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11394, NULL, '04293c2b-1e4a-4f81-a713-702e8ce3e412', 'deposit', 36075.00, '2025-02-02', '20:12:27', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:12:27', '2025-02-02 20:12:27', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11395, NULL, '04293c2b-1e4a-4f81-a713-702e8ce3e412', 'deposit', 0.00, '2025-02-02', '20:12:27', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:12:27', '2025-02-02 20:12:27', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11398, NULL, 'aa19faff-6d6d-4d77-a068-508881ce7a28', 'withdrawal', 40000.00, '2025-02-02', '20:13:01', NULL, 0.00, 1, 'MUHAMAD SALM', NULL, NULL, NULL, NULL, '2025-02-02 20:13:01', '2025-02-02 20:13:01', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11399, NULL, 'aa19faff-6d6d-4d77-a068-508881ce7a28', 'withdrawal', 40000.00, '2025-02-02', '20:13:01', NULL, 0.00, 1, 'MUHAMAD SALM', NULL, NULL, NULL, NULL, '2025-02-02 20:13:01', '2025-02-02 20:13:01', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11400, NULL, 'aa19faff-6d6d-4d77-a068-508881ce7a28', 'deposit', 0.00, '2025-02-02', '20:13:01', 'Fee collected for withdrawal', 0.00, 1, 'MUHAMAD SALM', NULL, NULL, NULL, NULL, '2025-02-02 20:13:01', '2025-02-02 20:13:01', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11401, NULL, '8d05a85d-8999-49ee-b2db-533d344398bc', 'withdrawal', 226000.00, '2025-02-02', '20:13:55', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:13:55', '2025-02-02 20:13:55', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11402, NULL, '8d05a85d-8999-49ee-b2db-533d344398bc', 'withdrawal', 226000.00, '2025-02-02', '20:13:55', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:13:55', '2025-02-02 20:13:55', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11403, NULL, '8d05a85d-8999-49ee-b2db-533d344398bc', 'deposit', 1000.00, '2025-02-02', '20:13:55', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:13:55', '2025-02-02 20:13:55', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11404, NULL, 'd63bfdf2-da33-4f51-9dcb-7630e22bba4e', 'withdrawal', 401250.00, '2025-02-02', '20:15:52', NULL, 1250.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:15:52', '2025-02-02 20:15:52', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11405, NULL, 'd63bfdf2-da33-4f51-9dcb-7630e22bba4e', 'withdrawal', 401250.00, '2025-02-02', '20:15:52', NULL, 1250.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:15:52', '2025-02-02 20:15:52', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11406, NULL, 'd63bfdf2-da33-4f51-9dcb-7630e22bba4e', 'deposit', 1250.00, '2025-02-02', '20:15:52', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:15:52', '2025-02-02 20:15:52', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11407, NULL, '6eebba66-2b08-4a4e-b8ed-2ef9899f1f9e', 'withdrawal', 151000.00, '2025-02-02', '20:16:11', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:16:11', '2025-02-02 20:16:11', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11408, NULL, '6eebba66-2b08-4a4e-b8ed-2ef9899f1f9e', 'withdrawal', 151000.00, '2025-02-02', '20:16:11', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:16:11', '2025-02-02 20:16:11', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11409, NULL, '6eebba66-2b08-4a4e-b8ed-2ef9899f1f9e', 'deposit', 1000.00, '2025-02-02', '20:16:11', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:16:11', '2025-02-02 20:16:11', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11410, NULL, '82b0e819-ef86-47b5-85ce-a3b4e5dfae90', 'withdrawal', 2510000.00, '2025-02-02', '20:16:44', NULL, 0.00, 1, 'M.XAKI BAXTYARI', NULL, NULL, NULL, NULL, '2025-02-02 20:16:44', '2025-02-02 20:16:44', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11411, NULL, '82b0e819-ef86-47b5-85ce-a3b4e5dfae90', 'withdrawal', 2510000.00, '2025-02-02', '20:16:44', NULL, 0.00, 1, 'M.XAKI BAXTYARI', NULL, NULL, NULL, NULL, '2025-02-02 20:16:44', '2025-02-02 20:16:44', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11412, NULL, '82b0e819-ef86-47b5-85ce-a3b4e5dfae90', 'deposit', 0.00, '2025-02-02', '20:16:44', 'Fee collected for withdrawal', 0.00, 1, 'M.XAKI BAXTYARI', NULL, NULL, NULL, NULL, '2025-02-02 20:16:44', '2025-02-02 20:16:44', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11413, NULL, 'b98b457e-88ff-4677-b29f-f47044626057', 'withdrawal', 750.00, '2025-02-02', '20:17:50', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-02 20:17:50', '2025-02-02 20:17:50', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11414, NULL, 'b98b457e-88ff-4677-b29f-f47044626057', 'withdrawal', 750.00, '2025-02-02', '20:17:50', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-02 20:17:50', '2025-02-02 20:17:50', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11415, NULL, 'b98b457e-88ff-4677-b29f-f47044626057', 'deposit', 0.00, '2025-02-02', '20:17:50', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-02 20:17:50', '2025-02-02 20:17:50', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11418, NULL, '63517d2b-e6eb-4972-b778-426ef9f13ab1', 'withdrawal', 3262400.00, '2025-02-02', '20:19:44', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:19:44', '2025-02-02 20:19:44', 212, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11419, NULL, '63517d2b-e6eb-4972-b778-426ef9f13ab1', 'withdrawal', 3262400.00, '2025-02-02', '20:19:44', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:19:44', '2025-02-02 20:19:44', 2, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11420, NULL, '63517d2b-e6eb-4972-b778-426ef9f13ab1', 'deposit', 0.00, '2025-02-02', '20:19:44', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:19:44', '2025-02-02 20:19:44', 23, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11421, NULL, 'cb7d1607-0b46-47e0-9745-0d846dd639d1', 'deposit', 2190000.00, '2025-02-02', '20:20:07', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-02 20:20:07', '2025-02-02 20:20:07', 212, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11422, NULL, 'cb7d1607-0b46-47e0-9745-0d846dd639d1', 'deposit', 2190000.00, '2025-02-02', '20:20:07', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-02 20:20:07', '2025-02-02 20:20:07', 2, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11423, NULL, 'cb7d1607-0b46-47e0-9745-0d846dd639d1', 'deposit', 0.00, '2025-02-02', '20:20:07', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-02 20:20:07', '2025-02-02 20:20:07', 23, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(11434, NULL, '10d62d13-000c-4e24-845a-31cc3abb4278', 'withdrawal', 2510000.00, '2025-02-02', '20:25:13', NULL, 10000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:25:13', '2025-02-02 20:25:13', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11435, NULL, '10d62d13-000c-4e24-845a-31cc3abb4278', 'withdrawal', 2510000.00, '2025-02-02', '20:25:13', NULL, 10000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:25:13', '2025-02-02 20:25:13', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11436, NULL, '10d62d13-000c-4e24-845a-31cc3abb4278', 'deposit', 10000.00, '2025-02-02', '20:25:13', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 20:25:13', '2025-02-02 20:25:13', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11437, NULL, 'b705c348-9428-42a2-9511-9861fb9f3171', 'deposit', 2510000.00, '2025-02-02', '20:25:29', NULL, 0.00, 1, 'M.DIJLA', NULL, NULL, NULL, NULL, '2025-02-02 20:25:29', '2025-02-02 20:25:29', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11438, NULL, 'b705c348-9428-42a2-9511-9861fb9f3171', 'deposit', 2510000.00, '2025-02-02', '20:25:29', NULL, 0.00, 1, 'M.DIJLA', NULL, NULL, NULL, NULL, '2025-02-02 20:25:29', '2025-02-02 20:25:29', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11439, NULL, 'b705c348-9428-42a2-9511-9861fb9f3171', 'deposit', 0.00, '2025-02-02', '20:25:29', 'Fee collected for deposit', 0.00, 1, 'M.DIJLA', NULL, NULL, NULL, NULL, '2025-02-02 20:25:29', '2025-02-02 20:25:29', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11448, NULL, 'f39345d3-aa07-4638-99b9-df45956a2b2d', 'deposit', 510.00, '2025-02-02', '20:27:51', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:27:51', '2025-02-02 20:27:51', 251, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11449, NULL, 'f39345d3-aa07-4638-99b9-df45956a2b2d', 'deposit', 510.00, '2025-02-02', '20:27:51', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:27:51', '2025-02-02 20:27:51', 1, 251, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11450, NULL, 'f39345d3-aa07-4638-99b9-df45956a2b2d', 'deposit', 0.00, '2025-02-02', '20:27:51', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:27:51', '2025-02-02 20:27:51', 22, 251, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11451, NULL, 'e8e0372c-5bb3-4acb-85eb-804982e7f9aa', 'withdrawal', 15.00, '2025-02-02', '20:28:23', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:28:23', '2025-02-02 20:28:23', 269, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11452, NULL, 'e8e0372c-5bb3-4acb-85eb-804982e7f9aa', 'withdrawal', 15.00, '2025-02-02', '20:28:23', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:28:23', '2025-02-02 20:28:23', 1, 269, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11453, NULL, 'e8e0372c-5bb3-4acb-85eb-804982e7f9aa', 'deposit', 0.00, '2025-02-02', '20:28:23', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:28:23', '2025-02-02 20:28:23', 22, 269, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11458, NULL, 'f8c575bb-4bdb-4f6a-84ab-a4878f5e135a', 'withdrawal', 325000.00, '2025-02-02', '20:29:15', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:29:15', '2025-02-02 20:29:15', 256, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11459, NULL, 'f8c575bb-4bdb-4f6a-84ab-a4878f5e135a', 'withdrawal', 325000.00, '2025-02-02', '20:29:15', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:29:15', '2025-02-02 20:29:15', 2, 256, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11460, NULL, 'f8c575bb-4bdb-4f6a-84ab-a4878f5e135a', 'deposit', 0.00, '2025-02-02', '20:29:15', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:29:15', '2025-02-02 20:29:15', 23, 256, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11463, NULL, '352cce51-0693-4429-93fb-fd98aa8ca8d9', 'withdrawal', 3975.00, '2025-02-02', '20:30:05', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:30:05', '2025-02-02 20:30:05', 194, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11464, NULL, '352cce51-0693-4429-93fb-fd98aa8ca8d9', 'withdrawal', 3975.00, '2025-02-02', '20:30:05', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:30:05', '2025-02-02 20:30:05', 1, 194, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11465, NULL, '352cce51-0693-4429-93fb-fd98aa8ca8d9', 'deposit', 0.00, '2025-02-02', '20:30:05', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:30:05', '2025-02-02 20:30:05', 22, 194, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11466, NULL, '778d9b2b-ffd9-4025-a8f2-64c2a435dfab', 'deposit', 909750.00, '2025-02-02', '20:30:53', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:30:53', '2025-02-02 20:30:53', 166, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11467, NULL, '778d9b2b-ffd9-4025-a8f2-64c2a435dfab', 'deposit', 909750.00, '2025-02-02', '20:30:53', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:30:53', '2025-02-02 20:30:53', 2, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11468, NULL, '778d9b2b-ffd9-4025-a8f2-64c2a435dfab', 'deposit', 0.00, '2025-02-02', '20:30:53', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:30:53', '2025-02-02 20:30:53', 23, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11469, NULL, 'de1e2127-1331-4144-92eb-9e497d3e68a2', 'withdrawal', 72250.00, '2025-02-02', '20:32:30', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:32:30', '2025-02-02 20:32:30', 222, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11470, NULL, 'de1e2127-1331-4144-92eb-9e497d3e68a2', 'withdrawal', 72250.00, '2025-02-02', '20:32:30', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:32:30', '2025-02-02 20:32:30', 2, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11471, NULL, 'de1e2127-1331-4144-92eb-9e497d3e68a2', 'deposit', 0.00, '2025-02-02', '20:32:30', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:32:30', '2025-02-02 20:32:30', 23, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11476, NULL, '4d4e0539-a72e-4484-a7fb-b778d1f80826', 'deposit', 8847.00, '2025-02-02', '20:33:10', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:33:10', '2025-02-02 20:33:10', 217, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11477, NULL, '4d4e0539-a72e-4484-a7fb-b778d1f80826', 'deposit', 8847.00, '2025-02-02', '20:33:10', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:33:10', '2025-02-02 20:33:10', 1, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11478, NULL, '4d4e0539-a72e-4484-a7fb-b778d1f80826', 'deposit', 0.00, '2025-02-02', '20:33:10', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:33:10', '2025-02-02 20:33:10', 22, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11479, NULL, 'a251e1ca-087c-4a23-813c-5445e05d681b', 'withdrawal', 460500.00, '2025-02-02', '20:33:21', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:33:21', '2025-02-02 20:33:21', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11480, NULL, 'a251e1ca-087c-4a23-813c-5445e05d681b', 'withdrawal', 460500.00, '2025-02-02', '20:33:21', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:33:21', '2025-02-02 20:33:21', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11481, NULL, 'a251e1ca-087c-4a23-813c-5445e05d681b', 'deposit', 0.00, '2025-02-02', '20:33:21', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:33:21', '2025-02-02 20:33:21', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11482, NULL, '2c508675-58f0-45e8-ad56-bfc2c5d2f420', 'withdrawal', 2562500.00, '2025-02-02', '20:34:39', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:34:39', '2025-02-02 20:34:39', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11483, NULL, '2c508675-58f0-45e8-ad56-bfc2c5d2f420', 'withdrawal', 2562500.00, '2025-02-02', '20:34:39', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:34:39', '2025-02-02 20:34:39', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11484, NULL, '2c508675-58f0-45e8-ad56-bfc2c5d2f420', 'deposit', 0.00, '2025-02-02', '20:34:39', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:34:39', '2025-02-02 20:34:39', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11505, NULL, '363f0b88-fdd2-40a1-b265-de618cb54bb7', 'withdrawal', 7.00, '2025-02-02', '20:44:05', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:44:05', '2025-02-02 20:44:05', 291, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11506, NULL, '363f0b88-fdd2-40a1-b265-de618cb54bb7', 'withdrawal', 7.00, '2025-02-02', '20:44:05', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:44:05', '2025-02-02 20:44:05', 1, 291, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11507, NULL, '363f0b88-fdd2-40a1-b265-de618cb54bb7', 'deposit', 0.00, '2025-02-02', '20:44:05', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:44:05', '2025-02-02 20:44:05', 22, 291, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11512, NULL, '4067298c-b027-4e07-b87f-38f025193dab', 'withdrawal', 500.00, '2025-02-02', '20:45:48', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:45:48', '2025-02-02 20:45:48', 191, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11513, NULL, '4067298c-b027-4e07-b87f-38f025193dab', 'withdrawal', 500.00, '2025-02-02', '20:45:48', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:45:48', '2025-02-02 20:45:48', 1, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11514, NULL, '4067298c-b027-4e07-b87f-38f025193dab', 'deposit', 0.00, '2025-02-02', '20:45:48', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:45:48', '2025-02-02 20:45:48', 22, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11515, NULL, 'e41e50dd-9de3-4290-af1b-610b3f756577', 'withdrawal', 202000.00, '2025-02-02', '20:45:50', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:45:50', '2025-02-02 20:45:50', 190, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11516, NULL, 'e41e50dd-9de3-4290-af1b-610b3f756577', 'withdrawal', 202000.00, '2025-02-02', '20:45:50', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:45:50', '2025-02-02 20:45:50', 2, 190, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11517, NULL, 'e41e50dd-9de3-4290-af1b-610b3f756577', 'deposit', 0.00, '2025-02-02', '20:45:50', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:45:50', '2025-02-02 20:45:50', 23, 190, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11518, NULL, '3d65a909-9adf-4998-a850-c827a01c99be', 'deposit', 46574.00, '2025-02-02', '20:48:05', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:48:05', '2025-02-02 20:48:05', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11519, NULL, '3d65a909-9adf-4998-a850-c827a01c99be', 'deposit', 46574.00, '2025-02-02', '20:48:05', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:48:05', '2025-02-02 20:48:05', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11520, NULL, '3d65a909-9adf-4998-a850-c827a01c99be', 'deposit', 0.00, '2025-02-02', '20:48:05', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:48:05', '2025-02-02 20:48:05', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11523, NULL, '43334970-3d26-45dd-b221-49f0edae2a9b', 'withdrawal', 301000.00, '2025-02-02', '20:49:00', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:49:00', '2025-02-02 20:49:00', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11524, NULL, '43334970-3d26-45dd-b221-49f0edae2a9b', 'withdrawal', 301000.00, '2025-02-02', '20:49:00', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:49:00', '2025-02-02 20:49:00', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11525, NULL, '43334970-3d26-45dd-b221-49f0edae2a9b', 'deposit', 0.00, '2025-02-02', '20:49:00', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:49:00', '2025-02-02 20:49:00', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11526, NULL, 'f2cb5ae8-eabd-434d-acca-72127ca73b85', 'deposit', 8387823.00, '2025-02-02', '20:50:27', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:50:27', '2025-02-02 20:50:27', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11527, NULL, 'f2cb5ae8-eabd-434d-acca-72127ca73b85', 'deposit', 8387823.00, '2025-02-02', '20:50:27', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:50:27', '2025-02-02 20:50:27', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11528, NULL, 'f2cb5ae8-eabd-434d-acca-72127ca73b85', 'deposit', 0.00, '2025-02-02', '20:50:27', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:50:27', '2025-02-02 20:50:27', 23, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11531, NULL, '2ee30025-bfb1-4cdd-9045-5f27d439a593', 'deposit', 28.00, '2025-02-02', '20:51:27', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:51:27', '2025-02-02 20:51:27', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11532, NULL, '2ee30025-bfb1-4cdd-9045-5f27d439a593', 'deposit', 28.00, '2025-02-02', '20:51:27', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:51:27', '2025-02-02 20:51:27', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11533, NULL, '2ee30025-bfb1-4cdd-9045-5f27d439a593', 'deposit', 0.00, '2025-02-02', '20:51:27', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:51:27', '2025-02-02 20:51:27', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11534, NULL, '7cbd2eb3-654f-45f6-98b7-e06e4899cef8', 'deposit', 19305000.00, '2025-02-02', '20:53:09', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:53:09', '2025-02-02 20:53:09', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11535, NULL, '7cbd2eb3-654f-45f6-98b7-e06e4899cef8', 'deposit', 19305000.00, '2025-02-02', '20:53:09', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:53:09', '2025-02-02 20:53:09', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11536, NULL, '7cbd2eb3-654f-45f6-98b7-e06e4899cef8', 'deposit', 0.00, '2025-02-02', '20:53:09', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:53:09', '2025-02-02 20:53:09', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11537, NULL, '2c5a89b3-ca51-43b1-94dd-ccc3ec818f52', 'deposit', 5100.00, '2025-02-02', '20:53:11', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:53:11', '2025-02-02 20:53:11', 265, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11538, NULL, '2c5a89b3-ca51-43b1-94dd-ccc3ec818f52', 'deposit', 5100.00, '2025-02-02', '20:53:11', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:53:11', '2025-02-02 20:53:11', 1, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11539, NULL, '2c5a89b3-ca51-43b1-94dd-ccc3ec818f52', 'deposit', 0.00, '2025-02-02', '20:53:11', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:53:11', '2025-02-02 20:53:11', 22, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11542, NULL, '79c193ca-f500-43b7-b545-bf3bbf3345f9', 'deposit', 11000.00, '2025-02-02', '20:54:05', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:54:05', '2025-02-02 20:54:05', 954, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11543, NULL, '79c193ca-f500-43b7-b545-bf3bbf3345f9', 'deposit', 11000.00, '2025-02-02', '20:54:05', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:54:05', '2025-02-02 20:54:05', 1, 954, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11544, NULL, '79c193ca-f500-43b7-b545-bf3bbf3345f9', 'deposit', 0.00, '2025-02-02', '20:54:05', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:54:05', '2025-02-02 20:54:05', 22, 954, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11545, NULL, '6afcfeae-94b8-4b45-9721-c6b923ac1513', 'withdrawal', 40000.00, '2025-02-02', '20:54:31', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:54:31', '2025-02-02 20:54:31', 184, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11546, NULL, '6afcfeae-94b8-4b45-9721-c6b923ac1513', 'withdrawal', 40000.00, '2025-02-02', '20:54:31', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:54:31', '2025-02-02 20:54:31', 2, 184, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11547, NULL, '6afcfeae-94b8-4b45-9721-c6b923ac1513', 'deposit', 0.00, '2025-02-02', '20:54:31', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:54:31', '2025-02-02 20:54:31', 23, 184, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11550, NULL, '63320c3f-0088-4e53-af41-bb25f492841f', 'withdrawal', 327500.00, '2025-02-02', '20:57:08', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:57:08', '2025-02-02 20:57:08', 183, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11551, NULL, '63320c3f-0088-4e53-af41-bb25f492841f', 'withdrawal', 327500.00, '2025-02-02', '20:57:08', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:57:08', '2025-02-02 20:57:08', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11552, NULL, '63320c3f-0088-4e53-af41-bb25f492841f', 'deposit', 0.00, '2025-02-02', '20:57:08', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:57:08', '2025-02-02 20:57:08', 23, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11553, NULL, '5b29b729-7781-41f2-b761-bb95fa407a44', 'withdrawal', 280.00, '2025-02-02', '20:57:09', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:57:09', '2025-02-02 20:57:09', 1048, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11554, NULL, '5b29b729-7781-41f2-b761-bb95fa407a44', 'withdrawal', 280.00, '2025-02-02', '20:57:09', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:57:09', '2025-02-02 20:57:09', 1, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11555, NULL, '5b29b729-7781-41f2-b761-bb95fa407a44', 'deposit', 0.00, '2025-02-02', '20:57:09', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 20:57:09', '2025-02-02 20:57:09', 22, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11566, NULL, '3d6420dd-2a56-4734-b505-c6ec705a9a01', 'withdrawal', 90000.00, '2025-02-02', '21:00:37', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 21:00:37', '2025-02-02 21:00:37', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11567, NULL, '3d6420dd-2a56-4734-b505-c6ec705a9a01', 'withdrawal', 90000.00, '2025-02-02', '21:00:37', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 21:00:37', '2025-02-02 21:00:37', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11568, NULL, '3d6420dd-2a56-4734-b505-c6ec705a9a01', 'deposit', 0.00, '2025-02-02', '21:00:37', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 21:00:37', '2025-02-02 21:00:37', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11575, NULL, '5a62700d-86f4-4bdb-b3d0-c665163900e5', 'deposit', 835000.00, '2025-02-02', '21:01:54', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 21:01:54', '2025-02-02 21:01:54', 451, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11576, NULL, '5a62700d-86f4-4bdb-b3d0-c665163900e5', 'deposit', 835000.00, '2025-02-02', '21:01:54', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 21:01:54', '2025-02-02 21:01:54', 2, 451, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11577, NULL, '5a62700d-86f4-4bdb-b3d0-c665163900e5', 'deposit', 0.00, '2025-02-02', '21:01:54', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-02 21:01:54', '2025-02-02 21:01:54', 23, 451, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11678, NULL, '5759575d-dc4a-4ddc-8076-b849888fcb20', 'withdrawal', 1500.00, '2025-02-02', '21:57:28', NULL, 0.00, 144, 'mahmod', NULL, NULL, NULL, NULL, '2025-02-02 21:57:28', '2025-02-02 21:57:28', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11679, NULL, '5759575d-dc4a-4ddc-8076-b849888fcb20', 'withdrawal', 1500.00, '2025-02-02', '21:57:28', NULL, 0.00, 144, 'mahmod', NULL, NULL, NULL, NULL, '2025-02-02 21:57:28', '2025-02-02 21:57:28', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11684, NULL, 'fcd12dbe-cf32-4b12-a158-f206f4ed6725', 'withdrawal', 301000.00, '2025-02-02', '22:04:54', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 22:04:54', '2025-02-02 22:04:54', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11685, NULL, 'fcd12dbe-cf32-4b12-a158-f206f4ed6725', 'withdrawal', 301000.00, '2025-02-02', '22:04:54', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 22:04:54', '2025-02-02 22:04:54', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11686, NULL, 'fcd12dbe-cf32-4b12-a158-f206f4ed6725', 'deposit', 1000.00, '2025-02-02', '22:04:54', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-02 22:04:54', '2025-02-02 22:04:54', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11687, NULL, '6c5ae31f-909f-4f95-8801-a990f94c1844', 'deposit', 1500.00, '2025-02-02', '22:07:22', NULL, 0.00, 1, 'MAHMUD', NULL, NULL, NULL, NULL, '2025-02-02 22:07:22', '2025-02-02 22:07:22', 217, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11688, NULL, '6c5ae31f-909f-4f95-8801-a990f94c1844', 'deposit', 1500.00, '2025-02-02', '22:07:22', NULL, 0.00, 1, 'MAHMUD', NULL, NULL, NULL, NULL, '2025-02-02 22:07:22', '2025-02-02 22:07:22', 1, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11689, NULL, '6c5ae31f-909f-4f95-8801-a990f94c1844', 'deposit', 0.00, '2025-02-02', '22:07:22', 'Fee collected for deposit', 0.00, 1, 'MAHMUD', NULL, NULL, NULL, NULL, '2025-02-02 22:07:22', '2025-02-02 22:07:22', 22, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11690, NULL, 'ac85288d-dffd-48b0-ab37-dbff07dcde08', 'deposit', 1500.00, '2025-02-02', '22:08:43', NULL, 0.00, 1, 'HMULA', NULL, NULL, NULL, NULL, '2025-02-02 22:08:43', '2025-02-02 22:08:43', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11691, NULL, 'ac85288d-dffd-48b0-ab37-dbff07dcde08', 'deposit', 1500.00, '2025-02-02', '22:08:43', NULL, 0.00, 1, 'HMULA', NULL, NULL, NULL, NULL, '2025-02-02 22:08:43', '2025-02-02 22:08:43', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11692, NULL, 'ac85288d-dffd-48b0-ab37-dbff07dcde08', 'deposit', 0.00, '2025-02-02', '22:08:43', 'Fee collected for deposit', 0.00, 1, 'HMULA', NULL, NULL, NULL, NULL, '2025-02-02 22:08:43', '2025-02-02 22:08:43', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11700, NULL, '47f4e0aa-3295-4b87-8a7c-c4aada25a1e0', 'withdrawal', 2000000.00, '2025-02-02', '22:12:36', NULL, 0.00, 1, 'K MUSTAFA', NULL, NULL, NULL, NULL, '2025-02-02 22:12:36', '2025-02-02 22:12:36', 253, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11701, NULL, '47f4e0aa-3295-4b87-8a7c-c4aada25a1e0', 'withdrawal', 2000000.00, '2025-02-02', '22:12:36', NULL, 0.00, 1, 'K MUSTAFA', NULL, NULL, NULL, NULL, '2025-02-02 22:12:36', '2025-02-02 22:12:36', 2, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11702, NULL, '47f4e0aa-3295-4b87-8a7c-c4aada25a1e0', 'deposit', 0.00, '2025-02-02', '22:12:36', 'Fee collected for withdrawal', 0.00, 1, 'K MUSTAFA', NULL, NULL, NULL, NULL, '2025-02-02 22:12:36', '2025-02-02 22:12:36', 23, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11713, NULL, '1d72c9cd-b0e6-4fde-a8d9-a716234447f3', 'withdrawal', 4062000.00, '2025-02-02', '22:16:57', NULL, 6000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:16:57', '2025-02-02 22:16:57', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11714, NULL, '1d72c9cd-b0e6-4fde-a8d9-a716234447f3', 'withdrawal', 4062000.00, '2025-02-02', '22:16:57', NULL, 6000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:16:57', '2025-02-02 22:16:57', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11715, NULL, '1d72c9cd-b0e6-4fde-a8d9-a716234447f3', 'deposit', 6000.00, '2025-02-02', '22:16:57', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:16:57', '2025-02-02 22:16:57', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11716, NULL, 'c9fe847f-befc-487e-9c58-a1cb32267453', 'withdrawal', 1046500.00, '2025-02-02', '22:17:18', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:17:18', '2025-02-02 22:17:18', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11717, NULL, 'c9fe847f-befc-487e-9c58-a1cb32267453', 'withdrawal', 1046500.00, '2025-02-02', '22:17:18', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:17:18', '2025-02-02 22:17:18', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11718, NULL, 'c9fe847f-befc-487e-9c58-a1cb32267453', 'deposit', 1500.00, '2025-02-02', '22:17:18', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:17:18', '2025-02-02 22:17:18', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11723, NULL, '43aa52ef-cc84-4f13-9225-07ca667c185d', 'withdrawal', 1346000.00, '2025-02-02', '22:17:50', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:17:50', '2025-02-02 22:17:50', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11724, NULL, '43aa52ef-cc84-4f13-9225-07ca667c185d', 'withdrawal', 1346000.00, '2025-02-02', '22:17:50', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:17:50', '2025-02-02 22:17:50', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(11725, NULL, '43aa52ef-cc84-4f13-9225-07ca667c185d', 'deposit', 2000.00, '2025-02-02', '22:17:50', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-02 22:17:50', '2025-02-02 22:17:50', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11730, NULL, '7c6be4cc-97b5-4d4c-b9f6-31dcc0f0cfa0', 'withdrawal', 1000.00, '2025-02-02', '22:18:16', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-02 22:18:16', '2025-02-02 22:18:16', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11731, NULL, '7c6be4cc-97b5-4d4c-b9f6-31dcc0f0cfa0', 'withdrawal', 1000.00, '2025-02-02', '22:18:16', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-02 22:18:16', '2025-02-02 22:18:16', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11732, NULL, '7c6be4cc-97b5-4d4c-b9f6-31dcc0f0cfa0', 'deposit', 0.00, '2025-02-02', '22:18:16', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-02 22:18:16', '2025-02-02 22:18:16', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11737, NULL, 'b1d907c4-50af-489a-a77c-fab5bba445c3', 'withdrawal', 60.00, '2025-02-02', '22:19:15', NULL, 0.00, 1, 'ZARDASHT', NULL, NULL, NULL, NULL, '2025-02-02 22:19:15', '2025-02-02 22:19:15', 214, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11738, NULL, 'b1d907c4-50af-489a-a77c-fab5bba445c3', 'withdrawal', 60.00, '2025-02-02', '22:19:15', NULL, 0.00, 1, 'ZARDASHT', NULL, NULL, NULL, NULL, '2025-02-02 22:19:15', '2025-02-02 22:19:15', 1, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11739, NULL, 'b1d907c4-50af-489a-a77c-fab5bba445c3', 'deposit', 0.00, '2025-02-02', '22:19:15', 'Fee collected for withdrawal', 0.00, 1, 'ZARDASHT', NULL, NULL, NULL, NULL, '2025-02-02 22:19:15', '2025-02-02 22:19:15', 22, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11792, NULL, 'dcef1420-d3e8-40ad-85a5-a1e7985a058e', 'withdrawal', 500000.00, '2025-02-03', '10:23:56', NULL, 0.00, 1, 'k.zagros', NULL, NULL, NULL, NULL, '2025-02-03 10:23:56', '2025-02-03 10:23:56', 284, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11793, NULL, 'dcef1420-d3e8-40ad-85a5-a1e7985a058e', 'withdrawal', 500000.00, '2025-02-03', '10:23:56', NULL, 0.00, 1, 'k.zagros', NULL, NULL, NULL, NULL, '2025-02-03 10:23:56', '2025-02-03 10:23:56', 2, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11824, NULL, 'c3e48f39-a093-4574-82d8-19f0c0f07b61', 'withdrawal', 3500.00, '2025-02-03', '11:09:58', NULL, 0.00, 1, 'Ali Husain Mohammed ali', NULL, NULL, NULL, NULL, '2025-02-03 11:09:58', '2025-02-03 11:09:58', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11825, NULL, 'c3e48f39-a093-4574-82d8-19f0c0f07b61', 'withdrawal', 3500.00, '2025-02-03', '11:09:58', NULL, 0.00, 1, 'Ali Husain Mohammed ali', NULL, NULL, NULL, NULL, '2025-02-03 11:09:58', '2025-02-03 11:09:58', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11842, NULL, 'b58ea5a9-b3f3-4e34-b915-24594bcf77d9', 'withdrawal', 2010000.00, '2025-02-03', '11:47:18', NULL, 0.00, 1, 'ida3', NULL, NULL, NULL, NULL, '2025-02-03 11:47:18', '2025-02-03 11:47:18', 469, 67, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11843, NULL, 'b58ea5a9-b3f3-4e34-b915-24594bcf77d9', 'deposit', 2010000.00, '2025-02-03', '11:47:18', NULL, 0.00, 1, 'ida3', NULL, NULL, NULL, NULL, '2025-02-03 11:47:18', '2025-02-03 11:47:18', 67, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11844, NULL, 'b58ea5a9-b3f3-4e34-b915-24594bcf77d9', 'deposit', 0.00, '2025-02-03', '11:47:18', 'Fee collected for transfer', 0.00, 1, 'ida3', NULL, NULL, NULL, NULL, '2025-02-03 11:47:18', '2025-02-03 11:47:18', 68, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11845, NULL, '15b88a9b-0700-4011-9907-3c29321c447f', 'deposit', 1155000.00, '2025-02-03', '11:50:48', 'dwene dasxl kra22 ', 0.00, 1, 'haval book store', NULL, NULL, NULL, NULL, '2025-02-03 11:50:48', '2025-02-03 11:50:48', 253, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11846, NULL, '15b88a9b-0700-4011-9907-3c29321c447f', 'deposit', 1155000.00, '2025-02-03', '11:50:48', 'dwene dasxl kra22 ', 0.00, 1, 'haval book store', NULL, NULL, NULL, NULL, '2025-02-03 11:50:48', '2025-02-03 11:50:48', 2, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11847, NULL, '15b88a9b-0700-4011-9907-3c29321c447f', 'deposit', 0.00, '2025-02-03', '11:50:48', 'Fee collected for deposit', 0.00, 1, 'haval book store', NULL, NULL, NULL, NULL, '2025-02-03 11:50:48', '2025-02-03 11:50:48', 23, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11946, NULL, '88a7278c-2d1f-42dc-885b-671e30713dae', 'deposit', 20280.00, '2025-02-03', '13:48:09', NULL, 0.00, 136, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-03 13:48:09', '2025-02-03 13:48:09', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(11947, NULL, '88a7278c-2d1f-42dc-885b-671e30713dae', 'deposit', 20280.00, '2025-02-03', '13:48:09', NULL, 0.00, 136, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-03 13:48:09', '2025-02-03 13:48:09', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12030, NULL, 'da43a3ae-3b43-4168-af53-d66479b2c353', 'deposit', 3300.00, '2025-02-03', '15:58:54', NULL, 0.00, 136, 'Rawa mahrewan jalal ', NULL, NULL, NULL, NULL, '2025-02-03 15:58:54', '2025-02-03 15:58:54', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12031, NULL, 'da43a3ae-3b43-4168-af53-d66479b2c353', 'deposit', 3300.00, '2025-02-03', '15:58:54', NULL, 0.00, 136, 'Rawa mahrewan jalal ', NULL, NULL, NULL, NULL, '2025-02-03 15:58:54', '2025-02-03 15:58:54', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12042, NULL, '667caf07-2db2-4ad1-ab25-1738adf9efd7', 'deposit', 19500000.00, '2025-02-03', '16:19:27', NULL, 0.00, 132, 'Abdula ', NULL, NULL, NULL, NULL, '2025-02-03 16:19:27', '2025-02-03 16:19:27', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12043, NULL, '667caf07-2db2-4ad1-ab25-1738adf9efd7', 'deposit', 19500000.00, '2025-02-03', '16:19:27', NULL, 0.00, 132, 'Abdula ', NULL, NULL, NULL, NULL, '2025-02-03 16:19:27', '2025-02-03 16:19:27', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12044, NULL, '3fb2df78-03db-426a-b6a8-56d12a3d4f63', 'deposit', 4200.00, '2025-02-03', '16:21:45', '', 0.00, 132, 'Abdula ', NULL, NULL, NULL, NULL, '2025-02-03 16:21:45', '2025-02-03 16:21:45', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12045, NULL, '3fb2df78-03db-426a-b6a8-56d12a3d4f63', 'deposit', 4200.00, '2025-02-03', '16:21:45', '', 0.00, 132, 'Abdula ', NULL, NULL, NULL, NULL, '2025-02-03 16:21:45', '2025-02-03 16:21:45', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12052, NULL, '16dbd72f-b324-4a56-a544-2e1ea119cf36', 'withdrawal', 1000000.00, '2025-02-03', '16:27:48', NULL, 0.00, 136, 'Shahlaa ahmed', NULL, NULL, NULL, NULL, '2025-02-03 16:27:48', '2025-02-03 16:27:48', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12053, NULL, '16dbd72f-b324-4a56-a544-2e1ea119cf36', 'withdrawal', 1000000.00, '2025-02-03', '16:27:48', NULL, 0.00, 136, 'Shahlaa ahmed', NULL, NULL, NULL, NULL, '2025-02-03 16:27:48', '2025-02-03 16:27:48', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12058, NULL, 'ab63929a-6395-47f3-8099-b801e699ddad', 'withdrawal', 1028000.00, '2025-02-03', '16:33:21', NULL, 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-03 16:33:21', '2025-02-03 16:33:21', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12059, NULL, 'ab63929a-6395-47f3-8099-b801e699ddad', 'withdrawal', 1028000.00, '2025-02-03', '16:33:21', NULL, 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-03 16:33:21', '2025-02-03 16:33:21', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12060, NULL, 'ab63929a-6395-47f3-8099-b801e699ddad', 'deposit', 0.00, '2025-02-03', '16:33:21', 'Fee collected for withdrawal', 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-03 16:33:21', '2025-02-03 16:33:21', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12063, NULL, '009d8547-859f-4b74-ad1a-a0954f0c8677', 'withdrawal', 3000.00, '2025-02-03', '16:34:07', NULL, 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-03 16:34:07', '2025-02-03 16:34:07', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12064, NULL, '009d8547-859f-4b74-ad1a-a0954f0c8677', 'withdrawal', 3000.00, '2025-02-03', '16:34:07', NULL, 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-03 16:34:07', '2025-02-03 16:34:07', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12065, NULL, '009d8547-859f-4b74-ad1a-a0954f0c8677', 'deposit', 0.00, '2025-02-03', '16:34:07', 'Fee collected for withdrawal', 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-03 16:34:07', '2025-02-03 16:34:07', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12066, NULL, '5bc76934-6218-4df4-a241-6a63ccd9caaa', 'deposit', 67750000.00, '2025-02-03', '16:34:42', NULL, 0.00, 1, 'm.rawand -muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-03 16:34:42', '2025-02-03 16:34:42', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12067, NULL, '5bc76934-6218-4df4-a241-6a63ccd9caaa', 'deposit', 67750000.00, '2025-02-03', '16:34:42', NULL, 0.00, 1, 'm.rawand -muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-03 16:34:42', '2025-02-03 16:34:42', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12068, NULL, '5bc76934-6218-4df4-a241-6a63ccd9caaa', 'deposit', 0.00, '2025-02-03', '16:34:42', 'Fee collected for deposit', 0.00, 1, 'm.rawand -muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-03 16:34:42', '2025-02-03 16:34:42', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12069, NULL, '7027afc6-6434-4217-be20-471fbf639e50', 'deposit', 3000.00, '2025-02-03', '16:36:19', NULL, 0.00, 1, 'turkeya', NULL, NULL, NULL, NULL, '2025-02-03 16:36:19', '2025-02-03 16:36:19', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12070, NULL, '7027afc6-6434-4217-be20-471fbf639e50', 'deposit', 3000.00, '2025-02-03', '16:36:19', NULL, 0.00, 1, 'turkeya', NULL, NULL, NULL, NULL, '2025-02-03 16:36:19', '2025-02-03 16:36:19', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12071, NULL, '7027afc6-6434-4217-be20-471fbf639e50', 'deposit', 0.00, '2025-02-03', '16:36:19', 'Fee collected for deposit', 0.00, 1, 'turkeya', NULL, NULL, NULL, NULL, '2025-02-03 16:36:19', '2025-02-03 16:36:19', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12072, NULL, '06bdf7c2-12e9-4e67-b2dc-4e0448e4dd37', 'withdrawal', 70000.00, '2025-02-03', '16:36:39', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-03 16:36:39', '2025-02-03 16:36:39', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12073, NULL, '06bdf7c2-12e9-4e67-b2dc-4e0448e4dd37', 'withdrawal', 70000.00, '2025-02-03', '16:36:39', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-03 16:36:39', '2025-02-03 16:36:39', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12074, NULL, '06bdf7c2-12e9-4e67-b2dc-4e0448e4dd37', 'deposit', 0.00, '2025-02-03', '16:36:39', 'Fee collected for withdrawal', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-03 16:36:39', '2025-02-03 16:36:39', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12075, NULL, 'a332e7f6-e995-4b81-8705-d98db5117a94', 'withdrawal', 50.00, '2025-02-03', '16:36:45', NULL, 0.00, 132, 'hade Khalid Abdulla ', NULL, NULL, NULL, NULL, '2025-02-03 16:36:45', '2025-02-03 16:36:45', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12076, NULL, 'a332e7f6-e995-4b81-8705-d98db5117a94', 'withdrawal', 50.00, '2025-02-03', '16:36:45', NULL, 0.00, 132, 'hade Khalid Abdulla ', NULL, NULL, NULL, NULL, '2025-02-03 16:36:45', '2025-02-03 16:36:45', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12077, NULL, '9981f24d-fc16-47d4-b52d-7b35a64db934', 'withdrawal', 64117.00, '2025-02-03', '16:38:00', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 16:38:00', '2025-02-03 16:38:00', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12078, NULL, '9981f24d-fc16-47d4-b52d-7b35a64db934', 'withdrawal', 64117.00, '2025-02-03', '16:38:00', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 16:38:00', '2025-02-03 16:38:00', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12079, NULL, '9981f24d-fc16-47d4-b52d-7b35a64db934', 'deposit', 0.00, '2025-02-03', '16:38:00', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 16:38:00', '2025-02-03 16:38:00', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12080, NULL, '5f1872a5-afcd-4128-a35e-92ebf9afbecb', 'deposit', 20000000.00, '2025-02-03', '16:38:42', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 16:38:42', '2025-02-03 16:38:42', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12081, NULL, '5f1872a5-afcd-4128-a35e-92ebf9afbecb', 'deposit', 20000000.00, '2025-02-03', '16:38:42', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 16:38:42', '2025-02-03 16:38:42', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12082, NULL, '5f1872a5-afcd-4128-a35e-92ebf9afbecb', 'deposit', 0.00, '2025-02-03', '16:38:42', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 16:38:42', '2025-02-03 16:38:42', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12085, NULL, '487a5306-2b93-4f5a-b97a-0301b0a857a0', 'withdrawal', 45000.00, '2025-02-03', '16:41:59', 'شکانەوە لەسەر داواکاری خۆی', 1503.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-03 16:41:59', '2025-02-03 16:41:59', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12086, NULL, '487a5306-2b93-4f5a-b97a-0301b0a857a0', 'deposit', 45000.00, '2025-02-03', '16:41:59', 'شکانەوە لەسەر داواکاری خۆی', 1503.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-03 16:41:59', '2025-02-03 16:41:59', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12087, NULL, '487a5306-2b93-4f5a-b97a-0301b0a857a0', 'deposit', 67646250.00, '2025-02-03', '16:41:59', 'شکانەوە لەسەر داواکاری خۆی', 1503.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-03 16:41:59', '2025-02-03 16:41:59', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12088, NULL, '487a5306-2b93-4f5a-b97a-0301b0a857a0', 'withdrawal', 67646250.00, '2025-02-03', '16:41:59', 'شکانەوە لەسەر داواکاری خۆی', 1503.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-03 16:41:59', '2025-02-03 16:41:59', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12131, NULL, 'd3d3d30c-1753-48fd-8dd0-00877d2399c8', 'withdrawal', 21982000.00, '2025-02-03', '17:24:10', NULL, 0.00, 132, 'Imad law braeem', NULL, NULL, NULL, NULL, '2025-02-03 17:24:10', '2025-02-03 17:24:10', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12132, NULL, 'd3d3d30c-1753-48fd-8dd0-00877d2399c8', 'withdrawal', 21982000.00, '2025-02-03', '17:24:10', NULL, 0.00, 132, 'Imad law braeem', NULL, NULL, NULL, NULL, '2025-02-03 17:24:10', '2025-02-03 17:24:10', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12257, NULL, 'e5f3eff9-c0b3-45ae-b9c6-7479159f232f', 'withdrawal', 191000.00, '2025-02-03', '20:06:31', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 20:06:31', '2025-02-03 20:06:31', 227, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12258, NULL, 'e5f3eff9-c0b3-45ae-b9c6-7479159f232f', 'withdrawal', 191000.00, '2025-02-03', '20:06:31', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 20:06:31', '2025-02-03 20:06:31', 2, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12259, NULL, 'e5f3eff9-c0b3-45ae-b9c6-7479159f232f', 'deposit', 1000.00, '2025-02-03', '20:06:31', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 20:06:31', '2025-02-03 20:06:31', 23, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12260, NULL, '762d2b03-441b-46c6-892b-92491c4603bb', 'withdrawal', 204500.00, '2025-02-03', '20:07:55', NULL, 1500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 20:07:55', '2025-02-03 20:07:55', 227, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12261, NULL, '762d2b03-441b-46c6-892b-92491c4603bb', 'withdrawal', 204500.00, '2025-02-03', '20:07:55', NULL, 1500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 20:07:55', '2025-02-03 20:07:55', 2, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12262, NULL, '762d2b03-441b-46c6-892b-92491c4603bb', 'deposit', 1500.00, '2025-02-03', '20:07:55', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 20:07:55', '2025-02-03 20:07:55', 23, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12269, NULL, '5f01c724-03f2-4a00-a269-f28b1894c795', 'withdrawal', 7227250.00, '2025-02-03', '20:18:50', NULL, 16500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 20:18:50', '2025-02-03 20:18:50', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12270, NULL, '5f01c724-03f2-4a00-a269-f28b1894c795', 'withdrawal', 7227250.00, '2025-02-03', '20:18:50', NULL, 16500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 20:18:50', '2025-02-03 20:18:50', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12271, NULL, '5f01c724-03f2-4a00-a269-f28b1894c795', 'deposit', 16500.00, '2025-02-03', '20:18:50', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 20:18:50', '2025-02-03 20:18:50', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12272, NULL, 'ee7df1e8-26b0-4451-ae77-f4da29484801', 'deposit', 1028000.00, '2025-02-03', '20:22:21', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-03 20:22:21', '2025-02-03 20:22:21', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12273, NULL, 'ee7df1e8-26b0-4451-ae77-f4da29484801', 'deposit', 1028000.00, '2025-02-03', '20:22:21', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-03 20:22:21', '2025-02-03 20:22:21', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12274, NULL, 'ee7df1e8-26b0-4451-ae77-f4da29484801', 'deposit', 0.00, '2025-02-03', '20:22:21', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-03 20:22:21', '2025-02-03 20:22:21', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12275, NULL, '76074dad-c1a7-4f43-93c9-be6003cc1c2d', 'deposit', 30000.00, '2025-02-03', '20:23:52', NULL, 0.00, 1, 'hsab asa', NULL, NULL, NULL, NULL, '2025-02-03 20:23:52', '2025-02-03 20:23:52', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12276, NULL, '76074dad-c1a7-4f43-93c9-be6003cc1c2d', 'deposit', 30000.00, '2025-02-03', '20:23:52', NULL, 0.00, 1, 'hsab asa', NULL, NULL, NULL, NULL, '2025-02-03 20:23:52', '2025-02-03 20:23:52', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12277, NULL, '76074dad-c1a7-4f43-93c9-be6003cc1c2d', 'deposit', 0.00, '2025-02-03', '20:23:52', 'Fee collected for deposit', 0.00, 1, 'hsab asa', NULL, NULL, NULL, NULL, '2025-02-03 20:23:52', '2025-02-03 20:23:52', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12280, NULL, '8c5ece3d-8f6a-443c-a26d-d609a5859d85', 'withdrawal', 31000.00, '2025-02-03', '20:24:39', NULL, 0.00, 1, 'k gardi', NULL, NULL, NULL, NULL, '2025-02-03 20:24:39', '2025-02-03 20:24:39', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12281, NULL, '8c5ece3d-8f6a-443c-a26d-d609a5859d85', 'withdrawal', 31000.00, '2025-02-03', '20:24:39', NULL, 0.00, 1, 'k gardi', NULL, NULL, NULL, NULL, '2025-02-03 20:24:39', '2025-02-03 20:24:39', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12282, NULL, '8c5ece3d-8f6a-443c-a26d-d609a5859d85', 'deposit', 0.00, '2025-02-03', '20:24:39', 'Fee collected for withdrawal', 0.00, 1, 'k gardi', NULL, NULL, NULL, NULL, '2025-02-03 20:24:39', '2025-02-03 20:24:39', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12283, NULL, 'd96171a8-2859-4fb9-82f6-48632d611d06', 'withdrawal', 67750000.00, '2025-02-03', '20:26:56', NULL, 0.00, 1, 'm.rawand-muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-03 20:26:56', '2025-02-03 20:26:56', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12284, NULL, 'd96171a8-2859-4fb9-82f6-48632d611d06', 'withdrawal', 67750000.00, '2025-02-03', '20:26:56', NULL, 0.00, 1, 'm.rawand-muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-03 20:26:56', '2025-02-03 20:26:56', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12285, NULL, 'd96171a8-2859-4fb9-82f6-48632d611d06', 'deposit', 0.00, '2025-02-03', '20:26:56', 'Fee collected for withdrawal', 0.00, 1, 'm.rawand-muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-03 20:26:56', '2025-02-03 20:26:56', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12288, NULL, '6c5cf480-c8f2-4321-98d8-96ffd48c1562', 'withdrawal', 67750000.00, '2025-02-03', '20:28:32', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-03 20:28:32', '2025-02-03 20:28:32', 409, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12289, NULL, '6c5cf480-c8f2-4321-98d8-96ffd48c1562', 'withdrawal', 67750000.00, '2025-02-03', '20:28:32', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-03 20:28:32', '2025-02-03 20:28:32', 2, 409, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12290, NULL, '6c5cf480-c8f2-4321-98d8-96ffd48c1562', 'deposit', 0.00, '2025-02-03', '20:28:32', 'Fee collected for withdrawal', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-03 20:28:32', '2025-02-03 20:28:32', 23, 409, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12291, NULL, 'c52e3096-a525-4147-a9bc-fa8fe703a37c', 'deposit', 67750000.00, '2025-02-03', '20:29:07', NULL, 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-03 20:29:07', '2025-02-03 20:29:07', 409, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12292, NULL, 'c52e3096-a525-4147-a9bc-fa8fe703a37c', 'deposit', 67750000.00, '2025-02-03', '20:29:07', NULL, 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-03 20:29:07', '2025-02-03 20:29:07', 2, 409, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12293, NULL, 'c52e3096-a525-4147-a9bc-fa8fe703a37c', 'deposit', 0.00, '2025-02-03', '20:29:07', 'Fee collected for deposit', 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-03 20:29:07', '2025-02-03 20:29:07', 23, 409, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12320, NULL, '87805c01-2da4-4235-8e5f-73c34bc44c2b', 'withdrawal', 64109.00, '2025-02-03', '21:00:36', NULL, -700.00, 1, 'raj3', NULL, NULL, NULL, NULL, '2025-02-03 21:00:36', '2025-02-03 21:00:36', 291, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12321, NULL, '87805c01-2da4-4235-8e5f-73c34bc44c2b', 'withdrawal', 64109.00, '2025-02-03', '21:00:36', NULL, -700.00, 1, 'raj3', NULL, NULL, NULL, NULL, '2025-02-03 21:00:36', '2025-02-03 21:00:36', 1, 291, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12322, NULL, '87805c01-2da4-4235-8e5f-73c34bc44c2b', 'deposit', -700.00, '2025-02-03', '21:00:36', 'Fee collected for withdrawal', 0.00, 1, 'raj3', NULL, NULL, NULL, NULL, '2025-02-03 21:00:36', '2025-02-03 21:00:36', 22, 291, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12323, NULL, 'b4b2dca9-2990-4af1-8d66-f81dea5baf94', 'deposit', 64116.00, '2025-02-03', '21:01:01', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 21:01:01', '2025-02-03 21:01:01', 291, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12324, NULL, 'b4b2dca9-2990-4af1-8d66-f81dea5baf94', 'deposit', 64116.00, '2025-02-03', '21:01:01', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 21:01:01', '2025-02-03 21:01:01', 1, 291, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12325, NULL, 'b4b2dca9-2990-4af1-8d66-f81dea5baf94', 'deposit', 0.00, '2025-02-03', '21:01:01', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 21:01:01', '2025-02-03 21:01:01', 22, 291, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12326, NULL, 'd2e5c9df-40f1-4a19-9589-57775e744ddc', 'withdrawal', 903000.00, '2025-02-03', '21:02:22', NULL, 3000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:02:22', '2025-02-03 21:02:22', 166, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12327, NULL, 'd2e5c9df-40f1-4a19-9589-57775e744ddc', 'withdrawal', 903000.00, '2025-02-03', '21:02:22', NULL, 3000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:02:22', '2025-02-03 21:02:22', 2, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12328, NULL, 'd2e5c9df-40f1-4a19-9589-57775e744ddc', 'deposit', 3000.00, '2025-02-03', '21:02:22', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:02:22', '2025-02-03 21:02:22', 23, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12329, NULL, '7df0c5d0-f85c-4cc2-a73f-a605476aa606', 'withdrawal', 301500.00, '2025-02-03', '21:02:42', NULL, 1500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:02:42', '2025-02-03 21:02:42', 166, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12330, NULL, '7df0c5d0-f85c-4cc2-a73f-a605476aa606', 'withdrawal', 301500.00, '2025-02-03', '21:02:42', NULL, 1500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:02:42', '2025-02-03 21:02:42', 2, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12331, NULL, '7df0c5d0-f85c-4cc2-a73f-a605476aa606', 'deposit', 1500.00, '2025-02-03', '21:02:42', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:02:42', '2025-02-03 21:02:42', 23, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12336, NULL, '001ee2f4-640f-4690-bab7-20c0ab21976d', 'deposit', 484.00, '2025-02-03', '21:04:56', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-03 21:04:56', '2025-02-03 21:04:56', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12337, NULL, '001ee2f4-640f-4690-bab7-20c0ab21976d', 'deposit', 484.00, '2025-02-03', '21:04:56', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-03 21:04:56', '2025-02-03 21:04:56', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12338, NULL, '001ee2f4-640f-4690-bab7-20c0ab21976d', 'deposit', 0.00, '2025-02-03', '21:04:56', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-03 21:04:56', '2025-02-03 21:04:56', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12343, NULL, '4f890132-c00d-427c-99af-041b41f5aa6f', 'deposit', 1004000.00, '2025-02-03', '21:07:18', NULL, 4000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:07:18', '2025-02-03 21:07:18', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12344, NULL, '4f890132-c00d-427c-99af-041b41f5aa6f', 'deposit', 1004000.00, '2025-02-03', '21:07:18', NULL, 4000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:07:18', '2025-02-03 21:07:18', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(12345, NULL, '4f890132-c00d-427c-99af-041b41f5aa6f', 'deposit', 4000.00, '2025-02-03', '21:07:18', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:07:18', '2025-02-03 21:07:18', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12346, NULL, 'ecadaa10-4ea3-426e-baf1-31353b6d92eb', 'deposit', 903500.00, '2025-02-03', '21:07:44', NULL, 3500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:07:44', '2025-02-03 21:07:44', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12347, NULL, 'ecadaa10-4ea3-426e-baf1-31353b6d92eb', 'deposit', 903500.00, '2025-02-03', '21:07:44', NULL, 3500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:07:44', '2025-02-03 21:07:44', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12348, NULL, 'ecadaa10-4ea3-426e-baf1-31353b6d92eb', 'deposit', 3500.00, '2025-02-03', '21:07:44', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:07:44', '2025-02-03 21:07:44', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12349, NULL, 'b3d6b4f7-6546-4d0a-8980-4ae1f690e092', 'deposit', 301250.00, '2025-02-03', '21:08:22', NULL, 1250.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:08:22', '2025-02-03 21:08:22', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12350, NULL, 'b3d6b4f7-6546-4d0a-8980-4ae1f690e092', 'deposit', 301250.00, '2025-02-03', '21:08:22', NULL, 1250.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:08:22', '2025-02-03 21:08:22', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12351, NULL, 'b3d6b4f7-6546-4d0a-8980-4ae1f690e092', 'deposit', 1250.00, '2025-02-03', '21:08:22', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:08:22', '2025-02-03 21:08:22', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12352, NULL, '8017b459-e2b0-4add-aec3-929bec07d411', 'deposit', 95380000.00, '2025-02-03', '21:09:05', NULL, 380000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:09:05', '2025-02-03 21:09:05', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12353, NULL, '8017b459-e2b0-4add-aec3-929bec07d411', 'deposit', 95380000.00, '2025-02-03', '21:09:05', NULL, 380000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:09:05', '2025-02-03 21:09:05', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12354, NULL, '8017b459-e2b0-4add-aec3-929bec07d411', 'deposit', 380000.00, '2025-02-03', '21:09:05', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:09:05', '2025-02-03 21:09:05', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12355, NULL, 'c411c21a-72c2-4d5b-9f83-d2edf7f9e795', 'deposit', 2008000.00, '2025-02-03', '21:09:28', NULL, 8000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:09:28', '2025-02-03 21:09:28', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12356, NULL, 'c411c21a-72c2-4d5b-9f83-d2edf7f9e795', 'deposit', 2008000.00, '2025-02-03', '21:09:28', NULL, 8000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:09:28', '2025-02-03 21:09:28', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12357, NULL, 'c411c21a-72c2-4d5b-9f83-d2edf7f9e795', 'deposit', 8000.00, '2025-02-03', '21:09:28', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 21:09:28', '2025-02-03 21:09:28', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12358, NULL, 'b8745f70-0358-406a-9b65-6193bfab34cd', 'withdrawal', 31942000.00, '2025-02-03', '21:10:00', NULL, 0.00, 1, 'tafrex', NULL, NULL, NULL, NULL, '2025-02-03 21:10:00', '2025-02-03 21:10:00', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12359, NULL, 'b8745f70-0358-406a-9b65-6193bfab34cd', 'withdrawal', 31942000.00, '2025-02-03', '21:10:00', NULL, 0.00, 1, 'tafrex', NULL, NULL, NULL, NULL, '2025-02-03 21:10:00', '2025-02-03 21:10:00', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12360, NULL, 'b8745f70-0358-406a-9b65-6193bfab34cd', 'deposit', 0.00, '2025-02-03', '21:10:00', 'Fee collected for withdrawal', 0.00, 1, 'tafrex', NULL, NULL, NULL, NULL, '2025-02-03 21:10:00', '2025-02-03 21:10:00', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12361, NULL, 'b3be50ba-eacb-4ae8-95bf-74740ea3c59b', 'withdrawal', 60000000.00, '2025-02-03', '21:10:44', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 21:10:44', '2025-02-03 21:10:44', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12362, NULL, 'b3be50ba-eacb-4ae8-95bf-74740ea3c59b', 'withdrawal', 60000000.00, '2025-02-03', '21:10:44', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 21:10:44', '2025-02-03 21:10:44', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12363, NULL, 'b3be50ba-eacb-4ae8-95bf-74740ea3c59b', 'deposit', 0.00, '2025-02-03', '21:10:44', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-03 21:10:44', '2025-02-03 21:10:44', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12402, NULL, 'edc73c6f-dbcd-4600-94b1-d7b82f76fe6b', 'withdrawal', 10.00, '2025-02-03', '22:13:43', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-03 22:13:43', '2025-02-03 22:13:43', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12403, NULL, 'edc73c6f-dbcd-4600-94b1-d7b82f76fe6b', 'withdrawal', 10.00, '2025-02-03', '22:13:43', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-03 22:13:43', '2025-02-03 22:13:43', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12404, NULL, 'edc73c6f-dbcd-4600-94b1-d7b82f76fe6b', 'deposit', 0.00, '2025-02-03', '22:13:43', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-03 22:13:43', '2025-02-03 22:13:43', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12405, NULL, '90d4a6d8-fa40-459b-a40c-7e493ea92518', 'withdrawal', 30000.00, '2025-02-03', '22:14:16', NULL, 0.00, 1, 'm.gardi', NULL, NULL, NULL, NULL, '2025-02-03 22:14:16', '2025-02-03 22:14:16', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12406, NULL, '90d4a6d8-fa40-459b-a40c-7e493ea92518', 'withdrawal', 30000.00, '2025-02-03', '22:14:16', NULL, 0.00, 1, 'm.gardi', NULL, NULL, NULL, NULL, '2025-02-03 22:14:16', '2025-02-03 22:14:16', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12407, NULL, '90d4a6d8-fa40-459b-a40c-7e493ea92518', 'deposit', 0.00, '2025-02-03', '22:14:16', 'Fee collected for withdrawal', 0.00, 1, 'm.gardi', NULL, NULL, NULL, NULL, '2025-02-03 22:14:16', '2025-02-03 22:14:16', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12410, NULL, 'eb585b90-f553-4902-b650-456f10db55df', 'withdrawal', 1005000.00, '2025-02-03', '22:15:56', NULL, 5000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 22:15:56', '2025-02-03 22:15:56', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12411, NULL, 'eb585b90-f553-4902-b650-456f10db55df', 'withdrawal', 1005000.00, '2025-02-03', '22:15:56', NULL, 5000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 22:15:56', '2025-02-03 22:15:56', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12412, NULL, 'eb585b90-f553-4902-b650-456f10db55df', 'deposit', 5000.00, '2025-02-03', '22:15:56', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 22:15:56', '2025-02-03 22:15:56', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12413, NULL, '7279bcda-e944-4492-aee4-d1b1c4f88c54', 'deposit', 3000.00, '2025-02-03', '22:16:22', NULL, 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-03 22:16:22', '2025-02-03 22:16:22', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12414, NULL, '7279bcda-e944-4492-aee4-d1b1c4f88c54', 'deposit', 3000.00, '2025-02-03', '22:16:22', NULL, 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-03 22:16:22', '2025-02-03 22:16:22', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12415, NULL, '7279bcda-e944-4492-aee4-d1b1c4f88c54', 'deposit', 0.00, '2025-02-03', '22:16:22', 'Fee collected for deposit', 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-03 22:16:22', '2025-02-03 22:16:22', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12420, NULL, '4e503b61-e5fc-4f86-a34b-835e62a142f0', 'withdrawal', 1362000.00, '2025-02-03', '22:19:33', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:19:33', '2025-02-03 22:19:33', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12421, NULL, '4e503b61-e5fc-4f86-a34b-835e62a142f0', 'withdrawal', 1362000.00, '2025-02-03', '22:19:33', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:19:33', '2025-02-03 22:19:33', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12422, NULL, '4e503b61-e5fc-4f86-a34b-835e62a142f0', 'deposit', 2000.00, '2025-02-03', '22:19:33', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:19:33', '2025-02-03 22:19:33', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12423, NULL, '621242ff-0765-4341-bcff-427bc50753cf', 'withdrawal', 251000.00, '2025-02-03', '22:19:53', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:19:53', '2025-02-03 22:19:53', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12424, NULL, '621242ff-0765-4341-bcff-427bc50753cf', 'withdrawal', 251000.00, '2025-02-03', '22:19:53', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:19:53', '2025-02-03 22:19:53', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12425, NULL, '621242ff-0765-4341-bcff-427bc50753cf', 'deposit', 1000.00, '2025-02-03', '22:19:53', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:19:53', '2025-02-03 22:19:53', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12426, NULL, '7c5d7b71-42c9-4be8-99e7-56b37471226d', 'withdrawal', 251000.00, '2025-02-03', '22:20:19', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:20:19', '2025-02-03 22:20:19', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12427, NULL, '7c5d7b71-42c9-4be8-99e7-56b37471226d', 'withdrawal', 251000.00, '2025-02-03', '22:20:19', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:20:19', '2025-02-03 22:20:19', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12428, NULL, '7c5d7b71-42c9-4be8-99e7-56b37471226d', 'deposit', 1000.00, '2025-02-03', '22:20:19', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-03 22:20:19', '2025-02-03 22:20:19', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12446, NULL, 'c248d85e-8379-4310-a873-4c9f2308fb62', 'deposit', 64096.00, '2025-02-03', '22:34:07', 'shadda 110$', -713.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-03 22:34:07', '2025-02-03 22:34:07', 221, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12447, NULL, 'c248d85e-8379-4310-a873-4c9f2308fb62', 'deposit', 64096.00, '2025-02-03', '22:34:07', 'shadda 110$', -713.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-03 22:34:07', '2025-02-03 22:34:07', 1, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12448, NULL, 'c248d85e-8379-4310-a873-4c9f2308fb62', 'deposit', -713.00, '2025-02-03', '22:34:07', 'Fee collected for deposit', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-03 22:34:07', '2025-02-03 22:34:07', 22, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12449, NULL, '5e95ef2c-0aae-429f-9329-e3e6ac40cb91', 'deposit', 64096.00, '2025-02-03', '22:35:03', 'شکانەوە لەسەر داواکاری خۆی', 1500.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-03 22:35:03', '2025-02-03 22:35:03', 1, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12450, NULL, '5e95ef2c-0aae-429f-9329-e3e6ac40cb91', 'withdrawal', 64096.00, '2025-02-03', '22:35:03', 'شکانەوە لەسەر داواکاری خۆی', 1500.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-03 22:35:03', '2025-02-03 22:35:03', 221, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12451, NULL, '5e95ef2c-0aae-429f-9329-e3e6ac40cb91', 'withdrawal', 96160024.00, '2025-02-03', '22:35:03', 'شکانەوە لەسەر داواکاری خۆی', 1500.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-03 22:35:03', '2025-02-03 22:35:03', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12452, NULL, '5e95ef2c-0aae-429f-9329-e3e6ac40cb91', 'deposit', 96160024.00, '2025-02-03', '22:35:03', 'شکانەوە لەسەر داواکاری خۆی', 1500.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-03 22:35:03', '2025-02-03 22:35:03', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12476, NULL, 'de7ac877-f622-4ff9-b892-4c1fd63ac730', 'withdrawal', 95522500.00, '2025-02-03', '22:46:55', NULL, 522500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 22:46:55', '2025-02-03 22:46:55', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12477, NULL, 'de7ac877-f622-4ff9-b892-4c1fd63ac730', 'withdrawal', 95522500.00, '2025-02-03', '22:46:55', NULL, 522500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 22:46:55', '2025-02-03 22:46:55', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12478, NULL, 'de7ac877-f622-4ff9-b892-4c1fd63ac730', 'deposit', 522500.00, '2025-02-03', '22:46:55', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-03 22:46:55', '2025-02-03 22:46:55', 23, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12483, NULL, 'f016953c-da46-4ef7-91c3-db4b1313b88e', 'deposit', 3869.00, '2025-02-04', '08:45:25', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 08:45:25', '2025-02-04 08:45:25', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12484, NULL, 'f016953c-da46-4ef7-91c3-db4b1313b88e', 'withdrawal', 3869.00, '2025-02-04', '08:45:25', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 08:45:25', '2025-02-04 08:45:25', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12485, NULL, 'f016953c-da46-4ef7-91c3-db4b1313b88e', 'withdrawal', 5809303.50, '2025-02-04', '08:45:25', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 08:45:25', '2025-02-04 08:45:25', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12486, NULL, 'f016953c-da46-4ef7-91c3-db4b1313b88e', 'deposit', 5809303.50, '2025-02-04', '08:45:25', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 08:45:25', '2025-02-04 08:45:25', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12487, NULL, 'edcfff97-b0b8-4147-83b2-2360a6f57abf', 'deposit', 47500.00, '2025-02-04', '08:47:28', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-04 08:47:28', '2025-02-04 08:47:28', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12488, NULL, 'edcfff97-b0b8-4147-83b2-2360a6f57abf', 'deposit', 47500.00, '2025-02-04', '08:47:28', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-04 08:47:28', '2025-02-04 08:47:28', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12489, NULL, 'edcfff97-b0b8-4147-83b2-2360a6f57abf', 'deposit', 0.00, '2025-02-04', '08:47:28', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-04 08:47:28', '2025-02-04 08:47:28', 23, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12490, NULL, '07d85c56-3689-46a6-a318-46316344aa62', 'withdrawal', 97250.00, '2025-02-04', '08:54:16', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-04 08:54:16', '2025-02-04 08:54:16', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12491, NULL, '07d85c56-3689-46a6-a318-46316344aa62', 'withdrawal', 97250.00, '2025-02-04', '08:54:16', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-04 08:54:16', '2025-02-04 08:54:16', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12492, NULL, '07d85c56-3689-46a6-a318-46316344aa62', 'deposit', 0.00, '2025-02-04', '08:54:16', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-04 08:54:16', '2025-02-04 08:54:16', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12555, NULL, 'b722975f-1a67-476c-8047-9013b3d6a8eb', 'withdrawal', 6274.00, '2025-02-04', '10:24:37', NULL, 14.00, 1, 'shoreja-abbas sadq', NULL, NULL, NULL, NULL, '2025-02-04 10:24:37', '2025-02-04 10:24:37', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12556, NULL, 'b722975f-1a67-476c-8047-9013b3d6a8eb', 'withdrawal', 6274.00, '2025-02-04', '10:24:37', NULL, 14.00, 1, 'shoreja-abbas sadq', NULL, NULL, NULL, NULL, '2025-02-04 10:24:37', '2025-02-04 10:24:37', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12557, NULL, 'b722975f-1a67-476c-8047-9013b3d6a8eb', 'deposit', 14.00, '2025-02-04', '10:24:37', 'Fee collected for withdrawal', 0.00, 1, 'shoreja-abbas sadq', NULL, NULL, NULL, NULL, '2025-02-04 10:24:37', '2025-02-04 10:24:37', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12558, NULL, '3dc97a47-02c6-4fb0-8d41-329aca795ddf', 'withdrawal', 2338.00, '2025-02-04', '10:25:40', NULL, 8.00, 1, 'shorja-oday abdulqadr', NULL, NULL, NULL, NULL, '2025-02-04 10:25:40', '2025-02-04 10:25:40', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12559, NULL, '3dc97a47-02c6-4fb0-8d41-329aca795ddf', 'withdrawal', 2338.00, '2025-02-04', '10:25:40', NULL, 8.00, 1, 'shorja-oday abdulqadr', NULL, NULL, NULL, NULL, '2025-02-04 10:25:40', '2025-02-04 10:25:40', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12560, NULL, '3dc97a47-02c6-4fb0-8d41-329aca795ddf', 'deposit', 8.00, '2025-02-04', '10:25:40', 'Fee collected for withdrawal', 0.00, 1, 'shorja-oday abdulqadr', NULL, NULL, NULL, NULL, '2025-02-04 10:25:40', '2025-02-04 10:25:40', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12561, NULL, '9a0cfe6c-6d3b-468b-a9b1-d6a57672fa5b', 'withdrawal', 4412.00, '2025-02-04', '10:28:34', 'شکانەوە لەسەر داواکاری خۆی', 1502.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 10:28:34', '2025-02-04 10:28:34', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12562, NULL, '9a0cfe6c-6d3b-468b-a9b1-d6a57672fa5b', 'deposit', 4412.00, '2025-02-04', '10:28:34', 'شکانەوە لەسەر داواکاری خۆی', 1502.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 10:28:34', '2025-02-04 10:28:34', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12563, NULL, '9a0cfe6c-6d3b-468b-a9b1-d6a57672fa5b', 'deposit', 6629030.00, '2025-02-04', '10:28:34', 'شکانەوە لەسەر داواکاری خۆی', 1502.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 10:28:34', '2025-02-04 10:28:34', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12564, NULL, '9a0cfe6c-6d3b-468b-a9b1-d6a57672fa5b', 'withdrawal', 6629030.00, '2025-02-04', '10:28:34', 'شکانەوە لەسەر داواکاری خۆی', 1502.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 10:28:34', '2025-02-04 10:28:34', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12581, NULL, '3c741109-4c45-4409-9336-fcea14e3d219', 'withdrawal', 2860000.00, '2025-02-04', '10:48:31', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-04 10:48:31', '2025-02-04 10:48:31', 184, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12582, NULL, '3c741109-4c45-4409-9336-fcea14e3d219', 'withdrawal', 2860000.00, '2025-02-04', '10:48:31', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-04 10:48:31', '2025-02-04 10:48:31', 2, 184, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12583, NULL, '3c741109-4c45-4409-9336-fcea14e3d219', 'deposit', 0.00, '2025-02-04', '10:48:31', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-04 10:48:31', '2025-02-04 10:48:31', 23, 184, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12620, NULL, '3a3d38d8-6248-4323-8162-2d2e9301083f', 'deposit', 2000.00, '2025-02-04', '12:10:10', NULL, 0.00, 132, 'Muhamad slah hamad ', NULL, NULL, NULL, NULL, '2025-02-04 12:10:10', '2025-02-04 12:10:10', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12621, NULL, '3a3d38d8-6248-4323-8162-2d2e9301083f', 'deposit', 2000.00, '2025-02-04', '12:10:10', NULL, 0.00, 132, 'Muhamad slah hamad ', NULL, NULL, NULL, NULL, '2025-02-04 12:10:10', '2025-02-04 12:10:10', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12708, NULL, '20ab8689-f0c5-4ab5-92d2-beb04611556b', 'deposit', 1525.00, '2025-02-04', '14:58:29', NULL, 0.00, 144, 'shko bakr abdulqadr', NULL, NULL, NULL, NULL, '2025-02-04 14:58:29', '2025-02-04 14:58:29', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12709, NULL, '20ab8689-f0c5-4ab5-92d2-beb04611556b', 'deposit', 1525.00, '2025-02-04', '14:58:29', NULL, 0.00, 144, 'shko bakr abdulqadr', NULL, NULL, NULL, NULL, '2025-02-04 14:58:29', '2025-02-04 14:58:29', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12718, NULL, 'c221c96f-ba07-4a13-9f9c-27793fb040ed', 'deposit', 2641.00, '2025-02-04', '15:11:44', NULL, 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-04 15:11:44', '2025-02-04 15:11:44', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12719, NULL, 'c221c96f-ba07-4a13-9f9c-27793fb040ed', 'deposit', 2641.00, '2025-02-04', '15:11:44', NULL, 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-04 15:11:44', '2025-02-04 15:11:44', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12720, NULL, 'c221c96f-ba07-4a13-9f9c-27793fb040ed', 'deposit', 0.00, '2025-02-04', '15:11:44', 'Fee collected for deposit', 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-04 15:11:44', '2025-02-04 15:11:44', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12721, NULL, '222a6160-9b3b-48ca-ae7c-4a9be1df2e2b', 'withdrawal', 3500.00, '2025-02-04', '15:12:21', NULL, 0.00, 1, 'm.semay wlat', NULL, NULL, NULL, NULL, '2025-02-04 15:12:21', '2025-02-04 15:12:21', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12722, NULL, '222a6160-9b3b-48ca-ae7c-4a9be1df2e2b', 'withdrawal', 3500.00, '2025-02-04', '15:12:21', NULL, 0.00, 1, 'm.semay wlat', NULL, NULL, NULL, NULL, '2025-02-04 15:12:21', '2025-02-04 15:12:21', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12723, NULL, '222a6160-9b3b-48ca-ae7c-4a9be1df2e2b', 'deposit', 0.00, '2025-02-04', '15:12:21', 'Fee collected for withdrawal', 0.00, 1, 'm.semay wlat', NULL, NULL, NULL, NULL, '2025-02-04 15:12:21', '2025-02-04 15:12:21', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12724, NULL, '8e1ad942-2961-4d41-97b3-91f1cc23f2f2', 'withdrawal', 500.00, '2025-02-04', '15:12:42', NULL, 0.00, 1, 'm.barz', NULL, NULL, NULL, NULL, '2025-02-04 15:12:42', '2025-02-04 15:12:42', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12725, NULL, '8e1ad942-2961-4d41-97b3-91f1cc23f2f2', 'withdrawal', 500.00, '2025-02-04', '15:12:42', NULL, 0.00, 1, 'm.barz', NULL, NULL, NULL, NULL, '2025-02-04 15:12:42', '2025-02-04 15:12:42', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12726, NULL, '8e1ad942-2961-4d41-97b3-91f1cc23f2f2', 'deposit', 0.00, '2025-02-04', '15:12:42', 'Fee collected for withdrawal', 0.00, 1, 'm.barz', NULL, NULL, NULL, NULL, '2025-02-04 15:12:42', '2025-02-04 15:12:42', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12727, NULL, '71835df2-782c-454a-949b-276c86c43e0a', 'withdrawal', 202000.00, '2025-02-04', '15:13:04', NULL, 0.00, 1, 'm.barz', NULL, NULL, NULL, NULL, '2025-02-04 15:13:04', '2025-02-04 15:13:04', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12728, NULL, '71835df2-782c-454a-949b-276c86c43e0a', 'withdrawal', 202000.00, '2025-02-04', '15:13:04', NULL, 0.00, 1, 'm.barz', NULL, NULL, NULL, NULL, '2025-02-04 15:13:04', '2025-02-04 15:13:04', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12729, NULL, '71835df2-782c-454a-949b-276c86c43e0a', 'deposit', 0.00, '2025-02-04', '15:13:04', 'Fee collected for withdrawal', 0.00, 1, 'm.barz', NULL, NULL, NULL, NULL, '2025-02-04 15:13:04', '2025-02-04 15:13:04', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12730, NULL, '22acbecb-6d32-4912-9dcf-5bd468aa4af8', 'withdrawal', 64166.00, '2025-02-04', '15:13:42', NULL, 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-02-04 15:13:42', '2025-02-04 15:13:42', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12731, NULL, '22acbecb-6d32-4912-9dcf-5bd468aa4af8', 'withdrawal', 64166.00, '2025-02-04', '15:13:42', NULL, 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-02-04 15:13:42', '2025-02-04 15:13:42', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12732, NULL, '22acbecb-6d32-4912-9dcf-5bd468aa4af8', 'deposit', 0.00, '2025-02-04', '15:13:42', 'Fee collected for withdrawal', 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-02-04 15:13:42', '2025-02-04 15:13:42', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12733, NULL, '05865d27-baa7-48f7-b986-0dd643a3e5df', 'withdrawal', 64166.00, '2025-02-04', '15:14:16', 'شکانەوە لەسەر داواکاری خۆی', 1499.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 15:14:16', '2025-02-04 15:14:16', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12734, NULL, '05865d27-baa7-48f7-b986-0dd643a3e5df', 'deposit', 64166.00, '2025-02-04', '15:14:16', 'شکانەوە لەسەر داواکاری خۆی', 1499.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 15:14:16', '2025-02-04 15:14:16', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12735, NULL, '05865d27-baa7-48f7-b986-0dd643a3e5df', 'deposit', 96184834.00, '2025-02-04', '15:14:16', 'شکانەوە لەسەر داواکاری خۆی', 1499.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 15:14:16', '2025-02-04 15:14:16', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12736, NULL, '05865d27-baa7-48f7-b986-0dd643a3e5df', 'withdrawal', 96184834.00, '2025-02-04', '15:14:16', 'شکانەوە لەسەر داواکاری خۆی', 1499.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 15:14:16', '2025-02-04 15:14:16', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12749, NULL, '0969e4dd-ee40-4229-bb09-a0f1efd69883', 'deposit', 400.00, '2025-02-04', '15:29:59', NULL, 0.00, 132, 'Rawa marewan jalal', NULL, NULL, NULL, NULL, '2025-02-04 15:29:59', '2025-02-04 15:29:59', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12750, NULL, '0969e4dd-ee40-4229-bb09-a0f1efd69883', 'deposit', 400.00, '2025-02-04', '15:29:59', NULL, 0.00, 132, 'Rawa marewan jalal', NULL, NULL, NULL, NULL, '2025-02-04 15:29:59', '2025-02-04 15:29:59', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12757, NULL, 'c73a033d-5ff7-4102-a64a-9b23909033f8', 'deposit', 6330.00, '2025-02-04', '15:50:12', NULL, 0.00, 1, 'ahmed pshtewan', NULL, NULL, NULL, NULL, '2025-02-04 15:50:12', '2025-02-04 15:50:12', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12758, NULL, 'c73a033d-5ff7-4102-a64a-9b23909033f8', 'deposit', 6330.00, '2025-02-04', '15:50:12', NULL, 0.00, 1, 'ahmed pshtewan', NULL, NULL, NULL, NULL, '2025-02-04 15:50:12', '2025-02-04 15:50:12', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(12759, NULL, 'c73a033d-5ff7-4102-a64a-9b23909033f8', 'deposit', 0.00, '2025-02-04', '15:50:12', 'Fee collected for deposit', 0.00, 1, 'ahmed pshtewan', NULL, NULL, NULL, NULL, '2025-02-04 15:50:12', '2025-02-04 15:50:12', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12760, NULL, '5264119d-24a7-4a49-b592-0e4534473bd6', 'withdrawal', 14000.00, '2025-02-04', '15:52:44', 'شکانەوە لەسەر داواکاری خۆی', 1500.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 15:52:44', '2025-02-04 15:52:44', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12761, NULL, '5264119d-24a7-4a49-b592-0e4534473bd6', 'deposit', 14000.00, '2025-02-04', '15:52:44', 'شکانەوە لەسەر داواکاری خۆی', 1500.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 15:52:44', '2025-02-04 15:52:44', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12762, NULL, '5264119d-24a7-4a49-b592-0e4534473bd6', 'deposit', 21007000.00, '2025-02-04', '15:52:44', 'شکانەوە لەسەر داواکاری خۆی', 1500.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 15:52:44', '2025-02-04 15:52:44', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12763, NULL, '5264119d-24a7-4a49-b592-0e4534473bd6', 'withdrawal', 21007000.00, '2025-02-04', '15:52:44', 'شکانەوە لەسەر داواکاری خۆی', 1500.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-04 15:52:44', '2025-02-04 15:52:44', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12764, NULL, 'a5e54fce-7d4d-4b4b-a218-2504cc060b9c', 'withdrawal', 2361750.00, '2025-02-04', '15:54:34', NULL, 11750.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-04 15:54:34', '2025-02-04 15:54:34', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12765, NULL, 'a5e54fce-7d4d-4b4b-a218-2504cc060b9c', 'withdrawal', 2361750.00, '2025-02-04', '15:54:34', NULL, 11750.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-04 15:54:34', '2025-02-04 15:54:34', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12766, NULL, 'a5e54fce-7d4d-4b4b-a218-2504cc060b9c', 'deposit', 11750.00, '2025-02-04', '15:54:34', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-04 15:54:34', '2025-02-04 15:54:34', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12773, NULL, 'ac6b4653-2dd5-4e85-bdf2-880f2624ccb9', 'deposit', 3330.00, '2025-02-04', '16:12:26', '', 0.00, 144, 'Mhamad salah hamd', NULL, NULL, NULL, NULL, '2025-02-04 16:12:26', '2025-02-04 16:12:26', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12774, NULL, 'ac6b4653-2dd5-4e85-bdf2-880f2624ccb9', 'deposit', 3330.00, '2025-02-04', '16:12:26', '', 0.00, 144, 'Mhamad salah hamd', NULL, NULL, NULL, NULL, '2025-02-04 16:12:26', '2025-02-04 16:12:26', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12809, NULL, 'c6ea1fea-ace4-4355-85d4-91c207761a4a', 'withdrawal', 25248.00, '2025-02-04', '16:33:49', NULL, 0.00, 144, 'mahde//07504444033', NULL, NULL, NULL, NULL, '2025-02-04 16:33:49', '2025-02-04 16:33:49', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12810, NULL, 'c6ea1fea-ace4-4355-85d4-91c207761a4a', 'withdrawal', 25248.00, '2025-02-04', '16:33:49', NULL, 0.00, 144, 'mahde//07504444033', NULL, NULL, NULL, NULL, '2025-02-04 16:33:49', '2025-02-04 16:33:49', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12849, NULL, '93c6e8d6-aa3a-482c-98c1-bf6dd4253730', 'deposit', 185000.00, '2025-02-04', '17:19:40', NULL, 0.00, 132, 'Barzan ahmed asad', NULL, NULL, NULL, NULL, '2025-02-04 17:19:40', '2025-02-04 17:19:40', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12850, NULL, '93c6e8d6-aa3a-482c-98c1-bf6dd4253730', 'deposit', 185000.00, '2025-02-04', '17:19:40', NULL, 0.00, 132, 'Barzan ahmed asad', NULL, NULL, NULL, NULL, '2025-02-04 17:19:40', '2025-02-04 17:19:40', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12873, NULL, '82e16cf0-d074-4284-8230-39d4bc5d91eb', 'withdrawal', 500.00, '2025-02-04', '18:51:14', NULL, 0.00, 136, 'mohammed abdulkhaleq hussein ', NULL, NULL, NULL, NULL, '2025-02-04 18:51:14', '2025-02-04 18:51:14', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12874, NULL, '82e16cf0-d074-4284-8230-39d4bc5d91eb', 'withdrawal', 500.00, '2025-02-04', '18:51:14', NULL, 0.00, 136, 'mohammed abdulkhaleq hussein ', NULL, NULL, NULL, NULL, '2025-02-04 18:51:14', '2025-02-04 18:51:14', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12877, NULL, '9ed8c155-44f5-40f9-a747-15e56ced2a60', 'deposit', 500.00, '2025-02-04', '18:54:17', NULL, 0.00, 132, 'Rawa mahrewan', NULL, NULL, NULL, NULL, '2025-02-04 18:54:17', '2025-02-04 18:54:17', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12878, NULL, '9ed8c155-44f5-40f9-a747-15e56ced2a60', 'deposit', 500.00, '2025-02-04', '18:54:17', NULL, 0.00, 132, 'Rawa mahrewan', NULL, NULL, NULL, NULL, '2025-02-04 18:54:17', '2025-02-04 18:54:17', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12917, NULL, '892e8bd0-30ed-4844-ad13-f616281222a7', 'deposit', 233.00, '2025-02-04', '19:43:56', NULL, 0.00, 136, 'Sawsan  mustafa rostam ', NULL, NULL, NULL, NULL, '2025-02-04 19:43:56', '2025-02-04 19:43:56', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(12918, NULL, '892e8bd0-30ed-4844-ad13-f616281222a7', 'deposit', 233.00, '2025-02-04', '19:43:56', NULL, 0.00, 136, 'Sawsan  mustafa rostam ', NULL, NULL, NULL, NULL, '2025-02-04 19:43:56', '2025-02-04 19:43:56', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13055, NULL, 'e625b386-1ffc-4df1-a166-929c881088ff', 'withdrawal', 1927000.00, '2025-02-05', '09:18:36', NULL, 7000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 09:18:36', '2025-02-05 09:18:36', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13056, NULL, 'e625b386-1ffc-4df1-a166-929c881088ff', 'withdrawal', 1927000.00, '2025-02-05', '09:18:36', NULL, 7000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 09:18:37', '2025-02-05 09:18:37', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13057, NULL, 'e625b386-1ffc-4df1-a166-929c881088ff', 'deposit', 7000.00, '2025-02-05', '09:18:36', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 09:18:37', '2025-02-05 09:18:37', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13074, NULL, '1f55e289-24ee-4aa6-8f90-23d938993a84', 'withdrawal', 1500.00, '2025-02-05', '09:50:23', NULL, 0.00, 1, 'samia brkl hasan', NULL, NULL, NULL, NULL, '2025-02-05 09:50:23', '2025-02-05 09:50:23', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13075, NULL, '1f55e289-24ee-4aa6-8f90-23d938993a84', 'withdrawal', 1500.00, '2025-02-05', '09:50:23', NULL, 0.00, 1, 'samia brkl hasan', NULL, NULL, NULL, NULL, '2025-02-05 09:50:23', '2025-02-05 09:50:23', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13076, NULL, '1f55e289-24ee-4aa6-8f90-23d938993a84', 'deposit', 0.00, '2025-02-05', '09:50:23', 'Fee collected for withdrawal', 0.00, 1, 'samia brkl hasan', NULL, NULL, NULL, NULL, '2025-02-05 09:50:23', '2025-02-05 09:50:23', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13079, NULL, '573691b7-7f76-43f2-bdd1-241255065ed7', 'withdrawal', 17.00, '2025-02-05', '09:51:16', NULL, 0.00, 1, 'nawroz', NULL, NULL, NULL, NULL, '2025-02-05 09:51:16', '2025-02-05 09:51:16', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13080, NULL, '573691b7-7f76-43f2-bdd1-241255065ed7', 'withdrawal', 17.00, '2025-02-05', '09:51:16', NULL, 0.00, 1, 'nawroz', NULL, NULL, NULL, NULL, '2025-02-05 09:51:16', '2025-02-05 09:51:16', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13081, NULL, '573691b7-7f76-43f2-bdd1-241255065ed7', 'deposit', 0.00, '2025-02-05', '09:51:16', 'Fee collected for withdrawal', 0.00, 1, 'nawroz', NULL, NULL, NULL, NULL, '2025-02-05 09:51:16', '2025-02-05 09:51:16', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13086, NULL, '8f6bd0c0-5638-458f-84b4-719b294298d7', 'withdrawal', 6.00, '2025-02-05', '09:55:26', NULL, 6.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 09:55:26', '2025-02-05 09:55:26', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13087, NULL, '8f6bd0c0-5638-458f-84b4-719b294298d7', 'withdrawal', 6.00, '2025-02-05', '09:55:26', NULL, 6.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 09:55:26', '2025-02-05 09:55:26', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13088, NULL, '8f6bd0c0-5638-458f-84b4-719b294298d7', 'deposit', 6.00, '2025-02-05', '09:55:26', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 09:55:26', '2025-02-05 09:55:26', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13089, NULL, '9d973664-aa04-4fba-8ab3-4e390f3b6340', 'deposit', 95000000.00, '2025-02-05', '09:57:41', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 09:57:41', '2025-02-05 09:57:41', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13090, NULL, '9d973664-aa04-4fba-8ab3-4e390f3b6340', 'deposit', 95000000.00, '2025-02-05', '09:57:41', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 09:57:41', '2025-02-05 09:57:41', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13091, NULL, '9d973664-aa04-4fba-8ab3-4e390f3b6340', 'deposit', 0.00, '2025-02-05', '09:57:41', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 09:57:41', '2025-02-05 09:57:41', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13092, NULL, '76c93acc-1979-4e8d-9ffc-b8a7ae3e8429', 'deposit', 10000.00, '2025-02-05', '09:58:03', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 09:58:03', '2025-02-05 09:58:03', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13093, NULL, '76c93acc-1979-4e8d-9ffc-b8a7ae3e8429', 'deposit', 10000.00, '2025-02-05', '09:58:03', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 09:58:03', '2025-02-05 09:58:03', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13094, NULL, '76c93acc-1979-4e8d-9ffc-b8a7ae3e8429', 'deposit', 0.00, '2025-02-05', '09:58:03', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 09:58:03', '2025-02-05 09:58:03', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13095, NULL, '89df21df-f1e3-4665-a434-cbe535f4e2b2', 'withdrawal', 300.00, '2025-02-05', '10:02:00', NULL, 0.00, 1, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-05 10:02:00', '2025-02-05 10:02:00', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13096, NULL, '89df21df-f1e3-4665-a434-cbe535f4e2b2', 'withdrawal', 300.00, '2025-02-05', '10:02:00', NULL, 0.00, 1, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-05 10:02:00', '2025-02-05 10:02:00', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13097, NULL, '89df21df-f1e3-4665-a434-cbe535f4e2b2', 'deposit', 0.00, '2025-02-05', '10:02:00', 'Fee collected for withdrawal', 0.00, 1, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-05 10:02:00', '2025-02-05 10:02:00', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13098, NULL, 'c52616e9-d7e3-41a9-8350-56fe0f974549', 'withdrawal', 10000000.00, '2025-02-05', '10:04:45', NULL, 0.00, 1, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-05 10:04:45', '2025-02-05 10:04:45', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13099, NULL, 'c52616e9-d7e3-41a9-8350-56fe0f974549', 'withdrawal', 10000000.00, '2025-02-05', '10:04:45', NULL, 0.00, 1, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-05 10:04:45', '2025-02-05 10:04:45', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13100, NULL, 'c52616e9-d7e3-41a9-8350-56fe0f974549', 'deposit', 0.00, '2025-02-05', '10:04:45', 'Fee collected for withdrawal', 0.00, 1, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-05 10:04:45', '2025-02-05 10:04:45', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13101, NULL, '8e284e80-8894-4801-9ff7-ca48fb831d9c', 'deposit', 64166.00, '2025-02-05', '10:09:44', 'shadda 93$', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-05 10:09:44', '2025-02-05 10:09:44', 221, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13102, NULL, '8e284e80-8894-4801-9ff7-ca48fb831d9c', 'deposit', 64166.00, '2025-02-05', '10:09:44', 'shadda 93$', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-05 10:09:44', '2025-02-05 10:09:44', 1, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13103, NULL, '8e284e80-8894-4801-9ff7-ca48fb831d9c', 'deposit', 0.00, '2025-02-05', '10:09:44', 'Fee collected for deposit', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-05 10:09:44', '2025-02-05 10:09:44', 22, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13104, NULL, '688c8a90-898a-4030-86f4-ebe9abd00611', 'deposit', 64166.00, '2025-02-05', '10:10:06', 'شکانەوە لەسەر داواکاری خۆی', 1499.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 10:10:06', '2025-02-05 10:10:06', 1, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13105, NULL, '688c8a90-898a-4030-86f4-ebe9abd00611', 'withdrawal', 64166.00, '2025-02-05', '10:10:06', 'شکانەوە لەسەر داواکاری خۆی', 1499.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 10:10:06', '2025-02-05 10:10:06', 221, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13106, NULL, '688c8a90-898a-4030-86f4-ebe9abd00611', 'withdrawal', 96184834.00, '2025-02-05', '10:10:06', 'شکانەوە لەسەر داواکاری خۆی', 1499.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 10:10:06', '2025-02-05 10:10:06', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13107, NULL, '688c8a90-898a-4030-86f4-ebe9abd00611', 'deposit', 96184834.00, '2025-02-05', '10:10:06', 'شکانەوە لەسەر داواکاری خۆی', 1499.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 10:10:06', '2025-02-05 10:10:06', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13112, NULL, '05d264a8-cf2e-4ac0-8d3f-5c2dcc918e1a', 'deposit', 2357000.00, '2025-02-05', '10:14:12', NULL, 7000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-05 10:14:12', '2025-02-05 10:14:12', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13113, NULL, '05d264a8-cf2e-4ac0-8d3f-5c2dcc918e1a', 'deposit', 2357000.00, '2025-02-05', '10:14:12', NULL, 7000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-05 10:14:12', '2025-02-05 10:14:12', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13114, NULL, '05d264a8-cf2e-4ac0-8d3f-5c2dcc918e1a', 'deposit', 7000.00, '2025-02-05', '10:14:12', 'Fee collected for deposit', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-05 10:14:12', '2025-02-05 10:14:12', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13119, NULL, '3a73046a-92d7-41ba-9e51-578bc200c7f7', 'withdrawal', 105000000.00, '2025-02-05', '10:14:39', NULL, 0.00, 1, 'muhamad salm,', NULL, NULL, NULL, NULL, '2025-02-05 10:14:39', '2025-02-05 10:14:39', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13120, NULL, '3a73046a-92d7-41ba-9e51-578bc200c7f7', 'withdrawal', 105000000.00, '2025-02-05', '10:14:39', NULL, 0.00, 1, 'muhamad salm,', NULL, NULL, NULL, NULL, '2025-02-05 10:14:39', '2025-02-05 10:14:39', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13121, NULL, '3a73046a-92d7-41ba-9e51-578bc200c7f7', 'deposit', 0.00, '2025-02-05', '10:14:39', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm,', NULL, NULL, NULL, NULL, '2025-02-05 10:14:39', '2025-02-05 10:14:39', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13122, NULL, 'f854efd3-f548-4364-bf29-07f294e32c3a', 'deposit', 102295000.00, '2025-02-05', '10:15:35', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 10:15:35', '2025-02-05 10:15:35', 961, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13123, NULL, 'f854efd3-f548-4364-bf29-07f294e32c3a', 'deposit', 102295000.00, '2025-02-05', '10:15:35', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 10:15:35', '2025-02-05 10:15:35', 2, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13124, NULL, 'f854efd3-f548-4364-bf29-07f294e32c3a', 'deposit', 0.00, '2025-02-05', '10:15:35', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-05 10:15:35', '2025-02-05 10:15:35', 23, 961, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13129, NULL, '55645a48-08fa-4466-84b6-e4ce9a69b4e5', 'deposit', 6272.00, '2025-02-05', '10:17:51', NULL, 12.00, 1, 'abbas sadq-shorja', NULL, NULL, NULL, NULL, '2025-02-05 10:17:51', '2025-02-05 10:17:51', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13130, NULL, '55645a48-08fa-4466-84b6-e4ce9a69b4e5', 'deposit', 6272.00, '2025-02-05', '10:17:51', NULL, 12.00, 1, 'abbas sadq-shorja', NULL, NULL, NULL, NULL, '2025-02-05 10:17:51', '2025-02-05 10:17:51', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13131, NULL, '55645a48-08fa-4466-84b6-e4ce9a69b4e5', 'deposit', 12.00, '2025-02-05', '10:17:51', 'Fee collected for deposit', 0.00, 1, 'abbas sadq-shorja', NULL, NULL, NULL, NULL, '2025-02-05 10:17:51', '2025-02-05 10:17:51', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13132, NULL, '75d64c32-73fe-49a3-9783-663ddc38631c', 'deposit', 2336.00, '2025-02-05', '10:18:21', NULL, 6.00, 1, 'oday abdulqadr-shorja', NULL, NULL, NULL, NULL, '2025-02-05 10:18:21', '2025-02-05 10:18:21', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13133, NULL, '75d64c32-73fe-49a3-9783-663ddc38631c', 'deposit', 2336.00, '2025-02-05', '10:18:21', NULL, 6.00, 1, 'oday abdulqadr-shorja', NULL, NULL, NULL, NULL, '2025-02-05 10:18:21', '2025-02-05 10:18:21', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13134, NULL, '75d64c32-73fe-49a3-9783-663ddc38631c', 'deposit', 6.00, '2025-02-05', '10:18:21', 'Fee collected for deposit', 0.00, 1, 'oday abdulqadr-shorja', NULL, NULL, NULL, NULL, '2025-02-05 10:18:21', '2025-02-05 10:18:21', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13135, NULL, '2c4876e7-26d3-4f25-babf-4ee9594d47b1', 'deposit', 300.00, '2025-02-05', '10:20:05', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:20:05', '2025-02-05 10:20:05', 265, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13136, NULL, '2c4876e7-26d3-4f25-babf-4ee9594d47b1', 'deposit', 300.00, '2025-02-05', '10:20:05', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:20:05', '2025-02-05 10:20:05', 1, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13137, NULL, '2c4876e7-26d3-4f25-babf-4ee9594d47b1', 'deposit', 0.00, '2025-02-05', '10:20:05', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:20:05', '2025-02-05 10:20:05', 22, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13138, NULL, '7819517a-668a-4160-b2e9-5f7d26e3ad75', 'deposit', 10000000.00, '2025-02-05', '10:21:28', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 10:21:28', '2025-02-05 10:21:28', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13139, NULL, '7819517a-668a-4160-b2e9-5f7d26e3ad75', 'deposit', 10000000.00, '2025-02-05', '10:21:28', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 10:21:28', '2025-02-05 10:21:28', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13140, NULL, '7819517a-668a-4160-b2e9-5f7d26e3ad75', 'deposit', 0.00, '2025-02-05', '10:21:28', 'Fee collected for deposit', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 10:21:28', '2025-02-05 10:21:28', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13141, NULL, 'e89b65c1-7cc2-48c3-a0b0-c46a70079ef4', 'withdrawal', 77500.00, '2025-02-05', '10:23:05', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 10:23:05', '2025-02-05 10:23:05', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13142, NULL, 'e89b65c1-7cc2-48c3-a0b0-c46a70079ef4', 'withdrawal', 77500.00, '2025-02-05', '10:23:05', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 10:23:05', '2025-02-05 10:23:05', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13143, NULL, 'e89b65c1-7cc2-48c3-a0b0-c46a70079ef4', 'deposit', 500.00, '2025-02-05', '10:23:05', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 10:23:05', '2025-02-05 10:23:05', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13144, NULL, 'da08579d-0193-41c3-a8a8-3241968e0bcc', 'withdrawal', 5695750.00, '2025-02-05', '10:26:10', NULL, 10750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 10:26:10', '2025-02-05 10:26:10', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13145, NULL, 'da08579d-0193-41c3-a8a8-3241968e0bcc', 'withdrawal', 5695750.00, '2025-02-05', '10:26:10', NULL, 10750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 10:26:10', '2025-02-05 10:26:10', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13146, NULL, 'da08579d-0193-41c3-a8a8-3241968e0bcc', 'deposit', 10750.00, '2025-02-05', '10:26:10', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 10:26:10', '2025-02-05 10:26:10', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13147, NULL, 'f20fbe68-ce3f-4dff-a26b-e3d93744f411', 'withdrawal', 1250.00, '2025-02-05', '10:26:37', NULL, 1250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 10:26:37', '2025-02-05 10:26:37', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13148, NULL, 'f20fbe68-ce3f-4dff-a26b-e3d93744f411', 'withdrawal', 1250.00, '2025-02-05', '10:26:37', NULL, 1250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 10:26:37', '2025-02-05 10:26:37', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13149, NULL, 'f20fbe68-ce3f-4dff-a26b-e3d93744f411', 'deposit', 1250.00, '2025-02-05', '10:26:37', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 10:26:37', '2025-02-05 10:26:37', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13152, NULL, '598a1768-0893-4c94-bef7-b768e6e1a96c', 'withdrawal', 500.00, '2025-02-05', '10:29:51', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 10:29:51', '2025-02-05 10:29:51', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13153, NULL, '598a1768-0893-4c94-bef7-b768e6e1a96c', 'deposit', 500.00, '2025-02-05', '10:29:51', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 10:29:51', '2025-02-05 10:29:51', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13154, NULL, '598a1768-0893-4c94-bef7-b768e6e1a96c', 'deposit', 750750.00, '2025-02-05', '10:29:51', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 10:29:51', '2025-02-05 10:29:51', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13155, NULL, '598a1768-0893-4c94-bef7-b768e6e1a96c', 'withdrawal', 750750.00, '2025-02-05', '10:29:51', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 10:29:51', '2025-02-05 10:29:51', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13158, NULL, '80070f23-c628-4b9f-928a-95e54ae6c62c', 'withdrawal', 6840.00, '2025-02-05', '10:36:09', '10500000hazare-153500', 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:36:09', '2025-02-05 10:36:09', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13159, NULL, '80070f23-c628-4b9f-928a-95e54ae6c62c', 'withdrawal', 6840.00, '2025-02-05', '10:36:09', '10500000hazare-153500', 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:36:09', '2025-02-05 10:36:09', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13160, NULL, '80070f23-c628-4b9f-928a-95e54ae6c62c', 'deposit', 0.00, '2025-02-05', '10:36:09', 'Fee collected for withdrawal', 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:36:09', '2025-02-05 10:36:09', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13161, NULL, '7f0ef3f5-c684-4fd7-acd3-094a6b3d7d71', 'deposit', 3200.00, '2025-02-05', '10:36:28', NULL, 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:36:28', '2025-02-05 10:36:28', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13162, NULL, '7f0ef3f5-c684-4fd7-acd3-094a6b3d7d71', 'deposit', 3200.00, '2025-02-05', '10:36:28', NULL, 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:36:28', '2025-02-05 10:36:28', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13163, NULL, '7f0ef3f5-c684-4fd7-acd3-094a6b3d7d71', 'deposit', 0.00, '2025-02-05', '10:36:28', 'Fee collected for deposit', 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:36:28', '2025-02-05 10:36:28', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13164, NULL, 'bb164630-fb55-43eb-879f-a5f714c98284', 'deposit', 21000.00, '2025-02-05', '10:37:02', NULL, 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:37:02', '2025-02-05 10:37:02', 179, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13165, NULL, 'bb164630-fb55-43eb-879f-a5f714c98284', 'deposit', 21000.00, '2025-02-05', '10:37:02', NULL, 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:37:02', '2025-02-05 10:37:02', 2, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13166, NULL, 'bb164630-fb55-43eb-879f-a5f714c98284', 'deposit', 0.00, '2025-02-05', '10:37:02', 'Fee collected for deposit', 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-05 10:37:02', '2025-02-05 10:37:02', 23, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13172, NULL, '79edfa32-4515-4410-8121-c51153a2cdb4', 'withdrawal', 64166.00, '2025-02-05', '10:40:57', NULL, -602.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-05 10:40:57', '2025-02-05 10:40:57', 271, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13173, NULL, '79edfa32-4515-4410-8121-c51153a2cdb4', 'withdrawal', 64166.00, '2025-02-05', '10:40:57', NULL, -602.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-05 10:40:57', '2025-02-05 10:40:57', 1, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13174, NULL, '79edfa32-4515-4410-8121-c51153a2cdb4', 'deposit', -602.00, '2025-02-05', '10:40:57', 'Fee collected for withdrawal', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-05 10:40:57', '2025-02-05 10:40:57', 22, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13175, NULL, '7e362c59-b165-40ce-a553-1555057ebd3a', 'deposit', 64166.00, '2025-02-05', '10:41:17', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:41:17', '2025-02-05 10:41:17', 271, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13176, NULL, '7e362c59-b165-40ce-a553-1555057ebd3a', 'deposit', 64166.00, '2025-02-05', '10:41:17', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:41:17', '2025-02-05 10:41:17', 1, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13177, NULL, '7e362c59-b165-40ce-a553-1555057ebd3a', 'deposit', 0.00, '2025-02-05', '10:41:17', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:41:17', '2025-02-05 10:41:17', 22, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(13178, NULL, '6bf50cfc-5b21-4e16-b162-0cbfeaa33794', 'deposit', 500.00, '2025-02-05', '10:44:00', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:44:00', '2025-02-05 10:44:00', 191, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13179, NULL, '6bf50cfc-5b21-4e16-b162-0cbfeaa33794', 'deposit', 500.00, '2025-02-05', '10:44:00', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:44:00', '2025-02-05 10:44:00', 1, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13180, NULL, '6bf50cfc-5b21-4e16-b162-0cbfeaa33794', 'deposit', 0.00, '2025-02-05', '10:44:00', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-05 10:44:00', '2025-02-05 10:44:00', 22, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13181, NULL, 'aa38e339-fe43-4e72-83d0-bf3a14b11262', 'deposit', 202000.00, '2025-02-05', '10:44:01', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 10:44:01', '2025-02-05 10:44:01', 190, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13182, NULL, 'aa38e339-fe43-4e72-83d0-bf3a14b11262', 'deposit', 202000.00, '2025-02-05', '10:44:01', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 10:44:01', '2025-02-05 10:44:01', 2, 190, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13183, NULL, 'aa38e339-fe43-4e72-83d0-bf3a14b11262', 'deposit', 0.00, '2025-02-05', '10:44:01', 'Fee collected for deposit', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 10:44:01', '2025-02-05 10:44:01', 23, 190, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13188, NULL, 'dae40e73-2a78-496f-9023-286ca3893ff3', 'withdrawal', 15000.00, '2025-02-05', '10:53:18', NULL, 0.00, 1, 'nasswalet', NULL, NULL, NULL, NULL, '2025-02-05 10:53:18', '2025-02-05 10:53:18', 222, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13189, NULL, 'dae40e73-2a78-496f-9023-286ca3893ff3', 'withdrawal', 15000.00, '2025-02-05', '10:53:18', NULL, 0.00, 1, 'nasswalet', NULL, NULL, NULL, NULL, '2025-02-05 10:53:18', '2025-02-05 10:53:18', 2, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13190, NULL, 'dae40e73-2a78-496f-9023-286ca3893ff3', 'deposit', 0.00, '2025-02-05', '10:53:18', 'Fee collected for withdrawal', 0.00, 1, 'nasswalet', NULL, NULL, NULL, NULL, '2025-02-05 10:53:18', '2025-02-05 10:53:18', 23, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13253, NULL, '825c4de2-03b4-47ed-8815-cb48cdf8821d', 'deposit', 4865000.00, '2025-02-05', '12:14:07', NULL, 0.00, 132, 'Azad akrey bo essa barzane ', NULL, NULL, NULL, NULL, '2025-02-05 12:14:07', '2025-02-05 12:14:07', 205, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13254, NULL, '825c4de2-03b4-47ed-8815-cb48cdf8821d', 'deposit', 4865000.00, '2025-02-05', '12:14:07', NULL, 0.00, 132, 'Azad akrey bo essa barzane ', NULL, NULL, NULL, NULL, '2025-02-05 12:14:07', '2025-02-05 12:14:07', 2, 205, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13271, NULL, '73cc0caf-5e97-4ff1-b88a-3c8cdca78045', 'withdrawal', 4865000.00, '2025-02-05', '12:37:56', 150150, 0.00, 1, 'Alugor', NULL, NULL, NULL, NULL, '2025-02-05 12:37:56', '2025-02-05 12:37:56', 205, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13272, NULL, '73cc0caf-5e97-4ff1-b88a-3c8cdca78045', 'withdrawal', 4865000.00, '2025-02-05', '12:37:56', 150150, 0.00, 1, 'Alugor', NULL, NULL, NULL, NULL, '2025-02-05 12:37:56', '2025-02-05 12:37:56', 2, 205, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13273, NULL, '73cc0caf-5e97-4ff1-b88a-3c8cdca78045', 'deposit', 0.00, '2025-02-05', '12:37:56', 'Fee collected for withdrawal', 0.00, 1, 'Alugor', NULL, NULL, NULL, NULL, '2025-02-05 12:37:56', '2025-02-05 12:37:56', 23, 205, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13274, NULL, '8811868f-5763-468a-84da-51c730123aad', 'deposit', 3240.00, '2025-02-05', '12:38:01', 150150, 0.00, 1, 'Alugor', NULL, NULL, NULL, NULL, '2025-02-05 12:38:01', '2025-02-05 12:38:01', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13275, NULL, '8811868f-5763-468a-84da-51c730123aad', 'deposit', 3240.00, '2025-02-05', '12:38:01', 150150, 0.00, 1, 'Alugor', NULL, NULL, NULL, NULL, '2025-02-05 12:38:01', '2025-02-05 12:38:01', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13276, NULL, '8811868f-5763-468a-84da-51c730123aad', 'deposit', 0.00, '2025-02-05', '12:38:01', 'Fee collected for deposit', 0.00, 1, 'Alugor', NULL, NULL, NULL, NULL, '2025-02-05 12:38:01', '2025-02-05 12:38:01', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13361, NULL, '03423008-6806-493a-b68a-777c64492f98', 'withdrawal', 1500.00, '2025-02-05', '14:55:32', NULL, 0.00, 132, 'Karwan', NULL, NULL, NULL, NULL, '2025-02-05 14:55:32', '2025-02-05 14:55:32', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13362, NULL, '03423008-6806-493a-b68a-777c64492f98', 'withdrawal', 1500.00, '2025-02-05', '14:55:32', NULL, 0.00, 132, 'Karwan', NULL, NULL, NULL, NULL, '2025-02-05 14:55:32', '2025-02-05 14:55:32', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13367, NULL, '99c6dac3-0b6f-4fd6-af68-9e520e5ca30f', 'deposit', 10002.00, '2025-02-05', '15:01:52', NULL, 2.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-05 15:01:52', '2025-02-05 15:01:52', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13368, NULL, '99c6dac3-0b6f-4fd6-af68-9e520e5ca30f', 'deposit', 10002.00, '2025-02-05', '15:01:52', NULL, 2.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-05 15:01:52', '2025-02-05 15:01:52', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13369, NULL, '99c6dac3-0b6f-4fd6-af68-9e520e5ca30f', 'deposit', 2.00, '2025-02-05', '15:01:52', 'Fee collected for deposit', 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-05 15:01:52', '2025-02-05 15:01:52', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13370, NULL, 'cc8bfad3-cfe2-4455-a00e-de1109c1cdc9', 'withdrawal', 1001500.00, '2025-02-05', '15:04:09', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 15:04:09', '2025-02-05 15:04:09', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13371, NULL, 'cc8bfad3-cfe2-4455-a00e-de1109c1cdc9', 'withdrawal', 1001500.00, '2025-02-05', '15:04:09', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 15:04:09', '2025-02-05 15:04:09', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13372, NULL, 'cc8bfad3-cfe2-4455-a00e-de1109c1cdc9', 'deposit', 1500.00, '2025-02-05', '15:04:09', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 15:04:09', '2025-02-05 15:04:09', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13373, NULL, 'ee91e3ea-42e5-42e7-adb0-0a843aaf755d', 'withdrawal', 301000.00, '2025-02-05', '15:04:39', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 15:04:39', '2025-02-05 15:04:39', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13374, NULL, 'ee91e3ea-42e5-42e7-adb0-0a843aaf755d', 'withdrawal', 301000.00, '2025-02-05', '15:04:39', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 15:04:39', '2025-02-05 15:04:39', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13375, NULL, 'ee91e3ea-42e5-42e7-adb0-0a843aaf755d', 'deposit', 1000.00, '2025-02-05', '15:04:39', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-05 15:04:39', '2025-02-05 15:04:39', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13376, NULL, '10e01aa9-afa1-469b-9a1e-1eb58595e50d', 'withdrawal', 4012.00, '2025-02-05', '15:05:59', NULL, 12.00, 1, 'shorja-husen sadq', NULL, NULL, NULL, NULL, '2025-02-05 15:05:59', '2025-02-05 15:05:59', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13377, NULL, '10e01aa9-afa1-469b-9a1e-1eb58595e50d', 'withdrawal', 4012.00, '2025-02-05', '15:05:59', NULL, 12.00, 1, 'shorja-husen sadq', NULL, NULL, NULL, NULL, '2025-02-05 15:05:59', '2025-02-05 15:05:59', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13378, NULL, '10e01aa9-afa1-469b-9a1e-1eb58595e50d', 'deposit', 12.00, '2025-02-05', '15:05:59', 'Fee collected for withdrawal', 0.00, 1, 'shorja-husen sadq', NULL, NULL, NULL, NULL, '2025-02-05 15:05:59', '2025-02-05 15:05:59', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13379, NULL, 'd8f1246b-e8b9-44d1-8f17-1f3d6df0da18', 'withdrawal', 4012.00, '2025-02-05', '15:06:44', 'شکانەوە لەسەر داواکاری خۆی', 1503.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 15:06:44', '2025-02-05 15:06:44', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13380, NULL, 'd8f1246b-e8b9-44d1-8f17-1f3d6df0da18', 'deposit', 4012.00, '2025-02-05', '15:06:44', 'شکانەوە لەسەر داواکاری خۆی', 1503.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 15:06:44', '2025-02-05 15:06:44', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13381, NULL, 'd8f1246b-e8b9-44d1-8f17-1f3d6df0da18', 'deposit', 6030036.00, '2025-02-05', '15:06:44', 'شکانەوە لەسەر داواکاری خۆی', 1503.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 15:06:44', '2025-02-05 15:06:44', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13382, NULL, 'd8f1246b-e8b9-44d1-8f17-1f3d6df0da18', 'withdrawal', 6030036.00, '2025-02-05', '15:06:44', 'شکانەوە لەسەر داواکاری خۆی', 1503.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 15:06:44', '2025-02-05 15:06:44', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13383, NULL, '31f52ffd-860b-41f9-a1d8-e40a46058519', 'withdrawal', 8636.00, '2025-02-05', '15:08:26', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 15:08:26', '2025-02-05 15:08:26', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13384, NULL, '31f52ffd-860b-41f9-a1d8-e40a46058519', 'withdrawal', 8636.00, '2025-02-05', '15:08:26', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 15:08:26', '2025-02-05 15:08:26', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13385, NULL, '31f52ffd-860b-41f9-a1d8-e40a46058519', 'deposit', 0.00, '2025-02-05', '15:08:26', 'Fee collected for withdrawal', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-05 15:08:26', '2025-02-05 15:08:26', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13386, NULL, '4e6f4ef9-8f08-4d59-90d2-fd6a05029b20', 'deposit', 4010.00, '2025-02-05', '15:09:08', NULL, 10.00, 1, 'husen sadq-shorja', NULL, NULL, NULL, NULL, '2025-02-05 15:09:08', '2025-02-05 15:09:08', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13387, NULL, '4e6f4ef9-8f08-4d59-90d2-fd6a05029b20', 'deposit', 4010.00, '2025-02-05', '15:09:08', NULL, 10.00, 1, 'husen sadq-shorja', NULL, NULL, NULL, NULL, '2025-02-05 15:09:08', '2025-02-05 15:09:08', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13388, NULL, '4e6f4ef9-8f08-4d59-90d2-fd6a05029b20', 'deposit', 10.00, '2025-02-05', '15:09:08', 'Fee collected for deposit', 0.00, 1, 'husen sadq-shorja', NULL, NULL, NULL, NULL, '2025-02-05 15:09:08', '2025-02-05 15:09:08', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13389, NULL, 'bf19c022-f607-4a67-ac99-379823a5d0e1', 'deposit', 8636.00, '2025-02-05', '15:10:42', NULL, 0.00, 1, 'm.suhl alrafeden', NULL, NULL, NULL, NULL, '2025-02-05 15:10:42', '2025-02-05 15:10:42', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13390, NULL, 'bf19c022-f607-4a67-ac99-379823a5d0e1', 'deposit', 8636.00, '2025-02-05', '15:10:42', NULL, 0.00, 1, 'm.suhl alrafeden', NULL, NULL, NULL, NULL, '2025-02-05 15:10:42', '2025-02-05 15:10:42', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13391, NULL, 'bf19c022-f607-4a67-ac99-379823a5d0e1', 'deposit', 0.00, '2025-02-05', '15:10:42', 'Fee collected for deposit', 0.00, 1, 'm.suhl alrafeden', NULL, NULL, NULL, NULL, '2025-02-05 15:10:42', '2025-02-05 15:10:42', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13392, NULL, 'a68ff8e5-7cef-4e20-aa1d-0e5f02f1905e', 'withdrawal', 10000.00, '2025-02-05', '15:12:17', NULL, 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-05 15:12:17', '2025-02-05 15:12:17', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13393, NULL, 'a68ff8e5-7cef-4e20-aa1d-0e5f02f1905e', 'withdrawal', 10000.00, '2025-02-05', '15:12:17', NULL, 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-05 15:12:17', '2025-02-05 15:12:17', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13394, NULL, 'a68ff8e5-7cef-4e20-aa1d-0e5f02f1905e', 'deposit', 0.00, '2025-02-05', '15:12:17', 'Fee collected for withdrawal', 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-05 15:12:17', '2025-02-05 15:12:17', 22, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13399, NULL, '2469a977-e4b7-46f5-a658-1d3afd31a295', 'deposit', 12015.00, '2025-02-05', '15:43:16', NULL, 15.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-05 15:43:16', '2025-02-05 15:43:16', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13400, NULL, '2469a977-e4b7-46f5-a658-1d3afd31a295', 'deposit', 12015.00, '2025-02-05', '15:43:16', NULL, 15.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-05 15:43:16', '2025-02-05 15:43:16', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13401, NULL, '2469a977-e4b7-46f5-a658-1d3afd31a295', 'deposit', 15.00, '2025-02-05', '15:43:16', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-05 15:43:16', '2025-02-05 15:43:16', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13402, NULL, '5a777989-a874-4601-9dd4-81ce6f7e5cc9', 'withdrawal', 3.00, '2025-02-05', '15:43:45', NULL, 3.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 15:43:45', '2025-02-05 15:43:45', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13403, NULL, '5a777989-a874-4601-9dd4-81ce6f7e5cc9', 'withdrawal', 3.00, '2025-02-05', '15:43:45', NULL, 3.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 15:43:45', '2025-02-05 15:43:45', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13404, NULL, '5a777989-a874-4601-9dd4-81ce6f7e5cc9', 'deposit', 3.00, '2025-02-05', '15:43:45', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-05 15:43:45', '2025-02-05 15:43:45', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13405, NULL, 'ff8bbe94-935c-44b8-a37b-d6f8e2127572', 'withdrawal', 12030.00, '2025-02-05', '15:47:48', NULL, 30.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-05 15:47:48', '2025-02-05 15:47:48', 237, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13406, NULL, 'ff8bbe94-935c-44b8-a37b-d6f8e2127572', 'withdrawal', 12030.00, '2025-02-05', '15:47:48', NULL, 30.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-05 15:47:48', '2025-02-05 15:47:48', 1, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13407, NULL, 'ff8bbe94-935c-44b8-a37b-d6f8e2127572', 'deposit', 30.00, '2025-02-05', '15:47:48', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-05 15:47:48', '2025-02-05 15:47:48', 22, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13418, NULL, '287bb797-a8ed-4086-91fc-41e394178e1c', 'deposit', 845000.00, '2025-02-05', '15:59:43', NULL, 0.00, 1, 'mustafa', NULL, NULL, NULL, NULL, '2025-02-05 15:59:43', '2025-02-05 15:59:43', 253, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13419, NULL, '287bb797-a8ed-4086-91fc-41e394178e1c', 'deposit', 845000.00, '2025-02-05', '15:59:43', NULL, 0.00, 1, 'mustafa', NULL, NULL, NULL, NULL, '2025-02-05 15:59:43', '2025-02-05 15:59:43', 2, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13420, NULL, '287bb797-a8ed-4086-91fc-41e394178e1c', 'deposit', 0.00, '2025-02-05', '15:59:43', 'Fee collected for deposit', 0.00, 1, 'mustafa', NULL, NULL, NULL, NULL, '2025-02-05 15:59:43', '2025-02-05 15:59:43', 23, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13431, NULL, '95e6ad7b-3916-4a04-9ce3-6ff38bee4079', 'deposit', 1602.00, '2025-02-05', '16:05:34', NULL, 2.00, 1, 'ASHTI AZAD-DHUK', NULL, NULL, NULL, NULL, '2025-02-05 16:05:34', '2025-02-05 16:05:34', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13432, NULL, '95e6ad7b-3916-4a04-9ce3-6ff38bee4079', 'deposit', 1602.00, '2025-02-05', '16:05:34', NULL, 2.00, 1, 'ASHTI AZAD-DHUK', NULL, NULL, NULL, NULL, '2025-02-05 16:05:34', '2025-02-05 16:05:34', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13433, NULL, '95e6ad7b-3916-4a04-9ce3-6ff38bee4079', 'deposit', 2.00, '2025-02-05', '16:05:34', 'Fee collected for deposit', 0.00, 1, 'ASHTI AZAD-DHUK', NULL, NULL, NULL, NULL, '2025-02-05 16:05:34', '2025-02-05 16:05:34', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13436, NULL, '746a2963-4db1-4045-a99a-69961a2931f2', 'withdrawal', 1604.00, '2025-02-05', '16:08:44', NULL, 4.00, 1, 'DHUK-ASHTI AZAD', NULL, NULL, NULL, NULL, '2025-02-05 16:08:44', '2025-02-05 16:08:44', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13437, NULL, '746a2963-4db1-4045-a99a-69961a2931f2', 'withdrawal', 1604.00, '2025-02-05', '16:08:44', NULL, 4.00, 1, 'DHUK-ASHTI AZAD', NULL, NULL, NULL, NULL, '2025-02-05 16:08:44', '2025-02-05 16:08:44', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13438, NULL, '746a2963-4db1-4045-a99a-69961a2931f2', 'deposit', 4.00, '2025-02-05', '16:08:44', 'Fee collected for withdrawal', 0.00, 1, 'DHUK-ASHTI AZAD', NULL, NULL, NULL, NULL, '2025-02-05 16:08:44', '2025-02-05 16:08:44', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13451, NULL, '5ac274ed-8504-4600-bf49-ae33cfe2b60f', 'withdrawal', 1604.00, '2025-02-05', '16:12:11', 'شکانەوە لەسەر داواکاری خۆی', 1504.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 16:12:11', '2025-02-05 16:12:11', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13452, NULL, '5ac274ed-8504-4600-bf49-ae33cfe2b60f', 'deposit', 1604.00, '2025-02-05', '16:12:11', 'شکانەوە لەسەر داواکاری خۆی', 1504.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 16:12:11', '2025-02-05 16:12:11', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13453, NULL, '5ac274ed-8504-4600-bf49-ae33cfe2b60f', 'deposit', 2412416.00, '2025-02-05', '16:12:11', 'شکانەوە لەسەر داواکاری خۆی', 1504.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 16:12:11', '2025-02-05 16:12:11', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13454, NULL, '5ac274ed-8504-4600-bf49-ae33cfe2b60f', 'withdrawal', 2412416.00, '2025-02-05', '16:12:11', 'شکانەوە لەسەر داواکاری خۆی', 1504.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-05 16:12:11', '2025-02-05 16:12:11', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13469, NULL, '868c2b30-afe7-4753-a1ce-254b2dcd501d', 'withdrawal', 2351434.00, '2025-02-05', '16:29:15', NULL, 0.00, 144, 'Sarf bo kak abdulla', NULL, NULL, NULL, NULL, '2025-02-05 16:29:15', '2025-02-05 16:29:15', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13470, NULL, '868c2b30-afe7-4753-a1ce-254b2dcd501d', 'withdrawal', 2351434.00, '2025-02-05', '16:29:15', NULL, 0.00, 144, 'Sarf bo kak abdulla', NULL, NULL, NULL, NULL, '2025-02-05 16:29:15', '2025-02-05 16:29:15', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13559, NULL, 'ff0fe7a8-93e9-4069-b122-6946b4399efd', 'deposit', 1000000.00, '2025-02-05', '17:50:58', NULL, 0.00, 136, 'K hemn', NULL, NULL, NULL, NULL, '2025-02-05 17:50:58', '2025-02-05 17:50:58', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13560, NULL, 'ff0fe7a8-93e9-4069-b122-6946b4399efd', 'deposit', 1000000.00, '2025-02-05', '17:50:58', NULL, 0.00, 136, 'K hemn', NULL, NULL, NULL, NULL, '2025-02-05 17:50:58', '2025-02-05 17:50:58', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13571, NULL, 'ae815c8f-e993-49c0-b613-5d68d6341f7a', 'withdrawal', 2965.00, '2025-02-05', '17:55:06', '', 0.00, 136, 'alas ahmad marhe', NULL, NULL, NULL, NULL, '2025-02-05 17:55:06', '2025-02-05 17:55:06', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13572, NULL, 'ae815c8f-e993-49c0-b613-5d68d6341f7a', 'withdrawal', 2965.00, '2025-02-05', '17:55:06', '', 0.00, 136, 'alas ahmad marhe', NULL, NULL, NULL, NULL, '2025-02-05 17:55:06', '2025-02-05 17:55:06', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13619, NULL, '123adfe6-e373-4352-866f-8897121a317c', 'deposit', 12030.00, '2025-02-05', '19:31:42', NULL, 0.00, 144, 'Kak haval', NULL, NULL, NULL, NULL, '2025-02-05 19:31:42', '2025-02-05 19:31:42', 237, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13620, NULL, '123adfe6-e373-4352-866f-8897121a317c', 'deposit', 12030.00, '2025-02-05', '19:31:42', NULL, 0.00, 144, 'Kak haval', NULL, NULL, NULL, NULL, '2025-02-05 19:31:42', '2025-02-05 19:31:42', 1, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13625, NULL, 'edec3815-c814-4bf4-90eb-3e5b64370c5e', 'deposit', 10000.00, '2025-02-05', '19:41:58', NULL, 0.00, 136, 'Hatw ba daste k hamadamen', NULL, NULL, NULL, NULL, '2025-02-05 19:41:58', '2025-02-05 19:41:58', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13626, NULL, 'edec3815-c814-4bf4-90eb-3e5b64370c5e', 'deposit', 10000.00, '2025-02-05', '19:41:58', NULL, 0.00, 136, 'Hatw ba daste k hamadamen', NULL, NULL, NULL, NULL, '2025-02-05 19:41:58', '2025-02-05 19:41:58', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13657, NULL, 'd1a483e6-20ae-459e-b7d2-5dd82ee21408', 'deposit', 7000.00, '2025-02-05', '20:03:00', NULL, 0.00, 1, 'HATW BADASTY HAJI SALM', NULL, NULL, NULL, NULL, '2025-02-05 20:03:00', '2025-02-05 20:03:00', 954, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13658, NULL, 'd1a483e6-20ae-459e-b7d2-5dd82ee21408', 'deposit', 7000.00, '2025-02-05', '20:03:00', NULL, 0.00, 1, 'HATW BADASTY HAJI SALM', NULL, NULL, NULL, NULL, '2025-02-05 20:03:00', '2025-02-05 20:03:00', 1, 954, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13659, NULL, 'd1a483e6-20ae-459e-b7d2-5dd82ee21408', 'deposit', 0.00, '2025-02-05', '20:03:00', 'Fee collected for deposit', 0.00, 1, 'HATW BADASTY HAJI SALM', NULL, NULL, NULL, NULL, '2025-02-05 20:03:00', '2025-02-05 20:03:00', 22, 954, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13726, NULL, 'f4c334ca-33b4-42cd-9afa-7a12809bd01e', 'deposit', 10150.00, '2025-02-05', '21:09:46', NULL, 0.00, 136, 'Mhamad ismail rasul', NULL, NULL, NULL, NULL, '2025-02-05 21:09:46', '2025-02-05 21:09:46', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13727, NULL, 'f4c334ca-33b4-42cd-9afa-7a12809bd01e', 'deposit', 10150.00, '2025-02-05', '21:09:46', NULL, 0.00, 136, 'Mhamad ismail rasul', NULL, NULL, NULL, NULL, '2025-02-05 21:09:46', '2025-02-05 21:09:46', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13732, NULL, 'f69ea82a-dab3-44d4-a2a9-cc2775284660', 'withdrawal', 150.00, '2025-02-05', '21:16:14', NULL, 0.00, 136, 'Mhamad ismail rasul', NULL, NULL, NULL, NULL, '2025-02-05 21:16:14', '2025-02-05 21:16:14', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13733, NULL, 'f69ea82a-dab3-44d4-a2a9-cc2775284660', 'withdrawal', 150.00, '2025-02-05', '21:16:14', NULL, 0.00, 136, 'Mhamad ismail rasul', NULL, NULL, NULL, NULL, '2025-02-05 21:16:14', '2025-02-05 21:16:14', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13868, NULL, '5c38ae7c-4cc6-49c9-82d5-68cdb59e3f52', 'withdrawal', 2.00, '2025-02-06', '10:39:34', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-06 10:39:34', '2025-02-06 10:39:34', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13869, NULL, '5c38ae7c-4cc6-49c9-82d5-68cdb59e3f52', 'withdrawal', 2.00, '2025-02-06', '10:39:34', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-06 10:39:34', '2025-02-06 10:39:34', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13870, NULL, '5c38ae7c-4cc6-49c9-82d5-68cdb59e3f52', 'deposit', 2.00, '2025-02-06', '10:39:34', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-06 10:39:34', '2025-02-06 10:39:34', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13873, NULL, 'cc241be1-c547-4657-9a9e-33c428182b45', 'withdrawal', 10000.00, '2025-02-06', '10:41:32', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-06 10:41:32', '2025-02-06 10:41:32', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13874, NULL, 'cc241be1-c547-4657-9a9e-33c428182b45', 'withdrawal', 10000.00, '2025-02-06', '10:41:32', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-06 10:41:32', '2025-02-06 10:41:32', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13875, NULL, 'cc241be1-c547-4657-9a9e-33c428182b45', 'deposit', 0.00, '2025-02-06', '10:41:32', 'Fee collected for withdrawal', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-06 10:41:32', '2025-02-06 10:41:32', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13876, NULL, '31e85d43-f1b1-44cd-b79c-deec18cdb037', 'withdrawal', 37750000.00, '2025-02-06', '10:42:45', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 10:42:45', '2025-02-06 10:42:45', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13877, NULL, '31e85d43-f1b1-44cd-b79c-deec18cdb037', 'withdrawal', 37750000.00, '2025-02-06', '10:42:45', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 10:42:45', '2025-02-06 10:42:45', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13878, NULL, '31e85d43-f1b1-44cd-b79c-deec18cdb037', 'deposit', 0.00, '2025-02-06', '10:42:45', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 10:42:45', '2025-02-06 10:42:45', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13879, NULL, '75553900-39b8-49f6-a949-38be7e855107', 'deposit', 15000.00, '2025-02-06', '10:43:19', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 10:43:19', '2025-02-06 10:43:19', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13880, NULL, '75553900-39b8-49f6-a949-38be7e855107', 'deposit', 15000.00, '2025-02-06', '10:43:19', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 10:43:19', '2025-02-06 10:43:19', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13881, NULL, '75553900-39b8-49f6-a949-38be7e855107', 'deposit', 0.00, '2025-02-06', '10:43:19', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 10:43:19', '2025-02-06 10:43:19', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13882, NULL, 'ff6dcc3e-711c-4ce6-88aa-9fa2ffb08224', 'deposit', 35000.00, '2025-02-06', '10:44:10', 'شکانەوە لەسەر داواکاری خۆی', 1504.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-06 10:44:10', '2025-02-06 10:44:10', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13883, NULL, 'ff6dcc3e-711c-4ce6-88aa-9fa2ffb08224', 'withdrawal', 35000.00, '2025-02-06', '10:44:10', 'شکانەوە لەسەر داواکاری خۆی', 1504.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-06 10:44:10', '2025-02-06 10:44:10', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(13884, NULL, 'ff6dcc3e-711c-4ce6-88aa-9fa2ffb08224', 'withdrawal', 52640000.00, '2025-02-06', '10:44:10', 'شکانەوە لەسەر داواکاری خۆی', 1504.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-06 10:44:10', '2025-02-06 10:44:10', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13885, NULL, 'ff6dcc3e-711c-4ce6-88aa-9fa2ffb08224', 'deposit', 52640000.00, '2025-02-06', '10:44:10', 'شکانەوە لەسەر داواکاری خۆی', 1504.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-06 10:44:10', '2025-02-06 10:44:10', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13886, NULL, 'b4ff51da-6481-48d6-8187-3a4f713dc94a', 'deposit', 12496.00, '2025-02-06', '10:44:55', NULL, 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-06 10:44:55', '2025-02-06 10:44:55', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13887, NULL, 'b4ff51da-6481-48d6-8187-3a4f713dc94a', 'deposit', 12496.00, '2025-02-06', '10:44:55', NULL, 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-06 10:44:55', '2025-02-06 10:44:55', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13888, NULL, 'b4ff51da-6481-48d6-8187-3a4f713dc94a', 'deposit', 0.00, '2025-02-06', '10:44:55', 'Fee collected for deposit', 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-06 10:44:55', '2025-02-06 10:44:55', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13909, NULL, '19c3d938-b36a-4741-829f-8a833e9a78c9', 'withdrawal', 12496.00, '2025-02-06', '11:05:41', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-06 11:05:41', '2025-02-06 11:05:41', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13910, NULL, '19c3d938-b36a-4741-829f-8a833e9a78c9', 'withdrawal', 12496.00, '2025-02-06', '11:05:41', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-06 11:05:41', '2025-02-06 11:05:41', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13911, NULL, '19c3d938-b36a-4741-829f-8a833e9a78c9', 'deposit', 0.00, '2025-02-06', '11:05:41', 'Fee collected for withdrawal', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-06 11:05:41', '2025-02-06 11:05:41', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13914, NULL, '99c14ddd-1f39-4491-b0b9-2580771f4d72', 'withdrawal', 1058500.00, '2025-02-06', '11:08:33', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 11:08:33', '2025-02-06 11:08:33', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13915, NULL, '99c14ddd-1f39-4491-b0b9-2580771f4d72', 'withdrawal', 1058500.00, '2025-02-06', '11:08:33', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 11:08:33', '2025-02-06 11:08:33', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13916, NULL, '99c14ddd-1f39-4491-b0b9-2580771f4d72', 'deposit', 1500.00, '2025-02-06', '11:08:33', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 11:08:33', '2025-02-06 11:08:33', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13926, NULL, '6ad75485-7263-4ecd-929e-3baa00e4c244', 'deposit', 6500000.00, '2025-02-06', '11:26:24', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-06 11:26:24', '2025-02-06 11:26:24', 284, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13927, NULL, '6ad75485-7263-4ecd-929e-3baa00e4c244', 'deposit', 6500000.00, '2025-02-06', '11:26:24', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-06 11:26:24', '2025-02-06 11:26:24', 2, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13928, NULL, '6ad75485-7263-4ecd-929e-3baa00e4c244', 'deposit', 0.00, '2025-02-06', '11:26:24', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-06 11:26:24', '2025-02-06 11:26:24', 23, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13929, NULL, 'e434decb-2f29-42c2-9213-699b9c6b53a7', 'deposit', 26500.00, '2025-02-06', '11:26:25', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-06 11:26:25', '2025-02-06 11:26:25', 283, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13930, NULL, 'e434decb-2f29-42c2-9213-699b9c6b53a7', 'deposit', 26500.00, '2025-02-06', '11:26:25', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-06 11:26:25', '2025-02-06 11:26:25', 1, 283, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13931, NULL, 'e434decb-2f29-42c2-9213-699b9c6b53a7', 'deposit', 0.00, '2025-02-06', '11:26:25', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-06 11:26:25', '2025-02-06 11:26:25', 22, 283, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13936, NULL, '61d2f9ec-638a-4931-b4cc-8abddcc49baf', 'withdrawal', 100500000.00, '2025-02-06', '11:52:15', NULL, 0.00, 144, 'Sarf m.borsa eskan', NULL, NULL, NULL, NULL, '2025-02-06 11:52:15', '2025-02-06 11:52:15', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(13937, NULL, '61d2f9ec-638a-4931-b4cc-8abddcc49baf', 'withdrawal', 100500000.00, '2025-02-06', '11:52:15', NULL, 0.00, 144, 'Sarf m.borsa eskan', NULL, NULL, NULL, NULL, '2025-02-06 11:52:15', '2025-02-06 11:52:15', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14002, NULL, '284e6eba-5baa-404a-9a4e-68ac2f33c921', 'withdrawal', 4006000.00, '2025-02-06', '13:20:10', NULL, 6000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:10', '2025-02-06 13:20:10', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14003, NULL, '284e6eba-5baa-404a-9a4e-68ac2f33c921', 'withdrawal', 4006000.00, '2025-02-06', '13:20:10', NULL, 6000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:10', '2025-02-06 13:20:10', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14004, NULL, '284e6eba-5baa-404a-9a4e-68ac2f33c921', 'deposit', 6000.00, '2025-02-06', '13:20:10', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:10', '2025-02-06 13:20:10', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14005, NULL, 'b1a37a3d-6bcc-41c0-a962-e8fedc34e74b', 'withdrawal', 301000.00, '2025-02-06', '13:20:36', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:36', '2025-02-06 13:20:36', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14006, NULL, 'b1a37a3d-6bcc-41c0-a962-e8fedc34e74b', 'withdrawal', 301000.00, '2025-02-06', '13:20:36', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:36', '2025-02-06 13:20:36', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14007, NULL, 'b1a37a3d-6bcc-41c0-a962-e8fedc34e74b', 'deposit', 1000.00, '2025-02-06', '13:20:36', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:36', '2025-02-06 13:20:36', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14008, NULL, '8a7ebddc-26b4-4150-ae9b-7dc67ee48918', 'withdrawal', 2003000.00, '2025-02-06', '13:20:55', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:55', '2025-02-06 13:20:55', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14009, NULL, '8a7ebddc-26b4-4150-ae9b-7dc67ee48918', 'withdrawal', 2003000.00, '2025-02-06', '13:20:55', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:55', '2025-02-06 13:20:55', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14010, NULL, '8a7ebddc-26b4-4150-ae9b-7dc67ee48918', 'deposit', 3000.00, '2025-02-06', '13:20:55', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 13:20:55', '2025-02-06 13:20:55', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14011, NULL, 'ab80f4d3-67ce-4d76-a0fc-2bd87ed61331', 'withdrawal', 10000000.00, '2025-02-06', '13:21:10', NULL, 0.00, 132, 'Shkur sleman ibrahem', NULL, NULL, NULL, NULL, '2025-02-06 13:21:10', '2025-02-06 13:21:10', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14012, NULL, 'ab80f4d3-67ce-4d76-a0fc-2bd87ed61331', 'withdrawal', 10000000.00, '2025-02-06', '13:21:10', NULL, 0.00, 132, 'Shkur sleman ibrahem', NULL, NULL, NULL, NULL, '2025-02-06 13:21:11', '2025-02-06 13:21:11', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14015, NULL, '3f9978ba-fce2-47e8-87f1-063c61dc1ec4', 'deposit', 1550.00, '2025-02-06', '13:31:16', NULL, 0.00, 144, 'Aram', NULL, NULL, NULL, NULL, '2025-02-06 13:31:16', '2025-02-06 13:31:16', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14016, NULL, '3f9978ba-fce2-47e8-87f1-063c61dc1ec4', 'deposit', 1550.00, '2025-02-06', '13:31:16', NULL, 0.00, 144, 'Aram', NULL, NULL, NULL, NULL, '2025-02-06 13:31:16', '2025-02-06 13:31:16', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14075, NULL, 'c4534556-ce99-4486-b1f5-b57ededb23c1', 'deposit', 20000.00, '2025-02-06', '14:58:03', NULL, 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-06 14:58:03', '2025-02-06 14:58:03', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14076, NULL, 'c4534556-ce99-4486-b1f5-b57ededb23c1', 'deposit', 20000.00, '2025-02-06', '14:58:03', NULL, 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-06 14:58:03', '2025-02-06 14:58:03', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14077, NULL, 'c4534556-ce99-4486-b1f5-b57ededb23c1', 'deposit', 0.00, '2025-02-06', '14:58:03', 'Fee collected for deposit', 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-06 14:58:03', '2025-02-06 14:58:03', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14078, NULL, 'd14ab936-5aae-4e68-a73b-1b48a9bfe8b1', 'withdrawal', 3331.00, '2025-02-06', '14:58:20', NULL, 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-06 14:58:20', '2025-02-06 14:58:20', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14079, NULL, 'd14ab936-5aae-4e68-a73b-1b48a9bfe8b1', 'withdrawal', 3331.00, '2025-02-06', '14:58:20', NULL, 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-06 14:58:20', '2025-02-06 14:58:20', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14080, NULL, 'd14ab936-5aae-4e68-a73b-1b48a9bfe8b1', 'deposit', 0.00, '2025-02-06', '14:58:20', 'Fee collected for withdrawal', 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-06 14:58:20', '2025-02-06 14:58:20', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14081, NULL, '4f55ad02-9ff4-4f16-b25c-89d4cd492317', 'withdrawal', 550.00, '2025-02-06', '15:00:03', NULL, 0.00, 1, 'shamal', NULL, NULL, NULL, NULL, '2025-02-06 15:00:03', '2025-02-06 15:00:03', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14082, NULL, '4f55ad02-9ff4-4f16-b25c-89d4cd492317', 'withdrawal', 550.00, '2025-02-06', '15:00:03', NULL, 0.00, 1, 'shamal', NULL, NULL, NULL, NULL, '2025-02-06 15:00:03', '2025-02-06 15:00:03', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14083, NULL, '4f55ad02-9ff4-4f16-b25c-89d4cd492317', 'deposit', 0.00, '2025-02-06', '15:00:03', 'Fee collected for withdrawal', 0.00, 1, 'shamal', NULL, NULL, NULL, NULL, '2025-02-06 15:00:03', '2025-02-06 15:00:03', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14084, NULL, '62a94d0c-72b9-4e63-875e-5bccbf9debd1', 'withdrawal', 12.00, '2025-02-06', '15:00:22', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-06 15:00:22', '2025-02-06 15:00:22', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14085, NULL, '62a94d0c-72b9-4e63-875e-5bccbf9debd1', 'withdrawal', 12.00, '2025-02-06', '15:00:22', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-06 15:00:22', '2025-02-06 15:00:22', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14086, NULL, '62a94d0c-72b9-4e63-875e-5bccbf9debd1', 'deposit', 0.00, '2025-02-06', '15:00:22', 'Fee collected for withdrawal', 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-06 15:00:22', '2025-02-06 15:00:22', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14137, NULL, 'abc2161a-cd64-4f37-8e16-23231799c7f0', 'deposit', 235.00, '2025-02-06', '15:54:21', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-06 15:54:21', '2025-02-06 15:54:21', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14138, NULL, 'abc2161a-cd64-4f37-8e16-23231799c7f0', 'deposit', 235.00, '2025-02-06', '15:54:21', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-06 15:54:21', '2025-02-06 15:54:21', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14139, NULL, 'abc2161a-cd64-4f37-8e16-23231799c7f0', 'deposit', 0.00, '2025-02-06', '15:54:21', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-06 15:54:21', '2025-02-06 15:54:21', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14140, NULL, 'd2992cb4-b7d1-4ae3-a298-2df343617dda', 'withdrawal', 4333.00, '2025-02-06', '15:55:41', NULL, 0.00, 1, 'shayda mahmud', NULL, NULL, NULL, NULL, '2025-02-06 15:55:41', '2025-02-06 15:55:41', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14141, NULL, 'd2992cb4-b7d1-4ae3-a298-2df343617dda', 'withdrawal', 4333.00, '2025-02-06', '15:55:41', NULL, 0.00, 1, 'shayda mahmud', NULL, NULL, NULL, NULL, '2025-02-06 15:55:41', '2025-02-06 15:55:41', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14142, NULL, 'd2992cb4-b7d1-4ae3-a298-2df343617dda', 'deposit', 0.00, '2025-02-06', '15:55:41', 'Fee collected for withdrawal', 0.00, 1, 'shayda mahmud', NULL, NULL, NULL, NULL, '2025-02-06 15:55:41', '2025-02-06 15:55:41', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14143, NULL, 'a76f4398-f0f5-4866-8c52-ff8ee8697b18', 'deposit', 45045000.00, '2025-02-06', '16:01:33', NULL, 0.00, 1, 'abdulla', NULL, NULL, NULL, NULL, '2025-02-06 16:01:33', '2025-02-06 16:01:33', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14144, NULL, 'a76f4398-f0f5-4866-8c52-ff8ee8697b18', 'deposit', 45045000.00, '2025-02-06', '16:01:33', NULL, 0.00, 1, 'abdulla', NULL, NULL, NULL, NULL, '2025-02-06 16:01:33', '2025-02-06 16:01:33', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14145, NULL, 'a76f4398-f0f5-4866-8c52-ff8ee8697b18', 'deposit', 0.00, '2025-02-06', '16:01:33', 'Fee collected for deposit', 0.00, 1, 'abdulla', NULL, NULL, NULL, NULL, '2025-02-06 16:01:33', '2025-02-06 16:01:33', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14146, NULL, '44dc961c-dad6-4272-9c4f-96bc17227037', 'withdrawal', 9009000.00, '2025-02-06', '16:02:09', NULL, 9000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:02:09', '2025-02-06 16:02:09', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14147, NULL, '44dc961c-dad6-4272-9c4f-96bc17227037', 'withdrawal', 9009000.00, '2025-02-06', '16:02:09', NULL, 9000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:02:09', '2025-02-06 16:02:09', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14148, NULL, '44dc961c-dad6-4272-9c4f-96bc17227037', 'deposit', 9000.00, '2025-02-06', '16:02:09', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:02:09', '2025-02-06 16:02:09', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14153, NULL, 'f81b11f4-5efa-4a43-9041-4180b0dbbbd0', 'withdrawal', 18018000.00, '2025-02-06', '16:03:00', NULL, 18000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:03:00', '2025-02-06 16:03:00', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14154, NULL, 'f81b11f4-5efa-4a43-9041-4180b0dbbbd0', 'withdrawal', 18018000.00, '2025-02-06', '16:03:00', NULL, 18000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:03:00', '2025-02-06 16:03:00', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14155, NULL, 'f81b11f4-5efa-4a43-9041-4180b0dbbbd0', 'deposit', 18000.00, '2025-02-06', '16:03:00', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:03:00', '2025-02-06 16:03:00', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14160, NULL, '1fe7afd8-332a-4f4b-8c31-a09f46442647', 'deposit', 50000000.00, '2025-02-06', '16:03:27', NULL, 0.00, 1, 'tafrex', NULL, NULL, NULL, NULL, '2025-02-06 16:03:27', '2025-02-06 16:03:27', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14161, NULL, '1fe7afd8-332a-4f4b-8c31-a09f46442647', 'deposit', 50000000.00, '2025-02-06', '16:03:27', NULL, 0.00, 1, 'tafrex', NULL, NULL, NULL, NULL, '2025-02-06 16:03:27', '2025-02-06 16:03:27', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14162, NULL, '1fe7afd8-332a-4f4b-8c31-a09f46442647', 'deposit', 0.00, '2025-02-06', '16:03:27', 'Fee collected for deposit', 0.00, 1, 'tafrex', NULL, NULL, NULL, NULL, '2025-02-06 16:03:27', '2025-02-06 16:03:27', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14163, NULL, 'c5ced7b2-0c50-43e1-b98f-ffb66865472d', 'withdrawal', 18018000.00, '2025-02-06', '16:03:48', NULL, 18000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:03:48', '2025-02-06 16:03:48', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14164, NULL, 'c5ced7b2-0c50-43e1-b98f-ffb66865472d', 'withdrawal', 18018000.00, '2025-02-06', '16:03:48', NULL, 18000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:03:48', '2025-02-06 16:03:48', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14165, NULL, 'c5ced7b2-0c50-43e1-b98f-ffb66865472d', 'deposit', 18000.00, '2025-02-06', '16:03:48', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:03:48', '2025-02-06 16:03:48', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14166, NULL, '850fecd2-1db0-4ceb-991f-5b0033919ab4', 'deposit', 50000000.00, '2025-02-06', '16:04:57', NULL, 0.00, 1, 'abdulla', NULL, NULL, NULL, NULL, '2025-02-06 16:04:57', '2025-02-06 16:04:57', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14167, NULL, '850fecd2-1db0-4ceb-991f-5b0033919ab4', 'deposit', 50000000.00, '2025-02-06', '16:04:57', NULL, 0.00, 1, 'abdulla', NULL, NULL, NULL, NULL, '2025-02-06 16:04:57', '2025-02-06 16:04:57', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14168, NULL, '850fecd2-1db0-4ceb-991f-5b0033919ab4', 'deposit', 0.00, '2025-02-06', '16:04:57', 'Fee collected for deposit', 0.00, 1, 'abdulla', NULL, NULL, NULL, NULL, '2025-02-06 16:04:57', '2025-02-06 16:04:57', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14169, NULL, '9577f67c-9845-405b-bf84-7a4a651951f6', 'withdrawal', 20000000.00, '2025-02-06', '16:05:16', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:05:16', '2025-02-06 16:05:16', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14170, NULL, '9577f67c-9845-405b-bf84-7a4a651951f6', 'withdrawal', 20000000.00, '2025-02-06', '16:05:16', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:05:16', '2025-02-06 16:05:16', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14171, NULL, '9577f67c-9845-405b-bf84-7a4a651951f6', 'deposit', 0.00, '2025-02-06', '16:05:16', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:05:16', '2025-02-06 16:05:16', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14172, NULL, 'fa5102a3-314c-4b26-919e-93eaa45ec87b', 'withdrawal', 30000000.00, '2025-02-06', '16:05:39', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:05:39', '2025-02-06 16:05:39', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14173, NULL, 'fa5102a3-314c-4b26-919e-93eaa45ec87b', 'withdrawal', 30000000.00, '2025-02-06', '16:05:39', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:05:39', '2025-02-06 16:05:39', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14174, NULL, 'fa5102a3-314c-4b26-919e-93eaa45ec87b', 'deposit', 0.00, '2025-02-06', '16:05:39', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-06 16:05:39', '2025-02-06 16:05:39', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14177, NULL, '2c818836-e825-4f9a-aaec-04d5561c0116', 'withdrawal', 100500000.00, '2025-02-06', '16:10:11', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 16:10:11', '2025-02-06 16:10:11', 1096, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14178, NULL, '2c818836-e825-4f9a-aaec-04d5561c0116', 'withdrawal', 100500000.00, '2025-02-06', '16:10:11', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 16:10:11', '2025-02-06 16:10:11', 2, 1096, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14179, NULL, '2c818836-e825-4f9a-aaec-04d5561c0116', 'deposit', 0.00, '2025-02-06', '16:10:11', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-06 16:10:11', '2025-02-06 16:10:11', 23, 1096, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14187, NULL, 'eabcfd8b-4cc8-49a1-b23a-78556f018b8a', 'deposit', 100500000.00, '2025-02-06', '16:16:53', NULL, 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-06 16:16:53', '2025-02-06 16:16:53', 1096, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14188, NULL, 'eabcfd8b-4cc8-49a1-b23a-78556f018b8a', 'deposit', 100500000.00, '2025-02-06', '16:16:53', NULL, 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-06 16:16:53', '2025-02-06 16:16:53', 2, 1096, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14189, NULL, 'eabcfd8b-4cc8-49a1-b23a-78556f018b8a', 'deposit', 0.00, '2025-02-06', '16:16:53', 'Fee collected for deposit', 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-06 16:16:53', '2025-02-06 16:16:53', 23, 1096, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14194, NULL, '6f23c4a2-6f99-4092-97a6-b085f81ef6f0', 'deposit', 4333.00, '2025-02-06', '16:19:11', NULL, 0.00, 1, 'shayda mahmud', NULL, NULL, NULL, NULL, '2025-02-06 16:19:11', '2025-02-06 16:19:11', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14195, NULL, '6f23c4a2-6f99-4092-97a6-b085f81ef6f0', 'deposit', 4333.00, '2025-02-06', '16:19:11', NULL, 0.00, 1, 'shayda mahmud', NULL, NULL, NULL, NULL, '2025-02-06 16:19:11', '2025-02-06 16:19:11', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14196, NULL, '6f23c4a2-6f99-4092-97a6-b085f81ef6f0', 'deposit', 0.00, '2025-02-06', '16:19:11', 'Fee collected for deposit', 0.00, 1, 'shayda mahmud', NULL, NULL, NULL, NULL, '2025-02-06 16:19:11', '2025-02-06 16:19:11', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14217, NULL, 'cf663b8e-e743-40a2-8cd4-8498486ff9bc', 'withdrawal', 2076250.00, '2025-02-06', '16:37:58', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 16:37:58', '2025-02-06 16:37:58', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14218, NULL, 'cf663b8e-e743-40a2-8cd4-8498486ff9bc', 'withdrawal', 2076250.00, '2025-02-06', '16:37:58', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 16:37:58', '2025-02-06 16:37:58', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14219, NULL, 'cf663b8e-e743-40a2-8cd4-8498486ff9bc', 'deposit', 3250.00, '2025-02-06', '16:37:58', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-06 16:37:58', '2025-02-06 16:37:58', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14470, NULL, 'ced9fbc1-0dfc-4ace-8129-17d51620ced2', 'deposit', 5000.00, '2025-02-08', '10:01:43', NULL, 0.00, 136, 'sardar salh abdulla ', NULL, NULL, NULL, NULL, '2025-02-08 10:01:43', '2025-02-08 10:01:43', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14471, NULL, 'ced9fbc1-0dfc-4ace-8129-17d51620ced2', 'deposit', 5000.00, '2025-02-08', '10:01:43', NULL, 0.00, 136, 'sardar salh abdulla ', NULL, NULL, NULL, NULL, '2025-02-08 10:01:43', '2025-02-08 10:01:43', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14488, NULL, '1f0191bf-7eeb-43be-894c-492d28230882', 'withdrawal', 44494758.00, '2025-02-08', '10:33:58', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, '2025-02-08 10:33:58', '2025-02-08 10:33:58', 69, 475, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14489, NULL, '1f0191bf-7eeb-43be-894c-492d28230882', 'deposit', 44494758.00, '2025-02-08', '10:33:58', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, '2025-02-08 10:33:58', '2025-02-08 10:33:58', 475, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14748, NULL, 'ae2f4c75-d716-450f-8c1f-477bbce646a1', 'deposit', 13400.00, '2025-02-08', '16:41:02', NULL, 0.00, 132, 'Ahmed pstewan xurshed', NULL, NULL, NULL, NULL, '2025-02-08 16:41:02', '2025-02-08 16:41:02', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14749, NULL, 'ae2f4c75-d716-450f-8c1f-477bbce646a1', 'deposit', 13400.00, '2025-02-08', '16:41:02', NULL, 0.00, 132, 'Ahmed pstewan xurshed', NULL, NULL, NULL, NULL, '2025-02-08 16:41:02', '2025-02-08 16:41:02', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14810, NULL, '5a18dfca-09e3-41a8-90a5-f763953c7f10', 'deposit', 3600.00, '2025-02-08', '17:39:16', NULL, 0.00, 136, 'Ahmad pshtewan khurshid', NULL, NULL, NULL, NULL, '2025-02-08 17:39:16', '2025-02-08 17:39:16', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14811, NULL, '5a18dfca-09e3-41a8-90a5-f763953c7f10', 'deposit', 3600.00, '2025-02-08', '17:39:16', NULL, 0.00, 136, 'Ahmad pshtewan khurshid', NULL, NULL, NULL, NULL, '2025-02-08 17:39:16', '2025-02-08 17:39:16', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14874, NULL, '18343f28-03f2-49aa-8a28-3b3fc400cc2c', 'deposit', 20000.00, '2025-02-08', '18:20:31', NULL, 0.00, 136, 'Kak karwan', NULL, NULL, NULL, NULL, '2025-02-08 18:20:31', '2025-02-08 18:20:31', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14875, NULL, '18343f28-03f2-49aa-8a28-3b3fc400cc2c', 'deposit', 20000.00, '2025-02-08', '18:20:31', NULL, 0.00, 136, 'Kak karwan', NULL, NULL, NULL, NULL, '2025-02-08 18:20:31', '2025-02-08 18:20:31', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14980, NULL, '6bb04386-0917-4c77-a45b-62bc60c7044b', 'deposit', 16990000.00, '2025-02-08', '20:16:32', NULL, 0.00, 1, 'hozan', NULL, NULL, NULL, NULL, '2025-02-08 20:16:32', '2025-02-08 20:16:32', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14981, NULL, '6bb04386-0917-4c77-a45b-62bc60c7044b', 'deposit', 16990000.00, '2025-02-08', '20:16:32', NULL, 0.00, 1, 'hozan', NULL, NULL, NULL, NULL, '2025-02-08 20:16:32', '2025-02-08 20:16:32', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14982, NULL, '6bb04386-0917-4c77-a45b-62bc60c7044b', 'deposit', 0.00, '2025-02-08', '20:16:32', 'Fee collected for deposit', 0.00, 1, 'hozan', NULL, NULL, NULL, NULL, '2025-02-08 20:16:32', '2025-02-08 20:16:32', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14985, NULL, 'c3b576b3-5538-47c9-ae11-bd45820f28eb', 'withdrawal', 50000000.00, '2025-02-08', '20:18:31', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 20:18:31', '2025-02-08 20:18:31', 1094, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(14986, NULL, 'c3b576b3-5538-47c9-ae11-bd45820f28eb', 'withdrawal', 50000000.00, '2025-02-08', '20:18:31', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 20:18:31', '2025-02-08 20:18:31', 2, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14987, NULL, 'c3b576b3-5538-47c9-ae11-bd45820f28eb', 'deposit', 0.00, '2025-02-08', '20:18:31', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 20:18:31', '2025-02-08 20:18:31', 23, 1094, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14990, NULL, '1a08752b-aab6-44d7-941a-525311dedac2', 'deposit', 64986.00, '2025-02-08', '20:21:05', 'shadda 112$', -736.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-08 20:21:05', '2025-02-08 20:21:05', 221, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14991, NULL, '1a08752b-aab6-44d7-941a-525311dedac2', 'deposit', 64986.00, '2025-02-08', '20:21:05', 'shadda 112$', -736.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-08 20:21:05', '2025-02-08 20:21:05', 1, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14992, NULL, '1a08752b-aab6-44d7-941a-525311dedac2', 'deposit', -736.00, '2025-02-08', '20:21:05', 'Fee collected for deposit', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-08 20:21:05', '2025-02-08 20:21:05', 22, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(14999, NULL, '603b09fb-2b74-460f-8b1b-92b4a30b9c44', 'deposit', 64986.00, '2025-02-08', '20:22:11', 'شکانەوە لەسەر داواکاری خۆی', 1500.75, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-08 20:22:11', '2025-02-08 20:22:11', 1, 221, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15000, NULL, '603b09fb-2b74-460f-8b1b-92b4a30b9c44', 'withdrawal', 64986.00, '2025-02-08', '20:22:11', 'شکانەوە لەسەر داواکاری خۆی', 1500.75, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-08 20:22:11', '2025-02-08 20:22:11', 221, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15001, NULL, '603b09fb-2b74-460f-8b1b-92b4a30b9c44', 'withdrawal', 97527739.50, '2025-02-08', '20:22:11', 'شکانەوە لەسەر داواکاری خۆی', 1500.75, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-08 20:22:11', '2025-02-08 20:22:11', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15002, NULL, '603b09fb-2b74-460f-8b1b-92b4a30b9c44', 'deposit', 97527739.50, '2025-02-08', '20:22:11', 'شکانەوە لەسەر داواکاری خۆی', 1500.75, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-08 20:22:11', '2025-02-08 20:22:11', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15007, NULL, 'a614e210-8646-4c71-a40d-e860be9b5708', 'withdrawal', 501500.00, '2025-02-08', '20:25:59', NULL, 1500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-08 20:25:59', '2025-02-08 20:25:59', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15008, NULL, 'a614e210-8646-4c71-a40d-e860be9b5708', 'withdrawal', 501500.00, '2025-02-08', '20:25:59', NULL, 1500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-08 20:25:59', '2025-02-08 20:25:59', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15009, NULL, 'a614e210-8646-4c71-a40d-e860be9b5708', 'deposit', 1500.00, '2025-02-08', '20:25:59', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-08 20:25:59', '2025-02-08 20:25:59', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15010, NULL, '959b9d28-204c-42ae-9cf1-bdef02449026', 'withdrawal', 1003000.00, '2025-02-08', '20:26:22', NULL, 3000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-08 20:26:22', '2025-02-08 20:26:22', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15011, NULL, '959b9d28-204c-42ae-9cf1-bdef02449026', 'withdrawal', 1003000.00, '2025-02-08', '20:26:22', NULL, 3000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-08 20:26:22', '2025-02-08 20:26:22', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15012, NULL, '959b9d28-204c-42ae-9cf1-bdef02449026', 'deposit', 3000.00, '2025-02-08', '20:26:22', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-08 20:26:22', '2025-02-08 20:26:22', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15021, NULL, '01b223d0-f2a9-4c53-ac8d-e045ad7d18cc', 'deposit', 23.00, '2025-02-08', '20:32:39', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-08 20:32:39', '2025-02-08 20:32:39', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15022, NULL, '01b223d0-f2a9-4c53-ac8d-e045ad7d18cc', 'deposit', 23.00, '2025-02-08', '20:32:39', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-08 20:32:39', '2025-02-08 20:32:39', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15023, NULL, '01b223d0-f2a9-4c53-ac8d-e045ad7d18cc', 'deposit', 0.00, '2025-02-08', '20:32:39', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-08 20:32:39', '2025-02-08 20:32:39', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15036, NULL, 'd5ed6cbc-62b4-4f01-9902-d27f8860a0fe', 'withdrawal', 1710750.00, '2025-02-08', '20:38:28', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-08 20:38:28', '2025-02-08 20:38:28', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15037, NULL, 'd5ed6cbc-62b4-4f01-9902-d27f8860a0fe', 'withdrawal', 1710750.00, '2025-02-08', '20:38:28', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-08 20:38:28', '2025-02-08 20:38:28', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15038, NULL, 'd5ed6cbc-62b4-4f01-9902-d27f8860a0fe', 'deposit', 4000.00, '2025-02-08', '20:38:28', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-08 20:38:28', '2025-02-08 20:38:28', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15039, NULL, '098e93ad-5f3b-453e-b53f-b9927b72ae5b', 'withdrawal', 1250.00, '2025-02-08', '20:39:11', NULL, 1250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-08 20:39:11', '2025-02-08 20:39:11', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15040, NULL, '098e93ad-5f3b-453e-b53f-b9927b72ae5b', 'withdrawal', 1250.00, '2025-02-08', '20:39:11', NULL, 1250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-08 20:39:11', '2025-02-08 20:39:11', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15041, NULL, '098e93ad-5f3b-453e-b53f-b9927b72ae5b', 'deposit', 1250.00, '2025-02-08', '20:39:11', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-08 20:39:11', '2025-02-08 20:39:11', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15044, NULL, '9963fa5b-9dc9-4e1b-a794-323c871aeffe', 'withdrawal', 1403250.00, '2025-02-08', '20:40:41', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-08 20:40:41', '2025-02-08 20:40:41', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15045, NULL, '9963fa5b-9dc9-4e1b-a794-323c871aeffe', 'withdrawal', 1403250.00, '2025-02-08', '20:40:41', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-08 20:40:41', '2025-02-08 20:40:41', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15046, NULL, '9963fa5b-9dc9-4e1b-a794-323c871aeffe', 'deposit', 3250.00, '2025-02-08', '20:40:41', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-08 20:40:41', '2025-02-08 20:40:41', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15047, NULL, '77a8d34d-c8be-4f6a-8534-bc07612f3766', 'withdrawal', 250.00, '2025-02-08', '20:41:06', NULL, 250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-08 20:41:06', '2025-02-08 20:41:06', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15048, NULL, '77a8d34d-c8be-4f6a-8534-bc07612f3766', 'withdrawal', 250.00, '2025-02-08', '20:41:06', NULL, 250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-08 20:41:06', '2025-02-08 20:41:06', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15049, NULL, '77a8d34d-c8be-4f6a-8534-bc07612f3766', 'deposit', 250.00, '2025-02-08', '20:41:06', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-08 20:41:06', '2025-02-08 20:41:06', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15089, NULL, 'd6b4867a-c34e-4d7a-885a-c67820e8d7d1', 'withdrawal', 64986.00, '2025-02-08', '21:30:23', NULL, -736.00, 1, 'drhm', NULL, NULL, NULL, NULL, '2025-02-08 21:30:23', '2025-02-08 21:30:23', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15090, NULL, 'd6b4867a-c34e-4d7a-885a-c67820e8d7d1', 'withdrawal', 64986.00, '2025-02-08', '21:30:23', NULL, -736.00, 1, 'drhm', NULL, NULL, NULL, NULL, '2025-02-08 21:30:23', '2025-02-08 21:30:23', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15091, NULL, 'd6b4867a-c34e-4d7a-885a-c67820e8d7d1', 'deposit', -736.00, '2025-02-08', '21:30:23', 'Fee collected for withdrawal', 0.00, 1, 'drhm', NULL, NULL, NULL, NULL, '2025-02-08 21:30:23', '2025-02-08 21:30:23', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15095, NULL, 'd9fdc944-6765-48d9-92ae-d5fb5f37e100', 'deposit', 100625000.00, '2025-02-08', '21:32:20', NULL, 0.00, 1, 'twana sherzad nuri', NULL, NULL, NULL, NULL, '2025-02-08 21:32:20', '2025-02-08 21:32:20', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15096, NULL, 'd9fdc944-6765-48d9-92ae-d5fb5f37e100', 'deposit', 100625000.00, '2025-02-08', '21:32:20', NULL, 0.00, 1, 'twana sherzad nuri', NULL, NULL, NULL, NULL, '2025-02-08 21:32:20', '2025-02-08 21:32:20', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15097, NULL, 'd9fdc944-6765-48d9-92ae-d5fb5f37e100', 'deposit', 0.00, '2025-02-08', '21:32:20', 'Fee collected for deposit', 0.00, 1, 'twana sherzad nuri', NULL, NULL, NULL, NULL, '2025-02-08 21:32:20', '2025-02-08 21:32:20', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15098, NULL, 'c8ebf2cb-db99-47bb-9e75-962a595ed8a9', 'withdrawal', 64986.00, '2025-02-08', '21:32:58', 'شکانەوە لەسەر داواکاری خۆی', 1501.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-08 21:32:58', '2025-02-08 21:32:58', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15099, NULL, 'c8ebf2cb-db99-47bb-9e75-962a595ed8a9', 'deposit', 64986.00, '2025-02-08', '21:32:58', 'شکانەوە لەسەر داواکاری خۆی', 1501.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-08 21:32:58', '2025-02-08 21:32:58', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15100, NULL, 'c8ebf2cb-db99-47bb-9e75-962a595ed8a9', 'deposit', 97560232.50, '2025-02-08', '21:32:58', 'شکانەوە لەسەر داواکاری خۆی', 1501.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-08 21:32:58', '2025-02-08 21:32:58', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15101, NULL, 'c8ebf2cb-db99-47bb-9e75-962a595ed8a9', 'withdrawal', 97560232.50, '2025-02-08', '21:32:58', 'شکانەوە لەسەر داواکاری خۆی', 1501.25, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-08 21:32:58', '2025-02-08 21:32:58', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15102, NULL, '5fb68722-3b86-40bb-a8f3-e5f6b5396a50', 'deposit', 1870.00, '2025-02-08', '21:33:39', NULL, 20.00, 1, 'dubai hsab', NULL, NULL, NULL, NULL, '2025-02-08 21:33:39', '2025-02-08 21:33:39', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15103, NULL, '5fb68722-3b86-40bb-a8f3-e5f6b5396a50', 'deposit', 1870.00, '2025-02-08', '21:33:39', NULL, 20.00, 1, 'dubai hsab', NULL, NULL, NULL, NULL, '2025-02-08 21:33:39', '2025-02-08 21:33:39', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15104, NULL, '5fb68722-3b86-40bb-a8f3-e5f6b5396a50', 'deposit', 20.00, '2025-02-08', '21:33:39', 'Fee collected for deposit', 0.00, 1, 'dubai hsab', NULL, NULL, NULL, NULL, '2025-02-08 21:33:39', '2025-02-08 21:33:39', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15105, NULL, '23b8f649-49bb-4b4a-8676-707d70f99d17', 'withdrawal', 795000.00, '2025-02-08', '21:35:54', NULL, 3000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:35:54', '2025-02-08 21:35:54', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15106, NULL, '23b8f649-49bb-4b4a-8676-707d70f99d17', 'withdrawal', 795000.00, '2025-02-08', '21:35:54', NULL, 3000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:35:54', '2025-02-08 21:35:54', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15107, NULL, '23b8f649-49bb-4b4a-8676-707d70f99d17', 'deposit', 3000.00, '2025-02-08', '21:35:54', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:35:54', '2025-02-08 21:35:54', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15108, NULL, '39f8bac5-dbb9-4c5a-8291-b7f3487b555c', 'withdrawal', 101000.00, '2025-02-08', '21:36:26', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:36:26', '2025-02-08 21:36:26', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15109, NULL, '39f8bac5-dbb9-4c5a-8291-b7f3487b555c', 'withdrawal', 101000.00, '2025-02-08', '21:36:26', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:36:26', '2025-02-08 21:36:26', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15110, NULL, '39f8bac5-dbb9-4c5a-8291-b7f3487b555c', 'deposit', 1000.00, '2025-02-08', '21:36:26', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:36:26', '2025-02-08 21:36:26', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15111, NULL, '8c33f210-ebcd-43e9-9162-ab24f4f54d7c', 'withdrawal', 201000.00, '2025-02-08', '21:36:52', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:36:52', '2025-02-08 21:36:52', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15112, NULL, '8c33f210-ebcd-43e9-9162-ab24f4f54d7c', 'withdrawal', 201000.00, '2025-02-08', '21:36:52', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:36:52', '2025-02-08 21:36:52', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15113, NULL, '8c33f210-ebcd-43e9-9162-ab24f4f54d7c', 'deposit', 1000.00, '2025-02-08', '21:36:52', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:36:52', '2025-02-08 21:36:52', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15114, NULL, 'b6d8508b-de47-4589-8f6f-2010fcfb9fe6', 'withdrawal', 1009000.00, '2025-02-08', '21:37:10', NULL, 4000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:37:10', '2025-02-08 21:37:10', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15115, NULL, 'b6d8508b-de47-4589-8f6f-2010fcfb9fe6', 'withdrawal', 1009000.00, '2025-02-08', '21:37:10', NULL, 4000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:37:10', '2025-02-08 21:37:10', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15116, NULL, 'b6d8508b-de47-4589-8f6f-2010fcfb9fe6', 'deposit', 4000.00, '2025-02-08', '21:37:10', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:37:10', '2025-02-08 21:37:10', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15117, NULL, '6a917078-65af-468e-8abe-09d5629f5ec3', 'withdrawal', 401500.00, '2025-02-08', '21:37:45', NULL, 1500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:37:45', '2025-02-08 21:37:45', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15118, NULL, '6a917078-65af-468e-8abe-09d5629f5ec3', 'withdrawal', 401500.00, '2025-02-08', '21:37:45', NULL, 1500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:37:45', '2025-02-08 21:37:45', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15119, NULL, '6a917078-65af-468e-8abe-09d5629f5ec3', 'deposit', 1500.00, '2025-02-08', '21:37:45', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:37:46', '2025-02-08 21:37:46', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15120, NULL, '13a75f7a-56c5-40ed-bd62-66b6d27f4600', 'withdrawal', 1353750.00, '2025-02-08', '21:38:11', NULL, 5500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:38:11', '2025-02-08 21:38:11', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15121, NULL, '13a75f7a-56c5-40ed-bd62-66b6d27f4600', 'withdrawal', 1353750.00, '2025-02-08', '21:38:11', NULL, 5500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:38:11', '2025-02-08 21:38:11', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15122, NULL, '13a75f7a-56c5-40ed-bd62-66b6d27f4600', 'deposit', 5500.00, '2025-02-08', '21:38:11', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:38:11', '2025-02-08 21:38:11', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15123, NULL, '0a11f6aa-14e3-462a-bc0f-34f954370b6b', 'withdrawal', 502000.00, '2025-02-08', '21:38:39', NULL, 2000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:38:39', '2025-02-08 21:38:39', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15124, NULL, '0a11f6aa-14e3-462a-bc0f-34f954370b6b', 'withdrawal', 502000.00, '2025-02-08', '21:38:39', NULL, 2000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:38:39', '2025-02-08 21:38:39', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15125, NULL, '0a11f6aa-14e3-462a-bc0f-34f954370b6b', 'deposit', 2000.00, '2025-02-08', '21:38:39', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:38:39', '2025-02-08 21:38:39', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15126, NULL, 'fcd2bd5b-5c76-460e-bbff-61efc667a20c', 'withdrawal', 313250.00, '2025-02-08', '21:39:12', NULL, 1250.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:39:12', '2025-02-08 21:39:12', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15127, NULL, 'fcd2bd5b-5c76-460e-bbff-61efc667a20c', 'withdrawal', 313250.00, '2025-02-08', '21:39:12', NULL, 1250.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:39:12', '2025-02-08 21:39:12', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15128, NULL, 'fcd2bd5b-5c76-460e-bbff-61efc667a20c', 'deposit', 1250.00, '2025-02-08', '21:39:12', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:39:12', '2025-02-08 21:39:12', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15129, NULL, 'f34dcbeb-eacd-4f55-9a58-5cfe42f6af4d', 'withdrawal', 351250.00, '2025-02-08', '21:39:46', NULL, 1250.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:39:46', '2025-02-08 21:39:46', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15130, NULL, 'f34dcbeb-eacd-4f55-9a58-5cfe42f6af4d', 'withdrawal', 351250.00, '2025-02-08', '21:39:46', NULL, 1250.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:39:46', '2025-02-08 21:39:46', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15131, NULL, 'f34dcbeb-eacd-4f55-9a58-5cfe42f6af4d', 'deposit', 1250.00, '2025-02-08', '21:39:46', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:39:46', '2025-02-08 21:39:46', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15132, NULL, '6433ac8e-66f3-4e0f-8c77-0d304a4d3814', 'withdrawal', 201000.00, '2025-02-08', '21:40:01', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:40:01', '2025-02-08 21:40:01', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15133, NULL, '6433ac8e-66f3-4e0f-8c77-0d304a4d3814', 'withdrawal', 201000.00, '2025-02-08', '21:40:01', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:40:01', '2025-02-08 21:40:01', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15134, NULL, '6433ac8e-66f3-4e0f-8c77-0d304a4d3814', 'deposit', 1000.00, '2025-02-08', '21:40:01', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:40:01', '2025-02-08 21:40:01', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15135, NULL, '0d4645bc-0e44-4484-ac6d-5ce4181dfd27', 'withdrawal', 251000.00, '2025-02-08', '21:40:27', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:40:27', '2025-02-08 21:40:27', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15136, NULL, '0d4645bc-0e44-4484-ac6d-5ce4181dfd27', 'withdrawal', 251000.00, '2025-02-08', '21:40:27', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:40:27', '2025-02-08 21:40:27', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15137, NULL, '0d4645bc-0e44-4484-ac6d-5ce4181dfd27', 'deposit', 1000.00, '2025-02-08', '21:40:27', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-08 21:40:27', '2025-02-08 21:40:27', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15142, NULL, 'be34b7d5-bc17-4a63-8be5-7d3c0a105056', 'withdrawal', 100625000.00, '2025-02-08', '21:45:15', NULL, 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-08 21:45:15', '2025-02-08 21:45:15', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15143, NULL, 'be34b7d5-bc17-4a63-8be5-7d3c0a105056', 'withdrawal', 100625000.00, '2025-02-08', '21:45:15', NULL, 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-08 21:45:15', '2025-02-08 21:45:15', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15144, NULL, 'be34b7d5-bc17-4a63-8be5-7d3c0a105056', 'deposit', 0.00, '2025-02-08', '21:45:15', 'Fee collected for withdrawal', 0.00, 1, 'sarf', NULL, NULL, NULL, NULL, '2025-02-08 21:45:15', '2025-02-08 21:45:15', 23, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15153, NULL, 'dc94936c-10e3-4b6e-88f4-2326f1d708be', 'withdrawal', 10000.00, '2025-02-08', '21:50:33', 'k muhamad shami', 0.00, 1, 'naqs shadda ', NULL, NULL, NULL, NULL, '2025-02-08 21:50:33', '2025-02-08 21:50:33', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15154, NULL, 'dc94936c-10e3-4b6e-88f4-2326f1d708be', 'withdrawal', 10000.00, '2025-02-08', '21:50:33', 'k muhamad shami', 0.00, 1, 'naqs shadda ', NULL, NULL, NULL, NULL, '2025-02-08 21:50:33', '2025-02-08 21:50:33', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15155, NULL, 'dc94936c-10e3-4b6e-88f4-2326f1d708be', 'deposit', 0.00, '2025-02-08', '21:50:33', 'Fee collected for withdrawal', 0.00, 1, 'naqs shadda ', NULL, NULL, NULL, NULL, '2025-02-08 21:50:33', '2025-02-08 21:50:33', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15156, NULL, '90d2abf5-34f4-43b7-b1bc-74dca2d0d3a4', 'deposit', 11198000.00, '2025-02-08', '22:00:48', 'mlion 18000', 198000.00, 1, 'switch', NULL, NULL, NULL, NULL, '2025-02-08 22:00:48', '2025-02-08 22:00:48', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15157, NULL, '90d2abf5-34f4-43b7-b1bc-74dca2d0d3a4', 'deposit', 11198000.00, '2025-02-08', '22:00:48', 'mlion 18000', 198000.00, 1, 'switch', NULL, NULL, NULL, NULL, '2025-02-08 22:00:48', '2025-02-08 22:00:48', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15158, NULL, '90d2abf5-34f4-43b7-b1bc-74dca2d0d3a4', 'deposit', 198000.00, '2025-02-08', '22:00:48', 'Fee collected for deposit', 0.00, 1, 'switch', NULL, NULL, NULL, NULL, '2025-02-08 22:00:48', '2025-02-08 22:00:48', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15163, NULL, 'a7e1d0dd-1e51-4538-8039-edb637c83af6', 'deposit', 1018000.00, '2025-02-08', '22:04:34', NULL, 18000.00, 1, 'switch', NULL, NULL, NULL, NULL, '2025-02-08 22:04:34', '2025-02-08 22:04:34', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15164, NULL, 'a7e1d0dd-1e51-4538-8039-edb637c83af6', 'deposit', 1018000.00, '2025-02-08', '22:04:34', NULL, 18000.00, 1, 'switch', NULL, NULL, NULL, NULL, '2025-02-08 22:04:34', '2025-02-08 22:04:34', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15165, NULL, 'a7e1d0dd-1e51-4538-8039-edb637c83af6', 'deposit', 18000.00, '2025-02-08', '22:04:34', 'Fee collected for deposit', 0.00, 1, 'switch', NULL, NULL, NULL, NULL, '2025-02-08 22:04:34', '2025-02-08 22:04:34', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15342, NULL, '960c087a-ad02-4905-a1e7-8d2af6c940ce', 'withdrawal', 3345.00, '2025-02-09', '14:29:59', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:29:59', '2025-02-09 14:29:59', 200, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15343, NULL, '960c087a-ad02-4905-a1e7-8d2af6c940ce', 'withdrawal', 3345.00, '2025-02-09', '14:29:59', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:29:59', '2025-02-09 14:29:59', 1, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15344, NULL, '960c087a-ad02-4905-a1e7-8d2af6c940ce', 'deposit', 0.00, '2025-02-09', '14:29:59', 'Fee collected for withdrawal', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:29:59', '2025-02-09 14:29:59', 22, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15351, NULL, '67454c36-dee0-427c-931c-cc307eec46cc', 'withdrawal', 2336.00, '2025-02-09', '14:32:35', NULL, 6.00, 1, 'cancel', NULL, NULL, NULL, NULL, '2025-02-09 14:32:35', '2025-02-09 14:32:35', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15352, NULL, '67454c36-dee0-427c-931c-cc307eec46cc', 'withdrawal', 2336.00, '2025-02-09', '14:32:35', NULL, 6.00, 1, 'cancel', NULL, NULL, NULL, NULL, '2025-02-09 14:32:35', '2025-02-09 14:32:35', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15353, NULL, '67454c36-dee0-427c-931c-cc307eec46cc', 'deposit', 6.00, '2025-02-09', '14:32:35', 'Fee collected for withdrawal', 0.00, 1, 'cancel', NULL, NULL, NULL, NULL, '2025-02-09 14:32:35', '2025-02-09 14:32:35', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15354, NULL, '39a8c412-e7b0-4ea9-9393-0b3f979f9569', 'deposit', 4010000.00, '2025-02-09', '14:36:21', 'leth shno
sja ismaiel', 10000.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-09 14:36:21', '2025-02-09 14:36:21', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15355, NULL, '39a8c412-e7b0-4ea9-9393-0b3f979f9569', 'deposit', 4010000.00, '2025-02-09', '14:36:21', 'leth shno
sja ismaiel', 10000.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-09 14:36:21', '2025-02-09 14:36:21', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15356, NULL, '39a8c412-e7b0-4ea9-9393-0b3f979f9569', 'deposit', 10000.00, '2025-02-09', '14:36:21', 'Fee collected for deposit', 0.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-09 14:36:21', '2025-02-09 14:36:21', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15357, NULL, '4e63cfb6-faf7-44ca-9be8-3b2d75a62be4', 'withdrawal', 4014000.00, '2025-02-09', '14:41:36', 'leth shno
sja ismaiel', 14000.00, 1, 'nasrea hawala', NULL, NULL, NULL, NULL, '2025-02-09 14:41:36', '2025-02-09 14:41:36', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15358, NULL, '4e63cfb6-faf7-44ca-9be8-3b2d75a62be4', 'withdrawal', 4014000.00, '2025-02-09', '14:41:36', 'leth shno
sja ismaiel', 14000.00, 1, 'nasrea hawala', NULL, NULL, NULL, NULL, '2025-02-09 14:41:36', '2025-02-09 14:41:36', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15359, NULL, '4e63cfb6-faf7-44ca-9be8-3b2d75a62be4', 'deposit', 14000.00, '2025-02-09', '14:41:36', 'Fee collected for withdrawal', 0.00, 1, 'nasrea hawala', NULL, NULL, NULL, NULL, '2025-02-09 14:41:36', '2025-02-09 14:41:36', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(15360, NULL, '1cd4e0e2-fa78-4bf3-9ab1-b5d1d5eade3c', 'withdrawal', 11915000.00, '2025-02-09', '14:42:39', NULL, 0.00, 1, 'sardar', NULL, NULL, NULL, NULL, '2025-02-09 14:42:39', '2025-02-09 14:42:39', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15361, NULL, '1cd4e0e2-fa78-4bf3-9ab1-b5d1d5eade3c', 'withdrawal', 11915000.00, '2025-02-09', '14:42:39', NULL, 0.00, 1, 'sardar', NULL, NULL, NULL, NULL, '2025-02-09 14:42:39', '2025-02-09 14:42:39', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15362, NULL, '1cd4e0e2-fa78-4bf3-9ab1-b5d1d5eade3c', 'deposit', 0.00, '2025-02-09', '14:42:39', 'Fee collected for withdrawal', 0.00, 1, 'sardar', NULL, NULL, NULL, NULL, '2025-02-09 14:42:39', '2025-02-09 14:42:39', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15365, NULL, '6cfc8d2e-c97b-444d-b89f-b2ca49a929ae', 'withdrawal', 1000.00, '2025-02-09', '14:43:50', NULL, 1000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-09 14:43:50', '2025-02-09 14:43:50', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15366, NULL, '6cfc8d2e-c97b-444d-b89f-b2ca49a929ae', 'withdrawal', 1000.00, '2025-02-09', '14:43:50', NULL, 1000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-09 14:43:50', '2025-02-09 14:43:50', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15367, NULL, '6cfc8d2e-c97b-444d-b89f-b2ca49a929ae', 'deposit', 1000.00, '2025-02-09', '14:43:50', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-09 14:43:50', '2025-02-09 14:43:50', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15368, NULL, '4a65c0b3-2b06-43e2-bf46-33866f012895', 'withdrawal', 500000.00, '2025-02-09', '14:45:11', NULL, 0.00, 1, 'payadar u zagros', NULL, NULL, NULL, NULL, '2025-02-09 14:45:11', '2025-02-09 14:45:11', 284, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15369, NULL, '4a65c0b3-2b06-43e2-bf46-33866f012895', 'withdrawal', 500000.00, '2025-02-09', '14:45:11', NULL, 0.00, 1, 'payadar u zagros', NULL, NULL, NULL, NULL, '2025-02-09 14:45:11', '2025-02-09 14:45:11', 2, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15370, NULL, '4a65c0b3-2b06-43e2-bf46-33866f012895', 'deposit', 0.00, '2025-02-09', '14:45:11', 'Fee collected for withdrawal', 0.00, 1, 'payadar u zagros', NULL, NULL, NULL, NULL, '2025-02-09 14:45:11', '2025-02-09 14:45:11', 23, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15371, NULL, '3d804926-0a3d-4c58-9c3d-055406360957', 'deposit', 500.00, '2025-02-09', '14:45:32', NULL, 0.00, 1, 'payadar', NULL, NULL, NULL, NULL, '2025-02-09 14:45:32', '2025-02-09 14:45:32', 283, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15372, NULL, '3d804926-0a3d-4c58-9c3d-055406360957', 'deposit', 500.00, '2025-02-09', '14:45:32', NULL, 0.00, 1, 'payadar', NULL, NULL, NULL, NULL, '2025-02-09 14:45:32', '2025-02-09 14:45:32', 1, 283, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15373, NULL, '3d804926-0a3d-4c58-9c3d-055406360957', 'deposit', 0.00, '2025-02-09', '14:45:32', 'Fee collected for deposit', 0.00, 1, 'payadar', NULL, NULL, NULL, NULL, '2025-02-09 14:45:32', '2025-02-09 14:45:32', 22, 283, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15378, NULL, '339be6bc-815d-4138-9f29-b6b36a398496', 'deposit', 3345.00, '2025-02-09', '14:48:40', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:48:40', '2025-02-09 14:48:40', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15379, NULL, '339be6bc-815d-4138-9f29-b6b36a398496', 'deposit', 3345.00, '2025-02-09', '14:48:40', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:48:40', '2025-02-09 14:48:40', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15380, NULL, '339be6bc-815d-4138-9f29-b6b36a398496', 'deposit', 0.00, '2025-02-09', '14:48:40', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:48:40', '2025-02-09 14:48:40', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15381, NULL, '41c5609f-b69f-4564-9cf5-825d3ae182e3', 'deposit', 80000.00, '2025-02-09', '14:49:08', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:49:08', '2025-02-09 14:49:08', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15382, NULL, '41c5609f-b69f-4564-9cf5-825d3ae182e3', 'deposit', 80000.00, '2025-02-09', '14:49:08', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:49:08', '2025-02-09 14:49:08', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15383, NULL, '41c5609f-b69f-4564-9cf5-825d3ae182e3', 'deposit', 0.00, '2025-02-09', '14:49:08', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:49:08', '2025-02-09 14:49:08', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15384, NULL, 'd90b362a-ecb8-4e6d-b990-fc18be2e61e8', 'deposit', 10000000.00, '2025-02-09', '14:50:04', NULL, 0.00, 1, 'ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:50:04', '2025-02-09 14:50:04', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15385, NULL, 'd90b362a-ecb8-4e6d-b990-fc18be2e61e8', 'deposit', 10000000.00, '2025-02-09', '14:50:04', NULL, 0.00, 1, 'ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:50:04', '2025-02-09 14:50:04', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15386, NULL, 'd90b362a-ecb8-4e6d-b990-fc18be2e61e8', 'deposit', 0.00, '2025-02-09', '14:50:04', 'Fee collected for deposit', 0.00, 1, 'ahmed', NULL, NULL, NULL, NULL, '2025-02-09 14:50:04', '2025-02-09 14:50:04', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15401, NULL, 'ea4d7e0d-3d1e-4aa3-ae5d-08c86131cf05', 'withdrawal', 16080000.00, '2025-02-09', '14:56:47', NULL, 80000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-09 14:56:47', '2025-02-09 14:56:47', 166, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15402, NULL, 'ea4d7e0d-3d1e-4aa3-ae5d-08c86131cf05', 'withdrawal', 16080000.00, '2025-02-09', '14:56:47', NULL, 80000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-09 14:56:47', '2025-02-09 14:56:47', 2, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15403, NULL, 'ea4d7e0d-3d1e-4aa3-ae5d-08c86131cf05', 'deposit', 80000.00, '2025-02-09', '14:56:47', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-09 14:56:47', '2025-02-09 14:56:47', 23, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15404, NULL, 'e7aa62c0-c35b-4ecf-9566-4998be13420e', 'deposit', 17000000.00, '2025-02-09', '14:57:25', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-09 14:57:25', '2025-02-09 14:57:25', 166, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15405, NULL, 'e7aa62c0-c35b-4ecf-9566-4998be13420e', 'deposit', 17000000.00, '2025-02-09', '14:57:25', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-09 14:57:25', '2025-02-09 14:57:25', 2, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15406, NULL, 'e7aa62c0-c35b-4ecf-9566-4998be13420e', 'deposit', 0.00, '2025-02-09', '14:57:25', 'Fee collected for deposit', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-09 14:57:25', '2025-02-09 14:57:25', 23, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15415, NULL, '344c38fe-981e-4669-89fb-d2f64f074a19', 'withdrawal', 1146.00, '2025-02-09', '15:04:59', NULL, 6.00, 1, 'aram muhamad', NULL, NULL, NULL, NULL, '2025-02-09 15:04:59', '2025-02-09 15:04:59', 189, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15416, NULL, '344c38fe-981e-4669-89fb-d2f64f074a19', 'withdrawal', 1146.00, '2025-02-09', '15:04:59', NULL, 6.00, 1, 'aram muhamad', NULL, NULL, NULL, NULL, '2025-02-09 15:04:59', '2025-02-09 15:04:59', 1, 189, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15417, NULL, '344c38fe-981e-4669-89fb-d2f64f074a19', 'deposit', 6.00, '2025-02-09', '15:04:59', 'Fee collected for withdrawal', 0.00, 1, 'aram muhamad', NULL, NULL, NULL, NULL, '2025-02-09 15:04:59', '2025-02-09 15:04:59', 22, 189, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15422, NULL, '25807723-daf3-4e92-b350-1975394de60b', 'deposit', 1550.00, '2025-02-09', '15:07:55', NULL, 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-09 15:07:55', '2025-02-09 15:07:55', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15423, NULL, '25807723-daf3-4e92-b350-1975394de60b', 'deposit', 1550.00, '2025-02-09', '15:07:55', NULL, 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-09 15:07:55', '2025-02-09 15:07:55', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15424, NULL, '25807723-daf3-4e92-b350-1975394de60b', 'deposit', 0.00, '2025-02-09', '15:07:55', 'Fee collected for deposit', 0.00, 1, 'aram', NULL, NULL, NULL, NULL, '2025-02-09 15:07:55', '2025-02-09 15:07:55', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15427, NULL, '6e7b0693-8004-43cb-aaab-e07f40ba1031', 'deposit', 10000000.00, '2025-02-09', '15:12:55', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-09 15:12:55', '2025-02-09 15:12:55', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15428, NULL, '6e7b0693-8004-43cb-aaab-e07f40ba1031', 'deposit', 10000000.00, '2025-02-09', '15:12:55', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-09 15:12:55', '2025-02-09 15:12:55', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15429, NULL, '6e7b0693-8004-43cb-aaab-e07f40ba1031', 'deposit', 0.00, '2025-02-09', '15:12:55', 'Fee collected for deposit', 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-09 15:12:55', '2025-02-09 15:12:55', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15430, NULL, '0924ae3d-3109-4939-9d88-724fbd755bf5', 'withdrawal', 2338500.00, '2025-02-09', '15:15:09', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-09 15:15:09', '2025-02-09 15:15:09', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15431, NULL, '0924ae3d-3109-4939-9d88-724fbd755bf5', 'withdrawal', 2338500.00, '2025-02-09', '15:15:09', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-09 15:15:09', '2025-02-09 15:15:09', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15432, NULL, '0924ae3d-3109-4939-9d88-724fbd755bf5', 'deposit', 3500.00, '2025-02-09', '15:15:09', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-09 15:15:09', '2025-02-09 15:15:09', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15433, NULL, '8ffa16e9-b2ae-485e-86d2-40649a8c01dd', 'withdrawal', 5905.00, '2025-02-09', '15:19:43', NULL, 5.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:19:43', '2025-02-09 15:19:43', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15434, NULL, '8ffa16e9-b2ae-485e-86d2-40649a8c01dd', 'withdrawal', 5905.00, '2025-02-09', '15:19:43', NULL, 5.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:19:43', '2025-02-09 15:19:43', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15435, NULL, '8ffa16e9-b2ae-485e-86d2-40649a8c01dd', 'deposit', 5.00, '2025-02-09', '15:19:43', 'Fee collected for withdrawal', 0.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:19:43', '2025-02-09 15:19:43', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15436, NULL, 'f1d654c9-bac5-44c5-9a34-97d0cebf8458', 'withdrawal', 9005.00, '2025-02-09', '15:20:08', NULL, 5.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:20:08', '2025-02-09 15:20:08', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15437, NULL, 'f1d654c9-bac5-44c5-9a34-97d0cebf8458', 'withdrawal', 9005.00, '2025-02-09', '15:20:08', NULL, 5.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:20:08', '2025-02-09 15:20:08', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15438, NULL, 'f1d654c9-bac5-44c5-9a34-97d0cebf8458', 'deposit', 5.00, '2025-02-09', '15:20:08', 'Fee collected for withdrawal', 0.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:20:08', '2025-02-09 15:20:08', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15439, NULL, 'd1e6bfa4-39c8-472a-a95d-40e63f762f56', 'deposit', 14000000.00, '2025-02-09', '15:21:16', NULL, 0.00, 1, 'k abdulla', NULL, NULL, NULL, NULL, '2025-02-09 15:21:16', '2025-02-09 15:21:16', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15440, NULL, 'd1e6bfa4-39c8-472a-a95d-40e63f762f56', 'deposit', 14000000.00, '2025-02-09', '15:21:16', NULL, 0.00, 1, 'k abdulla', NULL, NULL, NULL, NULL, '2025-02-09 15:21:16', '2025-02-09 15:21:16', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15441, NULL, 'd1e6bfa4-39c8-472a-a95d-40e63f762f56', 'deposit', 0.00, '2025-02-09', '15:21:16', 'Fee collected for deposit', 0.00, 1, 'k abdulla', NULL, NULL, NULL, NULL, '2025-02-09 15:21:16', '2025-02-09 15:21:16', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15442, NULL, '3b86b1a8-8be9-497a-b2d3-42896d01525c', 'withdrawal', 14453.00, '2025-02-09', '15:22:13', 'amanj hama rauf salh', 10.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:22:13', '2025-02-09 15:22:13', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15443, NULL, '3b86b1a8-8be9-497a-b2d3-42896d01525c', 'withdrawal', 14453.00, '2025-02-09', '15:22:13', 'amanj hama rauf salh', 10.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:22:13', '2025-02-09 15:22:13', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15444, NULL, '3b86b1a8-8be9-497a-b2d3-42896d01525c', 'deposit', 10.00, '2025-02-09', '15:22:13', 'Fee collected for withdrawal', 0.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:22:13', '2025-02-09 15:22:13', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15445, NULL, 'dff241ac-dd53-42bb-a92f-1e76df35109b', 'deposit', 2338.00, '2025-02-09', '15:22:45', NULL, 0.00, 1, 'hatawa hsab -cancell', NULL, NULL, NULL, NULL, '2025-02-09 15:22:45', '2025-02-09 15:22:45', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15446, NULL, 'dff241ac-dd53-42bb-a92f-1e76df35109b', 'deposit', 2338.00, '2025-02-09', '15:22:45', NULL, 0.00, 1, 'hatawa hsab -cancell', NULL, NULL, NULL, NULL, '2025-02-09 15:22:45', '2025-02-09 15:22:45', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15447, NULL, 'dff241ac-dd53-42bb-a92f-1e76df35109b', 'deposit', 0.00, '2025-02-09', '15:22:45', 'Fee collected for deposit', 0.00, 1, 'hatawa hsab -cancell', NULL, NULL, NULL, NULL, '2025-02-09 15:22:45', '2025-02-09 15:22:45', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15448, NULL, '43957fdc-4074-4a8a-b355-bd30f34c4c4a', 'withdrawal', 14000000.00, '2025-02-09', '15:24:08', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-09 15:24:08', '2025-02-09 15:24:08', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15449, NULL, '43957fdc-4074-4a8a-b355-bd30f34c4c4a', 'withdrawal', 14000000.00, '2025-02-09', '15:24:08', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-09 15:24:08', '2025-02-09 15:24:08', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15450, NULL, '43957fdc-4074-4a8a-b355-bd30f34c4c4a', 'deposit', 0.00, '2025-02-09', '15:24:08', 'Fee collected for withdrawal', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-09 15:24:08', '2025-02-09 15:24:08', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15451, NULL, '94c674e5-1add-4fa4-a443-5fcabbd00749', 'deposit', 9330.00, '2025-02-09', '15:24:41', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-09 15:24:41', '2025-02-09 15:24:41', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15452, NULL, '94c674e5-1add-4fa4-a443-5fcabbd00749', 'deposit', 9330.00, '2025-02-09', '15:24:41', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-09 15:24:41', '2025-02-09 15:24:41', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15453, NULL, '94c674e5-1add-4fa4-a443-5fcabbd00749', 'deposit', 0.00, '2025-02-09', '15:24:41', 'Fee collected for deposit', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-09 15:24:41', '2025-02-09 15:24:41', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15462, NULL, 'ee6160c4-ea75-492c-955b-85645ad5cb73', 'deposit', 17695.00, '2025-02-09', '15:32:41', NULL, 0.00, 144, 'Hatw badasty kak abdulla', NULL, NULL, NULL, NULL, '2025-02-09 15:32:41', '2025-02-09 15:32:41', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15463, NULL, 'ee6160c4-ea75-492c-955b-85645ad5cb73', 'deposit', 17695.00, '2025-02-09', '15:32:41', NULL, 0.00, 144, 'Hatw badasty kak abdulla', NULL, NULL, NULL, NULL, '2025-02-09 15:32:41', '2025-02-09 15:32:41', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15478, NULL, '36b6d8d0-61db-42e7-9374-7e9612bf4122', 'deposit', 726.00, '2025-02-09', '15:39:23', NULL, 16.00, 1, 'ghana', NULL, NULL, NULL, NULL, '2025-02-09 15:39:23', '2025-02-09 15:39:23', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15479, NULL, '36b6d8d0-61db-42e7-9374-7e9612bf4122', 'deposit', 726.00, '2025-02-09', '15:39:23', NULL, 16.00, 1, 'ghana', NULL, NULL, NULL, NULL, '2025-02-09 15:39:23', '2025-02-09 15:39:23', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15480, NULL, '36b6d8d0-61db-42e7-9374-7e9612bf4122', 'deposit', 16.00, '2025-02-09', '15:39:23', 'Fee collected for deposit', 0.00, 1, 'ghana', NULL, NULL, NULL, NULL, '2025-02-09 15:39:23', '2025-02-09 15:39:23', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15481, NULL, 'd044a02d-3f25-4e24-8aea-278cb030ca7b', 'withdrawal', 734.00, '2025-02-09', '15:42:38', NULL, 24.00, 1, 'ghana', NULL, NULL, NULL, NULL, '2025-02-09 15:42:38', '2025-02-09 15:42:38', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15482, NULL, 'd044a02d-3f25-4e24-8aea-278cb030ca7b', 'withdrawal', 734.00, '2025-02-09', '15:42:38', NULL, 24.00, 1, 'ghana', NULL, NULL, NULL, NULL, '2025-02-09 15:42:38', '2025-02-09 15:42:38', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15483, NULL, 'd044a02d-3f25-4e24-8aea-278cb030ca7b', 'deposit', 24.00, '2025-02-09', '15:42:38', 'Fee collected for withdrawal', 0.00, 1, 'ghana', NULL, NULL, NULL, NULL, '2025-02-09 15:42:38', '2025-02-09 15:42:38', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15488, NULL, '3d01f51d-41f8-48b9-bc95-bdb4eb689a64', 'deposit', 9002.00, '2025-02-09', '15:45:43', 'abubakr ahmed', 2.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:45:43', '2025-02-09 15:45:43', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15489, NULL, '3d01f51d-41f8-48b9-bc95-bdb4eb689a64', 'deposit', 9002.00, '2025-02-09', '15:45:43', 'abubakr ahmed', 2.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:45:43', '2025-02-09 15:45:43', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15490, NULL, '3d01f51d-41f8-48b9-bc95-bdb4eb689a64', 'deposit', 2.00, '2025-02-09', '15:45:43', 'Fee collected for deposit', 0.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:45:43', '2025-02-09 15:45:43', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15491, NULL, '4b68d2d7-2d6d-45f6-b3a8-695fa9a46a46', 'deposit', 5902.00, '2025-02-09', '15:46:22', 'abdulmanaf taher', 2.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:46:22', '2025-02-09 15:46:22', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15492, NULL, '4b68d2d7-2d6d-45f6-b3a8-695fa9a46a46', 'deposit', 5902.00, '2025-02-09', '15:46:22', 'abdulmanaf taher', 2.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:46:22', '2025-02-09 15:46:22', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15493, NULL, '4b68d2d7-2d6d-45f6-b3a8-695fa9a46a46', 'deposit', 2.00, '2025-02-09', '15:46:22', 'Fee collected for deposit', 0.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:46:22', '2025-02-09 15:46:22', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15494, NULL, '37c974a2-57ac-4b3b-b753-4c2434948254', 'withdrawal', 17000000.00, '2025-02-09', '15:46:55', NULL, 0.00, 1, 'quick wave', NULL, NULL, NULL, NULL, '2025-02-09 15:46:55', '2025-02-09 15:46:55', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15495, NULL, '37c974a2-57ac-4b3b-b753-4c2434948254', 'withdrawal', 17000000.00, '2025-02-09', '15:46:55', NULL, 0.00, 1, 'quick wave', NULL, NULL, NULL, NULL, '2025-02-09 15:46:55', '2025-02-09 15:46:55', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15496, NULL, '37c974a2-57ac-4b3b-b753-4c2434948254', 'deposit', 0.00, '2025-02-09', '15:46:55', 'Fee collected for withdrawal', 0.00, 1, 'quick wave', NULL, NULL, NULL, NULL, '2025-02-09 15:46:55', '2025-02-09 15:46:55', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15497, NULL, '3a5184e7-64c3-479a-97a6-1d5dc9e0737a', 'withdrawal', 6000000.00, '2025-02-09', '15:47:27', NULL, 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-09 15:47:27', '2025-02-09 15:47:27', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15498, NULL, '3a5184e7-64c3-479a-97a6-1d5dc9e0737a', 'withdrawal', 6000000.00, '2025-02-09', '15:47:27', NULL, 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-09 15:47:27', '2025-02-09 15:47:27', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15499, NULL, '3a5184e7-64c3-479a-97a6-1d5dc9e0737a', 'deposit', 0.00, '2025-02-09', '15:47:27', 'Fee collected for withdrawal', 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-09 15:47:27', '2025-02-09 15:47:27', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15500, NULL, '207b5252-bf1e-4f32-93ee-5cc891843b49', 'withdrawal', 30000.00, '2025-02-09', '15:48:55', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-09 15:48:55', '2025-02-09 15:48:55', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15501, NULL, '207b5252-bf1e-4f32-93ee-5cc891843b49', 'withdrawal', 30000.00, '2025-02-09', '15:48:55', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-09 15:48:55', '2025-02-09 15:48:55', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15502, NULL, '207b5252-bf1e-4f32-93ee-5cc891843b49', 'deposit', 0.00, '2025-02-09', '15:48:55', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-09 15:48:55', '2025-02-09 15:48:55', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15506, NULL, '9104b800-ce5f-42a2-9e8f-57d8b750f7e9', 'deposit', 25000000.00, '2025-02-09', '15:51:37', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-09 15:51:37', '2025-02-09 15:51:37', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15507, NULL, '9104b800-ce5f-42a2-9e8f-57d8b750f7e9', 'deposit', 25000000.00, '2025-02-09', '15:51:37', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-09 15:51:37', '2025-02-09 15:51:37', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15508, NULL, '9104b800-ce5f-42a2-9e8f-57d8b750f7e9', 'deposit', 0.00, '2025-02-09', '15:51:37', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-09 15:51:37', '2025-02-09 15:51:37', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15509, NULL, 'f1e77ccc-e6bb-4f0a-bef7-79b4367737b2', 'deposit', 1144.00, '2025-02-09', '15:52:03', NULL, 4.00, 1, 'aram muhmad-rania', NULL, NULL, NULL, NULL, '2025-02-09 15:52:03', '2025-02-09 15:52:03', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15510, NULL, 'f1e77ccc-e6bb-4f0a-bef7-79b4367737b2', 'deposit', 1144.00, '2025-02-09', '15:52:03', NULL, 4.00, 1, 'aram muhmad-rania', NULL, NULL, NULL, NULL, '2025-02-09 15:52:03', '2025-02-09 15:52:03', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15511, NULL, 'f1e77ccc-e6bb-4f0a-bef7-79b4367737b2', 'deposit', 4.00, '2025-02-09', '15:52:03', 'Fee collected for deposit', 0.00, 1, 'aram muhmad-rania', NULL, NULL, NULL, NULL, '2025-02-09 15:52:03', '2025-02-09 15:52:03', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15512, NULL, '0e34360b-0599-47ae-803e-c5f57f8a79a5', 'deposit', 14447.00, '2025-02-09', '15:52:49', NULL, 4.00, 1, 'amanj hama rauf-slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:52:49', '2025-02-09 15:52:49', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15513, NULL, '0e34360b-0599-47ae-803e-c5f57f8a79a5', 'deposit', 14447.00, '2025-02-09', '15:52:49', NULL, 4.00, 1, 'amanj hama rauf-slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:52:49', '2025-02-09 15:52:49', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15514, NULL, '0e34360b-0599-47ae-803e-c5f57f8a79a5', 'deposit', 4.00, '2025-02-09', '15:52:49', 'Fee collected for deposit', 0.00, 1, 'amanj hama rauf-slemani', NULL, NULL, NULL, NULL, '2025-02-09 15:52:49', '2025-02-09 15:52:49', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15523, NULL, 'b6ca6f0e-8360-4924-a44c-9ef483724ed5', 'deposit', 6000000.00, '2025-02-09', '15:57:38', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-09 15:57:38', '2025-02-09 15:57:38', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15524, NULL, 'b6ca6f0e-8360-4924-a44c-9ef483724ed5', 'deposit', 6000000.00, '2025-02-09', '15:57:38', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-09 15:57:38', '2025-02-09 15:57:38', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15525, NULL, 'b6ca6f0e-8360-4924-a44c-9ef483724ed5', 'deposit', 0.00, '2025-02-09', '15:57:38', 'Fee collected for deposit', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-09 15:57:38', '2025-02-09 15:57:38', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15712, NULL, 'a5815c53-9fae-4aed-96c5-1caf4c071b73', 'deposit', 600.00, '2025-02-09', '20:29:30', '', 0.00, 144, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-09 20:29:30', '2025-02-09 20:29:30', 265, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15713, NULL, 'a5815c53-9fae-4aed-96c5-1caf4c071b73', 'deposit', 600.00, '2025-02-09', '20:29:30', '', 0.00, 144, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-09 20:29:30', '2025-02-09 20:29:30', 1, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15714, NULL, '434b656e-847c-433d-abdf-63332ca2b750', 'deposit', 5000000.00, '2025-02-09', '20:30:08', 0, 0.00, 144, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-09 20:30:08', '2025-02-09 20:30:08', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15715, NULL, '434b656e-847c-433d-abdf-63332ca2b750', 'deposit', 5000000.00, '2025-02-09', '20:30:08', 0, 0.00, 144, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-09 20:30:08', '2025-02-09 20:30:08', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15782, NULL, '630bd1cc-f1b3-48b2-8066-a2b60522f292', 'deposit', 20000.00, '2025-02-09', '22:34:42', NULL, 0.00, 144, 'kak haval', NULL, NULL, NULL, NULL, '2025-02-09 22:34:42', '2025-02-09 22:34:42', 237, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(15783, NULL, '630bd1cc-f1b3-48b2-8066-a2b60522f292', 'deposit', 20000.00, '2025-02-09', '22:34:42', NULL, 0.00, 144, 'kak haval', NULL, NULL, NULL, NULL, '2025-02-09 22:34:42', '2025-02-09 22:34:42', 1, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15798, NULL, '3d56f500-ca9c-4904-a73b-9fae72d3dfd9', 'deposit', 10000.00, '2025-02-10', '09:29:21', NULL, 0.00, 1, 'muhamad shami', NULL, NULL, NULL, NULL, '2025-02-10 09:29:21', '2025-02-10 09:29:21', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15799, NULL, '3d56f500-ca9c-4904-a73b-9fae72d3dfd9', 'deposit', 10000.00, '2025-02-10', '09:29:21', NULL, 0.00, 1, 'muhamad shami', NULL, NULL, NULL, NULL, '2025-02-10 09:29:21', '2025-02-10 09:29:21', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15800, NULL, '3d56f500-ca9c-4904-a73b-9fae72d3dfd9', 'deposit', 0.00, '2025-02-10', '09:29:21', 'Fee collected for deposit', 0.00, 1, 'muhamad shami', NULL, NULL, NULL, NULL, '2025-02-10 09:29:21', '2025-02-10 09:29:21', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15801, NULL, 'a1db0404-6188-48bd-a495-efafcf42ca66', 'withdrawal', 1505000.00, '2025-02-10', '09:30:53', NULL, 5000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 09:30:53', '2025-02-10 09:30:53', 196, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15802, NULL, 'a1db0404-6188-48bd-a495-efafcf42ca66', 'withdrawal', 1505000.00, '2025-02-10', '09:30:53', NULL, 5000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 09:30:53', '2025-02-10 09:30:53', 2, 196, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15803, NULL, 'a1db0404-6188-48bd-a495-efafcf42ca66', 'deposit', 5000.00, '2025-02-10', '09:30:53', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 09:30:53', '2025-02-10 09:30:53', 23, 196, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15804, NULL, '43cebbba-8dca-461e-aa99-79a2862f8296', 'withdrawal', 15022500.00, '2025-02-10', '09:35:20', NULL, 22500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 09:35:20', '2025-02-10 09:35:20', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15805, NULL, '43cebbba-8dca-461e-aa99-79a2862f8296', 'withdrawal', 15022500.00, '2025-02-10', '09:35:20', NULL, 22500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 09:35:20', '2025-02-10 09:35:20', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15806, NULL, '43cebbba-8dca-461e-aa99-79a2862f8296', 'deposit', 22500.00, '2025-02-10', '09:35:20', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 09:35:20', '2025-02-10 09:35:20', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15835, NULL, 'b43330d3-36c2-4b49-9b8f-bc17db8fc4ec', 'withdrawal', 646500.00, '2025-02-10', '10:52:03', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 10:52:03', '2025-02-10 10:52:03', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15836, NULL, 'b43330d3-36c2-4b49-9b8f-bc17db8fc4ec', 'withdrawal', 646500.00, '2025-02-10', '10:52:03', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 10:52:03', '2025-02-10 10:52:03', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15837, NULL, 'b43330d3-36c2-4b49-9b8f-bc17db8fc4ec', 'deposit', 1500.00, '2025-02-10', '10:52:03', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 10:52:03', '2025-02-10 10:52:03', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15838, NULL, '61eeb881-d33c-4f84-bfec-42d30c73d9f7', 'withdrawal', 5191500.00, '2025-02-10', '10:53:19', NULL, 15500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 10:53:19', '2025-02-10 10:53:19', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15839, NULL, '61eeb881-d33c-4f84-bfec-42d30c73d9f7', 'withdrawal', 5191500.00, '2025-02-10', '10:53:19', NULL, 15500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 10:53:19', '2025-02-10 10:53:19', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15840, NULL, '61eeb881-d33c-4f84-bfec-42d30c73d9f7', 'deposit', 15500.00, '2025-02-10', '10:53:19', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 10:53:19', '2025-02-10 10:53:19', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15841, NULL, '507c75b4-0b50-4047-9dd5-977614b0f21f', 'withdrawal', 30000.00, '2025-02-10', '10:53:34', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 10:53:34', '2025-02-10 10:53:34', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15842, NULL, '507c75b4-0b50-4047-9dd5-977614b0f21f', 'withdrawal', 30000.00, '2025-02-10', '10:53:34', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 10:53:34', '2025-02-10 10:53:34', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15843, NULL, '507c75b4-0b50-4047-9dd5-977614b0f21f', 'deposit', 0.00, '2025-02-10', '10:53:34', 'Fee collected for withdrawal', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 10:53:34', '2025-02-10 10:53:34', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15844, NULL, 'ee2c3e09-3580-4ae3-afea-3533eebc4807', 'withdrawal', 753750.00, '2025-02-10', '10:55:44', NULL, 3750.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-10 10:55:44', '2025-02-10 10:55:44', 227, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15845, NULL, 'ee2c3e09-3580-4ae3-afea-3533eebc4807', 'withdrawal', 753750.00, '2025-02-10', '10:55:44', NULL, 3750.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-10 10:55:44', '2025-02-10 10:55:44', 2, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15846, NULL, 'ee2c3e09-3580-4ae3-afea-3533eebc4807', 'deposit', 3750.00, '2025-02-10', '10:55:44', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-10 10:55:44', '2025-02-10 10:55:44', 23, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15851, NULL, '92ea4030-a3d3-4108-bca8-853cb1767d84', 'withdrawal', 451750.00, '2025-02-10', '11:00:27', NULL, 1750.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-10 11:00:27', '2025-02-10 11:00:27', 166, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15852, NULL, '92ea4030-a3d3-4108-bca8-853cb1767d84', 'withdrawal', 451750.00, '2025-02-10', '11:00:27', NULL, 1750.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-10 11:00:28', '2025-02-10 11:00:28', 2, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15853, NULL, '92ea4030-a3d3-4108-bca8-853cb1767d84', 'deposit', 1750.00, '2025-02-10', '11:00:27', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-10 11:00:28', '2025-02-10 11:00:28', 23, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15868, NULL, 'f0b14e8f-0bad-4bde-bb98-c530ed798f8e', 'withdrawal', 1515500.00, '2025-02-10', '11:14:43', NULL, 5000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 11:14:43', '2025-02-10 11:14:43', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15869, NULL, 'f0b14e8f-0bad-4bde-bb98-c530ed798f8e', 'withdrawal', 1515500.00, '2025-02-10', '11:14:43', NULL, 5000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 11:14:43', '2025-02-10 11:14:43', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15870, NULL, 'f0b14e8f-0bad-4bde-bb98-c530ed798f8e', 'deposit', 5000.00, '2025-02-10', '11:14:43', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 11:14:43', '2025-02-10 11:14:43', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15873, NULL, '0a9fb3b5-3a5b-4d55-87d3-cb8d9ee15006', 'withdrawal', 1353000.00, '2025-02-10', '11:15:28', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 11:15:28', '2025-02-10 11:15:28', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15874, NULL, '0a9fb3b5-3a5b-4d55-87d3-cb8d9ee15006', 'withdrawal', 1353000.00, '2025-02-10', '11:15:28', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 11:15:28', '2025-02-10 11:15:28', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15875, NULL, '0a9fb3b5-3a5b-4d55-87d3-cb8d9ee15006', 'deposit', 3000.00, '2025-02-10', '11:15:28', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 11:15:28', '2025-02-10 11:15:28', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15876, NULL, 'fda0cf29-1805-424f-8a65-e35dd8962031', 'withdrawal', 1900.00, '2025-02-10', '11:17:59', NULL, 0.00, 1, 'aram sarf', NULL, NULL, NULL, NULL, '2025-02-10 11:17:59', '2025-02-10 11:17:59', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15877, NULL, 'fda0cf29-1805-424f-8a65-e35dd8962031', 'withdrawal', 1900.00, '2025-02-10', '11:17:59', NULL, 0.00, 1, 'aram sarf', NULL, NULL, NULL, NULL, '2025-02-10 11:17:59', '2025-02-10 11:17:59', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15878, NULL, 'fda0cf29-1805-424f-8a65-e35dd8962031', 'deposit', 0.00, '2025-02-10', '11:17:59', 'Fee collected for withdrawal', 0.00, 1, 'aram sarf', NULL, NULL, NULL, NULL, '2025-02-10 11:17:59', '2025-02-10 11:17:59', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15883, NULL, 'ed7a405d-4487-46dd-b0c4-78bd1802acb9', 'withdrawal', 500.00, '2025-02-10', '11:21:38', NULL, 500.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:21:38', '2025-02-10 11:21:38', 166, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15884, NULL, 'ed7a405d-4487-46dd-b0c4-78bd1802acb9', 'withdrawal', 500.00, '2025-02-10', '11:21:38', NULL, 500.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:21:38', '2025-02-10 11:21:38', 2, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15885, NULL, 'ed7a405d-4487-46dd-b0c4-78bd1802acb9', 'deposit', 500.00, '2025-02-10', '11:21:38', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:21:38', '2025-02-10 11:21:38', 23, 166, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15890, NULL, '39093da9-2c66-4d63-beee-f96db872d74c', 'deposit', 4860.00, '2025-02-10', '11:27:41', NULL, 10.00, 1, 'abbas fazl', NULL, NULL, NULL, NULL, '2025-02-10 11:27:41', '2025-02-10 11:27:41', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15891, NULL, '39093da9-2c66-4d63-beee-f96db872d74c', 'deposit', 4860.00, '2025-02-10', '11:27:41', NULL, 10.00, 1, 'abbas fazl', NULL, NULL, NULL, NULL, '2025-02-10 11:27:41', '2025-02-10 11:27:41', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15892, NULL, '39093da9-2c66-4d63-beee-f96db872d74c', 'deposit', 10.00, '2025-02-10', '11:27:41', 'Fee collected for deposit', 0.00, 1, 'abbas fazl', NULL, NULL, NULL, NULL, '2025-02-10 11:27:41', '2025-02-10 11:27:41', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15893, NULL, 'aafcc4ff-fd0c-4517-a87e-9cac0840aef5', 'deposit', 2900000.00, '2025-02-10', '11:28:46', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 11:28:46', '2025-02-10 11:28:46', 184, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15894, NULL, 'aafcc4ff-fd0c-4517-a87e-9cac0840aef5', 'deposit', 2900000.00, '2025-02-10', '11:28:46', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 11:28:46', '2025-02-10 11:28:46', 2, 184, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15895, NULL, 'aafcc4ff-fd0c-4517-a87e-9cac0840aef5', 'deposit', 0.00, '2025-02-10', '11:28:46', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 11:28:46', '2025-02-10 11:28:46', 23, 184, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15898, NULL, '70ce82fb-5d05-473b-8fee-608a4b3f37c2', 'deposit', 5820250.00, '2025-02-10', '11:31:00', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-10 11:31:00', '2025-02-10 11:31:00', 181, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15899, NULL, '70ce82fb-5d05-473b-8fee-608a4b3f37c2', 'deposit', 5820250.00, '2025-02-10', '11:31:00', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-10 11:31:00', '2025-02-10 11:31:00', 2, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15900, NULL, '70ce82fb-5d05-473b-8fee-608a4b3f37c2', 'deposit', 0.00, '2025-02-10', '11:31:00', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-10 11:31:00', '2025-02-10 11:31:00', 23, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15903, NULL, '62dca42d-9042-4804-b9a1-cf1d1e62ea3a', 'withdrawal', 5100.00, '2025-02-10', '11:31:15', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-10 11:31:15', '2025-02-10 11:31:15', 182, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15904, NULL, '62dca42d-9042-4804-b9a1-cf1d1e62ea3a', 'withdrawal', 5100.00, '2025-02-10', '11:31:15', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-10 11:31:15', '2025-02-10 11:31:15', 1, 182, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15905, NULL, '62dca42d-9042-4804-b9a1-cf1d1e62ea3a', 'deposit', 0.00, '2025-02-10', '11:31:15', 'Fee collected for withdrawal', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-10 11:31:15', '2025-02-10 11:31:15', 22, 182, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15906, NULL, '2dc69365-60c9-46ee-854b-99e0342243a9', 'withdrawal', 500000.00, '2025-02-10', '11:31:49', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 11:31:49', '2025-02-10 11:31:49', 181, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15907, NULL, '2dc69365-60c9-46ee-854b-99e0342243a9', 'withdrawal', 500000.00, '2025-02-10', '11:31:49', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 11:31:49', '2025-02-10 11:31:49', 2, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15908, NULL, '2dc69365-60c9-46ee-854b-99e0342243a9', 'deposit', 0.00, '2025-02-10', '11:31:49', 'Fee collected for withdrawal', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 11:31:49', '2025-02-10 11:31:49', 23, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15909, NULL, 'ac0b8e93-dc29-433a-a17d-1f1f0f77a4be', 'withdrawal', 1146.00, '2025-02-10', '11:34:30', 'شکانەوە لەسەر داواکاری خۆی', 1501.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-10 11:34:30', '2025-02-10 11:34:30', 1, 189, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15910, NULL, 'ac0b8e93-dc29-433a-a17d-1f1f0f77a4be', 'deposit', 1146.00, '2025-02-10', '11:34:30', 'شکانەوە لەسەر داواکاری خۆی', 1501.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-10 11:34:30', '2025-02-10 11:34:30', 189, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15911, NULL, 'ac0b8e93-dc29-433a-a17d-1f1f0f77a4be', 'deposit', 1720146.00, '2025-02-10', '11:34:30', 'شکانەوە لەسەر داواکاری خۆی', 1501.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-10 11:34:30', '2025-02-10 11:34:30', 2, 188, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15912, NULL, 'ac0b8e93-dc29-433a-a17d-1f1f0f77a4be', 'withdrawal', 1720146.00, '2025-02-10', '11:34:30', 'شکانەوە لەسەر داواکاری خۆی', 1501.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-10 11:34:30', '2025-02-10 11:34:30', 188, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15913, NULL, '14fa521e-644a-4419-9769-841b2f5fd2b0', 'deposit', 1560000.00, '2025-02-10', '11:34:46', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 11:34:46', '2025-02-10 11:34:46', 188, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15914, NULL, '14fa521e-644a-4419-9769-841b2f5fd2b0', 'deposit', 1560000.00, '2025-02-10', '11:34:46', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 11:34:46', '2025-02-10 11:34:46', 2, 188, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15915, NULL, '14fa521e-644a-4419-9769-841b2f5fd2b0', 'deposit', 0.00, '2025-02-10', '11:34:46', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 11:34:46', '2025-02-10 11:34:46', 23, 188, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15918, NULL, 'dd481836-768a-4a97-898f-a625abd1f199', 'withdrawal', 12.00, '2025-02-10', '11:37:20', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-10 11:37:20', '2025-02-10 11:37:20', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15919, NULL, 'dd481836-768a-4a97-898f-a625abd1f199', 'withdrawal', 12.00, '2025-02-10', '11:37:20', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-10 11:37:20', '2025-02-10 11:37:20', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15920, NULL, 'dd481836-768a-4a97-898f-a625abd1f199', 'deposit', 0.00, '2025-02-10', '11:37:20', 'Fee collected for withdrawal', 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-10 11:37:20', '2025-02-10 11:37:20', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15927, NULL, 'ee84fd9c-a14e-4771-9d18-c7032522b120', 'withdrawal', 6050000.00, '2025-02-10', '11:48:32', NULL, 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 11:48:32', '2025-02-10 11:48:32', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15928, NULL, 'ee84fd9c-a14e-4771-9d18-c7032522b120', 'withdrawal', 6050000.00, '2025-02-10', '11:48:32', NULL, 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 11:48:32', '2025-02-10 11:48:32', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15929, NULL, 'ee84fd9c-a14e-4771-9d18-c7032522b120', 'deposit', 0.00, '2025-02-10', '11:48:32', 'Fee collected for withdrawal', 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 11:48:32', '2025-02-10 11:48:32', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15930, NULL, 'f5793f8c-5d1c-45fd-8260-03053b36fa67', 'withdrawal', 15000.00, '2025-02-10', '11:48:49', NULL, 0.00, 1, 'ibrahm dukan', NULL, NULL, NULL, NULL, '2025-02-10 11:48:49', '2025-02-10 11:48:49', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15931, NULL, 'f5793f8c-5d1c-45fd-8260-03053b36fa67', 'withdrawal', 15000.00, '2025-02-10', '11:48:49', NULL, 0.00, 1, 'ibrahm dukan', NULL, NULL, NULL, NULL, '2025-02-10 11:48:49', '2025-02-10 11:48:49', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15932, NULL, 'f5793f8c-5d1c-45fd-8260-03053b36fa67', 'deposit', 0.00, '2025-02-10', '11:48:49', 'Fee collected for withdrawal', 0.00, 1, 'ibrahm dukan', NULL, NULL, NULL, NULL, '2025-02-10 11:48:49', '2025-02-10 11:48:49', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15933, NULL, '38eab538-215f-4977-9587-053d43efd85d', 'deposit', 502000.00, '2025-02-10', '11:49:42', NULL, 2000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 11:49:42', '2025-02-10 11:49:42', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15934, NULL, '38eab538-215f-4977-9587-053d43efd85d', 'deposit', 502000.00, '2025-02-10', '11:49:42', NULL, 2000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 11:49:42', '2025-02-10 11:49:42', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15935, NULL, '38eab538-215f-4977-9587-053d43efd85d', 'deposit', 2000.00, '2025-02-10', '11:49:42', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-10 11:49:42', '2025-02-10 11:49:42', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15936, NULL, 'ec91509a-3ea7-4428-8df5-4519537f4ec1', 'deposit', 250.00, '2025-02-10', '11:50:20', NULL, 250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:50:20', '2025-02-10 11:50:20', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15937, NULL, 'ec91509a-3ea7-4428-8df5-4519537f4ec1', 'deposit', 250.00, '2025-02-10', '11:50:20', NULL, 250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:50:20', '2025-02-10 11:50:20', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15938, NULL, 'ec91509a-3ea7-4428-8df5-4519537f4ec1', 'deposit', 250.00, '2025-02-10', '11:50:20', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:50:20', '2025-02-10 11:50:20', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15939, NULL, 'f59c4afb-3c61-401f-a3c6-57b4ba878aea', 'withdrawal', 500.00, '2025-02-10', '11:51:13', NULL, 500.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:51:13', '2025-02-10 11:51:13', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15940, NULL, 'f59c4afb-3c61-401f-a3c6-57b4ba878aea', 'withdrawal', 500.00, '2025-02-10', '11:51:13', NULL, 500.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:51:13', '2025-02-10 11:51:13', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15941, NULL, 'f59c4afb-3c61-401f-a3c6-57b4ba878aea', 'deposit', 500.00, '2025-02-10', '11:51:13', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-10 11:51:13', '2025-02-10 11:51:13', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15942, NULL, '67155bce-0500-46f4-b515-ae060506bec8', 'withdrawal', 300000.00, '2025-02-10', '11:51:38', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 11:51:38', '2025-02-10 11:51:38', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15943, NULL, '67155bce-0500-46f4-b515-ae060506bec8', 'withdrawal', 300000.00, '2025-02-10', '11:51:38', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 11:51:38', '2025-02-10 11:51:38', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15944, NULL, '67155bce-0500-46f4-b515-ae060506bec8', 'deposit', 0.00, '2025-02-10', '11:51:38', 'Fee collected for withdrawal', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-10 11:51:38', '2025-02-10 11:51:38', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15965, NULL, '03bff452-08f4-46b4-92f1-85f7acc61470', 'deposit', 2120.00, '2025-02-10', '12:28:58', NULL, 0.00, 132, 'kak gardi', NULL, NULL, NULL, NULL, '2025-02-10 12:28:58', '2025-02-10 12:28:58', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15966, NULL, '03bff452-08f4-46b4-92f1-85f7acc61470', 'deposit', 2120.00, '2025-02-10', '12:28:58', NULL, 0.00, 132, 'kak gardi', NULL, NULL, NULL, NULL, '2025-02-10 12:28:58', '2025-02-10 12:28:58', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15995, NULL, '2f2b03ca-a739-48f6-8d03-dc758a6c65cb', 'deposit', 19900.00, '2025-02-10', '13:39:35', NULL, 0.00, 144, 'Ahmad pshtewan khurshid', NULL, NULL, NULL, NULL, '2025-02-10 13:39:35', '2025-02-10 13:39:35', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(15996, NULL, '2f2b03ca-a739-48f6-8d03-dc758a6c65cb', 'deposit', 19900.00, '2025-02-10', '13:39:35', NULL, 0.00, 144, 'Ahmad pshtewan khurshid', NULL, NULL, NULL, NULL, '2025-02-10 13:39:35', '2025-02-10 13:39:35', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16017, NULL, '9ce671e9-4177-4cee-9b28-89fb0bc63130', 'deposit', 15022500.00, '2025-02-10', '14:34:56', NULL, 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 14:34:56', '2025-02-10 14:34:56', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16018, NULL, '9ce671e9-4177-4cee-9b28-89fb0bc63130', 'deposit', 15022500.00, '2025-02-10', '14:34:56', NULL, 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 14:34:56', '2025-02-10 14:34:56', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16019, NULL, '9ce671e9-4177-4cee-9b28-89fb0bc63130', 'deposit', 0.00, '2025-02-10', '14:34:56', 'Fee collected for deposit', 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 14:34:56', '2025-02-10 14:34:56', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16020, NULL, '1411803d-a7af-4563-ac1b-740d2460779f', 'deposit', 734.00, '2025-02-10', '14:34:57', NULL, 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 14:34:57', '2025-02-10 14:34:57', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16021, NULL, '1411803d-a7af-4563-ac1b-740d2460779f', 'deposit', 734.00, '2025-02-10', '14:34:57', NULL, 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 14:34:57', '2025-02-10 14:34:57', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16022, NULL, '1411803d-a7af-4563-ac1b-740d2460779f', 'deposit', 0.00, '2025-02-10', '14:34:57', 'Fee collected for deposit', 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-10 14:34:57', '2025-02-10 14:34:57', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16023, NULL, '56bebcc1-0929-4280-8028-45ca6626b9b2', 'withdrawal', 2103000.00, '2025-02-10', '14:40:36', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:40:36', '2025-02-10 14:40:36', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16024, NULL, '56bebcc1-0929-4280-8028-45ca6626b9b2', 'withdrawal', 2103000.00, '2025-02-10', '14:40:36', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:40:36', '2025-02-10 14:40:36', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16025, NULL, '56bebcc1-0929-4280-8028-45ca6626b9b2', 'deposit', 3000.00, '2025-02-10', '14:40:36', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:40:36', '2025-02-10 14:40:36', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16026, NULL, '2d58c4df-8b10-4b91-9a41-e2f83c6ba559', 'withdrawal', 19790000.00, '2025-02-10', '14:41:35', NULL, 30000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:41:35', '2025-02-10 14:41:35', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16027, NULL, '2d58c4df-8b10-4b91-9a41-e2f83c6ba559', 'withdrawal', 19790000.00, '2025-02-10', '14:41:35', NULL, 30000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:41:35', '2025-02-10 14:41:35', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16028, NULL, '2d58c4df-8b10-4b91-9a41-e2f83c6ba559', 'deposit', 30000.00, '2025-02-10', '14:41:35', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:41:35', '2025-02-10 14:41:35', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16029, NULL, '8ae2812c-898b-4874-8d05-b1a5b3320c27', 'withdrawal', 2253250.00, '2025-02-10', '14:46:14', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:46:14', '2025-02-10 14:46:14', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16030, NULL, '8ae2812c-898b-4874-8d05-b1a5b3320c27', 'withdrawal', 2253250.00, '2025-02-10', '14:46:14', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:46:14', '2025-02-10 14:46:14', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16031, NULL, '8ae2812c-898b-4874-8d05-b1a5b3320c27', 'deposit', 3250.00, '2025-02-10', '14:46:14', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:46:14', '2025-02-10 14:46:14', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16032, NULL, '68491fd8-0f57-4eac-8c05-ba171e9dc768', 'withdrawal', 151000.00, '2025-02-10', '14:46:28', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:46:28', '2025-02-10 14:46:28', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(16033, NULL, '68491fd8-0f57-4eac-8c05-ba171e9dc768', 'withdrawal', 151000.00, '2025-02-10', '14:46:28', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:46:28', '2025-02-10 14:46:28', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16034, NULL, '68491fd8-0f57-4eac-8c05-ba171e9dc768', 'deposit', 1000.00, '2025-02-10', '14:46:28', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-10 14:46:28', '2025-02-10 14:46:28', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16037, NULL, '7efed432-5785-4882-ae04-2d532b46f9e1', 'deposit', 1634.00, '2025-02-10', '14:47:33', NULL, 0.00, 1, 'muhmad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:47:33', '2025-02-10 14:47:33', 191, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16038, NULL, '7efed432-5785-4882-ae04-2d532b46f9e1', 'deposit', 1634.00, '2025-02-10', '14:47:33', NULL, 0.00, 1, 'muhmad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:47:33', '2025-02-10 14:47:33', 1, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16039, NULL, '7efed432-5785-4882-ae04-2d532b46f9e1', 'deposit', 0.00, '2025-02-10', '14:47:33', 'Fee collected for deposit', 0.00, 1, 'muhmad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:47:33', '2025-02-10 14:47:33', 22, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16040, NULL, 'fbc6d793-d570-4678-926e-5b1e94ddaf83', 'deposit', 2019000.00, '2025-02-10', '14:48:41', NULL, 7000.00, 1, 'shorja-talb heder', NULL, NULL, NULL, NULL, '2025-02-10 14:48:41', '2025-02-10 14:48:41', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16041, NULL, 'fbc6d793-d570-4678-926e-5b1e94ddaf83', 'deposit', 2019000.00, '2025-02-10', '14:48:41', NULL, 7000.00, 1, 'shorja-talb heder', NULL, NULL, NULL, NULL, '2025-02-10 14:48:41', '2025-02-10 14:48:41', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16042, NULL, 'fbc6d793-d570-4678-926e-5b1e94ddaf83', 'deposit', 7000.00, '2025-02-10', '14:48:41', 'Fee collected for deposit', 0.00, 1, 'shorja-talb heder', NULL, NULL, NULL, NULL, '2025-02-10 14:48:41', '2025-02-10 14:48:41', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16043, NULL, 'e6a4db91-2487-4d4e-8b49-c44ee25e084f', 'withdrawal', 6534.00, '2025-02-10', '14:49:34', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:49:34', '2025-02-10 14:49:34', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16044, NULL, 'e6a4db91-2487-4d4e-8b49-c44ee25e084f', 'withdrawal', 6534.00, '2025-02-10', '14:49:34', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:49:34', '2025-02-10 14:49:34', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16045, NULL, 'e6a4db91-2487-4d4e-8b49-c44ee25e084f', 'deposit', 0.00, '2025-02-10', '14:49:34', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:49:34', '2025-02-10 14:49:34', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16046, NULL, 'a76a66bc-9dd3-4fc5-8ec4-b99e43259fab', 'withdrawal', 6029000.00, '2025-02-10', '14:49:42', NULL, 0.00, 1, 'muhmad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:49:42', '2025-02-10 14:49:42', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16047, NULL, 'a76a66bc-9dd3-4fc5-8ec4-b99e43259fab', 'withdrawal', 6029000.00, '2025-02-10', '14:49:42', NULL, 0.00, 1, 'muhmad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:49:42', '2025-02-10 14:49:42', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16048, NULL, 'a76a66bc-9dd3-4fc5-8ec4-b99e43259fab', 'deposit', 0.00, '2025-02-10', '14:49:42', 'Fee collected for withdrawal', 0.00, 1, 'muhmad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:49:42', '2025-02-10 14:49:42', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16049, NULL, '77e14694-fb1c-4691-9440-65b32727ca0f', 'withdrawal', 500.00, '2025-02-10', '14:50:59', NULL, 0.00, 1, 'sarf gardi', NULL, NULL, NULL, NULL, '2025-02-10 14:50:59', '2025-02-10 14:50:59', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16050, NULL, '77e14694-fb1c-4691-9440-65b32727ca0f', 'withdrawal', 500.00, '2025-02-10', '14:50:59', NULL, 0.00, 1, 'sarf gardi', NULL, NULL, NULL, NULL, '2025-02-10 14:50:59', '2025-02-10 14:50:59', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16051, NULL, '77e14694-fb1c-4691-9440-65b32727ca0f', 'deposit', 0.00, '2025-02-10', '14:50:59', 'Fee collected for withdrawal', 0.00, 1, 'sarf gardi', NULL, NULL, NULL, NULL, '2025-02-10 14:50:59', '2025-02-10 14:50:59', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16052, NULL, '1c65b3b1-c70d-4ea3-a9a9-5bc0173d3620', 'withdrawal', 25000.00, '2025-02-10', '14:51:29', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:51:29', '2025-02-10 14:51:29', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16053, NULL, '1c65b3b1-c70d-4ea3-a9a9-5bc0173d3620', 'withdrawal', 25000.00, '2025-02-10', '14:51:29', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:51:29', '2025-02-10 14:51:29', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16054, NULL, '1c65b3b1-c70d-4ea3-a9a9-5bc0173d3620', 'deposit', 0.00, '2025-02-10', '14:51:29', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:51:29', '2025-02-10 14:51:29', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16055, NULL, '59c2cfc2-e60d-4e65-a122-d097fda97ea9', 'deposit', 300.00, '2025-02-10', '14:51:54', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:51:54', '2025-02-10 14:51:54', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16056, NULL, '59c2cfc2-e60d-4e65-a122-d097fda97ea9', 'deposit', 300.00, '2025-02-10', '14:51:54', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:51:54', '2025-02-10 14:51:54', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16057, NULL, '59c2cfc2-e60d-4e65-a122-d097fda97ea9', 'deposit', 0.00, '2025-02-10', '14:51:54', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-10 14:51:54', '2025-02-10 14:51:54', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16058, NULL, '5488ec6e-e79a-441e-8042-9a7b41702136', 'deposit', 20763.00, '2025-02-10', '14:54:48', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-10 14:54:48', '2025-02-10 14:54:48', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16059, NULL, '5488ec6e-e79a-441e-8042-9a7b41702136', 'deposit', 20763.00, '2025-02-10', '14:54:48', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-10 14:54:48', '2025-02-10 14:54:48', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16060, NULL, '5488ec6e-e79a-441e-8042-9a7b41702136', 'deposit', 0.00, '2025-02-10', '14:54:48', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-10 14:54:48', '2025-02-10 14:54:48', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16065, NULL, 'ec1528c2-dcda-4789-9588-43d833ec323c', 'deposit', 1038.00, '2025-02-10', '14:59:51', NULL, 2.00, 1, 'slemani-abdulmanaf taher', NULL, NULL, NULL, NULL, '2025-02-10 14:59:51', '2025-02-10 14:59:51', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16066, NULL, 'ec1528c2-dcda-4789-9588-43d833ec323c', 'deposit', 1038.00, '2025-02-10', '14:59:51', NULL, 2.00, 1, 'slemani-abdulmanaf taher', NULL, NULL, NULL, NULL, '2025-02-10 14:59:51', '2025-02-10 14:59:51', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16067, NULL, 'ec1528c2-dcda-4789-9588-43d833ec323c', 'deposit', 2.00, '2025-02-10', '14:59:51', 'Fee collected for deposit', 0.00, 1, 'slemani-abdulmanaf taher', NULL, NULL, NULL, NULL, '2025-02-10 14:59:51', '2025-02-10 14:59:51', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16072, NULL, '4b39dcd9-0393-484d-828b-efac090ae6be', 'deposit', 10002.00, '2025-02-10', '15:00:26', NULL, 2.00, 1, 'slemani- ardalan nadr', NULL, NULL, NULL, NULL, '2025-02-10 15:00:26', '2025-02-10 15:00:26', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16073, NULL, '4b39dcd9-0393-484d-828b-efac090ae6be', 'deposit', 10002.00, '2025-02-10', '15:00:26', NULL, 2.00, 1, 'slemani- ardalan nadr', NULL, NULL, NULL, NULL, '2025-02-10 15:00:26', '2025-02-10 15:00:26', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16074, NULL, '4b39dcd9-0393-484d-828b-efac090ae6be', 'deposit', 2.00, '2025-02-10', '15:00:26', 'Fee collected for deposit', 0.00, 1, 'slemani- ardalan nadr', NULL, NULL, NULL, NULL, '2025-02-10 15:00:26', '2025-02-10 15:00:26', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16075, NULL, '8802a482-2b4c-4682-95ba-46fa6fe8df72', 'withdrawal', 1535.00, '2025-02-10', '15:01:32', NULL, 0.00, 1, 'co.yanabe3-ashti azad', NULL, NULL, NULL, NULL, '2025-02-10 15:01:32', '2025-02-10 15:01:32', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16076, NULL, '8802a482-2b4c-4682-95ba-46fa6fe8df72', 'withdrawal', 1535.00, '2025-02-10', '15:01:32', NULL, 0.00, 1, 'co.yanabe3-ashti azad', NULL, NULL, NULL, NULL, '2025-02-10 15:01:32', '2025-02-10 15:01:32', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16077, NULL, '8802a482-2b4c-4682-95ba-46fa6fe8df72', 'deposit', 0.00, '2025-02-10', '15:01:32', 'Fee collected for withdrawal', 0.00, 1, 'co.yanabe3-ashti azad', NULL, NULL, NULL, NULL, '2025-02-10 15:01:32', '2025-02-10 15:01:32', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16078, NULL, 'bcd612eb-acd8-457a-93ab-1ae3eef9ff62', 'deposit', 1778.00, '2025-02-10', '15:02:54', NULL, -12.00, 1, 'dubai cash-ahmed hajut', NULL, NULL, NULL, NULL, '2025-02-10 15:02:54', '2025-02-10 15:02:54', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16079, NULL, 'bcd612eb-acd8-457a-93ab-1ae3eef9ff62', 'deposit', 1778.00, '2025-02-10', '15:02:54', NULL, -12.00, 1, 'dubai cash-ahmed hajut', NULL, NULL, NULL, NULL, '2025-02-10 15:02:54', '2025-02-10 15:02:54', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16080, NULL, 'bcd612eb-acd8-457a-93ab-1ae3eef9ff62', 'deposit', -12.00, '2025-02-10', '15:02:54', 'Fee collected for deposit', 0.00, 1, 'dubai cash-ahmed hajut', NULL, NULL, NULL, NULL, '2025-02-10 15:02:54', '2025-02-10 15:02:54', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16081, NULL, 'de72502f-73b0-4fb4-81b2-513c3e1b1a8e', 'withdrawal', 2022000.00, '2025-02-10', '15:08:55', NULL, 10000.00, 1, 'shorja', NULL, NULL, NULL, NULL, '2025-02-10 15:08:55', '2025-02-10 15:08:55', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16082, NULL, 'de72502f-73b0-4fb4-81b2-513c3e1b1a8e', 'withdrawal', 2022000.00, '2025-02-10', '15:08:55', NULL, 10000.00, 1, 'shorja', NULL, NULL, NULL, NULL, '2025-02-10 15:08:55', '2025-02-10 15:08:55', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16083, NULL, 'de72502f-73b0-4fb4-81b2-513c3e1b1a8e', 'deposit', 10000.00, '2025-02-10', '15:08:55', 'Fee collected for withdrawal', 0.00, 1, 'shorja', NULL, NULL, NULL, NULL, '2025-02-10 15:08:55', '2025-02-10 15:08:55', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16088, NULL, '61644aa6-488b-450a-b71a-1bb97b5411c2', 'withdrawal', 1041.00, '2025-02-10', '15:09:32', NULL, 5.00, 1, 'slemani-abdulmanaf taher', NULL, NULL, NULL, NULL, '2025-02-10 15:09:32', '2025-02-10 15:09:32', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16089, NULL, '61644aa6-488b-450a-b71a-1bb97b5411c2', 'withdrawal', 1041.00, '2025-02-10', '15:09:32', NULL, 5.00, 1, 'slemani-abdulmanaf taher', NULL, NULL, NULL, NULL, '2025-02-10 15:09:32', '2025-02-10 15:09:32', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16090, NULL, '61644aa6-488b-450a-b71a-1bb97b5411c2', 'deposit', 5.00, '2025-02-10', '15:09:32', 'Fee collected for withdrawal', 0.00, 1, 'slemani-abdulmanaf taher', NULL, NULL, NULL, NULL, '2025-02-10 15:09:32', '2025-02-10 15:09:32', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16091, NULL, '41bba90b-94b5-4f16-83cb-b7384d6d18d4', 'withdrawal', 10005.00, '2025-02-10', '15:18:08', NULL, 5.00, 1, 'slemani sarf', NULL, NULL, NULL, NULL, '2025-02-10 15:18:08', '2025-02-10 15:18:08', 1103, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16092, NULL, '41bba90b-94b5-4f16-83cb-b7384d6d18d4', 'withdrawal', 10005.00, '2025-02-10', '15:18:08', NULL, 5.00, 1, 'slemani sarf', NULL, NULL, NULL, NULL, '2025-02-10 15:18:08', '2025-02-10 15:18:08', 1, 1103, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16093, NULL, '41bba90b-94b5-4f16-83cb-b7384d6d18d4', 'deposit', 5.00, '2025-02-10', '15:18:08', 'Fee collected for withdrawal', 0.00, 1, 'slemani sarf', NULL, NULL, NULL, NULL, '2025-02-10 15:18:08', '2025-02-10 15:18:08', 22, 1103, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16146, NULL, 'af19d806-a66e-4d43-acaf-96a3f3d5dd2c', 'deposit', 2022000.00, '2025-02-10', '17:32:53', NULL, 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-02-10 17:32:53', '2025-02-10 17:32:53', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16147, NULL, 'af19d806-a66e-4d43-acaf-96a3f3d5dd2c', 'deposit', 2022000.00, '2025-02-10', '17:32:53', NULL, 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-02-10 17:32:53', '2025-02-10 17:32:53', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16148, NULL, 'ee43ee1a-48fb-4a26-8d72-abdbddfd167b', 'deposit', 1041.00, '2025-02-10', '17:33:24', '', 0.00, 144, 'Maten', NULL, NULL, NULL, NULL, '2025-02-10 17:33:24', '2025-02-10 17:33:24', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16149, NULL, 'ee43ee1a-48fb-4a26-8d72-abdbddfd167b', 'deposit', 1041.00, '2025-02-10', '17:33:24', '', 0.00, 144, 'Maten', NULL, NULL, NULL, NULL, '2025-02-10 17:33:24', '2025-02-10 17:33:24', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16166, NULL, '87f5b86f-d2b8-4697-b257-2328161d34cc', 'withdrawal', 1535.00, '2025-02-10', '18:09:14', NULL, 0.00, 144, 'Ashty azad', NULL, NULL, NULL, NULL, '2025-02-10 18:09:14', '2025-02-10 18:09:14', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16167, NULL, '87f5b86f-d2b8-4697-b257-2328161d34cc', 'withdrawal', 1535.00, '2025-02-10', '18:09:14', NULL, 0.00, 144, 'Ashty azad', NULL, NULL, NULL, NULL, '2025-02-10 18:09:14', '2025-02-10 18:09:14', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16170, NULL, 'd871bf00-4c43-4f65-870e-e4ed928d91f5', 'deposit', 1535.00, '2025-02-10', '18:12:31', NULL, 0.00, 1, 'Wargera', NULL, NULL, NULL, NULL, '2025-02-10 18:12:31', '2025-02-10 18:12:31', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16171, NULL, 'd871bf00-4c43-4f65-870e-e4ed928d91f5', 'deposit', 1535.00, '2025-02-10', '18:12:31', NULL, 0.00, 1, 'Wargera', NULL, NULL, NULL, NULL, '2025-02-10 18:12:31', '2025-02-10 18:12:31', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16172, NULL, 'd871bf00-4c43-4f65-870e-e4ed928d91f5', 'deposit', 0.00, '2025-02-10', '18:12:31', 'Fee collected for deposit', 0.00, 1, 'Wargera', NULL, NULL, NULL, NULL, '2025-02-10 18:12:31', '2025-02-10 18:12:31', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16221, NULL, '456ed618-0c4c-4c67-9922-31762187fac0', 'withdrawal', 500.00, '2025-02-10', '19:45:37', NULL, 0.00, 144, 'k shamal', NULL, NULL, NULL, NULL, '2025-02-10 19:45:37', '2025-02-10 19:45:37', 199, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16222, NULL, '456ed618-0c4c-4c67-9922-31762187fac0', 'withdrawal', 500.00, '2025-02-10', '19:45:37', NULL, 0.00, 144, 'k shamal', NULL, NULL, NULL, NULL, '2025-02-10 19:45:37', '2025-02-10 19:45:37', 2, 199, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16249, NULL, 'd1d8a810-3312-4c00-9489-85c54b7b87e0', 'deposit', 1500000.00, '2025-02-10', '20:33:25', NULL, 0.00, 136, 'Dlovan ', NULL, NULL, NULL, NULL, '2025-02-10 20:33:25', '2025-02-10 20:33:25', 196, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16250, NULL, 'd1d8a810-3312-4c00-9489-85c54b7b87e0', 'deposit', 1500000.00, '2025-02-10', '20:33:25', NULL, 0.00, 136, 'Dlovan ', NULL, NULL, NULL, NULL, '2025-02-10 20:33:25', '2025-02-10 20:33:25', 2, 196, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16253, NULL, '3d34eb47-51ce-44e8-b590-3118d69da7f9', 'deposit', 3000.00, '2025-02-10', '20:38:44', NULL, 0.00, 136, 'Rawa mahrewan jalal ', NULL, NULL, NULL, NULL, '2025-02-10 20:38:44', '2025-02-10 20:38:44', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16254, NULL, '3d34eb47-51ce-44e8-b590-3118d69da7f9', 'deposit', 3000.00, '2025-02-10', '20:38:44', NULL, 0.00, 136, 'Rawa mahrewan jalal ', NULL, NULL, NULL, NULL, '2025-02-10 20:38:44', '2025-02-10 20:38:44', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16303, NULL, 'a9325269-c690-4984-ac9d-49b6ea081d5a', 'withdrawal', 50000.00, '2025-02-10', '21:31:05', NULL, 0.00, 136, 'Asa', NULL, NULL, NULL, NULL, '2025-02-10 21:31:05', '2025-02-10 21:31:05', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16304, NULL, 'a9325269-c690-4984-ac9d-49b6ea081d5a', 'withdrawal', 50000.00, '2025-02-10', '21:31:05', NULL, 0.00, 136, 'Asa', NULL, NULL, NULL, NULL, '2025-02-10 21:31:05', '2025-02-10 21:31:05', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16319, NULL, 'cbf75afb-518e-4414-ab17-00c1d676ec42', 'deposit', 10005.00, '2025-02-10', '21:53:33', NULL, 0.00, 144, 'Muhamad halgurd', NULL, NULL, NULL, NULL, '2025-02-10 21:53:33', '2025-02-10 21:53:33', 1103, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16320, NULL, 'cbf75afb-518e-4414-ab17-00c1d676ec42', 'deposit', 10005.00, '2025-02-10', '21:53:33', NULL, 0.00, 144, 'Muhamad halgurd', NULL, NULL, NULL, NULL, '2025-02-10 21:53:33', '2025-02-10 21:53:33', 1, 1103, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16371, NULL, '5e983b83-180e-40a4-9be4-9accd8759783', 'withdrawal', 8000000.00, '2025-02-10', '22:22:29', NULL, 0.00, 136, 'Kak amo', NULL, NULL, NULL, NULL, '2025-02-10 22:22:29', '2025-02-10 22:22:29', 417, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16372, NULL, '5e983b83-180e-40a4-9be4-9accd8759783', 'withdrawal', 8000000.00, '2025-02-10', '22:22:29', NULL, 0.00, 136, 'Kak amo', NULL, NULL, NULL, NULL, '2025-02-10 22:22:29', '2025-02-10 22:22:29', 2, 417, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16395, NULL, '6ca1882c-97db-4c7d-9767-b89ca370f196', 'deposit', 5500.00, '2025-02-11', '09:36:04', NULL, 0.00, 144, 'Ahmad pshtewan khurshid', NULL, NULL, NULL, NULL, '2025-02-11 09:36:04', '2025-02-11 09:36:04', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16396, NULL, '6ca1882c-97db-4c7d-9767-b89ca370f196', 'deposit', 5500.00, '2025-02-11', '09:36:04', NULL, 0.00, 144, 'Ahmad pshtewan khurshid', NULL, NULL, NULL, NULL, '2025-02-11 09:36:04', '2025-02-11 09:36:04', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16459, NULL, '6e08e7bb-44e8-43af-9d9d-2a0ce5cbe5a9', 'deposit', 32000000.00, '2025-02-11', '12:10:55', NULL, 0.00, 136, 'Hozan', NULL, NULL, NULL, NULL, '2025-02-11 12:10:55', '2025-02-11 12:10:55', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16460, NULL, '6e08e7bb-44e8-43af-9d9d-2a0ce5cbe5a9', 'deposit', 32000000.00, '2025-02-11', '12:10:55', NULL, 0.00, 136, 'Hozan', NULL, NULL, NULL, NULL, '2025-02-11 12:10:55', '2025-02-11 12:10:55', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16461, NULL, '6a953bb5-bcf2-4085-bf34-440d7ec6f9c3', 'deposit', 1491.00, '2025-02-11', '12:11:33', '', 0.00, 136, 'hozan', NULL, NULL, NULL, NULL, '2025-02-11 12:11:33', '2025-02-11 12:11:33', 200, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16462, NULL, '6a953bb5-bcf2-4085-bf34-440d7ec6f9c3', 'deposit', 1491.00, '2025-02-11', '12:11:33', '', 0.00, 136, 'hozan', NULL, NULL, NULL, NULL, '2025-02-11 12:11:33', '2025-02-11 12:11:33', 1, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16586, NULL, '75bf4abf-4eea-4782-bdc6-ff68bd529547', 'withdrawal', 511500.00, '2025-02-11', '15:07:53', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:07:53', '2025-02-11 15:07:53', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16587, NULL, '75bf4abf-4eea-4782-bdc6-ff68bd529547', 'withdrawal', 511500.00, '2025-02-11', '15:07:53', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:07:53', '2025-02-11 15:07:53', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16588, NULL, '75bf4abf-4eea-4782-bdc6-ff68bd529547', 'deposit', 1500.00, '2025-02-11', '15:07:53', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:07:53', '2025-02-11 15:07:53', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16589, NULL, '847ecacb-86d0-4398-a730-09aa942ea783', 'withdrawal', 13019500.00, '2025-02-11', '15:08:12', NULL, 19500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:08:12', '2025-02-11 15:08:12', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16590, NULL, '847ecacb-86d0-4398-a730-09aa942ea783', 'withdrawal', 13019500.00, '2025-02-11', '15:08:12', NULL, 19500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:08:12', '2025-02-11 15:08:12', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16591, NULL, '847ecacb-86d0-4398-a730-09aa942ea783', 'deposit', 19500.00, '2025-02-11', '15:08:12', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:08:12', '2025-02-11 15:08:12', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16592, NULL, 'f84ee41d-0a69-4bff-94f3-6d1b8d9f5d10', 'withdrawal', 1001500.00, '2025-02-11', '15:08:45', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:08:45', '2025-02-11 15:08:45', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16593, NULL, 'f84ee41d-0a69-4bff-94f3-6d1b8d9f5d10', 'withdrawal', 1000000.00, '2025-02-11', '15:08:45', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:08:45', '2025-02-11 15:08:45', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16594, NULL, 'f84ee41d-0a69-4bff-94f3-6d1b8d9f5d10', 'withdrawal', 1001500.00, '2025-02-11', '15:08:45', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:08:45', '2025-02-11 15:08:45', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16619, NULL, '289b9ebb-42fb-4bea-bec1-946beb9fba55', 'withdrawal', 19028500.00, '2025-02-11', '15:42:00', NULL, 28500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:42:00', '2025-02-11 15:42:00', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16620, NULL, '289b9ebb-42fb-4bea-bec1-946beb9fba55', 'withdrawal', 19000000.00, '2025-02-11', '15:42:00', NULL, 28500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:42:00', '2025-02-11 15:42:00', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16621, NULL, '289b9ebb-42fb-4bea-bec1-946beb9fba55', 'withdrawal', 19028500.00, '2025-02-11', '15:42:00', NULL, 28500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 15:42:00', '2025-02-11 15:42:00', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16622, NULL, 'b869ec9b-c8fc-4dac-860b-bd59617134b9', 'deposit', 4000.00, '2025-02-11', '15:44:24', NULL, 0.00, 144, 'Blnd kurdo babakr', NULL, NULL, NULL, NULL, '2025-02-11 15:44:24', '2025-02-11 15:44:24', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16623, NULL, 'b869ec9b-c8fc-4dac-860b-bd59617134b9', 'deposit', 4000.00, '2025-02-11', '15:44:24', NULL, 0.00, 144, 'Blnd kurdo babakr', NULL, NULL, NULL, NULL, '2025-02-11 15:44:24', '2025-02-11 15:44:24', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16666, NULL, 'e91a8fe8-0165-44fe-9023-cadbc5640ace', 'withdrawal', 3125000.00, '2025-02-11', '16:18:59', NULL, 5000.00, 1, 'ZIN CASH', NULL, NULL, NULL, NULL, '2025-02-11 16:18:59', '2025-02-11 16:18:59', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16667, NULL, 'e91a8fe8-0165-44fe-9023-cadbc5640ace', 'withdrawal', 3120000.00, '2025-02-11', '16:18:59', NULL, 5000.00, 1, 'ZIN CASH', NULL, NULL, NULL, NULL, '2025-02-11 16:18:59', '2025-02-11 16:18:59', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16668, NULL, 'e91a8fe8-0165-44fe-9023-cadbc5640ace', 'withdrawal', 3125000.00, '2025-02-11', '16:18:59', NULL, 5000.00, 1, 'ZIN CASH', NULL, NULL, NULL, NULL, '2025-02-11 16:18:59', '2025-02-11 16:18:59', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16681, NULL, 'e3dac91d-6747-436c-85fc-d0ada7514bb4', 'deposit', 35000000.00, '2025-02-11', '16:46:55', NULL, 0.00, 144, 'Sarmand', NULL, NULL, NULL, NULL, '2025-02-11 16:46:55', '2025-02-11 16:46:55', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16682, NULL, 'e3dac91d-6747-436c-85fc-d0ada7514bb4', 'deposit', 35000000.00, '2025-02-11', '16:46:55', NULL, 0.00, 144, 'Sarmand', NULL, NULL, NULL, NULL, '2025-02-11 16:46:55', '2025-02-11 16:46:55', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16685, NULL, 'b8571a6a-a0b6-4255-952a-985c6416eb79', 'withdrawal', 500.00, '2025-02-11', '17:08:13', NULL, 0.00, 136, 'Sarf bo kak shamal', NULL, NULL, NULL, NULL, '2025-02-11 17:08:13', '2025-02-11 17:08:13', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16686, NULL, 'b8571a6a-a0b6-4255-952a-985c6416eb79', 'withdrawal', 500.00, '2025-02-11', '17:08:13', NULL, 0.00, 136, 'Sarf bo kak shamal', NULL, NULL, NULL, NULL, '2025-02-11 17:08:13', '2025-02-11 17:08:13', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16699, NULL, 'c31d1707-ac51-491b-aab2-99386c0704fa', 'deposit', 8242000.00, '2025-02-11', '17:59:19', NULL, 0.00, 144, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-11 17:59:19', '2025-02-11 17:59:19', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16700, NULL, 'c31d1707-ac51-491b-aab2-99386c0704fa', 'deposit', 8242000.00, '2025-02-11', '17:59:19', NULL, 0.00, 144, 'hemn fouad', NULL, NULL, NULL, NULL, '2025-02-11 17:59:19', '2025-02-11 17:59:19', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16791, NULL, '27a36134-00f2-418e-8190-a4d9bca6f550', 'withdrawal', 7000.00, '2025-02-11', '20:31:11', NULL, 0.00, 1, 'korek', NULL, NULL, NULL, NULL, '2025-02-11 20:31:11', '2025-02-11 20:31:11', 222, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16792, NULL, '27a36134-00f2-418e-8190-a4d9bca6f550', 'withdrawal', 7000.00, '2025-02-11', '20:31:11', NULL, 0.00, 1, 'korek', NULL, NULL, NULL, NULL, '2025-02-11 20:31:11', '2025-02-11 20:31:11', 2, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16793, NULL, '27a36134-00f2-418e-8190-a4d9bca6f550', 'deposit', 0.00, '2025-02-11', '20:31:11', 'Fee collected for withdrawal', 0.00, 1, 'korek', NULL, NULL, NULL, NULL, '2025-02-11 20:31:11', '2025-02-11 20:31:11', 23, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(16796, NULL, '3abcd8ce-5cfc-4ffa-93a9-dbf133f9af1d', 'withdrawal', 10.00, '2025-02-11', '20:35:29', NULL, 10.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 20:35:29', '2025-02-11 20:35:29', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16797, NULL, '3abcd8ce-5cfc-4ffa-93a9-dbf133f9af1d', 'withdrawal', 10.00, '2025-02-11', '20:35:29', NULL, 10.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 20:35:29', '2025-02-11 20:35:29', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16798, NULL, '3abcd8ce-5cfc-4ffa-93a9-dbf133f9af1d', 'deposit', 10.00, '2025-02-11', '20:35:29', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 20:35:29', '2025-02-11 20:35:29', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16804, NULL, '99ac6b0d-f2ac-4ca1-ad3a-fda5aae2c17f', 'withdrawal', 50500.00, '2025-02-11', '20:39:31', NULL, 500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:39:31', '2025-02-11 20:39:31', 227, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16805, NULL, '99ac6b0d-f2ac-4ca1-ad3a-fda5aae2c17f', 'withdrawal', 50000.00, '2025-02-11', '20:39:31', NULL, 500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:39:31', '2025-02-11 20:39:31', 69, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16806, NULL, '99ac6b0d-f2ac-4ca1-ad3a-fda5aae2c17f', 'withdrawal', 50500.00, '2025-02-11', '20:39:31', NULL, 500.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:39:31', '2025-02-11 20:39:31', 2, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16807, NULL, '9099b931-ffcc-46e6-a9fd-7a2871d15575', 'withdrawal', 1996000.00, '2025-02-11', '20:40:06', NULL, 8000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:40:06', '2025-02-11 20:40:06', 227, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16808, NULL, '9099b931-ffcc-46e6-a9fd-7a2871d15575', 'withdrawal', 1988000.00, '2025-02-11', '20:40:06', NULL, 8000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:40:06', '2025-02-11 20:40:06', 69, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16809, NULL, '9099b931-ffcc-46e6-a9fd-7a2871d15575', 'withdrawal', 1996000.00, '2025-02-11', '20:40:06', NULL, 8000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:40:06', '2025-02-11 20:40:06', 2, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16810, NULL, '6506602c-bc47-4245-9955-c0b8f03ea71f', 'withdrawal', 512000.00, '2025-02-11', '20:41:45', NULL, 2000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:41:45', '2025-02-11 20:41:45', 227, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16811, NULL, '6506602c-bc47-4245-9955-c0b8f03ea71f', 'withdrawal', 510000.00, '2025-02-11', '20:41:45', NULL, 2000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:41:45', '2025-02-11 20:41:45', 69, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16812, NULL, '6506602c-bc47-4245-9955-c0b8f03ea71f', 'withdrawal', 512000.00, '2025-02-11', '20:41:45', NULL, 2000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:41:45', '2025-02-11 20:41:45', 2, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16813, NULL, '2daf86ba-8665-4ca0-bb66-2ea1bc109746', 'withdrawal', 301000.00, '2025-02-11', '20:47:26', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:47:26', '2025-02-11 20:47:26', 206, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16814, NULL, '2daf86ba-8665-4ca0-bb66-2ea1bc109746', 'withdrawal', 300000.00, '2025-02-11', '20:47:26', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:47:26', '2025-02-11 20:47:26', 69, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16815, NULL, '2daf86ba-8665-4ca0-bb66-2ea1bc109746', 'withdrawal', 301000.00, '2025-02-11', '20:47:26', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:47:26', '2025-02-11 20:47:26', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16816, NULL, '7a934473-8ff0-4d96-9f5a-a96f410ef1fa', 'withdrawal', 591500.00, '2025-02-11', '20:48:59', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 20:48:59', '2025-02-11 20:48:59', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16817, NULL, '7a934473-8ff0-4d96-9f5a-a96f410ef1fa', 'withdrawal', 591500.00, '2025-02-11', '20:48:59', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 20:48:59', '2025-02-11 20:48:59', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16818, NULL, '7a934473-8ff0-4d96-9f5a-a96f410ef1fa', 'deposit', 1500.00, '2025-02-11', '20:48:59', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 20:48:59', '2025-02-11 20:48:59', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16819, NULL, '68e9e3ba-a9de-4819-aa3c-74f1b1d21943', 'withdrawal', 1054000.00, '2025-02-11', '20:51:28', NULL, 4000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:51:28', '2025-02-11 20:51:28', 206, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16820, NULL, '68e9e3ba-a9de-4819-aa3c-74f1b1d21943', 'withdrawal', 1050000.00, '2025-02-11', '20:51:28', NULL, 4000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:51:28', '2025-02-11 20:51:28', 69, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16821, NULL, '68e9e3ba-a9de-4819-aa3c-74f1b1d21943', 'withdrawal', 1054000.00, '2025-02-11', '20:51:28', NULL, 4000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:51:28', '2025-02-11 20:51:28', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16822, NULL, '1f73b686-3c6b-4dfa-a974-63bc709bf973', 'withdrawal', 201000.00, '2025-02-11', '20:52:47', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:52:47', '2025-02-11 20:52:47', 206, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16823, NULL, '1f73b686-3c6b-4dfa-a974-63bc709bf973', 'withdrawal', 200000.00, '2025-02-11', '20:52:47', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:52:47', '2025-02-11 20:52:47', 69, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16824, NULL, '1f73b686-3c6b-4dfa-a974-63bc709bf973', 'withdrawal', 201000.00, '2025-02-11', '20:52:47', NULL, 1000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 20:52:47', '2025-02-11 20:52:47', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16825, NULL, '10b7c71d-068e-41ac-8bc0-d536c44cd4fd', 'deposit', 250.00, '2025-02-11', '20:54:28', NULL, 250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 20:54:28', '2025-02-11 20:54:28', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16826, NULL, '10b7c71d-068e-41ac-8bc0-d536c44cd4fd', 'deposit', 250.00, '2025-02-11', '20:54:28', NULL, 250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 20:54:28', '2025-02-11 20:54:28', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16827, NULL, '10b7c71d-068e-41ac-8bc0-d536c44cd4fd', 'deposit', 250.00, '2025-02-11', '20:54:28', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 20:54:28', '2025-02-11 20:54:28', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16830, NULL, 'e56cb4fe-9b4f-492f-88fe-379ed47cbc5c', 'withdrawal', 500.00, '2025-02-11', '21:00:51', NULL, 0.00, 1, 'sarf k shamal', NULL, NULL, NULL, NULL, '2025-02-11 21:00:51', '2025-02-11 21:00:51', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16831, NULL, 'e56cb4fe-9b4f-492f-88fe-379ed47cbc5c', 'withdrawal', 500.00, '2025-02-11', '21:00:51', NULL, 0.00, 1, 'sarf k shamal', NULL, NULL, NULL, NULL, '2025-02-11 21:00:51', '2025-02-11 21:00:51', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16832, NULL, 'e56cb4fe-9b4f-492f-88fe-379ed47cbc5c', 'deposit', 0.00, '2025-02-11', '21:00:51', 'Fee collected for withdrawal', 0.00, 1, 'sarf k shamal', NULL, NULL, NULL, NULL, '2025-02-11 21:00:51', '2025-02-11 21:00:51', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16833, NULL, '095a9432-cee0-44e3-b511-c670425091d7', 'deposit', 500.00, '2025-02-11', '21:01:10', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:01:10', '2025-02-11 21:01:10', 199, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16834, NULL, '095a9432-cee0-44e3-b511-c670425091d7', 'deposit', 500.00, '2025-02-11', '21:01:10', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:01:10', '2025-02-11 21:01:10', 2, 199, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16835, NULL, '095a9432-cee0-44e3-b511-c670425091d7', 'deposit', 0.00, '2025-02-11', '21:01:10', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:01:10', '2025-02-11 21:01:10', 23, 199, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16840, NULL, 'ecec6750-fa8b-4abd-8e79-0d2fbe533f73', 'withdrawal', 1302250.00, '2025-02-11', '21:04:38', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 21:04:38', '2025-02-11 21:04:38', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16841, NULL, 'ecec6750-fa8b-4abd-8e79-0d2fbe533f73', 'withdrawal', 1300000.00, '2025-02-11', '21:04:38', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 21:04:38', '2025-02-11 21:04:38', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16842, NULL, 'ecec6750-fa8b-4abd-8e79-0d2fbe533f73', 'withdrawal', 1302250.00, '2025-02-11', '21:04:38', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 21:04:38', '2025-02-11 21:04:38', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16843, NULL, 'cc91b0ec-2124-4aaa-ac16-332ba6b8ecdb', 'withdrawal', 1000.00, '2025-02-11', '21:05:13', NULL, 1000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:05:13', '2025-02-11 21:05:13', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16844, NULL, 'cc91b0ec-2124-4aaa-ac16-332ba6b8ecdb', 'withdrawal', 1000.00, '2025-02-11', '21:05:13', NULL, 1000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:05:13', '2025-02-11 21:05:13', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16845, NULL, 'cc91b0ec-2124-4aaa-ac16-332ba6b8ecdb', 'deposit', 1000.00, '2025-02-11', '21:05:13', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:05:13', '2025-02-11 21:05:13', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16849, NULL, '4aa140ef-e9be-4a22-ac33-36368aa51a04', 'withdrawal', 6810250.00, '2025-02-11', '21:08:23', NULL, 10250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 21:08:23', '2025-02-11 21:08:23', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16850, NULL, '4aa140ef-e9be-4a22-ac33-36368aa51a04', 'withdrawal', 6800000.00, '2025-02-11', '21:08:23', NULL, 10250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 21:08:23', '2025-02-11 21:08:23', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16851, NULL, '4aa140ef-e9be-4a22-ac33-36368aa51a04', 'withdrawal', 6810250.00, '2025-02-11', '21:08:23', NULL, 10250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-11 21:08:23', '2025-02-11 21:08:23', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16852, NULL, '76b18f16-9db5-4459-93f2-6d2987ee34d2', 'deposit', 15000000.00, '2025-02-11', '21:11:52', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-11 21:11:52', '2025-02-11 21:11:52', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16853, NULL, '76b18f16-9db5-4459-93f2-6d2987ee34d2', 'deposit', 15000000.00, '2025-02-11', '21:11:52', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-11 21:11:52', '2025-02-11 21:11:52', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16854, NULL, '76b18f16-9db5-4459-93f2-6d2987ee34d2', 'deposit', 15000000.00, '2025-02-11', '21:11:52', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-11 21:11:52', '2025-02-11 21:11:52', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16855, NULL, 'e626f7dc-3c2e-434d-b360-dde937c5a0ce', 'withdrawal', 2250.00, '2025-02-11', '21:12:32', NULL, 2250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:12:32', '2025-02-11 21:12:32', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16856, NULL, 'e626f7dc-3c2e-434d-b360-dde937c5a0ce', 'withdrawal', 2250.00, '2025-02-11', '21:12:32', NULL, 2250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:12:32', '2025-02-11 21:12:32', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16857, NULL, 'e626f7dc-3c2e-434d-b360-dde937c5a0ce', 'deposit', 2250.00, '2025-02-11', '21:12:32', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-11 21:12:32', '2025-02-11 21:12:32', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16860, NULL, 'b2117c98-3ec0-4049-bb64-88c5dfe70326', 'withdrawal', 4513500.00, '2025-02-11', '21:15:45', NULL, 13500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-11 21:15:45', '2025-02-11 21:15:45', 171, 4, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16861, NULL, 'b2117c98-3ec0-4049-bb64-88c5dfe70326', 'withdrawal', 4500000.00, '2025-02-11', '21:15:45', NULL, 13500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-11 21:15:45', '2025-02-11 21:15:45', 4, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16862, NULL, 'b2117c98-3ec0-4049-bb64-88c5dfe70326', 'withdrawal', 4513500.00, '2025-02-11', '21:15:45', NULL, 13500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-11 21:15:45', '2025-02-11 21:15:45', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16863, NULL, 'e8e74bfe-78c2-403c-b427-a2b5663bfba9', 'deposit', 990000.00, '2025-02-11', '21:17:16', NULL, 0.00, 1, 'haval book store', NULL, NULL, NULL, NULL, '2025-02-11 21:17:16', '2025-02-11 21:17:16', 253, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16864, NULL, 'e8e74bfe-78c2-403c-b427-a2b5663bfba9', 'deposit', 990000.00, '2025-02-11', '21:17:16', NULL, 0.00, 1, 'haval book store', NULL, NULL, NULL, NULL, '2025-02-11 21:17:16', '2025-02-11 21:17:16', 2, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16865, NULL, 'e8e74bfe-78c2-403c-b427-a2b5663bfba9', 'deposit', 0.00, '2025-02-11', '21:17:16', 'Fee collected for deposit', 0.00, 1, 'haval book store', NULL, NULL, NULL, NULL, '2025-02-11 21:17:16', '2025-02-11 21:17:16', 23, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16866, NULL, '17004d70-1875-49e5-9c51-dc773af299c4', 'deposit', 97.00, '2025-02-11', '21:19:25', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:19:25', '2025-02-11 21:19:25', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16867, NULL, '17004d70-1875-49e5-9c51-dc773af299c4', 'deposit', 97.00, '2025-02-11', '21:19:25', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:19:25', '2025-02-11 21:19:25', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16868, NULL, '17004d70-1875-49e5-9c51-dc773af299c4', 'deposit', 0.00, '2025-02-11', '21:19:25', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:19:25', '2025-02-11 21:19:25', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16871, NULL, '3e12f735-bd9a-4ac3-b814-1a44a744eaee', 'deposit', 220.00, '2025-02-11', '21:20:26', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:20:26', '2025-02-11 21:20:26', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16872, NULL, '3e12f735-bd9a-4ac3-b814-1a44a744eaee', 'deposit', 220.00, '2025-02-11', '21:20:26', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:20:26', '2025-02-11 21:20:26', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16873, NULL, '3e12f735-bd9a-4ac3-b814-1a44a744eaee', 'deposit', 0.00, '2025-02-11', '21:20:26', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:20:26', '2025-02-11 21:20:26', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16874, NULL, '09cc931d-759e-44f8-a262-0bdf44eeb167', 'deposit', 330.00, '2025-02-11', '21:21:25', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:21:25', '2025-02-11 21:21:25', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16875, NULL, '09cc931d-759e-44f8-a262-0bdf44eeb167', 'deposit', 330.00, '2025-02-11', '21:21:25', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:21:25', '2025-02-11 21:21:25', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16876, NULL, '09cc931d-759e-44f8-a262-0bdf44eeb167', 'deposit', 0.00, '2025-02-11', '21:21:25', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:21:25', '2025-02-11 21:21:25', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16877, NULL, '90513b65-8b62-48a9-b91d-82911d0148f6', 'deposit', 56.00, '2025-02-11', '21:22:54', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:22:54', '2025-02-11 21:22:54', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16878, NULL, '90513b65-8b62-48a9-b91d-82911d0148f6', 'deposit', 56.00, '2025-02-11', '21:22:54', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:22:54', '2025-02-11 21:22:54', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16879, NULL, '90513b65-8b62-48a9-b91d-82911d0148f6', 'deposit', 0.00, '2025-02-11', '21:22:54', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-11 21:22:54', '2025-02-11 21:22:54', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16880, NULL, 'a55a0559-c31c-44ac-bb57-65ee59ad9d24', 'withdrawal', 55000.00, '2025-02-11', '21:25:40', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-11 21:25:40', '2025-02-11 21:25:40', 170, 67, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16881, NULL, 'a55a0559-c31c-44ac-bb57-65ee59ad9d24', 'withdrawal', 55000.00, '2025-02-11', '21:25:40', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-11 21:25:40', '2025-02-11 21:25:40', 67, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16882, NULL, 'a55a0559-c31c-44ac-bb57-65ee59ad9d24', 'withdrawal', 55000.00, '2025-02-11', '21:25:40', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-11 21:25:40', '2025-02-11 21:25:40', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16883, NULL, '905d53d9-f0a8-44ed-9e0a-3cb59048f4ee', 'withdrawal', 1005000.00, '2025-02-11', '21:26:47', NULL, 5000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 21:26:47', '2025-02-11 21:26:47', 170, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16884, NULL, '905d53d9-f0a8-44ed-9e0a-3cb59048f4ee', 'withdrawal', 1000000.00, '2025-02-11', '21:26:47', NULL, 5000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 21:26:47', '2025-02-11 21:26:47', 69, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16885, NULL, '905d53d9-f0a8-44ed-9e0a-3cb59048f4ee', 'withdrawal', 1005000.00, '2025-02-11', '21:26:47', NULL, 5000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 21:26:47', '2025-02-11 21:26:47', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16886, NULL, '00e72a2a-17d7-4900-9d02-c8539308e37c', 'deposit', 100.00, '2025-02-11', '21:27:31', NULL, 0.00, 1, 'raqam hsab zyad nardrabu', NULL, NULL, NULL, NULL, '2025-02-11 21:27:31', '2025-02-11 21:27:31', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16887, NULL, '00e72a2a-17d7-4900-9d02-c8539308e37c', 'deposit', 100.00, '2025-02-11', '21:27:31', NULL, 0.00, 1, 'raqam hsab zyad nardrabu', NULL, NULL, NULL, NULL, '2025-02-11 21:27:31', '2025-02-11 21:27:31', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16888, NULL, '00e72a2a-17d7-4900-9d02-c8539308e37c', 'deposit', 0.00, '2025-02-11', '21:27:31', 'Fee collected for deposit', 0.00, 1, 'raqam hsab zyad nardrabu', NULL, NULL, NULL, NULL, '2025-02-11 21:27:31', '2025-02-11 21:27:31', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16889, NULL, '02ef7955-3dbb-4aff-bc8a-0e39da5522c5', 'withdrawal', 1000000.00, '2025-02-11', '21:50:37', NULL, 0.00, 136, 'shhla ahmed', NULL, NULL, NULL, NULL, '2025-02-11 21:50:37', '2025-02-11 21:50:37', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16890, NULL, '02ef7955-3dbb-4aff-bc8a-0e39da5522c5', 'withdrawal', 1000000.00, '2025-02-11', '21:50:37', NULL, 0.00, 136, 'shhla ahmed', NULL, NULL, NULL, NULL, '2025-02-11 21:50:37', '2025-02-11 21:50:37', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16897, NULL, 'e4c12f43-8df6-40a4-bb1b-e34915e98245', 'deposit', 1535.00, '2025-02-11', '21:58:24', NULL, 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-11 21:58:24', '2025-02-11 21:58:24', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16898, NULL, 'e4c12f43-8df6-40a4-bb1b-e34915e98245', 'deposit', 1535.00, '2025-02-11', '21:58:24', NULL, 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-11 21:58:24', '2025-02-11 21:58:24', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16899, NULL, 'e4c12f43-8df6-40a4-bb1b-e34915e98245', 'deposit', 0.00, '2025-02-11', '21:58:24', 'Fee collected for deposit', 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-11 21:58:24', '2025-02-11 21:58:24', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16900, NULL, '9818901d-0a2f-4da8-ab9e-4c687c165afb', 'withdrawal', 1535.00, '2025-02-11', '21:59:26', NULL, 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-11 21:59:26', '2025-02-11 21:59:26', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16901, NULL, '9818901d-0a2f-4da8-ab9e-4c687c165afb', 'withdrawal', 1535.00, '2025-02-11', '21:59:26', NULL, 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-11 21:59:26', '2025-02-11 21:59:26', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16902, NULL, '9818901d-0a2f-4da8-ab9e-4c687c165afb', 'deposit', 0.00, '2025-02-11', '21:59:26', 'Fee collected for withdrawal', 0.00, 1, 'ashti azad', NULL, NULL, NULL, NULL, '2025-02-11 21:59:26', '2025-02-11 21:59:26', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16903, NULL, 'cb1e3c43-411f-4f5d-af0a-843a5e7ae540', 'deposit', 4333.00, '2025-02-11', '22:03:05', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-11 22:03:05', '2025-02-11 22:03:05', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16904, NULL, 'cb1e3c43-411f-4f5d-af0a-843a5e7ae540', 'withdrawal', 4333.00, '2025-02-11', '22:03:05', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-11 22:03:05', '2025-02-11 22:03:05', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16905, NULL, 'cb1e3c43-411f-4f5d-af0a-843a5e7ae540', 'withdrawal', 6505999.50, '2025-02-11', '22:03:05', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-11 22:03:05', '2025-02-11 22:03:05', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16906, NULL, 'cb1e3c43-411f-4f5d-af0a-843a5e7ae540', 'deposit', 6505999.50, '2025-02-11', '22:03:05', 'شکانەوە لەسەر داواکاری خۆی', 1501.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-11 22:03:05', '2025-02-11 22:03:05', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16907, NULL, '4151e9b7-c8c1-4abf-947d-f8f21c9071ac', 'deposit', 3324000.00, '2025-02-11', '22:10:26', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 22:10:26', '2025-02-11 22:10:26', 1098, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16908, NULL, '4151e9b7-c8c1-4abf-947d-f8f21c9071ac', 'deposit', 3324000.00, '2025-02-11', '22:10:26', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 22:10:26', '2025-02-11 22:10:26', 69, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16909, NULL, '4151e9b7-c8c1-4abf-947d-f8f21c9071ac', 'deposit', 3324000.00, '2025-02-11', '22:10:26', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-11 22:10:26', '2025-02-11 22:10:26', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16910, NULL, '9eaa5800-e35b-482e-94d2-f39cb34495dc', 'withdrawal', 40250.00, '2025-02-12', '09:06:40', NULL, 250.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-12 09:06:40', '2025-02-12 09:06:40', 181, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16911, NULL, '9eaa5800-e35b-482e-94d2-f39cb34495dc', 'withdrawal', 40250.00, '2025-02-12', '09:06:40', NULL, 250.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-12 09:06:40', '2025-02-12 09:06:40', 2, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16912, NULL, '9eaa5800-e35b-482e-94d2-f39cb34495dc', 'deposit', 250.00, '2025-02-12', '09:06:40', 'Fee collected for withdrawal', 0.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-12 09:06:40', '2025-02-12 09:06:40', 23, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16913, NULL, 'c14e830d-db07-44d2-a20f-2e3c81a9d0a4', 'deposit', 250.00, '2025-02-12', '09:07:09', NULL, 250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 09:07:09', '2025-02-12 09:07:09', 181, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16914, NULL, 'c14e830d-db07-44d2-a20f-2e3c81a9d0a4', 'deposit', 250.00, '2025-02-12', '09:07:09', NULL, 250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 09:07:09', '2025-02-12 09:07:09', 2, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16915, NULL, 'c14e830d-db07-44d2-a20f-2e3c81a9d0a4', 'deposit', 250.00, '2025-02-12', '09:07:09', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 09:07:09', '2025-02-12 09:07:09', 23, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16916, NULL, '00a2a091-8bbf-4186-a3c7-d7d0fb88668d', 'deposit', 6000.00, '2025-02-12', '09:10:10', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-12 09:10:10', '2025-02-12 09:10:10', 416, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16917, NULL, '00a2a091-8bbf-4186-a3c7-d7d0fb88668d', 'deposit', 6000.00, '2025-02-12', '09:10:10', NULL, 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-12 09:10:10', '2025-02-12 09:10:10', 1, 416, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16918, NULL, '00a2a091-8bbf-4186-a3c7-d7d0fb88668d', 'deposit', 0.00, '2025-02-12', '09:10:10', 'Fee collected for deposit', 0.00, 1, 'hisabe kona bo taza', NULL, NULL, NULL, NULL, '2025-02-12 09:10:10', '2025-02-12 09:10:10', 22, 416, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16929, NULL, 'cbd5c402-2b65-4025-9c24-52844a11f147', 'deposit', 6036000.00, '2025-02-12', '09:23:43', NULL, 12000.00, 1, 'basra-abdrazaq sami', NULL, NULL, NULL, NULL, '2025-02-12 09:23:43', '2025-02-12 09:23:43', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(16930, NULL, 'cbd5c402-2b65-4025-9c24-52844a11f147', 'deposit', 6036000.00, '2025-02-12', '09:23:43', NULL, 12000.00, 1, 'basra-abdrazaq sami', NULL, NULL, NULL, NULL, '2025-02-12 09:23:43', '2025-02-12 09:23:43', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16931, NULL, 'cbd5c402-2b65-4025-9c24-52844a11f147', 'deposit', 12000.00, '2025-02-12', '09:23:43', 'Fee collected for deposit', 0.00, 1, 'basra-abdrazaq sami', NULL, NULL, NULL, NULL, '2025-02-12 09:23:43', '2025-02-12 09:23:43', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16939, NULL, 'c8224f9c-dc31-42dc-a9b4-f09f84dcba2b', 'withdrawal', 550.00, '2025-02-12', '10:23:35', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-12 10:23:35', '2025-02-12 10:23:35', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16940, NULL, 'c8224f9c-dc31-42dc-a9b4-f09f84dcba2b', 'withdrawal', 550.00, '2025-02-12', '10:23:35', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-12 10:23:35', '2025-02-12 10:23:35', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16941, NULL, 'c8224f9c-dc31-42dc-a9b4-f09f84dcba2b', 'deposit', 0.00, '2025-02-12', '10:23:35', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-12 10:23:35', '2025-02-12 10:23:35', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16942, NULL, '73ffbc59-dfcd-463d-8718-a703a68e7312', 'withdrawal', 50500.00, '2025-02-12', '10:24:01', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:24:01', '2025-02-12 10:24:01', 168, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16943, NULL, '73ffbc59-dfcd-463d-8718-a703a68e7312', 'withdrawal', 50500.00, '2025-02-12', '10:24:01', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:24:01', '2025-02-12 10:24:01', 2, 168, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16944, NULL, '73ffbc59-dfcd-463d-8718-a703a68e7312', 'deposit', 500.00, '2025-02-12', '10:24:01', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:24:01', '2025-02-12 10:24:01', 23, 168, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16953, NULL, 'd1710277-fe43-462a-bba1-56871d6df62b', 'withdrawal', 501000.00, '2025-02-12', '10:35:12', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:35:12', '2025-02-12 10:35:12', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16954, NULL, 'd1710277-fe43-462a-bba1-56871d6df62b', 'withdrawal', 500000.00, '2025-02-12', '10:35:12', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:35:12', '2025-02-12 10:35:12', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16955, NULL, 'd1710277-fe43-462a-bba1-56871d6df62b', 'withdrawal', 501000.00, '2025-02-12', '10:35:12', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:35:12', '2025-02-12 10:35:12', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16956, NULL, '898aa2c3-5eb3-4fd3-9ea7-4fb697062ba5', 'deposit', 10500000.00, '2025-02-12', '10:36:11', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-12 10:36:11', '2025-02-12 10:36:11', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16957, NULL, '898aa2c3-5eb3-4fd3-9ea7-4fb697062ba5', 'deposit', 10500000.00, '2025-02-12', '10:36:11', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-12 10:36:11', '2025-02-12 10:36:11', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16958, NULL, '898aa2c3-5eb3-4fd3-9ea7-4fb697062ba5', 'deposit', 10500000.00, '2025-02-12', '10:36:11', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-12 10:36:11', '2025-02-12 10:36:11', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16963, NULL, '4764881d-0825-4848-833d-0e79e3b65485', 'withdrawal', 990000.00, '2025-02-12', '10:37:29', NULL, 0.00, 1, 'mustafa eyada sadi', NULL, NULL, NULL, NULL, '2025-02-12 10:37:29', '2025-02-12 10:37:29', 253, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16964, NULL, '4764881d-0825-4848-833d-0e79e3b65485', 'withdrawal', 990000.00, '2025-02-12', '10:37:29', NULL, 0.00, 1, 'mustafa eyada sadi', NULL, NULL, NULL, NULL, '2025-02-12 10:37:29', '2025-02-12 10:37:29', 2, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16965, NULL, '4764881d-0825-4848-833d-0e79e3b65485', 'deposit', 0.00, '2025-02-12', '10:37:29', 'Fee collected for withdrawal', 0.00, 1, 'mustafa eyada sadi', NULL, NULL, NULL, NULL, '2025-02-12 10:37:29', '2025-02-12 10:37:29', 23, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16980, NULL, 'ea25faf1-e063-4da7-ae9d-fd54e2b3330d', 'withdrawal', 1001500.00, '2025-02-12', '10:53:24', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:53:24', '2025-02-12 10:53:24', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16981, NULL, 'ea25faf1-e063-4da7-ae9d-fd54e2b3330d', 'withdrawal', 1000000.00, '2025-02-12', '10:53:24', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:53:24', '2025-02-12 10:53:24', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(16982, NULL, 'ea25faf1-e063-4da7-ae9d-fd54e2b3330d', 'withdrawal', 1001500.00, '2025-02-12', '10:53:24', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 10:53:24', '2025-02-12 10:53:24', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17017, NULL, 'c547dc1e-2e4f-46a3-8c21-40e08b003c91', 'withdrawal', 19108500.00, '2025-02-12', '12:33:55', NULL, 28500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 12:33:55', '2025-02-12 12:33:55', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17018, NULL, 'c547dc1e-2e4f-46a3-8c21-40e08b003c91', 'withdrawal', 19080000.00, '2025-02-12', '12:33:55', NULL, 28500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 12:33:55', '2025-02-12 12:33:55', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17019, NULL, 'c547dc1e-2e4f-46a3-8c21-40e08b003c91', 'withdrawal', 19108500.00, '2025-02-12', '12:33:55', NULL, 28500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 12:33:55', '2025-02-12 12:33:55', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17040, NULL, '4cd4402e-fcb3-4ec9-b943-ba2f6692bc02', 'withdrawal', 130500.00, '2025-02-12', '12:48:40', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 12:48:40', '2025-02-12 12:48:40', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17041, NULL, '4cd4402e-fcb3-4ec9-b943-ba2f6692bc02', 'withdrawal', 130000.00, '2025-02-12', '12:48:40', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 12:48:40', '2025-02-12 12:48:40', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17042, NULL, '4cd4402e-fcb3-4ec9-b943-ba2f6692bc02', 'withdrawal', 130500.00, '2025-02-12', '12:48:40', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 12:48:40', '2025-02-12 12:48:40', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17053, NULL, '429aa8c9-e29f-4338-a4e9-b0df9e733134', 'deposit', 1000.00, '2025-02-12', '13:25:19', NULL, 0.00, 132, 'rawa marewan jalal', NULL, NULL, NULL, NULL, '2025-02-12 13:25:19', '2025-02-12 13:25:19', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17054, NULL, '429aa8c9-e29f-4338-a4e9-b0df9e733134', 'deposit', 1000.00, '2025-02-12', '13:25:19', NULL, 0.00, 132, 'rawa marewan jalal', NULL, NULL, NULL, NULL, '2025-02-12 13:25:19', '2025-02-12 13:25:19', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17055, NULL, 'eb73e313-d3c7-4731-9ba7-d07d6647b21f', 'withdrawal', 18748000.00, '2025-02-12', '13:43:28', NULL, 28000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 13:43:28', '2025-02-12 13:43:28', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17056, NULL, 'eb73e313-d3c7-4731-9ba7-d07d6647b21f', 'withdrawal', 18720000.00, '2025-02-12', '13:43:28', NULL, 28000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 13:43:28', '2025-02-12 13:43:28', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17057, NULL, 'eb73e313-d3c7-4731-9ba7-d07d6647b21f', 'withdrawal', 18748000.00, '2025-02-12', '13:43:28', NULL, 28000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 13:43:28', '2025-02-12 13:43:28', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17058, NULL, 'daec9bfb-7106-4df6-b51e-1fc675832521', 'withdrawal', 401500.00, '2025-02-12', '13:45:10', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 13:45:10', '2025-02-12 13:45:10', 206, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17059, NULL, 'daec9bfb-7106-4df6-b51e-1fc675832521', 'withdrawal', 400000.00, '2025-02-12', '13:45:10', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 13:45:10', '2025-02-12 13:45:10', 18, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17060, NULL, 'daec9bfb-7106-4df6-b51e-1fc675832521', 'withdrawal', 401500.00, '2025-02-12', '13:45:10', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 13:45:10', '2025-02-12 13:45:10', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17073, NULL, 'e1f79006-b347-4774-92ed-9f7b3f3a9d6d', 'withdrawal', 500.00, '2025-02-12', '14:05:58', NULL, 0.00, 132, 'Muhamad samer younns               ', NULL, NULL, NULL, NULL, '2025-02-12 14:05:58', '2025-02-12 14:05:58', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17074, NULL, 'e1f79006-b347-4774-92ed-9f7b3f3a9d6d', 'withdrawal', 500.00, '2025-02-12', '14:05:58', NULL, 0.00, 132, 'Muhamad samer younns               ', NULL, NULL, NULL, NULL, '2025-02-12 14:05:58', '2025-02-12 14:05:58', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17085, NULL, '0587d86e-e515-4ad6-9aa0-efc79429f2f5', 'deposit', 20255000.00, '2025-02-12', '14:22:26', NULL, 0.00, 1, 'sarmand', NULL, NULL, NULL, NULL, '2025-02-12 14:22:26', '2025-02-12 14:22:26', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17086, NULL, '0587d86e-e515-4ad6-9aa0-efc79429f2f5', 'deposit', 20255000.00, '2025-02-12', '14:22:26', NULL, 0.00, 1, 'sarmand', NULL, NULL, NULL, NULL, '2025-02-12 14:22:26', '2025-02-12 14:22:26', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17087, NULL, '0587d86e-e515-4ad6-9aa0-efc79429f2f5', 'deposit', 0.00, '2025-02-12', '14:22:26', 'Fee collected for deposit', 0.00, 1, 'sarmand', NULL, NULL, NULL, NULL, '2025-02-12 14:22:26', '2025-02-12 14:22:26', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17088, NULL, '8dd053a9-3653-4bc0-84af-494ede1ea01c', 'deposit', 5000.00, '2025-02-12', '14:27:45', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-12 14:27:45', '2025-02-12 14:27:45', 196, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17089, NULL, '8dd053a9-3653-4bc0-84af-494ede1ea01c', 'deposit', 5000.00, '2025-02-12', '14:27:45', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-12 14:27:45', '2025-02-12 14:27:45', 2, 196, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17090, NULL, '8dd053a9-3653-4bc0-84af-494ede1ea01c', 'deposit', 0.00, '2025-02-12', '14:27:45', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-12 14:27:45', '2025-02-12 14:27:45', 23, 196, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17091, NULL, '522fc880-0517-4792-9fde-a58d2a8cff70', 'withdrawal', 5308000.00, '2025-02-12', '14:31:44', NULL, 8000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 14:31:44', '2025-02-12 14:31:44', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17092, NULL, '522fc880-0517-4792-9fde-a58d2a8cff70', 'withdrawal', 5300000.00, '2025-02-12', '14:31:44', NULL, 8000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 14:31:44', '2025-02-12 14:31:44', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17093, NULL, '522fc880-0517-4792-9fde-a58d2a8cff70', 'withdrawal', 5308000.00, '2025-02-12', '14:31:44', NULL, 8000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 14:31:44', '2025-02-12 14:31:44', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17096, NULL, 'dc486f08-dae0-4369-9bf8-41bd31f8a8cd', 'withdrawal', 20500.00, '2025-02-12', '14:41:15', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 14:41:15', '2025-02-12 14:41:15', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17097, NULL, 'dc486f08-dae0-4369-9bf8-41bd31f8a8cd', 'withdrawal', 20000.00, '2025-02-12', '14:41:15', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 14:41:15', '2025-02-12 14:41:15', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17098, NULL, 'dc486f08-dae0-4369-9bf8-41bd31f8a8cd', 'withdrawal', 20500.00, '2025-02-12', '14:41:15', NULL, 500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-12 14:41:15', '2025-02-12 14:41:15', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17099, NULL, '1e1ce050-7982-44ce-ab01-e97fb8e58a03', 'withdrawal', 500.00, '2025-02-12', '14:42:35', 'شکانەوە لەسەر داواکاری خۆی', 1503.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-12 14:42:35', '2025-02-12 14:42:35', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17100, NULL, '1e1ce050-7982-44ce-ab01-e97fb8e58a03', 'deposit', 500.00, '2025-02-12', '14:42:35', 'شکانەوە لەسەر داواکاری خۆی', 1503.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-12 14:42:35', '2025-02-12 14:42:35', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17101, NULL, '1e1ce050-7982-44ce-ab01-e97fb8e58a03', 'deposit', 751500.00, '2025-02-12', '14:42:35', 'شکانەوە لەسەر داواکاری خۆی', 1503.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-12 14:42:35', '2025-02-12 14:42:35', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17102, NULL, '1e1ce050-7982-44ce-ab01-e97fb8e58a03', 'withdrawal', 751500.00, '2025-02-12', '14:42:35', 'شکانەوە لەسەر داواکاری خۆی', 1503.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-12 14:42:35', '2025-02-12 14:42:35', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17113, NULL, '08401af6-0320-48e2-97ee-61b7da779fcf', 'withdrawal', 5000.00, '2025-02-12', '14:58:12', NULL, 0.00, 132, 'Rawand abdulla rasul', NULL, NULL, NULL, NULL, '2025-02-12 14:58:12', '2025-02-12 14:58:12', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17114, NULL, '08401af6-0320-48e2-97ee-61b7da779fcf', 'withdrawal', 5000.00, '2025-02-12', '14:58:12', NULL, 0.00, 132, 'Rawand abdulla rasul', NULL, NULL, NULL, NULL, '2025-02-12 14:58:12', '2025-02-12 14:58:12', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17115, NULL, 'a3870727-da12-4d1c-b721-cbf139fbdd27', 'withdrawal', 1660250.00, '2025-02-12', '15:03:59', '', 0.00, 132, 'Muhamad halgurd gafur', NULL, NULL, NULL, NULL, '2025-02-12 15:03:59', '2025-02-12 15:03:59', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17116, NULL, 'a3870727-da12-4d1c-b721-cbf139fbdd27', 'withdrawal', 1660250.00, '2025-02-12', '15:03:59', '', 0.00, 132, 'Muhamad halgurd gafur', NULL, NULL, NULL, NULL, '2025-02-12 15:03:59', '2025-02-12 15:03:59', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17145, NULL, 'ea03fba1-9065-4693-92aa-49b7d1a3523e', 'withdrawal', 171.00, '2025-02-12', '15:26:08', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 15:26:08', '2025-02-12 15:26:08', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17146, NULL, 'ea03fba1-9065-4693-92aa-49b7d1a3523e', 'withdrawal', 171.00, '2025-02-12', '15:26:08', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 15:26:08', '2025-02-12 15:26:08', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17147, NULL, 'ea03fba1-9065-4693-92aa-49b7d1a3523e', 'deposit', 0.00, '2025-02-12', '15:26:08', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 15:26:08', '2025-02-12 15:26:08', 23, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17148, NULL, 'c5d71bca-c3a8-4d14-9b92-76b6d0275334', 'deposit', 1.00, '2025-02-12', '15:26:31', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 15:26:31', '2025-02-12 15:26:31', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17149, NULL, 'c5d71bca-c3a8-4d14-9b92-76b6d0275334', 'deposit', 1.00, '2025-02-12', '15:26:31', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 15:26:31', '2025-02-12 15:26:31', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17150, NULL, 'c5d71bca-c3a8-4d14-9b92-76b6d0275334', 'deposit', 0.00, '2025-02-12', '15:26:31', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-12 15:26:31', '2025-02-12 15:26:31', 23, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17151, NULL, '28430d9e-2510-409a-a746-38a8833613a8', 'deposit', 2028500.00, '2025-02-12', '15:28:05', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-12 15:28:05', '2025-02-12 15:28:05', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17152, NULL, '28430d9e-2510-409a-a746-38a8833613a8', 'deposit', 2028500.00, '2025-02-12', '15:28:05', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-12 15:28:05', '2025-02-12 15:28:05', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17153, NULL, '28430d9e-2510-409a-a746-38a8833613a8', 'deposit', 0.00, '2025-02-12', '15:28:05', 'Fee collected for deposit', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-12 15:28:05', '2025-02-12 15:28:05', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17162, NULL, 'ec1a58c3-617c-46f2-9c99-6acd4e66c208', 'deposit', 5430.00, '2025-02-12', '15:54:40', NULL, -20.00, 1, 'drhm-muhamad ishaq', NULL, NULL, NULL, NULL, '2025-02-12 15:54:40', '2025-02-12 15:54:40', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17163, NULL, 'ec1a58c3-617c-46f2-9c99-6acd4e66c208', 'deposit', 5430.00, '2025-02-12', '15:54:40', NULL, -20.00, 1, 'drhm-muhamad ishaq', NULL, NULL, NULL, NULL, '2025-02-12 15:54:40', '2025-02-12 15:54:40', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17164, NULL, 'ec1a58c3-617c-46f2-9c99-6acd4e66c208', 'deposit', -20.00, '2025-02-12', '15:54:40', 'Fee collected for deposit', 0.00, 1, 'drhm-muhamad ishaq', NULL, NULL, NULL, NULL, '2025-02-12 15:54:40', '2025-02-12 15:54:40', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17169, NULL, '4e3a9ded-de54-492b-aa17-7b063b75e842', 'withdrawal', 3707750.00, '2025-02-12', '15:55:38', NULL, 0.00, 1, 'm.sheni', NULL, NULL, NULL, NULL, '2025-02-12 15:55:38', '2025-02-12 15:55:38', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17170, NULL, '4e3a9ded-de54-492b-aa17-7b063b75e842', 'withdrawal', 3707750.00, '2025-02-12', '15:55:38', NULL, 0.00, 1, 'm.sheni', NULL, NULL, NULL, NULL, '2025-02-12 15:55:38', '2025-02-12 15:55:38', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17171, NULL, '4e3a9ded-de54-492b-aa17-7b063b75e842', 'deposit', 0.00, '2025-02-12', '15:55:38', 'Fee collected for withdrawal', 0.00, 1, 'm.sheni', NULL, NULL, NULL, NULL, '2025-02-12 15:55:38', '2025-02-12 15:55:38', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17172, NULL, '9d1e3631-84ac-4ffe-bfaa-3dce647d002a', 'withdrawal', 2028500.00, '2025-02-12', '15:56:17', NULL, 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-12 15:56:17', '2025-02-12 15:56:17', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17173, NULL, '9d1e3631-84ac-4ffe-bfaa-3dce647d002a', 'withdrawal', 2028500.00, '2025-02-12', '15:56:17', NULL, 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-12 15:56:17', '2025-02-12 15:56:17', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17174, NULL, '9d1e3631-84ac-4ffe-bfaa-3dce647d002a', 'deposit', 0.00, '2025-02-12', '15:56:17', 'Fee collected for withdrawal', 0.00, 1, 'm.ez', NULL, NULL, NULL, NULL, '2025-02-12 15:56:17', '2025-02-12 15:56:17', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17175, NULL, 'd33803a1-f514-4910-acbd-7ce892cd876a', 'deposit', 3707750.00, '2025-02-12', '15:59:38', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-12 15:59:38', '2025-02-12 15:59:38', 227, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17176, NULL, 'd33803a1-f514-4910-acbd-7ce892cd876a', 'deposit', 3707750.00, '2025-02-12', '15:59:38', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-12 15:59:38', '2025-02-12 15:59:38', 2, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17177, NULL, 'd33803a1-f514-4910-acbd-7ce892cd876a', 'deposit', 0.00, '2025-02-12', '15:59:38', 'Fee collected for deposit', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-12 15:59:38', '2025-02-12 15:59:38', 23, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17316, NULL, '2cd48f66-8bf3-49c7-adab-be0305698c6f', 'deposit', 9700.00, '2025-02-12', '18:26:34', NULL, 0.00, 136, 'Karwan ', NULL, NULL, NULL, NULL, '2025-02-12 18:26:34', '2025-02-12 18:26:34', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17317, NULL, '2cd48f66-8bf3-49c7-adab-be0305698c6f', 'deposit', 9700.00, '2025-02-12', '18:26:34', NULL, 0.00, 136, 'Karwan ', NULL, NULL, NULL, NULL, '2025-02-12 18:26:34', '2025-02-12 18:26:34', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17452, NULL, '938a8ea7-3681-4df3-91db-2ade1300e964', 'deposit', 13000.00, '2025-02-12', '21:44:03', NULL, 0.00, 136, 'Hamadamen', NULL, NULL, NULL, NULL, '2025-02-12 21:44:03', '2025-02-12 21:44:03', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17453, NULL, '938a8ea7-3681-4df3-91db-2ade1300e964', 'deposit', 13000.00, '2025-02-12', '21:44:03', NULL, 0.00, 136, 'Hamadamen', NULL, NULL, NULL, NULL, '2025-02-12 21:44:03', '2025-02-12 21:44:03', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17454, NULL, '5ccc840a-d85c-44cd-ac6a-fe57bae01eef', 'deposit', 2500.00, '2025-02-12', '21:45:03', NULL, 0.00, 1, 'wajbay yakam dra babay', NULL, NULL, NULL, NULL, '2025-02-12 21:45:03', '2025-02-12 21:45:03', 1105, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17455, NULL, '5ccc840a-d85c-44cd-ac6a-fe57bae01eef', 'deposit', 2500.00, '2025-02-12', '21:45:03', NULL, 0.00, 1, 'wajbay yakam dra babay', NULL, NULL, NULL, NULL, '2025-02-12 21:45:03', '2025-02-12 21:45:03', 1, 1105, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17456, NULL, '5ccc840a-d85c-44cd-ac6a-fe57bae01eef', 'deposit', 0.00, '2025-02-12', '21:45:03', 'Fee collected for deposit', 0.00, 1, 'wajbay yakam dra babay', NULL, NULL, NULL, NULL, '2025-02-12 21:45:03', '2025-02-12 21:45:03', 22, 1105, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17457, NULL, '2af0d37e-0902-4c45-9f35-2f0c449f95c4', 'deposit', 1500.00, '2025-02-12', '21:45:45', NULL, 0.00, 1, 'wajbay dwam', NULL, NULL, NULL, NULL, '2025-02-12 21:45:45', '2025-02-12 21:45:45', 1105, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17458, NULL, '2af0d37e-0902-4c45-9f35-2f0c449f95c4', 'deposit', 1500.00, '2025-02-12', '21:45:45', NULL, 0.00, 1, 'wajbay dwam', NULL, NULL, NULL, NULL, '2025-02-12 21:45:45', '2025-02-12 21:45:45', 1, 1105, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17459, NULL, '2af0d37e-0902-4c45-9f35-2f0c449f95c4', 'deposit', 0.00, '2025-02-12', '21:45:45', 'Fee collected for deposit', 0.00, 1, 'wajbay dwam', NULL, NULL, NULL, NULL, '2025-02-12 21:45:45', '2025-02-12 21:45:45', 22, 1105, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17460, NULL, 'ece5bd1f-c091-41f0-99ea-533b0f843091', 'withdrawal', 7000.00, '2025-02-12', '21:46:13', 'bo sayaray payadar sarfkra bo kak shadi', 0.00, 1, 7000, NULL, NULL, NULL, NULL, '2025-02-12 21:46:13', '2025-02-12 21:46:13', 1105, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17461, NULL, 'ece5bd1f-c091-41f0-99ea-533b0f843091', 'withdrawal', 7000.00, '2025-02-12', '21:46:13', 'bo sayaray payadar sarfkra bo kak shadi', 0.00, 1, 7000, NULL, NULL, NULL, NULL, '2025-02-12 21:46:13', '2025-02-12 21:46:13', 1, 1105, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17462, NULL, 'ece5bd1f-c091-41f0-99ea-533b0f843091', 'deposit', 0.00, '2025-02-12', '21:46:13', 'Fee collected for withdrawal', 0.00, 1, 7000, NULL, NULL, NULL, NULL, '2025-02-12 21:46:13', '2025-02-12 21:46:13', 22, 1105, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17499, NULL, '344b6b62-32f2-4565-a658-412791112ff1', 'deposit', 3212000.00, '2025-02-13', '09:37:03', NULL, 0.00, 1, 'hatw qi card jihaz', NULL, NULL, NULL, NULL, '2025-02-13 09:37:03', '2025-02-13 09:37:03', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17500, NULL, '344b6b62-32f2-4565-a658-412791112ff1', 'deposit', 3212000.00, '2025-02-13', '09:37:03', NULL, 0.00, 1, 'hatw qi card jihaz', NULL, NULL, NULL, NULL, '2025-02-13 09:37:03', '2025-02-13 09:37:03', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17501, NULL, '344b6b62-32f2-4565-a658-412791112ff1', 'deposit', 0.00, '2025-02-13', '09:37:03', 'Fee collected for deposit', 0.00, 1, 'hatw qi card jihaz', NULL, NULL, NULL, NULL, '2025-02-13 09:37:03', '2025-02-13 09:37:03', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17504, NULL, 'cc37268f-074a-4f14-9547-c96ab527a2a4', 'deposit', 40556500.00, '2025-02-13', '09:52:15', NULL, 0.00, 1, 'hatw ba dasty kak sarmand', NULL, NULL, NULL, NULL, '2025-02-13 09:52:15', '2025-02-13 09:52:15', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17505, NULL, 'cc37268f-074a-4f14-9547-c96ab527a2a4', 'deposit', 40556500.00, '2025-02-13', '09:52:15', NULL, 0.00, 1, 'hatw ba dasty kak sarmand', NULL, NULL, NULL, NULL, '2025-02-13 09:52:15', '2025-02-13 09:52:15', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17506, NULL, 'cc37268f-074a-4f14-9547-c96ab527a2a4', 'deposit', 0.00, '2025-02-13', '09:52:15', 'Fee collected for deposit', 0.00, 1, 'hatw ba dasty kak sarmand', NULL, NULL, NULL, NULL, '2025-02-13 09:52:15', '2025-02-13 09:52:15', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17507, NULL, '82ae801d-bd1a-47e5-9e46-defcc1af5364', 'withdrawal', 25000000.00, '2025-02-13', '09:54:22', NULL, 0.00, 1, 'ida3 zain cash', NULL, NULL, NULL, NULL, '2025-02-13 09:54:22', '2025-02-13 09:54:22', 470, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17508, NULL, '82ae801d-bd1a-47e5-9e46-defcc1af5364', 'deposit', 25000000.00, '2025-02-13', '09:54:22', NULL, 0.00, 1, 'ida3 zain cash', NULL, NULL, NULL, NULL, '2025-02-13 09:54:22', '2025-02-13 09:54:22', 18, 470, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17509, NULL, '82ae801d-bd1a-47e5-9e46-defcc1af5364', 'deposit', 0.00, '2025-02-13', '09:54:22', 'Fee collected for transfer', 0.00, 1, 'ida3 zain cash', NULL, NULL, NULL, NULL, '2025-02-13 09:54:22', '2025-02-13 09:54:22', 63, 470, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17550, NULL, '7b9f2923-05b7-40dc-8d56-c9a43dbe6254', 'withdrawal', 50000.00, '2025-02-13', '11:32:02', NULL, 0.00, 1, 'xalid jabar xalil', NULL, NULL, NULL, NULL, '2025-02-13 11:32:02', '2025-02-13 11:32:02', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(17551, NULL, '7b9f2923-05b7-40dc-8d56-c9a43dbe6254', 'withdrawal', 50000.00, '2025-02-13', '11:32:02', NULL, 0.00, 1, 'xalid jabar xalil', NULL, NULL, NULL, NULL, '2025-02-13 11:32:02', '2025-02-13 11:32:02', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17552, NULL, '7b9f2923-05b7-40dc-8d56-c9a43dbe6254', 'deposit', 0.00, '2025-02-13', '11:32:02', 'Fee collected for withdrawal', 0.00, 1, 'xalid jabar xalil', NULL, NULL, NULL, NULL, '2025-02-13 11:32:02', '2025-02-13 11:32:02', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17553, NULL, 'e24e802f-9ee4-4741-ab13-3101fad0b006', 'withdrawal', 5450.00, '2025-02-13', '11:48:55', NULL, 0.00, 1, 'dubai hawala ', NULL, NULL, NULL, NULL, '2025-02-13 11:48:55', '2025-02-13 11:48:55', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17554, NULL, 'e24e802f-9ee4-4741-ab13-3101fad0b006', 'withdrawal', 5450.00, '2025-02-13', '11:48:55', NULL, 0.00, 1, 'dubai hawala ', NULL, NULL, NULL, NULL, '2025-02-13 11:48:55', '2025-02-13 11:48:55', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17555, NULL, 'e24e802f-9ee4-4741-ab13-3101fad0b006', 'deposit', 0.00, '2025-02-13', '11:48:55', 'Fee collected for withdrawal', 0.00, 1, 'dubai hawala ', NULL, NULL, NULL, NULL, '2025-02-13 11:48:55', '2025-02-13 11:48:55', 22, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17560, NULL, '6d76561c-0aa1-446b-925c-5b487b338f9f', 'deposit', 2400.00, '2025-02-13', '11:56:13', NULL, -100.00, 1, 'sweed', NULL, NULL, NULL, NULL, '2025-02-13 11:56:13', '2025-02-13 11:56:13', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17561, NULL, '6d76561c-0aa1-446b-925c-5b487b338f9f', 'deposit', 2400.00, '2025-02-13', '11:56:13', NULL, 50.00, 1, 'sweed', NULL, NULL, NULL, NULL, '2025-02-13 11:56:13', '2025-02-13 11:56:13', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17562, NULL, '6d76561c-0aa1-446b-925c-5b487b338f9f', 'deposit', 150.00, '2025-02-13', '11:56:13', 'Fee collected for deposit', 0.00, 1, 'sweed', NULL, NULL, NULL, NULL, '2025-02-13 11:56:13', '2025-02-13 11:56:13', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17566, NULL, '288f279e-3243-4e3b-a368-7f796c2ed335', 'withdrawal', 10000.00, '2025-02-13', '11:59:04', NULL, 0.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-13 11:59:04', '2025-02-13 11:59:04', 210, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17567, NULL, '288f279e-3243-4e3b-a368-7f796c2ed335', 'deposit', 10002.00, '2025-02-13', '11:59:04', NULL, 2.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-13 11:59:04', '2025-02-13 11:59:04', 169, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17568, NULL, '288f279e-3243-4e3b-a368-7f796c2ed335', 'deposit', -2.00, '2025-02-13', '11:59:04', 'Fee collected for transfer', 0.00, 1, 'slemani', NULL, NULL, NULL, NULL, '2025-02-13 11:59:04', '2025-02-13 11:59:04', 22, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17607, NULL, '5169e5d2-fd17-4ba3-a719-55a0fb4f3568', 'deposit', 12000.00, '2025-02-13', '12:59:18', NULL, 0.00, 136, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-13 12:59:18', '2025-02-13 12:59:18', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17608, NULL, '5169e5d2-fd17-4ba3-a719-55a0fb4f3568', 'deposit', 12000.00, '2025-02-13', '12:59:18', NULL, 0.00, 136, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-13 12:59:18', '2025-02-13 12:59:18', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17649, NULL, '7468c9f8-1859-4955-8933-6b101ab53447', 'deposit', 4800.00, '2025-02-13', '14:47:32', NULL, 0.00, 136, 'Aram ', NULL, NULL, NULL, NULL, '2025-02-13 14:47:32', '2025-02-13 14:47:32', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17650, NULL, '7468c9f8-1859-4955-8933-6b101ab53447', 'deposit', 4800.00, '2025-02-13', '14:47:32', NULL, 0.00, 136, 'Aram ', NULL, NULL, NULL, NULL, '2025-02-13 14:47:32', '2025-02-13 14:47:32', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17663, NULL, '8ae109c4-2fe6-4fd7-aad7-7651813e09d6', 'withdrawal', 21900000.00, '2025-02-13', '15:20:04', NULL, 0.00, 1, 'imad law braim', NULL, NULL, NULL, NULL, '2025-02-13 15:20:04', '2025-02-13 15:20:04', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17664, NULL, '8ae109c4-2fe6-4fd7-aad7-7651813e09d6', 'withdrawal', 21900000.00, '2025-02-13', '15:20:04', NULL, 0.00, 1, 'imad law braim', NULL, NULL, NULL, NULL, '2025-02-13 15:20:04', '2025-02-13 15:20:04', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17665, NULL, '8ae109c4-2fe6-4fd7-aad7-7651813e09d6', 'deposit', 0.00, '2025-02-13', '15:20:04', 'Fee collected for withdrawal', 0.00, 1, 'imad law braim', NULL, NULL, NULL, NULL, '2025-02-13 15:20:04', '2025-02-13 15:20:04', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17748, NULL, 'fb456396-c885-426b-a2f8-8b7fd77085f1', 'deposit', 2000000.00, '2025-02-13', '17:19:27', NULL, 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-13 17:19:27', '2025-02-13 17:19:27', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17749, NULL, 'fb456396-c885-426b-a2f8-8b7fd77085f1', 'deposit', 2000000.00, '2025-02-13', '17:19:27', NULL, 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-13 17:19:27', '2025-02-13 17:19:27', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17750, NULL, 'fb456396-c885-426b-a2f8-8b7fd77085f1', 'deposit', 0.00, '2025-02-13', '17:19:27', 'Fee collected for deposit', 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-13 17:19:27', '2025-02-13 17:19:27', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17751, NULL, '7063afcf-3ee9-4d35-9f0e-a3a6649eb096', 'withdrawal', 200.00, '2025-02-13', '17:19:43', NULL, 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-13 17:19:43', '2025-02-13 17:19:43', 214, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17752, NULL, '7063afcf-3ee9-4d35-9f0e-a3a6649eb096', 'withdrawal', 200.00, '2025-02-13', '17:19:43', NULL, 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-13 17:19:43', '2025-02-13 17:19:43', 1, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17753, NULL, '7063afcf-3ee9-4d35-9f0e-a3a6649eb096', 'deposit', 0.00, '2025-02-13', '17:19:43', 'Fee collected for withdrawal', 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-13 17:19:43', '2025-02-13 17:19:43', 22, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17816, NULL, 'ea8a6575-8093-44c6-8000-f09a6a23cd24', 'withdrawal', 2010.00, '2025-02-13', '19:01:31', NULL, 10.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 19:01:31', '2025-02-13 19:01:31', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17817, NULL, 'ea8a6575-8093-44c6-8000-f09a6a23cd24', 'withdrawal', 2010.00, '2025-02-13', '19:01:31', NULL, 10.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 19:01:31', '2025-02-13 19:01:31', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17818, NULL, 'ea8a6575-8093-44c6-8000-f09a6a23cd24', 'deposit', 10.00, '2025-02-13', '19:01:31', 'Fee collected for withdrawal', 0.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 19:01:31', '2025-02-13 19:01:31', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17819, NULL, '274a589a-592e-408d-b2e7-8975f6a387e5', 'withdrawal', 850.00, '2025-02-13', '19:01:57', NULL, 0.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 19:01:57', '2025-02-13 19:01:57', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17820, NULL, '274a589a-592e-408d-b2e7-8975f6a387e5', 'withdrawal', 850.00, '2025-02-13', '19:01:57', NULL, 0.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 19:01:57', '2025-02-13 19:01:57', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17821, NULL, '274a589a-592e-408d-b2e7-8975f6a387e5', 'deposit', 0.00, '2025-02-13', '19:01:57', 'Fee collected for withdrawal', 0.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 19:01:57', '2025-02-13 19:01:57', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17824, NULL, '3d129298-b6d3-4901-8e82-8e03da441959', 'withdrawal', 20030000.00, '2025-02-13', '19:03:01', NULL, 30000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 19:03:01', '2025-02-13 19:03:01', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17825, NULL, '3d129298-b6d3-4901-8e82-8e03da441959', 'withdrawal', 20000000.00, '2025-02-13', '19:03:01', NULL, 30000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 19:03:01', '2025-02-13 19:03:01', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17826, NULL, '3d129298-b6d3-4901-8e82-8e03da441959', 'withdrawal', 20030000.00, '2025-02-13', '19:03:01', NULL, 30000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 19:03:01', '2025-02-13 19:03:01', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17837, NULL, '5ffde5e7-a90e-421d-928d-d3d3791fe5c3', 'deposit', 1745000.00, '2025-02-13', '19:07:00', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-13 19:07:00', '2025-02-13 19:07:00', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17838, NULL, '5ffde5e7-a90e-421d-928d-d3d3791fe5c3', 'deposit', 1745000.00, '2025-02-13', '19:07:00', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-13 19:07:00', '2025-02-13 19:07:00', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17839, NULL, '5ffde5e7-a90e-421d-928d-d3d3791fe5c3', 'deposit', 0.00, '2025-02-13', '19:07:00', 'Fee collected for deposit', 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-13 19:07:00', '2025-02-13 19:07:00', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17840, NULL, '16a91ee5-4334-4444-b627-e1ffb5d26db5', 'deposit', 40500.00, '2025-02-13', '19:09:47', NULL, 0.00, 1, 'hatu k shamal', NULL, NULL, NULL, NULL, '2025-02-13 19:09:47', '2025-02-13 19:09:47', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17841, NULL, '16a91ee5-4334-4444-b627-e1ffb5d26db5', 'deposit', 40500.00, '2025-02-13', '19:09:47', NULL, 0.00, 1, 'hatu k shamal', NULL, NULL, NULL, NULL, '2025-02-13 19:09:47', '2025-02-13 19:09:47', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17842, NULL, '16a91ee5-4334-4444-b627-e1ffb5d26db5', 'deposit', 0.00, '2025-02-13', '19:09:47', 'Fee collected for deposit', 0.00, 1, 'hatu k shamal', NULL, NULL, NULL, NULL, '2025-02-13 19:09:47', '2025-02-13 19:09:47', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17843, NULL, 'cf2ef123-9d4d-48a7-a8f9-835b21375420', 'deposit', 4500.00, '2025-02-13', '19:12:10', NULL, 0.00, 1, 'k shamal', NULL, NULL, NULL, NULL, '2025-02-13 19:12:10', '2025-02-13 19:12:10', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17844, NULL, 'cf2ef123-9d4d-48a7-a8f9-835b21375420', 'deposit', 4500.00, '2025-02-13', '19:12:10', NULL, 0.00, 1, 'k shamal', NULL, NULL, NULL, NULL, '2025-02-13 19:12:10', '2025-02-13 19:12:10', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17845, NULL, 'cf2ef123-9d4d-48a7-a8f9-835b21375420', 'deposit', 0.00, '2025-02-13', '19:12:10', 'Fee collected for deposit', 0.00, 1, 'k shamal', NULL, NULL, NULL, NULL, '2025-02-13 19:12:10', '2025-02-13 19:12:10', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17846, NULL, '1e61925c-94dd-4e72-8d14-5eacdb91e9ff', 'deposit', 4513500.00, '2025-02-13', '19:14:51', NULL, 0.00, 1, 'wasl', NULL, NULL, NULL, NULL, '2025-02-13 19:14:51', '2025-02-13 19:14:51', 171, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17847, NULL, '1e61925c-94dd-4e72-8d14-5eacdb91e9ff', 'deposit', 4513500.00, '2025-02-13', '19:14:51', NULL, 0.00, 1, 'wasl', NULL, NULL, NULL, NULL, '2025-02-13 19:14:51', '2025-02-13 19:14:51', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17848, NULL, '1e61925c-94dd-4e72-8d14-5eacdb91e9ff', 'deposit', 0.00, '2025-02-13', '19:14:51', 'Fee collected for deposit', 0.00, 1, 'wasl', NULL, NULL, NULL, NULL, '2025-02-13 19:14:51', '2025-02-13 19:14:51', 23, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17849, NULL, '2af26498-efe1-45d1-ad4a-9018744fc02c', 'withdrawal', 10000000.00, '2025-02-13', '19:15:06', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 19:15:06', '2025-02-13 19:15:06', 171, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17850, NULL, '2af26498-efe1-45d1-ad4a-9018744fc02c', 'withdrawal', 10000000.00, '2025-02-13', '19:15:06', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 19:15:06', '2025-02-13 19:15:06', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17851, NULL, '2af26498-efe1-45d1-ad4a-9018744fc02c', 'deposit', 0.00, '2025-02-13', '19:15:06', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 19:15:06', '2025-02-13 19:15:06', 23, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17852, NULL, '6a57967f-5c38-46aa-ad82-c7561069eb3e', 'withdrawal', 5840.00, '2025-02-13', '19:17:37', NULL, 0.00, 1, 'tiger co.', NULL, NULL, NULL, NULL, '2025-02-13 19:17:37', '2025-02-13 19:17:37', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17853, NULL, '6a57967f-5c38-46aa-ad82-c7561069eb3e', 'withdrawal', 5840.00, '2025-02-13', '19:17:37', NULL, 0.00, 1, 'tiger co.', NULL, NULL, NULL, NULL, '2025-02-13 19:17:37', '2025-02-13 19:17:37', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17854, NULL, '6a57967f-5c38-46aa-ad82-c7561069eb3e', 'deposit', 0.00, '2025-02-13', '19:17:37', 'Fee collected for withdrawal', 0.00, 1, 'tiger co.', NULL, NULL, NULL, NULL, '2025-02-13 19:17:37', '2025-02-13 19:17:37', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17855, NULL, '8095c986-7905-42f3-a08e-35c5f837725a', 'withdrawal', 225.00, '2025-02-13', '19:18:41', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-13 19:18:41', '2025-02-13 19:18:41', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17856, NULL, '8095c986-7905-42f3-a08e-35c5f837725a', 'withdrawal', 225.00, '2025-02-13', '19:18:41', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-13 19:18:41', '2025-02-13 19:18:41', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17857, NULL, '8095c986-7905-42f3-a08e-35c5f837725a', 'deposit', 0.00, '2025-02-13', '19:18:41', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-13 19:18:41', '2025-02-13 19:18:41', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17888, NULL, '9614c2d4-3f31-4133-8044-692c536e6eda', 'deposit', 14500000.00, '2025-02-13', '20:01:15', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-13 20:01:15', '2025-02-13 20:01:15', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17889, NULL, '9614c2d4-3f31-4133-8044-692c536e6eda', 'deposit', 14500000.00, '2025-02-13', '20:01:15', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-13 20:01:15', '2025-02-13 20:01:15', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17890, NULL, '9614c2d4-3f31-4133-8044-692c536e6eda', 'deposit', 0.00, '2025-02-13', '20:01:15', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-13 20:01:15', '2025-02-13 20:01:15', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17891, NULL, '764705d5-73c0-40bb-93c5-2466cfa16cc8', 'withdrawal', 453000.00, '2025-02-13', '20:02:33', NULL, 3000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 20:02:33', '2025-02-13 20:02:33', 258, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17892, NULL, '764705d5-73c0-40bb-93c5-2466cfa16cc8', 'withdrawal', 453000.00, '2025-02-13', '20:02:33', NULL, 3000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 20:02:33', '2025-02-13 20:02:33', 2, 258, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17893, NULL, '764705d5-73c0-40bb-93c5-2466cfa16cc8', 'deposit', 3000.00, '2025-02-13', '20:02:33', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 20:02:33', '2025-02-13 20:02:33', 23, 258, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17894, NULL, '02d4fa82-7f85-4fca-816f-a5366ad8d4a6', 'withdrawal', 6518000.00, '2025-02-13', '20:06:54', NULL, 18000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 20:06:54', '2025-02-13 20:06:54', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17895, NULL, '02d4fa82-7f85-4fca-816f-a5366ad8d4a6', 'withdrawal', 6518000.00, '2025-02-13', '20:06:54', NULL, 18000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 20:06:54', '2025-02-13 20:06:54', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17896, NULL, '02d4fa82-7f85-4fca-816f-a5366ad8d4a6', 'deposit', 18000.00, '2025-02-13', '20:06:54', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-13 20:06:54', '2025-02-13 20:06:54', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17901, NULL, '424b719a-f75a-4555-8d28-2bb38936bc63', 'withdrawal', 2124000.00, '2025-02-13', '20:29:29', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:29:29', '2025-02-13 20:29:29', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17902, NULL, '424b719a-f75a-4555-8d28-2bb38936bc63', 'withdrawal', 2120000.00, '2025-02-13', '20:29:29', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:29:29', '2025-02-13 20:29:29', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17903, NULL, '424b719a-f75a-4555-8d28-2bb38936bc63', 'withdrawal', 2124000.00, '2025-02-13', '20:29:29', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:29:29', '2025-02-13 20:29:29', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17904, NULL, '78de0066-27db-45aa-bb7f-3dcdbaafb3f3', 'deposit', 20000000.00, '2025-02-13', '20:31:30', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-13 20:31:30', '2025-02-13 20:31:30', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17905, NULL, '78de0066-27db-45aa-bb7f-3dcdbaafb3f3', 'deposit', 20000000.00, '2025-02-13', '20:31:30', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-13 20:31:30', '2025-02-13 20:31:30', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17906, NULL, '78de0066-27db-45aa-bb7f-3dcdbaafb3f3', 'deposit', 20000000.00, '2025-02-13', '20:31:30', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-13 20:31:30', '2025-02-13 20:31:30', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17907, NULL, 'c2f27916-8a90-4e07-af10-f87c33bd32e3', 'withdrawal', 1993000.00, '2025-02-13', '20:32:40', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:32:40', '2025-02-13 20:32:40', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17908, NULL, 'c2f27916-8a90-4e07-af10-f87c33bd32e3', 'withdrawal', 1990000.00, '2025-02-13', '20:32:40', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:32:40', '2025-02-13 20:32:40', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17909, NULL, 'c2f27916-8a90-4e07-af10-f87c33bd32e3', 'withdrawal', 1993000.00, '2025-02-13', '20:32:40', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:32:40', '2025-02-13 20:32:40', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17910, NULL, 'a629d649-75f5-4c1a-83b6-efa036e5be1b', 'withdrawal', 1828000.00, '2025-02-13', '20:33:39', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:33:39', '2025-02-13 20:33:39', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17911, NULL, 'a629d649-75f5-4c1a-83b6-efa036e5be1b', 'withdrawal', 1825000.00, '2025-02-13', '20:33:39', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:33:39', '2025-02-13 20:33:39', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17912, NULL, 'a629d649-75f5-4c1a-83b6-efa036e5be1b', 'withdrawal', 1828000.00, '2025-02-13', '20:33:39', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 20:33:39', '2025-02-13 20:33:39', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17913, NULL, 'ee5df7a3-573e-431c-97ed-b6f300536ad1', 'withdrawal', 10000.00, '2025-02-13', '20:34:19', NULL, 10000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:34:19', '2025-02-13 20:34:19', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17914, NULL, 'ee5df7a3-573e-431c-97ed-b6f300536ad1', 'withdrawal', 10000.00, '2025-02-13', '20:34:19', NULL, 10000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:34:19', '2025-02-13 20:34:19', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17915, NULL, 'ee5df7a3-573e-431c-97ed-b6f300536ad1', 'deposit', 10000.00, '2025-02-13', '20:34:19', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:34:19', '2025-02-13 20:34:19', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17916, NULL, '6edc854a-26e8-435d-a20f-682900f56385', 'deposit', 850.00, '2025-02-13', '20:37:13', NULL, 0.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 20:37:13', '2025-02-13 20:37:13', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17917, NULL, '6edc854a-26e8-435d-a20f-682900f56385', 'deposit', 850.00, '2025-02-13', '20:37:13', NULL, 0.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 20:37:13', '2025-02-13 20:37:13', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17918, NULL, '6edc854a-26e8-435d-a20f-682900f56385', 'deposit', 0.00, '2025-02-13', '20:37:13', 'Fee collected for deposit', 0.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 20:37:13', '2025-02-13 20:37:13', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17919, NULL, 'b2680dbb-d573-48e5-9137-eeb7357a4faf', 'deposit', 2010.00, '2025-02-13', '20:37:36', NULL, 10.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 20:37:36', '2025-02-13 20:37:36', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17920, NULL, 'b2680dbb-d573-48e5-9137-eeb7357a4faf', 'deposit', 2010.00, '2025-02-13', '20:37:36', NULL, 10.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 20:37:36', '2025-02-13 20:37:36', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17921, NULL, 'b2680dbb-d573-48e5-9137-eeb7357a4faf', 'deposit', 10.00, '2025-02-13', '20:37:36', 'Fee collected for deposit', 0.00, 1, 'hsab lera', NULL, NULL, NULL, NULL, '2025-02-13 20:37:36', '2025-02-13 20:37:36', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17922, NULL, '2b730271-8ef6-4267-b78d-56abaede7d8c', 'withdrawal', 30000.00, '2025-02-13', '20:38:14', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-13 20:38:14', '2025-02-13 20:38:14', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17923, NULL, '2b730271-8ef6-4267-b78d-56abaede7d8c', 'withdrawal', 30000.00, '2025-02-13', '20:38:14', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-13 20:38:14', '2025-02-13 20:38:14', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17924, NULL, '2b730271-8ef6-4267-b78d-56abaede7d8c', 'deposit', 0.00, '2025-02-13', '20:38:14', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-13 20:38:14', '2025-02-13 20:38:14', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17925, NULL, 'f2752b52-c088-41b2-a79c-1cb325ce41f6', 'withdrawal', 18000.00, '2025-02-13', '20:39:25', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-13 20:39:25', '2025-02-13 20:39:25', 170, 67, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17926, NULL, 'f2752b52-c088-41b2-a79c-1cb325ce41f6', 'withdrawal', 18000.00, '2025-02-13', '20:39:25', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-13 20:39:25', '2025-02-13 20:39:25', 67, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17927, NULL, 'f2752b52-c088-41b2-a79c-1cb325ce41f6', 'withdrawal', 18000.00, '2025-02-13', '20:39:25', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-13 20:39:25', '2025-02-13 20:39:25', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17932, NULL, 'ba03e38d-1f26-430c-932f-b14bb6ac5c5d', 'deposit', 453000.00, '2025-02-13', '20:42:14', NULL, 0.00, 1, 'zamin', NULL, NULL, NULL, NULL, '2025-02-13 20:42:14', '2025-02-13 20:42:14', 258, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17933, NULL, 'ba03e38d-1f26-430c-932f-b14bb6ac5c5d', 'deposit', 453000.00, '2025-02-13', '20:42:14', NULL, 0.00, 1, 'zamin', NULL, NULL, NULL, NULL, '2025-02-13 20:42:14', '2025-02-13 20:42:14', 2, 258, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17934, NULL, 'ba03e38d-1f26-430c-932f-b14bb6ac5c5d', 'deposit', 0.00, '2025-02-13', '20:42:14', 'Fee collected for deposit', 0.00, 1, 'zamin', NULL, NULL, NULL, NULL, '2025-02-13 20:42:14', '2025-02-13 20:42:14', 23, 258, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17935, NULL, '39da28b8-40d4-46ca-88c7-d3ad949842da', 'withdrawal', 3000.00, '2025-02-13', '20:46:23', NULL, 3000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:46:23', '2025-02-13 20:46:23', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17936, NULL, '39da28b8-40d4-46ca-88c7-d3ad949842da', 'withdrawal', 3000.00, '2025-02-13', '20:46:23', NULL, 3000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:46:23', '2025-02-13 20:46:23', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17937, NULL, '39da28b8-40d4-46ca-88c7-d3ad949842da', 'deposit', 3000.00, '2025-02-13', '20:46:23', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:46:23', '2025-02-13 20:46:23', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17938, NULL, '5cfce199-5ec0-4857-a7a9-122574d04ecb', 'deposit', 9800.00, '2025-02-13', '20:50:18', NULL, -200.00, 1, 'chase bank-ghareba ali', NULL, NULL, NULL, NULL, '2025-02-13 20:50:18', '2025-02-13 20:50:18', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17939, NULL, '5cfce199-5ec0-4857-a7a9-122574d04ecb', 'deposit', 9800.00, '2025-02-13', '20:50:18', NULL, -200.00, 1, 'chase bank-ghareba ali', NULL, NULL, NULL, NULL, '2025-02-13 20:50:18', '2025-02-13 20:50:18', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17940, NULL, '5cfce199-5ec0-4857-a7a9-122574d04ecb', 'deposit', -200.00, '2025-02-13', '20:50:18', 'Fee collected for deposit', 0.00, 1, 'chase bank-ghareba ali', NULL, NULL, NULL, NULL, '2025-02-13 20:50:18', '2025-02-13 20:50:18', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17941, NULL, '27403019-211c-410b-8a1b-94cabf80fbae', 'deposit', 133.00, '2025-02-13', '20:51:59', NULL, 0.00, 136, 'Sawsan mustafa Rostam', NULL, NULL, NULL, NULL, '2025-02-13 20:51:59', '2025-02-13 20:51:59', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(17942, NULL, '27403019-211c-410b-8a1b-94cabf80fbae', 'deposit', 133.00, '2025-02-13', '20:51:59', NULL, 0.00, 136, 'Sawsan mustafa Rostam', NULL, NULL, NULL, NULL, '2025-02-13 20:51:59', '2025-02-13 20:51:59', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17943, NULL, 'be397322-64eb-4702-8800-962b0f5a5c41', 'withdrawal', 9850.00, '2025-02-13', '20:54:25', NULL, -150.00, 1, 'chase bank-ghareba ali', NULL, NULL, NULL, NULL, '2025-02-13 20:54:25', '2025-02-13 20:54:25', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17944, NULL, 'be397322-64eb-4702-8800-962b0f5a5c41', 'withdrawal', 9850.00, '2025-02-13', '20:54:25', NULL, -150.00, 1, 'chase bank-ghareba ali', NULL, NULL, NULL, NULL, '2025-02-13 20:54:25', '2025-02-13 20:54:25', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17945, NULL, 'be397322-64eb-4702-8800-962b0f5a5c41', 'deposit', -150.00, '2025-02-13', '20:54:25', 'Fee collected for withdrawal', 0.00, 1, 'chase bank-ghareba ali', NULL, NULL, NULL, NULL, '2025-02-13 20:54:25', '2025-02-13 20:54:25', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17946, NULL, '10d863d7-3dbe-4fe6-bed5-7bc9c5ae611c', 'deposit', 2450.00, '2025-02-13', '20:56:17', NULL, 0.00, 1, 'hamadamen', NULL, NULL, NULL, NULL, '2025-02-13 20:56:17', '2025-02-13 20:56:17', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17947, NULL, '10d863d7-3dbe-4fe6-bed5-7bc9c5ae611c', 'deposit', 2450.00, '2025-02-13', '20:56:17', NULL, 0.00, 1, 'hamadamen', NULL, NULL, NULL, NULL, '2025-02-13 20:56:17', '2025-02-13 20:56:17', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17948, NULL, '10d863d7-3dbe-4fe6-bed5-7bc9c5ae611c', 'deposit', 0.00, '2025-02-13', '20:56:17', 'Fee collected for deposit', 0.00, 1, 'hamadamen', NULL, NULL, NULL, NULL, '2025-02-13 20:56:17', '2025-02-13 20:56:17', 22, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17949, NULL, '164d84eb-b272-4a47-a600-94707888ba03', 'withdrawal', 3.00, '2025-02-13', '20:58:15', NULL, 3.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:58:15', '2025-02-13 20:58:15', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17950, NULL, '164d84eb-b272-4a47-a600-94707888ba03', 'withdrawal', 3.00, '2025-02-13', '20:58:15', NULL, 3.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:58:15', '2025-02-13 20:58:15', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17951, NULL, '164d84eb-b272-4a47-a600-94707888ba03', 'deposit', 3.00, '2025-02-13', '20:58:15', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:58:15', '2025-02-13 20:58:15', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17952, NULL, '1fa9d5a2-4b02-457c-af07-45f5ce5a9752', 'deposit', 763.00, '2025-02-13', '20:59:09', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:59:09', '2025-02-13 20:59:09', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17953, NULL, '1fa9d5a2-4b02-457c-af07-45f5ce5a9752', 'deposit', 763.00, '2025-02-13', '20:59:09', NULL, 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:59:09', '2025-02-13 20:59:09', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17954, NULL, '1fa9d5a2-4b02-457c-af07-45f5ce5a9752', 'deposit', 0.00, '2025-02-13', '20:59:09', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 20:59:09', '2025-02-13 20:59:09', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17955, NULL, '0f1b10aa-bae9-4119-b99e-9b69edf6124b', 'withdrawal', 2.00, '2025-02-13', '21:01:29', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 21:01:29', '2025-02-13 21:01:29', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17956, NULL, '0f1b10aa-bae9-4119-b99e-9b69edf6124b', 'withdrawal', 2.00, '2025-02-13', '21:01:29', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 21:01:29', '2025-02-13 21:01:29', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17957, NULL, '0f1b10aa-bae9-4119-b99e-9b69edf6124b', 'deposit', 2.00, '2025-02-13', '21:01:29', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 21:01:29', '2025-02-13 21:01:29', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17958, NULL, 'cc4dc9aa-9a9c-487a-9dea-039d9e1dec6f', 'deposit', 223.00, '2025-02-13', '21:03:47', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-13 21:03:47', '2025-02-13 21:03:47', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17959, NULL, 'cc4dc9aa-9a9c-487a-9dea-039d9e1dec6f', 'deposit', 223.00, '2025-02-13', '21:03:47', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-13 21:03:47', '2025-02-13 21:03:47', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17960, NULL, 'cc4dc9aa-9a9c-487a-9dea-039d9e1dec6f', 'deposit', 0.00, '2025-02-13', '21:03:47', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-13 21:03:47', '2025-02-13 21:03:47', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17961, NULL, 'b747279b-06d5-4740-b86c-68b81ee6213c', 'withdrawal', 6041000.00, '2025-02-13', '21:08:02', NULL, 17000.00, 1, 'basra-abdulrazaq sami', NULL, NULL, NULL, NULL, '2025-02-13 21:08:02', '2025-02-13 21:08:02', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17962, NULL, 'b747279b-06d5-4740-b86c-68b81ee6213c', 'withdrawal', 6041000.00, '2025-02-13', '21:08:02', NULL, 17000.00, 1, 'basra-abdulrazaq sami', NULL, NULL, NULL, NULL, '2025-02-13 21:08:02', '2025-02-13 21:08:02', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17963, NULL, 'b747279b-06d5-4740-b86c-68b81ee6213c', 'deposit', 17000.00, '2025-02-13', '21:08:02', 'Fee collected for withdrawal', 0.00, 1, 'basra-abdulrazaq sami', NULL, NULL, NULL, NULL, '2025-02-13 21:08:02', '2025-02-13 21:08:02', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17964, NULL, '55092696-b327-45c5-8aeb-ae443c828616', 'deposit', 3500.00, '2025-02-13', '21:09:27', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-13 21:09:27', '2025-02-13 21:09:27', 194, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17965, NULL, '55092696-b327-45c5-8aeb-ae443c828616', 'deposit', 3500.00, '2025-02-13', '21:09:27', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-13 21:09:27', '2025-02-13 21:09:27', 1, 194, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17966, NULL, '55092696-b327-45c5-8aeb-ae443c828616', 'deposit', 0.00, '2025-02-13', '21:09:27', 'Fee collected for deposit', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-13 21:09:27', '2025-02-13 21:09:27', 22, 194, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17973, NULL, '8c7ca427-72c1-44a8-b565-826eb8d8dd15', 'withdrawal', 50000.00, '2025-02-13', '21:18:13', NULL, 0.00, 1, 'shadda zyad la 80000$aka', NULL, NULL, NULL, NULL, '2025-02-13 21:18:13', '2025-02-13 21:18:13', 171, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17974, NULL, '8c7ca427-72c1-44a8-b565-826eb8d8dd15', 'withdrawal', 50000.00, '2025-02-13', '21:18:13', NULL, 0.00, 1, 'shadda zyad la 80000$aka', NULL, NULL, NULL, NULL, '2025-02-13 21:18:13', '2025-02-13 21:18:13', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17975, NULL, '8c7ca427-72c1-44a8-b565-826eb8d8dd15', 'deposit', 0.00, '2025-02-13', '21:18:13', 'Fee collected for withdrawal', 0.00, 1, 'shadda zyad la 80000$aka', NULL, NULL, NULL, NULL, '2025-02-13 21:18:13', '2025-02-13 21:18:13', 23, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17978, NULL, '1987006c-8f0c-4c30-a4d4-6d4dee1917d1', 'deposit', 1053000.00, '2025-02-13', '21:28:12', NULL, -10000.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-13 21:28:12', '2025-02-13 21:28:12', 170, 67, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17979, NULL, '1987006c-8f0c-4c30-a4d4-6d4dee1917d1', 'deposit', 1063000.00, '2025-02-13', '21:28:12', NULL, -10000.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-13 21:28:12', '2025-02-13 21:28:12', 67, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17980, NULL, '1987006c-8f0c-4c30-a4d4-6d4dee1917d1', 'deposit', 1053000.00, '2025-02-13', '21:28:12', NULL, -10000.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-13 21:28:12', '2025-02-13 21:28:12', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17995, NULL, '3c23068f-1746-48b6-84e2-9534e083043b', 'withdrawal', 20505750.00, '2025-02-13', '22:40:24', NULL, 30750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 22:40:24', '2025-02-13 22:40:24', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17996, NULL, '3c23068f-1746-48b6-84e2-9534e083043b', 'withdrawal', 20475000.00, '2025-02-13', '22:40:24', NULL, 30750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 22:40:24', '2025-02-13 22:40:24', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(17997, NULL, '3c23068f-1746-48b6-84e2-9534e083043b', 'withdrawal', 20505750.00, '2025-02-13', '22:40:24', NULL, 30750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-13 22:40:24', '2025-02-13 22:40:24', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18002, NULL, '29005f3e-3c4c-4a44-b7f1-9add8a4abcb5', 'withdrawal', 10250.00, '2025-02-13', '22:41:48', NULL, 10250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 22:41:48', '2025-02-13 22:41:48', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18003, NULL, '29005f3e-3c4c-4a44-b7f1-9add8a4abcb5', 'withdrawal', 10250.00, '2025-02-13', '22:41:48', NULL, 10250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 22:41:48', '2025-02-13 22:41:48', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18004, NULL, '29005f3e-3c4c-4a44-b7f1-9add8a4abcb5', 'deposit', 10250.00, '2025-02-13', '22:41:48', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-13 22:41:48', '2025-02-13 22:41:48', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18009, NULL, '8c71dd5e-e48d-404e-af51-cb38f20d48f0', 'deposit', 9950000.00, '2025-02-13', '22:43:04', NULL, 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-13 22:43:04', '2025-02-13 22:43:04', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18010, NULL, '8c71dd5e-e48d-404e-af51-cb38f20d48f0', 'deposit', 9950000.00, '2025-02-13', '22:43:04', NULL, 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-13 22:43:04', '2025-02-13 22:43:04', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18011, NULL, '8c71dd5e-e48d-404e-af51-cb38f20d48f0', 'deposit', 0.00, '2025-02-13', '22:43:04', 'Fee collected for deposit', 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-13 22:43:04', '2025-02-13 22:43:04', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18012, NULL, '4317d10e-1544-4663-b009-508c1a2bb56a', 'deposit', 200000.00, '2025-02-13', '22:44:00', NULL, 0.00, 1, 'hemn', NULL, NULL, NULL, NULL, '2025-02-13 22:44:00', '2025-02-13 22:44:00', 264, 4, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18013, NULL, '4317d10e-1544-4663-b009-508c1a2bb56a', 'deposit', 200000.00, '2025-02-13', '22:44:00', NULL, 0.00, 1, 'hemn', NULL, NULL, NULL, NULL, '2025-02-13 22:44:00', '2025-02-13 22:44:00', 4, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18014, NULL, '4317d10e-1544-4663-b009-508c1a2bb56a', 'deposit', 200000.00, '2025-02-13', '22:44:00', NULL, 0.00, 1, 'hemn', NULL, NULL, NULL, NULL, '2025-02-13 22:44:00', '2025-02-13 22:44:00', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18237, NULL, 'eb79bd15-b705-4141-9e73-4ebddbe608bd', 'withdrawal', 1505000.00, '2025-02-15', '16:20:35', NULL, 5000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 16:20:35', '2025-02-15 16:20:35', 232, 4, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18238, NULL, 'eb79bd15-b705-4141-9e73-4ebddbe608bd', 'withdrawal', 1500000.00, '2025-02-15', '16:20:35', NULL, 5000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 16:20:35', '2025-02-15 16:20:35', 4, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18239, NULL, 'eb79bd15-b705-4141-9e73-4ebddbe608bd', 'withdrawal', 1505000.00, '2025-02-15', '16:20:35', NULL, 5000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 16:20:36', '2025-02-15 16:20:36', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18240, NULL, '29939e22-f232-4594-830d-34d7ba8347af', 'withdrawal', 3260000.00, '2025-02-15', '16:21:04', NULL, 10000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 16:21:04', '2025-02-15 16:21:04', 85, 4, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18241, NULL, '29939e22-f232-4594-830d-34d7ba8347af', 'withdrawal', 3250000.00, '2025-02-15', '16:21:04', NULL, 10000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 16:21:04', '2025-02-15 16:21:04', 4, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18242, NULL, '29939e22-f232-4594-830d-34d7ba8347af', 'withdrawal', 3260000.00, '2025-02-15', '16:21:04', NULL, 10000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 16:21:04', '2025-02-15 16:21:04', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18243, NULL, 'f0d1c3a6-d571-4481-b383-cb50d46b5866', 'withdrawal', 3015000.00, '2025-02-15', '16:21:39', NULL, 0.00, 1, 0, NULL, NULL, NULL, NULL, '2025-02-15 16:21:39', '2025-02-15 16:21:39', 469, 67, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18244, NULL, 'f0d1c3a6-d571-4481-b383-cb50d46b5866', 'deposit', 3015000.00, '2025-02-15', '16:21:39', NULL, 0.00, 1, 0, NULL, NULL, NULL, NULL, '2025-02-15 16:21:39', '2025-02-15 16:21:39', 67, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18245, NULL, 'f0d1c3a6-d571-4481-b383-cb50d46b5866', 'deposit', 0.00, '2025-02-15', '16:21:39', 'Fee collected for transfer', 0.00, 1, 0, NULL, NULL, NULL, NULL, '2025-02-15 16:21:39', '2025-02-15 16:21:39', 68, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18366, NULL, '88887b07-8bc3-4b89-b18f-3c5f070eb755', 'withdrawal', 1000.00, '2025-02-15', '18:54:34', NULL, 0.00, 132, 'Muhamad faqe abdulla', NULL, NULL, NULL, NULL, '2025-02-15 18:54:34', '2025-02-15 18:54:34', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18367, NULL, '88887b07-8bc3-4b89-b18f-3c5f070eb755', 'withdrawal', 1000.00, '2025-02-15', '18:54:34', NULL, 0.00, 132, 'Muhamad faqe abdulla', NULL, NULL, NULL, NULL, '2025-02-15 18:54:34', '2025-02-15 18:54:34', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18418, NULL, '9a6f46ad-372a-4250-a3cc-2d0000703443', 'deposit', 27500000.00, '2025-02-15', '20:29:38', NULL, 0.00, 1, 'hozan', NULL, NULL, NULL, NULL, '2025-02-15 20:29:38', '2025-02-15 20:29:38', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18419, NULL, '9a6f46ad-372a-4250-a3cc-2d0000703443', 'deposit', 27500000.00, '2025-02-15', '20:29:38', NULL, 0.00, 1, 'hozan', NULL, NULL, NULL, NULL, '2025-02-15 20:29:38', '2025-02-15 20:29:38', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18420, NULL, '9a6f46ad-372a-4250-a3cc-2d0000703443', 'deposit', 0.00, '2025-02-15', '20:29:38', 'Fee collected for deposit', 0.00, 1, 'hozan', NULL, NULL, NULL, NULL, '2025-02-15 20:29:38', '2025-02-15 20:29:38', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18421, NULL, '9aa62d8f-802a-44c4-aa85-d3a1c9a0980f', 'withdrawal', 4000000.00, '2025-02-15', '20:32:08', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-15 20:32:08', '2025-02-15 20:32:08', 171, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18422, NULL, '9aa62d8f-802a-44c4-aa85-d3a1c9a0980f', 'withdrawal', 4000000.00, '2025-02-15', '20:32:08', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-15 20:32:08', '2025-02-15 20:32:08', 69, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18423, NULL, '9aa62d8f-802a-44c4-aa85-d3a1c9a0980f', 'withdrawal', 4000000.00, '2025-02-15', '20:32:08', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-15 20:32:08', '2025-02-15 20:32:08', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18424, NULL, '2c1f5fdb-e5fd-4b3e-8be1-32a78c9ba351', 'deposit', 14050000.00, '2025-02-15', '20:33:18', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 20:33:18', '2025-02-15 20:33:18', 171, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18425, NULL, '2c1f5fdb-e5fd-4b3e-8be1-32a78c9ba351', 'deposit', 14050000.00, '2025-02-15', '20:33:18', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 20:33:18', '2025-02-15 20:33:18', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18426, NULL, '2c1f5fdb-e5fd-4b3e-8be1-32a78c9ba351', 'deposit', 0.00, '2025-02-15', '20:33:18', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 20:33:18', '2025-02-15 20:33:18', 23, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18429, NULL, '1ddebc8e-7024-4f77-9acf-7bdf9fa2b480', 'deposit', 6518000.00, '2025-02-15', '20:48:52', NULL, 0.00, 1, 'hesham', NULL, NULL, NULL, NULL, '2025-02-15 20:48:52', '2025-02-15 20:48:52', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18430, NULL, '1ddebc8e-7024-4f77-9acf-7bdf9fa2b480', 'deposit', 6518000.00, '2025-02-15', '20:48:52', NULL, 0.00, 1, 'hesham', NULL, NULL, NULL, NULL, '2025-02-15 20:48:52', '2025-02-15 20:48:52', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18431, NULL, '1ddebc8e-7024-4f77-9acf-7bdf9fa2b480', 'deposit', 0.00, '2025-02-15', '20:48:52', 'Fee collected for deposit', 0.00, 1, 'hesham', NULL, NULL, NULL, NULL, '2025-02-15 20:48:52', '2025-02-15 20:48:52', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18436, NULL, '9359891f-f592-4e46-a179-c4672c3f424a', 'withdrawal', 40000.00, '2025-02-15', '20:51:33', NULL, 0.00, 1, 'sarf hsab karwan', NULL, NULL, NULL, NULL, '2025-02-15 20:51:33', '2025-02-15 20:51:33', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18437, NULL, '9359891f-f592-4e46-a179-c4672c3f424a', 'withdrawal', 40000.00, '2025-02-15', '20:51:33', NULL, 0.00, 1, 'sarf hsab karwan', NULL, NULL, NULL, NULL, '2025-02-15 20:51:33', '2025-02-15 20:51:33', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18438, NULL, '9359891f-f592-4e46-a179-c4672c3f424a', 'deposit', 0.00, '2025-02-15', '20:51:33', 'Fee collected for withdrawal', 0.00, 1, 'sarf hsab karwan', NULL, NULL, NULL, NULL, '2025-02-15 20:51:33', '2025-02-15 20:51:33', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18439, NULL, 'c21b78db-ec0b-45fc-9d1a-85ffa479e46a', 'deposit', 40000.00, '2025-02-15', '20:53:03', NULL, 0.00, 1, 'hatu hsab shamal sherzad', NULL, NULL, NULL, NULL, '2025-02-15 20:53:03', '2025-02-15 20:53:03', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18440, NULL, 'c21b78db-ec0b-45fc-9d1a-85ffa479e46a', 'deposit', 40000.00, '2025-02-15', '20:53:03', NULL, 0.00, 1, 'hatu hsab shamal sherzad', NULL, NULL, NULL, NULL, '2025-02-15 20:53:03', '2025-02-15 20:53:03', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18441, NULL, 'c21b78db-ec0b-45fc-9d1a-85ffa479e46a', 'deposit', 0.00, '2025-02-15', '20:53:03', 'Fee collected for deposit', 0.00, 1, 'hatu hsab shamal sherzad', NULL, NULL, NULL, NULL, '2025-02-15 20:53:03', '2025-02-15 20:53:03', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18444, NULL, '17d6d5db-87b6-4cdc-aa58-6165ee77696d', 'deposit', 395.00, '2025-02-15', '20:54:47', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-15 20:54:47', '2025-02-15 20:54:47', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18445, NULL, '17d6d5db-87b6-4cdc-aa58-6165ee77696d', 'deposit', 395.00, '2025-02-15', '20:54:47', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-15 20:54:47', '2025-02-15 20:54:47', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18446, NULL, '17d6d5db-87b6-4cdc-aa58-6165ee77696d', 'deposit', 0.00, '2025-02-15', '20:54:47', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-15 20:54:47', '2025-02-15 20:54:47', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18447, NULL, '2392c95d-529d-4011-bc86-8e34752ec8f6', 'deposit', 195.00, '2025-02-15', '20:55:10', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-15 20:55:10', '2025-02-15 20:55:10', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18448, NULL, '2392c95d-529d-4011-bc86-8e34752ec8f6', 'deposit', 195.00, '2025-02-15', '20:55:10', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-15 20:55:10', '2025-02-15 20:55:10', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18449, NULL, '2392c95d-529d-4011-bc86-8e34752ec8f6', 'deposit', 0.00, '2025-02-15', '20:55:10', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-15 20:55:10', '2025-02-15 20:55:10', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18454, NULL, '7d77662c-9ee5-49fc-88b6-cb5c58439081', 'withdrawal', 1500.00, '2025-02-15', '20:59:48', NULL, 0.00, 1, 'sarf hsab k hawkar', NULL, NULL, NULL, NULL, '2025-02-15 20:59:48', '2025-02-15 20:59:48', 265, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18455, NULL, '7d77662c-9ee5-49fc-88b6-cb5c58439081', 'withdrawal', 1500.00, '2025-02-15', '20:59:48', NULL, 0.00, 1, 'sarf hsab k hawkar', NULL, NULL, NULL, NULL, '2025-02-15 20:59:48', '2025-02-15 20:59:48', 1, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18456, NULL, '7d77662c-9ee5-49fc-88b6-cb5c58439081', 'deposit', 0.00, '2025-02-15', '20:59:48', 'Fee collected for withdrawal', 0.00, 1, 'sarf hsab k hawkar', NULL, NULL, NULL, NULL, '2025-02-15 20:59:48', '2025-02-15 20:59:48', 22, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18457, NULL, '14b52911-a19b-40d6-872b-8e068becda11', 'deposit', 1500.00, '2025-02-15', '21:02:51', NULL, 0.00, 1, 'hatu la hsab hemn', NULL, NULL, NULL, NULL, '2025-02-15 21:02:51', '2025-02-15 21:02:51', 240, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18458, NULL, '14b52911-a19b-40d6-872b-8e068becda11', 'deposit', 1500.00, '2025-02-15', '21:02:51', NULL, 0.00, 1, 'hatu la hsab hemn', NULL, NULL, NULL, NULL, '2025-02-15 21:02:51', '2025-02-15 21:02:51', 1, 240, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18459, NULL, '14b52911-a19b-40d6-872b-8e068becda11', 'deposit', 0.00, '2025-02-15', '21:02:51', 'Fee collected for deposit', 0.00, 1, 'hatu la hsab hemn', NULL, NULL, NULL, NULL, '2025-02-15 21:02:51', '2025-02-15 21:02:51', 22, 240, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18460, NULL, '4fe316e6-ec0d-4804-ab7b-98cab1fa8792', 'withdrawal', 4200.00, '2025-02-15', '21:05:41', NULL, 10.00, 1, 'tela hawala', NULL, NULL, NULL, NULL, '2025-02-15 21:05:41', '2025-02-15 21:05:41', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18461, NULL, '4fe316e6-ec0d-4804-ab7b-98cab1fa8792', 'withdrawal', 4200.00, '2025-02-15', '21:05:41', NULL, 10.00, 1, 'tela hawala', NULL, NULL, NULL, NULL, '2025-02-15 21:05:41', '2025-02-15 21:05:41', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18462, NULL, '4fe316e6-ec0d-4804-ab7b-98cab1fa8792', 'deposit', 10.00, '2025-02-15', '21:05:41', 'Fee collected for withdrawal', 0.00, 1, 'tela hawala', NULL, NULL, NULL, NULL, '2025-02-15 21:05:41', '2025-02-15 21:05:41', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18463, NULL, '9dd3f5f8-7b17-4c21-ac54-dd8fbc9b630e', 'deposit', 1321000.00, '2025-02-15', '21:08:28', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-15 21:08:28', '2025-02-15 21:08:28', 1098, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18464, NULL, '9dd3f5f8-7b17-4c21-ac54-dd8fbc9b630e', 'deposit', 1321000.00, '2025-02-15', '21:08:28', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-15 21:08:28', '2025-02-15 21:08:28', 69, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18465, NULL, '9dd3f5f8-7b17-4c21-ac54-dd8fbc9b630e', 'deposit', 1321000.00, '2025-02-15', '21:08:28', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-15 21:08:28', '2025-02-15 21:08:28', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18466, NULL, '3696ef5b-d936-4afc-9325-8b888a47d6b9', 'deposit', 10000.00, '2025-02-15', '21:08:54', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:08:54', '2025-02-15 21:08:54', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18467, NULL, '3696ef5b-d936-4afc-9325-8b888a47d6b9', 'deposit', 10000.00, '2025-02-15', '21:08:54', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:08:54', '2025-02-15 21:08:54', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18468, NULL, '3696ef5b-d936-4afc-9325-8b888a47d6b9', 'deposit', 0.00, '2025-02-15', '21:08:54', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:08:54', '2025-02-15 21:08:54', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18469, NULL, '1fd5f633-60fa-4dae-b249-436fec2398c1', 'deposit', 725000.00, '2025-02-15', '21:10:23', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-15 21:10:23', '2025-02-15 21:10:23', 1098, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18470, NULL, '1fd5f633-60fa-4dae-b249-436fec2398c1', 'deposit', 725000.00, '2025-02-15', '21:10:23', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-15 21:10:23', '2025-02-15 21:10:23', 69, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18471, NULL, '1fd5f633-60fa-4dae-b249-436fec2398c1', 'deposit', 725000.00, '2025-02-15', '21:10:23', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-15 21:10:23', '2025-02-15 21:10:23', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18474, NULL, '0866691c-8fd0-44be-b16a-c10046c00dee', 'withdrawal', 1000.00, '2025-02-15', '21:19:37', NULL, 0.00, 1, 'sarf bo hsab k karwan', NULL, NULL, NULL, NULL, '2025-02-15 21:19:37', '2025-02-15 21:19:37', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18475, NULL, '0866691c-8fd0-44be-b16a-c10046c00dee', 'withdrawal', 1000.00, '2025-02-15', '21:19:37', NULL, 0.00, 1, 'sarf bo hsab k karwan', NULL, NULL, NULL, NULL, '2025-02-15 21:19:37', '2025-02-15 21:19:37', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18476, NULL, '0866691c-8fd0-44be-b16a-c10046c00dee', 'deposit', 0.00, '2025-02-15', '21:19:37', 'Fee collected for withdrawal', 0.00, 1, 'sarf bo hsab k karwan', NULL, NULL, NULL, NULL, '2025-02-15 21:19:37', '2025-02-15 21:19:37', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18477, NULL, 'c1725840-38f4-41a7-8ede-dfd4cc72fbf2', 'deposit', 1000.00, '2025-02-15', '21:20:40', NULL, 0.00, 1, 'hatu hsab k shamal', NULL, NULL, NULL, NULL, '2025-02-15 21:20:40', '2025-02-15 21:20:40', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(18478, NULL, 'c1725840-38f4-41a7-8ede-dfd4cc72fbf2', 'deposit', 1000.00, '2025-02-15', '21:20:40', NULL, 0.00, 1, 'hatu hsab k shamal', NULL, NULL, NULL, NULL, '2025-02-15 21:20:40', '2025-02-15 21:20:40', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18479, NULL, 'c1725840-38f4-41a7-8ede-dfd4cc72fbf2', 'deposit', 0.00, '2025-02-15', '21:20:40', 'Fee collected for deposit', 0.00, 1, 'hatu hsab k shamal', NULL, NULL, NULL, NULL, '2025-02-15 21:20:40', '2025-02-15 21:20:40', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18480, NULL, '67c18ed7-d910-4fe9-859b-e28e264de603', 'withdrawal', 9000.00, '2025-02-15', '21:23:36', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-15 21:23:36', '2025-02-15 21:23:36', 179, 71, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18481, NULL, '67c18ed7-d910-4fe9-859b-e28e264de603', 'withdrawal', 9000.00, '2025-02-15', '21:23:36', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-15 21:23:36', '2025-02-15 21:23:36', 71, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18482, NULL, '67c18ed7-d910-4fe9-859b-e28e264de603', 'withdrawal', 9000.00, '2025-02-15', '21:23:36', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-15 21:23:36', '2025-02-15 21:23:36', 2, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18487, NULL, '2fcc938c-a28d-4f41-9b92-56474fea692e', 'withdrawal', 1000000.00, '2025-02-15', '21:29:18', NULL, 0.00, 1, 'zardasht sarf', NULL, NULL, NULL, NULL, '2025-02-15 21:29:18', '2025-02-15 21:29:18', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18488, NULL, '2fcc938c-a28d-4f41-9b92-56474fea692e', 'withdrawal', 1000000.00, '2025-02-15', '21:29:18', NULL, 0.00, 1, 'zardasht sarf', NULL, NULL, NULL, NULL, '2025-02-15 21:29:18', '2025-02-15 21:29:18', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18489, NULL, '2fcc938c-a28d-4f41-9b92-56474fea692e', 'deposit', 0.00, '2025-02-15', '21:29:18', 'Fee collected for withdrawal', 0.00, 1, 'zardasht sarf', NULL, NULL, NULL, NULL, '2025-02-15 21:29:18', '2025-02-15 21:29:18', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18500, NULL, '727fcb4c-cd82-45e5-8002-ce01850bd54e', 'deposit', 1505000.00, '2025-02-15', '21:33:21', NULL, 0.00, 1, 'muhamad shami hatu', NULL, NULL, NULL, NULL, '2025-02-15 21:33:21', '2025-02-15 21:33:21', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18501, NULL, '727fcb4c-cd82-45e5-8002-ce01850bd54e', 'deposit', 1505000.00, '2025-02-15', '21:33:21', NULL, 0.00, 1, 'muhamad shami hatu', NULL, NULL, NULL, NULL, '2025-02-15 21:33:21', '2025-02-15 21:33:21', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18502, NULL, '727fcb4c-cd82-45e5-8002-ce01850bd54e', 'deposit', 0.00, '2025-02-15', '21:33:21', 'Fee collected for deposit', 0.00, 1, 'muhamad shami hatu', NULL, NULL, NULL, NULL, '2025-02-15 21:33:21', '2025-02-15 21:33:21', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18503, NULL, '43819ba0-ae2d-4c5a-8a2c-5e4fcef84a05', 'deposit', 4100.00, '2025-02-15', '21:35:35', NULL, 0.00, 132, 'Muhamad slah hamad ', NULL, NULL, NULL, NULL, '2025-02-15 21:35:35', '2025-02-15 21:35:35', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18504, NULL, '43819ba0-ae2d-4c5a-8a2c-5e4fcef84a05', 'deposit', 4100.00, '2025-02-15', '21:35:35', NULL, 0.00, 132, 'Muhamad slah hamad ', NULL, NULL, NULL, NULL, '2025-02-15 21:35:35', '2025-02-15 21:35:35', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18505, NULL, '4afd71e6-0330-449a-8a70-8834d35505b4', 'deposit', 15045000.00, '2025-02-15', '21:36:20', NULL, 45000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 21:36:20', '2025-02-15 21:36:20', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18506, NULL, '4afd71e6-0330-449a-8a70-8834d35505b4', 'deposit', 15045000.00, '2025-02-15', '21:36:20', NULL, 45000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 21:36:20', '2025-02-15 21:36:20', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18507, NULL, '4afd71e6-0330-449a-8a70-8834d35505b4', 'deposit', 45000.00, '2025-02-15', '21:36:20', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-15 21:36:20', '2025-02-15 21:36:20', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18514, NULL, 'dcce5b1c-a298-4d49-a3d6-d036909554d6', 'deposit', 1010.00, '2025-02-15', '21:41:57', NULL, 10.00, 1, 'peran shar - rahman darbandi', NULL, NULL, NULL, NULL, '2025-02-15 21:41:57', '2025-02-15 21:41:57', 1048, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18515, NULL, 'dcce5b1c-a298-4d49-a3d6-d036909554d6', 'deposit', 1010.00, '2025-02-15', '21:41:57', NULL, 10.00, 1, 'peran shar - rahman darbandi', NULL, NULL, NULL, NULL, '2025-02-15 21:41:57', '2025-02-15 21:41:57', 1, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18516, NULL, 'dcce5b1c-a298-4d49-a3d6-d036909554d6', 'deposit', 10.00, '2025-02-15', '21:41:57', 'Fee collected for deposit', 0.00, 1, 'peran shar - rahman darbandi', NULL, NULL, NULL, NULL, '2025-02-15 21:41:57', '2025-02-15 21:41:57', 22, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18524, NULL, 'fcd098fd-a850-4a8c-888f-ef828da4ea1f', 'withdrawal', 30000.00, '2025-02-15', '21:45:33', NULL, 0.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-15 21:45:33', '2025-02-15 21:45:33', 82, 71, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18525, NULL, 'fcd098fd-a850-4a8c-888f-ef828da4ea1f', 'withdrawal', 30000.00, '2025-02-15', '21:45:33', NULL, 0.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-15 21:45:33', '2025-02-15 21:45:33', 71, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18526, NULL, 'fcd098fd-a850-4a8c-888f-ef828da4ea1f', 'withdrawal', 30000.00, '2025-02-15', '21:45:33', NULL, 0.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-15 21:45:33', '2025-02-15 21:45:33', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18527, NULL, '7e9a53b1-87b8-442b-9008-6aeb9dcdfe9c', 'deposit', 4190.00, '2025-02-15', '21:50:38', NULL, 0.00, 1, 'tela-hawala', NULL, NULL, NULL, NULL, '2025-02-15 21:50:38', '2025-02-15 21:50:38', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18528, NULL, '7e9a53b1-87b8-442b-9008-6aeb9dcdfe9c', 'deposit', 4190.00, '2025-02-15', '21:50:38', NULL, 0.00, 1, 'tela-hawala', NULL, NULL, NULL, NULL, '2025-02-15 21:50:38', '2025-02-15 21:50:38', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18529, NULL, '7e9a53b1-87b8-442b-9008-6aeb9dcdfe9c', 'deposit', 0.00, '2025-02-15', '21:50:38', 'Fee collected for deposit', 0.00, 1, 'tela-hawala', NULL, NULL, NULL, NULL, '2025-02-15 21:50:38', '2025-02-15 21:50:38', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18530, NULL, '30cd15ff-2a08-4aad-93fa-a7ebf76113a4', 'withdrawal', 15000.00, '2025-02-15', '21:51:17', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:51:17', '2025-02-15 21:51:17', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18531, NULL, '30cd15ff-2a08-4aad-93fa-a7ebf76113a4', 'withdrawal', 15000.00, '2025-02-15', '21:51:17', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:51:17', '2025-02-15 21:51:17', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18532, NULL, '30cd15ff-2a08-4aad-93fa-a7ebf76113a4', 'deposit', 0.00, '2025-02-15', '21:51:17', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:51:17', '2025-02-15 21:51:17', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18533, NULL, '291983be-1ac2-4ebd-ac4a-c0b056e9e870', 'deposit', 5000000.00, '2025-02-15', '21:51:42', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:51:42', '2025-02-15 21:51:42', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18534, NULL, '291983be-1ac2-4ebd-ac4a-c0b056e9e870', 'deposit', 5000000.00, '2025-02-15', '21:51:42', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:51:42', '2025-02-15 21:51:42', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18535, NULL, '291983be-1ac2-4ebd-ac4a-c0b056e9e870', 'deposit', 0.00, '2025-02-15', '21:51:42', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-15 21:51:42', '2025-02-15 21:51:42', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18606, NULL, '9f9b2d2f-46e4-4d75-8fb1-11b15a849d7b', 'withdrawal', 3015000.00, '2025-02-16', '10:41:11', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-16 10:41:11', '2025-02-16 10:41:11', 469, 67, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18607, NULL, '9f9b2d2f-46e4-4d75-8fb1-11b15a849d7b', 'deposit', 3015000.00, '2025-02-16', '10:41:11', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-16 10:41:11', '2025-02-16 10:41:11', 67, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18608, NULL, '9f9b2d2f-46e4-4d75-8fb1-11b15a849d7b', 'deposit', 0.00, '2025-02-16', '10:41:11', 'Fee collected for transfer', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-16 10:41:11', '2025-02-16 10:41:11', 68, 469, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18620, NULL, '44daf6b0-37a4-4a61-814c-0ed9b3f892b9', 'withdrawal', 15045000.00, '2025-02-16', '10:48:46', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-16 10:48:46', '2025-02-16 10:48:46', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18621, NULL, '44daf6b0-37a4-4a61-814c-0ed9b3f892b9', 'withdrawal', 15045000.00, '2025-02-16', '10:48:46', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-16 10:48:46', '2025-02-16 10:48:46', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18622, NULL, '44daf6b0-37a4-4a61-814c-0ed9b3f892b9', 'deposit', 0.00, '2025-02-16', '10:48:46', 'Fee collected for withdrawal', 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-16 10:48:46', '2025-02-16 10:48:46', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18625, NULL, 'f3339ba3-23b8-4351-816d-cef58b0c48e4', 'deposit', 1005.00, '2025-02-16', '10:52:46', NULL, 5.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-16 10:52:46', '2025-02-16 10:52:46', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18626, NULL, 'f3339ba3-23b8-4351-816d-cef58b0c48e4', 'deposit', 1005.00, '2025-02-16', '10:52:46', NULL, 5.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-16 10:52:46', '2025-02-16 10:52:46', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18627, NULL, 'f3339ba3-23b8-4351-816d-cef58b0c48e4', 'deposit', 5.00, '2025-02-16', '10:52:46', 'Fee collected for deposit', 0.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-16 10:52:46', '2025-02-16 10:52:46', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18634, NULL, '0e7cddfb-a29f-4653-bdae-c8b1fd66e68e', 'withdrawal', 1008.00, '2025-02-16', '10:56:37', NULL, 8.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-16 10:56:37', '2025-02-16 10:56:37', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18635, NULL, '0e7cddfb-a29f-4653-bdae-c8b1fd66e68e', 'withdrawal', 1008.00, '2025-02-16', '10:56:37', NULL, 8.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-16 10:56:37', '2025-02-16 10:56:37', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18636, NULL, '0e7cddfb-a29f-4653-bdae-c8b1fd66e68e', 'deposit', 8.00, '2025-02-16', '10:56:37', 'Fee collected for withdrawal', 0.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-16 10:56:37', '2025-02-16 10:56:37', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18655, NULL, '39439896-6e0c-4335-b59f-a7cdf66855c4', 'deposit', 167.00, '2025-02-16', '11:45:32', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-16 11:45:32', '2025-02-16 11:45:32', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18656, NULL, '39439896-6e0c-4335-b59f-a7cdf66855c4', 'deposit', 167.00, '2025-02-16', '11:45:32', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-16 11:45:32', '2025-02-16 11:45:32', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18657, NULL, '39439896-6e0c-4335-b59f-a7cdf66855c4', 'deposit', 0.00, '2025-02-16', '11:45:32', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-16 11:45:32', '2025-02-16 11:45:32', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18676, NULL, '3133dc15-585e-4e81-a3de-02be65d54ac7', 'withdrawal', 1505000.00, '2025-02-16', '12:10:16', NULL, 5000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-16 12:10:16', '2025-02-16 12:10:16', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18677, NULL, '3133dc15-585e-4e81-a3de-02be65d54ac7', 'withdrawal', 1505000.00, '2025-02-16', '12:10:16', NULL, 5000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-16 12:10:16', '2025-02-16 12:10:16', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18678, NULL, '3133dc15-585e-4e81-a3de-02be65d54ac7', 'deposit', 5000.00, '2025-02-16', '12:10:16', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-16 12:10:16', '2025-02-16 12:10:16', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18697, NULL, '6b24ab05-dc41-44ee-bab2-0ae9b015e8dd', 'withdrawal', 50000.00, '2025-02-16', '12:58:31', NULL, 0.00, 136, 'Asa', NULL, NULL, NULL, NULL, '2025-02-16 12:58:31', '2025-02-16 12:58:31', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18698, NULL, '6b24ab05-dc41-44ee-bab2-0ae9b015e8dd', 'withdrawal', 50000.00, '2025-02-16', '12:58:31', NULL, 0.00, 136, 'Asa', NULL, NULL, NULL, NULL, '2025-02-16 12:58:31', '2025-02-16 12:58:31', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18779, NULL, 'e7dcb5bf-d136-4a35-bbf8-8eb6ae36cae1', 'withdrawal', 8000.00, '2025-02-16', '15:06:34', NULL, 0.00, 136, 'ahmad sharef', NULL, NULL, NULL, NULL, '2025-02-16 15:06:34', '2025-02-16 15:06:34', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18780, NULL, 'e7dcb5bf-d136-4a35-bbf8-8eb6ae36cae1', 'withdrawal', 8000.00, '2025-02-16', '15:06:34', NULL, 0.00, 136, 'ahmad sharef', NULL, NULL, NULL, NULL, '2025-02-16 15:06:34', '2025-02-16 15:06:34', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18781, NULL, '51a756fd-5110-4705-8724-31e2cc6b6ae6', 'withdrawal', 300.00, '2025-02-16', '15:11:57', NULL, 0.00, 1, 'abu fawaz sarf', NULL, NULL, NULL, NULL, '2025-02-16 15:11:57', '2025-02-16 15:11:57', 251, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18782, NULL, '51a756fd-5110-4705-8724-31e2cc6b6ae6', 'withdrawal', 300.00, '2025-02-16', '15:11:57', NULL, 0.00, 1, 'abu fawaz sarf', NULL, NULL, NULL, NULL, '2025-02-16 15:11:57', '2025-02-16 15:11:57', 1, 251, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18783, NULL, '51a756fd-5110-4705-8724-31e2cc6b6ae6', 'deposit', 0.00, '2025-02-16', '15:11:57', 'Fee collected for withdrawal', 0.00, 1, 'abu fawaz sarf', NULL, NULL, NULL, NULL, '2025-02-16 15:11:57', '2025-02-16 15:11:57', 22, 251, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18788, NULL, 'f5576616-3584-4b93-a0f0-f9b3aab56bb9', 'deposit', 8000000.00, '2025-02-16', '15:19:18', NULL, 0.00, 1, 'muhamad ismaiel hatu', NULL, NULL, NULL, NULL, '2025-02-16 15:19:18', '2025-02-16 15:19:18', 417, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18789, NULL, 'f5576616-3584-4b93-a0f0-f9b3aab56bb9', 'deposit', 8000000.00, '2025-02-16', '15:19:18', NULL, 0.00, 1, 'muhamad ismaiel hatu', NULL, NULL, NULL, NULL, '2025-02-16 15:19:18', '2025-02-16 15:19:18', 2, 417, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18790, NULL, 'f5576616-3584-4b93-a0f0-f9b3aab56bb9', 'deposit', 0.00, '2025-02-16', '15:19:18', 'Fee collected for deposit', 0.00, 1, 'muhamad ismaiel hatu', NULL, NULL, NULL, NULL, '2025-02-16 15:19:18', '2025-02-16 15:19:18', 23, 417, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18798, NULL, 'dceee290-6ef1-4090-b96c-a77e501be540', 'withdrawal', 5005.00, '2025-02-16', '15:24:54', NULL, 5.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-16 15:24:54', '2025-02-16 15:24:54', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18799, NULL, 'dceee290-6ef1-4090-b96c-a77e501be540', 'withdrawal', 5005.00, '2025-02-16', '15:24:54', NULL, 5.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-16 15:24:54', '2025-02-16 15:24:54', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18800, NULL, 'dceee290-6ef1-4090-b96c-a77e501be540', 'deposit', 5.00, '2025-02-16', '15:24:54', 'Fee collected for withdrawal', 0.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-16 15:24:54', '2025-02-16 15:24:54', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18811, NULL, 'a74f82fc-8699-4415-be9b-d058f084d644', 'withdrawal', 10.00, '2025-02-16', '15:50:21', NULL, 10.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-16 15:50:21', '2025-02-16 15:50:21', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18812, NULL, 'a74f82fc-8699-4415-be9b-d058f084d644', 'withdrawal', 10.00, '2025-02-16', '15:50:21', NULL, 10.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-16 15:50:21', '2025-02-16 15:50:21', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18813, NULL, 'a74f82fc-8699-4415-be9b-d058f084d644', 'deposit', 10.00, '2025-02-16', '15:50:21', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-16 15:50:21', '2025-02-16 15:50:21', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18814, NULL, 'ecef98f5-a751-4609-bdeb-dec4894af3da', 'deposit', 3260000.00, '2025-02-16', '15:56:56', NULL, 0.00, 1, 'hatu k sardar', NULL, NULL, NULL, NULL, '2025-02-16 15:56:56', '2025-02-16 15:56:56', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18815, NULL, 'ecef98f5-a751-4609-bdeb-dec4894af3da', 'deposit', 3260000.00, '2025-02-16', '15:56:56', NULL, 0.00, 1, 'hatu k sardar', NULL, NULL, NULL, NULL, '2025-02-16 15:56:56', '2025-02-16 15:56:56', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18816, NULL, 'ecef98f5-a751-4609-bdeb-dec4894af3da', 'deposit', 0.00, '2025-02-16', '15:56:56', 'Fee collected for deposit', 0.00, 1, 'hatu k sardar', NULL, NULL, NULL, NULL, '2025-02-16 15:56:56', '2025-02-16 15:56:56', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18817, NULL, 'a4d58b54-cec3-4698-aeca-6c75268e9507', 'deposit', 1990000.00, '2025-02-16', '15:57:25', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-16 15:57:25', '2025-02-16 15:57:25', 85, 4, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18818, NULL, 'a4d58b54-cec3-4698-aeca-6c75268e9507', 'deposit', 1990000.00, '2025-02-16', '15:57:25', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-16 15:57:25', '2025-02-16 15:57:25', 4, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18819, NULL, 'a4d58b54-cec3-4698-aeca-6c75268e9507', 'deposit', 1990000.00, '2025-02-16', '15:57:25', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-16 15:57:25', '2025-02-16 15:57:25', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18858, NULL, '59824460-50b7-4975-ad53-6db294a56f10', 'withdrawal', 787.00, '2025-02-16', '17:10:11', NULL, 0.00, 1, 'Twman', NULL, NULL, NULL, NULL, '2025-02-16 17:10:11', '2025-02-16 17:10:11', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18859, NULL, '59824460-50b7-4975-ad53-6db294a56f10', 'withdrawal', 787.00, '2025-02-16', '17:10:11', NULL, 0.00, 1, 'Twman', NULL, NULL, NULL, NULL, '2025-02-16 17:10:11', '2025-02-16 17:10:11', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18860, NULL, '59824460-50b7-4975-ad53-6db294a56f10', 'deposit', 0.00, '2025-02-16', '17:10:11', 'Fee collected for withdrawal', 0.00, 1, 'Twman', NULL, NULL, NULL, NULL, '2025-02-16 17:10:11', '2025-02-16 17:10:11', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18861, NULL, 'a40ef0e8-a3c5-4771-b258-756699ebfd98', 'withdrawal', 14028000.00, '2025-02-16', '17:11:57', NULL, 20000.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-16 17:11:57', '2025-02-16 17:11:57', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18862, NULL, 'a40ef0e8-a3c5-4771-b258-756699ebfd98', 'withdrawal', 14008000.00, '2025-02-16', '17:11:57', NULL, 20000.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-16 17:11:57', '2025-02-16 17:11:57', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18863, NULL, 'a40ef0e8-a3c5-4771-b258-756699ebfd98', 'withdrawal', 14028000.00, '2025-02-16', '17:11:57', NULL, 20000.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-16 17:11:57', '2025-02-16 17:11:57', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18952, NULL, '9d28eaf7-1c82-41a6-8bbe-e0c040bbe9bf', 'deposit', 32500.00, '2025-02-16', '18:24:04', NULL, 0.00, 137, 'sangar', NULL, NULL, NULL, NULL, '2025-02-16 18:24:04', '2025-02-16 18:24:04', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18953, NULL, '9d28eaf7-1c82-41a6-8bbe-e0c040bbe9bf', 'deposit', 32500.00, '2025-02-16', '18:24:04', NULL, 0.00, 137, 'sangar', NULL, NULL, NULL, NULL, '2025-02-16 18:24:04', '2025-02-16 18:24:04', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18988, NULL, '0f610ebd-9c79-4d58-8f3a-ff8077b0feb3', 'withdrawal', 19799500.00, '2025-02-16', '19:02:02', NULL, 30000.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-16 19:02:02', '2025-02-16 19:02:02', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18989, NULL, '0f610ebd-9c79-4d58-8f3a-ff8077b0feb3', 'withdrawal', 19769500.00, '2025-02-16', '19:02:02', NULL, 30000.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-16 19:02:02', '2025-02-16 19:02:02', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18990, NULL, '0f610ebd-9c79-4d58-8f3a-ff8077b0feb3', 'withdrawal', 19799500.00, '2025-02-16', '19:02:02', NULL, 30000.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-16 19:02:02', '2025-02-16 19:02:02', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18993, NULL, '0b20c09a-828c-42b2-863d-ef0cb126a861', 'withdrawal', 1002000.00, '2025-02-16', '19:02:49', NULL, 1500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-16 19:02:49', '2025-02-16 19:02:49', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18994, NULL, '0b20c09a-828c-42b2-863d-ef0cb126a861', 'withdrawal', 1000500.00, '2025-02-16', '19:02:49', NULL, 1500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-16 19:02:49', '2025-02-16 19:02:49', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(18995, NULL, '0b20c09a-828c-42b2-863d-ef0cb126a861', 'withdrawal', 1002000.00, '2025-02-16', '19:02:49', NULL, 1500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-16 19:02:49', '2025-02-16 19:02:49', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19131, NULL, 'cd71b9ec-caf7-4bd9-99bd-14e89812346d', 'withdrawal', 8499.00, '2025-02-17', '10:42:01', NULL, -95.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-17 10:42:01', '2025-02-17 10:42:01', 271, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19132, NULL, 'cd71b9ec-caf7-4bd9-99bd-14e89812346d', 'withdrawal', 8499.00, '2025-02-17', '10:42:01', NULL, -95.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-17 10:42:01', '2025-02-17 10:42:01', 1, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19133, NULL, 'cd71b9ec-caf7-4bd9-99bd-14e89812346d', 'deposit', -95.00, '2025-02-17', '10:42:01', 'Fee collected for withdrawal', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-17 10:42:01', '2025-02-17 10:42:01', 22, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19134, NULL, 'c6e5408e-42bb-4a51-a6eb-a789fc4e0628', 'deposit', 700000.00, '2025-02-17', '10:44:43', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-17 10:44:43', '2025-02-17 10:44:43', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19135, NULL, 'c6e5408e-42bb-4a51-a6eb-a789fc4e0628', 'deposit', 700000.00, '2025-02-17', '10:44:43', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-17 10:44:43', '2025-02-17 10:44:43', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19136, NULL, 'c6e5408e-42bb-4a51-a6eb-a789fc4e0628', 'deposit', 0.00, '2025-02-17', '10:44:43', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-17 10:44:43', '2025-02-17 10:44:43', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19137, NULL, '99ae5a48-9885-4578-a1bb-6052f0f34896', 'deposit', 8499.00, '2025-02-17', '10:45:45', NULL, -95.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-17 10:45:45', '2025-02-17 10:45:45', 217, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19138, NULL, '99ae5a48-9885-4578-a1bb-6052f0f34896', 'deposit', 8499.00, '2025-02-17', '10:45:45', NULL, -95.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-17 10:45:45', '2025-02-17 10:45:45', 1, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19139, NULL, '99ae5a48-9885-4578-a1bb-6052f0f34896', 'deposit', -95.00, '2025-02-17', '10:45:45', 'Fee collected for deposit', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-17 10:45:45', '2025-02-17 10:45:45', 22, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19142, NULL, 'ff85b371-419c-427a-854e-8e209f6fe6a5', 'withdrawal', 250000.00, '2025-02-17', '10:47:08', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-17 10:47:08', '2025-02-17 10:47:08', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19143, NULL, 'ff85b371-419c-427a-854e-8e209f6fe6a5', 'withdrawal', 250000.00, '2025-02-17', '10:47:08', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-17 10:47:08', '2025-02-17 10:47:08', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19144, NULL, 'ff85b371-419c-427a-854e-8e209f6fe6a5', 'deposit', 0.00, '2025-02-17', '10:47:08', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-17 10:47:08', '2025-02-17 10:47:08', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19153, NULL, '97e4b306-2b68-448b-add7-c17546942302', 'deposit', 782.00, '2025-02-17', '10:58:54', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-17 10:58:54', '2025-02-17 10:58:54', 1048, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19154, NULL, '97e4b306-2b68-448b-add7-c17546942302', 'deposit', 782.00, '2025-02-17', '10:58:54', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-17 10:58:54', '2025-02-17 10:58:54', 1, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19155, NULL, '97e4b306-2b68-448b-add7-c17546942302', 'deposit', 0.00, '2025-02-17', '10:58:54', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-17 10:58:54', '2025-02-17 10:58:54', 22, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(19158, NULL, 'aa7994a7-a710-4808-8090-2014ebaef057', 'deposit', 1005.00, '2025-02-17', '11:03:10', NULL, 0.00, 1, 'suhl rafden', NULL, NULL, NULL, NULL, '2025-02-17 11:03:10', '2025-02-17 11:03:10', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19159, NULL, 'aa7994a7-a710-4808-8090-2014ebaef057', 'deposit', 1005.00, '2025-02-17', '11:03:10', NULL, 0.00, 1, 'suhl rafden', NULL, NULL, NULL, NULL, '2025-02-17 11:03:10', '2025-02-17 11:03:10', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19160, NULL, 'aa7994a7-a710-4808-8090-2014ebaef057', 'deposit', 0.00, '2025-02-17', '11:03:10', 'Fee collected for deposit', 0.00, 1, 'suhl rafden', NULL, NULL, NULL, NULL, '2025-02-17 11:03:10', '2025-02-17 11:03:10', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19161, NULL, '2babe191-b7af-4253-bbb5-389b1881ab90', 'deposit', 6036000.00, '2025-02-17', '11:03:15', NULL, 0.00, 1, 'suhl rafden', NULL, NULL, NULL, NULL, '2025-02-17 11:03:15', '2025-02-17 11:03:15', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19162, NULL, '2babe191-b7af-4253-bbb5-389b1881ab90', 'deposit', 6036000.00, '2025-02-17', '11:03:15', NULL, 0.00, 1, 'suhl rafden', NULL, NULL, NULL, NULL, '2025-02-17 11:03:15', '2025-02-17 11:03:15', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19163, NULL, '2babe191-b7af-4253-bbb5-389b1881ab90', 'deposit', 0.00, '2025-02-17', '11:03:15', 'Fee collected for deposit', 0.00, 1, 'suhl rafden', NULL, NULL, NULL, NULL, '2025-02-17 11:03:15', '2025-02-17 11:03:15', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19164, NULL, '5e236b6b-8ed7-4777-91b6-c3c12577d40c', 'deposit', 1941.00, '2025-02-17', '11:03:47', NULL, 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-17 11:03:47', '2025-02-17 11:03:47', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19165, NULL, '5e236b6b-8ed7-4777-91b6-c3c12577d40c', 'deposit', 1941.00, '2025-02-17', '11:03:47', NULL, 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-17 11:03:47', '2025-02-17 11:03:47', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19166, NULL, '5e236b6b-8ed7-4777-91b6-c3c12577d40c', 'deposit', 0.00, '2025-02-17', '11:03:47', 'Fee collected for deposit', 0.00, 1, 'aso', NULL, NULL, NULL, NULL, '2025-02-17 11:03:47', '2025-02-17 11:03:47', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19167, NULL, '609aca72-5b3e-40b0-b2ce-df0927561f9a', 'deposit', 5002.00, '2025-02-17', '11:04:38', NULL, 2.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-17 11:04:38', '2025-02-17 11:04:38', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19168, NULL, '609aca72-5b3e-40b0-b2ce-df0927561f9a', 'deposit', 5002.00, '2025-02-17', '11:04:38', NULL, 2.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-17 11:04:38', '2025-02-17 11:04:38', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19169, NULL, '609aca72-5b3e-40b0-b2ce-df0927561f9a', 'deposit', 2.00, '2025-02-17', '11:04:38', 'Fee collected for deposit', 0.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-17 11:04:38', '2025-02-17 11:04:38', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19170, NULL, '7a484508-987a-4e48-9db0-0a4a3e50ee3c', 'withdrawal', 125000.00, '2025-02-17', '11:05:41', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-17 11:05:41', '2025-02-17 11:05:41', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19171, NULL, '7a484508-987a-4e48-9db0-0a4a3e50ee3c', 'withdrawal', 125000.00, '2025-02-17', '11:05:41', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-17 11:05:41', '2025-02-17 11:05:41', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19172, NULL, '7a484508-987a-4e48-9db0-0a4a3e50ee3c', 'deposit', 0.00, '2025-02-17', '11:05:41', 'Fee collected for withdrawal', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-17 11:05:41', '2025-02-17 11:05:41', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19175, NULL, 'cc17597b-240f-4f35-9a90-2a224bfa2b86', 'withdrawal', 1941.00, '2025-02-17', '11:09:58', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:09:58', '2025-02-17 11:09:58', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19176, NULL, 'cc17597b-240f-4f35-9a90-2a224bfa2b86', 'withdrawal', 1941.00, '2025-02-17', '11:09:58', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:09:58', '2025-02-17 11:09:58', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19177, NULL, 'cc17597b-240f-4f35-9a90-2a224bfa2b86', 'deposit', 0.00, '2025-02-17', '11:09:58', 'Fee collected for withdrawal', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:09:58', '2025-02-17 11:09:58', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19178, NULL, '86eeae8d-afaa-48a2-a07f-554f1cb435f7', 'withdrawal', 6036000.00, '2025-02-17', '11:12:36', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:12:36', '2025-02-17 11:12:36', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19179, NULL, '86eeae8d-afaa-48a2-a07f-554f1cb435f7', 'withdrawal', 6036000.00, '2025-02-17', '11:12:36', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:12:36', '2025-02-17 11:12:36', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19180, NULL, '86eeae8d-afaa-48a2-a07f-554f1cb435f7', 'deposit', 0.00, '2025-02-17', '11:12:36', 'Fee collected for withdrawal', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:12:36', '2025-02-17 11:12:36', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19181, NULL, '61993667-eefb-4d88-bf0c-c58e08cdc811', 'withdrawal', 1005.00, '2025-02-17', '11:12:37', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:12:37', '2025-02-17 11:12:37', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19182, NULL, '61993667-eefb-4d88-bf0c-c58e08cdc811', 'withdrawal', 1005.00, '2025-02-17', '11:12:37', NULL, 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:12:37', '2025-02-17 11:12:37', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19183, NULL, '61993667-eefb-4d88-bf0c-c58e08cdc811', 'deposit', 0.00, '2025-02-17', '11:12:37', 'Fee collected for withdrawal', 0.00, 1, 'm.djla', NULL, NULL, NULL, NULL, '2025-02-17 11:12:37', '2025-02-17 11:12:37', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19212, NULL, '8f23181e-33bd-49d4-844f-8256ab0d591d', 'withdrawal', 3905750.00, '2025-02-17', '11:47:31', NULL, 5750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 11:47:31', '2025-02-17 11:47:31', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19213, NULL, '8f23181e-33bd-49d4-844f-8256ab0d591d', 'withdrawal', 3905750.00, '2025-02-17', '11:47:31', NULL, 5750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 11:47:31', '2025-02-17 11:47:31', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19214, NULL, '8f23181e-33bd-49d4-844f-8256ab0d591d', 'deposit', 5750.00, '2025-02-17', '11:47:31', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 11:47:31', '2025-02-17 11:47:31', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19222, NULL, 'd3b2dc85-89f5-427d-906c-b5bd11dda306', 'deposit', 25000000.00, '2025-02-17', '11:53:12', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-17 11:53:12', '2025-02-17 11:53:12', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19223, NULL, 'd3b2dc85-89f5-427d-906c-b5bd11dda306', 'deposit', 25000000.00, '2025-02-17', '11:53:12', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-17 11:53:12', '2025-02-17 11:53:12', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19224, NULL, 'd3b2dc85-89f5-427d-906c-b5bd11dda306', 'deposit', 0.00, '2025-02-17', '11:53:12', 'Fee collected for deposit', 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-17 11:53:12', '2025-02-17 11:53:12', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19227, NULL, '9642ee7c-2f5a-4982-918b-5ee796f5c705', 'withdrawal', 1990000.00, '2025-02-17', '12:02:42', NULL, 0.00, 136, 'Sardar', NULL, NULL, NULL, NULL, '2025-02-17 12:02:42', '2025-02-17 12:02:42', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19228, NULL, '9642ee7c-2f5a-4982-918b-5ee796f5c705', 'withdrawal', 1990000.00, '2025-02-17', '12:02:42', NULL, 0.00, 136, 'Sardar', NULL, NULL, NULL, NULL, '2025-02-17 12:02:42', '2025-02-17 12:02:42', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19259, NULL, '4aa7e305-8536-4da0-b337-10315d50fe1d', 'withdrawal', 3105000.00, '2025-02-17', '13:38:57', NULL, 5000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:38:57', '2025-02-17 13:38:57', 216, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19260, NULL, '4aa7e305-8536-4da0-b337-10315d50fe1d', 'withdrawal', 3100000.00, '2025-02-17', '13:38:57', NULL, 5000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:38:57', '2025-02-17 13:38:57', 18, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19261, NULL, '4aa7e305-8536-4da0-b337-10315d50fe1d', 'withdrawal', 3105000.00, '2025-02-17', '13:38:57', NULL, 5000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:38:57', '2025-02-17 13:38:57', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19262, NULL, '887f8655-d8ae-47ba-8763-049168a75d50', 'withdrawal', 2616000.00, '2025-02-17', '13:39:37', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:39:37', '2025-02-17 13:39:37', 216, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19263, NULL, '887f8655-d8ae-47ba-8763-049168a75d50', 'withdrawal', 2612000.00, '2025-02-17', '13:39:37', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:39:37', '2025-02-17 13:39:37', 18, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19264, NULL, '887f8655-d8ae-47ba-8763-049168a75d50', 'withdrawal', 2616000.00, '2025-02-17', '13:39:37', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:39:37', '2025-02-17 13:39:37', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19267, NULL, 'ea0caefd-b405-4892-bcf1-1f7e2fa4ba72', 'withdrawal', 1352000.00, '2025-02-17', '13:42:24', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:42:24', '2025-02-17 13:42:24', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19268, NULL, 'ea0caefd-b405-4892-bcf1-1f7e2fa4ba72', 'withdrawal', 1350000.00, '2025-02-17', '13:42:24', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:42:24', '2025-02-17 13:42:24', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19269, NULL, 'ea0caefd-b405-4892-bcf1-1f7e2fa4ba72', 'withdrawal', 1352000.00, '2025-02-17', '13:42:24', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:42:24', '2025-02-17 13:42:24', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19284, NULL, '3f3f0746-efb0-4f21-8cb5-f9f84c643ba1', 'withdrawal', 381500.00, '2025-02-17', '13:47:30', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:47:30', '2025-02-17 13:47:30', 206, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19285, NULL, '3f3f0746-efb0-4f21-8cb5-f9f84c643ba1', 'withdrawal', 380000.00, '2025-02-17', '13:47:30', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:47:30', '2025-02-17 13:47:30', 18, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19286, NULL, '3f3f0746-efb0-4f21-8cb5-f9f84c643ba1', 'withdrawal', 381500.00, '2025-02-17', '13:47:30', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 13:47:30', '2025-02-17 13:47:30', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19291, NULL, '102901e4-eaef-4266-b4b6-cbafb8017f30', 'withdrawal', 30000.00, '2025-02-17', '13:50:01', NULL, 0.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-17 13:50:01', '2025-02-17 13:50:01', 222, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19292, NULL, '102901e4-eaef-4266-b4b6-cbafb8017f30', 'withdrawal', 30000.00, '2025-02-17', '13:50:01', NULL, 0.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-17 13:50:01', '2025-02-17 13:50:01', 2, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19293, NULL, '102901e4-eaef-4266-b4b6-cbafb8017f30', 'deposit', 0.00, '2025-02-17', '13:50:01', 'Fee collected for withdrawal', 0.00, 1, 'ftth', NULL, NULL, NULL, NULL, '2025-02-17 13:50:01', '2025-02-17 13:50:01', 23, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19310, NULL, '8886ecd4-9499-4ac6-85b5-c7c07755fd09', 'deposit', 8499.00, '2025-02-17', '14:01:39', 'شکانەوە لەسەر داواکاری خۆی', 1500.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-17 14:01:39', '2025-02-17 14:01:39', 1, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19311, NULL, '8886ecd4-9499-4ac6-85b5-c7c07755fd09', 'withdrawal', 8499.00, '2025-02-17', '14:01:39', 'شکانەوە لەسەر داواکاری خۆی', 1500.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-17 14:01:39', '2025-02-17 14:01:39', 217, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19312, NULL, '8886ecd4-9499-4ac6-85b5-c7c07755fd09', 'withdrawal', 12752749.50, '2025-02-17', '14:01:39', 'شکانەوە لەسەر داواکاری خۆی', 1500.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-17 14:01:39', '2025-02-17 14:01:39', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19313, NULL, '8886ecd4-9499-4ac6-85b5-c7c07755fd09', 'deposit', 12752749.50, '2025-02-17', '14:01:39', 'شکانەوە لەسەر داواکاری خۆی', 1500.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-17 14:01:39', '2025-02-17 14:01:39', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19314, NULL, 'ea027b54-b4e2-45d7-95a0-3cdc2775afb5', 'deposit', 4250.00, '2025-02-17', '14:04:03', NULL, 0.00, 1, 'hsab alugor', NULL, NULL, NULL, NULL, '2025-02-17 14:04:03', '2025-02-17 14:04:03', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19315, NULL, 'ea027b54-b4e2-45d7-95a0-3cdc2775afb5', 'deposit', 4250.00, '2025-02-17', '14:04:03', NULL, 0.00, 1, 'hsab alugor', NULL, NULL, NULL, NULL, '2025-02-17 14:04:03', '2025-02-17 14:04:03', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19316, NULL, 'ea027b54-b4e2-45d7-95a0-3cdc2775afb5', 'deposit', 0.00, '2025-02-17', '14:04:03', 'Fee collected for deposit', 0.00, 1, 'hsab alugor', NULL, NULL, NULL, NULL, '2025-02-17 14:04:03', '2025-02-17 14:04:03', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19323, NULL, '3c482e4d-54d7-41dd-925d-8dc729daf5ca', 'deposit', 2500.00, '2025-02-17', '14:27:19', NULL, 0.00, 136, 'Aram', NULL, NULL, NULL, NULL, '2025-02-17 14:27:19', '2025-02-17 14:27:19', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19324, NULL, '3c482e4d-54d7-41dd-925d-8dc729daf5ca', 'deposit', 2500.00, '2025-02-17', '14:27:19', NULL, 0.00, 136, 'Aram', NULL, NULL, NULL, NULL, '2025-02-17 14:27:19', '2025-02-17 14:27:19', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19333, NULL, '342bc760-85a9-4698-ba03-8cd839058b5b', 'deposit', 40.00, '2025-02-17', '14:53:14', NULL, 0.00, 136, 'Aram', NULL, NULL, NULL, NULL, '2025-02-17 14:53:14', '2025-02-17 14:53:14', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19334, NULL, '342bc760-85a9-4698-ba03-8cd839058b5b', 'deposit', 40.00, '2025-02-17', '14:53:14', NULL, 0.00, 136, 'Aram', NULL, NULL, NULL, NULL, '2025-02-17 14:53:14', '2025-02-17 14:53:14', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19335, NULL, '9ce89295-8b11-43e5-8890-9ac5938e502e', 'deposit', 9000.00, '2025-02-17', '14:54:04', '', 0.00, 136, 'aram', NULL, NULL, NULL, NULL, '2025-02-17 14:54:04', '2025-02-17 14:54:04', 179, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19336, NULL, '9ce89295-8b11-43e5-8890-9ac5938e502e', 'deposit', 9000.00, '2025-02-17', '14:54:04', '', 0.00, 136, 'aram', NULL, NULL, NULL, NULL, '2025-02-17 14:54:04', '2025-02-17 14:54:04', 2, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19347, NULL, '88ed647a-793c-48fe-93c9-03bf6b536675', 'withdrawal', 1500.00, '2025-02-17', '15:18:57', NULL, 0.00, 1, 'k hawkar sarf', NULL, NULL, NULL, NULL, '2025-02-17 15:18:57', '2025-02-17 15:18:57', 240, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19348, NULL, '88ed647a-793c-48fe-93c9-03bf6b536675', 'withdrawal', 1500.00, '2025-02-17', '15:18:57', NULL, 0.00, 1, 'k hawkar sarf', NULL, NULL, NULL, NULL, '2025-02-17 15:18:57', '2025-02-17 15:18:57', 1, 240, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19349, NULL, '88ed647a-793c-48fe-93c9-03bf6b536675', 'deposit', 0.00, '2025-02-17', '15:18:57', 'Fee collected for withdrawal', 0.00, 1, 'k hawkar sarf', NULL, NULL, NULL, NULL, '2025-02-17 15:18:57', '2025-02-17 15:18:57', 22, 240, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19350, NULL, 'd7d3b743-df54-46a5-b8a2-bafde367d69f', 'deposit', 7500000.00, '2025-02-17', '15:19:42', NULL, 0.00, 1, 'hatu k hawkar', NULL, NULL, NULL, NULL, '2025-02-17 15:19:42', '2025-02-17 15:19:42', 241, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19351, NULL, 'd7d3b743-df54-46a5-b8a2-bafde367d69f', 'deposit', 7500000.00, '2025-02-17', '15:19:42', NULL, 0.00, 1, 'hatu k hawkar', NULL, NULL, NULL, NULL, '2025-02-17 15:19:42', '2025-02-17 15:19:42', 2, 241, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19352, NULL, 'd7d3b743-df54-46a5-b8a2-bafde367d69f', 'deposit', 0.00, '2025-02-17', '15:19:42', 'Fee collected for deposit', 0.00, 1, 'hatu k hawkar', NULL, NULL, NULL, NULL, '2025-02-17 15:19:42', '2025-02-17 15:19:42', 23, 241, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19355, NULL, '93463d13-6c46-4a4c-8606-212b0c1fdd63', 'withdrawal', 835000.00, '2025-02-17', '15:22:01', '500$ ba dolar sarf-baqi d dinar
150400', 0.00, 1, 'sarf k hawkar', NULL, NULL, NULL, NULL, '2025-02-17 15:22:01', '2025-02-17 15:22:01', 451, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19356, NULL, '93463d13-6c46-4a4c-8606-212b0c1fdd63', 'withdrawal', 835000.00, '2025-02-17', '15:22:01', '500$ ba dolar sarf-baqi d dinar
150400', 0.00, 1, 'sarf k hawkar', NULL, NULL, NULL, NULL, '2025-02-17 15:22:01', '2025-02-17 15:22:01', 2, 451, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19357, NULL, '93463d13-6c46-4a4c-8606-212b0c1fdd63', 'deposit', 0.00, '2025-02-17', '15:22:01', 'Fee collected for withdrawal', 0.00, 1, 'sarf k hawkar', NULL, NULL, NULL, NULL, '2025-02-17 15:22:01', '2025-02-17 15:22:01', 23, 451, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19362, NULL, '05ed1f2f-1a6e-4911-83d1-9c8fd34f8866', 'withdrawal', 400.00, '2025-02-17', '15:29:27', NULL, 0.00, 1, 'sarf k aram', NULL, NULL, NULL, NULL, '2025-02-17 15:29:27', '2025-02-17 15:29:27', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19363, NULL, '05ed1f2f-1a6e-4911-83d1-9c8fd34f8866', 'withdrawal', 400.00, '2025-02-17', '15:29:27', NULL, 0.00, 1, 'sarf k aram', NULL, NULL, NULL, NULL, '2025-02-17 15:29:27', '2025-02-17 15:29:27', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19364, NULL, '05ed1f2f-1a6e-4911-83d1-9c8fd34f8866', 'deposit', 0.00, '2025-02-17', '15:29:27', 'Fee collected for withdrawal', 0.00, 1, 'sarf k aram', NULL, NULL, NULL, NULL, '2025-02-17 15:29:27', '2025-02-17 15:29:27', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19365, NULL, '1e8d198e-9415-4a75-8004-6988bf37e3d6', 'withdrawal', 30000.00, '2025-02-17', '15:31:41', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-17 15:31:41', '2025-02-17 15:31:41', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19366, NULL, '1e8d198e-9415-4a75-8004-6988bf37e3d6', 'withdrawal', 30000.00, '2025-02-17', '15:31:41', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-17 15:31:41', '2025-02-17 15:31:41', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19367, NULL, '1e8d198e-9415-4a75-8004-6988bf37e3d6', 'deposit', 0.00, '2025-02-17', '15:31:41', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-17 15:31:41', '2025-02-17 15:31:41', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19368, NULL, '74dea9da-212a-4bfc-ac59-a91e6387d04f', 'withdrawal', 426000.00, '2025-02-17', '15:32:23', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 15:32:23', '2025-02-17 15:32:23', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19369, NULL, '74dea9da-212a-4bfc-ac59-a91e6387d04f', 'withdrawal', 426000.00, '2025-02-17', '15:32:23', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 15:32:23', '2025-02-17 15:32:23', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19370, NULL, '74dea9da-212a-4bfc-ac59-a91e6387d04f', 'deposit', 1000.00, '2025-02-17', '15:32:23', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 15:32:23', '2025-02-17 15:32:23', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19371, NULL, '487cef48-41f7-4de2-93b6-4de24c363f66', 'deposit', 302.00, '2025-02-17', '15:34:24', NULL, 2.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-17 15:34:24', '2025-02-17 15:34:24', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19372, NULL, '487cef48-41f7-4de2-93b6-4de24c363f66', 'deposit', 302.00, '2025-02-17', '15:34:24', NULL, 2.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-17 15:34:24', '2025-02-17 15:34:24', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19373, NULL, '487cef48-41f7-4de2-93b6-4de24c363f66', 'deposit', 2.00, '2025-02-17', '15:34:24', 'Fee collected for deposit', 0.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-17 15:34:24', '2025-02-17 15:34:24', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19376, NULL, '67ea677b-73c7-4264-ae2b-fb0fc5d93a33', 'withdrawal', 8499.00, '2025-02-17', '15:35:46', NULL, 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-02-17 15:35:46', '2025-02-17 15:35:46', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19377, NULL, '67ea677b-73c7-4264-ae2b-fb0fc5d93a33', 'withdrawal', 8499.00, '2025-02-17', '15:35:46', NULL, 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-02-17 15:35:47', '2025-02-17 15:35:47', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19378, NULL, '67ea677b-73c7-4264-ae2b-fb0fc5d93a33', 'deposit', 0.00, '2025-02-17', '15:35:46', 'Fee collected for withdrawal', 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-02-17 15:35:47', '2025-02-17 15:35:47', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19379, NULL, '5700d30d-f275-41d4-852f-3367db577805', 'deposit', 9965.00, '2025-02-17', '15:36:56', NULL, -35.00, 1, 'istanbul-selim huseyin', NULL, NULL, NULL, NULL, '2025-02-17 15:36:56', '2025-02-17 15:36:56', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19380, NULL, '5700d30d-f275-41d4-852f-3367db577805', 'deposit', 9965.00, '2025-02-17', '15:36:56', NULL, -35.00, 1, 'istanbul-selim huseyin', NULL, NULL, NULL, NULL, '2025-02-17 15:36:56', '2025-02-17 15:36:56', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19381, NULL, '5700d30d-f275-41d4-852f-3367db577805', 'deposit', -35.00, '2025-02-17', '15:36:56', 'Fee collected for deposit', 0.00, 1, 'istanbul-selim huseyin', NULL, NULL, NULL, NULL, '2025-02-17 15:36:56', '2025-02-17 15:36:56', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19382, NULL, 'd0d159b3-51ef-442e-9596-3e690647c7ff', 'withdrawal', 615000.00, '2025-02-17', '15:37:15', NULL, 0.00, 136, 'Mustafa', NULL, NULL, NULL, NULL, '2025-02-17 15:37:15', '2025-02-17 15:37:15', 241, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19383, NULL, 'd0d159b3-51ef-442e-9596-3e690647c7ff', 'withdrawal', 615000.00, '2025-02-17', '15:37:15', NULL, 0.00, 136, 'Mustafa', NULL, NULL, NULL, NULL, '2025-02-17 15:37:15', '2025-02-17 15:37:15', 2, 241, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19384, NULL, 'b2b4e165-fd91-41d6-9982-e8064734a7be', 'withdrawal', 15000000.00, '2025-02-17', '15:37:57', NULL, 0.00, 1, 'k ahmed izzaden', NULL, NULL, NULL, NULL, '2025-02-17 15:37:57', '2025-02-17 15:37:57', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19385, NULL, 'b2b4e165-fd91-41d6-9982-e8064734a7be', 'withdrawal', 15000000.00, '2025-02-17', '15:37:57', NULL, 0.00, 1, 'k ahmed izzaden', NULL, NULL, NULL, NULL, '2025-02-17 15:37:57', '2025-02-17 15:37:57', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19386, NULL, 'b2b4e165-fd91-41d6-9982-e8064734a7be', 'deposit', 0.00, '2025-02-17', '15:37:57', 'Fee collected for withdrawal', 0.00, 1, 'k ahmed izzaden', NULL, NULL, NULL, NULL, '2025-02-17 15:37:57', '2025-02-17 15:37:57', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19397, NULL, '387f59be-42cb-41dd-9e38-a39c9d18f87d', 'withdrawal', 992000.00, '2025-02-17', '15:47:12', NULL, -8000.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-17 15:47:12', '2025-02-17 15:47:12', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19398, NULL, '387f59be-42cb-41dd-9e38-a39c9d18f87d', 'withdrawal', 992000.00, '2025-02-17', '15:47:12', NULL, -8000.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-17 15:47:12', '2025-02-17 15:47:12', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19399, NULL, '387f59be-42cb-41dd-9e38-a39c9d18f87d', 'deposit', -8000.00, '2025-02-17', '15:47:12', 'Fee collected for withdrawal', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-17 15:47:12', '2025-02-17 15:47:12', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19407, NULL, 'c45c47ba-8ace-445f-a245-623d391c319d', 'withdrawal', 304.00, '2025-02-17', '15:52:19', NULL, 4.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-17 15:52:19', '2025-02-17 15:52:19', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19408, NULL, 'c45c47ba-8ace-445f-a245-623d391c319d', 'withdrawal', 304.00, '2025-02-17', '15:52:19', NULL, 4.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-17 15:52:19', '2025-02-17 15:52:19', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19409, NULL, 'c45c47ba-8ace-445f-a245-623d391c319d', 'deposit', 4.00, '2025-02-17', '15:52:19', 'Fee collected for withdrawal', 0.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-17 15:52:19', '2025-02-17 15:52:19', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19418, NULL, '8ceb808e-9f37-4f3a-9c8e-bfa5b143bfd9', 'deposit', 8499.00, '2025-02-17', '15:55:10', NULL, 0.00, 1, 'm.djla ', NULL, NULL, NULL, NULL, '2025-02-17 15:55:10', '2025-02-17 15:55:10', 271, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19419, NULL, '8ceb808e-9f37-4f3a-9c8e-bfa5b143bfd9', 'deposit', 8499.00, '2025-02-17', '15:55:10', NULL, 0.00, 1, 'm.djla ', NULL, NULL, NULL, NULL, '2025-02-17 15:55:10', '2025-02-17 15:55:10', 1, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(19420, NULL, '8ceb808e-9f37-4f3a-9c8e-bfa5b143bfd9', 'deposit', 0.00, '2025-02-17', '15:55:10', 'Fee collected for deposit', 0.00, 1, 'm.djla ', NULL, NULL, NULL, NULL, '2025-02-17 15:55:10', '2025-02-17 15:55:10', 22, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19421, NULL, '3f316147-50d7-4c54-acbf-ee89d8fc262a', 'withdrawal', 500.00, '2025-02-17', '15:55:56', NULL, 0.00, 136, 'Ezzatdin tahazadeh haki ', NULL, NULL, NULL, NULL, '2025-02-17 15:55:56', '2025-02-17 15:55:56', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19422, NULL, '3f316147-50d7-4c54-acbf-ee89d8fc262a', 'withdrawal', 500.00, '2025-02-17', '15:55:56', NULL, 0.00, 136, 'Ezzatdin tahazadeh haki ', NULL, NULL, NULL, NULL, '2025-02-17 15:55:56', '2025-02-17 15:55:56', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19423, NULL, '551c83fe-3967-4f09-baae-2fbeb567ca4c', 'withdrawal', 2.00, '2025-02-17', '15:59:26', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-17 15:59:26', '2025-02-17 15:59:26', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19424, NULL, '551c83fe-3967-4f09-baae-2fbeb567ca4c', 'withdrawal', 2.00, '2025-02-17', '15:59:26', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-17 15:59:26', '2025-02-17 15:59:26', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19425, NULL, '551c83fe-3967-4f09-baae-2fbeb567ca4c', 'deposit', 2.00, '2025-02-17', '15:59:26', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-17 15:59:26', '2025-02-17 15:59:26', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19446, NULL, '70f6fa18-d22f-4e41-b9b4-49f547128fd7', 'withdrawal', 978000.00, '2025-02-17', '16:24:39', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:24:39', '2025-02-17 16:24:39', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19447, NULL, '70f6fa18-d22f-4e41-b9b4-49f547128fd7', 'withdrawal', 976000.00, '2025-02-17', '16:24:39', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:24:39', '2025-02-17 16:24:39', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19448, NULL, '70f6fa18-d22f-4e41-b9b4-49f547128fd7', 'withdrawal', 978000.00, '2025-02-17', '16:24:39', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:24:39', '2025-02-17 16:24:39', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19449, NULL, 'ab40af42-461a-4bfe-babe-7abf7b5b58be', 'withdrawal', 10000.00, '2025-02-17', '16:26:52', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:26:52', '2025-02-17 16:26:52', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19450, NULL, 'ab40af42-461a-4bfe-babe-7abf7b5b58be', 'withdrawal', 10000.00, '2025-02-17', '16:26:52', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:26:52', '2025-02-17 16:26:52', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19451, NULL, 'ab40af42-461a-4bfe-babe-7abf7b5b58be', 'withdrawal', 10000.00, '2025-02-17', '16:26:52', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:26:52', '2025-02-17 16:26:52', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19452, NULL, '87ab39e3-cac4-4e75-9e99-e0b8fd96dbd1', 'withdrawal', 752500.00, '2025-02-17', '16:31:47', NULL, 1250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:31:47', '2025-02-17 16:31:47', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19453, NULL, '87ab39e3-cac4-4e75-9e99-e0b8fd96dbd1', 'withdrawal', 751250.00, '2025-02-17', '16:31:47', NULL, 1250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:31:47', '2025-02-17 16:31:47', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19454, NULL, '87ab39e3-cac4-4e75-9e99-e0b8fd96dbd1', 'withdrawal', 752500.00, '2025-02-17', '16:31:47', NULL, 1250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-17 16:31:47', '2025-02-17 16:31:47', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19455, NULL, '6a003229-4c21-4e39-bb50-5531c178d673', 'deposit', 15000000.00, '2025-02-17', '16:33:25', NULL, 0.00, 1, 'hatu k ahmed la m.djla', NULL, NULL, NULL, NULL, '2025-02-17 16:33:25', '2025-02-17 16:33:25', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19456, NULL, '6a003229-4c21-4e39-bb50-5531c178d673', 'deposit', 15000000.00, '2025-02-17', '16:33:25', NULL, 0.00, 1, 'hatu k ahmed la m.djla', NULL, NULL, NULL, NULL, '2025-02-17 16:33:25', '2025-02-17 16:33:25', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19457, NULL, '6a003229-4c21-4e39-bb50-5531c178d673', 'deposit', 0.00, '2025-02-17', '16:33:25', 'Fee collected for deposit', 0.00, 1, 'hatu k ahmed la m.djla', NULL, NULL, NULL, NULL, '2025-02-17 16:33:25', '2025-02-17 16:33:25', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19458, NULL, 'e6257075-e9a5-4ab2-a889-88397ed7ed1f', 'deposit', 7700.00, '2025-02-17', '16:38:14', NULL, 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-17 16:38:14', '2025-02-17 16:38:14', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19459, NULL, 'e6257075-e9a5-4ab2-a889-88397ed7ed1f', 'deposit', 7700.00, '2025-02-17', '16:38:14', NULL, 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-17 16:38:14', '2025-02-17 16:38:14', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19460, NULL, 'e6257075-e9a5-4ab2-a889-88397ed7ed1f', 'deposit', 0.00, '2025-02-17', '16:38:14', 'Fee collected for deposit', 0.00, 1, 'ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-17 16:38:14', '2025-02-17 16:38:14', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19495, NULL, 'ace1bc8f-ad9e-462e-9541-aaea6ef97385', 'deposit', 5000.00, '2025-02-17', '17:39:35', NULL, 0.00, 132, 'Yad bayad abdulqadr', NULL, NULL, NULL, NULL, '2025-02-17 17:39:35', '2025-02-17 17:39:35', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19496, NULL, 'ace1bc8f-ad9e-462e-9541-aaea6ef97385', 'deposit', 5000.00, '2025-02-17', '17:39:35', NULL, 0.00, 132, 'Yad bayad abdulqadr', NULL, NULL, NULL, NULL, '2025-02-17 17:39:35', '2025-02-17 17:39:35', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19517, NULL, 'd825f036-5dd1-44ce-a8df-654a892168a3', 'deposit', 19800.00, '2025-02-17', '18:00:49', NULL, 0.00, 1, 'k.mohammed', NULL, NULL, NULL, NULL, '2025-02-17 18:00:49', '2025-02-17 18:00:49', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19518, NULL, 'd825f036-5dd1-44ce-a8df-654a892168a3', 'deposit', 19800.00, '2025-02-17', '18:00:49', NULL, 0.00, 1, 'k.mohammed', NULL, NULL, NULL, NULL, '2025-02-17 18:00:49', '2025-02-17 18:00:49', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19519, NULL, 'd825f036-5dd1-44ce-a8df-654a892168a3', 'deposit', 0.00, '2025-02-17', '18:00:49', 'Fee collected for deposit', 0.00, 1, 'k.mohammed', NULL, NULL, NULL, NULL, '2025-02-17 18:00:49', '2025-02-17 18:00:49', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19520, NULL, 'c2e9dfa1-fc82-4d89-85c2-8f1a070286a4', 'deposit', 1602.00, '2025-02-17', '18:01:57', 'Pound', 0.00, 1, 'k.mohammed', NULL, NULL, NULL, NULL, '2025-02-17 18:01:57', '2025-02-17 18:01:57', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19521, NULL, 'c2e9dfa1-fc82-4d89-85c2-8f1a070286a4', 'deposit', 1602.00, '2025-02-17', '18:01:57', 'Pound', 0.00, 1, 'k.mohammed', NULL, NULL, NULL, NULL, '2025-02-17 18:01:57', '2025-02-17 18:01:57', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19522, NULL, 'c2e9dfa1-fc82-4d89-85c2-8f1a070286a4', 'deposit', 0.00, '2025-02-17', '18:01:57', 'Fee collected for deposit', 0.00, 1, 'k.mohammed', NULL, NULL, NULL, NULL, '2025-02-17 18:01:57', '2025-02-17 18:01:57', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19523, NULL, 'b8e57894-61d5-47d3-96fe-0812937c2e4f', 'deposit', 20000000.00, '2025-02-17', '18:02:25', NULL, 0.00, 1, 'K.mohamed', NULL, NULL, NULL, NULL, '2025-02-17 18:02:25', '2025-02-17 18:02:25', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19524, NULL, 'b8e57894-61d5-47d3-96fe-0812937c2e4f', 'deposit', 20000000.00, '2025-02-17', '18:02:25', NULL, 0.00, 1, 'K.mohamed', NULL, NULL, NULL, NULL, '2025-02-17 18:02:25', '2025-02-17 18:02:25', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19525, NULL, 'b8e57894-61d5-47d3-96fe-0812937c2e4f', 'deposit', 0.00, '2025-02-17', '18:02:25', 'Fee collected for deposit', 0.00, 1, 'K.mohamed', NULL, NULL, NULL, NULL, '2025-02-17 18:02:25', '2025-02-17 18:02:25', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19534, NULL, '5b10881d-31d3-48c3-8eba-ccf9c0ec2aac', 'deposit', 21405.00, '2025-02-17', '18:08:02', 'شکانەوە لەسەر داواکاری خۆی', 1501.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-17 18:08:02', '2025-02-17 18:08:02', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19535, NULL, '5b10881d-31d3-48c3-8eba-ccf9c0ec2aac', 'withdrawal', 21405.00, '2025-02-17', '18:08:02', 'شکانەوە لەسەر داواکاری خۆی', 1501.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-17 18:08:02', '2025-02-17 18:08:02', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19536, NULL, '5b10881d-31d3-48c3-8eba-ccf9c0ec2aac', 'withdrawal', 32128905.00, '2025-02-17', '18:08:02', 'شکانەوە لەسەر داواکاری خۆی', 1501.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-17 18:08:02', '2025-02-17 18:08:02', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19537, NULL, '5b10881d-31d3-48c3-8eba-ccf9c0ec2aac', 'deposit', 32128905.00, '2025-02-17', '18:08:02', 'شکانەوە لەسەر داواکاری خۆی', 1501.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-17 18:08:02', '2025-02-17 18:08:02', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19650, NULL, '475934cb-5c5e-4ac9-aa3b-95bebf305c05', 'withdrawal', 10000000.00, '2025-02-17', '20:58:52', NULL, 0.00, 1, 'farhang sarbaz othman/07502414445', NULL, NULL, NULL, NULL, '2025-02-17 20:58:52', '2025-02-17 20:58:52', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19651, NULL, '475934cb-5c5e-4ac9-aa3b-95bebf305c05', 'withdrawal', 10000000.00, '2025-02-17', '20:58:52', NULL, 0.00, 1, 'farhang sarbaz othman/07502414445', NULL, NULL, NULL, NULL, '2025-02-17 20:58:52', '2025-02-17 20:58:52', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19652, NULL, '475934cb-5c5e-4ac9-aa3b-95bebf305c05', 'deposit', 0.00, '2025-02-17', '20:58:52', 'Fee collected for withdrawal', 0.00, 1, 'farhang sarbaz othman/07502414445', NULL, NULL, NULL, NULL, '2025-02-17 20:58:52', '2025-02-17 20:58:52', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19669, NULL, '40819fbb-2083-4417-9721-8dd1d88ea182', 'deposit', 5266000.00, '2025-02-17', '21:09:23', 'Nawe dwAmi hangaw', 0.00, 1, 'Ahmed hoshyar omer', NULL, NULL, NULL, NULL, '2025-02-17 21:09:23', '2025-02-17 21:09:23', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19670, NULL, '40819fbb-2083-4417-9721-8dd1d88ea182', 'deposit', 5266000.00, '2025-02-17', '21:09:23', 'Nawe dwAmi hangaw', 0.00, 1, 'Ahmed hoshyar omer', NULL, NULL, NULL, NULL, '2025-02-17 21:09:23', '2025-02-17 21:09:23', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19671, NULL, '40819fbb-2083-4417-9721-8dd1d88ea182', 'deposit', 0.00, '2025-02-17', '21:09:23', 'Fee collected for deposit', 0.00, 1, 'Ahmed hoshyar omer', NULL, NULL, NULL, NULL, '2025-02-17 21:09:23', '2025-02-17 21:09:23', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19699, NULL, 'f367cf67-0369-4533-8a90-f3a9645d8fac', 'withdrawal', 5260000.00, '2025-02-17', '21:40:00', NULL, 7500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:40:00', '2025-02-17 21:40:00', 85, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19700, NULL, 'f367cf67-0369-4533-8a90-f3a9645d8fac', 'withdrawal', 5252500.00, '2025-02-17', '21:40:00', NULL, 7500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:40:00', '2025-02-17 21:40:00', 18, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19701, NULL, 'f367cf67-0369-4533-8a90-f3a9645d8fac', 'withdrawal', 5260000.00, '2025-02-17', '21:40:00', NULL, 7500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:40:00', '2025-02-17 21:40:00', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19702, NULL, '44b2310e-cbb8-4cee-b12b-51d160a39f5d', 'withdrawal', 27054000.00, '2025-02-17', '21:42:23', NULL, 40500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:42:23', '2025-02-17 21:42:23', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19703, NULL, '44b2310e-cbb8-4cee-b12b-51d160a39f5d', 'withdrawal', 27013500.00, '2025-02-17', '21:42:23', NULL, 40500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:42:23', '2025-02-17 21:42:23', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19704, NULL, '44b2310e-cbb8-4cee-b12b-51d160a39f5d', 'withdrawal', 27054000.00, '2025-02-17', '21:42:23', NULL, 40500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:42:23', '2025-02-17 21:42:23', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19705, NULL, '5ec9897b-125b-4a6e-8897-85a94d39e22f', 'withdrawal', 1506500.00, '2025-02-17', '21:44:12', NULL, 2000.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:44:12', '2025-02-17 21:44:12', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19706, NULL, '5ec9897b-125b-4a6e-8897-85a94d39e22f', 'withdrawal', 1504500.00, '2025-02-17', '21:44:12', NULL, 2000.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:44:12', '2025-02-17 21:44:12', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19707, NULL, '5ec9897b-125b-4a6e-8897-85a94d39e22f', 'withdrawal', 1506500.00, '2025-02-17', '21:44:12', NULL, 2000.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-17 21:44:12', '2025-02-17 21:44:12', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19708, NULL, 'ff54cd28-86b4-4bbd-be2d-bbdfa5c58e59', 'withdrawal', 151000.00, '2025-02-17', '21:44:55', NULL, 500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-17 21:44:55', '2025-02-17 21:44:55', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19709, NULL, 'ff54cd28-86b4-4bbd-be2d-bbdfa5c58e59', 'withdrawal', 150500.00, '2025-02-17', '21:44:55', NULL, 500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-17 21:44:55', '2025-02-17 21:44:55', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19710, NULL, 'ff54cd28-86b4-4bbd-be2d-bbdfa5c58e59', 'withdrawal', 151000.00, '2025-02-17', '21:44:55', NULL, 500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-17 21:44:55', '2025-02-17 21:44:55', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19711, NULL, '2600616f-6fe6-4dff-a424-0e922c17eab8', 'withdrawal', 51000.00, '2025-02-17', '21:45:22', NULL, 500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-17 21:45:22', '2025-02-17 21:45:22', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19712, NULL, '2600616f-6fe6-4dff-a424-0e922c17eab8', 'withdrawal', 50500.00, '2025-02-17', '21:45:22', NULL, 500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-17 21:45:22', '2025-02-17 21:45:22', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19713, NULL, '2600616f-6fe6-4dff-a424-0e922c17eab8', 'withdrawal', 51000.00, '2025-02-17', '21:45:22', NULL, 500.00, 1, 'Zain', NULL, NULL, NULL, NULL, '2025-02-17 21:45:22', '2025-02-17 21:45:22', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19738, NULL, '22928d67-e447-44e0-8a9b-b3c9982b7f2c', 'deposit', 10000000.00, '2025-02-17', '22:11:19', NULL, 0.00, 1, 'Farhang sarbaz othman', NULL, NULL, NULL, NULL, '2025-02-17 22:11:19', '2025-02-17 22:11:19', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19739, NULL, '22928d67-e447-44e0-8a9b-b3c9982b7f2c', 'deposit', 10000000.00, '2025-02-17', '22:11:19', NULL, 0.00, 1, 'Farhang sarbaz othman', NULL, NULL, NULL, NULL, '2025-02-17 22:11:19', '2025-02-17 22:11:19', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19740, NULL, '22928d67-e447-44e0-8a9b-b3c9982b7f2c', 'deposit', 0.00, '2025-02-17', '22:11:19', 'Fee collected for deposit', 0.00, 1, 'Farhang sarbaz othman', NULL, NULL, NULL, NULL, '2025-02-17 22:11:19', '2025-02-17 22:11:19', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19791, NULL, '63399a16-88f8-4eeb-9f4f-49c3988ddb66', 'withdrawal', 2000000.00, '2025-02-18', '09:56:52', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-18 09:56:52', '2025-02-18 09:56:52', 171, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19792, NULL, '63399a16-88f8-4eeb-9f4f-49c3988ddb66', 'withdrawal', 2000000.00, '2025-02-18', '09:56:52', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-18 09:56:52', '2025-02-18 09:56:52', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19793, NULL, '63399a16-88f8-4eeb-9f4f-49c3988ddb66', 'deposit', 0.00, '2025-02-18', '09:56:52', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-18 09:56:52', '2025-02-18 09:56:52', 23, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19796, NULL, '182e3c42-2889-414f-9a14-f485d9d83ea3', 'withdrawal', 2000000.00, '2025-02-18', '09:58:48', NULL, 0.00, 1, 'aram - hazari', NULL, NULL, NULL, NULL, '2025-02-18 09:58:48', '2025-02-18 09:58:48', 179, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19797, NULL, '182e3c42-2889-414f-9a14-f485d9d83ea3', 'withdrawal', 2000000.00, '2025-02-18', '09:58:48', NULL, 0.00, 1, 'aram - hazari', NULL, NULL, NULL, NULL, '2025-02-18 09:58:48', '2025-02-18 09:58:48', 2, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19798, NULL, '182e3c42-2889-414f-9a14-f485d9d83ea3', 'deposit', 0.00, '2025-02-18', '09:58:48', 'Fee collected for withdrawal', 0.00, 1, 'aram - hazari', NULL, NULL, NULL, NULL, '2025-02-18 09:58:48', '2025-02-18 09:58:48', 23, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19799, NULL, '7ebd9b40-f3b1-4bcc-90d5-f87cb276880d', 'withdrawal', 405.00, '2025-02-18', '10:01:46', NULL, 405.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 10:01:46', '2025-02-18 10:01:46', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19800, NULL, '7ebd9b40-f3b1-4bcc-90d5-f87cb276880d', 'withdrawal', 405.00, '2025-02-18', '10:01:46', NULL, 405.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 10:01:46', '2025-02-18 10:01:46', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19801, NULL, '7ebd9b40-f3b1-4bcc-90d5-f87cb276880d', 'deposit', 405.00, '2025-02-18', '10:01:46', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 10:01:46', '2025-02-18 10:01:46', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19802, NULL, '990c3043-a25b-4876-96d3-03a01eacb7e1', 'withdrawal', 6000.00, '2025-02-18', '10:07:20', NULL, 6000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 10:07:20', '2025-02-18 10:07:20', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19803, NULL, '990c3043-a25b-4876-96d3-03a01eacb7e1', 'withdrawal', 6000.00, '2025-02-18', '10:07:20', NULL, 6000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 10:07:20', '2025-02-18 10:07:20', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19804, NULL, '990c3043-a25b-4876-96d3-03a01eacb7e1', 'deposit', 6000.00, '2025-02-18', '10:07:20', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 10:07:21', '2025-02-18 10:07:21', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19809, NULL, 'e4fa1ae6-9917-4761-99dd-3f198efff462', 'deposit', 5000000.00, '2025-02-18', '10:11:46', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-18 10:11:46', '2025-02-18 10:11:46', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19810, NULL, 'e4fa1ae6-9917-4761-99dd-3f198efff462', 'deposit', 5000000.00, '2025-02-18', '10:11:46', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-18 10:11:46', '2025-02-18 10:11:46', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19811, NULL, 'e4fa1ae6-9917-4761-99dd-3f198efff462', 'deposit', 0.00, '2025-02-18', '10:11:46', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-18 10:11:46', '2025-02-18 10:11:46', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19812, NULL, 'ec275b60-5233-4ece-836e-98be6fee6c59', 'withdrawal', 1000000.00, '2025-02-18', '10:12:07', NULL, 0.00, 1, 'sarf k hemn', NULL, NULL, NULL, NULL, '2025-02-18 10:12:07', '2025-02-18 10:12:07', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19813, NULL, 'ec275b60-5233-4ece-836e-98be6fee6c59', 'withdrawal', 1000000.00, '2025-02-18', '10:12:07', NULL, 0.00, 1, 'sarf k hemn', NULL, NULL, NULL, NULL, '2025-02-18 10:12:07', '2025-02-18 10:12:07', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19814, NULL, 'ec275b60-5233-4ece-836e-98be6fee6c59', 'deposit', 0.00, '2025-02-18', '10:12:07', 'Fee collected for withdrawal', 0.00, 1, 'sarf k hemn', NULL, NULL, NULL, NULL, '2025-02-18 10:12:07', '2025-02-18 10:12:07', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19817, NULL, '811957f3-0a2d-4e5f-b9c5-9a41df11fb17', 'withdrawal', 10000000.00, '2025-02-18', '10:13:12', NULL, 0.00, 1, 'sarf farhang sarbaz', NULL, NULL, NULL, NULL, '2025-02-18 10:13:12', '2025-02-18 10:13:12', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19818, NULL, '811957f3-0a2d-4e5f-b9c5-9a41df11fb17', 'withdrawal', 10000000.00, '2025-02-18', '10:13:12', NULL, 0.00, 1, 'sarf farhang sarbaz', NULL, NULL, NULL, NULL, '2025-02-18 10:13:12', '2025-02-18 10:13:12', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19819, NULL, '811957f3-0a2d-4e5f-b9c5-9a41df11fb17', 'deposit', 0.00, '2025-02-18', '10:13:12', 'Fee collected for withdrawal', 0.00, 1, 'sarf farhang sarbaz', NULL, NULL, NULL, NULL, '2025-02-18 10:13:12', '2025-02-18 10:13:12', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19822, NULL, '696ab9e0-6358-4e33-a9a5-83eaf9c059f9', 'deposit', 10000000.00, '2025-02-18', '10:13:38', NULL, 0.00, 1, 'hatu k farhang', NULL, NULL, NULL, NULL, '2025-02-18 10:13:38', '2025-02-18 10:13:38', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19823, NULL, '696ab9e0-6358-4e33-a9a5-83eaf9c059f9', 'deposit', 10000000.00, '2025-02-18', '10:13:38', NULL, 0.00, 1, 'hatu k farhang', NULL, NULL, NULL, NULL, '2025-02-18 10:13:38', '2025-02-18 10:13:38', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19824, NULL, '696ab9e0-6358-4e33-a9a5-83eaf9c059f9', 'deposit', 0.00, '2025-02-18', '10:13:38', 'Fee collected for deposit', 0.00, 1, 'hatu k farhang', NULL, NULL, NULL, NULL, '2025-02-18 10:13:38', '2025-02-18 10:13:38', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19833, NULL, 'cf0b2fb5-a850-4d41-aebb-8a1e91edf0d2', 'withdrawal', 10000.00, '2025-02-18', '10:21:14', NULL, 0.00, 1, 'istanbul-selim huseyin', NULL, NULL, NULL, NULL, '2025-02-18 10:21:14', '2025-02-18 10:21:14', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19834, NULL, 'cf0b2fb5-a850-4d41-aebb-8a1e91edf0d2', 'withdrawal', 10000.00, '2025-02-18', '10:21:14', NULL, 0.00, 1, 'istanbul-selim huseyin', NULL, NULL, NULL, NULL, '2025-02-18 10:21:14', '2025-02-18 10:21:14', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19835, NULL, 'cf0b2fb5-a850-4d41-aebb-8a1e91edf0d2', 'deposit', 0.00, '2025-02-18', '10:21:14', 'Fee collected for withdrawal', 0.00, 1, 'istanbul-selim huseyin', NULL, NULL, NULL, NULL, '2025-02-18 10:21:14', '2025-02-18 10:21:14', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19836, NULL, 'b0d30a32-f813-48de-bc00-cd59de4f339b', 'deposit', 9300.00, '2025-02-18', '10:21:47', NULL, 0.00, 1, 'k abdulla hatu', NULL, NULL, NULL, NULL, '2025-02-18 10:21:47', '2025-02-18 10:21:47', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19837, NULL, 'b0d30a32-f813-48de-bc00-cd59de4f339b', 'deposit', 9300.00, '2025-02-18', '10:21:47', NULL, 0.00, 1, 'k abdulla hatu', NULL, NULL, NULL, NULL, '2025-02-18 10:21:47', '2025-02-18 10:21:47', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19838, NULL, 'b0d30a32-f813-48de-bc00-cd59de4f339b', 'deposit', 0.00, '2025-02-18', '10:21:47', 'Fee collected for deposit', 0.00, 1, 'k abdulla hatu', NULL, NULL, NULL, NULL, '2025-02-18 10:21:47', '2025-02-18 10:21:47', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19839, NULL, '356f4dc8-720e-4629-93d4-386060e642e8', 'deposit', 3713.00, '2025-02-18', '10:23:53', NULL, 8.00, 1, 'shorja-husen abdulstar', NULL, NULL, NULL, NULL, '2025-02-18 10:23:53', '2025-02-18 10:23:53', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19840, NULL, '356f4dc8-720e-4629-93d4-386060e642e8', 'deposit', 3713.00, '2025-02-18', '10:23:53', NULL, 8.00, 1, 'shorja-husen abdulstar', NULL, NULL, NULL, NULL, '2025-02-18 10:23:53', '2025-02-18 10:23:53', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19841, NULL, '356f4dc8-720e-4629-93d4-386060e642e8', 'deposit', 8.00, '2025-02-18', '10:23:53', 'Fee collected for deposit', 0.00, 1, 'shorja-husen abdulstar', NULL, NULL, NULL, NULL, '2025-02-18 10:23:53', '2025-02-18 10:23:53', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19868, NULL, 'a446707d-910a-4986-9dec-2824bda5b4e4', 'withdrawal', 2006000.00, '2025-02-18', '11:58:09', NULL, 6000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-18 11:58:09', '2025-02-18 11:58:09', 232, 4, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19869, NULL, 'a446707d-910a-4986-9dec-2824bda5b4e4', 'withdrawal', 2000000.00, '2025-02-18', '11:58:09', NULL, 6000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-18 11:58:09', '2025-02-18 11:58:09', 4, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19870, NULL, 'a446707d-910a-4986-9dec-2824bda5b4e4', 'withdrawal', 2006000.00, '2025-02-18', '11:58:09', NULL, 6000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-18 11:58:09', '2025-02-18 11:58:09', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19915, NULL, '7c34a101-8b47-4536-8863-463a3d1b0c09', 'withdrawal', 22044000.00, '2025-02-18', '13:26:34', NULL, 44000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-18 13:26:34', '2025-02-18 13:26:34', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19916, NULL, '7c34a101-8b47-4536-8863-463a3d1b0c09', 'withdrawal', 22000000.00, '2025-02-18', '13:26:34', NULL, 44000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-18 13:26:34', '2025-02-18 13:26:34', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19917, NULL, '7c34a101-8b47-4536-8863-463a3d1b0c09', 'withdrawal', 22044000.00, '2025-02-18', '13:26:34', NULL, 44000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-18 13:26:34', '2025-02-18 13:26:34', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19920, NULL, '91be659b-a8b8-4c9b-909e-83f14d378898', 'withdrawal', 200.00, '2025-02-18', '13:31:55', NULL, 0.00, 132, 'karwan xald rasul ', NULL, NULL, NULL, NULL, '2025-02-18 13:31:55', '2025-02-18 13:31:55', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(19921, NULL, '91be659b-a8b8-4c9b-909e-83f14d378898', 'withdrawal', 200.00, '2025-02-18', '13:31:55', NULL, 0.00, 132, 'karwan xald rasul ', NULL, NULL, NULL, NULL, '2025-02-18 13:31:55', '2025-02-18 13:31:55', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19962, NULL, 'b780c366-5838-451e-832b-52fe52d4ca1a', 'deposit', 900.00, '2025-02-18', '15:07:16', NULL, 0.00, 1, 'aram hatu', NULL, NULL, NULL, NULL, '2025-02-18 15:07:16', '2025-02-18 15:07:16', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19963, NULL, 'b780c366-5838-451e-832b-52fe52d4ca1a', 'deposit', 900.00, '2025-02-18', '15:07:16', NULL, 0.00, 1, 'aram hatu', NULL, NULL, NULL, NULL, '2025-02-18 15:07:16', '2025-02-18 15:07:16', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19964, NULL, 'b780c366-5838-451e-832b-52fe52d4ca1a', 'deposit', 0.00, '2025-02-18', '15:07:16', 'Fee collected for deposit', 0.00, 1, 'aram hatu', NULL, NULL, NULL, NULL, '2025-02-18 15:07:16', '2025-02-18 15:07:16', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19965, NULL, 'd685832e-fff9-4809-906b-94b7215c3a37', 'withdrawal', 1000000.00, '2025-02-18', '15:08:20', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-18 15:08:20', '2025-02-18 15:08:20', 78, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19966, NULL, 'd685832e-fff9-4809-906b-94b7215c3a37', 'withdrawal', 1000000.00, '2025-02-18', '15:08:20', NULL, 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-18 15:08:20', '2025-02-18 15:08:20', 2, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19967, NULL, 'd685832e-fff9-4809-906b-94b7215c3a37', 'deposit', 0.00, '2025-02-18', '15:08:20', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-18 15:08:20', '2025-02-18 15:08:20', 23, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19968, NULL, '99d298cc-c5f9-4467-8b69-71682c187e09', 'withdrawal', 2495750.00, '2025-02-18', '15:10:54', NULL, 3750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-18 15:10:54', '2025-02-18 15:10:54', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19969, NULL, '99d298cc-c5f9-4467-8b69-71682c187e09', 'withdrawal', 2492000.00, '2025-02-18', '15:10:54', NULL, 3750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-18 15:10:54', '2025-02-18 15:10:54', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19970, NULL, '99d298cc-c5f9-4467-8b69-71682c187e09', 'withdrawal', 2495750.00, '2025-02-18', '15:10:54', NULL, 3750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-18 15:10:54', '2025-02-18 15:10:54', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19973, NULL, '9c103537-ab9c-4e36-a968-f29f9258eba9', 'deposit', 1250.00, '2025-02-18', '15:11:35', NULL, 1250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 15:11:35', '2025-02-18 15:11:35', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19974, NULL, '9c103537-ab9c-4e36-a968-f29f9258eba9', 'deposit', 1250.00, '2025-02-18', '15:11:35', NULL, 1250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 15:11:35', '2025-02-18 15:11:35', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19975, NULL, '9c103537-ab9c-4e36-a968-f29f9258eba9', 'deposit', 1250.00, '2025-02-18', '15:11:35', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-18 15:11:35', '2025-02-18 15:11:35', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19980, NULL, '52a22bb9-d7c2-464e-ab55-7e1b61acfb79', 'deposit', 3511000.00, '2025-02-18', '15:13:17', NULL, 0.00, 1, 'k muhamad shami', NULL, NULL, NULL, NULL, '2025-02-18 15:13:17', '2025-02-18 15:13:17', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19981, NULL, '52a22bb9-d7c2-464e-ab55-7e1b61acfb79', 'deposit', 3511000.00, '2025-02-18', '15:13:17', NULL, 0.00, 1, 'k muhamad shami', NULL, NULL, NULL, NULL, '2025-02-18 15:13:17', '2025-02-18 15:13:17', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19982, NULL, '52a22bb9-d7c2-464e-ab55-7e1b61acfb79', 'deposit', 0.00, '2025-02-18', '15:13:17', 'Fee collected for deposit', 0.00, 1, 'k muhamad shami', NULL, NULL, NULL, NULL, '2025-02-18 15:13:17', '2025-02-18 15:13:17', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19983, NULL, '907d767a-de49-48cb-a05d-6b706c8cee28', 'deposit', 444.00, '2025-02-18', '15:14:50', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-18 15:14:50', '2025-02-18 15:14:50', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19984, NULL, '907d767a-de49-48cb-a05d-6b706c8cee28', 'deposit', 444.00, '2025-02-18', '15:14:50', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-18 15:14:50', '2025-02-18 15:14:50', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19985, NULL, '907d767a-de49-48cb-a05d-6b706c8cee28', 'deposit', 0.00, '2025-02-18', '15:14:50', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-18 15:14:50', '2025-02-18 15:14:50', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19990, NULL, 'c4a083c5-830d-4f8b-93a1-4b4bb8eccb0c', 'deposit', 198.00, '2025-02-18', '15:15:28', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-18 15:15:28', '2025-02-18 15:15:28', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19991, NULL, 'c4a083c5-830d-4f8b-93a1-4b4bb8eccb0c', 'deposit', 198.00, '2025-02-18', '15:15:28', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-18 15:15:28', '2025-02-18 15:15:28', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(19992, NULL, 'c4a083c5-830d-4f8b-93a1-4b4bb8eccb0c', 'deposit', 0.00, '2025-02-18', '15:15:28', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-18 15:15:28', '2025-02-18 15:15:28', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20017, NULL, '7c47e45a-2d1f-4f57-8b57-89060ecd8b93', 'deposit', 5000.00, '2025-02-18', '16:15:24', NULL, 0.00, 132, 'Ahmed pstewan xurshed', NULL, NULL, NULL, NULL, '2025-02-18 16:15:24', '2025-02-18 16:15:24', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20018, NULL, '7c47e45a-2d1f-4f57-8b57-89060ecd8b93', 'deposit', 5000.00, '2025-02-18', '16:15:24', NULL, 0.00, 132, 'Ahmed pstewan xurshed', NULL, NULL, NULL, NULL, '2025-02-18 16:15:24', '2025-02-18 16:15:24', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20021, NULL, 'e14d1863-bc29-4885-bb98-ff3b26546f24', 'deposit', 2400.00, '2025-02-18', '16:20:44', NULL, 0.00, 1, 'bawar abdulxalq talaat', NULL, NULL, NULL, NULL, '2025-02-18 16:20:44', '2025-02-18 16:20:44', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20022, NULL, 'e14d1863-bc29-4885-bb98-ff3b26546f24', 'deposit', 2400.00, '2025-02-18', '16:20:44', NULL, 0.00, 1, 'bawar abdulxalq talaat', NULL, NULL, NULL, NULL, '2025-02-18 16:20:44', '2025-02-18 16:20:44', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20023, NULL, 'e14d1863-bc29-4885-bb98-ff3b26546f24', 'deposit', 0.00, '2025-02-18', '16:20:44', 'Fee collected for deposit', 0.00, 1, 'bawar abdulxalq talaat', NULL, NULL, NULL, NULL, '2025-02-18 16:20:44', '2025-02-18 16:20:44', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20024, NULL, '007d1b21-d048-4368-9ba3-6dfbceaa5ba2', 'deposit', 50500.00, '2025-02-18', '16:21:16', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-18 16:21:16', '2025-02-18 16:21:16', 168, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20025, NULL, '007d1b21-d048-4368-9ba3-6dfbceaa5ba2', 'deposit', 50500.00, '2025-02-18', '16:21:16', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-18 16:21:16', '2025-02-18 16:21:16', 2, 168, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20026, NULL, '007d1b21-d048-4368-9ba3-6dfbceaa5ba2', 'deposit', 0.00, '2025-02-18', '16:21:16', 'Fee collected for deposit', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-18 16:21:17', '2025-02-18 16:21:17', 23, 168, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20027, NULL, '144d2b50-84cd-4b89-9dd1-49b73cf34c5c', 'withdrawal', 34.00, '2025-02-18', '16:21:42', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-18 16:21:42', '2025-02-18 16:21:42', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20028, NULL, '144d2b50-84cd-4b89-9dd1-49b73cf34c5c', 'withdrawal', 34.00, '2025-02-18', '16:21:42', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-18 16:21:42', '2025-02-18 16:21:42', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20029, NULL, '144d2b50-84cd-4b89-9dd1-49b73cf34c5c', 'deposit', 0.00, '2025-02-18', '16:21:42', 'Fee collected for withdrawal', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-18 16:21:42', '2025-02-18 16:21:42', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20076, NULL, 'a9c06229-ece9-4e6a-96ef-7c5d35c3c64b', 'deposit', 7400.00, '2025-02-18', '17:48:55', NULL, 0.00, 132, 'Mustafa', NULL, NULL, NULL, NULL, '2025-02-18 17:48:55', '2025-02-18 17:48:55', 254, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20077, NULL, 'a9c06229-ece9-4e6a-96ef-7c5d35c3c64b', 'deposit', 7400.00, '2025-02-18', '17:48:55', NULL, 0.00, 132, 'Mustafa', NULL, NULL, NULL, NULL, '2025-02-18 17:48:55', '2025-02-18 17:48:55', 1, 254, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20094, NULL, '438c3c2b-ecd5-4a69-a264-0d31777c3312', 'deposit', 5700.00, '2025-02-18', '17:59:16', NULL, 0.00, 132, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-18 17:59:16', '2025-02-18 17:59:16', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20095, NULL, '438c3c2b-ecd5-4a69-a264-0d31777c3312', 'deposit', 5700.00, '2025-02-18', '17:59:16', NULL, 0.00, 132, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-18 17:59:16', '2025-02-18 17:59:16', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20192, NULL, 'ce143dfe-76f0-4fc8-9b2e-598180e7a482', 'deposit', 130.00, '2025-02-18', '20:08:14', NULL, 0.00, 144, 'Azad akrey', NULL, NULL, NULL, NULL, '2025-02-18 20:08:14', '2025-02-18 20:08:14', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20193, NULL, 'ce143dfe-76f0-4fc8-9b2e-598180e7a482', 'deposit', 130.00, '2025-02-18', '20:08:14', NULL, 0.00, 144, 'Azad akrey', NULL, NULL, NULL, NULL, '2025-02-18 20:08:14', '2025-02-18 20:08:14', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20238, NULL, '0dbaa1f8-508d-40d1-b407-bfadf8fcc149', 'deposit', 11000.00, '2025-02-19', '09:19:14', NULL, 11000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-19 09:19:14', '2025-02-19 09:19:14', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20239, NULL, '0dbaa1f8-508d-40d1-b407-bfadf8fcc149', 'deposit', 11000.00, '2025-02-19', '09:19:14', NULL, 11000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-19 09:19:14', '2025-02-19 09:19:14', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20240, NULL, '0dbaa1f8-508d-40d1-b407-bfadf8fcc149', 'deposit', 11000.00, '2025-02-19', '09:19:14', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-19 09:19:14', '2025-02-19 09:19:14', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20241, NULL, '8471d208-1938-410e-9074-b4019baabfef', 'withdrawal', 227000.00, '2025-02-19', '09:22:41', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 09:22:41', '2025-02-19 09:22:41', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20242, NULL, '8471d208-1938-410e-9074-b4019baabfef', 'withdrawal', 226000.00, '2025-02-19', '09:22:41', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 09:22:41', '2025-02-19 09:22:41', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20243, NULL, '8471d208-1938-410e-9074-b4019baabfef', 'withdrawal', 227000.00, '2025-02-19', '09:22:41', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 09:22:41', '2025-02-19 09:22:41', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20244, NULL, '94f48bf1-bd47-444a-b25c-a4d95b10c300', 'deposit', 25000000.00, '2025-02-19', '09:25:55', NULL, 0.00, 1, 'sarf ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-19 09:25:55', '2025-02-19 09:25:55', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20245, NULL, '94f48bf1-bd47-444a-b25c-a4d95b10c300', 'deposit', 25000000.00, '2025-02-19', '09:25:55', NULL, 0.00, 1, 'sarf ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-19 09:25:55', '2025-02-19 09:25:55', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20246, NULL, '94f48bf1-bd47-444a-b25c-a4d95b10c300', 'deposit', 0.00, '2025-02-19', '09:25:55', 'Fee collected for deposit', 0.00, 1, 'sarf ibrahem dukan', NULL, NULL, NULL, NULL, '2025-02-19 09:25:55', '2025-02-19 09:25:55', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20308, NULL, '997a60b0-ce85-4f0e-8dfa-4992dcee7c72', 'deposit', 34000000.00, '2025-02-19', '11:21:21', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-19 11:21:21', '2025-02-19 11:21:21', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20309, NULL, '997a60b0-ce85-4f0e-8dfa-4992dcee7c72', 'deposit', 34000000.00, '2025-02-19', '11:21:21', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-19 11:21:21', '2025-02-19 11:21:21', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20310, NULL, '997a60b0-ce85-4f0e-8dfa-4992dcee7c72', 'deposit', 0.00, '2025-02-19', '11:21:21', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-19 11:21:21', '2025-02-19 11:21:21', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20325, NULL, '39c8a703-d1ba-4cba-911d-ac14ad22e14d', 'deposit', 10000.00, '2025-02-19', '12:08:30', NULL, 0.00, 132, 'Sardar salh abdulla ', NULL, NULL, NULL, NULL, '2025-02-19 12:08:30', '2025-02-19 12:08:30', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20326, NULL, '39c8a703-d1ba-4cba-911d-ac14ad22e14d', 'deposit', 10000.00, '2025-02-19', '12:08:30', NULL, 0.00, 132, 'Sardar salh abdulla ', NULL, NULL, NULL, NULL, '2025-02-19 12:08:30', '2025-02-19 12:08:30', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20327, NULL, 'd974aef0-f713-4b95-9a4f-06af8786a6a1', 'deposit', 300.00, '2025-02-19', '12:15:20', NULL, 0.00, 132, 'Hewr salih saeed', NULL, NULL, NULL, NULL, '2025-02-19 12:15:20', '2025-02-19 12:15:20', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20328, NULL, 'd974aef0-f713-4b95-9a4f-06af8786a6a1', 'deposit', 300.00, '2025-02-19', '12:15:20', NULL, 0.00, 132, 'Hewr salih saeed', NULL, NULL, NULL, NULL, '2025-02-19 12:15:20', '2025-02-19 12:15:20', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20379, NULL, '067e473a-720e-4315-9736-dfa2c093a75c', 'withdrawal', 2428500.00, '2025-02-19', '13:46:54', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 13:46:54', '2025-02-19 13:46:54', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20380, NULL, '067e473a-720e-4315-9736-dfa2c093a75c', 'withdrawal', 2425000.00, '2025-02-19', '13:46:54', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 13:46:54', '2025-02-19 13:46:54', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20381, NULL, '067e473a-720e-4315-9736-dfa2c093a75c', 'withdrawal', 2428500.00, '2025-02-19', '13:46:54', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 13:46:54', '2025-02-19 13:46:54', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20382, NULL, 'd5192ef5-7379-4639-aa2e-cea97cd7b7eb', 'withdrawal', 150000.00, '2025-02-19', '13:50:22', '100$', 0.00, 1, 'huda xan sarf', NULL, NULL, NULL, NULL, '2025-02-19 13:50:22', '2025-02-19 13:50:22', 222, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20383, NULL, 'd5192ef5-7379-4639-aa2e-cea97cd7b7eb', 'withdrawal', 150000.00, '2025-02-19', '13:50:22', '100$', 0.00, 1, 'huda xan sarf', NULL, NULL, NULL, NULL, '2025-02-19 13:50:22', '2025-02-19 13:50:22', 2, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20384, NULL, 'd5192ef5-7379-4639-aa2e-cea97cd7b7eb', 'deposit', 0.00, '2025-02-19', '13:50:22', 'Fee collected for withdrawal', 0.00, 1, 'huda xan sarf', NULL, NULL, NULL, NULL, '2025-02-19 13:50:22', '2025-02-19 13:50:22', 23, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20385, NULL, '28b3b270-8181-40ac-9d5b-19f79d322f86', 'deposit', 500000.00, '2025-02-19', '13:53:40', NULL, 0.00, 1, 'hatu k shadi', NULL, NULL, NULL, NULL, '2025-02-19 13:53:40', '2025-02-19 13:53:40', 284, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20386, NULL, '28b3b270-8181-40ac-9d5b-19f79d322f86', 'deposit', 500000.00, '2025-02-19', '13:53:40', NULL, 0.00, 1, 'hatu k shadi', NULL, NULL, NULL, NULL, '2025-02-19 13:53:40', '2025-02-19 13:53:40', 2, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20387, NULL, '28b3b270-8181-40ac-9d5b-19f79d322f86', 'deposit', 0.00, '2025-02-19', '13:53:40', 'Fee collected for deposit', 0.00, 1, 'hatu k shadi', NULL, NULL, NULL, NULL, '2025-02-19 13:53:40', '2025-02-19 13:53:40', 23, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20392, NULL, '0ef0d5b1-1c61-45ce-8866-caff163e955e', 'deposit', 8195.00, '2025-02-19', '14:02:24', NULL, 0.00, 1, 'enab3 3qra-muhamad yusf', NULL, NULL, NULL, NULL, '2025-02-19 14:02:24', '2025-02-19 14:02:24', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20393, NULL, '0ef0d5b1-1c61-45ce-8866-caff163e955e', 'deposit', 8195.00, '2025-02-19', '14:02:24', NULL, 0.00, 1, 'enab3 3qra-muhamad yusf', NULL, NULL, NULL, NULL, '2025-02-19 14:02:24', '2025-02-19 14:02:24', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20394, NULL, '0ef0d5b1-1c61-45ce-8866-caff163e955e', 'deposit', 0.00, '2025-02-19', '14:02:24', 'Fee collected for deposit', 0.00, 1, 'enab3 3qra-muhamad yusf', NULL, NULL, NULL, NULL, '2025-02-19 14:02:24', '2025-02-19 14:02:24', 22, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20395, NULL, '43c390a5-4d0b-47a8-ae2f-cdb9082e3c2e', 'withdrawal', 10000.00, '2025-02-19', '14:02:52', NULL, 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:02:52', '2025-02-19 14:02:52', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20396, NULL, '43c390a5-4d0b-47a8-ae2f-cdb9082e3c2e', 'withdrawal', 10000.00, '2025-02-19', '14:02:52', NULL, 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:02:53', '2025-02-19 14:02:53', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20397, NULL, '43c390a5-4d0b-47a8-ae2f-cdb9082e3c2e', 'deposit', 0.00, '2025-02-19', '14:02:52', 'Fee collected for withdrawal', 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:02:53', '2025-02-19 14:02:53', 22, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20404, NULL, '3453e820-df7e-4e59-87e3-b01d272abceb', 'deposit', 593.00, '2025-02-19', '14:06:13', NULL, 8.00, 1, 'turkiye-serdar', NULL, NULL, NULL, NULL, '2025-02-19 14:06:13', '2025-02-19 14:06:13', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20405, NULL, '3453e820-df7e-4e59-87e3-b01d272abceb', 'deposit', 593.00, '2025-02-19', '14:06:13', NULL, 8.00, 1, 'turkiye-serdar', NULL, NULL, NULL, NULL, '2025-02-19 14:06:13', '2025-02-19 14:06:13', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20406, NULL, '3453e820-df7e-4e59-87e3-b01d272abceb', 'deposit', 8.00, '2025-02-19', '14:06:13', 'Fee collected for deposit', 0.00, 1, 'turkiye-serdar', NULL, NULL, NULL, NULL, '2025-02-19 14:06:13', '2025-02-19 14:06:13', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20407, NULL, '1c52e860-73c0-4fe2-aa3a-086601bbe7c4', 'deposit', 18205.00, '2025-02-19', '14:06:53', NULL, 5.00, 1, 'dhuk-nasraden muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:06:53', '2025-02-19 14:06:53', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20408, NULL, '1c52e860-73c0-4fe2-aa3a-086601bbe7c4', 'deposit', 18205.00, '2025-02-19', '14:06:53', NULL, 5.00, 1, 'dhuk-nasraden muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:06:53', '2025-02-19 14:06:53', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20409, NULL, '1c52e860-73c0-4fe2-aa3a-086601bbe7c4', 'deposit', 5.00, '2025-02-19', '14:06:53', 'Fee collected for deposit', 0.00, 1, 'dhuk-nasraden muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:06:53', '2025-02-19 14:06:53', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20410, NULL, '19790ff5-de71-44a0-ae29-fa6d49694c89', 'withdrawal', 8195.00, '2025-02-19', '14:07:38', NULL, 0.00, 1, 'muhamad tusf-enab3 3qra', NULL, NULL, NULL, NULL, '2025-02-19 14:07:38', '2025-02-19 14:07:38', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20411, NULL, '19790ff5-de71-44a0-ae29-fa6d49694c89', 'withdrawal', 8195.00, '2025-02-19', '14:07:38', NULL, 0.00, 1, 'muhamad tusf-enab3 3qra', NULL, NULL, NULL, NULL, '2025-02-19 14:07:38', '2025-02-19 14:07:38', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20412, NULL, '19790ff5-de71-44a0-ae29-fa6d49694c89', 'deposit', 0.00, '2025-02-19', '14:07:38', 'Fee collected for withdrawal', 0.00, 1, 'muhamad tusf-enab3 3qra', NULL, NULL, NULL, NULL, '2025-02-19 14:07:38', '2025-02-19 14:07:38', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20413, NULL, '474d253f-6a8d-4626-a0a4-4b20b974d2aa', 'deposit', 10002.00, '2025-02-19', '14:08:12', NULL, 2.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:08:12', '2025-02-19 14:08:12', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20414, NULL, '474d253f-6a8d-4626-a0a4-4b20b974d2aa', 'deposit', 10002.00, '2025-02-19', '14:08:12', NULL, 2.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:08:12', '2025-02-19 14:08:12', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20415, NULL, '474d253f-6a8d-4626-a0a4-4b20b974d2aa', 'deposit', 2.00, '2025-02-19', '14:08:12', 'Fee collected for deposit', 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:08:12', '2025-02-19 14:08:12', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20416, NULL, 'de38b894-72bb-4a2a-8d91-e55b961bfcb8', 'withdrawal', 2007000.00, '2025-02-19', '14:10:29', NULL, 7000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-19 14:10:29', '2025-02-19 14:10:29', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20417, NULL, 'de38b894-72bb-4a2a-8d91-e55b961bfcb8', 'withdrawal', 2007000.00, '2025-02-19', '14:10:29', NULL, 7000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-19 14:10:29', '2025-02-19 14:10:29', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20418, NULL, 'de38b894-72bb-4a2a-8d91-e55b961bfcb8', 'deposit', 7000.00, '2025-02-19', '14:10:29', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-19 14:10:29', '2025-02-19 14:10:29', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20424, NULL, 'f177b83a-4492-493d-9a50-cd06cc996ed0', 'withdrawal', 20000.00, '2025-02-19', '14:12:44', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 14:12:44', '2025-02-19 14:12:44', 237, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20425, NULL, 'f177b83a-4492-493d-9a50-cd06cc996ed0', 'withdrawal', 20000.00, '2025-02-19', '14:12:44', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 14:12:44', '2025-02-19 14:12:44', 1, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20426, NULL, 'f177b83a-4492-493d-9a50-cd06cc996ed0', 'deposit', 0.00, '2025-02-19', '14:12:44', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 14:12:44', '2025-02-19 14:12:44', 22, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20433, NULL, 'a9d6af47-847c-4c1a-a307-cc75b7cbc749', 'deposit', 18000.00, '2025-02-19', '14:18:36', NULL, 0.00, 1, 'k dlovan', NULL, NULL, NULL, NULL, '2025-02-19 14:18:36', '2025-02-19 14:18:36', 197, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20434, NULL, 'a9d6af47-847c-4c1a-a307-cc75b7cbc749', 'deposit', 18000.00, '2025-02-19', '14:18:36', NULL, 0.00, 1, 'k dlovan', NULL, NULL, NULL, NULL, '2025-02-19 14:18:36', '2025-02-19 14:18:36', 1, 197, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20435, NULL, 'a9d6af47-847c-4c1a-a307-cc75b7cbc749', 'deposit', 0.00, '2025-02-19', '14:18:36', 'Fee collected for deposit', 0.00, 1, 'k dlovan', NULL, NULL, NULL, NULL, '2025-02-19 14:18:36', '2025-02-19 14:18:36', 22, 197, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20436, NULL, '76e9ea2f-a8c6-4c1e-a303-aed2edc07ce3', 'withdrawal', 18210.00, '2025-02-19', '14:19:12', NULL, 10.00, 1, 'dhuk-nasraden muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:19:12', '2025-02-19 14:19:12', 197, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20437, NULL, '76e9ea2f-a8c6-4c1e-a303-aed2edc07ce3', 'withdrawal', 18210.00, '2025-02-19', '14:19:12', NULL, 10.00, 1, 'dhuk-nasraden muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:19:12', '2025-02-19 14:19:12', 1, 197, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20438, NULL, '76e9ea2f-a8c6-4c1e-a303-aed2edc07ce3', 'deposit', 10.00, '2025-02-19', '14:19:12', 'Fee collected for withdrawal', 0.00, 1, 'dhuk-nasraden muhamad', NULL, NULL, NULL, NULL, '2025-02-19 14:19:12', '2025-02-19 14:19:12', 22, 197, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20439, NULL, 'b6359e73-22eb-4677-a7b4-6e587d31edb4', 'withdrawal', 71000.00, '2025-02-19', '14:22:49', NULL, 1000.00, 1, 'tishknet', NULL, NULL, NULL, NULL, '2025-02-19 14:22:49', '2025-02-19 14:22:49', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20440, NULL, 'b6359e73-22eb-4677-a7b4-6e587d31edb4', 'withdrawal', 71000.00, '2025-02-19', '14:22:49', NULL, 1000.00, 1, 'tishknet', NULL, NULL, NULL, NULL, '2025-02-19 14:22:49', '2025-02-19 14:22:49', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20441, NULL, 'b6359e73-22eb-4677-a7b4-6e587d31edb4', 'deposit', 1000.00, '2025-02-19', '14:22:49', 'Fee collected for withdrawal', 0.00, 1, 'tishknet', NULL, NULL, NULL, NULL, '2025-02-19 14:22:49', '2025-02-19 14:22:49', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20488, NULL, 'c1dd8258-bd1b-4f1f-9c0f-9718fb1fb40b', 'withdrawal', 6910500.00, '2025-02-19', '15:56:26', NULL, 10500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 15:56:26', '2025-02-19 15:56:26', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20489, NULL, 'c1dd8258-bd1b-4f1f-9c0f-9718fb1fb40b', 'withdrawal', 6900000.00, '2025-02-19', '15:56:26', NULL, 10500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 15:56:26', '2025-02-19 15:56:26', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20490, NULL, 'c1dd8258-bd1b-4f1f-9c0f-9718fb1fb40b', 'withdrawal', 6910500.00, '2025-02-19', '15:56:26', NULL, 10500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-19 15:56:26', '2025-02-19 15:56:26', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(20491, NULL, '4dd49bb1-2513-4b90-80be-05f424a958b4', 'deposit', 50.00, '2025-02-19', '15:58:41', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 15:58:41', '2025-02-19 15:58:41', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20492, NULL, '4dd49bb1-2513-4b90-80be-05f424a958b4', 'deposit', 50.00, '2025-02-19', '15:58:41', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 15:58:41', '2025-02-19 15:58:41', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20493, NULL, '4dd49bb1-2513-4b90-80be-05f424a958b4', 'deposit', 0.00, '2025-02-19', '15:58:41', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 15:58:41', '2025-02-19 15:58:41', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20494, NULL, 'ac310ecf-e59b-41aa-99b9-938ddd618a2e', 'deposit', 105.00, '2025-02-19', '15:59:54', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 15:59:54', '2025-02-19 15:59:54', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20495, NULL, 'ac310ecf-e59b-41aa-99b9-938ddd618a2e', 'deposit', 105.00, '2025-02-19', '15:59:54', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 15:59:54', '2025-02-19 15:59:54', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20496, NULL, 'ac310ecf-e59b-41aa-99b9-938ddd618a2e', 'deposit', 0.00, '2025-02-19', '15:59:54', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-19 15:59:54', '2025-02-19 15:59:54', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20525, NULL, '1ff7235c-8690-4417-a33b-83b187701682', 'withdrawal', 2000000.00, '2025-02-19', '16:41:57', '', 0.00, 136, 'Farhang sarbaz othman ', NULL, NULL, NULL, NULL, '2025-02-19 16:41:57', '2025-02-19 16:41:57', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20526, NULL, '1ff7235c-8690-4417-a33b-83b187701682', 'withdrawal', 2000000.00, '2025-02-19', '16:41:57', '', 0.00, 136, 'Farhang sarbaz othman ', NULL, NULL, NULL, NULL, '2025-02-19 16:41:57', '2025-02-19 16:41:57', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20665, NULL, '4308a2c9-c1b1-4277-9ab9-69a30e7f7925', 'withdrawal', 8100.00, '2025-02-19', '19:18:56', NULL, 0.00, 137, 'Idris   ahyada', NULL, NULL, NULL, NULL, '2025-02-19 19:18:56', '2025-02-19 19:18:56', 254, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20666, NULL, '4308a2c9-c1b1-4277-9ab9-69a30e7f7925', 'withdrawal', 8100.00, '2025-02-19', '19:18:56', NULL, 0.00, 137, 'Idris   ahyada', NULL, NULL, NULL, NULL, '2025-02-19 19:18:56', '2025-02-19 19:18:56', 1, 254, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20697, NULL, '5eaa89c5-9291-4e47-81c2-ef7b88cf918a', 'deposit', 1805.00, '2025-02-19', '20:04:19', NULL, 0.00, 137, 'Hamdamin', NULL, NULL, NULL, NULL, '2025-02-19 20:04:19', '2025-02-19 20:04:19', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20698, NULL, '5eaa89c5-9291-4e47-81c2-ef7b88cf918a', 'deposit', 1805.00, '2025-02-19', '20:04:19', NULL, 0.00, 137, 'Hamdamin', NULL, NULL, NULL, NULL, '2025-02-19 20:04:19', '2025-02-19 20:04:19', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20715, NULL, '7a47c4ee-3a79-4eef-9aac-0cccb3c77616', 'withdrawal', 500.00, '2025-02-19', '20:18:16', NULL, 0.00, 137, 'Mahmod ', NULL, NULL, NULL, NULL, '2025-02-19 20:18:16', '2025-02-19 20:18:16', 191, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20716, NULL, '7a47c4ee-3a79-4eef-9aac-0cccb3c77616', 'withdrawal', 500.00, '2025-02-19', '20:18:16', NULL, 0.00, 137, 'Mahmod ', NULL, NULL, NULL, NULL, '2025-02-19 20:18:16', '2025-02-19 20:18:16', 1, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20847, NULL, 'aee1a238-1098-4b90-bdee-3c377a31be46', 'deposit', 2700.00, '2025-02-20', '11:23:58', NULL, 0.00, 132, 'Rawa mahrewan jalal', NULL, NULL, NULL, NULL, '2025-02-20 11:23:58', '2025-02-20 11:23:58', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20848, NULL, 'aee1a238-1098-4b90-bdee-3c377a31be46', 'deposit', 2700.00, '2025-02-20', '11:23:58', NULL, 0.00, 132, 'Rawa mahrewan jalal', NULL, NULL, NULL, NULL, '2025-02-20 11:23:58', '2025-02-20 11:23:58', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20977, NULL, '14536a6c-43e6-44cd-93d1-f3df2776c54e', 'deposit', 5000.00, '2025-02-20', '15:42:24', NULL, 0.00, 136, 'Shko bakr bdulqadr', NULL, NULL, NULL, NULL, '2025-02-20 15:42:24', '2025-02-20 15:42:24', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20978, NULL, '14536a6c-43e6-44cd-93d1-f3df2776c54e', 'deposit', 5000.00, '2025-02-20', '15:42:24', NULL, 0.00, 136, 'Shko bakr bdulqadr', NULL, NULL, NULL, NULL, '2025-02-20 15:42:24', '2025-02-20 15:42:24', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20979, NULL, '2f986b28-1454-4b22-8000-93dd3572aa4d', 'deposit', 50.00, '2025-02-20', '15:45:22', NULL, 0.00, 136, 'Shko bakr bdulqadr', NULL, NULL, NULL, NULL, '2025-02-20 15:45:22', '2025-02-20 15:45:22', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20980, NULL, '2f986b28-1454-4b22-8000-93dd3572aa4d', 'deposit', 50.00, '2025-02-20', '15:45:22', NULL, 0.00, 136, 'Shko bakr bdulqadr', NULL, NULL, NULL, NULL, '2025-02-20 15:45:22', '2025-02-20 15:45:22', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20987, NULL, '128e5f6a-672d-4ba0-a7eb-648aec1f3db5', 'deposit', 310.00, '2025-02-20', '16:02:11', NULL, 0.00, 136, 'Abbas latif abbas', NULL, NULL, NULL, NULL, '2025-02-20 16:02:11', '2025-02-20 16:02:11', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20988, NULL, '128e5f6a-672d-4ba0-a7eb-648aec1f3db5', 'deposit', 310.00, '2025-02-20', '16:02:11', NULL, 0.00, 136, 'Abbas latif abbas', NULL, NULL, NULL, NULL, '2025-02-20 16:02:11', '2025-02-20 16:02:11', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20997, NULL, '21bb06f0-23b7-47b3-b48f-97fda147c1e8', 'deposit', 5300.00, '2025-02-20', '16:29:37', NULL, 0.00, 136, 'Alo ibrahem maiesh', NULL, NULL, NULL, NULL, '2025-02-20 16:29:37', '2025-02-20 16:29:37', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(20998, NULL, '21bb06f0-23b7-47b3-b48f-97fda147c1e8', 'deposit', 5300.00, '2025-02-20', '16:29:37', NULL, 0.00, 136, 'Alo ibrahem maiesh', NULL, NULL, NULL, NULL, '2025-02-20 16:29:37', '2025-02-20 16:29:37', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21029, NULL, 'd253b934-b3e1-4685-b853-1592e9d32973', 'deposit', 15000.00, '2025-02-20', '17:24:07', NULL, 0.00, 132, 'Hatu k muhama', NULL, NULL, NULL, NULL, '2025-02-20 17:24:07', '2025-02-20 17:24:07', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21030, NULL, 'd253b934-b3e1-4685-b853-1592e9d32973', 'deposit', 15000.00, '2025-02-20', '17:24:07', NULL, 0.00, 132, 'Hatu k muhama', NULL, NULL, NULL, NULL, '2025-02-20 17:24:07', '2025-02-20 17:24:07', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21047, NULL, '536d7780-b116-47cd-a3f1-60998a86f872', 'deposit', 10000000.00, '2025-02-20', '19:05:35', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-20 19:05:35', '2025-02-20 19:05:35', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21048, NULL, '536d7780-b116-47cd-a3f1-60998a86f872', 'deposit', 10000000.00, '2025-02-20', '19:05:35', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-20 19:05:35', '2025-02-20 19:05:35', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21049, NULL, '536d7780-b116-47cd-a3f1-60998a86f872', 'deposit', 10000000.00, '2025-02-20', '19:05:35', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-20 19:05:35', '2025-02-20 19:05:35', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21050, NULL, '530889b8-ffc2-4686-8afb-6db540d06fe8', 'withdrawal', 501000.00, '2025-02-20', '19:06:01', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 19:06:01', '2025-02-20 19:06:01', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21051, NULL, '530889b8-ffc2-4686-8afb-6db540d06fe8', 'withdrawal', 500000.00, '2025-02-20', '19:06:01', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 19:06:01', '2025-02-20 19:06:01', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21052, NULL, '530889b8-ffc2-4686-8afb-6db540d06fe8', 'withdrawal', 501000.00, '2025-02-20', '19:06:01', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 19:06:01', '2025-02-20 19:06:01', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21053, NULL, '5dbfdd6a-78f8-4c75-83e1-a66526c6efd0', 'withdrawal', 1001500.00, '2025-02-20', '19:07:16', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 19:07:16', '2025-02-20 19:07:16', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21054, NULL, '5dbfdd6a-78f8-4c75-83e1-a66526c6efd0', 'withdrawal', 1000000.00, '2025-02-20', '19:07:16', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 19:07:16', '2025-02-20 19:07:16', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21055, NULL, '5dbfdd6a-78f8-4c75-83e1-a66526c6efd0', 'withdrawal', 1001500.00, '2025-02-20', '19:07:16', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 19:07:16', '2025-02-20 19:07:16', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21056, NULL, '88837b83-d749-4e45-988d-6f8ee60508e0', 'deposit', 615000.00, '2025-02-20', '19:12:47', NULL, 0.00, 1, 'maktab hasan', NULL, NULL, NULL, NULL, '2025-02-20 19:12:47', '2025-02-20 19:12:47', 238, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21057, NULL, '88837b83-d749-4e45-988d-6f8ee60508e0', 'deposit', 615000.00, '2025-02-20', '19:12:47', NULL, 0.00, 1, 'maktab hasan', NULL, NULL, NULL, NULL, '2025-02-20 19:12:47', '2025-02-20 19:12:47', 2, 238, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21058, NULL, '88837b83-d749-4e45-988d-6f8ee60508e0', 'deposit', 0.00, '2025-02-20', '19:12:47', 'Fee collected for deposit', 0.00, 1, 'maktab hasan', NULL, NULL, NULL, NULL, '2025-02-20 19:12:47', '2025-02-20 19:12:47', 23, 238, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21067, NULL, '6a37e683-3432-45b2-9371-f295951db60b', 'deposit', 220.00, '2025-02-20', '19:47:36', NULL, 0.00, 132, 'sawsan Mustafa rostam ', NULL, NULL, NULL, NULL, '2025-02-20 19:47:36', '2025-02-20 19:47:36', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21068, NULL, '6a37e683-3432-45b2-9371-f295951db60b', 'deposit', 220.00, '2025-02-20', '19:47:36', NULL, 0.00, 132, 'sawsan Mustafa rostam ', NULL, NULL, NULL, NULL, '2025-02-20 19:47:36', '2025-02-20 19:47:36', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21073, NULL, '5203f170-229c-47dc-983c-8a797ac94204', 'withdrawal', 502000.00, '2025-02-20', '19:56:39', NULL, 2000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-20 19:56:39', '2025-02-20 19:56:39', 227, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21074, NULL, '5203f170-229c-47dc-983c-8a797ac94204', 'withdrawal', 502000.00, '2025-02-20', '19:56:39', NULL, 2000.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-20 19:56:39', '2025-02-20 19:56:39', 2, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21075, NULL, '5203f170-229c-47dc-983c-8a797ac94204', 'deposit', 2000.00, '2025-02-20', '19:56:39', 'Fee collected for withdrawal', 0.00, 1, 'qi card', NULL, NULL, NULL, NULL, '2025-02-20 19:56:39', '2025-02-20 19:56:39', 23, 227, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21076, NULL, 'b63858f6-4c5e-4985-aaa1-09d45a219b77', 'deposit', 15000.00, '2025-02-20', '20:00:49', NULL, 0.00, 1, 'hatu karem m.gardi', NULL, NULL, NULL, NULL, '2025-02-20 20:00:49', '2025-02-20 20:00:49', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21077, NULL, 'b63858f6-4c5e-4985-aaa1-09d45a219b77', 'deposit', 15000.00, '2025-02-20', '20:00:49', NULL, 0.00, 1, 'hatu karem m.gardi', NULL, NULL, NULL, NULL, '2025-02-20 20:00:49', '2025-02-20 20:00:49', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21078, NULL, 'b63858f6-4c5e-4985-aaa1-09d45a219b77', 'deposit', 0.00, '2025-02-20', '20:00:49', 'Fee collected for deposit', 0.00, 1, 'hatu karem m.gardi', NULL, NULL, NULL, NULL, '2025-02-20 20:00:49', '2025-02-20 20:00:49', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21079, NULL, '3137eabf-fcc2-44b1-9378-0e2addd37685', 'withdrawal', 15000.00, '2025-02-20', '20:02:23', NULL, 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-20 20:02:23', '2025-02-20 20:02:23', 1048, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21080, NULL, '3137eabf-fcc2-44b1-9378-0e2addd37685', 'withdrawal', 15000.00, '2025-02-20', '20:02:23', NULL, 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-20 20:02:23', '2025-02-20 20:02:23', 1, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21081, NULL, '3137eabf-fcc2-44b1-9378-0e2addd37685', 'deposit', 0.00, '2025-02-20', '20:02:23', 'Fee collected for withdrawal', 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-20 20:02:23', '2025-02-20 20:02:23', 22, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21082, NULL, 'd9bc9f64-3e3e-4bfc-81c2-2bdbf959256c', 'deposit', 1072400.00, '2025-02-20', '20:04:47', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-20 20:04:47', '2025-02-20 20:04:47', 212, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21083, NULL, 'd9bc9f64-3e3e-4bfc-81c2-2bdbf959256c', 'deposit', 1072400.00, '2025-02-20', '20:04:47', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-20 20:04:47', '2025-02-20 20:04:47', 2, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21084, NULL, 'd9bc9f64-3e3e-4bfc-81c2-2bdbf959256c', 'deposit', 0.00, '2025-02-20', '20:04:47', 'Fee collected for deposit', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-20 20:04:47', '2025-02-20 20:04:47', 23, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21085, NULL, 'fd6f7a6d-5f77-4e17-acec-bc38f2784b9d', 'withdrawal', 716.00, '2025-02-20', '20:05:12', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-20 20:05:12', '2025-02-20 20:05:12', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21086, NULL, 'fd6f7a6d-5f77-4e17-acec-bc38f2784b9d', 'withdrawal', 716.00, '2025-02-20', '20:05:12', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-20 20:05:12', '2025-02-20 20:05:12', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21087, NULL, 'fd6f7a6d-5f77-4e17-acec-bc38f2784b9d', 'deposit', 0.00, '2025-02-20', '20:05:12', 'Fee collected for withdrawal', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-20 20:05:12', '2025-02-20 20:05:12', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21088, NULL, 'd852545b-8b0c-405d-88cc-856b384e4974', 'withdrawal', 14284.00, '2025-02-20', '20:06:55', NULL, 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-20 20:06:55', '2025-02-20 20:06:55', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21089, NULL, 'd852545b-8b0c-405d-88cc-856b384e4974', 'withdrawal', 14284.00, '2025-02-20', '20:06:55', NULL, 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-20 20:06:56', '2025-02-20 20:06:56', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21090, NULL, 'd852545b-8b0c-405d-88cc-856b384e4974', 'deposit', 0.00, '2025-02-20', '20:06:55', 'Fee collected for withdrawal', 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-20 20:06:56', '2025-02-20 20:06:56', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21091, NULL, '8f7d137c-0bae-4ec3-99e7-2c44c373b38e', 'deposit', 14284.00, '2025-02-20', '20:08:34', NULL, 0.00, 1, 'hatu hsab ahmed baper', NULL, NULL, NULL, NULL, '2025-02-20 20:08:34', '2025-02-20 20:08:34', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21092, NULL, '8f7d137c-0bae-4ec3-99e7-2c44c373b38e', 'deposit', 14284.00, '2025-02-20', '20:08:34', NULL, 0.00, 1, 'hatu hsab ahmed baper', NULL, NULL, NULL, NULL, '2025-02-20 20:08:34', '2025-02-20 20:08:34', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21093, NULL, '8f7d137c-0bae-4ec3-99e7-2c44c373b38e', 'deposit', 0.00, '2025-02-20', '20:08:34', 'Fee collected for deposit', 0.00, 1, 'hatu hsab ahmed baper', NULL, NULL, NULL, NULL, '2025-02-20 20:08:34', '2025-02-20 20:08:34', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21094, NULL, 'c22e56ad-50aa-4439-9676-d9f5026db3d2', 'deposit', 27500000.00, '2025-02-20', '20:11:05', NULL, 0.00, 1, 'hatu k hesham', NULL, NULL, NULL, NULL, '2025-02-20 20:11:05', '2025-02-20 20:11:05', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21095, NULL, 'c22e56ad-50aa-4439-9676-d9f5026db3d2', 'deposit', 27500000.00, '2025-02-20', '20:11:05', NULL, 0.00, 1, 'hatu k hesham', NULL, NULL, NULL, NULL, '2025-02-20 20:11:05', '2025-02-20 20:11:05', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21096, NULL, 'c22e56ad-50aa-4439-9676-d9f5026db3d2', 'deposit', 0.00, '2025-02-20', '20:11:05', 'Fee collected for deposit', 0.00, 1, 'hatu k hesham', NULL, NULL, NULL, NULL, '2025-02-20 20:11:05', '2025-02-20 20:11:05', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21101, NULL, '1e54f43b-99da-4567-8853-537ba678f171', 'withdrawal', 20250.00, '2025-02-20', '20:16:19', NULL, 250.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-20 20:16:19', '2025-02-20 20:16:19', 181, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21102, NULL, '1e54f43b-99da-4567-8853-537ba678f171', 'withdrawal', 20250.00, '2025-02-20', '20:16:19', NULL, 250.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-20 20:16:19', '2025-02-20 20:16:19', 2, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21103, NULL, '1e54f43b-99da-4567-8853-537ba678f171', 'deposit', 250.00, '2025-02-20', '20:16:19', 'Fee collected for withdrawal', 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-20 20:16:19', '2025-02-20 20:16:19', 23, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21104, NULL, '754046b7-7fbf-4b6c-a4a7-1bf28c5bad58', 'withdrawal', 150000.00, '2025-02-20', '20:16:49', NULL, 0.00, 1, 'sarf k muhamad', NULL, NULL, NULL, NULL, '2025-02-20 20:16:49', '2025-02-20 20:16:49', 181, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21105, NULL, '754046b7-7fbf-4b6c-a4a7-1bf28c5bad58', 'withdrawal', 150000.00, '2025-02-20', '20:16:49', NULL, 0.00, 1, 'sarf k muhamad', NULL, NULL, NULL, NULL, '2025-02-20 20:16:49', '2025-02-20 20:16:49', 2, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21106, NULL, '754046b7-7fbf-4b6c-a4a7-1bf28c5bad58', 'deposit', 0.00, '2025-02-20', '20:16:49', 'Fee collected for withdrawal', 0.00, 1, 'sarf k muhamad', NULL, NULL, NULL, NULL, '2025-02-20 20:16:49', '2025-02-20 20:16:49', 23, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21113, NULL, '2a614935-42ce-49db-b4a9-1bf6b1c2459c', 'withdrawal', 17087000.00, '2025-02-20', '20:28:09', NULL, 87000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 20:28:09', '2025-02-20 20:28:09', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21114, NULL, '2a614935-42ce-49db-b4a9-1bf6b1c2459c', 'withdrawal', 17087000.00, '2025-02-20', '20:28:09', NULL, 87000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 20:28:09', '2025-02-20 20:28:09', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21115, NULL, '2a614935-42ce-49db-b4a9-1bf6b1c2459c', 'deposit', 87000.00, '2025-02-20', '20:28:09', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 20:28:09', '2025-02-20 20:28:09', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21116, NULL, 'f3327731-6fbc-4bee-930d-dec8c60f9b1d', 'deposit', 2012000.00, '2025-02-20', '20:31:31', NULL, 12000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 20:31:31', '2025-02-20 20:31:31', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21117, NULL, 'f3327731-6fbc-4bee-930d-dec8c60f9b1d', 'deposit', 2012000.00, '2025-02-20', '20:31:31', NULL, 12000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 20:31:31', '2025-02-20 20:31:31', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21118, NULL, 'f3327731-6fbc-4bee-930d-dec8c60f9b1d', 'deposit', 12000.00, '2025-02-20', '20:31:31', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 20:31:31', '2025-02-20 20:31:31', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21125, NULL, '11b6bb55-fe20-4ee4-802e-f99bce742c9f', 'deposit', 492.00, '2025-02-20', '20:36:44', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:36:44', '2025-02-20 20:36:44', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21126, NULL, '11b6bb55-fe20-4ee4-802e-f99bce742c9f', 'deposit', 492.00, '2025-02-20', '20:36:44', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:36:44', '2025-02-20 20:36:44', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21127, NULL, '11b6bb55-fe20-4ee4-802e-f99bce742c9f', 'deposit', 0.00, '2025-02-20', '20:36:44', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:36:44', '2025-02-20 20:36:44', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21128, NULL, 'f072d47b-1664-4e05-932a-c97c49e490bf', 'deposit', 787.00, '2025-02-20', '20:37:09', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:37:09', '2025-02-20 20:37:09', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21129, NULL, 'f072d47b-1664-4e05-932a-c97c49e490bf', 'deposit', 787.00, '2025-02-20', '20:37:09', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:37:09', '2025-02-20 20:37:09', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21130, NULL, 'f072d47b-1664-4e05-932a-c97c49e490bf', 'deposit', 0.00, '2025-02-20', '20:37:09', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:37:09', '2025-02-20 20:37:09', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21131, NULL, '5e96137e-f451-4786-bae5-80b73c1cbf84', 'deposit', 32.00, '2025-02-20', '20:37:48', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:37:48', '2025-02-20 20:37:48', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21132, NULL, '5e96137e-f451-4786-bae5-80b73c1cbf84', 'deposit', 32.00, '2025-02-20', '20:37:48', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:37:48', '2025-02-20 20:37:48', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21133, NULL, '5e96137e-f451-4786-bae5-80b73c1cbf84', 'deposit', 0.00, '2025-02-20', '20:37:48', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-20 20:37:48', '2025-02-20 20:37:48', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21134, NULL, '1d5ae23a-fb16-4cb5-8aac-fa32d76db2a1', 'deposit', 4500.00, '2025-02-20', '20:40:29', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-20 20:40:29', '2025-02-20 20:40:29', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21135, NULL, '1d5ae23a-fb16-4cb5-8aac-fa32d76db2a1', 'deposit', 4500.00, '2025-02-20', '20:40:29', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-20 20:40:29', '2025-02-20 20:40:29', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21136, NULL, '1d5ae23a-fb16-4cb5-8aac-fa32d76db2a1', 'deposit', 0.00, '2025-02-20', '20:40:29', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-20 20:40:29', '2025-02-20 20:40:29', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21137, NULL, 'd866998d-c8f2-43c1-b8d7-1a69e2244eab', 'withdrawal', 10500.00, '2025-02-20', '20:50:39', NULL, 500.00, 1, 'zaincash kart-korek kart', NULL, NULL, NULL, NULL, '2025-02-20 20:50:39', '2025-02-20 20:50:39', 199, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21138, NULL, 'd866998d-c8f2-43c1-b8d7-1a69e2244eab', 'withdrawal', 10500.00, '2025-02-20', '20:50:39', NULL, 500.00, 1, 'zaincash kart-korek kart', NULL, NULL, NULL, NULL, '2025-02-20 20:50:39', '2025-02-20 20:50:39', 2, 199, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21139, NULL, 'd866998d-c8f2-43c1-b8d7-1a69e2244eab', 'deposit', 500.00, '2025-02-20', '20:50:39', 'Fee collected for withdrawal', 0.00, 1, 'zaincash kart-korek kart', NULL, NULL, NULL, NULL, '2025-02-20 20:50:39', '2025-02-20 20:50:39', 23, 199, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21140, NULL, '2fe8f344-f17e-4e62-8d78-f91ce80a936d', 'withdrawal', 595.00, '2025-02-20', '21:04:01', NULL, 0.00, 1, 'turkeya', NULL, NULL, NULL, NULL, '2025-02-20 21:04:01', '2025-02-20 21:04:01', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21141, NULL, '2fe8f344-f17e-4e62-8d78-f91ce80a936d', 'withdrawal', 595.00, '2025-02-20', '21:04:01', NULL, 0.00, 1, 'turkeya', NULL, NULL, NULL, NULL, '2025-02-20 21:04:01', '2025-02-20 21:04:01', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21142, NULL, '2fe8f344-f17e-4e62-8d78-f91ce80a936d', 'deposit', 0.00, '2025-02-20', '21:04:01', 'Fee collected for withdrawal', 0.00, 1, 'turkeya', NULL, NULL, NULL, NULL, '2025-02-20 21:04:01', '2025-02-20 21:04:01', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21143, NULL, 'be2f62cc-338f-4830-b6b4-3b55ba2a66ec', 'withdrawal', 9970.00, '2025-02-20', '21:05:37', NULL, -30.00, 1, 'turkeya-tonbul ibrahem', NULL, NULL, NULL, NULL, '2025-02-20 21:05:37', '2025-02-20 21:05:37', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21144, NULL, 'be2f62cc-338f-4830-b6b4-3b55ba2a66ec', 'withdrawal', 9970.00, '2025-02-20', '21:05:37', NULL, -30.00, 1, 'turkeya-tonbul ibrahem', NULL, NULL, NULL, NULL, '2025-02-20 21:05:37', '2025-02-20 21:05:37', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21145, NULL, 'be2f62cc-338f-4830-b6b4-3b55ba2a66ec', 'deposit', -30.00, '2025-02-20', '21:05:37', 'Fee collected for withdrawal', 0.00, 1, 'turkeya-tonbul ibrahem', NULL, NULL, NULL, NULL, '2025-02-20 21:05:37', '2025-02-20 21:05:37', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21146, NULL, '5d45a68f-299f-4232-ae7d-9c715b6881ed', 'withdrawal', 450750.00, '2025-02-20', '21:06:26', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 21:06:26', '2025-02-20 21:06:26', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21147, NULL, '5d45a68f-299f-4232-ae7d-9c715b6881ed', 'withdrawal', 450000.00, '2025-02-20', '21:06:26', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 21:06:26', '2025-02-20 21:06:26', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21148, NULL, '5d45a68f-299f-4232-ae7d-9c715b6881ed', 'withdrawal', 450750.00, '2025-02-20', '21:06:26', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-20 21:06:26', '2025-02-20 21:06:26', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(21149, NULL, '8d5c2904-15f9-4932-bdcd-0d81b1aec978', 'withdrawal', 4925.00, '2025-02-20', '21:07:12', NULL, -75.00, 1, 'chase bank', NULL, NULL, NULL, NULL, '2025-02-20 21:07:12', '2025-02-20 21:07:12', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21150, NULL, '8d5c2904-15f9-4932-bdcd-0d81b1aec978', 'withdrawal', 4925.00, '2025-02-20', '21:07:12', NULL, -75.00, 1, 'chase bank', NULL, NULL, NULL, NULL, '2025-02-20 21:07:12', '2025-02-20 21:07:12', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21151, NULL, '8d5c2904-15f9-4932-bdcd-0d81b1aec978', 'deposit', -75.00, '2025-02-20', '21:07:12', 'Fee collected for withdrawal', 0.00, 1, 'chase bank', NULL, NULL, NULL, NULL, '2025-02-20 21:07:12', '2025-02-20 21:07:12', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21152, NULL, 'f09c5d00-9510-4edc-9613-5809cb96f3cf', 'deposit', 5000000.00, '2025-02-20', '21:07:30', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:07:30', '2025-02-20 21:07:30', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21153, NULL, 'f09c5d00-9510-4edc-9613-5809cb96f3cf', 'deposit', 5000000.00, '2025-02-20', '21:07:30', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:07:30', '2025-02-20 21:07:30', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21154, NULL, 'f09c5d00-9510-4edc-9613-5809cb96f3cf', 'deposit', 0.00, '2025-02-20', '21:07:30', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:07:30', '2025-02-20 21:07:30', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21155, NULL, '84fb6678-ee84-4453-9194-204f927eab11', 'deposit', 17250.00, '2025-02-20', '21:08:35', NULL, 17250.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:08:35', '2025-02-20 21:08:35', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21156, NULL, '84fb6678-ee84-4453-9194-204f927eab11', 'deposit', 17250.00, '2025-02-20', '21:08:35', NULL, 17250.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:08:35', '2025-02-20 21:08:35', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21157, NULL, '84fb6678-ee84-4453-9194-204f927eab11', 'deposit', 17250.00, '2025-02-20', '21:08:35', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:08:35', '2025-02-20 21:08:35', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21158, NULL, '9a7f945f-d57b-4d8b-8755-1382afa7236a', 'deposit', 10030000.00, '2025-02-20', '21:11:25', NULL, 30000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:11:25', '2025-02-20 21:11:25', 171, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21159, NULL, '9a7f945f-d57b-4d8b-8755-1382afa7236a', 'deposit', 10030000.00, '2025-02-20', '21:11:25', NULL, 30000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:11:25', '2025-02-20 21:11:25', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21160, NULL, '9a7f945f-d57b-4d8b-8755-1382afa7236a', 'deposit', 30000.00, '2025-02-20', '21:11:25', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:11:25', '2025-02-20 21:11:25', 23, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21161, NULL, '9610392c-1fb4-443b-bc7c-130956d27681', 'withdrawal', 15000.00, '2025-02-20', '21:14:37', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:14:37', '2025-02-20 21:14:37', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21162, NULL, '9610392c-1fb4-443b-bc7c-130956d27681', 'withdrawal', 15000.00, '2025-02-20', '21:14:37', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:14:37', '2025-02-20 21:14:37', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21163, NULL, '9610392c-1fb4-443b-bc7c-130956d27681', 'deposit', 0.00, '2025-02-20', '21:14:37', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:14:37', '2025-02-20 21:14:37', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21164, NULL, '3c8ad8ce-cf01-48dc-a629-0cd999207e0d', 'withdrawal', 615000.00, '2025-02-20', '21:16:30', NULL, 0.00, 1, 'ali hamza-maktab hasan', NULL, NULL, NULL, NULL, '2025-02-20 21:16:30', '2025-02-20 21:16:30', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21165, NULL, '3c8ad8ce-cf01-48dc-a629-0cd999207e0d', 'withdrawal', 615000.00, '2025-02-20', '21:16:30', NULL, 0.00, 1, 'ali hamza-maktab hasan', NULL, NULL, NULL, NULL, '2025-02-20 21:16:30', '2025-02-20 21:16:30', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21166, NULL, '3c8ad8ce-cf01-48dc-a629-0cd999207e0d', 'deposit', 0.00, '2025-02-20', '21:16:30', 'Fee collected for withdrawal', 0.00, 1, 'ali hamza-maktab hasan', NULL, NULL, NULL, NULL, '2025-02-20 21:16:30', '2025-02-20 21:16:30', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21167, NULL, 'be252c05-3430-4442-b1bc-cd1170c407f9', 'withdrawal', 20000.00, '2025-02-20', '21:16:51', NULL, 0.00, 1, 'k mder', NULL, NULL, NULL, NULL, '2025-02-20 21:16:51', '2025-02-20 21:16:51', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21168, NULL, 'be252c05-3430-4442-b1bc-cd1170c407f9', 'withdrawal', 20000.00, '2025-02-20', '21:16:51', NULL, 0.00, 1, 'k mder', NULL, NULL, NULL, NULL, '2025-02-20 21:16:51', '2025-02-20 21:16:51', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21169, NULL, 'be252c05-3430-4442-b1bc-cd1170c407f9', 'deposit', 0.00, '2025-02-20', '21:16:51', 'Fee collected for withdrawal', 0.00, 1, 'k mder', NULL, NULL, NULL, NULL, '2025-02-20 21:16:51', '2025-02-20 21:16:51', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21170, NULL, '8aec2f25-1335-4375-a6d8-ad565715e1b4', 'deposit', 2006000.00, '2025-02-20', '21:17:25', NULL, 6000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:17:25', '2025-02-20 21:17:25', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21171, NULL, '8aec2f25-1335-4375-a6d8-ad565715e1b4', 'deposit', 2006000.00, '2025-02-20', '21:17:25', NULL, 6000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:17:25', '2025-02-20 21:17:25', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21172, NULL, '8aec2f25-1335-4375-a6d8-ad565715e1b4', 'deposit', 6000.00, '2025-02-20', '21:17:25', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-20 21:17:25', '2025-02-20 21:17:25', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21173, NULL, 'df21e92b-34fb-48e6-8e6d-c941ad5e8b45', 'withdrawal', 1650.00, '2025-02-20', '21:18:01', NULL, 0.00, 1, 'muhamad yusf', NULL, NULL, NULL, NULL, '2025-02-20 21:18:01', '2025-02-20 21:18:01', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21174, NULL, 'df21e92b-34fb-48e6-8e6d-c941ad5e8b45', 'withdrawal', 1650.00, '2025-02-20', '21:18:01', NULL, 0.00, 1, 'muhamad yusf', NULL, NULL, NULL, NULL, '2025-02-20 21:18:01', '2025-02-20 21:18:01', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21175, NULL, 'df21e92b-34fb-48e6-8e6d-c941ad5e8b45', 'deposit', 0.00, '2025-02-20', '21:18:01', 'Fee collected for withdrawal', 0.00, 1, 'muhamad yusf', NULL, NULL, NULL, NULL, '2025-02-20 21:18:01', '2025-02-20 21:18:01', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21176, NULL, '8dc5e4a6-3bae-4b26-b83e-4a475839ddaa', 'deposit', 9276.00, '2025-02-20', '21:18:42', NULL, 90.00, 1, 'swef chine', NULL, NULL, NULL, NULL, '2025-02-20 21:18:42', '2025-02-20 21:18:42', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21177, NULL, '8dc5e4a6-3bae-4b26-b83e-4a475839ddaa', 'deposit', 9276.00, '2025-02-20', '21:18:42', NULL, 90.00, 1, 'swef chine', NULL, NULL, NULL, NULL, '2025-02-20 21:18:42', '2025-02-20 21:18:42', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21178, NULL, '8dc5e4a6-3bae-4b26-b83e-4a475839ddaa', 'deposit', 90.00, '2025-02-20', '21:18:42', 'Fee collected for deposit', 0.00, 1, 'swef chine', NULL, NULL, NULL, NULL, '2025-02-20 21:18:42', '2025-02-20 21:18:42', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21179, NULL, '8d530d18-08e2-4628-a236-73483fef766a', 'deposit', 9965.00, '2025-02-20', '21:19:33', NULL, -35.00, 1, 'turkea-tonbul ibrahem', NULL, NULL, NULL, NULL, '2025-02-20 21:19:33', '2025-02-20 21:19:33', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21180, NULL, '8d530d18-08e2-4628-a236-73483fef766a', 'deposit', 9965.00, '2025-02-20', '21:19:33', NULL, -35.00, 1, 'turkea-tonbul ibrahem', NULL, NULL, NULL, NULL, '2025-02-20 21:19:33', '2025-02-20 21:19:33', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21181, NULL, '8d530d18-08e2-4628-a236-73483fef766a', 'deposit', -35.00, '2025-02-20', '21:19:33', 'Fee collected for deposit', 0.00, 1, 'turkea-tonbul ibrahem', NULL, NULL, NULL, NULL, '2025-02-20 21:19:33', '2025-02-20 21:19:33', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21182, NULL, '2a678295-bafb-49b2-aad0-237c15dbda6f', 'deposit', 4910.00, '2025-02-20', '21:20:27', NULL, -90.00, 1, 'chase bank', NULL, NULL, NULL, NULL, '2025-02-20 21:20:27', '2025-02-20 21:20:27', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21183, NULL, '2a678295-bafb-49b2-aad0-237c15dbda6f', 'deposit', 4910.00, '2025-02-20', '21:20:27', NULL, -90.00, 1, 'chase bank', NULL, NULL, NULL, NULL, '2025-02-20 21:20:27', '2025-02-20 21:20:27', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21184, NULL, '2a678295-bafb-49b2-aad0-237c15dbda6f', 'deposit', -90.00, '2025-02-20', '21:20:27', 'Fee collected for deposit', 0.00, 1, 'chase bank', NULL, NULL, NULL, NULL, '2025-02-20 21:20:27', '2025-02-20 21:20:27', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21185, NULL, '49f479d0-e26f-4220-8ba6-800fd1ebf18e', 'withdrawal', 35700.00, '2025-02-20', '21:21:01', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-20 21:21:01', '2025-02-20 21:21:01', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21186, NULL, '49f479d0-e26f-4220-8ba6-800fd1ebf18e', 'withdrawal', 35700.00, '2025-02-20', '21:21:01', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-20 21:21:01', '2025-02-20 21:21:01', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21187, NULL, '49f479d0-e26f-4220-8ba6-800fd1ebf18e', 'deposit', 0.00, '2025-02-20', '21:21:01', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-20 21:21:01', '2025-02-20 21:21:01', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21234, NULL, 'd77ec2b6-a673-4f70-a49b-1aa3b9b8d1a5', 'deposit', 10000.00, '2025-02-22', '10:32:43', NULL, 0.00, 1, 'Maten jwbrail', NULL, NULL, NULL, NULL, '2025-02-22 10:32:43', '2025-02-22 10:32:43', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21235, NULL, 'd77ec2b6-a673-4f70-a49b-1aa3b9b8d1a5', 'deposit', 10000.00, '2025-02-22', '10:32:43', NULL, 0.00, 1, 'Maten jwbrail', NULL, NULL, NULL, NULL, '2025-02-22 10:32:43', '2025-02-22 10:32:43', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21236, NULL, 'd77ec2b6-a673-4f70-a49b-1aa3b9b8d1a5', 'deposit', 0.00, '2025-02-22', '10:32:43', 'Fee collected for deposit', 0.00, 1, 'Maten jwbrail', NULL, NULL, NULL, NULL, '2025-02-22 10:32:43', '2025-02-22 10:32:43', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21239, NULL, '907f075e-0a03-47fe-87a7-6f706d29f23e', 'withdrawal', 5000000.00, '2025-02-22', '10:33:08', NULL, 0.00, 1, 'Maten jwbrail', NULL, NULL, NULL, NULL, '2025-02-22 10:33:08', '2025-02-22 10:33:08', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21240, NULL, '907f075e-0a03-47fe-87a7-6f706d29f23e', 'withdrawal', 5000000.00, '2025-02-22', '10:33:08', NULL, 0.00, 1, 'Maten jwbrail', NULL, NULL, NULL, NULL, '2025-02-22 10:33:08', '2025-02-22 10:33:08', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21241, NULL, '907f075e-0a03-47fe-87a7-6f706d29f23e', 'deposit', 0.00, '2025-02-22', '10:33:08', 'Fee collected for withdrawal', 0.00, 1, 'Maten jwbrail', NULL, NULL, NULL, NULL, '2025-02-22 10:33:08', '2025-02-22 10:33:08', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21454, NULL, 'fb0fd232-b565-4aaf-b870-5313fc8b2fa8', 'withdrawal', 10000.00, '2025-02-22', '16:06:32', NULL, 0.00, 136, 'Sardar salh abdulla', NULL, NULL, NULL, NULL, '2025-02-22 16:06:32', '2025-02-22 16:06:32', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21455, NULL, 'fb0fd232-b565-4aaf-b870-5313fc8b2fa8', 'withdrawal', 10000.00, '2025-02-22', '16:06:32', NULL, 0.00, 136, 'Sardar salh abdulla', NULL, NULL, NULL, NULL, '2025-02-22 16:06:32', '2025-02-22 16:06:32', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21468, NULL, '99beea6a-eb41-464d-83c7-4ff131f9b810', 'withdrawal', 1218.00, '2025-02-22', '16:35:20', NULL, 18.00, 1, 'qairo-ibrahm abdulhadi', NULL, NULL, NULL, NULL, '2025-02-22 16:35:20', '2025-02-22 16:35:20', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21469, NULL, '99beea6a-eb41-464d-83c7-4ff131f9b810', 'withdrawal', 1218.00, '2025-02-22', '16:35:20', NULL, 18.00, 1, 'qairo-ibrahm abdulhadi', NULL, NULL, NULL, NULL, '2025-02-22 16:35:20', '2025-02-22 16:35:20', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21470, NULL, '99beea6a-eb41-464d-83c7-4ff131f9b810', 'deposit', 18.00, '2025-02-22', '16:35:20', 'Fee collected for withdrawal', 0.00, 1, 'qairo-ibrahm abdulhadi', NULL, NULL, NULL, NULL, '2025-02-22 16:35:20', '2025-02-22 16:35:20', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21471, NULL, '8e13df6e-124f-4465-8024-e9090bfae807', 'withdrawal', 1201750.00, '2025-02-22', '16:36:17', NULL, 1750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 16:36:17', '2025-02-22 16:36:17', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21472, NULL, '8e13df6e-124f-4465-8024-e9090bfae807', 'withdrawal', 1200000.00, '2025-02-22', '16:36:17', NULL, 1750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 16:36:17', '2025-02-22 16:36:17', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21473, NULL, '8e13df6e-124f-4465-8024-e9090bfae807', 'withdrawal', 1201750.00, '2025-02-22', '16:36:17', NULL, 1750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 16:36:17', '2025-02-22 16:36:17', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21474, NULL, '9b311f17-a600-462f-b229-036df1ba7a21', 'deposit', 2008000.00, '2025-02-22', '16:39:12', NULL, 8000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 16:39:12', '2025-02-22 16:39:12', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21475, NULL, '9b311f17-a600-462f-b229-036df1ba7a21', 'deposit', 2008000.00, '2025-02-22', '16:39:12', NULL, 8000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 16:39:12', '2025-02-22 16:39:12', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21476, NULL, '9b311f17-a600-462f-b229-036df1ba7a21', 'deposit', 8000.00, '2025-02-22', '16:39:12', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 16:39:12', '2025-02-22 16:39:12', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21507, NULL, '2de4ad73-9928-4ffe-b9b4-14ddc5a2c1e7', 'deposit', 12559.00, '2025-02-22', '17:10:34', '149600 shkawa', -95.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-22 17:10:34', '2025-02-22 17:10:34', 214, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21508, NULL, '2de4ad73-9928-4ffe-b9b4-14ddc5a2c1e7', 'deposit', 12559.00, '2025-02-22', '17:10:34', '149600 shkawa', -95.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-22 17:10:34', '2025-02-22 17:10:34', 1, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21509, NULL, '2de4ad73-9928-4ffe-b9b4-14ddc5a2c1e7', 'deposit', -95.00, '2025-02-22', '17:10:34', 'Fee collected for deposit', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-22 17:10:34', '2025-02-22 17:10:34', 22, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21510, NULL, '22c2b5f2-b79d-48a2-997c-d4a4535ac31e', 'deposit', 12559.00, '2025-02-22', '17:11:51', 'شکانەوە لەسەر داواکاری خۆی', 1496.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-22 17:11:51', '2025-02-22 17:11:51', 1, 214, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21511, NULL, '22c2b5f2-b79d-48a2-997c-d4a4535ac31e', 'withdrawal', 12559.00, '2025-02-22', '17:11:51', 'شکانەوە لەسەر داواکاری خۆی', 1496.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-22 17:11:51', '2025-02-22 17:11:51', 214, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21512, NULL, '22c2b5f2-b79d-48a2-997c-d4a4535ac31e', 'withdrawal', 18788264.00, '2025-02-22', '17:11:51', 'شکانەوە لەسەر داواکاری خۆی', 1496.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-22 17:11:51', '2025-02-22 17:11:51', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21513, NULL, '22c2b5f2-b79d-48a2-997c-d4a4535ac31e', 'deposit', 18788264.00, '2025-02-22', '17:11:51', 'شکانەوە لەسەر داواکاری خۆی', 1496.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-22 17:11:51', '2025-02-22 17:11:51', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21514, NULL, '2acf0e9a-38a6-4f91-84ac-6f190a4d0f32', 'withdrawal', 2062000.00, '2025-02-22', '17:13:35', NULL, 12000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:13:35', '2025-02-22 17:13:35', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21515, NULL, '2acf0e9a-38a6-4f91-84ac-6f190a4d0f32', 'withdrawal', 2062000.00, '2025-02-22', '17:13:35', NULL, 12000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:13:35', '2025-02-22 17:13:35', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21516, NULL, '2acf0e9a-38a6-4f91-84ac-6f190a4d0f32', 'deposit', 12000.00, '2025-02-22', '17:13:35', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:13:35', '2025-02-22 17:13:35', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21519, NULL, 'af28529c-7214-4037-9331-fd3104c80a79', 'withdrawal', 10000.00, '2025-02-22', '17:22:41', NULL, 0.00, 1, 'korek', NULL, NULL, NULL, NULL, '2025-02-22 17:22:41', '2025-02-22 17:22:41', 82, 73, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21520, NULL, 'af28529c-7214-4037-9331-fd3104c80a79', 'withdrawal', 10000.00, '2025-02-22', '17:22:41', NULL, 0.00, 1, 'korek', NULL, NULL, NULL, NULL, '2025-02-22 17:22:41', '2025-02-22 17:22:41', 73, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21521, NULL, 'af28529c-7214-4037-9331-fd3104c80a79', 'withdrawal', 10000.00, '2025-02-22', '17:22:41', NULL, 0.00, 1, 'korek', NULL, NULL, NULL, NULL, '2025-02-22 17:22:41', '2025-02-22 17:22:41', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21526, NULL, 'e1917951-4ce0-4f63-847b-cf0b27eba7d7', 'deposit', 14971000.00, '2025-02-22', '17:25:29', NULL, 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-22 17:25:29', '2025-02-22 17:25:29', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21527, NULL, 'e1917951-4ce0-4f63-847b-cf0b27eba7d7', 'deposit', 14971000.00, '2025-02-22', '17:25:29', NULL, 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-22 17:25:29', '2025-02-22 17:25:29', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21528, NULL, 'e1917951-4ce0-4f63-847b-cf0b27eba7d7', 'deposit', 0.00, '2025-02-22', '17:25:29', 'Fee collected for deposit', 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-22 17:25:29', '2025-02-22 17:25:29', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21529, NULL, 'f199b57e-55b2-474e-909e-7a4e3aec5232', 'deposit', 6700.00, '2025-02-22', '17:28:09', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 17:28:09', '2025-02-22 17:28:09', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21530, NULL, 'f199b57e-55b2-474e-909e-7a4e3aec5232', 'deposit', 6700.00, '2025-02-22', '17:28:09', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 17:28:09', '2025-02-22 17:28:09', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21531, NULL, 'f199b57e-55b2-474e-909e-7a4e3aec5232', 'deposit', 0.00, '2025-02-22', '17:28:09', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 17:28:09', '2025-02-22 17:28:09', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21532, NULL, '87f1f384-14e6-4bb4-a339-fae6ef499572', 'deposit', 100000.00, '2025-02-22', '17:28:33', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:28:33', '2025-02-22 17:28:33', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21533, NULL, '87f1f384-14e6-4bb4-a339-fae6ef499572', 'deposit', 100000.00, '2025-02-22', '17:28:33', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:28:33', '2025-02-22 17:28:33', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21534, NULL, '87f1f384-14e6-4bb4-a339-fae6ef499572', 'deposit', 0.00, '2025-02-22', '17:28:33', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:28:33', '2025-02-22 17:28:33', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21539, NULL, '765ee88f-8d29-4aa2-80a9-3b5ea14da48a', 'withdrawal', 1001500.00, '2025-02-22', '17:29:25', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 17:29:25', '2025-02-22 17:29:25', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21540, NULL, '765ee88f-8d29-4aa2-80a9-3b5ea14da48a', 'withdrawal', 1000000.00, '2025-02-22', '17:29:25', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 17:29:25', '2025-02-22 17:29:25', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21541, NULL, '765ee88f-8d29-4aa2-80a9-3b5ea14da48a', 'withdrawal', 1001500.00, '2025-02-22', '17:29:25', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 17:29:25', '2025-02-22 17:29:25', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21548, NULL, '93ad9176-5a06-475d-867b-3ec144e3f517', 'deposit', 210.00, '2025-02-22', '17:33:09', NULL, 0.00, 1, 'dlovan', NULL, NULL, NULL, NULL, '2025-02-22 17:33:09', '2025-02-22 17:33:09', 197, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21549, NULL, '93ad9176-5a06-475d-867b-3ec144e3f517', 'deposit', 210.00, '2025-02-22', '17:33:09', NULL, 0.00, 1, 'dlovan', NULL, NULL, NULL, NULL, '2025-02-22 17:33:09', '2025-02-22 17:33:09', 1, 197, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21550, NULL, '93ad9176-5a06-475d-867b-3ec144e3f517', 'deposit', 0.00, '2025-02-22', '17:33:09', 'Fee collected for deposit', 0.00, 1, 'dlovan', NULL, NULL, NULL, NULL, '2025-02-22 17:33:09', '2025-02-22 17:33:09', 22, 197, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21551, NULL, '08a5563b-d3b2-4e05-9d36-49eb096974f3', 'deposit', 2000000.00, '2025-02-22', '17:34:53', NULL, 0.00, 1, 'hatu k aram', NULL, NULL, NULL, NULL, '2025-02-22 17:34:53', '2025-02-22 17:34:53', 179, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21552, NULL, '08a5563b-d3b2-4e05-9d36-49eb096974f3', 'deposit', 2000000.00, '2025-02-22', '17:34:53', NULL, 0.00, 1, 'hatu k aram', NULL, NULL, NULL, NULL, '2025-02-22 17:34:53', '2025-02-22 17:34:53', 2, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21553, NULL, '08a5563b-d3b2-4e05-9d36-49eb096974f3', 'deposit', 0.00, '2025-02-22', '17:34:53', 'Fee collected for deposit', 0.00, 1, 'hatu k aram', NULL, NULL, NULL, NULL, '2025-02-22 17:34:53', '2025-02-22 17:34:53', 23, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21554, NULL, '0ff75ea6-dffa-4679-bb87-a7b4dcb995d9', 'withdrawal', 18000.00, '2025-02-22', '17:36:15', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-22 17:36:15', '2025-02-22 17:36:15', 85, 71, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21555, NULL, '0ff75ea6-dffa-4679-bb87-a7b4dcb995d9', 'withdrawal', 18000.00, '2025-02-22', '17:36:15', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-22 17:36:15', '2025-02-22 17:36:15', 71, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21556, NULL, '0ff75ea6-dffa-4679-bb87-a7b4dcb995d9', 'withdrawal', 18000.00, '2025-02-22', '17:36:15', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-22 17:36:15', '2025-02-22 17:36:15', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21561, NULL, '8a8bdaa0-509f-4470-853e-b085a54d6510', 'withdrawal', 300251.00, '2025-02-22', '17:39:16', NULL, 251.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:39:16', '2025-02-22 17:39:16', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21562, NULL, '8a8bdaa0-509f-4470-853e-b085a54d6510', 'withdrawal', 300251.00, '2025-02-22', '17:39:16', NULL, 251.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:39:16', '2025-02-22 17:39:16', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21563, NULL, '8a8bdaa0-509f-4470-853e-b085a54d6510', 'deposit', 251.00, '2025-02-22', '17:39:16', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-22 17:39:16', '2025-02-22 17:39:16', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21564, NULL, '15511078-8026-4f2d-9923-3c039463169b', 'withdrawal', 5904000.00, '2025-02-22', '17:40:43', NULL, 9000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 17:40:43', '2025-02-22 17:40:43', 216, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21565, NULL, '15511078-8026-4f2d-9923-3c039463169b', 'withdrawal', 5895000.00, '2025-02-22', '17:40:43', NULL, 9000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 17:40:43', '2025-02-22 17:40:43', 18, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21566, NULL, '15511078-8026-4f2d-9923-3c039463169b', 'withdrawal', 5904000.00, '2025-02-22', '17:40:43', NULL, 9000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 17:40:43', '2025-02-22 17:40:43', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21575, NULL, 'ee9d1290-8919-4281-97c3-175fba506121', 'deposit', 850000.00, '2025-02-22', '17:44:52', NULL, 0.00, 1, 'hatu k zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:44:52', '2025-02-22 17:44:52', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21576, NULL, 'ee9d1290-8919-4281-97c3-175fba506121', 'deposit', 850000.00, '2025-02-22', '17:44:52', NULL, 0.00, 1, 'hatu k zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:44:52', '2025-02-22 17:44:52', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21577, NULL, 'ee9d1290-8919-4281-97c3-175fba506121', 'deposit', 0.00, '2025-02-22', '17:44:52', 'Fee collected for deposit', 0.00, 1, 'hatu k zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:44:52', '2025-02-22 17:44:52', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21584, NULL, '5f540110-e948-4f24-ab74-ad0c1af44eb9', 'deposit', 736.00, '2025-02-22', '17:46:59', NULL, 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:46:59', '2025-02-22 17:46:59', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(21585, NULL, '5f540110-e948-4f24-ab74-ad0c1af44eb9', 'deposit', 736.00, '2025-02-22', '17:46:59', NULL, 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:46:59', '2025-02-22 17:46:59', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21586, NULL, '5f540110-e948-4f24-ab74-ad0c1af44eb9', 'deposit', 0.00, '2025-02-22', '17:46:59', 'Fee collected for deposit', 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:46:59', '2025-02-22 17:46:59', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21587, NULL, '32d9cd49-ea03-4fca-bc98-263192e6f052', 'withdrawal', 1583000.00, '2025-02-22', '17:48:59', NULL, 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:48:59', '2025-02-22 17:48:59', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21588, NULL, '32d9cd49-ea03-4fca-bc98-263192e6f052', 'withdrawal', 1583000.00, '2025-02-22', '17:48:59', NULL, 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:48:59', '2025-02-22 17:48:59', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21589, NULL, '32d9cd49-ea03-4fca-bc98-263192e6f052', 'deposit', 0.00, '2025-02-22', '17:48:59', 'Fee collected for withdrawal', 0.00, 1, 'zardasht', NULL, NULL, NULL, NULL, '2025-02-22 17:48:59', '2025-02-22 17:48:59', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21626, NULL, 'b34838c2-2928-43fc-9116-e0bb5381b664', 'deposit', 2500.00, '2025-02-22', '18:38:18', NULL, 0.00, 132, 'Mahmood azad haje kakol', NULL, NULL, NULL, NULL, '2025-02-22 18:38:18', '2025-02-22 18:38:18', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21627, NULL, 'b34838c2-2928-43fc-9116-e0bb5381b664', 'deposit', 2500.00, '2025-02-22', '18:38:18', NULL, 0.00, 132, 'Mahmood azad haje kakol', NULL, NULL, NULL, NULL, '2025-02-22 18:38:18', '2025-02-22 18:38:18', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21696, NULL, '279305ee-da1c-4c1d-b30c-105e83b850c3', 'withdrawal', 2.00, '2025-02-22', '20:08:04', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-22 20:08:04', '2025-02-22 20:08:04', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21697, NULL, '279305ee-da1c-4c1d-b30c-105e83b850c3', 'withdrawal', 2.00, '2025-02-22', '20:08:04', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-22 20:08:04', '2025-02-22 20:08:04', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21698, NULL, '279305ee-da1c-4c1d-b30c-105e83b850c3', 'deposit', 2.00, '2025-02-22', '20:08:04', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-22 20:08:04', '2025-02-22 20:08:04', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21699, NULL, '4e4afa01-331d-466b-b42e-447ff720b505', 'withdrawal', 52130000.00, '2025-02-22', '20:19:46', NULL, 130000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:19:46', '2025-02-22 20:19:46', 292, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21700, NULL, '4e4afa01-331d-466b-b42e-447ff720b505', 'withdrawal', 52000000.00, '2025-02-22', '20:19:46', NULL, 130000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:19:46', '2025-02-22 20:19:46', 18, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21701, NULL, '4e4afa01-331d-466b-b42e-447ff720b505', 'withdrawal', 52130000.00, '2025-02-22', '20:19:46', NULL, 130000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:19:46', '2025-02-22 20:19:46', 2, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21702, NULL, '18c2e053-5f86-4944-a553-801359373a0e', 'deposit', 50000000.00, '2025-02-22', '20:20:09', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:20:09', '2025-02-22 20:20:09', 292, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21703, NULL, '18c2e053-5f86-4944-a553-801359373a0e', 'deposit', 50000000.00, '2025-02-22', '20:20:09', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:20:09', '2025-02-22 20:20:09', 2, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21704, NULL, '18c2e053-5f86-4944-a553-801359373a0e', 'deposit', 0.00, '2025-02-22', '20:20:09', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:20:09', '2025-02-22 20:20:09', 23, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21705, NULL, '2b001780-9967-45cc-a27b-be9ab05c981c', 'deposit', 40000.00, '2025-02-22', '20:20:30', NULL, 0.00, 1, 'shadda zyad', NULL, NULL, NULL, NULL, '2025-02-22 20:20:30', '2025-02-22 20:20:30', 292, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21706, NULL, '2b001780-9967-45cc-a27b-be9ab05c981c', 'deposit', 40000.00, '2025-02-22', '20:20:30', NULL, 0.00, 1, 'shadda zyad', NULL, NULL, NULL, NULL, '2025-02-22 20:20:30', '2025-02-22 20:20:30', 2, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21707, NULL, '2b001780-9967-45cc-a27b-be9ab05c981c', 'deposit', 0.00, '2025-02-22', '20:20:30', 'Fee collected for deposit', 0.00, 1, 'shadda zyad', NULL, NULL, NULL, NULL, '2025-02-22 20:20:30', '2025-02-22 20:20:30', 23, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21708, NULL, '201368d2-8173-469a-9aa5-158488c68d47', 'withdrawal', 1577500.00, '2025-02-22', '20:25:45', NULL, 2500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:25:45', '2025-02-22 20:25:45', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21709, NULL, '201368d2-8173-469a-9aa5-158488c68d47', 'withdrawal', 1575000.00, '2025-02-22', '20:25:45', NULL, 2500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:25:45', '2025-02-22 20:25:45', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21710, NULL, '201368d2-8173-469a-9aa5-158488c68d47', 'withdrawal', 1577500.00, '2025-02-22', '20:25:45', NULL, 2500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:25:45', '2025-02-22 20:25:45', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21714, NULL, '4601fdd3-63b7-4eb5-8fa3-a9be3f7ffb86', 'withdrawal', 12562.00, '2025-02-22', '20:31:15', NULL, -92.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-22 20:31:15', '2025-02-22 20:31:15', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21715, NULL, '4601fdd3-63b7-4eb5-8fa3-a9be3f7ffb86', 'withdrawal', 12562.00, '2025-02-22', '20:31:15', NULL, -92.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-22 20:31:15', '2025-02-22 20:31:15', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21716, NULL, '4601fdd3-63b7-4eb5-8fa3-a9be3f7ffb86', 'deposit', -92.00, '2025-02-22', '20:31:15', 'Fee collected for withdrawal', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-22 20:31:15', '2025-02-22 20:31:15', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21719, NULL, 'a382e03f-3b60-44e4-8156-10f53b6b51e8', 'deposit', 1210.00, '2025-02-22', '20:32:48', NULL, 10.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-22 20:32:48', '2025-02-22 20:32:48', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21720, NULL, 'a382e03f-3b60-44e4-8156-10f53b6b51e8', 'deposit', 1210.00, '2025-02-22', '20:32:48', NULL, 10.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-22 20:32:48', '2025-02-22 20:32:48', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21721, NULL, 'a382e03f-3b60-44e4-8156-10f53b6b51e8', 'deposit', 10.00, '2025-02-22', '20:32:48', 'Fee collected for deposit', 0.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-22 20:32:48', '2025-02-22 20:32:48', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21722, NULL, '77abb620-672f-4af1-bd6d-81946ee92433', 'withdrawal', 14971000.00, '2025-02-22', '20:33:22', NULL, 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-22 20:33:22', '2025-02-22 20:33:22', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21723, NULL, '77abb620-672f-4af1-bd6d-81946ee92433', 'withdrawal', 14971000.00, '2025-02-22', '20:33:22', NULL, 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-22 20:33:22', '2025-02-22 20:33:22', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21724, NULL, '77abb620-672f-4af1-bd6d-81946ee92433', 'deposit', 0.00, '2025-02-22', '20:33:22', 'Fee collected for withdrawal', 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-22 20:33:22', '2025-02-22 20:33:22', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21729, NULL, 'ee853e4a-6d80-4954-ac7b-84a20e687230', 'withdrawal', 40000000.00, '2025-02-22', '20:34:06', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:34:06', '2025-02-22 20:34:06', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21730, NULL, 'ee853e4a-6d80-4954-ac7b-84a20e687230', 'withdrawal', 40000000.00, '2025-02-22', '20:34:06', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:34:06', '2025-02-22 20:34:06', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21731, NULL, 'ee853e4a-6d80-4954-ac7b-84a20e687230', 'deposit', 0.00, '2025-02-22', '20:34:06', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:34:06', '2025-02-22 20:34:06', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21732, NULL, '6c87e950-e45f-4965-aeb0-8f91938a931f', 'deposit', 10000.00, '2025-02-22', '20:34:31', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:34:31', '2025-02-22 20:34:31', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21733, NULL, '6c87e950-e45f-4965-aeb0-8f91938a931f', 'deposit', 10000.00, '2025-02-22', '20:34:31', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:34:31', '2025-02-22 20:34:31', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21734, NULL, '6c87e950-e45f-4965-aeb0-8f91938a931f', 'deposit', 0.00, '2025-02-22', '20:34:31', 'Fee collected for deposit', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-22 20:34:31', '2025-02-22 20:34:31', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21735, NULL, 'ef41ea48-c402-4975-97fa-b1e439b6a5fa', 'withdrawal', 79905000.00, '2025-02-22', '20:35:44', NULL, 0.00, 1, 'muhamd salm', NULL, NULL, NULL, NULL, '2025-02-22 20:35:44', '2025-02-22 20:35:44', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21736, NULL, 'ef41ea48-c402-4975-97fa-b1e439b6a5fa', 'withdrawal', 79905000.00, '2025-02-22', '20:35:44', NULL, 0.00, 1, 'muhamd salm', NULL, NULL, NULL, NULL, '2025-02-22 20:35:44', '2025-02-22 20:35:44', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21737, NULL, 'ef41ea48-c402-4975-97fa-b1e439b6a5fa', 'deposit', 0.00, '2025-02-22', '20:35:44', 'Fee collected for withdrawal', 0.00, 1, 'muhamd salm', NULL, NULL, NULL, NULL, '2025-02-22 20:35:44', '2025-02-22 20:35:44', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21738, NULL, '7886ac7d-c5a2-4882-ab95-b531f538c3a8', 'withdrawal', 6009000.00, '2025-02-22', '20:37:07', NULL, 9000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:37:07', '2025-02-22 20:37:07', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21739, NULL, '7886ac7d-c5a2-4882-ab95-b531f538c3a8', 'withdrawal', 6000000.00, '2025-02-22', '20:37:07', NULL, 9000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:37:07', '2025-02-22 20:37:07', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21740, NULL, '7886ac7d-c5a2-4882-ab95-b531f538c3a8', 'withdrawal', 6009000.00, '2025-02-22', '20:37:07', NULL, 9000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-22 20:37:07', '2025-02-22 20:37:07', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21741, NULL, 'a5c48f30-c25b-4aed-8240-61a3e9709af4', 'deposit', 1133000.00, '2025-02-22', '20:37:51', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-22 20:37:51', '2025-02-22 20:37:51', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21742, NULL, 'a5c48f30-c25b-4aed-8240-61a3e9709af4', 'deposit', 1133000.00, '2025-02-22', '20:37:51', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-22 20:37:51', '2025-02-22 20:37:51', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21743, NULL, 'a5c48f30-c25b-4aed-8240-61a3e9709af4', 'deposit', 0.00, '2025-02-22', '20:37:51', 'Fee collected for deposit', 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-22 20:37:51', '2025-02-22 20:37:51', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21760, NULL, '7c5eccaa-551b-4903-8ae5-637204b3d3dc', 'deposit', 54.00, '2025-02-22', '21:05:01', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-22 21:05:01', '2025-02-22 21:05:01', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21761, NULL, '7c5eccaa-551b-4903-8ae5-637204b3d3dc', 'deposit', 54.00, '2025-02-22', '21:05:01', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-22 21:05:01', '2025-02-22 21:05:01', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21762, NULL, '7c5eccaa-551b-4903-8ae5-637204b3d3dc', 'deposit', 0.00, '2025-02-22', '21:05:01', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-22 21:05:01', '2025-02-22 21:05:01', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21763, NULL, '1366ab07-d110-4e7c-8f24-ba2f78d62c70', 'deposit', 47.00, '2025-02-22', '21:05:29', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-22 21:05:29', '2025-02-22 21:05:29', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21764, NULL, '1366ab07-d110-4e7c-8f24-ba2f78d62c70', 'deposit', 47.00, '2025-02-22', '21:05:29', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-22 21:05:29', '2025-02-22 21:05:29', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21765, NULL, '1366ab07-d110-4e7c-8f24-ba2f78d62c70', 'deposit', 0.00, '2025-02-22', '21:05:29', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-22 21:05:29', '2025-02-22 21:05:29', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21788, NULL, '77510571-0959-4d59-9ef1-13c08c829d44', 'withdrawal', 500.00, '2025-02-22', '21:20:07', NULL, 0.00, 1, 'sarf k shamal', NULL, NULL, NULL, NULL, '2025-02-22 21:20:07', '2025-02-22 21:20:07', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21789, NULL, '77510571-0959-4d59-9ef1-13c08c829d44', 'withdrawal', 500.00, '2025-02-22', '21:20:07', NULL, 0.00, 1, 'sarf k shamal', NULL, NULL, NULL, NULL, '2025-02-22 21:20:07', '2025-02-22 21:20:07', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21790, NULL, '77510571-0959-4d59-9ef1-13c08c829d44', 'deposit', 0.00, '2025-02-22', '21:20:07', 'Fee collected for withdrawal', 0.00, 1, 'sarf k shamal', NULL, NULL, NULL, NULL, '2025-02-22 21:20:07', '2025-02-22 21:20:07', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21791, NULL, 'fe72a0cd-fb15-40d5-ae53-00a4ba78bc5b', 'deposit', 275000.00, '2025-02-22', '21:24:07', NULL, 0.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-22 21:24:07', '2025-02-22 21:24:07', 183, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21792, NULL, 'fe72a0cd-fb15-40d5-ae53-00a4ba78bc5b', 'deposit', 275000.00, '2025-02-22', '21:24:07', NULL, 0.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-22 21:24:07', '2025-02-22 21:24:07', 18, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21793, NULL, 'fe72a0cd-fb15-40d5-ae53-00a4ba78bc5b', 'deposit', 275000.00, '2025-02-22', '21:24:07', NULL, 0.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-22 21:24:07', '2025-02-22 21:24:07', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21794, NULL, '2f2a78be-4aca-4338-bd54-939a02229e28', 'withdrawal', 9286.00, '2025-02-22', '21:28:24', NULL, 100.00, 1, 'sweft chine', NULL, NULL, NULL, NULL, '2025-02-22 21:28:24', '2025-02-22 21:28:24', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21795, NULL, '2f2a78be-4aca-4338-bd54-939a02229e28', 'withdrawal', 9286.00, '2025-02-22', '21:28:24', NULL, 100.00, 1, 'sweft chine', NULL, NULL, NULL, NULL, '2025-02-22 21:28:24', '2025-02-22 21:28:24', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21796, NULL, '2f2a78be-4aca-4338-bd54-939a02229e28', 'deposit', 100.00, '2025-02-22', '21:28:24', 'Fee collected for withdrawal', 0.00, 1, 'sweft chine', NULL, NULL, NULL, NULL, '2025-02-22 21:28:24', '2025-02-22 21:28:24', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21799, NULL, '63a8aefa-05ed-4a95-a883-cca276d98c5e', 'withdrawal', 2007000.00, '2025-02-22', '21:34:38', NULL, 7000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-22 21:34:38', '2025-02-22 21:34:38', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21800, NULL, '63a8aefa-05ed-4a95-a883-cca276d98c5e', 'withdrawal', 2007000.00, '2025-02-22', '21:34:38', NULL, 7000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-22 21:34:38', '2025-02-22 21:34:38', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21801, NULL, '63a8aefa-05ed-4a95-a883-cca276d98c5e', 'deposit', 7000.00, '2025-02-22', '21:34:38', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-22 21:34:38', '2025-02-22 21:34:38', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21924, NULL, '9abd1a75-50c0-4bf8-8c3a-10d16f9c721e', 'deposit', 40000000.00, '2025-02-23', '11:58:09', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-23 11:58:09', '2025-02-23 11:58:09', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21925, NULL, '9abd1a75-50c0-4bf8-8c3a-10d16f9c721e', 'deposit', 40000000.00, '2025-02-23', '11:58:09', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-23 11:58:09', '2025-02-23 11:58:09', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21926, NULL, '9abd1a75-50c0-4bf8-8c3a-10d16f9c721e', 'deposit', 40000000.00, '2025-02-23', '11:58:09', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-23 11:58:09', '2025-02-23 11:58:09', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21937, NULL, '24a78da6-5005-41e9-95d0-4f2a591d700a', 'withdrawal', 9743500.00, '2025-02-23', '12:16:15', NULL, 14500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 12:16:15', '2025-02-23 12:16:15', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21938, NULL, '24a78da6-5005-41e9-95d0-4f2a591d700a', 'withdrawal', 9729000.00, '2025-02-23', '12:16:15', NULL, 14500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 12:16:15', '2025-02-23 12:16:15', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21939, NULL, '24a78da6-5005-41e9-95d0-4f2a591d700a', 'withdrawal', 9743500.00, '2025-02-23', '12:16:15', NULL, 14500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 12:16:15', '2025-02-23 12:16:15', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21946, NULL, '1ce2f29c-ed7e-44b0-959d-3596ca518d0c', 'deposit', 4012000.00, '2025-02-23', '12:20:49', '2hawala-sja ismaiel
leth shno', 12000.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-23 12:20:49', '2025-02-23 12:20:49', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21947, NULL, '1ce2f29c-ed7e-44b0-959d-3596ca518d0c', 'deposit', 4012000.00, '2025-02-23', '12:20:49', '2hawala-sja ismaiel
leth shno', 12000.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-23 12:20:49', '2025-02-23 12:20:49', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(21948, NULL, '1ce2f29c-ed7e-44b0-959d-3596ca518d0c', 'deposit', 12000.00, '2025-02-23', '12:20:49', 'Fee collected for deposit', 0.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-23 12:20:49', '2025-02-23 12:20:49', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22047, NULL, 'ae366cee-3ff5-4c28-a496-23e473be8e5b', 'withdrawal', 21615000.00, '2025-02-23', '14:21:32', NULL, 0.00, 132, 'Imad law braim', NULL, NULL, NULL, NULL, '2025-02-23 14:21:32', '2025-02-23 14:21:32', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22048, NULL, 'ae366cee-3ff5-4c28-a496-23e473be8e5b', 'withdrawal', 21615000.00, '2025-02-23', '14:21:32', NULL, 0.00, 132, 'Imad law braim', NULL, NULL, NULL, NULL, '2025-02-23 14:21:32', '2025-02-23 14:21:32', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22067, NULL, '476553d3-aaa8-463a-b9dd-6e5d1be5e46d', 'deposit', 150000.00, '2025-02-23', '15:22:04', NULL, 0.00, 1, 'hatu', NULL, NULL, NULL, NULL, '2025-02-23 15:22:04', '2025-02-23 15:22:04', 222, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22068, NULL, '476553d3-aaa8-463a-b9dd-6e5d1be5e46d', 'deposit', 150000.00, '2025-02-23', '15:22:04', NULL, 0.00, 1, 'hatu', NULL, NULL, NULL, NULL, '2025-02-23 15:22:04', '2025-02-23 15:22:04', 2, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22069, NULL, '476553d3-aaa8-463a-b9dd-6e5d1be5e46d', 'deposit', 0.00, '2025-02-23', '15:22:04', 'Fee collected for deposit', 0.00, 1, 'hatu', NULL, NULL, NULL, NULL, '2025-02-23 15:22:04', '2025-02-23 15:22:04', 23, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22076, NULL, '4867a595-7d9b-424e-aac1-9c1e906ba0fb', 'withdrawal', 2242750.00, '2025-02-23', '15:29:52', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:29:52', '2025-02-23 15:29:52', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22077, NULL, '4867a595-7d9b-424e-aac1-9c1e906ba0fb', 'withdrawal', 2239500.00, '2025-02-23', '15:29:52', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:29:53', '2025-02-23 15:29:53', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22078, NULL, '4867a595-7d9b-424e-aac1-9c1e906ba0fb', 'withdrawal', 2242750.00, '2025-02-23', '15:29:52', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:29:53', '2025-02-23 15:29:53', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22079, NULL, '88c6fb54-6203-4ec6-bdaa-0355c1a4e633', 'deposit', 3500.00, '2025-02-23', '15:31:10', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-23 15:31:10', '2025-02-23 15:31:10', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22080, NULL, '88c6fb54-6203-4ec6-bdaa-0355c1a4e633', 'deposit', 3500.00, '2025-02-23', '15:31:10', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-23 15:31:10', '2025-02-23 15:31:10', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22081, NULL, '88c6fb54-6203-4ec6-bdaa-0355c1a4e633', 'deposit', 0.00, '2025-02-23', '15:31:10', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-23 15:31:10', '2025-02-23 15:31:10', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22086, NULL, '44f26ed6-ee18-4fa9-92a3-692f131f26ee', 'withdrawal', 6570000.00, '2025-02-23', '15:34:48', NULL, 10000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:34:48', '2025-02-23 15:34:48', 216, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22087, NULL, '44f26ed6-ee18-4fa9-92a3-692f131f26ee', 'withdrawal', 6560000.00, '2025-02-23', '15:34:48', NULL, 10000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:34:48', '2025-02-23 15:34:48', 18, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22088, NULL, '44f26ed6-ee18-4fa9-92a3-692f131f26ee', 'withdrawal', 6570000.00, '2025-02-23', '15:34:48', NULL, 10000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:34:48', '2025-02-23 15:34:48', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22089, NULL, '22e1b775-f9e0-4550-96c3-e7a1c54d7ca5', 'deposit', 8141.00, '2025-02-23', '15:38:50', NULL, -85.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-23 15:38:50', '2025-02-23 15:38:50', 217, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22090, NULL, '22e1b775-f9e0-4550-96c3-e7a1c54d7ca5', 'deposit', 8141.00, '2025-02-23', '15:38:50', NULL, -85.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-23 15:38:50', '2025-02-23 15:38:50', 1, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22091, NULL, '22e1b775-f9e0-4550-96c3-e7a1c54d7ca5', 'deposit', -85.00, '2025-02-23', '15:38:50', 'Fee collected for deposit', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-23 15:38:50', '2025-02-23 15:38:50', 22, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22092, NULL, 'd7701285-f83c-4463-9c8e-46426a35f362', 'withdrawal', 4016000.00, '2025-02-23', '15:42:28', 'sja ismaiel
leth shno', 16000.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-23 15:42:28', '2025-02-23 15:42:28', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22093, NULL, 'd7701285-f83c-4463-9c8e-46426a35f362', 'withdrawal', 4016000.00, '2025-02-23', '15:42:28', 'sja ismaiel
leth shno', 16000.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-23 15:42:28', '2025-02-23 15:42:28', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22094, NULL, 'd7701285-f83c-4463-9c8e-46426a35f362', 'deposit', 16000.00, '2025-02-23', '15:42:28', 'Fee collected for withdrawal', 0.00, 1, 'hawala', NULL, NULL, NULL, NULL, '2025-02-23 15:42:28', '2025-02-23 15:42:28', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22095, NULL, 'fdab51ce-783e-4dad-98af-f100b406e61a', 'deposit', 5000000.00, '2025-02-23', '15:42:59', NULL, 0.00, 1, 'ashti azad haji', NULL, NULL, NULL, NULL, '2025-02-23 15:42:59', '2025-02-23 15:42:59', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22096, NULL, 'fdab51ce-783e-4dad-98af-f100b406e61a', 'deposit', 5000000.00, '2025-02-23', '15:42:59', NULL, 0.00, 1, 'ashti azad haji', NULL, NULL, NULL, NULL, '2025-02-23 15:42:59', '2025-02-23 15:42:59', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22097, NULL, 'fdab51ce-783e-4dad-98af-f100b406e61a', 'deposit', 0.00, '2025-02-23', '15:42:59', 'Fee collected for deposit', 0.00, 1, 'ashti azad haji', NULL, NULL, NULL, NULL, '2025-02-23 15:42:59', '2025-02-23 15:42:59', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22102, NULL, '24d35ea7-a6fc-4727-a459-1dccd75f55e1', 'deposit', 23000.00, '2025-02-23', '15:46:08', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-23 15:46:08', '2025-02-23 15:46:08', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22103, NULL, '24d35ea7-a6fc-4727-a459-1dccd75f55e1', 'deposit', 23000.00, '2025-02-23', '15:46:08', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-23 15:46:08', '2025-02-23 15:46:08', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22104, NULL, '24d35ea7-a6fc-4727-a459-1dccd75f55e1', 'deposit', 0.00, '2025-02-23', '15:46:08', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-23 15:46:08', '2025-02-23 15:46:08', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22109, NULL, '8726ead5-13ec-4e3c-85fe-d6075f29349b', 'deposit', 10000.00, '2025-02-23', '15:48:04', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-23 15:48:04', '2025-02-23 15:48:04', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(22110, NULL, '8726ead5-13ec-4e3c-85fe-d6075f29349b', 'deposit', 10000.00, '2025-02-23', '15:48:04', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-23 15:48:04', '2025-02-23 15:48:04', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22111, NULL, '8726ead5-13ec-4e3c-85fe-d6075f29349b', 'deposit', 0.00, '2025-02-23', '15:48:04', 'Fee collected for deposit', 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-23 15:48:04', '2025-02-23 15:48:04', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22112, NULL, '2b07e82d-a473-4b8b-8749-98751604de5d', 'deposit', 5013.00, '2025-02-23', '15:48:20', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-23 15:48:20', '2025-02-23 15:48:20', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22113, NULL, '2b07e82d-a473-4b8b-8749-98751604de5d', 'deposit', 5013.00, '2025-02-23', '15:48:20', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-23 15:48:20', '2025-02-23 15:48:20', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22114, NULL, '2b07e82d-a473-4b8b-8749-98751604de5d', 'deposit', 0.00, '2025-02-23', '15:48:20', 'Fee collected for deposit', 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-23 15:48:20', '2025-02-23 15:48:20', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22115, NULL, 'b52628f1-6ab6-465a-9f61-32fa433b9e14', 'withdrawal', 1500.00, '2025-02-23', '15:48:42', NULL, 0.00, 1, 'sarf k karwan', NULL, NULL, NULL, NULL, '2025-02-23 15:48:42', '2025-02-23 15:48:42', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22116, NULL, 'b52628f1-6ab6-465a-9f61-32fa433b9e14', 'withdrawal', 1500.00, '2025-02-23', '15:48:42', NULL, 0.00, 1, 'sarf k karwan', NULL, NULL, NULL, NULL, '2025-02-23 15:48:42', '2025-02-23 15:48:42', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22117, NULL, 'b52628f1-6ab6-465a-9f61-32fa433b9e14', 'deposit', 0.00, '2025-02-23', '15:48:42', 'Fee collected for withdrawal', 0.00, 1, 'sarf k karwan', NULL, NULL, NULL, NULL, '2025-02-23 15:48:42', '2025-02-23 15:48:42', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22118, NULL, '2351b77a-b317-4def-aabd-1e8c4fcbcf7d', 'deposit', 19000000.00, '2025-02-23', '15:49:52', NULL, 0.00, 1, 'k alan', NULL, NULL, NULL, NULL, '2025-02-23 15:49:52', '2025-02-23 15:49:52', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22119, NULL, '2351b77a-b317-4def-aabd-1e8c4fcbcf7d', 'deposit', 19000000.00, '2025-02-23', '15:49:52', NULL, 0.00, 1, 'k alan', NULL, NULL, NULL, NULL, '2025-02-23 15:49:52', '2025-02-23 15:49:52', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22120, NULL, '2351b77a-b317-4def-aabd-1e8c4fcbcf7d', 'deposit', 0.00, '2025-02-23', '15:49:52', 'Fee collected for deposit', 0.00, 1, 'k alan', NULL, NULL, NULL, NULL, '2025-02-23 15:49:52', '2025-02-23 15:49:52', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22124, NULL, '2ae9bc59-8dca-4bce-833e-c2d74013890f', 'withdrawal', 5007500.00, '2025-02-23', '15:54:38', NULL, 7500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:54:38', '2025-02-23 15:54:38', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22125, NULL, '2ae9bc59-8dca-4bce-833e-c2d74013890f', 'withdrawal', 5000000.00, '2025-02-23', '15:54:38', NULL, 7500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:54:38', '2025-02-23 15:54:38', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22126, NULL, '2ae9bc59-8dca-4bce-833e-c2d74013890f', 'withdrawal', 5007500.00, '2025-02-23', '15:54:38', NULL, 7500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-23 15:54:38', '2025-02-23 15:54:38', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22139, NULL, '8a5f3333-6afb-4310-aee4-62a481b70698', 'deposit', 135500000.00, '2025-02-23', '16:03:44', NULL, 0.00, 1, 'muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-23 16:03:44', '2025-02-23 16:03:44', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22140, NULL, '8a5f3333-6afb-4310-aee4-62a481b70698', 'deposit', 135500000.00, '2025-02-23', '16:03:44', NULL, 0.00, 1, 'muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-23 16:03:44', '2025-02-23 16:03:44', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22141, NULL, '8a5f3333-6afb-4310-aee4-62a481b70698', 'deposit', 0.00, '2025-02-23', '16:03:44', 'Fee collected for deposit', 0.00, 1, 'muhamad bahzad', NULL, NULL, NULL, NULL, '2025-02-23 16:03:44', '2025-02-23 16:03:44', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22142, NULL, 'ed65cacf-c94a-4afc-85d0-5be5ae637c34', 'withdrawal', 40000.00, '2025-02-23', '16:04:06', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-23 16:04:06', '2025-02-23 16:04:06', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22143, NULL, 'ed65cacf-c94a-4afc-85d0-5be5ae637c34', 'withdrawal', 40000.00, '2025-02-23', '16:04:06', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-23 16:04:06', '2025-02-23 16:04:06', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22144, NULL, 'ed65cacf-c94a-4afc-85d0-5be5ae637c34', 'deposit', 0.00, '2025-02-23', '16:04:06', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-23 16:04:06', '2025-02-23 16:04:06', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22149, NULL, '6573204d-fad6-4b55-8f9f-e7ea2bb3382c', 'withdrawal', 13488.00, '2025-02-23', '16:04:54', NULL, 0.00, 1, 'maktab hemdad', NULL, NULL, NULL, NULL, '2025-02-23 16:04:54', '2025-02-23 16:04:54', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22150, NULL, '6573204d-fad6-4b55-8f9f-e7ea2bb3382c', 'withdrawal', 13488.00, '2025-02-23', '16:04:54', NULL, 0.00, 1, 'maktab hemdad', NULL, NULL, NULL, NULL, '2025-02-23 16:04:54', '2025-02-23 16:04:54', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22151, NULL, '6573204d-fad6-4b55-8f9f-e7ea2bb3382c', 'deposit', 0.00, '2025-02-23', '16:04:54', 'Fee collected for withdrawal', 0.00, 1, 'maktab hemdad', NULL, NULL, NULL, NULL, '2025-02-23 16:04:54', '2025-02-23 16:04:54', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22152, NULL, '32a14f99-4bcf-4eea-b5c0-34b99f69bd9d', 'deposit', 55018.00, '2025-02-23', '16:05:23', NULL, 0.00, 1, 'maktab juantren payam', NULL, NULL, NULL, NULL, '2025-02-23 16:05:23', '2025-02-23 16:05:23', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22153, NULL, '32a14f99-4bcf-4eea-b5c0-34b99f69bd9d', 'deposit', 55018.00, '2025-02-23', '16:05:23', NULL, 0.00, 1, 'maktab juantren payam', NULL, NULL, NULL, NULL, '2025-02-23 16:05:23', '2025-02-23 16:05:23', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22154, NULL, '32a14f99-4bcf-4eea-b5c0-34b99f69bd9d', 'deposit', 0.00, '2025-02-23', '16:05:23', 'Fee collected for deposit', 0.00, 1, 'maktab juantren payam', NULL, NULL, NULL, NULL, '2025-02-23 16:05:23', '2025-02-23 16:05:23', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22159, NULL, 'd1baa574-a0b2-4621-bd05-b2bf52ad52a2', 'deposit', 3713.00, '2025-02-23', '16:05:56', NULL, 0.00, 1, 'maktab shul rafden', NULL, NULL, NULL, NULL, '2025-02-23 16:05:56', '2025-02-23 16:05:56', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22160, NULL, 'd1baa574-a0b2-4621-bd05-b2bf52ad52a2', 'deposit', 3713.00, '2025-02-23', '16:05:56', NULL, 0.00, 1, 'maktab shul rafden', NULL, NULL, NULL, NULL, '2025-02-23 16:05:56', '2025-02-23 16:05:56', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22161, NULL, 'd1baa574-a0b2-4621-bd05-b2bf52ad52a2', 'deposit', 0.00, '2025-02-23', '16:05:56', 'Fee collected for deposit', 0.00, 1, 'maktab shul rafden', NULL, NULL, NULL, NULL, '2025-02-23 16:05:56', '2025-02-23 16:05:56', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22166, NULL, '482d7098-99c4-4f82-a7d4-cd378368c9bd', 'deposit', 4012000.00, '2025-02-23', '16:06:28', NULL, 0.00, 1, 'maktab shul rafden', NULL, NULL, NULL, NULL, '2025-02-23 16:06:28', '2025-02-23 16:06:28', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22167, NULL, '482d7098-99c4-4f82-a7d4-cd378368c9bd', 'deposit', 4012000.00, '2025-02-23', '16:06:28', NULL, 0.00, 1, 'maktab shul rafden', NULL, NULL, NULL, NULL, '2025-02-23 16:06:28', '2025-02-23 16:06:28', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22168, NULL, '482d7098-99c4-4f82-a7d4-cd378368c9bd', 'deposit', 0.00, '2025-02-23', '16:06:28', 'Fee collected for deposit', 0.00, 1, 'maktab shul rafden', NULL, NULL, NULL, NULL, '2025-02-23 16:06:28', '2025-02-23 16:06:28', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22173, NULL, '373b1e89-4193-4c30-b71c-cf7f6254f799', 'deposit', 783.00, '2025-02-23', '16:13:16', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-23 16:13:16', '2025-02-23 16:13:16', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22174, NULL, '373b1e89-4193-4c30-b71c-cf7f6254f799', 'deposit', 783.00, '2025-02-23', '16:13:16', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-23 16:13:16', '2025-02-23 16:13:16', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22175, NULL, '373b1e89-4193-4c30-b71c-cf7f6254f799', 'deposit', 0.00, '2025-02-23', '16:13:16', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-23 16:13:16', '2025-02-23 16:13:16', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22176, NULL, '134d4dde-db24-4acf-bcda-ea878218573c', 'deposit', 98.00, '2025-02-23', '16:13:37', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-23 16:13:37', '2025-02-23 16:13:37', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22177, NULL, '134d4dde-db24-4acf-bcda-ea878218573c', 'deposit', 98.00, '2025-02-23', '16:13:37', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-23 16:13:37', '2025-02-23 16:13:37', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22178, NULL, '134d4dde-db24-4acf-bcda-ea878218573c', 'deposit', 0.00, '2025-02-23', '16:13:37', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-23 16:13:37', '2025-02-23 16:13:37', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22181, NULL, 'a04596ce-333c-4c6a-a4ae-0f122597b066', 'withdrawal', 8160.00, '2025-02-23', '16:17:38', NULL, -66.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-23 16:17:38', '2025-02-23 16:17:38', 271, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22182, NULL, 'a04596ce-333c-4c6a-a4ae-0f122597b066', 'withdrawal', 8160.00, '2025-02-23', '16:17:38', NULL, -66.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-23 16:17:38', '2025-02-23 16:17:38', 1, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22183, NULL, 'a04596ce-333c-4c6a-a4ae-0f122597b066', 'deposit', -66.00, '2025-02-23', '16:17:38', 'Fee collected for withdrawal', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-02-23 16:17:38', '2025-02-23 16:17:38', 22, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22190, NULL, '90ce49c6-7be2-4085-bff9-13277c444f80', 'deposit', 15.00, '2025-02-23', '16:20:09', NULL, 15.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-23 16:20:09', '2025-02-23 16:20:09', 217, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22191, NULL, '90ce49c6-7be2-4085-bff9-13277c444f80', 'deposit', 15.00, '2025-02-23', '16:20:09', NULL, 15.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-23 16:20:09', '2025-02-23 16:20:09', 1, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22192, NULL, '90ce49c6-7be2-4085-bff9-13277c444f80', 'deposit', 15.00, '2025-02-23', '16:20:09', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-23 16:20:09', '2025-02-23 16:20:09', 22, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22199, NULL, 'de76648c-bf9c-4f0b-bac3-4f969df63d39', 'withdrawal', 2500.00, '2025-02-23', '16:33:40', NULL, 0.00, 137, 'mahmood azad haji kakul', NULL, NULL, NULL, NULL, '2025-02-23 16:33:40', '2025-02-23 16:33:40', 727, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22200, NULL, 'de76648c-bf9c-4f0b-bac3-4f969df63d39', 'withdrawal', 2500.00, '2025-02-23', '16:33:40', NULL, 0.00, 137, 'mahmood azad haji kakul', NULL, NULL, NULL, NULL, '2025-02-23 16:33:40', '2025-02-23 16:33:40', 1, 727, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22221, NULL, 'f0661b82-42a0-413a-9f03-d1b26f78f56d', 'deposit', 2900.00, '2025-02-23', '16:58:12', NULL, 0.00, 1, 'kak rebaz bray k.rabar/07504360706', NULL, NULL, NULL, NULL, '2025-02-23 16:58:12', '2025-02-23 16:58:12', 1144, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22222, NULL, 'f0661b82-42a0-413a-9f03-d1b26f78f56d', 'deposit', 2900.00, '2025-02-23', '16:58:12', NULL, 0.00, 1, 'kak rebaz bray k.rabar/07504360706', NULL, NULL, NULL, NULL, '2025-02-23 16:58:12', '2025-02-23 16:58:12', 1, 1144, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22223, NULL, 'f0661b82-42a0-413a-9f03-d1b26f78f56d', 'deposit', 0.00, '2025-02-23', '16:58:12', 'Fee collected for deposit', 0.00, 1, 'kak rebaz bray k.rabar/07504360706', NULL, NULL, NULL, NULL, '2025-02-23 16:58:12', '2025-02-23 16:58:12', 22, 1144, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22460, NULL, 'f58c4165-62a5-465a-a135-98d5a887cdf0', 'withdrawal', 25382492.00, '2025-02-24', '09:28:58', NULL, 0.00, 1, 'hg', NULL, NULL, NULL, NULL, '2025-02-24 09:28:58', '2025-02-24 09:28:58', 475, 69, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22461, NULL, 'f58c4165-62a5-465a-a135-98d5a887cdf0', 'deposit', 25382492.00, '2025-02-24', '09:28:58', NULL, 0.00, 1, 'hg', NULL, NULL, NULL, NULL, '2025-02-24 09:28:58', '2025-02-24 09:28:58', 69, 475, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22462, NULL, 'f58c4165-62a5-465a-a135-98d5a887cdf0', 'deposit', 0.00, '2025-02-24', '09:28:58', 'Fee collected for transfer', 0.00, 1, 'hg', NULL, NULL, NULL, NULL, '2025-02-24 09:28:58', '2025-02-24 09:28:58', 70, 475, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22465, NULL, 'ba1e280c-9a22-46f4-8aa8-af1ee37a3e81', 'deposit', 1200000.00, '2025-02-24', '09:32:25', NULL, 0.00, 1, 'hatw badasty alan', NULL, NULL, NULL, NULL, '2025-02-24 09:32:25', '2025-02-24 09:32:25', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22466, NULL, 'ba1e280c-9a22-46f4-8aa8-af1ee37a3e81', 'deposit', 1200000.00, '2025-02-24', '09:32:25', NULL, 0.00, 1, 'hatw badasty alan', NULL, NULL, NULL, NULL, '2025-02-24 09:32:25', '2025-02-24 09:32:25', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22467, NULL, 'ba1e280c-9a22-46f4-8aa8-af1ee37a3e81', 'deposit', 0.00, '2025-02-24', '09:32:25', 'Fee collected for deposit', 0.00, 1, 'hatw badasty alan', NULL, NULL, NULL, NULL, '2025-02-24 09:32:25', '2025-02-24 09:32:25', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22468, NULL, 'c1774624-7f80-4e55-a07a-ccdf4d32be29', 'withdrawal', 20130000.00, '2025-02-24', '09:33:22', NULL, 130000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 09:33:22', '2025-02-24 09:33:22', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22469, NULL, 'c1774624-7f80-4e55-a07a-ccdf4d32be29', 'withdrawal', 20130000.00, '2025-02-24', '09:33:22', NULL, 130000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 09:33:22', '2025-02-24 09:33:22', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22470, NULL, 'c1774624-7f80-4e55-a07a-ccdf4d32be29', 'deposit', 130000.00, '2025-02-24', '09:33:22', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 09:33:22', '2025-02-24 09:33:22', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22471, NULL, '1a464458-81a0-49a0-97a2-905c6870fe51', 'deposit', 17500000.00, '2025-02-24', '09:33:59', NULL, 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-24 09:33:59', '2025-02-24 09:33:59', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22472, NULL, '1a464458-81a0-49a0-97a2-905c6870fe51', 'deposit', 17500000.00, '2025-02-24', '09:33:59', NULL, 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-24 09:33:59', '2025-02-24 09:33:59', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22473, NULL, '1a464458-81a0-49a0-97a2-905c6870fe51', 'deposit', 0.00, '2025-02-24', '09:33:59', 'Fee collected for deposit', 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-24 09:33:59', '2025-02-24 09:33:59', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22630, NULL, '2e9d6f1a-88b4-479b-be3e-0fd123e3206a', 'deposit', 20000.00, '2025-02-24', '13:39:13', NULL, 0.00, 1, 'korea jeon seung min', NULL, NULL, NULL, NULL, '2025-02-24 13:39:13', '2025-02-24 13:39:13', 1145, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22631, NULL, '2e9d6f1a-88b4-479b-be3e-0fd123e3206a', 'deposit', 20000.00, '2025-02-24', '13:39:13', NULL, 0.00, 1, 'korea jeon seung min', NULL, NULL, NULL, NULL, '2025-02-24 13:39:13', '2025-02-24 13:39:13', 1, 1145, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22632, NULL, '2e9d6f1a-88b4-479b-be3e-0fd123e3206a', 'deposit', 0.00, '2025-02-24', '13:39:13', 'Fee collected for deposit', 0.00, 1, 'korea jeon seung min', NULL, NULL, NULL, NULL, '2025-02-24 13:39:13', '2025-02-24 13:39:13', 22, 1145, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22637, NULL, 'a93b3380-d0ca-4507-a222-3f782c8c653e', 'withdrawal', 135500000.00, '2025-02-24', '13:42:32', NULL, 0.00, 1, 'sarf muhamad bahzad ', NULL, NULL, NULL, NULL, '2025-02-24 13:42:32', '2025-02-24 13:42:32', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22638, NULL, 'a93b3380-d0ca-4507-a222-3f782c8c653e', 'withdrawal', 135500000.00, '2025-02-24', '13:42:32', NULL, 0.00, 1, 'sarf muhamad bahzad ', NULL, NULL, NULL, NULL, '2025-02-24 13:42:32', '2025-02-24 13:42:32', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22639, NULL, 'a93b3380-d0ca-4507-a222-3f782c8c653e', 'deposit', 0.00, '2025-02-24', '13:42:32', 'Fee collected for withdrawal', 0.00, 1, 'sarf muhamad bahzad ', NULL, NULL, NULL, NULL, '2025-02-24 13:42:32', '2025-02-24 13:42:32', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22640, NULL, 'e0f352cf-8830-4f1d-bde9-77edb73b01ac', 'deposit', 8156.00, '2025-02-24', '13:45:06', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-24 13:45:06', '2025-02-24 13:45:06', 1, 217, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22641, NULL, 'e0f352cf-8830-4f1d-bde9-77edb73b01ac', 'withdrawal', 8156.00, '2025-02-24', '13:45:06', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-24 13:45:06', '2025-02-24 13:45:06', 217, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22642, NULL, 'e0f352cf-8830-4f1d-bde9-77edb73b01ac', 'withdrawal', 12152440.00, '2025-02-24', '13:45:06', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-24 13:45:06', '2025-02-24 13:45:06', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22643, NULL, 'e0f352cf-8830-4f1d-bde9-77edb73b01ac', 'deposit', 12152440.00, '2025-02-24', '13:45:06', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-24 13:45:06', '2025-02-24 13:45:06', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22680, NULL, '39033697-734a-4186-a554-2acfbf172433', 'withdrawal', 4012000.00, '2025-02-24', '14:44:05', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:44:05', '2025-02-24 14:44:05', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22681, NULL, '39033697-734a-4186-a554-2acfbf172433', 'withdrawal', 4012000.00, '2025-02-24', '14:44:05', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:44:05', '2025-02-24 14:44:05', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22682, NULL, '39033697-734a-4186-a554-2acfbf172433', 'deposit', 0.00, '2025-02-24', '14:44:05', 'Fee collected for withdrawal', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:44:05', '2025-02-24 14:44:05', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22683, NULL, '8c152d2e-d967-4204-90d1-5296abcf5df4', 'withdrawal', 3713.00, '2025-02-24', '14:44:16', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:44:16', '2025-02-24 14:44:16', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22684, NULL, '8c152d2e-d967-4204-90d1-5296abcf5df4', 'withdrawal', 3713.00, '2025-02-24', '14:44:16', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:44:16', '2025-02-24 14:44:16', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22685, NULL, '8c152d2e-d967-4204-90d1-5296abcf5df4', 'deposit', 0.00, '2025-02-24', '14:44:16', 'Fee collected for withdrawal', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:44:16', '2025-02-24 14:44:16', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22688, NULL, 'b736a7a8-9e9c-42c5-b0ba-5801d3e46775', 'deposit', 13488.00, '2025-02-24', '14:45:46', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:45:46', '2025-02-24 14:45:46', 1048, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22689, NULL, 'b736a7a8-9e9c-42c5-b0ba-5801d3e46775', 'deposit', 13488.00, '2025-02-24', '14:45:46', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:45:46', '2025-02-24 14:45:46', 1, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22690, NULL, 'b736a7a8-9e9c-42c5-b0ba-5801d3e46775', 'deposit', 0.00, '2025-02-24', '14:45:46', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 14:45:46', '2025-02-24 14:45:46', 22, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22693, NULL, '0f3f36a7-48bc-4c53-86bc-4b3b941f70b6', 'withdrawal', 630.00, '2025-02-24', '14:48:35', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-24 14:48:35', '2025-02-24 14:48:35', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22694, NULL, '0f3f36a7-48bc-4c53-86bc-4b3b941f70b6', 'withdrawal', 630.00, '2025-02-24', '14:48:35', NULL, 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-24 14:48:35', '2025-02-24 14:48:35', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22695, NULL, '0f3f36a7-48bc-4c53-86bc-4b3b941f70b6', 'deposit', 0.00, '2025-02-24', '14:48:35', 'Fee collected for withdrawal', 0.00, 1, 'fastpay', NULL, NULL, NULL, NULL, '2025-02-24 14:48:35', '2025-02-24 14:48:35', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22696, NULL, '5d3bb7d5-ebc1-4f7e-aa5c-a51e9cadb120', 'withdrawal', 2870.00, '2025-02-24', '14:48:59', NULL, 0.00, 1, 'sarf hsab Asa', NULL, NULL, NULL, NULL, '2025-02-24 14:48:59', '2025-02-24 14:48:59', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22697, NULL, '5d3bb7d5-ebc1-4f7e-aa5c-a51e9cadb120', 'withdrawal', 2870.00, '2025-02-24', '14:48:59', NULL, 0.00, 1, 'sarf hsab Asa', NULL, NULL, NULL, NULL, '2025-02-24 14:48:59', '2025-02-24 14:48:59', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22698, NULL, '5d3bb7d5-ebc1-4f7e-aa5c-a51e9cadb120', 'deposit', 0.00, '2025-02-24', '14:48:59', 'Fee collected for withdrawal', 0.00, 1, 'sarf hsab Asa', NULL, NULL, NULL, NULL, '2025-02-24 14:48:59', '2025-02-24 14:48:59', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22705, NULL, 'aecb68a7-b2f6-435b-ab5f-ede0cfc481d9', 'withdrawal', 55030.00, '2025-02-24', '14:56:18', NULL, 12.00, 1, 'maktab juantren payam', NULL, NULL, NULL, NULL, '2025-02-24 14:56:18', '2025-02-24 14:56:18', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22706, NULL, 'aecb68a7-b2f6-435b-ab5f-ede0cfc481d9', 'withdrawal', 55030.00, '2025-02-24', '14:56:18', NULL, 12.00, 1, 'maktab juantren payam', NULL, NULL, NULL, NULL, '2025-02-24 14:56:18', '2025-02-24 14:56:18', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22707, NULL, 'aecb68a7-b2f6-435b-ab5f-ede0cfc481d9', 'deposit', 12.00, '2025-02-24', '14:56:18', 'Fee collected for withdrawal', 0.00, 1, 'maktab juantren payam', NULL, NULL, NULL, NULL, '2025-02-24 14:56:18', '2025-02-24 14:56:18', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22708, NULL, '73fa278a-b0a1-49ed-af4d-c0c11ac8050a', 'deposit', 2870.00, '2025-02-24', '14:57:15', NULL, 0.00, 1, 'hatu hsab ahmed baper', NULL, NULL, NULL, NULL, '2025-02-24 14:57:15', '2025-02-24 14:57:15', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22709, NULL, '73fa278a-b0a1-49ed-af4d-c0c11ac8050a', 'deposit', 2870.00, '2025-02-24', '14:57:15', NULL, 0.00, 1, 'hatu hsab ahmed baper', NULL, NULL, NULL, NULL, '2025-02-24 14:57:15', '2025-02-24 14:57:15', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22710, NULL, '73fa278a-b0a1-49ed-af4d-c0c11ac8050a', 'deposit', 0.00, '2025-02-24', '14:57:15', 'Fee collected for deposit', 0.00, 1, 'hatu hsab ahmed baper', NULL, NULL, NULL, NULL, '2025-02-24 14:57:15', '2025-02-24 14:57:15', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22711, NULL, 'f4807a62-d764-4644-b400-9422810f7c7b', 'deposit', 8000.00, '2025-02-24', '14:57:38', NULL, 0.00, 1, 'maktab gardi', NULL, NULL, NULL, NULL, '2025-02-24 14:57:38', '2025-02-24 14:57:38', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22712, NULL, 'f4807a62-d764-4644-b400-9422810f7c7b', 'deposit', 8000.00, '2025-02-24', '14:57:38', NULL, 0.00, 1, 'maktab gardi', NULL, NULL, NULL, NULL, '2025-02-24 14:57:38', '2025-02-24 14:57:38', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22713, NULL, 'f4807a62-d764-4644-b400-9422810f7c7b', 'deposit', 0.00, '2025-02-24', '14:57:38', 'Fee collected for deposit', 0.00, 1, 'maktab gardi', NULL, NULL, NULL, NULL, '2025-02-24 14:57:38', '2025-02-24 14:57:38', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22718, NULL, '487f76d2-55eb-447d-8201-029c29a95421', 'withdrawal', 8000.00, '2025-02-24', '14:59:36', NULL, 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-24 14:59:36', '2025-02-24 14:59:36', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22719, NULL, '487f76d2-55eb-447d-8201-029c29a95421', 'withdrawal', 8000.00, '2025-02-24', '14:59:36', NULL, 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-24 14:59:36', '2025-02-24 14:59:36', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22720, NULL, '487f76d2-55eb-447d-8201-029c29a95421', 'deposit', 0.00, '2025-02-24', '14:59:36', 'Fee collected for withdrawal', 0.00, 1, 'sarf hsab asa', NULL, NULL, NULL, NULL, '2025-02-24 14:59:36', '2025-02-24 14:59:36', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22721, NULL, 'cfea5b4e-b682-4d29-9aed-88de71c9503f', 'deposit', 4264.00, '2025-02-24', '15:08:06', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 15:08:06', '2025-02-24 15:08:06', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22722, NULL, 'cfea5b4e-b682-4d29-9aed-88de71c9503f', 'deposit', 4264.00, '2025-02-24', '15:08:06', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 15:08:06', '2025-02-24 15:08:06', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(22723, NULL, 'cfea5b4e-b682-4d29-9aed-88de71c9503f', 'deposit', 0.00, '2025-02-24', '15:08:06', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 15:08:06', '2025-02-24 15:08:06', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22746, NULL, 'ed05ee08-94ec-4fb2-b55b-76c5085b3f85', 'deposit', 18000.00, '2025-02-24', '15:26:45', NULL, 0.00, 1, 'sardar', NULL, NULL, NULL, NULL, '2025-02-24 15:26:45', '2025-02-24 15:26:45', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22747, NULL, 'ed05ee08-94ec-4fb2-b55b-76c5085b3f85', 'deposit', 18000.00, '2025-02-24', '15:26:45', NULL, 0.00, 1, 'sardar', NULL, NULL, NULL, NULL, '2025-02-24 15:26:45', '2025-02-24 15:26:45', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22748, NULL, 'ed05ee08-94ec-4fb2-b55b-76c5085b3f85', 'deposit', 0.00, '2025-02-24', '15:26:45', 'Fee collected for deposit', 0.00, 1, 'sardar', NULL, NULL, NULL, NULL, '2025-02-24 15:26:45', '2025-02-24 15:26:45', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22751, NULL, '73f318b5-3d1b-4e02-aa89-990100883167', 'withdrawal', 17.00, '2025-02-24', '15:29:18', NULL, 0.00, 1, 'newroz', NULL, NULL, NULL, NULL, '2025-02-24 15:29:18', '2025-02-24 15:29:18', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22752, NULL, '73f318b5-3d1b-4e02-aa89-990100883167', 'withdrawal', 17.00, '2025-02-24', '15:29:18', NULL, 0.00, 1, 'newroz', NULL, NULL, NULL, NULL, '2025-02-24 15:29:18', '2025-02-24 15:29:18', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22753, NULL, '73f318b5-3d1b-4e02-aa89-990100883167', 'deposit', 0.00, '2025-02-24', '15:29:18', 'Fee collected for withdrawal', 0.00, 1, 'newroz', NULL, NULL, NULL, NULL, '2025-02-24 15:29:18', '2025-02-24 15:29:18', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22754, NULL, '2eceb272-027a-408a-b38a-205b05997f9e', 'withdrawal', 20000.00, '2025-02-24', '15:31:11', NULL, 0.00, 1, 'korea', NULL, NULL, NULL, NULL, '2025-02-24 15:31:11', '2025-02-24 15:31:11', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22755, NULL, '2eceb272-027a-408a-b38a-205b05997f9e', 'withdrawal', 20000.00, '2025-02-24', '15:31:11', NULL, 0.00, 1, 'korea', NULL, NULL, NULL, NULL, '2025-02-24 15:31:11', '2025-02-24 15:31:11', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22756, NULL, '2eceb272-027a-408a-b38a-205b05997f9e', 'deposit', 0.00, '2025-02-24', '15:31:11', 'Fee collected for withdrawal', 0.00, 1, 'korea', NULL, NULL, NULL, NULL, '2025-02-24 15:31:11', '2025-02-24 15:31:11', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22757, NULL, 'e2ab4353-9823-42d1-a896-a2b303465001', 'deposit', 20120000.00, '2025-02-24', '15:34:27', NULL, 120000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 15:34:27', '2025-02-24 15:34:27', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22758, NULL, 'e2ab4353-9823-42d1-a896-a2b303465001', 'deposit', 20120000.00, '2025-02-24', '15:34:27', NULL, 120000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 15:34:27', '2025-02-24 15:34:27', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22759, NULL, 'e2ab4353-9823-42d1-a896-a2b303465001', 'deposit', 120000.00, '2025-02-24', '15:34:27', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 15:34:27', '2025-02-24 15:34:27', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22763, NULL, '2dc97866-6d49-4333-8ffa-f8e28338ae6b', 'withdrawal', 20125000.00, '2025-02-24', '15:35:55', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-24 15:35:55', '2025-02-24 15:35:55', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22764, NULL, '2dc97866-6d49-4333-8ffa-f8e28338ae6b', 'withdrawal', 20125000.00, '2025-02-24', '15:35:55', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-24 15:35:55', '2025-02-24 15:35:55', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22765, NULL, '2dc97866-6d49-4333-8ffa-f8e28338ae6b', 'deposit', 0.00, '2025-02-24', '15:35:55', 'Fee collected for withdrawal', 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-24 15:35:55', '2025-02-24 15:35:55', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22770, NULL, '3df89c22-8dc1-4ffc-8d41-1acebf093e84', 'deposit', 4016000.00, '2025-02-24', '15:41:54', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-24 15:41:54', '2025-02-24 15:41:54', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22771, NULL, '3df89c22-8dc1-4ffc-8d41-1acebf093e84', 'deposit', 4016000.00, '2025-02-24', '15:41:54', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-24 15:41:54', '2025-02-24 15:41:54', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22772, NULL, '3df89c22-8dc1-4ffc-8d41-1acebf093e84', 'deposit', 0.00, '2025-02-24', '15:41:54', 'Fee collected for deposit', 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-24 15:41:54', '2025-02-24 15:41:54', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22773, NULL, '508a2942-ae7c-48f9-b083-084445d92aef', 'deposit', 2012000.00, '2025-02-24', '15:45:35', NULL, 12000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 15:45:35', '2025-02-24 15:45:35', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22774, NULL, '508a2942-ae7c-48f9-b083-084445d92aef', 'deposit', 2012000.00, '2025-02-24', '15:45:35', NULL, 12000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 15:45:35', '2025-02-24 15:45:35', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22775, NULL, '508a2942-ae7c-48f9-b083-084445d92aef', 'deposit', 12000.00, '2025-02-24', '15:45:35', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 15:45:35', '2025-02-24 15:45:35', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22780, NULL, '63143455-148b-43c7-9e70-54ead83b683f', 'withdrawal', 6000.00, '2025-02-24', '15:47:26', NULL, 6000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 15:47:26', '2025-02-24 15:47:26', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22781, NULL, '63143455-148b-43c7-9e70-54ead83b683f', 'withdrawal', 6000.00, '2025-02-24', '15:47:26', NULL, 6000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 15:47:26', '2025-02-24 15:47:26', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22782, NULL, '63143455-148b-43c7-9e70-54ead83b683f', 'deposit', 6000.00, '2025-02-24', '15:47:26', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 15:47:26', '2025-02-24 15:47:26', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22783, NULL, '423f52ff-d9aa-40ba-8269-5cd8b6a4ef5e', 'withdrawal', 3505250.00, '2025-02-24', '15:49:30', NULL, 5250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 15:49:30', '2025-02-24 15:49:30', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22784, NULL, '423f52ff-d9aa-40ba-8269-5cd8b6a4ef5e', 'withdrawal', 3500000.00, '2025-02-24', '15:49:30', NULL, 5250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 15:49:30', '2025-02-24 15:49:30', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22785, NULL, '423f52ff-d9aa-40ba-8269-5cd8b6a4ef5e', 'withdrawal', 3505250.00, '2025-02-24', '15:49:30', NULL, 5250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 15:49:30', '2025-02-24 15:49:30', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22788, NULL, '62ed8a75-d875-41e6-9232-2f87f081ed2d', 'withdrawal', 500000.00, '2025-02-24', '15:57:30', NULL, 0.00, 1, 'sarf k ahmed', NULL, NULL, NULL, NULL, '2025-02-24 15:57:30', '2025-02-24 15:57:30', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22789, NULL, '62ed8a75-d875-41e6-9232-2f87f081ed2d', 'withdrawal', 500000.00, '2025-02-24', '15:57:30', NULL, 0.00, 1, 'sarf k ahmed', NULL, NULL, NULL, NULL, '2025-02-24 15:57:30', '2025-02-24 15:57:30', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22790, NULL, '62ed8a75-d875-41e6-9232-2f87f081ed2d', 'deposit', 0.00, '2025-02-24', '15:57:30', 'Fee collected for withdrawal', 0.00, 1, 'sarf k ahmed', NULL, NULL, NULL, NULL, '2025-02-24 15:57:30', '2025-02-24 15:57:30', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22793, NULL, 'ede7dd07-433a-4462-a40d-2ebe757db3c8', 'deposit', 3500.00, '2025-02-24', '15:59:25', '', 0.00, 144, 'Sardar salh abdulla ', NULL, NULL, NULL, NULL, '2025-02-24 15:59:25', '2025-02-24 15:59:25', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22794, NULL, 'ede7dd07-433a-4462-a40d-2ebe757db3c8', 'deposit', 3500.00, '2025-02-24', '15:59:25', '', 0.00, 144, 'Sardar salh abdulla ', NULL, NULL, NULL, NULL, '2025-02-24 15:59:26', '2025-02-24 15:59:26', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22810, NULL, '225f70cb-beb6-46ef-b09c-f16ffa975b08', 'deposit', 1203000.00, '2025-02-24', '16:14:26', NULL, 3000.00, 1, 'ali qahtan-hawala', NULL, NULL, NULL, NULL, '2025-02-24 16:14:26', '2025-02-24 16:14:26', 78, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22811, NULL, '225f70cb-beb6-46ef-b09c-f16ffa975b08', 'deposit', 1203000.00, '2025-02-24', '16:14:26', NULL, 3000.00, 1, 'ali qahtan-hawala', NULL, NULL, NULL, NULL, '2025-02-24 16:14:26', '2025-02-24 16:14:26', 2, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22812, NULL, '225f70cb-beb6-46ef-b09c-f16ffa975b08', 'deposit', 3000.00, '2025-02-24', '16:14:26', 'Fee collected for deposit', 0.00, 1, 'ali qahtan-hawala', NULL, NULL, NULL, NULL, '2025-02-24 16:14:26', '2025-02-24 16:14:26', 23, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22813, NULL, '4ed69d27-09dd-4b40-a30f-cce27b29382a', 'withdrawal', 3000.00, '2025-02-24', '16:15:46', NULL, 3000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 16:15:46', '2025-02-24 16:15:46', 78, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22814, NULL, '4ed69d27-09dd-4b40-a30f-cce27b29382a', 'withdrawal', 3000.00, '2025-02-24', '16:15:46', NULL, 3000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 16:15:46', '2025-02-24 16:15:46', 2, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22815, NULL, '4ed69d27-09dd-4b40-a30f-cce27b29382a', 'deposit', 3000.00, '2025-02-24', '16:15:46', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 16:15:46', '2025-02-24 16:15:46', 23, 78, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22818, NULL, '4c9bc5d2-d600-48d3-9582-c44ad2d97f01', 'deposit', 1006000.00, '2025-02-24', '16:23:24', NULL, 6000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 16:23:24', '2025-02-24 16:23:24', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22819, NULL, '4c9bc5d2-d600-48d3-9582-c44ad2d97f01', 'deposit', 1006000.00, '2025-02-24', '16:23:24', NULL, 6000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 16:23:24', '2025-02-24 16:23:24', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22820, NULL, '4c9bc5d2-d600-48d3-9582-c44ad2d97f01', 'deposit', 6000.00, '2025-02-24', '16:23:24', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 16:23:24', '2025-02-24 16:23:24', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22823, NULL, 'f347dfff-a97c-48ad-9c38-be465b0ade90', 'withdrawal', 4278.00, '2025-02-24', '16:27:38', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:27:38', '2025-02-24 16:27:38', 237, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22824, NULL, 'f347dfff-a97c-48ad-9c38-be465b0ade90', 'withdrawal', 4278.00, '2025-02-24', '16:27:38', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:27:38', '2025-02-24 16:27:38', 1, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22825, NULL, 'f347dfff-a97c-48ad-9c38-be465b0ade90', 'deposit', 0.00, '2025-02-24', '16:27:38', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:27:38', '2025-02-24 16:27:38', 22, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22828, NULL, '50dabff3-8c29-42ce-a68e-b518e0858a60', 'withdrawal', 20000.00, '2025-02-24', '16:29:17', NULL, 0.00, 1, 'm.tolaz', NULL, NULL, NULL, NULL, '2025-02-24 16:29:17', '2025-02-24 16:29:17', 1145, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22829, NULL, '50dabff3-8c29-42ce-a68e-b518e0858a60', 'withdrawal', 20000.00, '2025-02-24', '16:29:17', NULL, 0.00, 1, 'm.tolaz', NULL, NULL, NULL, NULL, '2025-02-24 16:29:17', '2025-02-24 16:29:17', 1, 1145, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22830, NULL, '50dabff3-8c29-42ce-a68e-b518e0858a60', 'deposit', 0.00, '2025-02-24', '16:29:17', 'Fee collected for withdrawal', 0.00, 1, 'm.tolaz', NULL, NULL, NULL, NULL, '2025-02-24 16:29:17', '2025-02-24 16:29:17', 22, 1145, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22835, NULL, 'db238fbf-6af0-41f2-bb69-b6a398314dc6', 'deposit', 647.00, '2025-02-24', '16:33:45', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:33:45', '2025-02-24 16:33:45', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22836, NULL, 'db238fbf-6af0-41f2-bb69-b6a398314dc6', 'deposit', 647.00, '2025-02-24', '16:33:45', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:33:45', '2025-02-24 16:33:45', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22837, NULL, 'db238fbf-6af0-41f2-bb69-b6a398314dc6', 'deposit', 0.00, '2025-02-24', '16:33:45', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:33:45', '2025-02-24 16:33:45', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22838, NULL, '5bd66aab-22bf-436a-93ad-16ce8f9cb00f', 'deposit', 64.00, '2025-02-24', '16:34:14', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:34:14', '2025-02-24 16:34:14', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22839, NULL, '5bd66aab-22bf-436a-93ad-16ce8f9cb00f', 'deposit', 64.00, '2025-02-24', '16:34:14', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:34:14', '2025-02-24 16:34:14', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22840, NULL, '5bd66aab-22bf-436a-93ad-16ce8f9cb00f', 'deposit', 0.00, '2025-02-24', '16:34:14', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:34:14', '2025-02-24 16:34:14', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22845, NULL, 'b59a5102-0fd3-4c23-a11d-4e833eed8714', 'deposit', 32.00, '2025-02-24', '16:36:17', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:36:17', '2025-02-24 16:36:17', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22846, NULL, 'b59a5102-0fd3-4c23-a11d-4e833eed8714', 'deposit', 32.00, '2025-02-24', '16:36:17', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:36:17', '2025-02-24 16:36:17', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22847, NULL, 'b59a5102-0fd3-4c23-a11d-4e833eed8714', 'deposit', 0.00, '2025-02-24', '16:36:17', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 16:36:17', '2025-02-24 16:36:17', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22848, NULL, 'abe3516f-c50f-48af-af8c-4b573268d70a', 'withdrawal', 504.00, '2025-02-24', '16:39:16', NULL, 4.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-24 16:39:16', '2025-02-24 16:39:16', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22849, NULL, 'abe3516f-c50f-48af-af8c-4b573268d70a', 'withdrawal', 504.00, '2025-02-24', '16:39:16', NULL, 4.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-24 16:39:16', '2025-02-24 16:39:16', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22850, NULL, 'abe3516f-c50f-48af-af8c-4b573268d70a', 'deposit', 4.00, '2025-02-24', '16:39:16', 'Fee collected for withdrawal', 0.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-24 16:39:16', '2025-02-24 16:39:16', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22851, NULL, '61656bac-d245-41be-8222-7ef072b4a6e7', 'withdrawal', 20000.00, '2025-02-24', '16:40:02', NULL, 0.00, 132, 'Zreyan nuri ali ', NULL, NULL, NULL, NULL, '2025-02-24 16:40:02', '2025-02-24 16:40:02', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22852, NULL, '61656bac-d245-41be-8222-7ef072b4a6e7', 'withdrawal', 20000.00, '2025-02-24', '16:40:02', NULL, 0.00, 132, 'Zreyan nuri ali ', NULL, NULL, NULL, NULL, '2025-02-24 16:40:03', '2025-02-24 16:40:03', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22853, NULL, 'dfea5042-13c8-4a6c-8a7d-93eacaf524c8', 'withdrawal', 1010.00, '2025-02-24', '16:40:46', NULL, 10.00, 1, 'turkea-maher abdulsalam', NULL, NULL, NULL, NULL, '2025-02-24 16:40:46', '2025-02-24 16:40:46', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22854, NULL, 'dfea5042-13c8-4a6c-8a7d-93eacaf524c8', 'withdrawal', 1010.00, '2025-02-24', '16:40:46', NULL, 10.00, 1, 'turkea-maher abdulsalam', NULL, NULL, NULL, NULL, '2025-02-24 16:40:46', '2025-02-24 16:40:46', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22855, NULL, 'dfea5042-13c8-4a6c-8a7d-93eacaf524c8', 'deposit', 10.00, '2025-02-24', '16:40:46', 'Fee collected for withdrawal', 0.00, 1, 'turkea-maher abdulsalam', NULL, NULL, NULL, NULL, '2025-02-24 16:40:46', '2025-02-24 16:40:46', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22856, NULL, '258fc10d-2653-4542-acdb-94af513103fa', 'withdrawal', 20000.00, '2025-02-24', '16:46:00', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-24 16:46:00', '2025-02-24 16:46:00', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22857, NULL, '258fc10d-2653-4542-acdb-94af513103fa', 'deposit', 20000.00, '2025-02-24', '16:46:00', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-24 16:46:00', '2025-02-24 16:46:00', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22858, NULL, '258fc10d-2653-4542-acdb-94af513103fa', 'deposit', 29800000.00, '2025-02-24', '16:46:00', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-24 16:46:00', '2025-02-24 16:46:00', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22859, NULL, '258fc10d-2653-4542-acdb-94af513103fa', 'withdrawal', 29800000.00, '2025-02-24', '16:46:00', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-24 16:46:00', '2025-02-24 16:46:00', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22860, NULL, 'f871eb1e-23e2-4fc5-b311-29ca47ee46e0', 'withdrawal', 5000.00, '2025-02-24', '16:48:13', NULL, 5000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 16:48:13', '2025-02-24 16:48:13', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22861, NULL, 'f871eb1e-23e2-4fc5-b311-29ca47ee46e0', 'withdrawal', 5000.00, '2025-02-24', '16:48:13', NULL, 5000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 16:48:14', '2025-02-24 16:48:14', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22862, NULL, 'f871eb1e-23e2-4fc5-b311-29ca47ee46e0', 'deposit', 5000.00, '2025-02-24', '16:48:13', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-24 16:48:14', '2025-02-24 16:48:14', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22863, NULL, '89d68ddb-fec5-476a-8b56-1d978de4967a', 'deposit', 5017500.00, '2025-02-24', '16:49:21', NULL, 17500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 16:49:21', '2025-02-24 16:49:21', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22864, NULL, '89d68ddb-fec5-476a-8b56-1d978de4967a', 'deposit', 5017500.00, '2025-02-24', '16:49:21', NULL, 17500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 16:49:21', '2025-02-24 16:49:21', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22865, NULL, '89d68ddb-fec5-476a-8b56-1d978de4967a', 'deposit', 17500.00, '2025-02-24', '16:49:21', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 16:49:21', '2025-02-24 16:49:21', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22874, NULL, '6a60349c-b811-423c-a522-16452c99f965', 'withdrawal', 435750.00, '2025-02-24', '16:52:07', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 16:52:07', '2025-02-24 16:52:07', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22875, NULL, '6a60349c-b811-423c-a522-16452c99f965', 'withdrawal', 435000.00, '2025-02-24', '16:52:07', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 16:52:07', '2025-02-24 16:52:07', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22876, NULL, '6a60349c-b811-423c-a522-16452c99f965', 'withdrawal', 435750.00, '2025-02-24', '16:52:07', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 16:52:07', '2025-02-24 16:52:07', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22885, NULL, '13480d4d-553b-43d6-b5f6-0d172fc76939', 'deposit', 25000000.00, '2025-02-24', '17:06:18', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-24 17:06:18', '2025-02-24 17:06:18', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22886, NULL, '13480d4d-553b-43d6-b5f6-0d172fc76939', 'deposit', 25000000.00, '2025-02-24', '17:06:18', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-24 17:06:18', '2025-02-24 17:06:18', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22887, NULL, '13480d4d-553b-43d6-b5f6-0d172fc76939', 'deposit', 25000000.00, '2025-02-24', '17:06:18', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-24 17:06:18', '2025-02-24 17:06:18', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22890, NULL, '1ab37943-792f-46a5-b56f-1d493b31a157', 'withdrawal', 60370500.00, '2025-02-24', '17:07:19', NULL, 90500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 17:07:19', '2025-02-24 17:07:19', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22891, NULL, '1ab37943-792f-46a5-b56f-1d493b31a157', 'withdrawal', 60280000.00, '2025-02-24', '17:07:19', NULL, 90500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 17:07:19', '2025-02-24 17:07:19', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22892, NULL, '1ab37943-792f-46a5-b56f-1d493b31a157', 'withdrawal', 60370500.00, '2025-02-24', '17:07:19', NULL, 90500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 17:07:19', '2025-02-24 17:07:19', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22893, NULL, '664b5d66-95b7-450b-83a1-51a7c124c95b', 'withdrawal', 182750.00, '2025-02-24', '17:07:43', NULL, 250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 17:07:43', '2025-02-24 17:07:43', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22894, NULL, '664b5d66-95b7-450b-83a1-51a7c124c95b', 'withdrawal', 182500.00, '2025-02-24', '17:07:43', NULL, 250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 17:07:43', '2025-02-24 17:07:43', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22895, NULL, '664b5d66-95b7-450b-83a1-51a7c124c95b', 'withdrawal', 182750.00, '2025-02-24', '17:07:43', NULL, 250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-24 17:07:43', '2025-02-24 17:07:43', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22912, NULL, 'b7655f81-a693-47f5-a3d1-a377c39965ad', 'withdrawal', 1007000.00, '2025-02-24', '17:54:33', NULL, 7000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 17:54:33', '2025-02-24 17:54:33', 215, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22913, NULL, 'b7655f81-a693-47f5-a3d1-a377c39965ad', 'withdrawal', 1007000.00, '2025-02-24', '17:54:33', NULL, 7000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 17:54:33', '2025-02-24 17:54:33', 2, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22914, NULL, 'b7655f81-a693-47f5-a3d1-a377c39965ad', 'deposit', 7000.00, '2025-02-24', '17:54:33', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 17:54:33', '2025-02-24 17:54:33', 23, 215, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22945, NULL, 'b23ae48e-0afb-40e0-853a-72ee024629b4', 'deposit', 700.00, '2025-02-24', '18:27:33', NULL, 0.00, 1, 'k mustafa', NULL, NULL, NULL, NULL, '2025-02-24 18:27:33', '2025-02-24 18:27:33', 254, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22946, NULL, 'b23ae48e-0afb-40e0-853a-72ee024629b4', 'deposit', 700.00, '2025-02-24', '18:27:33', NULL, 0.00, 1, 'k mustafa', NULL, NULL, NULL, NULL, '2025-02-24 18:27:33', '2025-02-24 18:27:33', 1, 254, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22947, NULL, 'b23ae48e-0afb-40e0-853a-72ee024629b4', 'deposit', 0.00, '2025-02-24', '18:27:33', 'Fee collected for deposit', 0.00, 1, 'k mustafa', NULL, NULL, NULL, NULL, '2025-02-24 18:27:33', '2025-02-24 18:27:33', 22, 254, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22948, NULL, '3d256038-d49a-4b7b-bc8c-028124c0748e', 'deposit', 250000.00, '2025-02-24', '18:27:51', NULL, 0.00, 1, 'k mustafa', NULL, NULL, NULL, NULL, '2025-02-24 18:27:51', '2025-02-24 18:27:51', 253, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22949, NULL, '3d256038-d49a-4b7b-bc8c-028124c0748e', 'deposit', 250000.00, '2025-02-24', '18:27:51', NULL, 0.00, 1, 'k mustafa', NULL, NULL, NULL, NULL, '2025-02-24 18:27:51', '2025-02-24 18:27:51', 2, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22950, NULL, '3d256038-d49a-4b7b-bc8c-028124c0748e', 'deposit', 0.00, '2025-02-24', '18:27:51', 'Fee collected for deposit', 0.00, 1, 'k mustafa', NULL, NULL, NULL, NULL, '2025-02-24 18:27:51', '2025-02-24 18:27:51', 23, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22955, NULL, '25d90d9e-b5e8-4626-a63c-174e42c5d58a', 'deposit', 25150000.00, '2025-02-24', '18:39:57', NULL, 150000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 18:39:57', '2025-02-24 18:39:57', 453, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22956, NULL, '25d90d9e-b5e8-4626-a63c-174e42c5d58a', 'deposit', 25150000.00, '2025-02-24', '18:39:57', NULL, 150000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 18:39:57', '2025-02-24 18:39:57', 2, 453, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22957, NULL, '25d90d9e-b5e8-4626-a63c-174e42c5d58a', 'deposit', 150000.00, '2025-02-24', '18:39:57', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 18:39:57', '2025-02-24 18:39:57', 23, 453, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22960, NULL, '3072d695-edf2-47c4-ba34-00d71614a6f5', 'deposit', 20000.00, '2025-02-24', '18:44:50', NULL, 0.00, 1, 'm.tolaz', NULL, NULL, NULL, NULL, '2025-02-24 18:44:50', '2025-02-24 18:44:50', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(22961, NULL, '3072d695-edf2-47c4-ba34-00d71614a6f5', 'deposit', 20000.00, '2025-02-24', '18:44:50', NULL, 0.00, 1, 'm.tolaz', NULL, NULL, NULL, NULL, '2025-02-24 18:44:50', '2025-02-24 18:44:50', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22962, NULL, '3072d695-edf2-47c4-ba34-00d71614a6f5', 'deposit', 0.00, '2025-02-24', '18:44:50', 'Fee collected for deposit', 0.00, 1, 'm.tolaz', NULL, NULL, NULL, NULL, '2025-02-24 18:44:50', '2025-02-24 18:44:50', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22963, NULL, '619de9dd-686b-4d97-834d-845d78a6239d', 'deposit', 1008.00, '2025-02-24', '18:45:40', NULL, 8.00, 1, 'turkia-maher abdulsalam', NULL, NULL, NULL, NULL, '2025-02-24 18:45:40', '2025-02-24 18:45:40', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22964, NULL, '619de9dd-686b-4d97-834d-845d78a6239d', 'deposit', 1008.00, '2025-02-24', '18:45:40', NULL, 8.00, 1, 'turkia-maher abdulsalam', NULL, NULL, NULL, NULL, '2025-02-24 18:45:40', '2025-02-24 18:45:40', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22965, NULL, '619de9dd-686b-4d97-834d-845d78a6239d', 'deposit', 8.00, '2025-02-24', '18:45:40', 'Fee collected for deposit', 0.00, 1, 'turkia-maher abdulsalam', NULL, NULL, NULL, NULL, '2025-02-24 18:45:40', '2025-02-24 18:45:40', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22966, NULL, '2bf79bd1-67ea-4425-9407-1d4c9dca2977', 'withdrawal', 2090000.00, '2025-02-24', '18:45:59', NULL, 0.00, 1, 'zharawa', NULL, NULL, NULL, NULL, '2025-02-24 18:45:59', '2025-02-24 18:45:59', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22967, NULL, '2bf79bd1-67ea-4425-9407-1d4c9dca2977', 'withdrawal', 2090000.00, '2025-02-24', '18:45:59', NULL, 0.00, 1, 'zharawa', NULL, NULL, NULL, NULL, '2025-02-24 18:45:59', '2025-02-24 18:45:59', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22968, NULL, '2bf79bd1-67ea-4425-9407-1d4c9dca2977', 'deposit', 0.00, '2025-02-24', '18:45:59', 'Fee collected for withdrawal', 0.00, 1, 'zharawa', NULL, NULL, NULL, NULL, '2025-02-24 18:45:59', '2025-02-24 18:45:59', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22969, NULL, '3430922e-0714-4cc6-9f0e-ff1ee468fef4', 'deposit', 502.00, '2025-02-24', '18:46:30', NULL, 2.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-24 18:46:30', '2025-02-24 18:46:30', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22970, NULL, '3430922e-0714-4cc6-9f0e-ff1ee468fef4', 'deposit', 502.00, '2025-02-24', '18:46:30', NULL, 2.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-24 18:46:30', '2025-02-24 18:46:30', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22971, NULL, '3430922e-0714-4cc6-9f0e-ff1ee468fef4', 'deposit', 2.00, '2025-02-24', '18:46:30', 'Fee collected for deposit', 0.00, 1, 'slemani-sasan omer', NULL, NULL, NULL, NULL, '2025-02-24 18:46:30', '2025-02-24 18:46:30', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22980, NULL, '72f404ab-5440-4a3c-b3a0-fbbc327b617f', 'withdrawal', 20000.00, '2025-02-24', '18:47:33', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-24 18:47:33', '2025-02-24 18:47:33', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22981, NULL, '72f404ab-5440-4a3c-b3a0-fbbc327b617f', 'withdrawal', 20000.00, '2025-02-24', '18:47:33', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-24 18:47:33', '2025-02-24 18:47:33', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22982, NULL, '72f404ab-5440-4a3c-b3a0-fbbc327b617f', 'deposit', 0.00, '2025-02-24', '18:47:33', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-24 18:47:33', '2025-02-24 18:47:33', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22983, NULL, '43d67ed8-5402-4f6c-97e1-c109c5d85359', 'withdrawal', 30000000.00, '2025-02-24', '18:48:49', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-24 18:48:49', '2025-02-24 18:48:49', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22984, NULL, '43d67ed8-5402-4f6c-97e1-c109c5d85359', 'withdrawal', 30000000.00, '2025-02-24', '18:48:49', NULL, 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-24 18:48:49', '2025-02-24 18:48:49', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22985, NULL, '43d67ed8-5402-4f6c-97e1-c109c5d85359', 'deposit', 0.00, '2025-02-24', '18:48:49', 'Fee collected for withdrawal', 0.00, 1, 'muhamad salm', NULL, NULL, NULL, NULL, '2025-02-24 18:48:49', '2025-02-24 18:48:49', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22986, NULL, '765e1ec7-2ade-45e4-ac80-e84a2c78ffc5', 'deposit', 34920000.00, '2025-02-24', '18:50:40', NULL, 0.00, 1, 'k alan', NULL, NULL, NULL, NULL, '2025-02-24 18:50:40', '2025-02-24 18:50:40', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22987, NULL, '765e1ec7-2ade-45e4-ac80-e84a2c78ffc5', 'deposit', 34920000.00, '2025-02-24', '18:50:40', NULL, 0.00, 1, 'k alan', NULL, NULL, NULL, NULL, '2025-02-24 18:50:40', '2025-02-24 18:50:40', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22988, NULL, '765e1ec7-2ade-45e4-ac80-e84a2c78ffc5', 'deposit', 0.00, '2025-02-24', '18:50:40', 'Fee collected for deposit', 0.00, 1, 'k alan', NULL, NULL, NULL, NULL, '2025-02-24 18:50:40', '2025-02-24 18:50:40', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22995, NULL, '99ba3a2c-06ff-44fc-ae11-7c2fd3488c94', 'withdrawal', 30210000.00, '2025-02-24', '18:53:53', NULL, 210000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 18:53:53', '2025-02-24 18:53:53', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22996, NULL, '99ba3a2c-06ff-44fc-ae11-7c2fd3488c94', 'withdrawal', 30210000.00, '2025-02-24', '18:53:53', NULL, 210000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 18:53:53', '2025-02-24 18:53:53', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(22997, NULL, '99ba3a2c-06ff-44fc-ae11-7c2fd3488c94', 'deposit', 210000.00, '2025-02-24', '18:53:53', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-24 18:53:53', '2025-02-24 18:53:53', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23002, NULL, 'f3b583d4-b06e-4c60-9f36-d149063fb8c7', 'deposit', 50.00, '2025-02-24', '18:57:15', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 18:57:15', '2025-02-24 18:57:15', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23003, NULL, 'f3b583d4-b06e-4c60-9f36-d149063fb8c7', 'deposit', 50.00, '2025-02-24', '18:57:15', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 18:57:15', '2025-02-24 18:57:15', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23004, NULL, 'f3b583d4-b06e-4c60-9f36-d149063fb8c7', 'deposit', 0.00, '2025-02-24', '18:57:15', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-24 18:57:15', '2025-02-24 18:57:15', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23013, NULL, '6fa78dd9-2207-48cc-a71a-fd70c1149867', 'deposit', 2090000.00, '2025-02-24', '19:00:42', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 19:00:42', '2025-02-24 19:00:42', 292, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23014, NULL, '6fa78dd9-2207-48cc-a71a-fd70c1149867', 'deposit', 2090000.00, '2025-02-24', '19:00:42', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 19:00:42', '2025-02-24 19:00:42', 2, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23015, NULL, '6fa78dd9-2207-48cc-a71a-fd70c1149867', 'deposit', 0.00, '2025-02-24', '19:00:42', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-24 19:00:42', '2025-02-24 19:00:42', 23, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23072, NULL, '96ab9e1a-0e49-4b23-9d9a-0a01f83c9dd8', 'deposit', 3000.00, '2025-02-24', '20:24:51', '', 0.00, 144, 'Karzan sherzad', NULL, NULL, NULL, NULL, '2025-02-24 20:24:51', '2025-02-24 20:24:51', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23073, NULL, '96ab9e1a-0e49-4b23-9d9a-0a01f83c9dd8', 'deposit', 3000.00, '2025-02-24', '20:24:51', '', 0.00, 144, 'Karzan sherzad', NULL, NULL, NULL, NULL, '2025-02-24 20:24:51', '2025-02-24 20:24:51', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23086, NULL, '9be896a9-d102-454c-a0a9-65146854ca38', 'deposit', 10500.00, '2025-02-25', '09:29:16', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-25 09:29:16', '2025-02-25 09:29:16', 199, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23087, NULL, '9be896a9-d102-454c-a0a9-65146854ca38', 'deposit', 10500.00, '2025-02-25', '09:29:16', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-25 09:29:16', '2025-02-25 09:29:16', 2, 199, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23088, NULL, '9be896a9-d102-454c-a0a9-65146854ca38', 'deposit', 0.00, '2025-02-25', '09:29:16', 'Fee collected for deposit', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-25 09:29:16', '2025-02-25 09:29:16', 23, 199, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23089, NULL, '223c5e30-744b-46a6-ad03-6a975ea94845', 'withdrawal', 7.00, '2025-02-25', '09:29:17', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-25 09:29:17', '2025-02-25 09:29:17', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23090, NULL, '223c5e30-744b-46a6-ad03-6a975ea94845', 'withdrawal', 7.00, '2025-02-25', '09:29:17', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-25 09:29:17', '2025-02-25 09:29:17', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23091, NULL, '223c5e30-744b-46a6-ad03-6a975ea94845', 'deposit', 0.00, '2025-02-25', '09:29:17', 'Fee collected for withdrawal', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-25 09:29:17', '2025-02-25 09:29:17', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23092, NULL, '4d791f04-29ac-4365-93de-739989103573', 'deposit', 25150000.00, '2025-02-25', '09:31:42', NULL, 0.00, 1, 'maktab kani', NULL, NULL, NULL, NULL, '2025-02-25 09:31:42', '2025-02-25 09:31:42', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23093, NULL, '4d791f04-29ac-4365-93de-739989103573', 'deposit', 25150000.00, '2025-02-25', '09:31:42', NULL, 0.00, 1, 'maktab kani', NULL, NULL, NULL, NULL, '2025-02-25 09:31:42', '2025-02-25 09:31:42', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23094, NULL, '4d791f04-29ac-4365-93de-739989103573', 'deposit', 0.00, '2025-02-25', '09:31:42', 'Fee collected for deposit', 0.00, 1, 'maktab kani', NULL, NULL, NULL, NULL, '2025-02-25 09:31:42', '2025-02-25 09:31:42', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23107, NULL, '3d3f68de-6665-46c4-9c6c-59674e5dd284', 'deposit', 3002.00, '2025-02-25', '09:33:04', NULL, 0.00, 1, 'sarf aso', NULL, NULL, NULL, NULL, '2025-02-25 09:33:04', '2025-02-25 09:33:04', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23108, NULL, '3d3f68de-6665-46c4-9c6c-59674e5dd284', 'deposit', 3002.00, '2025-02-25', '09:33:04', NULL, 0.00, 1, 'sarf aso', NULL, NULL, NULL, NULL, '2025-02-25 09:33:04', '2025-02-25 09:33:04', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23109, NULL, '3d3f68de-6665-46c4-9c6c-59674e5dd284', 'deposit', 0.00, '2025-02-25', '09:33:04', 'Fee collected for deposit', 0.00, 1, 'sarf aso', NULL, NULL, NULL, NULL, '2025-02-25 09:33:04', '2025-02-25 09:33:04', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23116, NULL, '5f835fdf-91a7-48e3-b2e5-6075fae1e410', 'deposit', 1.00, '2025-02-25', '09:38:16', NULL, 1.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-25 09:38:16', '2025-02-25 09:38:16', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23117, NULL, '5f835fdf-91a7-48e3-b2e5-6075fae1e410', 'deposit', 1.00, '2025-02-25', '09:38:16', NULL, 1.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-25 09:38:16', '2025-02-25 09:38:16', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23118, NULL, '5f835fdf-91a7-48e3-b2e5-6075fae1e410', 'deposit', 1.00, '2025-02-25', '09:38:16', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-25 09:38:16', '2025-02-25 09:38:16', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23119, NULL, '08923395-bfc8-4fa1-b831-a76220fdf62a', 'deposit', 9150000.00, '2025-02-25', '09:45:15', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-25 09:45:15', '2025-02-25 09:45:15', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23120, NULL, '08923395-bfc8-4fa1-b831-a76220fdf62a', 'deposit', 9150000.00, '2025-02-25', '09:45:15', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-25 09:45:15', '2025-02-25 09:45:15', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23121, NULL, '08923395-bfc8-4fa1-b831-a76220fdf62a', 'deposit', 0.00, '2025-02-25', '09:45:15', 'Fee collected for deposit', 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-25 09:45:15', '2025-02-25 09:45:15', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23122, NULL, 'ad34d1b6-3f73-4321-8246-fdebb7f7480a', 'withdrawal', 25150000.00, '2025-02-25', '09:46:31', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-25 09:46:31', '2025-02-25 09:46:31', 453, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23123, NULL, 'ad34d1b6-3f73-4321-8246-fdebb7f7480a', 'withdrawal', 25150000.00, '2025-02-25', '09:46:31', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-25 09:46:31', '2025-02-25 09:46:31', 2, 453, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23124, NULL, 'ad34d1b6-3f73-4321-8246-fdebb7f7480a', 'deposit', 0.00, '2025-02-25', '09:46:31', 'Fee collected for withdrawal', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-25 09:46:31', '2025-02-25 09:46:31', 23, 453, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23125, NULL, '3cfe9691-ec6a-43f9-be6a-b1fd399fce9e', 'withdrawal', 3002.00, '2025-02-25', '09:48:07', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-25 09:48:07', '2025-02-25 09:48:07', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23126, NULL, '3cfe9691-ec6a-43f9-be6a-b1fd399fce9e', 'withdrawal', 3002.00, '2025-02-25', '09:48:07', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-25 09:48:07', '2025-02-25 09:48:07', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23127, NULL, '3cfe9691-ec6a-43f9-be6a-b1fd399fce9e', 'deposit', 0.00, '2025-02-25', '09:48:07', 'Fee collected for withdrawal', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-25 09:48:07', '2025-02-25 09:48:07', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23240, NULL, '03b62d87-8d13-4576-8d51-65db8bce6215', 'deposit', 13850000.00, '2025-02-25', '12:49:06', NULL, 0.00, 132, 'suhaeb Ahmad hadi', NULL, NULL, NULL, NULL, '2025-02-25 12:49:06', '2025-02-25 12:49:06', 451, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23241, NULL, '03b62d87-8d13-4576-8d51-65db8bce6215', 'deposit', 13850000.00, '2025-02-25', '12:49:06', NULL, 0.00, 132, 'suhaeb Ahmad hadi', NULL, NULL, NULL, NULL, '2025-02-25 12:49:06', '2025-02-25 12:49:06', 2, 451, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23268, NULL, '9f2d8c8d-ae7c-4cc4-9e96-fe45dc2e95cc', 'deposit', 1500.00, '2025-02-25', '14:12:58', NULL, 0.00, 132, 'shawqi muhamad hamed', NULL, NULL, NULL, NULL, '2025-02-25 14:12:58', '2025-02-25 14:12:58', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23269, NULL, '9f2d8c8d-ae7c-4cc4-9e96-fe45dc2e95cc', 'deposit', 1500.00, '2025-02-25', '14:12:58', NULL, 0.00, 132, 'shawqi muhamad hamed', NULL, NULL, NULL, NULL, '2025-02-25 14:12:58', '2025-02-25 14:12:58', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23286, NULL, 'a1362f63-9f2d-4b7a-b4f6-7306adaaed93', 'withdrawal', 7021000.00, '2025-02-25', '14:54:33', NULL, 21000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:54:33', '2025-02-25 14:54:33', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23287, NULL, 'a1362f63-9f2d-4b7a-b4f6-7306adaaed93', 'withdrawal', 7000000.00, '2025-02-25', '14:54:33', NULL, 21000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:54:33', '2025-02-25 14:54:33', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23288, NULL, 'a1362f63-9f2d-4b7a-b4f6-7306adaaed93', 'withdrawal', 7021000.00, '2025-02-25', '14:54:33', NULL, 21000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:54:33', '2025-02-25 14:54:33', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23293, NULL, 'de9f5b0e-657e-476d-a9c1-c35ed37d967d', 'withdrawal', 925500.00, '2025-02-25', '14:55:57', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:55:57', '2025-02-25 14:55:57', 216, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23294, NULL, 'de9f5b0e-657e-476d-a9c1-c35ed37d967d', 'withdrawal', 924000.00, '2025-02-25', '14:55:57', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:55:58', '2025-02-25 14:55:58', 18, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23295, NULL, 'de9f5b0e-657e-476d-a9c1-c35ed37d967d', 'withdrawal', 925500.00, '2025-02-25', '14:55:57', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:55:58', '2025-02-25 14:55:58', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23296, NULL, 'a14426a3-977c-4755-81c6-16ce30ec3305', 'withdrawal', 5248000.00, '2025-02-25', '14:56:28', NULL, 8000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:56:28', '2025-02-25 14:56:28', 216, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23297, NULL, 'a14426a3-977c-4755-81c6-16ce30ec3305', 'withdrawal', 5240000.00, '2025-02-25', '14:56:28', NULL, 8000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:56:28', '2025-02-25 14:56:28', 18, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23298, NULL, 'a14426a3-977c-4755-81c6-16ce30ec3305', 'withdrawal', 5248000.00, '2025-02-25', '14:56:28', NULL, 8000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:56:28', '2025-02-25 14:56:28', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23303, NULL, '92ee69bd-863a-4958-9fce-db5a62701fd1', 'withdrawal', 10438.00, '2025-02-25', '14:57:03', NULL, 438.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:57:03', '2025-02-25 14:57:03', 216, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23304, NULL, '92ee69bd-863a-4958-9fce-db5a62701fd1', 'withdrawal', 10000.00, '2025-02-25', '14:57:03', NULL, 438.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:57:03', '2025-02-25 14:57:03', 18, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23305, NULL, '92ee69bd-863a-4958-9fce-db5a62701fd1', 'withdrawal', 10438.00, '2025-02-25', '14:57:03', NULL, 438.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:57:03', '2025-02-25 14:57:03', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23314, NULL, 'ae76361e-4a3f-4f16-a1cd-4565fe5edc59', 'withdrawal', 1750000.00, '2025-02-25', '14:59:40', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:59:40', '2025-02-25 14:59:40', 1102, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23315, NULL, 'ae76361e-4a3f-4f16-a1cd-4565fe5edc59', 'withdrawal', 1750000.00, '2025-02-25', '14:59:40', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:59:40', '2025-02-25 14:59:40', 18, 1102, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23316, NULL, 'ae76361e-4a3f-4f16-a1cd-4565fe5edc59', 'withdrawal', 1750000.00, '2025-02-25', '14:59:40', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 14:59:40', '2025-02-25 14:59:40', 2, 1102, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23317, NULL, 'd1e1767e-2383-4cbf-9906-92bbdef3d630', 'withdrawal', 2750.00, '2025-02-25', '15:07:52', NULL, 2750.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-25 15:07:52', '2025-02-25 15:07:52', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23318, NULL, 'd1e1767e-2383-4cbf-9906-92bbdef3d630', 'withdrawal', 2750.00, '2025-02-25', '15:07:52', NULL, 2750.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-25 15:07:52', '2025-02-25 15:07:52', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23319, NULL, 'd1e1767e-2383-4cbf-9906-92bbdef3d630', 'deposit', 2750.00, '2025-02-25', '15:07:52', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-25 15:07:52', '2025-02-25 15:07:52', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23322, NULL, '76c3b037-b44b-4428-af98-4c5e237d6aaa', 'withdrawal', 1502250.00, '2025-02-25', '15:09:10', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 15:09:10', '2025-02-25 15:09:10', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23323, NULL, '76c3b037-b44b-4428-af98-4c5e237d6aaa', 'withdrawal', 1500000.00, '2025-02-25', '15:09:10', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 15:09:10', '2025-02-25 15:09:10', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23324, NULL, '76c3b037-b44b-4428-af98-4c5e237d6aaa', 'withdrawal', 1502250.00, '2025-02-25', '15:09:10', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-25 15:09:10', '2025-02-25 15:09:10', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23325, NULL, 'f24ee0a3-2360-443b-ad86-a95296cc7e69', 'deposit', 15000000.00, '2025-02-25', '15:09:35', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-25 15:09:35', '2025-02-25 15:09:35', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23326, NULL, 'f24ee0a3-2360-443b-ad86-a95296cc7e69', 'deposit', 15000000.00, '2025-02-25', '15:09:35', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-25 15:09:35', '2025-02-25 15:09:35', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23327, NULL, 'f24ee0a3-2360-443b-ad86-a95296cc7e69', 'deposit', 15000000.00, '2025-02-25', '15:09:35', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-02-25 15:09:35', '2025-02-25 15:09:35', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23328, NULL, 'b81ac517-64d7-4706-be90-696e67552508', 'deposit', 4174.00, '2025-02-25', '15:12:16', NULL, 2.00, 1, 'slemani-fredun nuraden', NULL, NULL, NULL, NULL, '2025-02-25 15:12:16', '2025-02-25 15:12:16', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23329, NULL, 'b81ac517-64d7-4706-be90-696e67552508', 'deposit', 4174.00, '2025-02-25', '15:12:16', NULL, 2.00, 1, 'slemani-fredun nuraden', NULL, NULL, NULL, NULL, '2025-02-25 15:12:16', '2025-02-25 15:12:16', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23330, NULL, 'b81ac517-64d7-4706-be90-696e67552508', 'deposit', 2.00, '2025-02-25', '15:12:16', 'Fee collected for deposit', 0.00, 1, 'slemani-fredun nuraden', NULL, NULL, NULL, NULL, '2025-02-25 15:12:16', '2025-02-25 15:12:16', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23433, NULL, 'b35832b8-0ad8-47c7-a088-d2c0f8c97104', 'withdrawal', 2645000.00, '2025-02-25', '18:17:00', NULL, 0.00, 136, 'farhang sarbaz', NULL, NULL, NULL, NULL, '2025-02-25 18:17:00', '2025-02-25 18:17:00', 241, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23434, NULL, 'b35832b8-0ad8-47c7-a088-d2c0f8c97104', 'withdrawal', 2645000.00, '2025-02-25', '18:17:00', NULL, 0.00, 136, 'farhang sarbaz', NULL, NULL, NULL, NULL, '2025-02-25 18:17:00', '2025-02-25 18:17:00', 2, 241, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23447, NULL, '37296129-2b5d-4fee-8ccb-51e19b1c067f', 'withdrawal', 6015000.00, '2025-02-25', '18:24:36', NULL, 15000.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-25 18:24:36', '2025-02-25 18:24:36', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23448, NULL, '37296129-2b5d-4fee-8ccb-51e19b1c067f', 'withdrawal', 6000000.00, '2025-02-25', '18:24:36', NULL, 15000.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-25 18:24:36', '2025-02-25 18:24:36', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23449, NULL, '37296129-2b5d-4fee-8ccb-51e19b1c067f', 'withdrawal', 6015000.00, '2025-02-25', '18:24:36', NULL, 15000.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-25 18:24:36', '2025-02-25 18:24:36', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23450, NULL, '69477724-3b25-4599-94b0-5bdc5c2ea440', 'withdrawal', 5516500.00, '2025-02-25', '18:25:23', NULL, 16500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-25 18:25:23', '2025-02-25 18:25:23', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23451, NULL, '69477724-3b25-4599-94b0-5bdc5c2ea440', 'withdrawal', 5500000.00, '2025-02-25', '18:25:23', NULL, 16500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-25 18:25:23', '2025-02-25 18:25:23', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23452, NULL, '69477724-3b25-4599-94b0-5bdc5c2ea440', 'withdrawal', 5516500.00, '2025-02-25', '18:25:23', NULL, 16500.00, 1, 'Zain cash', NULL, NULL, NULL, NULL, '2025-02-25 18:25:23', '2025-02-25 18:25:23', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23453, NULL, '050d1574-7739-4f07-a2b6-b7fe889a2566', 'withdrawal', 501500.00, '2025-02-25', '18:25:49', NULL, 1500.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-25 18:25:49', '2025-02-25 18:25:49', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23454, NULL, '050d1574-7739-4f07-a2b6-b7fe889a2566', 'withdrawal', 500000.00, '2025-02-25', '18:25:49', NULL, 1500.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-25 18:25:49', '2025-02-25 18:25:49', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23455, NULL, '050d1574-7739-4f07-a2b6-b7fe889a2566', 'withdrawal', 501500.00, '2025-02-25', '18:25:49', NULL, 1500.00, 1, 'Zaincash', NULL, NULL, NULL, NULL, '2025-02-25 18:25:49', '2025-02-25 18:25:49', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23516, NULL, '81bc18b2-89dd-4025-9e55-ae2ff0ea4771', 'deposit', 20000000.00, '2025-02-25', '20:03:31', NULL, 0.00, 137, 'Basm', NULL, NULL, NULL, NULL, '2025-02-25 20:03:31', '2025-02-25 20:03:31', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23517, NULL, '81bc18b2-89dd-4025-9e55-ae2ff0ea4771', 'deposit', 20000000.00, '2025-02-25', '20:03:31', NULL, 0.00, 137, 'Basm', NULL, NULL, NULL, NULL, '2025-02-25 20:03:31', '2025-02-25 20:03:31', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23732, NULL, '80d58c8b-3e2a-4881-90cc-f126dc19458c', 'withdrawal', 10000.00, '2025-02-26', '13:08:15', NULL, 0.00, 132, 'Zreyan nuri ali ', NULL, NULL, NULL, NULL, '2025-02-26 13:08:15', '2025-02-26 13:08:15', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(23733, NULL, '80d58c8b-3e2a-4881-90cc-f126dc19458c', 'withdrawal', 10000.00, '2025-02-26', '13:08:15', NULL, 0.00, 132, 'Zreyan nuri ali ', NULL, NULL, NULL, NULL, '2025-02-26 13:08:15', '2025-02-26 13:08:15', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23792, NULL, 'f2065ebf-acd6-4fe2-83c4-89f7e238d827', 'deposit', 500000.00, '2025-02-26', '15:17:43', NULL, 0.00, 1, 'ma3ash ki card', NULL, NULL, NULL, NULL, '2025-02-26 15:17:43', '2025-02-26 15:17:43', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23793, NULL, 'f2065ebf-acd6-4fe2-83c4-89f7e238d827', 'deposit', 500000.00, '2025-02-26', '15:17:43', NULL, 0.00, 1, 'ma3ash ki card', NULL, NULL, NULL, NULL, '2025-02-26 15:17:43', '2025-02-26 15:17:43', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23794, NULL, 'f2065ebf-acd6-4fe2-83c4-89f7e238d827', 'deposit', 0.00, '2025-02-26', '15:17:43', 'Fee collected for deposit', 0.00, 1, 'ma3ash ki card', NULL, NULL, NULL, NULL, '2025-02-26 15:17:43', '2025-02-26 15:17:43', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23795, NULL, '48de6eda-24e8-43ce-b732-1a6fe710041a', 'withdrawal', 5487.00, '2025-02-26', '15:19:10', NULL, -13.00, 1, 'gurkan dogru', NULL, NULL, NULL, NULL, '2025-02-26 15:19:10', '2025-02-26 15:19:10', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23796, NULL, '48de6eda-24e8-43ce-b732-1a6fe710041a', 'withdrawal', 5487.00, '2025-02-26', '15:19:10', NULL, -13.00, 1, 'gurkan dogru', NULL, NULL, NULL, NULL, '2025-02-26 15:19:10', '2025-02-26 15:19:10', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23797, NULL, '48de6eda-24e8-43ce-b732-1a6fe710041a', 'deposit', -13.00, '2025-02-26', '15:19:10', 'Fee collected for withdrawal', 0.00, 1, 'gurkan dogru', NULL, NULL, NULL, NULL, '2025-02-26 15:19:10', '2025-02-26 15:19:10', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23806, NULL, '5a07db39-5664-4825-bcc1-9ca68f4f6391', 'withdrawal', 2008.00, '2025-02-26', '15:30:36', NULL, 8.00, 1, 'musa amer mansur', NULL, NULL, NULL, NULL, '2025-02-26 15:30:36', '2025-02-26 15:30:36', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23807, NULL, '5a07db39-5664-4825-bcc1-9ca68f4f6391', 'withdrawal', 2008.00, '2025-02-26', '15:30:36', NULL, 8.00, 1, 'musa amer mansur', NULL, NULL, NULL, NULL, '2025-02-26 15:30:36', '2025-02-26 15:30:36', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23808, NULL, '5a07db39-5664-4825-bcc1-9ca68f4f6391', 'deposit', 8.00, '2025-02-26', '15:30:36', 'Fee collected for withdrawal', 0.00, 1, 'musa amer mansur', NULL, NULL, NULL, NULL, '2025-02-26 15:30:36', '2025-02-26 15:30:36', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23809, NULL, '5acbef54-4328-4011-8a1d-6d2ccfc0fb66', 'deposit', 2700.00, '2025-02-26', '15:31:46', NULL, 0.00, 1, 'kak husain', NULL, NULL, NULL, NULL, '2025-02-26 15:31:46', '2025-02-26 15:31:46', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23810, NULL, '5acbef54-4328-4011-8a1d-6d2ccfc0fb66', 'deposit', 2700.00, '2025-02-26', '15:31:46', NULL, 0.00, 1, 'kak husain', NULL, NULL, NULL, NULL, '2025-02-26 15:31:46', '2025-02-26 15:31:46', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23811, NULL, '5acbef54-4328-4011-8a1d-6d2ccfc0fb66', 'deposit', 0.00, '2025-02-26', '15:31:46', 'Fee collected for deposit', 0.00, 1, 'kak husain', NULL, NULL, NULL, NULL, '2025-02-26 15:31:46', '2025-02-26 15:31:46', 22, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23812, NULL, '6afd853b-620b-40fa-847b-2e83de4959f7', 'deposit', 14000000.00, '2025-02-26', '15:32:16', NULL, 0.00, 1, 'kak husain', NULL, NULL, NULL, NULL, '2025-02-26 15:32:16', '2025-02-26 15:32:16', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23813, NULL, '6afd853b-620b-40fa-847b-2e83de4959f7', 'deposit', 14000000.00, '2025-02-26', '15:32:16', NULL, 0.00, 1, 'kak husain', NULL, NULL, NULL, NULL, '2025-02-26 15:32:16', '2025-02-26 15:32:16', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23814, NULL, '6afd853b-620b-40fa-847b-2e83de4959f7', 'deposit', 0.00, '2025-02-26', '15:32:16', 'Fee collected for deposit', 0.00, 1, 'kak husain', NULL, NULL, NULL, NULL, '2025-02-26 15:32:16', '2025-02-26 15:32:16', 23, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23815, NULL, 'a5564466-5198-484c-ae71-e36c01b9d02a', 'withdrawal', 9308.00, '2025-02-26', '15:32:51', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-26 15:32:51', '2025-02-26 15:32:51', 1, 87, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23816, NULL, 'a5564466-5198-484c-ae71-e36c01b9d02a', 'deposit', 9308.00, '2025-02-26', '15:32:51', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-26 15:32:51', '2025-02-26 15:32:51', 87, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23817, NULL, 'a5564466-5198-484c-ae71-e36c01b9d02a', 'deposit', 13868920.00, '2025-02-26', '15:32:51', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-26 15:32:51', '2025-02-26 15:32:51', 2, 86, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23818, NULL, 'a5564466-5198-484c-ae71-e36c01b9d02a', 'withdrawal', 13868920.00, '2025-02-26', '15:32:51', 'شکانەوە لەسەر داواکاری خۆی', 1490.00, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-26 15:32:51', '2025-02-26 15:32:51', 86, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23861, NULL, 'bdc8b337-726f-4167-a43e-da6c1d32b6eb', 'withdrawal', 300.00, '2025-02-26', '16:06:46', NULL, 0.00, 132, 'Triska jamil maghded', NULL, NULL, NULL, NULL, '2025-02-26 16:06:46', '2025-02-26 16:06:46', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23862, NULL, 'bdc8b337-726f-4167-a43e-da6c1d32b6eb', 'withdrawal', 300.00, '2025-02-26', '16:06:46', NULL, 0.00, 132, 'Triska jamil maghded', NULL, NULL, NULL, NULL, '2025-02-26 16:06:46', '2025-02-26 16:06:46', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23881, NULL, 'def99c0a-77d7-4e01-bc70-a7d6860bbfdf', 'deposit', 1750000.00, '2025-02-26', '17:57:12', NULL, 0.00, 1, 'k muhamad sabah', NULL, NULL, NULL, NULL, '2025-02-26 17:57:12', '2025-02-26 17:57:12', 1102, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23882, NULL, 'def99c0a-77d7-4e01-bc70-a7d6860bbfdf', 'deposit', 1750000.00, '2025-02-26', '17:57:12', NULL, 0.00, 1, 'k muhamad sabah', NULL, NULL, NULL, NULL, '2025-02-26 17:57:12', '2025-02-26 17:57:12', 2, 1102, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23883, NULL, 'def99c0a-77d7-4e01-bc70-a7d6860bbfdf', 'deposit', 0.00, '2025-02-26', '17:57:12', 'Fee collected for deposit', 0.00, 1, 'k muhamad sabah', NULL, NULL, NULL, NULL, '2025-02-26 17:57:12', '2025-02-26 17:57:12', 23, 1102, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23884, NULL, '9274d29a-591e-4505-a2d5-0259ccccff19', 'withdrawal', 13850000.00, '2025-02-26', '17:58:46', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-26 17:58:46', '2025-02-26 17:58:46', 451, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23885, NULL, '9274d29a-591e-4505-a2d5-0259ccccff19', 'withdrawal', 13850000.00, '2025-02-26', '17:58:46', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-26 17:58:46', '2025-02-26 17:58:46', 2, 451, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23886, NULL, '9274d29a-591e-4505-a2d5-0259ccccff19', 'deposit', 0.00, '2025-02-26', '17:58:46', 'Fee collected for withdrawal', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-26 17:58:46', '2025-02-26 17:58:46', 23, 451, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23887, NULL, 'b3ad9d11-bf08-4b62-9437-2d7e117078fc', 'deposit', 9311.00, '2025-02-26', '17:59:32', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-26 17:59:32', '2025-02-26 17:59:32', 452, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23888, NULL, 'b3ad9d11-bf08-4b62-9437-2d7e117078fc', 'deposit', 9311.00, '2025-02-26', '17:59:32', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-26 17:59:32', '2025-02-26 17:59:32', 1, 452, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23889, NULL, 'b3ad9d11-bf08-4b62-9437-2d7e117078fc', 'deposit', 0.00, '2025-02-26', '17:59:32', 'Fee collected for deposit', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-26 17:59:32', '2025-02-26 17:59:32', 22, 452, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23890, NULL, '3e339724-cfa9-4630-ae2f-4d78d36bcd47', 'deposit', 8160.00, '2025-02-26', '18:01:13', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-26 18:01:13', '2025-02-26 18:01:13', 271, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23891, NULL, '3e339724-cfa9-4630-ae2f-4d78d36bcd47', 'deposit', 8160.00, '2025-02-26', '18:01:13', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-26 18:01:13', '2025-02-26 18:01:13', 1, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23892, NULL, '3e339724-cfa9-4630-ae2f-4d78d36bcd47', 'deposit', 0.00, '2025-02-26', '18:01:13', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-26 18:01:13', '2025-02-26 18:01:13', 22, 271, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23893, NULL, 'e2c00f8a-596f-4b4b-8d0d-a65c946a5626', 'deposit', 1200.00, '2025-02-26', '18:02:28', NULL, 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-26 18:02:28', '2025-02-26 18:02:28', 265, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23894, NULL, 'e2c00f8a-596f-4b4b-8d0d-a65c946a5626', 'deposit', 1200.00, '2025-02-26', '18:02:28', NULL, 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-26 18:02:28', '2025-02-26 18:02:28', 1, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23895, NULL, 'e2c00f8a-596f-4b4b-8d0d-a65c946a5626', 'deposit', 0.00, '2025-02-26', '18:02:28', 'Fee collected for deposit', 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-26 18:02:28', '2025-02-26 18:02:28', 22, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23896, NULL, '785dcd1e-58ee-4a37-b413-f47ed059b885', 'deposit', 2400000.00, '2025-02-26', '18:02:29', NULL, 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-26 18:02:29', '2025-02-26 18:02:29', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23897, NULL, '785dcd1e-58ee-4a37-b413-f47ed059b885', 'deposit', 2400000.00, '2025-02-26', '18:02:29', NULL, 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-26 18:02:29', '2025-02-26 18:02:29', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23898, NULL, '785dcd1e-58ee-4a37-b413-f47ed059b885', 'deposit', 0.00, '2025-02-26', '18:02:29', 'Fee collected for deposit', 0.00, 1, 'k hemn', NULL, NULL, NULL, NULL, '2025-02-26 18:02:29', '2025-02-26 18:02:29', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23899, NULL, 'c5f02445-accc-4ba5-9485-2272dff37888', 'deposit', 2005.00, '2025-02-26', '18:03:51', NULL, 5.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-26 18:03:51', '2025-02-26 18:03:51', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23900, NULL, 'c5f02445-accc-4ba5-9485-2272dff37888', 'deposit', 2005.00, '2025-02-26', '18:03:51', NULL, 5.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-26 18:03:51', '2025-02-26 18:03:51', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23901, NULL, 'c5f02445-accc-4ba5-9485-2272dff37888', 'deposit', 5.00, '2025-02-26', '18:03:51', 'Fee collected for deposit', 0.00, 1, 'musa aamr-shorja', NULL, NULL, NULL, NULL, '2025-02-26 18:03:51', '2025-02-26 18:03:51', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23902, NULL, 'bee652ee-002a-4c31-92ea-c68738f5d5ef', 'deposit', 5010000.00, '2025-02-26', '18:04:33', NULL, 10000.00, 1, 'heder abbas-shorja', NULL, NULL, NULL, NULL, '2025-02-26 18:04:33', '2025-02-26 18:04:33', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23903, NULL, 'bee652ee-002a-4c31-92ea-c68738f5d5ef', 'deposit', 5010000.00, '2025-02-26', '18:04:33', NULL, 10000.00, 1, 'heder abbas-shorja', NULL, NULL, NULL, NULL, '2025-02-26 18:04:33', '2025-02-26 18:04:33', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23904, NULL, 'bee652ee-002a-4c31-92ea-c68738f5d5ef', 'deposit', 10000.00, '2025-02-26', '18:04:33', 'Fee collected for deposit', 0.00, 1, 'heder abbas-shorja', NULL, NULL, NULL, NULL, '2025-02-26 18:04:33', '2025-02-26 18:04:33', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23905, NULL, '51e9bc66-3866-48f4-adf4-0b924603c019', 'withdrawal', 4176.00, '2025-02-26', '18:06:27', NULL, 4.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-26 18:06:27', '2025-02-26 18:06:27', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23906, NULL, '51e9bc66-3866-48f4-adf4-0b924603c019', 'withdrawal', 4176.00, '2025-02-26', '18:06:27', NULL, 4.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-26 18:06:27', '2025-02-26 18:06:27', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23907, NULL, '51e9bc66-3866-48f4-adf4-0b924603c019', 'deposit', 4.00, '2025-02-26', '18:06:27', 'Fee collected for withdrawal', 0.00, 1, 'slemani-faraydun nuraden', NULL, NULL, NULL, NULL, '2025-02-26 18:06:27', '2025-02-26 18:06:27', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23908, NULL, '7508b203-da89-45e5-8c8a-5332c043e156', 'deposit', 800.00, '2025-02-26', '18:06:52', NULL, 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-26 18:06:52', '2025-02-26 18:06:52', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23909, NULL, '7508b203-da89-45e5-8c8a-5332c043e156', 'deposit', 800.00, '2025-02-26', '18:06:52', NULL, 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-26 18:06:52', '2025-02-26 18:06:52', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23910, NULL, '7508b203-da89-45e5-8c8a-5332c043e156', 'deposit', 0.00, '2025-02-26', '18:06:52', 'Fee collected for deposit', 0.00, 1, 'k karwan', NULL, NULL, NULL, NULL, '2025-02-26 18:06:52', '2025-02-26 18:06:52', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23911, NULL, 'bfc8606e-ad93-464c-a37c-455f5a784eb2', 'withdrawal', 1500.00, '2025-02-26', '18:07:23', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-26 18:07:23', '2025-02-26 18:07:23', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23912, NULL, 'bfc8606e-ad93-464c-a37c-455f5a784eb2', 'withdrawal', 1500.00, '2025-02-26', '18:07:23', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-26 18:07:23', '2025-02-26 18:07:23', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23913, NULL, 'bfc8606e-ad93-464c-a37c-455f5a784eb2', 'deposit', 0.00, '2025-02-26', '18:07:23', 'Fee collected for withdrawal', 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-02-26 18:07:23', '2025-02-26 18:07:23', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23917, NULL, '4d631fe9-4088-4733-98a2-a333cd642ef9', 'withdrawal', 2500.00, '2025-02-26', '18:16:22', NULL, 0.00, 1, 'sarf mahmud azad', NULL, NULL, NULL, NULL, '2025-02-26 18:16:22', '2025-02-26 18:16:22', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23918, NULL, '4d631fe9-4088-4733-98a2-a333cd642ef9', 'withdrawal', 2500.00, '2025-02-26', '18:16:22', NULL, 0.00, 1, 'sarf mahmud azad', NULL, NULL, NULL, NULL, '2025-02-26 18:16:22', '2025-02-26 18:16:22', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23919, NULL, '4d631fe9-4088-4733-98a2-a333cd642ef9', 'deposit', 0.00, '2025-02-26', '18:16:22', 'Fee collected for withdrawal', 0.00, 1, 'sarf mahmud azad', NULL, NULL, NULL, NULL, '2025-02-26 18:16:22', '2025-02-26 18:16:22', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23920, NULL, '231eb888-b76d-4fd7-908d-69c92da729e8', 'withdrawal', 1205000.00, '2025-02-26', '18:16:52', NULL, 5000.00, 1, 'tkret-ali qahtan', NULL, NULL, NULL, NULL, '2025-02-26 18:16:52', '2025-02-26 18:16:52', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23921, NULL, '231eb888-b76d-4fd7-908d-69c92da729e8', 'withdrawal', 1205000.00, '2025-02-26', '18:16:52', NULL, 5000.00, 1, 'tkret-ali qahtan', NULL, NULL, NULL, NULL, '2025-02-26 18:16:52', '2025-02-26 18:16:52', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23922, NULL, '231eb888-b76d-4fd7-908d-69c92da729e8', 'deposit', 5000.00, '2025-02-26', '18:16:52', 'Fee collected for withdrawal', 0.00, 1, 'tkret-ali qahtan', NULL, NULL, NULL, NULL, '2025-02-26 18:16:52', '2025-02-26 18:16:52', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23923, NULL, '540ca944-68a5-42b1-b624-78d653e6f312', 'withdrawal', 205.00, '2025-02-26', '18:18:37', NULL, 5.00, 1, 'dhuk-peshkaft muhamad', NULL, NULL, NULL, NULL, '2025-02-26 18:18:37', '2025-02-26 18:18:37', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23924, NULL, '540ca944-68a5-42b1-b624-78d653e6f312', 'withdrawal', 205.00, '2025-02-26', '18:18:37', NULL, 5.00, 1, 'dhuk-peshkaft muhamad', NULL, NULL, NULL, NULL, '2025-02-26 18:18:37', '2025-02-26 18:18:37', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23925, NULL, '540ca944-68a5-42b1-b624-78d653e6f312', 'deposit', 5.00, '2025-02-26', '18:18:37', 'Fee collected for withdrawal', 0.00, 1, 'dhuk-peshkaft muhamad', NULL, NULL, NULL, NULL, '2025-02-26 18:18:37', '2025-02-26 18:18:37', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23935, NULL, '81f33402-4cb7-4ca4-9183-01ee4f9443f3', 'deposit', 1017000.00, '2025-02-26', '18:23:07', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-26 18:23:07', '2025-02-26 18:23:07', 212, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23936, NULL, '81f33402-4cb7-4ca4-9183-01ee4f9443f3', 'deposit', 1017000.00, '2025-02-26', '18:23:07', NULL, 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-26 18:23:07', '2025-02-26 18:23:07', 2, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23937, NULL, '81f33402-4cb7-4ca4-9183-01ee4f9443f3', 'deposit', 0.00, '2025-02-26', '18:23:07', 'Fee collected for deposit', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-26 18:23:07', '2025-02-26 18:23:07', 23, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23938, NULL, 'b7ad3677-6674-48f5-8b26-c603644912b3', 'withdrawal', 300.00, '2025-02-26', '18:25:40', NULL, 0.00, 1, 'ahmed baper', NULL, NULL, NULL, NULL, '2025-02-26 18:25:40', '2025-02-26 18:25:40', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23939, NULL, 'b7ad3677-6674-48f5-8b26-c603644912b3', 'withdrawal', 300.00, '2025-02-26', '18:25:40', NULL, 0.00, 1, 'ahmed baper', NULL, NULL, NULL, NULL, '2025-02-26 18:25:40', '2025-02-26 18:25:40', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23940, NULL, 'b7ad3677-6674-48f5-8b26-c603644912b3', 'deposit', 0.00, '2025-02-26', '18:25:40', 'Fee collected for withdrawal', 0.00, 1, 'ahmed baper', NULL, NULL, NULL, NULL, '2025-02-26 18:25:40', '2025-02-26 18:25:40', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23944, NULL, '90c531a2-3447-4e76-97e9-acdcd082c591', 'withdrawal', 5495.00, '2025-02-26', '18:34:59', 'شکانەوە لەسەر داواکاری خۆی', 1487.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-26 18:34:59', '2025-02-26 18:34:59', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23945, NULL, '90c531a2-3447-4e76-97e9-acdcd082c591', 'deposit', 5495.00, '2025-02-26', '18:34:59', 'شکانەوە لەسەر داواکاری خۆی', 1487.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-26 18:34:59', '2025-02-26 18:34:59', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23946, NULL, '90c531a2-3447-4e76-97e9-acdcd082c591', 'deposit', 8173812.50, '2025-02-26', '18:34:59', 'شکانەوە لەسەر داواکاری خۆی', 1487.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-26 18:34:59', '2025-02-26 18:34:59', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23947, NULL, '90c531a2-3447-4e76-97e9-acdcd082c591', 'withdrawal', 8173812.50, '2025-02-26', '18:34:59', 'شکانەوە لەسەر داواکاری خۆی', 1487.50, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-26 18:34:59', '2025-02-26 18:34:59', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23948, NULL, 'dd5327d3-3b25-48f0-babb-31d604bd58f0', 'deposit', 10000000.00, '2025-02-26', '18:44:30', NULL, 0.00, 1, 'Mohammed ismai', NULL, NULL, NULL, NULL, '2025-02-26 18:44:30', '2025-02-26 18:44:30', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23949, NULL, 'dd5327d3-3b25-48f0-babb-31d604bd58f0', 'deposit', 10000000.00, '2025-02-26', '18:44:30', NULL, 0.00, 1, 'Mohammed ismai', NULL, NULL, NULL, NULL, '2025-02-26 18:44:30', '2025-02-26 18:44:30', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23950, NULL, 'dd5327d3-3b25-48f0-babb-31d604bd58f0', 'deposit', 0.00, '2025-02-26', '18:44:30', 'Fee collected for deposit', 0.00, 1, 'Mohammed ismai', NULL, NULL, NULL, NULL, '2025-02-26 18:44:30', '2025-02-26 18:44:30', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23967, NULL, '79599328-6c1f-450a-ba49-7355841208b1', 'deposit', 321.00, '2025-02-26', '20:57:21', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:57:21', '2025-02-26 20:57:21', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23968, NULL, '79599328-6c1f-450a-ba49-7355841208b1', 'deposit', 321.00, '2025-02-26', '20:57:21', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:57:21', '2025-02-26 20:57:21', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23969, NULL, '79599328-6c1f-450a-ba49-7355841208b1', 'deposit', 0.00, '2025-02-26', '20:57:21', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:57:21', '2025-02-26 20:57:21', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23970, NULL, '8fd992ac-828d-4ad0-960f-767a07adfabe', 'deposit', 465.00, '2025-02-26', '20:58:17', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:58:17', '2025-02-26 20:58:17', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23971, NULL, '8fd992ac-828d-4ad0-960f-767a07adfabe', 'deposit', 465.00, '2025-02-26', '20:58:17', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:58:17', '2025-02-26 20:58:17', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23972, NULL, '8fd992ac-828d-4ad0-960f-767a07adfabe', 'deposit', 0.00, '2025-02-26', '20:58:17', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:58:17', '2025-02-26 20:58:17', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23973, NULL, '90163347-cd7a-471c-bf4a-63609522d355', 'deposit', 32.00, '2025-02-26', '20:58:46', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:58:46', '2025-02-26 20:58:46', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23974, NULL, '90163347-cd7a-471c-bf4a-63609522d355', 'deposit', 32.00, '2025-02-26', '20:58:46', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:58:46', '2025-02-26 20:58:46', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23975, NULL, '90163347-cd7a-471c-bf4a-63609522d355', 'deposit', 0.00, '2025-02-26', '20:58:46', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 20:58:46', '2025-02-26 20:58:46', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23976, NULL, '8943ca3d-d451-4d50-b323-ce6698526d7b', 'withdrawal', 18000.00, '2025-02-26', '20:59:50', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-26 20:59:50', '2025-02-26 20:59:50', 179, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23977, NULL, '8943ca3d-d451-4d50-b323-ce6698526d7b', 'withdrawal', 18000.00, '2025-02-26', '20:59:50', NULL, 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-26 20:59:50', '2025-02-26 20:59:50', 2, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23978, NULL, '8943ca3d-d451-4d50-b323-ce6698526d7b', 'deposit', 0.00, '2025-02-26', '20:59:50', 'Fee collected for withdrawal', 0.00, 1, 'fastlink', NULL, NULL, NULL, NULL, '2025-02-26 20:59:50', '2025-02-26 20:59:50', 23, 179, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23979, NULL, 'a4af4b65-a53c-4922-87aa-d58779c8cb7f', 'withdrawal', 410.00, '2025-02-26', '21:03:00', NULL, 10.00, 1, 'basm ismaiel-dubai remit', NULL, NULL, NULL, NULL, '2025-02-26 21:03:00', '2025-02-26 21:03:00', 1099, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23980, NULL, 'a4af4b65-a53c-4922-87aa-d58779c8cb7f', 'withdrawal', 410.00, '2025-02-26', '21:03:00', NULL, 10.00, 1, 'basm ismaiel-dubai remit', NULL, NULL, NULL, NULL, '2025-02-26 21:03:00', '2025-02-26 21:03:00', 1, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23981, NULL, 'a4af4b65-a53c-4922-87aa-d58779c8cb7f', 'deposit', 10.00, '2025-02-26', '21:03:00', 'Fee collected for withdrawal', 0.00, 1, 'basm ismaiel-dubai remit', NULL, NULL, NULL, NULL, '2025-02-26 21:03:00', '2025-02-26 21:03:00', 22, 1099, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23982, NULL, '60a110e2-d862-46b8-8009-bd433a43f9aa', 'withdrawal', 2004000.00, '2025-02-26', '21:04:44', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:04:44', '2025-02-26 21:04:44', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23983, NULL, '60a110e2-d862-46b8-8009-bd433a43f9aa', 'withdrawal', 2000000.00, '2025-02-26', '21:04:44', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:04:44', '2025-02-26 21:04:44', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23984, NULL, '60a110e2-d862-46b8-8009-bd433a43f9aa', 'withdrawal', 2004000.00, '2025-02-26', '21:04:44', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:04:44', '2025-02-26 21:04:44', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23985, NULL, '9db18ee9-e021-4d9b-ad7e-2598a1273481', 'deposit', 150000.00, '2025-02-26', '21:05:10', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-26 21:05:10', '2025-02-26 21:05:10', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23986, NULL, '9db18ee9-e021-4d9b-ad7e-2598a1273481', 'deposit', 150000.00, '2025-02-26', '21:05:10', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-26 21:05:10', '2025-02-26 21:05:10', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23987, NULL, '9db18ee9-e021-4d9b-ad7e-2598a1273481', 'deposit', 0.00, '2025-02-26', '21:05:10', 'Fee collected for deposit', 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-26 21:05:10', '2025-02-26 21:05:10', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23988, NULL, '45b3467d-a2f2-4d44-a664-609fd39ca087', 'withdrawal', 10000000.00, '2025-02-26', '21:07:10', NULL, 0.00, 1, 'sarf k alan', NULL, NULL, NULL, NULL, '2025-02-26 21:07:10', '2025-02-26 21:07:10', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23989, NULL, '45b3467d-a2f2-4d44-a664-609fd39ca087', 'withdrawal', 10000000.00, '2025-02-26', '21:07:10', NULL, 0.00, 1, 'sarf k alan', NULL, NULL, NULL, NULL, '2025-02-26 21:07:10', '2025-02-26 21:07:10', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(23990, NULL, '45b3467d-a2f2-4d44-a664-609fd39ca087', 'deposit', 0.00, '2025-02-26', '21:07:10', 'Fee collected for withdrawal', 0.00, 1, 'sarf k alan', NULL, NULL, NULL, NULL, '2025-02-26 21:07:10', '2025-02-26 21:07:10', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23991, NULL, '70b3624e-6a7b-4b2c-b05e-f617c015d5f4', 'withdrawal', 6851000.00, '2025-02-26', '21:07:54', NULL, 26000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:07:54', '2025-02-26 21:07:54', 1044, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23992, NULL, '70b3624e-6a7b-4b2c-b05e-f617c015d5f4', 'withdrawal', 6825000.00, '2025-02-26', '21:07:54', NULL, 26000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:07:54', '2025-02-26 21:07:54', 18, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23993, NULL, '70b3624e-6a7b-4b2c-b05e-f617c015d5f4', 'withdrawal', 6851000.00, '2025-02-26', '21:07:54', NULL, 26000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:07:54', '2025-02-26 21:07:54', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23994, NULL, '051d9e68-2bd2-4eb8-8c0d-f2366d312f23', 'withdrawal', 5508250.00, '2025-02-26', '21:15:12', NULL, 8250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:15:12', '2025-02-26 21:15:12', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23995, NULL, '051d9e68-2bd2-4eb8-8c0d-f2366d312f23', 'withdrawal', 5500000.00, '2025-02-26', '21:15:12', NULL, 8250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:15:12', '2025-02-26 21:15:12', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23996, NULL, '051d9e68-2bd2-4eb8-8c0d-f2366d312f23', 'withdrawal', 5508250.00, '2025-02-26', '21:15:12', NULL, 8250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:15:12', '2025-02-26 21:15:12', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23997, NULL, 'e6a77fba-3513-43bd-8533-c4a0d7aefd88', 'withdrawal', 498750.00, '2025-02-26', '21:17:21', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:17:21', '2025-02-26 21:17:21', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23998, NULL, 'e6a77fba-3513-43bd-8533-c4a0d7aefd88', 'withdrawal', 498000.00, '2025-02-26', '21:17:21', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:17:21', '2025-02-26 21:17:21', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(23999, NULL, 'e6a77fba-3513-43bd-8533-c4a0d7aefd88', 'withdrawal', 498750.00, '2025-02-26', '21:17:21', NULL, 750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:17:21', '2025-02-26 21:17:21', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24000, NULL, 'fe87d428-72f6-4ce1-80d9-32db90fcee54', 'withdrawal', 10000.00, '2025-02-26', '21:17:41', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:17:41', '2025-02-26 21:17:41', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24001, NULL, 'fe87d428-72f6-4ce1-80d9-32db90fcee54', 'withdrawal', 10000.00, '2025-02-26', '21:17:41', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:17:41', '2025-02-26 21:17:41', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24002, NULL, 'fe87d428-72f6-4ce1-80d9-32db90fcee54', 'withdrawal', 10000.00, '2025-02-26', '21:17:41', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:17:41', '2025-02-26 21:17:41', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24003, NULL, 'ec993f9e-0a88-443d-8c24-afc008743889', 'withdrawal', 3250.00, '2025-02-26', '21:18:36', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:18:36', '2025-02-26 21:18:36', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24004, NULL, 'ec993f9e-0a88-443d-8c24-afc008743889', 'withdrawal', 3250.00, '2025-02-26', '21:18:36', NULL, 3250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:18:36', '2025-02-26 21:18:36', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24005, NULL, 'ec993f9e-0a88-443d-8c24-afc008743889', 'deposit', 3250.00, '2025-02-26', '21:18:36', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:18:36', '2025-02-26 21:18:36', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24006, NULL, 'dc576433-cfd0-4d66-9677-33ca27fee8d1', 'withdrawal', 1502250.00, '2025-02-26', '21:20:04', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:20:04', '2025-02-26 21:20:04', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24007, NULL, 'dc576433-cfd0-4d66-9677-33ca27fee8d1', 'withdrawal', 1500000.00, '2025-02-26', '21:20:04', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:20:04', '2025-02-26 21:20:04', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24008, NULL, 'dc576433-cfd0-4d66-9677-33ca27fee8d1', 'withdrawal', 1502250.00, '2025-02-26', '21:20:04', NULL, 2250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:20:04', '2025-02-26 21:20:04', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24009, NULL, 'c96856bd-05dc-494e-9e03-30ca3d5a094e', 'withdrawal', 22250.00, '2025-02-26', '21:20:42', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:20:42', '2025-02-26 21:20:42', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24010, NULL, 'c96856bd-05dc-494e-9e03-30ca3d5a094e', 'withdrawal', 22250.00, '2025-02-26', '21:20:42', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:20:42', '2025-02-26 21:20:42', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24011, NULL, 'c96856bd-05dc-494e-9e03-30ca3d5a094e', 'withdrawal', 22250.00, '2025-02-26', '21:20:42', NULL, 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 21:20:42', '2025-02-26 21:20:42', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24012, NULL, '58f42906-3558-44cc-a7b2-f852c145524c', 'withdrawal', 8160.00, '2025-02-26', '21:22:14', NULL, 0.00, 1, 'maktab salahaden', NULL, NULL, NULL, NULL, '2025-02-26 21:22:14', '2025-02-26 21:22:14', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24013, NULL, '58f42906-3558-44cc-a7b2-f852c145524c', 'withdrawal', 8160.00, '2025-02-26', '21:22:14', NULL, 0.00, 1, 'maktab salahaden', NULL, NULL, NULL, NULL, '2025-02-26 21:22:14', '2025-02-26 21:22:14', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24014, NULL, '58f42906-3558-44cc-a7b2-f852c145524c', 'deposit', 0.00, '2025-02-26', '21:22:14', 'Fee collected for withdrawal', 0.00, 1, 'maktab salahaden', NULL, NULL, NULL, NULL, '2025-02-26 21:22:14', '2025-02-26 21:22:14', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24015, NULL, '8fd845fb-0d42-477c-9a99-cf3d0d77c99c', 'deposit', 202.00, '2025-02-26', '21:23:40', NULL, 2.00, 1, 'dhok-peshkaft muhamad salem', NULL, NULL, NULL, NULL, '2025-02-26 21:23:40', '2025-02-26 21:23:40', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24016, NULL, '8fd845fb-0d42-477c-9a99-cf3d0d77c99c', 'deposit', 202.00, '2025-02-26', '21:23:40', NULL, 2.00, 1, 'dhok-peshkaft muhamad salem', NULL, NULL, NULL, NULL, '2025-02-26 21:23:40', '2025-02-26 21:23:40', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24017, NULL, '8fd845fb-0d42-477c-9a99-cf3d0d77c99c', 'deposit', 2.00, '2025-02-26', '21:23:40', 'Fee collected for deposit', 0.00, 1, 'dhok-peshkaft muhamad salem', NULL, NULL, NULL, NULL, '2025-02-26 21:23:40', '2025-02-26 21:23:40', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24018, NULL, 'cf5233ed-42e5-4485-a134-126b19da2899', 'withdrawal', 14850000.00, '2025-02-26', '21:24:04', NULL, 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-26 21:24:04', '2025-02-26 21:24:04', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24019, NULL, 'cf5233ed-42e5-4485-a134-126b19da2899', 'withdrawal', 14850000.00, '2025-02-26', '21:24:04', NULL, 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-26 21:24:04', '2025-02-26 21:24:04', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24020, NULL, 'cf5233ed-42e5-4485-a134-126b19da2899', 'deposit', 0.00, '2025-02-26', '21:24:04', 'Fee collected for withdrawal', 0.00, 1, 'rashad karem', NULL, NULL, NULL, NULL, '2025-02-26 21:24:04', '2025-02-26 21:24:04', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24021, NULL, '154a2c3d-2747-46e3-9fa9-6cc14f5a6884', 'deposit', 5480.00, '2025-02-26', '21:26:26', NULL, -20.00, 1, 'turkea-dogru gurcan', NULL, NULL, NULL, NULL, '2025-02-26 21:26:26', '2025-02-26 21:26:26', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24022, NULL, '154a2c3d-2747-46e3-9fa9-6cc14f5a6884', 'deposit', 5480.00, '2025-02-26', '21:26:26', NULL, -20.00, 1, 'turkea-dogru gurcan', NULL, NULL, NULL, NULL, '2025-02-26 21:26:26', '2025-02-26 21:26:26', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24023, NULL, '154a2c3d-2747-46e3-9fa9-6cc14f5a6884', 'deposit', -20.00, '2025-02-26', '21:26:26', 'Fee collected for deposit', 0.00, 1, 'turkea-dogru gurcan', NULL, NULL, NULL, NULL, '2025-02-26 21:26:26', '2025-02-26 21:26:26', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24028, NULL, 'a467286a-440f-4d1f-8b1a-0698afbee0c2', 'deposit', 20004.00, '2025-02-26', '21:27:30', NULL, 4.00, 1, 'slemani-ibrahm abdulla rasul', NULL, NULL, NULL, NULL, '2025-02-26 21:27:30', '2025-02-26 21:27:30', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24029, NULL, 'a467286a-440f-4d1f-8b1a-0698afbee0c2', 'deposit', 20004.00, '2025-02-26', '21:27:30', NULL, 4.00, 1, 'slemani-ibrahm abdulla rasul', NULL, NULL, NULL, NULL, '2025-02-26 21:27:30', '2025-02-26 21:27:30', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24030, NULL, 'a467286a-440f-4d1f-8b1a-0698afbee0c2', 'deposit', 4.00, '2025-02-26', '21:27:30', 'Fee collected for deposit', 0.00, 1, 'slemani-ibrahm abdulla rasul', NULL, NULL, NULL, NULL, '2025-02-26 21:27:30', '2025-02-26 21:27:30', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24039, NULL, '38bfb636-e2b5-4233-8020-381089ad2c09', 'deposit', 10.00, '2025-02-26', '21:29:16', NULL, 10.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:29:16', '2025-02-26 21:29:16', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24040, NULL, '38bfb636-e2b5-4233-8020-381089ad2c09', 'deposit', 10.00, '2025-02-26', '21:29:16', NULL, 10.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:29:16', '2025-02-26 21:29:16', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24041, NULL, '38bfb636-e2b5-4233-8020-381089ad2c09', 'deposit', 10.00, '2025-02-26', '21:29:16', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:29:16', '2025-02-26 21:29:16', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24046, NULL, 'c1d9b6f3-304b-4a8f-93e3-224c4bc536e1', 'deposit', 10002.00, '2025-02-26', '21:30:07', NULL, 2.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-26 21:30:07', '2025-02-26 21:30:07', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24047, NULL, 'c1d9b6f3-304b-4a8f-93e3-224c4bc536e1', 'deposit', 10002.00, '2025-02-26', '21:30:07', NULL, 2.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-26 21:30:07', '2025-02-26 21:30:07', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24048, NULL, 'c1d9b6f3-304b-4a8f-93e3-224c4bc536e1', 'deposit', 2.00, '2025-02-26', '21:30:07', 'Fee collected for deposit', 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-26 21:30:07', '2025-02-26 21:30:07', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24049, NULL, '7f3a468d-941d-4f58-9514-cc0eac023cae', 'deposit', 5789500.00, '2025-02-26', '21:31:06', NULL, 4500.00, 1, 'slemani-muhamad nazhad', NULL, NULL, NULL, NULL, '2025-02-26 21:31:06', '2025-02-26 21:31:06', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24050, NULL, '7f3a468d-941d-4f58-9514-cc0eac023cae', 'deposit', 5789500.00, '2025-02-26', '21:31:06', NULL, 4500.00, 1, 'slemani-muhamad nazhad', NULL, NULL, NULL, NULL, '2025-02-26 21:31:06', '2025-02-26 21:31:06', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24051, NULL, '7f3a468d-941d-4f58-9514-cc0eac023cae', 'deposit', 4500.00, '2025-02-26', '21:31:06', 'Fee collected for deposit', 0.00, 1, 'slemani-muhamad nazhad', NULL, NULL, NULL, NULL, '2025-02-26 21:31:06', '2025-02-26 21:31:06', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24052, NULL, 'd3ce1928-f037-447d-945f-ea5825022b43', 'withdrawal', 1500.00, '2025-02-26', '21:32:21', NULL, 1500.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:32:21', '2025-02-26 21:32:21', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24053, NULL, 'd3ce1928-f037-447d-945f-ea5825022b43', 'withdrawal', 1500.00, '2025-02-26', '21:32:21', NULL, 1500.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:32:21', '2025-02-26 21:32:21', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24054, NULL, 'd3ce1928-f037-447d-945f-ea5825022b43', 'deposit', 1500.00, '2025-02-26', '21:32:21', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:32:21', '2025-02-26 21:32:21', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24055, NULL, 'e97bfd17-e157-45e1-b4f4-33a94a79fc38', 'withdrawal', 10.00, '2025-02-26', '21:34:14', NULL, 10.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:34:14', '2025-02-26 21:34:14', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24056, NULL, 'e97bfd17-e157-45e1-b4f4-33a94a79fc38', 'withdrawal', 10.00, '2025-02-26', '21:34:14', NULL, 10.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:34:14', '2025-02-26 21:34:14', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24057, NULL, 'e97bfd17-e157-45e1-b4f4-33a94a79fc38', 'deposit', 10.00, '2025-02-26', '21:34:14', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 21:34:14', '2025-02-26 21:34:14', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24062, NULL, '7c4574a6-d291-4b6e-be91-72d42a230f6a', 'deposit', 10800.00, '2025-02-26', '21:35:22', NULL, 0.00, 1, 'bawar abdulxalq', NULL, NULL, NULL, NULL, '2025-02-26 21:35:22', '2025-02-26 21:35:22', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24063, NULL, '7c4574a6-d291-4b6e-be91-72d42a230f6a', 'deposit', 10800.00, '2025-02-26', '21:35:22', NULL, 0.00, 1, 'bawar abdulxalq', NULL, NULL, NULL, NULL, '2025-02-26 21:35:22', '2025-02-26 21:35:22', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24064, NULL, '7c4574a6-d291-4b6e-be91-72d42a230f6a', 'deposit', 0.00, '2025-02-26', '21:35:22', 'Fee collected for deposit', 0.00, 1, 'bawar abdulxalq', NULL, NULL, NULL, NULL, '2025-02-26 21:35:22', '2025-02-26 21:35:22', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24065, NULL, 'dc3dcecb-f016-4a84-b4dd-47eaa7e958b8', 'withdrawal', 324.00, '2025-02-26', '21:37:18', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 21:37:18', '2025-02-26 21:37:18', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24066, NULL, 'dc3dcecb-f016-4a84-b4dd-47eaa7e958b8', 'withdrawal', 324.00, '2025-02-26', '21:37:18', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 21:37:18', '2025-02-26 21:37:18', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24067, NULL, 'dc3dcecb-f016-4a84-b4dd-47eaa7e958b8', 'deposit', 0.00, '2025-02-26', '21:37:18', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-26 21:37:18', '2025-02-26 21:37:18', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24068, NULL, '9ade256e-89db-4a67-ab80-a5a736573600', 'deposit', 408.00, '2025-02-26', '21:38:00', NULL, 8.00, 1, 'indonesia', NULL, NULL, NULL, NULL, '2025-02-26 21:38:00', '2025-02-26 21:38:00', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24069, NULL, '9ade256e-89db-4a67-ab80-a5a736573600', 'deposit', 408.00, '2025-02-26', '21:38:00', NULL, 8.00, 1, 'indonesia', NULL, NULL, NULL, NULL, '2025-02-26 21:38:00', '2025-02-26 21:38:00', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24070, NULL, '9ade256e-89db-4a67-ab80-a5a736573600', 'deposit', 8.00, '2025-02-26', '21:38:00', 'Fee collected for deposit', 0.00, 1, 'indonesia', NULL, NULL, NULL, NULL, '2025-02-26 21:38:00', '2025-02-26 21:38:00', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24071, NULL, '927795d2-6238-44e9-bdb5-1f56cf7d752d', 'deposit', 9000.00, '2025-02-26', '21:40:39', NULL, 0.00, 1, 'hatu k hamadamen', NULL, NULL, NULL, NULL, '2025-02-26 21:40:39', '2025-02-26 21:40:39', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24072, NULL, '927795d2-6238-44e9-bdb5-1f56cf7d752d', 'deposit', 9000.00, '2025-02-26', '21:40:39', NULL, 0.00, 1, 'hatu k hamadamen', NULL, NULL, NULL, NULL, '2025-02-26 21:40:39', '2025-02-26 21:40:39', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24073, NULL, '927795d2-6238-44e9-bdb5-1f56cf7d752d', 'deposit', 0.00, '2025-02-26', '21:40:39', 'Fee collected for deposit', 0.00, 1, 'hatu k hamadamen', NULL, NULL, NULL, NULL, '2025-02-26 21:40:39', '2025-02-26 21:40:39', 22, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24074, NULL, '0f27d6a2-4817-4ed0-a58e-a41a4a64df8b', 'withdrawal', 10000.00, '2025-02-26', '21:41:02', NULL, 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-26 21:41:02', '2025-02-26 21:41:02', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24075, NULL, '0f27d6a2-4817-4ed0-a58e-a41a4a64df8b', 'withdrawal', 10000.00, '2025-02-26', '21:41:02', NULL, 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-26 21:41:02', '2025-02-26 21:41:02', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24076, NULL, '0f27d6a2-4817-4ed0-a58e-a41a4a64df8b', 'deposit', 0.00, '2025-02-26', '21:41:02', 'Fee collected for withdrawal', 0.00, 1, 'slemani-ahmed muhamad', NULL, NULL, NULL, NULL, '2025-02-26 21:41:02', '2025-02-26 21:41:02', 22, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24077, NULL, '09ae8bba-5c11-4592-9abd-297783fe485b', 'deposit', 71000.00, '2025-02-26', '21:43:54', NULL, 0.00, 1, 'hatu k muhamad shami', NULL, NULL, NULL, NULL, '2025-02-26 21:43:54', '2025-02-26 21:43:54', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24078, NULL, '09ae8bba-5c11-4592-9abd-297783fe485b', 'deposit', 71000.00, '2025-02-26', '21:43:54', NULL, 0.00, 1, 'hatu k muhamad shami', NULL, NULL, NULL, NULL, '2025-02-26 21:43:54', '2025-02-26 21:43:54', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24079, NULL, '09ae8bba-5c11-4592-9abd-297783fe485b', 'deposit', 0.00, '2025-02-26', '21:43:54', 'Fee collected for deposit', 0.00, 1, 'hatu k muhamad shami', NULL, NULL, NULL, NULL, '2025-02-26 21:43:54', '2025-02-26 21:43:54', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24080, NULL, 'cbe1655a-f338-4410-97cb-3a731aa766f6', 'withdrawal', 2008000.00, '2025-02-26', '21:44:33', NULL, 8000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-26 21:44:33', '2025-02-26 21:44:33', 232, 4, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24081, NULL, 'cbe1655a-f338-4410-97cb-3a731aa766f6', 'withdrawal', 2000000.00, '2025-02-26', '21:44:33', NULL, 8000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-26 21:44:33', '2025-02-26 21:44:33', 4, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24082, NULL, 'cbe1655a-f338-4410-97cb-3a731aa766f6', 'withdrawal', 2008000.00, '2025-02-26', '21:44:33', NULL, 8000.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-26 21:44:33', '2025-02-26 21:44:33', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24083, NULL, '02c70d4c-acb4-4202-8551-2b685ae9fd99', 'withdrawal', 32000.00, '2025-02-26', '21:45:30', NULL, 0.00, 1, 'aaw masafe', NULL, NULL, NULL, NULL, '2025-02-26 21:45:30', '2025-02-26 21:45:30', 222, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24084, NULL, '02c70d4c-acb4-4202-8551-2b685ae9fd99', 'withdrawal', 32000.00, '2025-02-26', '21:45:30', NULL, 0.00, 1, 'aaw masafe', NULL, NULL, NULL, NULL, '2025-02-26 21:45:30', '2025-02-26 21:45:30', 2, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24085, NULL, '02c70d4c-acb4-4202-8551-2b685ae9fd99', 'deposit', 0.00, '2025-02-26', '21:45:30', 'Fee collected for withdrawal', 0.00, 1, 'aaw masafe', NULL, NULL, NULL, NULL, '2025-02-26 21:45:30', '2025-02-26 21:45:30', 23, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24094, NULL, 'e0cce470-d0d7-4f77-a84d-0fc6fa37b62d', 'deposit', 1600.00, '2025-02-26', '22:13:17', NULL, 0.00, 132, 'shawqi muhamad hamed', NULL, NULL, NULL, NULL, '2025-02-26 22:13:17', '2025-02-26 22:13:17', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24095, NULL, 'e0cce470-d0d7-4f77-a84d-0fc6fa37b62d', 'deposit', 1600.00, '2025-02-26', '22:13:17', NULL, 0.00, 132, 'shawqi muhamad hamed', NULL, NULL, NULL, NULL, '2025-02-26 22:13:17', '2025-02-26 22:13:17', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24108, NULL, '9c1cf2db-3507-4f5d-bf36-ef348816dd7a', 'deposit', 2000.00, '2025-02-26', '22:17:49', NULL, 2000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 22:17:49', '2025-02-26 22:17:49', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24109, NULL, '9c1cf2db-3507-4f5d-bf36-ef348816dd7a', 'deposit', 2000.00, '2025-02-26', '22:17:49', NULL, 2000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 22:17:49', '2025-02-26 22:17:49', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24110, NULL, '9c1cf2db-3507-4f5d-bf36-ef348816dd7a', 'deposit', 2000.00, '2025-02-26', '22:17:49', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-26 22:17:49', '2025-02-26 22:17:49', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24119, NULL, 'adea94fa-4762-4f18-9e4d-b722c68aaf80', 'withdrawal', 893250.00, '2025-02-26', '22:19:27', NULL, 1250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 22:19:27', '2025-02-26 22:19:27', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24120, NULL, 'adea94fa-4762-4f18-9e4d-b722c68aaf80', 'withdrawal', 892000.00, '2025-02-26', '22:19:27', NULL, 1250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 22:19:27', '2025-02-26 22:19:27', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24121, NULL, 'adea94fa-4762-4f18-9e4d-b722c68aaf80', 'withdrawal', 893250.00, '2025-02-26', '22:19:27', NULL, 1250.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-26 22:19:27', '2025-02-26 22:19:27', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24152, NULL, '8adf1f90-da69-4167-bbd3-55026a6827a7', 'withdrawal', 1652000.00, '2025-02-27', '10:31:45', NULL, 2000.00, 1, 'slemani-rawaz adnan', NULL, NULL, NULL, NULL, '2025-02-27 10:31:45', '2025-02-27 10:31:45', 168, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24153, NULL, '8adf1f90-da69-4167-bbd3-55026a6827a7', 'withdrawal', 1652000.00, '2025-02-27', '10:31:45', NULL, 2000.00, 1, 'slemani-rawaz adnan', NULL, NULL, NULL, NULL, '2025-02-27 10:31:45', '2025-02-27 10:31:45', 2, 168, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24154, NULL, '8adf1f90-da69-4167-bbd3-55026a6827a7', 'deposit', 2000.00, '2025-02-27', '10:31:45', 'Fee collected for withdrawal', 0.00, 1, 'slemani-rawaz adnan', NULL, NULL, NULL, NULL, '2025-02-27 10:31:45', '2025-02-27 10:31:45', 23, 168, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24159, NULL, '30d9d177-d2cd-4389-9fd6-a2a4458b6ba9', 'withdrawal', 32.00, '2025-02-27', '10:37:57', NULL, 0.00, 1, 'kart ftth u faastlink', NULL, NULL, NULL, NULL, '2025-02-27 10:37:57', '2025-02-27 10:37:57', 194, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24160, NULL, '30d9d177-d2cd-4389-9fd6-a2a4458b6ba9', 'withdrawal', 32.00, '2025-02-27', '10:37:57', NULL, 0.00, 1, 'kart ftth u faastlink', NULL, NULL, NULL, NULL, '2025-02-27 10:37:57', '2025-02-27 10:37:57', 1, 194, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24161, NULL, '30d9d177-d2cd-4389-9fd6-a2a4458b6ba9', 'deposit', 0.00, '2025-02-27', '10:37:57', 'Fee collected for withdrawal', 0.00, 1, 'kart ftth u faastlink', NULL, NULL, NULL, NULL, '2025-02-27 10:37:57', '2025-02-27 10:37:57', 22, 194, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24162, NULL, 'a02c5f4f-81d2-49c7-9f67-382bae982d01', 'withdrawal', 501500.00, '2025-02-27', '10:45:15', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 10:45:15', '2025-02-27 10:45:15', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24163, NULL, 'a02c5f4f-81d2-49c7-9f67-382bae982d01', 'withdrawal', 500000.00, '2025-02-27', '10:45:15', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 10:45:15', '2025-02-27 10:45:15', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24164, NULL, 'a02c5f4f-81d2-49c7-9f67-382bae982d01', 'withdrawal', 501500.00, '2025-02-27', '10:45:15', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 10:45:15', '2025-02-27 10:45:15', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24165, NULL, '65311578-d540-42bd-b084-5ed00447fdf3', 'withdrawal', 1001500.00, '2025-02-27', '10:48:06', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 10:48:06', '2025-02-27 10:48:06', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24166, NULL, '65311578-d540-42bd-b084-5ed00447fdf3', 'withdrawal', 1000000.00, '2025-02-27', '10:48:06', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 10:48:06', '2025-02-27 10:48:06', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24167, NULL, '65311578-d540-42bd-b084-5ed00447fdf3', 'withdrawal', 1001500.00, '2025-02-27', '10:48:06', NULL, 1500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 10:48:06', '2025-02-27 10:48:06', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24188, NULL, 'e86ca04d-0602-4efc-bba6-e1dadf1c8b03', 'deposit', 18412.00, '2025-02-27', '10:53:06', 'wasta shamal-1741775000-94600', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 10:53:06', '2025-02-27 10:53:06', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24189, NULL, 'e86ca04d-0602-4efc-bba6-e1dadf1c8b03', 'deposit', 18412.00, '2025-02-27', '10:53:06', 'wasta shamal-1741775000-94600', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 10:53:06', '2025-02-27 10:53:06', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24190, NULL, 'e86ca04d-0602-4efc-bba6-e1dadf1c8b03', 'deposit', 0.00, '2025-02-27', '10:53:06', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 10:53:06', '2025-02-27 10:53:06', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24191, NULL, '598060f5-3f69-47d3-9d23-d92ccdf53907', 'withdrawal', 20008.00, '2025-02-27', '10:54:08', NULL, 8.00, 1, 'slemani-ibrahim abdulla', NULL, NULL, NULL, NULL, '2025-02-27 10:54:08', '2025-02-27 10:54:08', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(24192, NULL, '598060f5-3f69-47d3-9d23-d92ccdf53907', 'withdrawal', 20008.00, '2025-02-27', '10:54:08', NULL, 8.00, 1, 'slemani-ibrahim abdulla', NULL, NULL, NULL, NULL, '2025-02-27 10:54:08', '2025-02-27 10:54:08', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24193, NULL, '598060f5-3f69-47d3-9d23-d92ccdf53907', 'deposit', 8.00, '2025-02-27', '10:54:08', 'Fee collected for withdrawal', 0.00, 1, 'slemani-ibrahim abdulla', NULL, NULL, NULL, NULL, '2025-02-27 10:54:08', '2025-02-27 10:54:08', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24194, NULL, 'edc803dd-a050-48f4-92f4-e746ea4dd1c8', 'deposit', 53.00, '2025-02-27', '10:54:21', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 10:54:21', '2025-02-27 10:54:21', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24195, NULL, 'edc803dd-a050-48f4-92f4-e746ea4dd1c8', 'deposit', 53.00, '2025-02-27', '10:54:21', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 10:54:21', '2025-02-27 10:54:21', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24196, NULL, 'edc803dd-a050-48f4-92f4-e746ea4dd1c8', 'deposit', 0.00, '2025-02-27', '10:54:21', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 10:54:21', '2025-02-27 10:54:21', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24200, NULL, 'e6bbacec-f213-47ce-810f-6f58b1f154ab', 'withdrawal', 18500.00, '2025-02-27', '11:01:25', '1741775000-94150', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 11:01:25', '2025-02-27 11:01:25', 237, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24201, NULL, 'e6bbacec-f213-47ce-810f-6f58b1f154ab', 'withdrawal', 18500.00, '2025-02-27', '11:01:25', '1741775000-94150', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 11:01:25', '2025-02-27 11:01:25', 1, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24202, NULL, 'e6bbacec-f213-47ce-810f-6f58b1f154ab', 'deposit', 0.00, '2025-02-27', '11:01:25', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 11:01:25', '2025-02-27 11:01:25', 22, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24206, NULL, '656675ff-12c7-4314-b3bb-e263239c1c37', 'deposit', 14850000.00, '2025-02-27', '11:08:57', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 11:08:57', '2025-02-27 11:08:57', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24207, NULL, '656675ff-12c7-4314-b3bb-e263239c1c37', 'deposit', 14850000.00, '2025-02-27', '11:08:57', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 11:08:57', '2025-02-27 11:08:57', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24208, NULL, '656675ff-12c7-4314-b3bb-e263239c1c37', 'deposit', 0.00, '2025-02-27', '11:08:57', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 11:08:57', '2025-02-27 11:08:57', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24209, NULL, '8b386b89-c182-4e45-a676-6e47ffe69895', 'deposit', 3500.00, '2025-02-27', '11:09:49', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 11:09:49', '2025-02-27 11:09:49', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24210, NULL, '8b386b89-c182-4e45-a676-6e47ffe69895', 'deposit', 3500.00, '2025-02-27', '11:09:49', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 11:09:49', '2025-02-27 11:09:49', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24211, NULL, '8b386b89-c182-4e45-a676-6e47ffe69895', 'deposit', 0.00, '2025-02-27', '11:09:49', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 11:09:49', '2025-02-27 11:09:49', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24212, NULL, '72b98152-062e-4765-b5ba-a1aa99ccc0f5', 'withdrawal', 5013000.00, '2025-02-27', '11:13:34', NULL, 13000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 11:13:34', '2025-02-27 11:13:34', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24213, NULL, '72b98152-062e-4765-b5ba-a1aa99ccc0f5', 'withdrawal', 5013000.00, '2025-02-27', '11:13:34', NULL, 13000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 11:13:34', '2025-02-27 11:13:34', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24214, NULL, '72b98152-062e-4765-b5ba-a1aa99ccc0f5', 'deposit', 13000.00, '2025-02-27', '11:13:34', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 11:13:34', '2025-02-27 11:13:34', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24215, NULL, '40126889-710c-4701-960a-ae9b8ea13561', 'withdrawal', 659.00, '2025-02-27', '11:25:28', '60m tuman-91000', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 11:25:28', '2025-02-27 11:25:28', 240, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24216, NULL, '40126889-710c-4701-960a-ae9b8ea13561', 'withdrawal', 659.00, '2025-02-27', '11:25:28', '60m tuman-91000', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 11:25:28', '2025-02-27 11:25:28', 1, 240, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24217, NULL, '40126889-710c-4701-960a-ae9b8ea13561', 'deposit', 0.00, '2025-02-27', '11:25:28', 'Fee collected for withdrawal', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-02-27 11:25:28', '2025-02-27 11:25:28', 22, 240, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24218, NULL, '4f5f36de-4490-4c6d-9175-33fae3b70c06', 'withdrawal', 301500.00, '2025-02-27', '11:25:53', NULL, 1500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-27 11:25:53', '2025-02-27 11:25:53', 241, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24219, NULL, '4f5f36de-4490-4c6d-9175-33fae3b70c06', 'withdrawal', 301500.00, '2025-02-27', '11:25:53', NULL, 1500.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-27 11:25:53', '2025-02-27 11:25:53', 2, 241, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24220, NULL, '4f5f36de-4490-4c6d-9175-33fae3b70c06', 'deposit', 1500.00, '2025-02-27', '11:25:53', 'Fee collected for withdrawal', 0.00, 1, 'fib', NULL, NULL, NULL, NULL, '2025-02-27 11:25:53', '2025-02-27 11:25:53', 23, 241, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24221, NULL, '929b5621-c561-42aa-8f2c-d5080068a11b', 'deposit', 1500.00, '2025-02-27', '11:27:38', NULL, 0.00, 1, 'k shamal', NULL, NULL, NULL, NULL, '2025-02-27 11:27:38', '2025-02-27 11:27:38', 198, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24222, NULL, '929b5621-c561-42aa-8f2c-d5080068a11b', 'deposit', 1500.00, '2025-02-27', '11:27:38', NULL, 0.00, 1, 'k shamal', NULL, NULL, NULL, NULL, '2025-02-27 11:27:38', '2025-02-27 11:27:38', 1, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24223, NULL, '929b5621-c561-42aa-8f2c-d5080068a11b', 'deposit', 0.00, '2025-02-27', '11:27:38', 'Fee collected for deposit', 0.00, 1, 'k shamal', NULL, NULL, NULL, NULL, '2025-02-27 11:27:38', '2025-02-27 11:27:38', 22, 198, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24228, NULL, '5a508875-ce3e-4106-bc7a-2570e6653bff', 'withdrawal', 28056000.00, '2025-02-27', '12:07:40', NULL, 56000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 12:07:40', '2025-02-27 12:07:40', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24229, NULL, '5a508875-ce3e-4106-bc7a-2570e6653bff', 'withdrawal', 28000000.00, '2025-02-27', '12:07:40', NULL, 56000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 12:07:40', '2025-02-27 12:07:40', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24230, NULL, '5a508875-ce3e-4106-bc7a-2570e6653bff', 'withdrawal', 28056000.00, '2025-02-27', '12:07:40', NULL, 56000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 12:07:40', '2025-02-27 12:07:40', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24235, NULL, '9ea78ad5-53be-41de-8abf-2b5df6dfb99e', 'withdrawal', 772500.00, '2025-02-27', '12:29:13', NULL, 2500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 12:29:13', '2025-02-27 12:29:13', 206, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24236, NULL, '9ea78ad5-53be-41de-8abf-2b5df6dfb99e', 'withdrawal', 770000.00, '2025-02-27', '12:29:13', NULL, 2500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 12:29:13', '2025-02-27 12:29:13', 18, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24237, NULL, '9ea78ad5-53be-41de-8abf-2b5df6dfb99e', 'withdrawal', 772500.00, '2025-02-27', '12:29:13', NULL, 2500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 12:29:13', '2025-02-27 12:29:13', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24250, NULL, '889f7e90-5eb0-45f5-a223-09e8c4f00b4d', 'withdrawal', 1227000.00, '2025-02-27', '13:52:02', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 13:52:02', '2025-02-27 13:52:02', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24251, NULL, '889f7e90-5eb0-45f5-a223-09e8c4f00b4d', 'withdrawal', 1225000.00, '2025-02-27', '13:52:02', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 13:52:02', '2025-02-27 13:52:02', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24252, NULL, '889f7e90-5eb0-45f5-a223-09e8c4f00b4d', 'withdrawal', 1227000.00, '2025-02-27', '13:52:02', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 13:52:02', '2025-02-27 13:52:02', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24257, NULL, 'ed3cabe1-f59d-484c-be77-b6f64beb9bf2', 'withdrawal', 1017000.00, '2025-02-27', '13:54:08', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-27 13:54:08', '2025-02-27 13:54:08', 212, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24258, NULL, 'ed3cabe1-f59d-484c-be77-b6f64beb9bf2', 'withdrawal', 1017000.00, '2025-02-27', '13:54:08', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-27 13:54:08', '2025-02-27 13:54:08', 2, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24259, NULL, 'ed3cabe1-f59d-484c-be77-b6f64beb9bf2', 'deposit', 0.00, '2025-02-27', '13:54:08', 'Fee collected for withdrawal', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-27 13:54:08', '2025-02-27 13:54:08', 23, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24260, NULL, 'a90cfc16-1295-4965-bef8-23a9945a2423', 'deposit', 685.00, '2025-02-27', '13:54:36', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-27 13:54:36', '2025-02-27 13:54:36', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24261, NULL, 'a90cfc16-1295-4965-bef8-23a9945a2423', 'deposit', 685.00, '2025-02-27', '13:54:36', NULL, 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-27 13:54:36', '2025-02-27 13:54:36', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24262, NULL, 'a90cfc16-1295-4965-bef8-23a9945a2423', 'deposit', 0.00, '2025-02-27', '13:54:36', 'Fee collected for deposit', 0.00, 1, 'alugor', NULL, NULL, NULL, NULL, '2025-02-27 13:54:36', '2025-02-27 13:54:36', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24263, NULL, 'c76be80a-c46c-4500-bc35-ef86609ee1c1', 'deposit', 5000.00, '2025-02-27', '13:54:48', NULL, 0.00, 136, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-27 13:54:48', '2025-02-27 13:54:48', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24264, NULL, 'c76be80a-c46c-4500-bc35-ef86609ee1c1', 'deposit', 5000.00, '2025-02-27', '13:54:48', NULL, 0.00, 136, 'Ahmad pshtiwan xurshid', NULL, NULL, NULL, NULL, '2025-02-27 13:54:48', '2025-02-27 13:54:48', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24265, NULL, '36d8cf11-3601-41fb-8338-132f6f1de5f3', 'deposit', 5621.00, '2025-02-27', '13:54:59', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 13:54:59', '2025-02-27 13:54:59', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24266, NULL, '36d8cf11-3601-41fb-8338-132f6f1de5f3', 'deposit', 5621.00, '2025-02-27', '13:54:59', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 13:54:59', '2025-02-27 13:54:59', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24267, NULL, '36d8cf11-3601-41fb-8338-132f6f1de5f3', 'deposit', 0.00, '2025-02-27', '13:54:59', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 13:54:59', '2025-02-27 13:54:59', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24268, NULL, '79021ccf-a147-4a05-9c9b-dfefbde206a1', 'withdrawal', 11006.00, '2025-02-27', '13:57:13', NULL, 0.00, 1, 'sarf asa hsab', NULL, NULL, NULL, NULL, '2025-02-27 13:57:13', '2025-02-27 13:57:13', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24269, NULL, '79021ccf-a147-4a05-9c9b-dfefbde206a1', 'withdrawal', 11006.00, '2025-02-27', '13:57:13', NULL, 0.00, 1, 'sarf asa hsab', NULL, NULL, NULL, NULL, '2025-02-27 13:57:13', '2025-02-27 13:57:13', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24270, NULL, '79021ccf-a147-4a05-9c9b-dfefbde206a1', 'deposit', 0.00, '2025-02-27', '13:57:13', 'Fee collected for withdrawal', 0.00, 1, 'sarf asa hsab', NULL, NULL, NULL, NULL, '2025-02-27 13:57:13', '2025-02-27 13:57:13', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24271, NULL, '428318ed-545e-4e06-88e4-a8834165d10c', 'deposit', 11006.00, '2025-02-27', '13:58:52', NULL, 0.00, 1, ' hsab k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 13:58:52', '2025-02-27 13:58:52', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24272, NULL, '428318ed-545e-4e06-88e4-a8834165d10c', 'deposit', 11006.00, '2025-02-27', '13:58:52', NULL, 0.00, 1, ' hsab k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 13:58:52', '2025-02-27 13:58:52', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24273, NULL, '428318ed-545e-4e06-88e4-a8834165d10c', 'deposit', 0.00, '2025-02-27', '13:58:52', 'Fee collected for deposit', 0.00, 1, ' hsab k ahmed', NULL, NULL, NULL, NULL, '2025-02-27 13:58:52', '2025-02-27 13:58:52', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24282, NULL, 'ddc73788-dd1a-4a44-bff0-cee51c9cfd33', 'withdrawal', 22500.00, '2025-02-27', '14:13:40', NULL, 0.00, 1, 'Mohamad ali sheikhmous', NULL, NULL, NULL, NULL, '2025-02-27 14:13:40', '2025-02-27 14:13:40', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24283, NULL, 'ddc73788-dd1a-4a44-bff0-cee51c9cfd33', 'withdrawal', 22500.00, '2025-02-27', '14:13:40', NULL, 0.00, 1, 'Mohamad ali sheikhmous', NULL, NULL, NULL, NULL, '2025-02-27 14:13:40', '2025-02-27 14:13:40', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24286, NULL, '529e1647-c2b4-4993-8fb4-d99d0f64c665', 'withdrawal', 1033000.00, '2025-02-27', '14:37:41', NULL, 2000.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-27 14:37:41', '2025-02-27 14:37:41', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24287, NULL, '529e1647-c2b4-4993-8fb4-d99d0f64c665', 'withdrawal', 1033000.00, '2025-02-27', '14:37:41', NULL, 2000.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-27 14:37:41', '2025-02-27 14:37:41', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24288, NULL, '529e1647-c2b4-4993-8fb4-d99d0f64c665', 'deposit', 2000.00, '2025-02-27', '14:37:41', 'Fee collected for withdrawal', 0.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-27 14:37:41', '2025-02-27 14:37:41', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24289, NULL, '68378e47-5081-44d3-b58f-9573a7e17853', 'deposit', 40000000.00, '2025-02-27', '14:58:14', NULL, 0.00, 1, 'Matin jubrail', NULL, NULL, NULL, NULL, '2025-02-27 14:58:14', '2025-02-27 14:58:14', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24290, NULL, '68378e47-5081-44d3-b58f-9573a7e17853', 'deposit', 40000000.00, '2025-02-27', '14:58:14', NULL, 0.00, 1, 'Matin jubrail', NULL, NULL, NULL, NULL, '2025-02-27 14:58:14', '2025-02-27 14:58:14', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24291, NULL, '68378e47-5081-44d3-b58f-9573a7e17853', 'deposit', 0.00, '2025-02-27', '14:58:14', 'Fee collected for deposit', 0.00, 1, 'Matin jubrail', NULL, NULL, NULL, NULL, '2025-02-27 14:58:14', '2025-02-27 14:58:14', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24296, NULL, 'ce7b1077-9ff3-448b-a014-e020c646757f', 'withdrawal', 5000000.00, '2025-02-27', '15:26:44', NULL, 0.00, 136, 'Shakor sulaiman ibrahim', NULL, NULL, NULL, NULL, '2025-02-27 15:26:44', '2025-02-27 15:26:44', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24297, NULL, 'ce7b1077-9ff3-448b-a014-e020c646757f', 'withdrawal', 5000000.00, '2025-02-27', '15:26:44', NULL, 0.00, 136, 'Shakor sulaiman ibrahim', NULL, NULL, NULL, NULL, '2025-02-27 15:26:44', '2025-02-27 15:26:44', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24334, NULL, 'bf30a9c2-5eac-42ff-969d-9de06d03c079', 'deposit', 10000.00, '2025-02-27', '17:34:52', NULL, 0.00, 144, 'ashte azad', NULL, NULL, NULL, NULL, '2025-02-27 17:34:52', '2025-02-27 17:34:52', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24335, NULL, 'bf30a9c2-5eac-42ff-969d-9de06d03c079', 'deposit', 10000.00, '2025-02-27', '17:34:52', NULL, 0.00, 144, 'ashte azad', NULL, NULL, NULL, NULL, '2025-02-27 17:34:52', '2025-02-27 17:34:52', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24352, NULL, '00814287-6d55-43a9-8300-4130cb5a2384', 'deposit', 1680.00, '2025-02-27', '18:35:04', NULL, 0.00, 132, 'Ali muhamad jalal', NULL, NULL, NULL, NULL, '2025-02-27 18:35:04', '2025-02-27 18:35:04', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24353, NULL, '00814287-6d55-43a9-8300-4130cb5a2384', 'deposit', 1680.00, '2025-02-27', '18:35:04', NULL, 0.00, 132, 'Ali muhamad jalal', NULL, NULL, NULL, NULL, '2025-02-27 18:35:04', '2025-02-27 18:35:04', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24358, NULL, '573e7340-617b-47db-81db-a5a69dc3a1af', 'withdrawal', 35000.00, '2025-02-27', '18:57:43', NULL, 0.00, 1, 'Hamza fast pay', NULL, NULL, NULL, NULL, '2025-02-27 18:57:43', '2025-02-27 18:57:43', 1149, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24359, NULL, '573e7340-617b-47db-81db-a5a69dc3a1af', 'withdrawal', 35000.00, '2025-02-27', '18:57:43', NULL, 0.00, 1, 'Hamza fast pay', NULL, NULL, NULL, NULL, '2025-02-27 18:57:43', '2025-02-27 18:57:43', 2, 1149, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24360, NULL, '573e7340-617b-47db-81db-a5a69dc3a1af', 'deposit', 0.00, '2025-02-27', '18:57:43', 'Fee collected for withdrawal', 0.00, 1, 'Hamza fast pay', NULL, NULL, NULL, NULL, '2025-02-27 18:57:43', '2025-02-27 18:57:43', 23, 1149, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24361, NULL, '5957f482-f10a-439b-99ef-d81a7ada535d', 'withdrawal', 300000.00, '2025-02-27', '19:00:28', NULL, 0.00, 1, 'saf bo kak payadar', NULL, NULL, NULL, NULL, '2025-02-27 19:00:28', '2025-02-27 19:00:28', 284, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24362, NULL, '5957f482-f10a-439b-99ef-d81a7ada535d', 'withdrawal', 300000.00, '2025-02-27', '19:00:28', NULL, 0.00, 1, 'saf bo kak payadar', NULL, NULL, NULL, NULL, '2025-02-27 19:00:28', '2025-02-27 19:00:28', 2, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24363, NULL, '5957f482-f10a-439b-99ef-d81a7ada535d', 'deposit', 0.00, '2025-02-27', '19:00:28', 'Fee collected for withdrawal', 0.00, 1, 'saf bo kak payadar', NULL, NULL, NULL, NULL, '2025-02-27 19:00:28', '2025-02-27 19:00:28', 23, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24392, NULL, '135745b3-47bf-4d71-b368-d88aceed93d0', 'withdrawal', 201000.00, '2025-02-27', '19:56:34', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:56:34', '2025-02-27 19:56:34', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24393, NULL, '135745b3-47bf-4d71-b368-d88aceed93d0', 'withdrawal', 201000.00, '2025-02-27', '19:56:34', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:56:34', '2025-02-27 19:56:34', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24394, NULL, '135745b3-47bf-4d71-b368-d88aceed93d0', 'deposit', 1000.00, '2025-02-27', '19:56:34', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:56:34', '2025-02-27 19:56:34', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24395, NULL, '0a03be98-2543-4d00-8ea9-5b2446ab9ad9', 'withdrawal', 171000.00, '2025-02-27', '19:56:56', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:56:56', '2025-02-27 19:56:56', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24396, NULL, '0a03be98-2543-4d00-8ea9-5b2446ab9ad9', 'withdrawal', 171000.00, '2025-02-27', '19:56:56', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:56:56', '2025-02-27 19:56:56', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24397, NULL, '0a03be98-2543-4d00-8ea9-5b2446ab9ad9', 'deposit', 1000.00, '2025-02-27', '19:56:56', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:56:56', '2025-02-27 19:56:56', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24398, NULL, 'f707a814-0db1-434b-b400-ca7cbb0cae4a', 'withdrawal', 201000.00, '2025-02-27', '19:57:20', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:57:20', '2025-02-27 19:57:20', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24399, NULL, 'f707a814-0db1-434b-b400-ca7cbb0cae4a', 'withdrawal', 201000.00, '2025-02-27', '19:57:20', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:57:20', '2025-02-27 19:57:20', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24400, NULL, 'f707a814-0db1-434b-b400-ca7cbb0cae4a', 'deposit', 1000.00, '2025-02-27', '19:57:20', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 19:57:20', '2025-02-27 19:57:20', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24401, NULL, '1537ca6a-2d8d-4753-92a9-09d8ab5de632', 'deposit', 4779000.00, '2025-02-27', '20:00:09', NULL, 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-27 20:00:09', '2025-02-27 20:00:09', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24402, NULL, '1537ca6a-2d8d-4753-92a9-09d8ab5de632', 'deposit', 4779000.00, '2025-02-27', '20:00:09', NULL, 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-27 20:00:09', '2025-02-27 20:00:09', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24403, NULL, '1537ca6a-2d8d-4753-92a9-09d8ab5de632', 'deposit', 0.00, '2025-02-27', '20:00:09', 'Fee collected for deposit', 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-27 20:00:09', '2025-02-27 20:00:09', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24404, NULL, '0015cd5b-7e9f-452e-83eb-068d96a63a7b', 'deposit', 3936500.00, '2025-02-27', '20:00:31', NULL, 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-27 20:00:31', '2025-02-27 20:00:31', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24405, NULL, '0015cd5b-7e9f-452e-83eb-068d96a63a7b', 'deposit', 3936500.00, '2025-02-27', '20:00:31', NULL, 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-27 20:00:31', '2025-02-27 20:00:31', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24406, NULL, '0015cd5b-7e9f-452e-83eb-068d96a63a7b', 'deposit', 0.00, '2025-02-27', '20:00:31', 'Fee collected for deposit', 0.00, 1, 'alan', NULL, NULL, NULL, NULL, '2025-02-27 20:00:31', '2025-02-27 20:00:31', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24407, NULL, '4e6b7464-650a-49bd-9502-4c3f376de68c', 'deposit', 1000.00, '2025-02-27', '20:04:39', NULL, 0.00, 144, 'Kak hamdamin', NULL, NULL, NULL, NULL, '2025-02-27 20:04:39', '2025-02-27 20:04:39', 210, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24408, NULL, '4e6b7464-650a-49bd-9502-4c3f376de68c', 'deposit', 1000.00, '2025-02-27', '20:04:39', NULL, 0.00, 144, 'Kak hamdamin', NULL, NULL, NULL, NULL, '2025-02-27 20:04:39', '2025-02-27 20:04:39', 1, 210, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24413, NULL, '8e65c540-51c9-4c3e-b1a7-63228313e8ff', 'withdrawal', 14144500.00, '2025-02-27', '20:20:27', NULL, 34500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 20:20:27', '2025-02-27 20:20:27', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24414, NULL, '8e65c540-51c9-4c3e-b1a7-63228313e8ff', 'withdrawal', 14144500.00, '2025-02-27', '20:20:27', NULL, 34500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 20:20:27', '2025-02-27 20:20:27', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24415, NULL, '8e65c540-51c9-4c3e-b1a7-63228313e8ff', 'deposit', 34500.00, '2025-02-27', '20:20:27', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-02-27 20:20:27', '2025-02-27 20:20:27', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24416, NULL, 'd7c00a5e-8362-467e-b307-37240b9f4186', 'deposit', 156250.00, '2025-02-27', '20:21:45', NULL, 0.00, 1, 'payadar', NULL, NULL, NULL, NULL, '2025-02-27 20:21:45', '2025-02-27 20:27:37', 222, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24417, NULL, 'd7c00a5e-8362-467e-b307-37240b9f4186', 'deposit', 156250.00, '2025-02-27', '20:21:45', NULL, 0.00, 1, 'payadar', NULL, NULL, NULL, NULL, '2025-02-27 20:21:45', '2025-02-27 20:27:37', 2, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24418, NULL, 'd7c00a5e-8362-467e-b307-37240b9f4186', 'deposit', 156250.00, '2025-02-27', '20:21:45', 'Fee collected for withdrawal', 0.00, 1, 'payadar', NULL, NULL, NULL, NULL, '2025-02-27 20:21:45', '2025-02-27 20:27:37', 23, 222, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24419, NULL, 'a4efcac3-7d93-4b9a-b02e-6d1c4f75de24', 'withdrawal', 700000.00, '2025-02-27', '20:27:08', NULL, 0.00, 144, 'Hamdamin', NULL, NULL, NULL, NULL, '2025-02-27 20:27:08', '2025-02-27 20:27:08', 211, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24420, NULL, 'a4efcac3-7d93-4b9a-b02e-6d1c4f75de24', 'withdrawal', 700000.00, '2025-02-27', '20:27:08', NULL, 0.00, 144, 'Hamdamin', NULL, NULL, NULL, NULL, '2025-02-27 20:27:08', '2025-02-27 20:27:08', 2, 211, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24427, NULL, 'aa60fbaa-523a-4952-a674-e40299e0dd90', 'withdrawal', 325000.00, '2025-02-27', '20:36:09', NULL, 0.00, 1, 'demakar', NULL, NULL, NULL, NULL, '2025-02-27 20:36:09', '2025-02-27 20:36:09', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24428, NULL, 'aa60fbaa-523a-4952-a674-e40299e0dd90', 'withdrawal', 325000.00, '2025-02-27', '20:36:09', NULL, 0.00, 1, 'demakar', NULL, NULL, NULL, NULL, '2025-02-27 20:36:09', '2025-02-27 20:36:09', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24429, NULL, 'aa60fbaa-523a-4952-a674-e40299e0dd90', 'deposit', 0.00, '2025-02-27', '20:36:09', 'Fee collected for withdrawal', 0.00, 1, 'demakar', NULL, NULL, NULL, NULL, '2025-02-27 20:36:09', '2025-02-27 20:36:09', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(24430, NULL, '09339075-206d-4d2b-844e-3eb969a86b3b', 'withdrawal', 1154000.00, '2025-02-27', '20:36:29', NULL, 0.00, 1, 'E Z', NULL, NULL, NULL, NULL, '2025-02-27 20:36:29', '2025-02-27 20:36:29', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24431, NULL, '09339075-206d-4d2b-844e-3eb969a86b3b', 'withdrawal', 1154000.00, '2025-02-27', '20:36:29', NULL, 0.00, 1, 'E Z', NULL, NULL, NULL, NULL, '2025-02-27 20:36:29', '2025-02-27 20:36:29', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24432, NULL, '09339075-206d-4d2b-844e-3eb969a86b3b', 'deposit', 0.00, '2025-02-27', '20:36:29', 'Fee collected for withdrawal', 0.00, 1, 'E Z', NULL, NULL, NULL, NULL, '2025-02-27 20:36:29', '2025-02-27 20:36:29', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24433, NULL, '3dd1fa41-b392-42bb-8a5f-c12642922454', 'withdrawal', 5000.00, '2025-02-27', '20:37:01', NULL, 0.00, 1, 'FASTPAY', NULL, NULL, NULL, NULL, '2025-02-27 20:37:01', '2025-02-27 20:37:01', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24434, NULL, '3dd1fa41-b392-42bb-8a5f-c12642922454', 'withdrawal', 5000.00, '2025-02-27', '20:37:01', NULL, 0.00, 1, 'FASTPAY', NULL, NULL, NULL, NULL, '2025-02-27 20:37:01', '2025-02-27 20:37:01', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24435, NULL, '3dd1fa41-b392-42bb-8a5f-c12642922454', 'deposit', 0.00, '2025-02-27', '20:37:01', 'Fee collected for withdrawal', 0.00, 1, 'FASTPAY', NULL, NULL, NULL, NULL, '2025-02-27 20:37:01', '2025-02-27 20:37:01', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24442, NULL, '8ab353a7-ea31-41de-9309-c01479db4873', 'deposit', 985.00, '2025-02-27', '20:40:42', NULL, 10.00, 1, 'canada', NULL, NULL, NULL, NULL, '2025-02-27 20:40:42', '2025-02-27 20:40:42', 1048, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24443, NULL, '8ab353a7-ea31-41de-9309-c01479db4873', 'deposit', 985.00, '2025-02-27', '20:40:42', NULL, 10.00, 1, 'canada', NULL, NULL, NULL, NULL, '2025-02-27 20:40:42', '2025-02-27 20:40:42', 1, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24444, NULL, '8ab353a7-ea31-41de-9309-c01479db4873', 'deposit', 10.00, '2025-02-27', '20:40:42', 'Fee collected for deposit', 0.00, 1, 'canada', NULL, NULL, NULL, NULL, '2025-02-27 20:40:42', '2025-02-27 20:40:42', 22, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24445, NULL, '5144351c-2982-4b2d-a401-c50c7617d9f4', 'deposit', 1651000.00, '2025-02-27', '20:42:31', NULL, 1000.00, 1, 'rawaz adnan', NULL, NULL, NULL, NULL, '2025-02-27 20:42:31', '2025-02-27 20:42:31', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24446, NULL, '5144351c-2982-4b2d-a401-c50c7617d9f4', 'deposit', 1651000.00, '2025-02-27', '20:42:31', NULL, 1000.00, 1, 'rawaz adnan', NULL, NULL, NULL, NULL, '2025-02-27 20:42:31', '2025-02-27 20:42:31', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24447, NULL, '5144351c-2982-4b2d-a401-c50c7617d9f4', 'deposit', 1000.00, '2025-02-27', '20:42:31', 'Fee collected for deposit', 0.00, 1, 'rawaz adnan', NULL, NULL, NULL, NULL, '2025-02-27 20:42:31', '2025-02-27 20:42:31', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24448, NULL, 'e437ba13-8255-4ff5-8f6e-97c362214095', 'withdrawal', 1047500.00, '2025-02-27', '20:43:37', NULL, 2500.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-27 20:43:37', '2025-02-27 20:43:37', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24449, NULL, 'e437ba13-8255-4ff5-8f6e-97c362214095', 'withdrawal', 1047500.00, '2025-02-27', '20:43:37', NULL, 2500.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-27 20:43:37', '2025-02-27 20:43:37', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24450, NULL, 'e437ba13-8255-4ff5-8f6e-97c362214095', 'deposit', 2500.00, '2025-02-27', '20:43:37', 'Fee collected for withdrawal', 0.00, 1, 'zain cash', NULL, NULL, NULL, NULL, '2025-02-27 20:43:37', '2025-02-27 20:43:37', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24455, NULL, '5c4960fc-19dc-41cc-9960-c1b853151393', 'withdrawal', 9027000.00, '2025-02-27', '21:33:40', NULL, 27000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:33:40', '2025-02-27 21:33:40', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24456, NULL, '5c4960fc-19dc-41cc-9960-c1b853151393', 'withdrawal', 9027000.00, '2025-02-27', '21:33:40', NULL, 27000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:33:40', '2025-02-27 21:33:40', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24457, NULL, '5c4960fc-19dc-41cc-9960-c1b853151393', 'deposit', 27000.00, '2025-02-27', '21:33:40', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:33:40', '2025-02-27 21:33:40', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24458, NULL, '4739c9c1-73df-4adf-bf3f-b3ebbfa6136b', 'deposit', 5000000.00, '2025-02-27', '21:34:52', NULL, 0.00, 1, 'hatw badasty ahmed bair', NULL, NULL, NULL, NULL, '2025-02-27 21:34:52', '2025-02-27 21:34:52', 212, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24459, NULL, '4739c9c1-73df-4adf-bf3f-b3ebbfa6136b', 'deposit', 5000000.00, '2025-02-27', '21:34:52', NULL, 0.00, 1, 'hatw badasty ahmed bair', NULL, NULL, NULL, NULL, '2025-02-27 21:34:52', '2025-02-27 21:34:52', 2, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24460, NULL, '4739c9c1-73df-4adf-bf3f-b3ebbfa6136b', 'deposit', 0.00, '2025-02-27', '21:34:52', 'Fee collected for deposit', 0.00, 1, 'hatw badasty ahmed bair', NULL, NULL, NULL, NULL, '2025-02-27 21:34:52', '2025-02-27 21:34:52', 23, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24461, NULL, '541b0423-927f-49c9-9155-a66527de5d69', 'deposit', 8000.00, '2025-02-27', '21:36:26', NULL, 0.00, 1, 'ahmed ezaddi', NULL, NULL, NULL, NULL, '2025-02-27 21:36:26', '2025-02-27 21:36:26', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24462, NULL, '541b0423-927f-49c9-9155-a66527de5d69', 'deposit', 8000.00, '2025-02-27', '21:36:26', NULL, 0.00, 1, 'ahmed ezaddi', NULL, NULL, NULL, NULL, '2025-02-27 21:36:26', '2025-02-27 21:36:26', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24463, NULL, '541b0423-927f-49c9-9155-a66527de5d69', 'deposit', 0.00, '2025-02-27', '21:36:26', 'Fee collected for deposit', 0.00, 1, 'ahmed ezaddi', NULL, NULL, NULL, NULL, '2025-02-27 21:36:26', '2025-02-27 21:36:26', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24464, NULL, '725db3cc-00b6-4279-9dfe-c4ceecc5b608', 'deposit', 14000000.00, '2025-02-27', '21:36:40', NULL, 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:36:40', '2025-02-27 21:36:40', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24465, NULL, '725db3cc-00b6-4279-9dfe-c4ceecc5b608', 'deposit', 14000000.00, '2025-02-27', '21:36:40', NULL, 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:36:40', '2025-02-27 21:36:40', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24466, NULL, '725db3cc-00b6-4279-9dfe-c4ceecc5b608', 'deposit', 0.00, '2025-02-27', '21:36:40', 'Fee collected for deposit', 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:36:40', '2025-02-27 21:36:40', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24467, NULL, '6ec80540-8376-4ae5-9d5f-e31ffe9664e1', 'deposit', 36000000.00, '2025-02-27', '21:37:55', NULL, 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:37:55', '2025-02-27 21:37:55', 201, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24468, NULL, '6ec80540-8376-4ae5-9d5f-e31ffe9664e1', 'deposit', 36000000.00, '2025-02-27', '21:37:55', NULL, 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:37:55', '2025-02-27 21:37:55', 2, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24469, NULL, '6ec80540-8376-4ae5-9d5f-e31ffe9664e1', 'deposit', 0.00, '2025-02-27', '21:37:55', 'Fee collected for deposit', 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:37:55', '2025-02-27 21:37:55', 23, 201, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24470, NULL, 'a56f4c84-e67d-419d-8e14-9bf721599e90', 'deposit', 3800.00, '2025-02-27', '21:38:09', NULL, 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:38:09', '2025-02-27 21:38:09', 200, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24471, NULL, 'a56f4c84-e67d-419d-8e14-9bf721599e90', 'deposit', 3800.00, '2025-02-27', '21:38:09', NULL, 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:38:09', '2025-02-27 21:38:09', 1, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24472, NULL, 'a56f4c84-e67d-419d-8e14-9bf721599e90', 'deposit', 0.00, '2025-02-27', '21:38:09', 'Fee collected for deposit', 0.00, 1, 'ahmed izzadin sharif', NULL, NULL, NULL, NULL, '2025-02-27 21:38:09', '2025-02-27 21:38:09', 22, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24473, NULL, 'b77ebbd2-1f3f-4052-a3f9-a00bb5d3b647', 'withdrawal', 1134.00, '2025-02-27', '21:39:38', NULL, 0.00, 1, 'badasty mahmood', NULL, NULL, NULL, NULL, '2025-02-27 21:39:38', '2025-02-27 21:39:38', 191, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24474, NULL, 'b77ebbd2-1f3f-4052-a3f9-a00bb5d3b647', 'withdrawal', 1134.00, '2025-02-27', '21:39:38', NULL, 0.00, 1, 'badasty mahmood', NULL, NULL, NULL, NULL, '2025-02-27 21:39:38', '2025-02-27 21:39:38', 1, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24475, NULL, 'b77ebbd2-1f3f-4052-a3f9-a00bb5d3b647', 'deposit', 0.00, '2025-02-27', '21:39:38', 'Fee collected for withdrawal', 0.00, 1, 'badasty mahmood', NULL, NULL, NULL, NULL, '2025-02-27 21:39:38', '2025-02-27 21:39:38', 22, 191, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24476, NULL, '91bbf859-6cf9-4163-8d2b-74d8968acbf8', 'withdrawal', 1000.00, '2025-02-27', '21:47:02', NULL, 1000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 21:47:02', '2025-02-27 21:47:02', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24477, NULL, '91bbf859-6cf9-4163-8d2b-74d8968acbf8', 'withdrawal', 1000.00, '2025-02-27', '21:47:02', NULL, 1000.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 21:47:02', '2025-02-27 21:47:02', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24478, NULL, '91bbf859-6cf9-4163-8d2b-74d8968acbf8', 'deposit', 1000.00, '2025-02-27', '21:47:02', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 21:47:02', '2025-02-27 21:47:02', 23, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24479, NULL, 'e04baeb3-8dad-42fa-b0dc-ff4456f3ad08', 'withdrawal', 1003000.00, '2025-02-27', '21:48:08', NULL, 3000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:48:08', '2025-02-27 21:48:08', 220, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24480, NULL, 'e04baeb3-8dad-42fa-b0dc-ff4456f3ad08', 'withdrawal', 1003000.00, '2025-02-27', '21:48:08', NULL, 3000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:48:08', '2025-02-27 21:48:08', 2, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24481, NULL, 'e04baeb3-8dad-42fa-b0dc-ff4456f3ad08', 'deposit', 3000.00, '2025-02-27', '21:48:08', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:48:08', '2025-02-27 21:48:08', 23, 220, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24482, NULL, 'f9dd964d-5d30-47e6-9a00-2a40d4c67e32', 'withdrawal', 990.00, '2025-02-27', '21:50:53', NULL, 15.00, 1, 'canada', NULL, NULL, NULL, NULL, '2025-02-27 21:50:53', '2025-02-27 21:50:53', 167, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24483, NULL, 'f9dd964d-5d30-47e6-9a00-2a40d4c67e32', 'withdrawal', 990.00, '2025-02-27', '21:50:53', NULL, 15.00, 1, 'canada', NULL, NULL, NULL, NULL, '2025-02-27 21:50:53', '2025-02-27 21:50:53', 1, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24484, NULL, 'f9dd964d-5d30-47e6-9a00-2a40d4c67e32', 'deposit', 15.00, '2025-02-27', '21:50:53', 'Fee collected for withdrawal', 0.00, 1, 'canada', NULL, NULL, NULL, NULL, '2025-02-27 21:50:53', '2025-02-27 21:50:53', 22, 167, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24488, NULL, 'aca5a35c-ef5d-4b2c-a815-400718a531cc', 'withdrawal', 9027000.00, '2025-02-27', '21:55:05', NULL, 27000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:55:05', '2025-02-27 21:55:05', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24489, NULL, 'aca5a35c-ef5d-4b2c-a815-400718a531cc', 'withdrawal', 9027000.00, '2025-02-27', '21:55:05', NULL, 27000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:55:05', '2025-02-27 21:55:05', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24490, NULL, 'aca5a35c-ef5d-4b2c-a815-400718a531cc', 'deposit', 27000.00, '2025-02-27', '21:55:05', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-02-27 21:55:05', '2025-02-27 21:55:05', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24491, NULL, 'd1f47d04-6a6c-45cf-93a2-5011c97fa409', 'deposit', 643000.00, '2025-02-27', '22:05:43', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-27 22:05:43', '2025-02-27 22:05:43', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24492, NULL, 'd1f47d04-6a6c-45cf-93a2-5011c97fa409', 'deposit', 643000.00, '2025-02-27', '22:05:43', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-27 22:05:43', '2025-02-27 22:05:43', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24493, NULL, 'd1f47d04-6a6c-45cf-93a2-5011c97fa409', 'deposit', 0.00, '2025-02-27', '22:05:43', 'Fee collected for deposit', 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-02-27 22:05:43', '2025-02-27 22:05:43', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24494, NULL, '93c6efcf-23e4-450a-90e7-5a826e0d2c4b', 'withdrawal', 6.00, '2025-02-27', '22:07:10', NULL, 6.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:07:10', '2025-02-27 22:07:10', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24495, NULL, '93c6efcf-23e4-450a-90e7-5a826e0d2c4b', 'withdrawal', 6.00, '2025-02-27', '22:07:10', NULL, 6.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:07:10', '2025-02-27 22:07:10', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24496, NULL, '93c6efcf-23e4-450a-90e7-5a826e0d2c4b', 'deposit', 6.00, '2025-02-27', '22:07:10', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:07:10', '2025-02-27 22:07:10', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24497, NULL, '67a5b431-f4ce-43cf-9edd-2a3319f08463', 'deposit', 700000.00, '2025-02-27', '22:09:27', NULL, 0.00, 1, 'k hamadamen', NULL, NULL, NULL, NULL, '2025-02-27 22:09:27', '2025-02-27 22:09:27', 211, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24498, NULL, '67a5b431-f4ce-43cf-9edd-2a3319f08463', 'deposit', 700000.00, '2025-02-27', '22:09:27', NULL, 0.00, 1, 'k hamadamen', NULL, NULL, NULL, NULL, '2025-02-27 22:09:27', '2025-02-27 22:09:27', 2, 211, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24499, NULL, '67a5b431-f4ce-43cf-9edd-2a3319f08463', 'deposit', 0.00, '2025-02-27', '22:09:27', 'Fee collected for deposit', 0.00, 1, 'k hamadamen', NULL, NULL, NULL, NULL, '2025-02-27 22:09:27', '2025-02-27 22:09:27', 23, 211, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24500, NULL, '0f6d2689-6dbd-46c8-b869-57c13777a216', 'withdrawal', 2005.00, '2025-02-27', '22:12:46', NULL, 0.00, 1, 'xozyar', NULL, NULL, NULL, NULL, '2025-02-27 22:12:46', '2025-02-27 22:12:46', 267, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24501, NULL, '0f6d2689-6dbd-46c8-b869-57c13777a216', 'withdrawal', 2005.00, '2025-02-27', '22:12:46', NULL, 0.00, 1, 'xozyar', NULL, NULL, NULL, NULL, '2025-02-27 22:12:46', '2025-02-27 22:12:46', 1, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24502, NULL, '0f6d2689-6dbd-46c8-b869-57c13777a216', 'deposit', 0.00, '2025-02-27', '22:12:46', 'Fee collected for withdrawal', 0.00, 1, 'xozyar', NULL, NULL, NULL, NULL, '2025-02-27 22:12:46', '2025-02-27 22:12:46', 22, 267, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24503, NULL, 'b0b237b3-9c20-4b74-ba4c-0a287db97a2d', 'withdrawal', 5010000.00, '2025-02-27', '22:12:47', NULL, 0.00, 1, 'xozyar', NULL, NULL, NULL, NULL, '2025-02-27 22:12:47', '2025-02-27 22:12:47', 266, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24504, NULL, 'b0b237b3-9c20-4b74-ba4c-0a287db97a2d', 'withdrawal', 5010000.00, '2025-02-27', '22:12:47', NULL, 0.00, 1, 'xozyar', NULL, NULL, NULL, NULL, '2025-02-27 22:12:47', '2025-02-27 22:12:47', 2, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24505, NULL, 'b0b237b3-9c20-4b74-ba4c-0a287db97a2d', 'deposit', 0.00, '2025-02-27', '22:12:47', 'Fee collected for withdrawal', 0.00, 1, 'xozyar', NULL, NULL, NULL, NULL, '2025-02-27 22:12:47', '2025-02-27 22:12:47', 23, 266, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24506, NULL, '8233c9a4-54d4-4923-b18d-4d4400b99f81', 'deposit', 2500.00, '2025-02-27', '22:14:50', NULL, 0.00, 1, 'muhamad jaafar', NULL, NULL, NULL, NULL, '2025-02-27 22:14:50', '2025-02-27 22:14:50', 204, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24507, NULL, '8233c9a4-54d4-4923-b18d-4d4400b99f81', 'deposit', 2500.00, '2025-02-27', '22:14:50', NULL, 0.00, 1, 'muhamad jaafar', NULL, NULL, NULL, NULL, '2025-02-27 22:14:50', '2025-02-27 22:14:50', 1, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24508, NULL, '8233c9a4-54d4-4923-b18d-4d4400b99f81', 'deposit', 0.00, '2025-02-27', '22:14:50', 'Fee collected for deposit', 0.00, 1, 'muhamad jaafar', NULL, NULL, NULL, NULL, '2025-02-27 22:14:50', '2025-02-27 22:14:50', 22, 204, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24509, NULL, 'a8747193-d92d-4706-9346-e35b47848d03', 'deposit', 1000000.00, '2025-02-27', '22:15:51', NULL, 0.00, 1, 'card houzz', NULL, NULL, NULL, NULL, '2025-02-27 22:15:51', '2025-02-27 22:15:51', 236, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24510, NULL, 'a8747193-d92d-4706-9346-e35b47848d03', 'deposit', 1000000.00, '2025-02-27', '22:15:51', NULL, 0.00, 1, 'card houzz', NULL, NULL, NULL, NULL, '2025-02-27 22:15:51', '2025-02-27 22:15:51', 2, 236, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24511, NULL, 'a8747193-d92d-4706-9346-e35b47848d03', 'deposit', 0.00, '2025-02-27', '22:15:51', 'Fee collected for deposit', 0.00, 1, 'card houzz', NULL, NULL, NULL, NULL, '2025-02-27 22:15:51', '2025-02-27 22:15:51', 23, 236, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24512, NULL, '1cd22904-7778-4640-a3e0-326fec243a04', 'deposit', 325000.00, '2025-02-27', '22:16:51', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 22:16:51', '2025-02-27 22:16:51', 256, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24513, NULL, '1cd22904-7778-4640-a3e0-326fec243a04', 'deposit', 325000.00, '2025-02-27', '22:16:51', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 22:16:51', '2025-02-27 22:16:51', 2, 256, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24514, NULL, '1cd22904-7778-4640-a3e0-326fec243a04', 'deposit', 0.00, '2025-02-27', '22:16:51', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 22:16:51', '2025-02-27 22:16:51', 23, 256, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24515, NULL, 'a9600975-7012-4487-a5d1-419854f5e7cb', 'deposit', 1154000.00, '2025-02-27', '22:19:32', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 22:19:32', '2025-02-27 22:19:32', 206, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24516, NULL, 'a9600975-7012-4487-a5d1-419854f5e7cb', 'deposit', 1154000.00, '2025-02-27', '22:19:32', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 22:19:32', '2025-02-27 22:19:32', 2, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24517, NULL, 'a9600975-7012-4487-a5d1-419854f5e7cb', 'deposit', 0.00, '2025-02-27', '22:19:32', 'Fee collected for deposit', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-02-27 22:19:32', '2025-02-27 22:19:32', 23, 206, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24518, NULL, 'c13fe2d4-6954-4951-9127-8d5fad6305b4', 'withdrawal', 750.00, '2025-02-27', '22:20:34', NULL, 750.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:20:34', '2025-02-27 22:20:34', 162, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24519, NULL, 'c13fe2d4-6954-4951-9127-8d5fad6305b4', 'withdrawal', 750.00, '2025-02-27', '22:20:34', NULL, 750.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:20:34', '2025-02-27 22:20:34', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24520, NULL, 'c13fe2d4-6954-4951-9127-8d5fad6305b4', 'deposit', 750.00, '2025-02-27', '22:20:34', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:20:34', '2025-02-27 22:20:34', 23, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24521, NULL, 'c05decc6-88d1-40b6-9bce-5853ce7e9a9a', 'deposit', 3250.00, '2025-02-27', '22:24:23', NULL, 3250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:24:23', '2025-02-27 22:24:23', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24522, NULL, 'c05decc6-88d1-40b6-9bce-5853ce7e9a9a', 'deposit', 3250.00, '2025-02-27', '22:24:23', NULL, 3250.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:24:23', '2025-02-27 22:24:23', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24523, NULL, 'c05decc6-88d1-40b6-9bce-5853ce7e9a9a', 'deposit', 3250.00, '2025-02-27', '22:24:23', 'Fee collected for deposit', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-02-27 22:24:23', '2025-02-27 22:24:23', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24524, NULL, '4b0d711b-0686-4f80-913b-245c2172d8a0', 'withdrawal', 250000.00, '2025-02-27', '22:27:44', NULL, 0.00, 1, 'mustafa', NULL, NULL, NULL, NULL, '2025-02-27 22:27:44', '2025-02-27 22:27:44', 253, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24525, NULL, '4b0d711b-0686-4f80-913b-245c2172d8a0', 'withdrawal', 250000.00, '2025-02-27', '22:27:44', NULL, 0.00, 1, 'mustafa', NULL, NULL, NULL, NULL, '2025-02-27 22:27:44', '2025-02-27 22:27:44', 2, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24526, NULL, '4b0d711b-0686-4f80-913b-245c2172d8a0', 'deposit', 0.00, '2025-02-27', '22:27:44', 'Fee collected for withdrawal', 0.00, 1, 'mustafa', NULL, NULL, NULL, NULL, '2025-02-27 22:27:44', '2025-02-27 22:27:44', 23, 253, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24527, NULL, 'de23c805-266c-4027-a4b8-bea276613f63', 'withdrawal', 1500000.00, '2025-02-27', '22:36:39', NULL, 0.00, 1, 'sarf quick pay', NULL, NULL, NULL, NULL, '2025-02-27 22:36:39', '2025-02-27 22:36:39', 1151, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24528, NULL, 'de23c805-266c-4027-a4b8-bea276613f63', 'withdrawal', 1500000.00, '2025-02-27', '22:36:39', NULL, 0.00, 1, 'sarf quick pay', NULL, NULL, NULL, NULL, '2025-02-27 22:36:39', '2025-02-27 22:36:39', 2, 1151, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24529, NULL, 'de23c805-266c-4027-a4b8-bea276613f63', 'deposit', 0.00, '2025-02-27', '22:36:39', 'Fee collected for withdrawal', 0.00, 1, 'sarf quick pay', NULL, NULL, NULL, NULL, '2025-02-27 22:36:39', '2025-02-27 22:36:39', 23, 1151, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24530, NULL, 'd64b5005-c067-46ea-b092-732f560c0efa', 'withdrawal', 1350000.00, '2025-02-27', '22:39:16', NULL, 0.00, 1, 'shadi', NULL, NULL, NULL, NULL, '2025-02-27 22:39:16', '2025-02-27 22:39:16', 959, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24531, NULL, 'd64b5005-c067-46ea-b092-732f560c0efa', 'withdrawal', 1350000.00, '2025-02-27', '22:39:16', NULL, 0.00, 1, 'shadi', NULL, NULL, NULL, NULL, '2025-02-27 22:39:16', '2025-02-27 22:39:16', 2, 959, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24532, NULL, 'd64b5005-c067-46ea-b092-732f560c0efa', 'deposit', 0.00, '2025-02-27', '22:39:16', 'Fee collected for withdrawal', 0.00, 1, 'shadi', NULL, NULL, NULL, NULL, '2025-02-27 22:39:16', '2025-02-27 22:39:16', 23, 959, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24533, NULL, '7f19173d-a68b-493e-b72b-4b22f5b24d65', 'deposit', 14900.00, '2025-02-27', '22:41:36', 'شکانەوە لەسەر داواکاری خۆی', 1480.60, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-27 22:41:36', '2025-02-27 22:41:36', 1, 224, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24534, NULL, '7f19173d-a68b-493e-b72b-4b22f5b24d65', 'withdrawal', 14900.00, '2025-02-27', '22:41:36', 'شکانەوە لەسەر داواکاری خۆی', 1480.60, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-27 22:41:36', '2025-02-27 22:41:36', 224, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24535, NULL, '7f19173d-a68b-493e-b72b-4b22f5b24d65', 'withdrawal', 22060940.00, '2025-02-27', '22:41:36', 'شکانەوە لەسەر داواکاری خۆی', 1480.60, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-27 22:41:36', '2025-02-27 22:41:36', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24536, NULL, '7f19173d-a68b-493e-b72b-4b22f5b24d65', 'deposit', 22060940.00, '2025-02-27', '22:41:36', 'شکانەوە لەسەر داواکاری خۆی', 1480.60, 1, 'شکانەوە لەسەر داواکاری خۆی', NULL, NULL, NULL, NULL, '2025-02-27 22:41:36', '2025-02-27 22:41:36', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24537, NULL, 'f0d63239-b482-4d74-80a4-85a8f9d06127', 'deposit', 14900.00, '2025-02-27', '22:42:22', NULL, 0.00, 1, 'hatu sangar', NULL, NULL, NULL, NULL, '2025-02-27 22:42:22', '2025-02-27 22:42:22', 224, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24538, NULL, 'f0d63239-b482-4d74-80a4-85a8f9d06127', 'deposit', 14900.00, '2025-02-27', '22:42:22', NULL, 0.00, 1, 'hatu sangar', NULL, NULL, NULL, NULL, '2025-02-27 22:42:22', '2025-02-27 22:42:22', 1, 224, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24539, NULL, 'f0d63239-b482-4d74-80a4-85a8f9d06127', 'deposit', 0.00, '2025-02-27', '22:42:22', 'Fee collected for deposit', 0.00, 1, 'hatu sangar', NULL, NULL, NULL, NULL, '2025-02-27 22:42:22', '2025-02-27 22:42:22', 22, 224, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24540, NULL, 'dff68036-6f07-4763-b390-646d6579302c', 'withdrawal', 1950000.00, '2025-02-27', '22:46:16', NULL, 0.00, 1, 'sarhang', NULL, NULL, NULL, NULL, '2025-02-27 22:46:16', '2025-02-27 22:46:16', 1154, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24541, NULL, 'dff68036-6f07-4763-b390-646d6579302c', 'withdrawal', 1950000.00, '2025-02-27', '22:46:16', NULL, 0.00, 1, 'sarhang', NULL, NULL, NULL, NULL, '2025-02-27 22:46:16', '2025-02-27 22:46:16', 2, 1154, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24542, NULL, 'dff68036-6f07-4763-b390-646d6579302c', 'deposit', 0.00, '2025-02-27', '22:46:16', 'Fee collected for withdrawal', 0.00, 1, 'sarhang', NULL, NULL, NULL, NULL, '2025-02-27 22:46:16', '2025-02-27 22:46:16', 23, 1154, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(24549, NULL, '587a1882-1af3-4b8e-8fca-5ebb63ccc0ac', 'deposit', 2500.00, '2025-02-27', '23:12:07', NULL, 0.00, 1, 'hisab ', NULL, NULL, NULL, NULL, '2025-02-27 23:12:07', '2025-02-27 23:12:07', 727, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24550, NULL, '587a1882-1af3-4b8e-8fca-5ebb63ccc0ac', 'deposit', 2500.00, '2025-02-27', '23:12:07', NULL, 0.00, 1, 'hisab ', NULL, NULL, NULL, NULL, '2025-02-27 23:12:07', '2025-02-27 23:12:07', 1, 727, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24551, NULL, '587a1882-1af3-4b8e-8fca-5ebb63ccc0ac', 'deposit', 0.00, '2025-02-27', '23:12:07', 'Fee collected for deposit', 0.00, 1, 'hisab ', NULL, NULL, NULL, NULL, '2025-02-27 23:12:07', '2025-02-27 23:12:07', 22, 727, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24552, NULL, 'dcb43595-4138-438d-9012-9c50321b9c27', 'withdrawal', 11100000.00, '2025-03-01', '09:55:00', NULL, NULL, 134, NULL, NULL, NULL, NULL, NULL, '2025-03-01 09:55:00', '2025-03-01 09:55:00', 1017, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24553, NULL, 'dcb43595-4138-438d-9012-9c50321b9c27', 'deposit', 11100000.00, '2025-03-01', '09:55:00', NULL, NULL, 134, NULL, NULL, NULL, NULL, NULL, '2025-03-01 09:55:00', '2025-03-01 09:55:00', 731, 1017, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24554, NULL, '26822a5c-5321-4936-b3c0-2139102809d0', 'withdrawal', 10000.00, '2025-03-01', '09:55:12', NULL, NULL, 134, NULL, NULL, NULL, NULL, NULL, '2025-03-01 09:55:12', '2025-03-01 09:55:12', 1016, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24555, NULL, '26822a5c-5321-4936-b3c0-2139102809d0', 'deposit', 10000.00, '2025-03-01', '09:55:12', NULL, NULL, 134, NULL, NULL, NULL, NULL, NULL, '2025-03-01 09:55:12', '2025-03-01 09:55:12', 730, 1016, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24556, 6369, '48a2ed4a-59cd-44cc-b4f9-10e273b56309', 'deposit', 18250.00, '2025-03-01', '09:58:40', 'جوڵە کردن لە  IQD بۆ fast pay card', 350.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 09:59:26', '2025-03-01 09:59:26', 964, 998, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24557, 6369, '48a2ed4a-59cd-44cc-b4f9-10e273b56309', 'withdrawal', 17900.00, '2025-03-01', '09:58:40', 'جوڵە کردن لە fast pay card بۆ IQD', 350.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 09:59:26', '2025-03-01 09:59:26', 998, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24558, 6369, '48a2ed4a-59cd-44cc-b4f9-10e273b56309', 'withdrawal', 17900.00, '2025-03-01', '09:58:40', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 09:59:26', '2025-03-01 09:59:26', 71, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24559, 6369, '48a2ed4a-59cd-44cc-b4f9-10e273b56309', 'deposit', 350.00, '2025-03-01', '09:58:40', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 09:59:26', '2025-03-01 09:59:26', 72, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24560, 6370, '45dade50-5288-4a28-9edd-d665c2dd0868', 'deposit', 100.00, '2025-03-01', '09:46:22', 'جوڵە کردن لە  USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:06:34', '2025-03-01 10:06:34', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24561, 6370, '45dade50-5288-4a28-9edd-d665c2dd0868', 'withdrawal', 148000.00, '2025-03-01', '09:46:22', 'جوڵە کردن لە IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:06:34', '2025-03-01 10:06:34', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24562, NULL, '179c85d6-4ff7-4ec0-960b-739dd5f578ea', 'withdrawal', 1201750.00, '2025-03-01', '10:07:16', NULL, 1750.00, 134, 'zain cash', NULL, NULL, NULL, NULL, '2025-03-01 10:07:16', '2025-03-01 10:07:16', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24563, NULL, '179c85d6-4ff7-4ec0-960b-739dd5f578ea', 'withdrawal', 1200000.00, '2025-03-01', '10:07:16', NULL, 1750.00, 134, 'zain cash', NULL, NULL, NULL, NULL, '2025-03-01 10:07:16', '2025-03-01 10:07:16', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24564, NULL, '179c85d6-4ff7-4ec0-960b-739dd5f578ea', 'withdrawal', 1201750.00, '2025-03-01', '10:07:16', NULL, 1750.00, 134, 'zain cash', NULL, NULL, NULL, NULL, '2025-03-01 10:07:16', '2025-03-01 10:07:16', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24565, 6371, 'e9ff8813-3896-4716-b954-1c544efdbe25', 'deposit', 445200.00, '2025-03-01', '10:06:34', 'جوڵە کردن لە  IQD بۆ USD', 1484.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:07:17', '2025-03-01 10:07:17', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24566, 6371, 'e9ff8813-3896-4716-b954-1c544efdbe25', 'withdrawal', 300.00, '2025-03-01', '10:06:34', 'جوڵە کردن لە USD بۆ IQD', 1484.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:07:17', '2025-03-01 10:07:17', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24567, 6372, '7b4d6ac8-272b-46b4-b54a-840c73f3cae7', 'deposit', 100.00, '2025-03-01', '10:07:20', 'جوڵە کردن لە  USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:15:38', '2025-03-01 10:15:38', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24568, 6372, '7b4d6ac8-272b-46b4-b54a-840c73f3cae7', 'withdrawal', 148000.00, '2025-03-01', '10:07:20', 'جوڵە کردن لە IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:15:38', '2025-03-01 10:15:38', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24569, 6373, 'd4c70c4d-ba2b-4aab-84e5-279e42201856', 'deposit', 741750.00, '2025-03-01', '10:18:35', 'جوڵە کردن لە  IQD بۆ USD', 1483.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:23:57', '2025-03-01 10:23:57', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24570, 6373, 'd4c70c4d-ba2b-4aab-84e5-279e42201856', 'withdrawal', 500.00, '2025-03-01', '10:18:35', 'جوڵە کردن لە USD بۆ IQD', 1483.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:23:57', '2025-03-01 10:23:57', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24571, 6374, '849df3cd-90a2-4c97-b099-137e92a39380', 'deposit', 150.00, '2025-03-01', '10:23:58', 'جوڵە کردن لە  USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:27:05', '2025-03-01 10:27:05', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24572, 6374, '849df3cd-90a2-4c97-b099-137e92a39380', 'withdrawal', 222000.00, '2025-03-01', '10:23:58', 'جوڵە کردن لە IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:27:05', '2025-03-01 10:27:05', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24573, 6375, '05f4d1c5-183c-4e8c-83aa-04833e3db108', 'deposit', 1112625.00, '2025-03-01', '10:27:06', 'جوڵە کردن لە  IQD بۆ USD', 1483.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:34:24', '2025-03-01 10:34:24', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24574, 6375, '05f4d1c5-183c-4e8c-83aa-04833e3db108', 'withdrawal', 750.00, '2025-03-01', '10:27:06', 'جوڵە کردن لە USD بۆ IQD', 1483.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:34:24', '2025-03-01 10:34:24', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24575, 6376, '1987bf78-6b57-4ca2-91a1-8508531aeaaa', 'deposit', 744750.00, '2025-03-01', '10:39:07', 'جوڵە کردن لە  Qi Card بۆ USD', 3000.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:39:28', '2025-03-01 10:39:28', 996, 963, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24576, 6376, '1987bf78-6b57-4ca2-91a1-8508531aeaaa', 'withdrawal', 500.00, '2025-03-01', '10:39:07', 'جوڵە کردن لە USD بۆ Qi Card', 3000.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:39:28', '2025-03-01 10:39:28', 963, 996, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24577, 6376, '1987bf78-6b57-4ca2-91a1-8508531aeaaa', 'deposit', 744750.00, '2025-03-01', '10:39:07', 'جوڵە کردن لە USD بۆ Qi Card', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:39:28', '2025-03-01 10:39:28', 69, 996, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24578, 6376, '1987bf78-6b57-4ca2-91a1-8508531aeaaa', 'deposit', 3000.00, '2025-03-01', '10:39:07', 'جوڵە کردن لە USD بۆ Qi Card', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:39:28', '2025-03-01 10:39:28', 70, 996, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24579, 6377, '494dc5d9-8664-4bb1-83ab-ea21816fb6cf', 'deposit', 1000.00, '2025-03-01', '10:43:21', 'جوڵە کردن لە  USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:44:32', '2025-03-01 10:44:32', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24580, 6377, '494dc5d9-8664-4bb1-83ab-ea21816fb6cf', 'withdrawal', 1480000.00, '2025-03-01', '10:43:21', 'جوڵە کردن لە IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:44:32', '2025-03-01 10:44:32', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24581, 6378, 'db419e94-b92c-4086-891a-e09c0763fca4', 'deposit', 296700.00, '2025-03-01', '10:44:33', 'جوڵە کردن لە  IQD بۆ USD', 1483.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:46:57', '2025-03-01 10:46:57', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24582, 6378, 'db419e94-b92c-4086-891a-e09c0763fca4', 'withdrawal', 200.00, '2025-03-01', '10:44:33', 'جوڵە کردن لە USD بۆ IQD', 1483.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:46:57', '2025-03-01 10:46:57', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24583, 6379, 'e14d4eba-4056-43dc-a077-6762214a39fe', 'deposit', 7416250.00, '2025-03-01', '10:39:28', 'جوڵە کردن لە  IQD بۆ USD', 1483.25, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:52:26', '2025-03-01 10:52:26', 964, 963, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24584, 6379, 'e14d4eba-4056-43dc-a077-6762214a39fe', 'withdrawal', 5000.00, '2025-03-01', '10:39:28', 'جوڵە کردن لە USD بۆ IQD', 1483.25, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:52:26', '2025-03-01 10:52:26', 963, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24585, 6380, '18dc87a4-0bcb-4d77-aafa-bbf2283f5534', 'deposit', 100.00, '2025-03-01', '10:46:57', 'جوڵە کردن لە  USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:57:53', '2025-03-01 10:57:53', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24586, 6380, '18dc87a4-0bcb-4d77-aafa-bbf2283f5534', 'withdrawal', 148000.00, '2025-03-01', '10:46:57', 'جوڵە کردن لە IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 10:57:53', '2025-03-01 10:57:53', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24587, 6381, '9ef67868-e530-41ae-bce4-93dbd2bf5762', 'deposit', 148150.00, '2025-03-01', '10:57:54', 'جوڵە کردن لە  IQD بۆ USD', 1481.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:01:44', '2025-03-01 11:01:44', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24588, 6381, '9ef67868-e530-41ae-bce4-93dbd2bf5762', 'withdrawal', 100.00, '2025-03-01', '10:57:54', 'جوڵە کردن لە USD بۆ IQD', 1481.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:01:44', '2025-03-01 11:01:44', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24589, 6382, '6b27deb0-a1e7-450f-a2b3-e6371a8c45c8', 'deposit', 2666700.00, '2025-03-01', '11:01:45', 'جوڵە کردن لە  IQD بۆ USD', 1481.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:05:20', '2025-03-01 11:05:20', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24590, 6382, '6b27deb0-a1e7-450f-a2b3-e6371a8c45c8', 'withdrawal', 1800.00, '2025-03-01', '11:01:45', 'جوڵە کردن لە USD بۆ IQD', 1481.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:05:20', '2025-03-01 11:05:20', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24591, 6383, 'b9e50085-92cc-4279-b808-d99f12c84028', 'deposit', 6000.00, '2025-03-01', '11:05:21', 'جوڵە کردن لە  IQD بۆ FastPay', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:13:13', '2025-03-01 11:13:13', 731, 760, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24592, 6383, 'b9e50085-92cc-4279-b808-d99f12c84028', 'withdrawal', 6000.00, '2025-03-01', '11:05:21', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:13:13', '2025-03-01 11:13:13', 760, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24593, 6383, 'b9e50085-92cc-4279-b808-d99f12c84028', 'withdrawal', 6000.00, '2025-03-01', '11:05:21', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:13:13', '2025-03-01 11:13:13', 67, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24594, 6383, 'b9e50085-92cc-4279-b808-d99f12c84028', 'deposit', 0.00, '2025-03-01', '11:05:21', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:13:13', '2025-03-01 11:13:13', 68, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24595, 6384, 'c202570e-44e6-474d-bb01-0e6066041f04', 'deposit', 15000.00, '2025-03-01', '11:16:41', 'جوڵە کردن لە  USD بۆ IQD', 1488.75, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:16:58', '2025-03-01 11:16:58', 963, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24596, 6384, 'c202570e-44e6-474d-bb01-0e6066041f04', 'withdrawal', 22331250.00, '2025-03-01', '11:16:41', 'جوڵە کردن لە IQD بۆ USD', 1488.75, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:16:58', '2025-03-01 11:16:58', 964, 963, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24597, 6385, '94dff636-f400-42f1-8894-d02857912a2b', 'deposit', 2100.00, '2025-03-01', '11:13:14', 'جوڵە کردن لە  USD بۆ IQD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:20:58', '2025-03-01 11:20:58', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24598, 6385, '94dff636-f400-42f1-8894-d02857912a2b', 'withdrawal', 3105900.00, '2025-03-01', '11:13:14', 'جوڵە کردن لە IQD بۆ USD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:20:58', '2025-03-01 11:20:58', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24599, 6386, '75b5a0a6-8c6c-420d-a3cd-4a8b881a1ac6', 'deposit', 444450.00, '2025-03-01', '11:20:59', 'جوڵە کردن لە  IQD بۆ USD', 1481.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:22:19', '2025-03-01 11:22:19', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24600, 6386, '75b5a0a6-8c6c-420d-a3cd-4a8b881a1ac6', 'withdrawal', 300.00, '2025-03-01', '11:20:59', 'جوڵە کردن لە USD بۆ IQD', 1481.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:22:19', '2025-03-01 11:22:19', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24601, NULL, '086ee919-18cc-4ba1-96d6-9281771969ff', 'deposit', 2215000.00, '2025-03-01', '11:36:18', NULL, 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:36:18', '2025-03-01 11:36:18', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24602, NULL, '086ee919-18cc-4ba1-96d6-9281771969ff', 'deposit', 2215000.00, '2025-03-01', '11:36:18', NULL, 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:36:18', '2025-03-01 11:36:18', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24603, NULL, '086ee919-18cc-4ba1-96d6-9281771969ff', 'deposit', 0.00, '2025-03-01', '11:36:18', 'Fee collected for deposit', 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:36:18', '2025-03-01 11:36:18', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24604, NULL, 'ec2c460b-e71d-4162-bc48-4fae108f283b', 'deposit', 4300.00, '2025-03-01', '11:36:53', NULL, 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:36:53', '2025-03-01 11:36:53', 265, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24605, NULL, 'ec2c460b-e71d-4162-bc48-4fae108f283b', 'deposit', 4300.00, '2025-03-01', '11:36:53', NULL, 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:36:53', '2025-03-01 11:36:53', 1, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24606, NULL, 'ec2c460b-e71d-4162-bc48-4fae108f283b', 'deposit', 0.00, '2025-03-01', '11:36:53', 'Fee collected for deposit', 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:36:53', '2025-03-01 11:36:53', 22, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24607, NULL, '975f8f2d-678c-4dbf-9b6c-6895a373880a', 'deposit', 3700.00, '2025-03-01', '11:39:10', NULL, 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:39:10', '2025-03-01 11:39:10', 265, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24608, NULL, '975f8f2d-678c-4dbf-9b6c-6895a373880a', 'deposit', 3700.00, '2025-03-01', '11:39:10', NULL, 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:39:10', '2025-03-01 11:39:10', 1, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24609, NULL, '975f8f2d-678c-4dbf-9b6c-6895a373880a', 'deposit', 0.00, '2025-03-01', '11:39:10', 'Fee collected for deposit', 0.00, 134, 'k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:39:10', '2025-03-01 11:39:10', 22, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24610, NULL, '443f09ef-c468-4133-aa6e-e140f68596c4', 'withdrawal', 1925000.00, '2025-03-01', '11:41:47', NULL, 0.00, 134, 'sarf k hemn ', NULL, NULL, NULL, NULL, '2025-03-01 11:41:47', '2025-03-01 11:41:47', 264, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24611, NULL, '443f09ef-c468-4133-aa6e-e140f68596c4', 'withdrawal', 1925000.00, '2025-03-01', '11:41:47', NULL, 0.00, 134, 'sarf k hemn ', NULL, NULL, NULL, NULL, '2025-03-01 11:41:47', '2025-03-01 11:41:47', 2, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24612, NULL, '443f09ef-c468-4133-aa6e-e140f68596c4', 'deposit', 0.00, '2025-03-01', '11:41:47', 'Fee collected for withdrawal', 0.00, 134, 'sarf k hemn ', NULL, NULL, NULL, NULL, '2025-03-01 11:41:47', '2025-03-01 11:41:47', 23, 264, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24613, NULL, '085e4efc-84d2-48e9-a7cc-43fcef944e0b', 'deposit', 1300.00, '2025-03-01', '11:42:03', NULL, 0.00, 134, 'hatu k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:42:03', '2025-03-01 11:42:03', 265, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24614, NULL, '085e4efc-84d2-48e9-a7cc-43fcef944e0b', 'deposit', 1300.00, '2025-03-01', '11:42:03', NULL, 0.00, 134, 'hatu k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:42:03', '2025-03-01 11:42:03', 1, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24615, NULL, '085e4efc-84d2-48e9-a7cc-43fcef944e0b', 'deposit', 0.00, '2025-03-01', '11:42:03', 'Fee collected for deposit', 0.00, 134, 'hatu k hemn', NULL, NULL, NULL, NULL, '2025-03-01 11:42:03', '2025-03-01 11:42:03', 22, 265, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24616, 6387, '3f3ffcf5-38a9-42b9-99d4-1660857083d8', 'deposit', 5776875.00, '2025-03-01', '11:22:20', 'جوڵە کردن لە  IQD بۆ USD', 1481.25, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:46:38', '2025-03-01 11:46:38', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24617, 6387, '3f3ffcf5-38a9-42b9-99d4-1660857083d8', 'withdrawal', 3900.00, '2025-03-01', '11:22:20', 'جوڵە کردن لە USD بۆ IQD', 1481.25, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:46:38', '2025-03-01 11:46:38', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24618, 6388, 'f845ecfb-0d6a-4e40-b8b5-e551465fe51d', 'deposit', 199000.00, '2025-03-01', '11:46:38', 'جوڵە کردن لە  Qi Card بۆ IQD', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:47:56', '2025-03-01 11:47:56', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24619, 6388, 'f845ecfb-0d6a-4e40-b8b5-e551465fe51d', 'withdrawal', 198000.00, '2025-03-01', '11:46:38', 'جوڵە کردن لە IQD بۆ Qi Card', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:47:56', '2025-03-01 11:47:56', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24620, 6388, 'f845ecfb-0d6a-4e40-b8b5-e551465fe51d', 'deposit', 199000.00, '2025-03-01', '11:46:38', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:47:56', '2025-03-01 11:47:56', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24621, 6388, 'f845ecfb-0d6a-4e40-b8b5-e551465fe51d', 'deposit', 1000.00, '2025-03-01', '11:46:38', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:47:56', '2025-03-01 11:47:56', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24622, 6389, 'bc12a318-bf13-426a-bf7c-43f7c67f285e', 'deposit', 200.00, '2025-03-01', '11:47:57', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:49:03', '2025-03-01 11:49:03', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24623, 6389, 'bc12a318-bf13-426a-bf7c-43f7c67f285e', 'withdrawal', 295600.00, '2025-03-01', '11:47:57', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:49:03', '2025-03-01 11:49:03', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24624, 6390, '0af6387b-28ae-42c1-abd9-5bb4eb853a79', 'deposit', 7405000.00, '2025-03-01', '11:49:03', 'جوڵە کردن لە  IQD بۆ USD', 1481.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:53:40', '2025-03-01 11:53:40', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24625, 6390, '0af6387b-28ae-42c1-abd9-5bb4eb853a79', 'withdrawal', 5000.00, '2025-03-01', '11:49:03', 'جوڵە کردن لە USD بۆ IQD', 1481.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:53:40', '2025-03-01 11:53:40', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24626, 6391, '42fc394c-6a42-4d76-8dd7-4e5a704e4253', 'deposit', 100.00, '2025-03-01', '11:54:14', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:54:27', '2025-03-01 11:54:27', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24627, 6391, '42fc394c-6a42-4d76-8dd7-4e5a704e4253', 'withdrawal', 147800.00, '2025-03-01', '11:54:14', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:54:27', '2025-03-01 11:54:27', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24628, 6392, 'b05f8192-9bf2-4a81-b22c-eeadf1f957be', 'deposit', 200.00, '2025-03-01', '11:54:27', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:56:06', '2025-03-01 11:56:06', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24629, 6392, 'b05f8192-9bf2-4a81-b22c-eeadf1f957be', 'withdrawal', 295600.00, '2025-03-01', '11:54:27', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:56:06', '2025-03-01 11:56:06', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24630, 6393, 'f14d75c8-8ea4-4ca2-88aa-1edce397b016', 'deposit', 200.00, '2025-03-01', '11:56:07', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:59:02', '2025-03-01 11:59:02', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24631, 6393, 'f14d75c8-8ea4-4ca2-88aa-1edce397b016', 'withdrawal', 295600.00, '2025-03-01', '11:56:07', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 11:59:02', '2025-03-01 11:59:02', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24632, 6394, 'c9d2026c-0938-40a7-a636-6010f21ab928', 'deposit', 100.00, '2025-03-01', '11:59:03', 'جوڵە کردن لە  USD بۆ IQD', 1477.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:01:32', '2025-03-01 12:01:32', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24633, 6394, 'c9d2026c-0938-40a7-a636-6010f21ab928', 'withdrawal', 147750.00, '2025-03-01', '11:59:03', 'جوڵە کردن لە IQD بۆ USD', 1477.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:01:32', '2025-03-01 12:01:32', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24634, 6395, 'ecc42e79-90de-46f5-9154-3889990562de', 'deposit', 740500.00, '2025-03-01', '12:01:32', 'جوڵە کردن لە  IQD بۆ USD', 1481.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:03:23', '2025-03-01 12:03:23', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24635, 6395, 'ecc42e79-90de-46f5-9154-3889990562de', 'withdrawal', 500.00, '2025-03-01', '12:01:32', 'جوڵە کردن لە USD بۆ IQD', 1481.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:03:23', '2025-03-01 12:03:23', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24636, 6396, 'aee9fd96-af52-44f9-b85f-78bf7b44aaa2', 'deposit', 60000.00, '2025-03-01', '12:03:24', 'جوڵە کردن لە  IQD بۆ FIB', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:04:45', '2025-03-01 12:04:45', 731, 732, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24637, 6396, 'aee9fd96-af52-44f9-b85f-78bf7b44aaa2', 'withdrawal', 60000.00, '2025-03-01', '12:03:24', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:04:45', '2025-03-01 12:04:45', 732, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24638, 6396, 'aee9fd96-af52-44f9-b85f-78bf7b44aaa2', 'withdrawal', 60000.00, '2025-03-01', '12:03:24', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:04:45', '2025-03-01 12:04:45', 4, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24639, 6396, 'aee9fd96-af52-44f9-b85f-78bf7b44aaa2', 'deposit', 0.00, '2025-03-01', '12:03:24', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:04:45', '2025-03-01 12:04:45', 457, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24640, 6397, '861c90ec-514c-4ab1-811e-928d6cd97434', 'deposit', 30000.00, '2025-03-01', '12:04:46', 'جوڵە کردن لە  IQD بۆ FastPay', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:05:00', '2025-03-01 12:05:00', 731, 760, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24641, 6397, '861c90ec-514c-4ab1-811e-928d6cd97434', 'withdrawal', 30000.00, '2025-03-01', '12:04:46', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:05:00', '2025-03-01 12:05:00', 760, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24642, 6397, '861c90ec-514c-4ab1-811e-928d6cd97434', 'withdrawal', 30000.00, '2025-03-01', '12:04:46', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:05:00', '2025-03-01 12:05:00', 67, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24643, 6397, '861c90ec-514c-4ab1-811e-928d6cd97434', 'deposit', 0.00, '2025-03-01', '12:04:46', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:05:00', '2025-03-01 12:05:00', 68, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24644, 6398, '374ab724-bf7d-4eb9-aa07-64d944750b9c', 'deposit', 200.00, '2025-03-01', '12:05:00', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:06:03', '2025-03-01 12:06:03', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24645, 6398, '374ab724-bf7d-4eb9-aa07-64d944750b9c', 'withdrawal', 295600.00, '2025-03-01', '12:05:00', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:06:03', '2025-03-01 12:06:03', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24646, 6399, 'b119a1f6-be39-410c-abd8-1090584b07ec', 'deposit', 100.00, '2025-03-01', '12:06:04', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:08:43', '2025-03-01 12:08:43', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24647, 6399, 'b119a1f6-be39-410c-abd8-1090584b07ec', 'withdrawal', 147800.00, '2025-03-01', '12:06:04', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:08:43', '2025-03-01 12:08:43', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24648, 6400, '0838cadd-734b-441f-811d-f2c3218ca601', 'deposit', 290000.00, '2025-03-01', '12:08:44', 'جوڵە کردن لە  Zaincash بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:14:32', '2025-03-01 12:14:32', 735, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(24649, 6400, '0838cadd-734b-441f-811d-f2c3218ca601', 'withdrawal', 290000.00, '2025-03-01', '12:08:44', 'جوڵە کردن لە IQD بۆ Zaincash', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:14:32', '2025-03-01 12:14:32', 731, 735, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24650, 6400, '0838cadd-734b-441f-811d-f2c3218ca601', 'deposit', 290000.00, '2025-03-01', '12:08:44', 'جوڵە کردن لە IQD بۆ Zaincash', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:14:32', '2025-03-01 12:14:32', 18, 735, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24651, 6400, '0838cadd-734b-441f-811d-f2c3218ca601', 'deposit', 0.00, '2025-03-01', '12:08:44', 'جوڵە کردن لە IQD بۆ Zaincash', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:14:32', '2025-03-01 12:14:32', 63, 735, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24652, 6401, 'fdad6553-8b33-4edc-942a-4b1ebc91ccb7', 'deposit', 20000.00, '2025-03-01', '12:14:34', 'جوڵە کردن لە  IQD بۆ fast pay card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:17:58', '2025-03-01 12:17:58', 731, 765, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24653, 6401, 'fdad6553-8b33-4edc-942a-4b1ebc91ccb7', 'withdrawal', 20000.00, '2025-03-01', '12:14:34', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:17:58', '2025-03-01 12:17:58', 765, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24654, 6401, 'fdad6553-8b33-4edc-942a-4b1ebc91ccb7', 'withdrawal', 20000.00, '2025-03-01', '12:14:34', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:17:58', '2025-03-01 12:17:58', 71, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24655, 6401, 'fdad6553-8b33-4edc-942a-4b1ebc91ccb7', 'deposit', 0.00, '2025-03-01', '12:14:34', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:17:58', '2025-03-01 12:17:58', 72, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24656, 6402, '5d0d6ef8-66cf-4178-8f07-19d0893a6dc3', 'deposit', 60000.00, '2025-03-01', '12:17:58', 'جوڵە کردن لە  IQD بۆ FastPay', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:21:39', '2025-03-01 12:21:39', 731, 760, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24657, 6402, '5d0d6ef8-66cf-4178-8f07-19d0893a6dc3', 'withdrawal', 60000.00, '2025-03-01', '12:17:58', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:21:39', '2025-03-01 12:21:39', 760, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24658, 6403, '17a20305-1158-4c04-ae74-7b292784d38f', 'deposit', 100.00, '2025-03-01', '12:21:40', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:29:54', '2025-03-01 12:29:54', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24659, 6403, '17a20305-1158-4c04-ae74-7b292784d38f', 'withdrawal', 147800.00, '2025-03-01', '12:21:40', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 12:29:54', '2025-03-01 12:29:54', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24660, 6404, 'b92bea3e-d835-4c94-8599-02d6b185792b', 'deposit', 1776000.00, '2025-03-01', '12:59:47', 'جوڵە کردن لە  IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:00:02', '2025-03-01 13:00:02', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24661, 6404, 'b92bea3e-d835-4c94-8599-02d6b185792b', 'withdrawal', 1200.00, '2025-03-01', '12:59:47', 'جوڵە کردن لە USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:00:02', '2025-03-01 13:00:02', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24662, 6405, '3baa8015-00dd-45e0-a206-7cab62b33fd7', 'deposit', 10000.00, '2025-03-01', '13:00:03', 'جوڵە کردن لە  IQD بۆ FastPay', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:02:34', '2025-03-01 13:02:34', 731, 760, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24663, 6405, '3baa8015-00dd-45e0-a206-7cab62b33fd7', 'withdrawal', 10000.00, '2025-03-01', '13:00:03', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:02:34', '2025-03-01 13:02:34', 760, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24664, 6405, '3baa8015-00dd-45e0-a206-7cab62b33fd7', 'withdrawal', 10000.00, '2025-03-01', '13:00:03', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:02:34', '2025-03-01 13:02:34', 67, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24665, 6405, '3baa8015-00dd-45e0-a206-7cab62b33fd7', 'deposit', 0.00, '2025-03-01', '13:00:03', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:02:34', '2025-03-01 13:02:34', 68, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24666, 6406, 'a21df25a-0ca6-4a50-bb71-54e3c84d7e96', 'deposit', 100.00, '2025-03-01', '13:02:34', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:06:12', '2025-03-01 13:06:12', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24667, 6406, 'a21df25a-0ca6-4a50-bb71-54e3c84d7e96', 'withdrawal', 147800.00, '2025-03-01', '13:02:34', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:06:12', '2025-03-01 13:06:12', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24668, 6407, '00ac821b-313d-44f7-b3f0-dd573494759e', 'deposit', 100.00, '2025-03-01', '13:10:59', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:11:57', '2025-03-01 13:11:57', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24669, 6407, '00ac821b-313d-44f7-b3f0-dd573494759e', 'withdrawal', 147800.00, '2025-03-01', '13:10:59', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:11:57', '2025-03-01 13:11:57', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24670, 6408, '617a6921-5438-4c22-81b3-8c024d2a398b', 'deposit', 13143880.00, '2025-03-01', '13:11:58', 'جوڵە کردن لە  IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:21:00', '2025-03-01 13:21:00', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24671, 6408, '617a6921-5438-4c22-81b3-8c024d2a398b', 'withdrawal', 8881.00, '2025-03-01', '13:11:58', 'جوڵە کردن لە USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:21:00', '2025-03-01 13:21:00', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24672, 6409, '3fd377d4-8868-44b4-9ec8-e081ab2051ca', 'deposit', 100.00, '2025-03-01', '13:24:48', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:25:03', '2025-03-01 13:25:03', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24673, 6409, '3fd377d4-8868-44b4-9ec8-e081ab2051ca', 'withdrawal', 147800.00, '2025-03-01', '13:24:48', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:25:03', '2025-03-01 13:25:03', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24674, 6410, 'aa46cd0b-e9d6-4b6d-b887-a70362dda9e2', 'deposit', 800.00, '2025-03-01', '13:25:04', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:25:15', '2025-03-01 13:25:15', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24675, 6410, 'aa46cd0b-e9d6-4b6d-b887-a70362dda9e2', 'withdrawal', 1182400.00, '2025-03-01', '13:25:04', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:25:15', '2025-03-01 13:25:15', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24676, 6411, '72cec8c2-8c02-4aff-8a76-0d47fc9e4a5a', 'deposit', 100.00, '2025-03-01', '13:25:16', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:25:37', '2025-03-01 13:25:37', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24677, 6411, '72cec8c2-8c02-4aff-8a76-0d47fc9e4a5a', 'withdrawal', 147800.00, '2025-03-01', '13:25:16', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:25:37', '2025-03-01 13:25:37', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24678, 6412, 'ca03f62e-0434-4012-a713-8cdce98fdcdb', 'deposit', 200.00, '2025-03-01', '13:25:37', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:25:47', '2025-03-01 13:25:47', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24679, 6412, 'ca03f62e-0434-4012-a713-8cdce98fdcdb', 'withdrawal', 295600.00, '2025-03-01', '13:25:37', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:25:47', '2025-03-01 13:25:47', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24680, 6413, '47e4f9f0-ef99-4202-9efd-c4d8ccd9361e', 'deposit', 200.00, '2025-03-01', '13:25:47', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:26:00', '2025-03-01 13:26:00', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24681, 6413, '47e4f9f0-ef99-4202-9efd-c4d8ccd9361e', 'withdrawal', 295600.00, '2025-03-01', '13:25:47', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:26:00', '2025-03-01 13:26:00', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24682, 6414, '72a107eb-0a5b-4dd7-b1c2-223dc36c013b', 'deposit', 888000.00, '2025-03-01', '13:26:00', 'جوڵە کردن لە  IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:30:36', '2025-03-01 13:30:36', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24683, 6414, '72a107eb-0a5b-4dd7-b1c2-223dc36c013b', 'withdrawal', 600.00, '2025-03-01', '13:26:00', 'جوڵە کردن لە USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:30:36', '2025-03-01 13:30:36', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24684, 6415, '1abc2cb9-5b8e-4206-9feb-6f02d366a794', 'deposit', 251000.00, '2025-03-01', '13:30:37', 'جوڵە کردن لە  IQD بۆ FastPay', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:42:25', '2025-03-01 13:42:25', 731, 760, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24685, 6415, '1abc2cb9-5b8e-4206-9feb-6f02d366a794', 'withdrawal', 251000.00, '2025-03-01', '13:30:37', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:42:25', '2025-03-01 13:42:25', 760, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24686, 6415, '1abc2cb9-5b8e-4206-9feb-6f02d366a794', 'withdrawal', 251000.00, '2025-03-01', '13:30:37', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:42:25', '2025-03-01 13:42:25', 67, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24687, 6415, '1abc2cb9-5b8e-4206-9feb-6f02d366a794', 'deposit', 0.00, '2025-03-01', '13:30:37', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:42:25', '2025-03-01 13:42:25', 68, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24688, 6416, '57ae4542-28fd-4da8-9675-ecbe11fe3613', 'deposit', 1036000.00, '2025-03-01', '13:42:25', 'جوڵە کردن لە  IQD بۆ USD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:43:36', '2025-03-01 13:43:36', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24689, 6416, '57ae4542-28fd-4da8-9675-ecbe11fe3613', 'withdrawal', 700.00, '2025-03-01', '13:42:25', 'جوڵە کردن لە USD بۆ IQD', 1480.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:43:36', '2025-03-01 13:43:36', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24690, 6417, '7c025cb2-2afa-447a-afd6-8ed57e4b0761', 'deposit', 400.00, '2025-03-01', '13:43:36', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:45:06', '2025-03-01 13:45:06', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24691, 6417, '7c025cb2-2afa-447a-afd6-8ed57e4b0761', 'withdrawal', 591200.00, '2025-03-01', '13:43:36', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:45:06', '2025-03-01 13:45:06', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24692, 6418, 'fd7b0438-9b1c-4f9d-927e-d3edfd7cda6d', 'deposit', 300.00, '2025-03-01', '13:45:06', 'جوڵە کردن لە  USD بۆ IQD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:51:25', '2025-03-01 13:51:25', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24693, 6418, 'fd7b0438-9b1c-4f9d-927e-d3edfd7cda6d', 'withdrawal', 443400.00, '2025-03-01', '13:45:06', 'جوڵە کردن لە IQD بۆ USD', 1478.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:51:25', '2025-03-01 13:51:25', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24694, NULL, 'e6b7e59a-ed7d-462b-9ea8-d59c247805cf', 'withdrawal', 19.00, '2025-03-01', '13:55:24', NULL, 0.00, 134, 'fastlink-korek', NULL, NULL, NULL, NULL, '2025-03-01 13:55:24', '2025-03-01 13:55:24', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24695, NULL, 'e6b7e59a-ed7d-462b-9ea8-d59c247805cf', 'withdrawal', 19.00, '2025-03-01', '13:55:24', NULL, 0.00, 134, 'fastlink-korek', NULL, NULL, NULL, NULL, '2025-03-01 13:55:24', '2025-03-01 13:55:24', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24696, NULL, 'e6b7e59a-ed7d-462b-9ea8-d59c247805cf', 'deposit', 0.00, '2025-03-01', '13:55:24', 'Fee collected for withdrawal', 0.00, 134, 'fastlink-korek', NULL, NULL, NULL, NULL, '2025-03-01 13:55:25', '2025-03-01 13:55:25', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24697, NULL, 'e7c10c4a-4ad1-49a0-b130-46a24300da35', 'withdrawal', 615000.00, '2025-03-01', '13:56:12', NULL, 0.00, 134, 'sarf k ali', NULL, NULL, NULL, NULL, '2025-03-01 13:56:12', '2025-03-01 13:56:12', 238, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24698, NULL, 'e7c10c4a-4ad1-49a0-b130-46a24300da35', 'withdrawal', 615000.00, '2025-03-01', '13:56:12', NULL, 0.00, 134, 'sarf k ali', NULL, NULL, NULL, NULL, '2025-03-01 13:56:12', '2025-03-01 13:56:12', 2, 238, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24699, NULL, 'e7c10c4a-4ad1-49a0-b130-46a24300da35', 'deposit', 0.00, '2025-03-01', '13:56:12', 'Fee collected for withdrawal', 0.00, 134, 'sarf k ali', NULL, NULL, NULL, NULL, '2025-03-01 13:56:12', '2025-03-01 13:56:12', 23, 238, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24700, NULL, 'db46a286-a58c-4a8c-a1c4-3e34e906179e', 'deposit', 22778.00, '2025-03-01', '13:56:26', NULL, 0.00, 134, 'k ali hatu', NULL, NULL, NULL, NULL, '2025-03-01 13:56:26', '2025-03-01 13:56:26', 237, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24701, NULL, 'db46a286-a58c-4a8c-a1c4-3e34e906179e', 'deposit', 22778.00, '2025-03-01', '13:56:26', NULL, 0.00, 134, 'k ali hatu', NULL, NULL, NULL, NULL, '2025-03-01 13:56:26', '2025-03-01 13:56:26', 1, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24702, NULL, 'db46a286-a58c-4a8c-a1c4-3e34e906179e', 'deposit', 0.00, '2025-03-01', '13:56:26', 'Fee collected for deposit', 0.00, 134, 'k ali hatu', NULL, NULL, NULL, NULL, '2025-03-01 13:56:26', '2025-03-01 13:56:26', 22, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24703, NULL, '5d9ed582-8cb8-4044-82cf-6a08979c32cf', 'withdrawal', 5015000.00, '2025-03-01', '13:57:35', NULL, 15000.00, 134, 'suoer qi', NULL, NULL, NULL, NULL, '2025-03-01 13:57:35', '2025-03-01 13:57:35', 1104, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24704, NULL, '5d9ed582-8cb8-4044-82cf-6a08979c32cf', 'withdrawal', 5015000.00, '2025-03-01', '13:57:35', NULL, 15000.00, 134, 'suoer qi', NULL, NULL, NULL, NULL, '2025-03-01 13:57:35', '2025-03-01 13:57:35', 2, 1104, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24705, NULL, '5d9ed582-8cb8-4044-82cf-6a08979c32cf', 'deposit', 15000.00, '2025-03-01', '13:57:35', 'Fee collected for withdrawal', 0.00, 134, 'suoer qi', NULL, NULL, NULL, NULL, '2025-03-01 13:57:35', '2025-03-01 13:57:35', 23, 1104, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24706, 6419, 'fa5c7ef3-5019-46e0-b269-7d7755b364fc', 'deposit', 739500.00, '2025-03-01', '13:57:19', 'جوڵە کردن لە  IQD بۆ USD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:57:43', '2025-03-01 13:57:43', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24707, 6419, 'fa5c7ef3-5019-46e0-b269-7d7755b364fc', 'withdrawal', 500.00, '2025-03-01', '13:57:19', 'جوڵە کردن لە USD بۆ IQD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:57:43', '2025-03-01 13:57:43', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24708, 6420, '60aa7fc2-d4fb-466d-b2ce-ed1ef842b3f4', 'deposit', 20000.00, '2025-03-01', '13:57:44', 'جوڵە کردن لە  IQD بۆ FIB', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:57:56', '2025-03-01 13:57:56', 731, 732, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24709, 6420, '60aa7fc2-d4fb-466d-b2ce-ed1ef842b3f4', 'withdrawal', 20000.00, '2025-03-01', '13:57:44', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:57:56', '2025-03-01 13:57:56', 732, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24710, 6420, '60aa7fc2-d4fb-466d-b2ce-ed1ef842b3f4', 'withdrawal', 20000.00, '2025-03-01', '13:57:44', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:57:56', '2025-03-01 13:57:56', 4, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24711, 6420, '60aa7fc2-d4fb-466d-b2ce-ed1ef842b3f4', 'deposit', 0.00, '2025-03-01', '13:57:44', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 13:57:56', '2025-03-01 13:57:56', 457, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24712, NULL, '04fd20dd-115f-402c-8076-ff9c24e5a84c', 'deposit', 13436.00, '2025-03-01', '14:00:10', NULL, 0.00, 134, 'k ahmed', NULL, NULL, NULL, NULL, '2025-03-01 14:00:10', '2025-03-01 14:00:10', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24713, NULL, '04fd20dd-115f-402c-8076-ff9c24e5a84c', 'deposit', 13436.00, '2025-03-01', '14:00:10', NULL, 0.00, 134, 'k ahmed', NULL, NULL, NULL, NULL, '2025-03-01 14:00:10', '2025-03-01 14:00:10', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24714, NULL, '04fd20dd-115f-402c-8076-ff9c24e5a84c', 'deposit', 0.00, '2025-03-01', '14:00:10', 'Fee collected for deposit', 0.00, 134, 'k ahmed', NULL, NULL, NULL, NULL, '2025-03-01 14:00:10', '2025-03-01 14:00:10', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24715, NULL, 'ab4cad14-bad4-4f2d-bea0-bdb05f82b21a', 'withdrawal', 5000000.00, '2025-03-01', '14:00:30', NULL, 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-01 14:00:30', '2025-03-01 14:00:30', 212, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24716, NULL, 'ab4cad14-bad4-4f2d-bea0-bdb05f82b21a', 'withdrawal', 5000000.00, '2025-03-01', '14:00:30', NULL, 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-01 14:00:30', '2025-03-01 14:00:30', 2, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24717, NULL, 'ab4cad14-bad4-4f2d-bea0-bdb05f82b21a', 'deposit', 0.00, '2025-03-01', '14:00:30', 'Fee collected for withdrawal', 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-01 14:00:30', '2025-03-01 14:00:30', 23, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24718, NULL, '1156daa6-68d9-4496-a736-2b5570e59b6c', 'deposit', 3375.00, '2025-03-01', '14:02:40', NULL, 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-01 14:02:40', '2025-03-01 14:02:40', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24719, NULL, '1156daa6-68d9-4496-a736-2b5570e59b6c', 'deposit', 3375.00, '2025-03-01', '14:02:40', NULL, 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-01 14:02:40', '2025-03-01 14:02:40', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24720, NULL, '1156daa6-68d9-4496-a736-2b5570e59b6c', 'deposit', 0.00, '2025-03-01', '14:02:40', 'Fee collected for deposit', 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-01 14:02:40', '2025-03-01 14:02:40', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24721, 6421, 'ce5254ae-1872-4b00-89f8-7706c52111c2', 'deposit', 400.00, '2025-03-01', '13:57:56', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:02:57', '2025-03-01 14:02:57', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24722, 6421, 'ce5254ae-1872-4b00-89f8-7706c52111c2', 'withdrawal', 590600.00, '2025-03-01', '13:57:56', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:02:57', '2025-03-01 14:02:57', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24723, 6422, 'b018dd90-505c-4712-a154-2de3b296d75e', 'deposit', 100.00, '2025-03-01', '14:02:57', 'جوڵە کردن لە  USD بۆ IQD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:03:08', '2025-03-01 14:03:08', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24724, 6422, 'b018dd90-505c-4712-a154-2de3b296d75e', 'withdrawal', 147500.00, '2025-03-01', '14:02:57', 'جوڵە کردن لە IQD بۆ USD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:03:08', '2025-03-01 14:03:08', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24725, NULL, '05c9d9aa-f5d0-4a28-a9a8-b7377d899617', 'withdrawal', 16811.00, '2025-03-01', '14:04:32', NULL, 0.00, 134, 'sarf asa', NULL, NULL, NULL, NULL, '2025-03-01 14:04:32', '2025-03-01 14:04:32', 213, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24726, NULL, '05c9d9aa-f5d0-4a28-a9a8-b7377d899617', 'withdrawal', 16811.00, '2025-03-01', '14:04:32', NULL, 0.00, 134, 'sarf asa', NULL, NULL, NULL, NULL, '2025-03-01 14:04:32', '2025-03-01 14:04:32', 1, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24727, NULL, '05c9d9aa-f5d0-4a28-a9a8-b7377d899617', 'deposit', 0.00, '2025-03-01', '14:04:32', 'Fee collected for withdrawal', 0.00, 134, 'sarf asa', NULL, NULL, NULL, NULL, '2025-03-01 14:04:32', '2025-03-01 14:04:32', 22, 213, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24728, NULL, '33d74a3b-16b4-47e7-b05c-d949599bd4a0', 'deposit', 16811.00, '2025-03-01', '14:06:05', NULL, 0.00, 134, 'hatu hsab ahmed bapir', NULL, NULL, NULL, NULL, '2025-03-01 14:06:05', '2025-03-01 14:06:05', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24729, NULL, '33d74a3b-16b4-47e7-b05c-d949599bd4a0', 'deposit', 16811.00, '2025-03-01', '14:06:05', NULL, 0.00, 134, 'hatu hsab ahmed bapir', NULL, NULL, NULL, NULL, '2025-03-01 14:06:05', '2025-03-01 14:06:05', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24730, NULL, '33d74a3b-16b4-47e7-b05c-d949599bd4a0', 'deposit', 0.00, '2025-03-01', '14:06:05', 'Fee collected for deposit', 0.00, 134, 'hatu hsab ahmed bapir', NULL, NULL, NULL, NULL, '2025-03-01 14:06:05', '2025-03-01 14:06:05', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24731, 6423, '7003730c-7501-46dc-bc73-ee3a5431cd48', 'deposit', 1991000.00, '2025-03-01', '14:03:08', 'جوڵە کردن لە  Qi Card بۆ IQD', 6000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:08:03', '2025-03-01 14:08:03', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24732, 6423, '7003730c-7501-46dc-bc73-ee3a5431cd48', 'withdrawal', 1985000.00, '2025-03-01', '14:03:08', 'جوڵە کردن لە IQD بۆ Qi Card', 6000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:08:03', '2025-03-01 14:08:03', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24733, 6423, '7003730c-7501-46dc-bc73-ee3a5431cd48', 'deposit', 1991000.00, '2025-03-01', '14:03:08', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:08:03', '2025-03-01 14:08:03', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24734, 6423, '7003730c-7501-46dc-bc73-ee3a5431cd48', 'deposit', 6000.00, '2025-03-01', '14:03:08', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:08:03', '2025-03-01 14:08:03', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24735, 6424, '58d80156-f252-491a-88f5-9250c9cc3878', 'deposit', 200.00, '2025-03-01', '14:08:03', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:08:53', '2025-03-01 14:08:53', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24736, 6424, '58d80156-f252-491a-88f5-9250c9cc3878', 'withdrawal', 295300.00, '2025-03-01', '14:08:03', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:08:53', '2025-03-01 14:08:53', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24737, 6425, 'b17c7196-35a6-401d-a913-8c89ffb86171', 'deposit', 591600.00, '2025-03-01', '14:08:54', 'جوڵە کردن لە  IQD بۆ USD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:10:00', '2025-03-01 14:10:00', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24738, 6425, 'b17c7196-35a6-401d-a913-8c89ffb86171', 'withdrawal', 400.00, '2025-03-01', '14:08:54', 'جوڵە کردن لە USD بۆ IQD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:10:00', '2025-03-01 14:10:00', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24739, NULL, '4effa8f4-870a-49e9-ac41-94425276389b', 'deposit', 2006000.00, '2025-03-01', '14:10:03', NULL, 0.00, 134, 'k muhmd shami', NULL, NULL, NULL, NULL, '2025-03-01 14:10:03', '2025-03-01 14:10:03', 232, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24740, NULL, '4effa8f4-870a-49e9-ac41-94425276389b', 'deposit', 2006000.00, '2025-03-01', '14:10:03', NULL, 0.00, 134, 'k muhmd shami', NULL, NULL, NULL, NULL, '2025-03-01 14:10:03', '2025-03-01 14:10:03', 2, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24741, NULL, '4effa8f4-870a-49e9-ac41-94425276389b', 'deposit', 0.00, '2025-03-01', '14:10:03', 'Fee collected for deposit', 0.00, 134, 'k muhmd shami', NULL, NULL, NULL, NULL, '2025-03-01 14:10:03', '2025-03-01 14:10:03', 23, 232, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24742, NULL, 'd727c8e5-5269-4053-961d-0f2a3e9937ec', 'withdrawal', 5015000.00, '2025-03-01', '14:13:10', NULL, 15000.00, 134, 'super qi', NULL, NULL, NULL, NULL, '2025-03-01 14:13:10', '2025-03-01 14:13:10', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24743, NULL, 'd727c8e5-5269-4053-961d-0f2a3e9937ec', 'withdrawal', 5015000.00, '2025-03-01', '14:13:10', NULL, 15000.00, 134, 'super qi', NULL, NULL, NULL, NULL, '2025-03-01 14:13:10', '2025-03-01 14:13:10', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24744, NULL, 'd727c8e5-5269-4053-961d-0f2a3e9937ec', 'deposit', 15000.00, '2025-03-01', '14:13:10', 'Fee collected for withdrawal', 0.00, 134, 'super qi', NULL, NULL, NULL, NULL, '2025-03-01 14:13:10', '2025-03-01 14:13:10', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24745, 6426, '10f3649b-f2e8-4d6a-8cd1-5179200dc953', 'deposit', 100.00, '2025-03-01', '14:10:00', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:14:45', '2025-03-01 14:14:45', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24746, 6426, '10f3649b-f2e8-4d6a-8cd1-5179200dc953', 'withdrawal', 147650.00, '2025-03-01', '14:10:00', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:14:45', '2025-03-01 14:14:45', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24747, 6427, '3eaa21b4-4238-4869-aefd-729835b59de3', 'deposit', 100.00, '2025-03-01', '14:14:46', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:14:59', '2025-03-01 14:14:59', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24748, 6427, '3eaa21b4-4238-4869-aefd-729835b59de3', 'withdrawal', 147650.00, '2025-03-01', '14:14:46', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:14:59', '2025-03-01 14:14:59', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(24749, 6428, '1f5aec87-8da2-49ba-bfc7-71dbbf5d36ff', 'deposit', 100.00, '2025-03-01', '14:14:59', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:16:01', '2025-03-01 14:16:01', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24750, 6428, '1f5aec87-8da2-49ba-bfc7-71dbbf5d36ff', 'withdrawal', 147650.00, '2025-03-01', '14:14:59', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:16:01', '2025-03-01 14:16:01', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24751, 6429, '48531cd4-ca71-45b1-a685-bc25fbb6b83c', 'deposit', 200.00, '2025-03-01', '14:16:02', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:33:24', '2025-03-01 14:33:24', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24752, 6429, '48531cd4-ca71-45b1-a685-bc25fbb6b83c', 'withdrawal', 295300.00, '2025-03-01', '14:16:02', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:33:24', '2025-03-01 14:33:24', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24753, 6430, 'd4e8925f-d382-4018-82ea-697a47d53a68', 'deposit', 10000.00, '2025-03-01', '14:33:25', 'جوڵە کردن لە  IQD بۆ FastPay', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:36:27', '2025-03-01 14:36:27', 731, 760, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24754, 6430, 'd4e8925f-d382-4018-82ea-697a47d53a68', 'withdrawal', 10000.00, '2025-03-01', '14:33:25', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:36:27', '2025-03-01 14:36:27', 760, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24755, 6430, 'd4e8925f-d382-4018-82ea-697a47d53a68', 'withdrawal', 10000.00, '2025-03-01', '14:33:25', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:36:27', '2025-03-01 14:36:27', 67, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24756, 6430, 'd4e8925f-d382-4018-82ea-697a47d53a68', 'deposit', 0.00, '2025-03-01', '14:33:25', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:36:27', '2025-03-01 14:36:27', 68, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24757, 6431, '1e8fa330-d3de-4a56-a2a0-a990e0a0868d', 'deposit', 100.00, '2025-03-01', '14:36:28', 'جوڵە کردن لە  USD بۆ IQD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:37:24', '2025-03-01 14:37:24', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24758, 6431, '1e8fa330-d3de-4a56-a2a0-a990e0a0868d', 'withdrawal', 147500.00, '2025-03-01', '14:36:28', 'جوڵە کردن لە IQD بۆ USD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:37:24', '2025-03-01 14:37:24', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24759, 6432, '658a63d3-95c1-40a3-8889-b10968fec4a3', 'deposit', 100.00, '2025-03-01', '14:37:24', 'جوڵە کردن لە  USD بۆ IQD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:42:04', '2025-03-01 14:42:04', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24760, 6432, '658a63d3-95c1-40a3-8889-b10968fec4a3', 'withdrawal', 147500.00, '2025-03-01', '14:37:24', 'جوڵە کردن لە IQD بۆ USD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:42:04', '2025-03-01 14:42:04', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24761, 6433, '4e770f1a-75c5-47fe-8e8a-2ba35ac5daa8', 'deposit', 100.00, '2025-03-01', '14:42:05', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:48:37', '2025-03-01 14:48:37', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24762, 6433, '4e770f1a-75c5-47fe-8e8a-2ba35ac5daa8', 'withdrawal', 147650.00, '2025-03-01', '14:42:05', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:48:37', '2025-03-01 14:48:37', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24763, 6434, '23cd4a2b-1145-49bb-8626-3988091e8f62', 'deposit', 500.00, '2025-03-01', '14:48:37', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:50:51', '2025-03-01 14:50:51', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24764, 6434, '23cd4a2b-1145-49bb-8626-3988091e8f62', 'withdrawal', 738250.00, '2025-03-01', '14:48:37', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:50:51', '2025-03-01 14:50:51', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24765, 6435, 'af05c014-a6f1-4d97-ad83-f44e591409e2', 'deposit', 500.00, '2025-03-01', '14:50:52', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:52:27', '2025-03-01 14:52:27', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24766, 6435, 'af05c014-a6f1-4d97-ad83-f44e591409e2', 'withdrawal', 738250.00, '2025-03-01', '14:50:52', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:52:27', '2025-03-01 14:52:27', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24767, 6436, 'f84fbb58-80f1-414b-92f4-54449f9c10a4', 'deposit', 900.00, '2025-03-01', '14:52:27', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:54:18', '2025-03-01 14:54:18', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24768, 6436, 'f84fbb58-80f1-414b-92f4-54449f9c10a4', 'withdrawal', 1328850.00, '2025-03-01', '14:52:27', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:54:18', '2025-03-01 14:54:18', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24769, 6437, '4850dc36-d827-47ec-9600-2161fc7cb409', 'deposit', 200.00, '2025-03-01', '14:54:19', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:55:05', '2025-03-01 14:55:05', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24770, 6437, '4850dc36-d827-47ec-9600-2161fc7cb409', 'withdrawal', 295300.00, '2025-03-01', '14:54:19', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:55:05', '2025-03-01 14:55:05', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24771, 6438, 'b7b5f377-f364-4695-a581-7f2b1eab8d40', 'deposit', 100.00, '2025-03-01', '14:55:06', 'جوڵە کردن لە  USD بۆ IQD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:56:54', '2025-03-01 14:56:54', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24772, 6438, 'b7b5f377-f364-4695-a581-7f2b1eab8d40', 'withdrawal', 147500.00, '2025-03-01', '14:55:06', 'جوڵە کردن لە IQD بۆ USD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 14:56:54', '2025-03-01 14:56:54', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24773, 6439, '92a93a68-4969-4b7c-9847-720d3acfb124', 'deposit', 1035300.00, '2025-03-01', '14:56:54', 'جوڵە کردن لە  IQD بۆ USD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:02:57', '2025-03-01 15:02:57', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24774, 6439, '92a93a68-4969-4b7c-9847-720d3acfb124', 'withdrawal', 700.00, '2025-03-01', '14:56:54', 'جوڵە کردن لە USD بۆ IQD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:02:57', '2025-03-01 15:02:57', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24775, 6440, '95734455-091f-4f4d-a0dc-63a93d5d355c', 'deposit', 100.00, '2025-03-01', '15:03:01', 'جوڵە کردن لە  USD بۆ IQD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:05:13', '2025-03-01 15:05:13', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24776, 6440, '95734455-091f-4f4d-a0dc-63a93d5d355c', 'withdrawal', 147500.00, '2025-03-01', '15:03:01', 'جوڵە کردن لە IQD بۆ USD', 1475.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:05:13', '2025-03-01 15:05:13', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24777, 6441, '6c7f7108-85ea-49cd-94f0-81e0f90726e6', 'deposit', 591600.00, '2025-03-01', '15:05:14', 'جوڵە کردن لە  IQD بۆ USD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:08:57', '2025-03-01 15:08:57', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24778, 6441, '6c7f7108-85ea-49cd-94f0-81e0f90726e6', 'withdrawal', 400.00, '2025-03-01', '15:05:14', 'جوڵە کردن لە USD بۆ IQD', 1479.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:08:57', '2025-03-01 15:08:57', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24779, 6442, '92a09669-7fc3-4a9b-9df0-9a922b2aa85a', 'deposit', 21000.00, '2025-03-01', '15:08:58', 'جوڵە کردن لە  IQD بۆ Card Hows', 300.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:09:31', '2025-03-01 15:09:31', 731, 764, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24780, 6442, '92a09669-7fc3-4a9b-9df0-9a922b2aa85a', 'withdrawal', 20700.00, '2025-03-01', '15:08:58', 'جوڵە کردن لە Card Hows بۆ IQD', 300.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:09:31', '2025-03-01 15:09:31', 764, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24781, 6442, '92a09669-7fc3-4a9b-9df0-9a922b2aa85a', 'withdrawal', 20700.00, '2025-03-01', '15:08:58', 'جوڵە کردن لە Card Hows بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:09:31', '2025-03-01 15:09:31', 73, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24782, 6442, '92a09669-7fc3-4a9b-9df0-9a922b2aa85a', 'deposit', 300.00, '2025-03-01', '15:08:58', 'جوڵە کردن لە Card Hows بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:09:31', '2025-03-01 15:09:31', 74, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24783, 6443, '5e0c0b9d-f84e-47c0-b801-ca3479b77bd1', 'deposit', 400.00, '2025-03-01', '15:09:31', 'جوڵە کردن لە  USD بۆ IQD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:14:58', '2025-03-01 15:14:58', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24784, 6443, '5e0c0b9d-f84e-47c0-b801-ca3479b77bd1', 'withdrawal', 590600.00, '2025-03-01', '15:09:31', 'جوڵە کردن لە IQD بۆ USD', 1476.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:14:58', '2025-03-01 15:14:58', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24787, 6445, 'c9cb647f-65c2-45bd-990b-aa0fc53b423a', 'deposit', 295500.00, '2025-03-01', '15:17:38', 'جوڵە کردن لە  IQD بۆ USD', 1477.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:20:23', '2025-03-01 15:20:23', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24788, 6445, 'c9cb647f-65c2-45bd-990b-aa0fc53b423a', 'withdrawal', 200.00, '2025-03-01', '15:17:38', 'جوڵە کردن لە USD بۆ IQD', 1477.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:20:23', '2025-03-01 15:20:23', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24789, NULL, '060d234b-9707-4196-8e0c-53312ebd197e', 'deposit', 55000.00, '2025-03-01', '15:33:01', NULL, 0.00, 134, 'hatu karem', NULL, NULL, NULL, NULL, '2025-03-01 15:33:01', '2025-03-01 15:33:01', 183, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24790, NULL, '060d234b-9707-4196-8e0c-53312ebd197e', 'deposit', 55000.00, '2025-03-01', '15:33:01', NULL, 0.00, 134, 'hatu karem', NULL, NULL, NULL, NULL, '2025-03-01 15:33:01', '2025-03-01 15:33:01', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24791, NULL, '060d234b-9707-4196-8e0c-53312ebd197e', 'deposit', 0.00, '2025-03-01', '15:33:01', 'Fee collected for deposit', 0.00, 134, 'hatu karem', NULL, NULL, NULL, NULL, '2025-03-01 15:33:01', '2025-03-01 15:33:01', 23, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24792, NULL, '10c84bb3-e825-4c25-b129-4c0d3b89c07d', 'withdrawal', 10000.00, '2025-03-01', '15:34:32', NULL, 0.00, 134, 'k karem', NULL, NULL, NULL, NULL, '2025-03-01 15:34:32', '2025-03-01 15:34:32', 1048, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24793, NULL, '10c84bb3-e825-4c25-b129-4c0d3b89c07d', 'withdrawal', 10000.00, '2025-03-01', '15:34:32', NULL, 0.00, 134, 'k karem', NULL, NULL, NULL, NULL, '2025-03-01 15:34:32', '2025-03-01 15:34:32', 1, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24794, NULL, '10c84bb3-e825-4c25-b129-4c0d3b89c07d', 'deposit', 0.00, '2025-03-01', '15:34:32', 'Fee collected for withdrawal', 0.00, 134, 'k karem', NULL, NULL, NULL, NULL, '2025-03-01 15:34:32', '2025-03-01 15:34:32', 22, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24795, NULL, '73c95d61-a97b-4403-a971-a04f1324d060', 'withdrawal', 10000.00, '2025-03-01', '15:38:13', NULL, NULL, 134, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:38:13', '2025-03-01 15:38:13', 1016, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24796, NULL, '73c95d61-a97b-4403-a971-a04f1324d060', 'deposit', 10000.00, '2025-03-01', '15:38:13', NULL, NULL, 134, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:38:13', '2025-03-01 15:38:13', 730, 1016, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24797, 6446, 'b6e7abeb-635b-458d-81be-6e355a325f62', 'deposit', 301000.00, '2025-03-01', '15:43:29', 'جوڵە کردن لە  IQD بۆ FIB', 1000.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:47:08', '2025-03-01 15:47:08', 964, 965, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24798, 6446, 'b6e7abeb-635b-458d-81be-6e355a325f62', 'withdrawal', 300000.00, '2025-03-01', '15:43:29', 'جوڵە کردن لە FIB بۆ IQD', 1000.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:47:08', '2025-03-01 15:47:08', 965, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24799, 6446, 'b6e7abeb-635b-458d-81be-6e355a325f62', 'withdrawal', 300000.00, '2025-03-01', '15:43:29', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:47:08', '2025-03-01 15:47:08', 4, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24800, 6446, 'b6e7abeb-635b-458d-81be-6e355a325f62', 'deposit', 1000.00, '2025-03-01', '15:43:29', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:47:08', '2025-03-01 15:47:08', 457, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24801, 6447, '010fdf27-f1ea-4240-84d8-3dc9d228f387', 'deposit', 40000.00, '2025-03-01', '15:47:09', 'جوڵە کردن لە  IQD بۆ Qi Card', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:07', '2025-03-01 15:49:07', 964, 996, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24802, 6447, '010fdf27-f1ea-4240-84d8-3dc9d228f387', 'withdrawal', 40000.00, '2025-03-01', '15:47:09', 'جوڵە کردن لە Qi Card بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:07', '2025-03-01 15:49:07', 996, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24803, 6447, '010fdf27-f1ea-4240-84d8-3dc9d228f387', 'withdrawal', 40000.00, '2025-03-01', '15:47:09', 'جوڵە کردن لە Qi Card بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:07', '2025-03-01 15:49:07', 69, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24804, 6447, '010fdf27-f1ea-4240-84d8-3dc9d228f387', 'deposit', 0.00, '2025-03-01', '15:47:09', 'جوڵە کردن لە Qi Card بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:07', '2025-03-01 15:49:07', 70, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24805, 6448, '860ace25-68bf-4618-a1b2-74f79072ad31', 'deposit', 30000.00, '2025-03-01', '15:49:07', 'جوڵە کردن لە  IQD بۆ FastPay', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:24', '2025-03-01 15:49:24', 964, 993, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24806, 6448, '860ace25-68bf-4618-a1b2-74f79072ad31', 'withdrawal', 30000.00, '2025-03-01', '15:49:07', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:24', '2025-03-01 15:49:24', 993, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24807, 6448, '860ace25-68bf-4618-a1b2-74f79072ad31', 'withdrawal', 30000.00, '2025-03-01', '15:49:07', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:24', '2025-03-01 15:49:24', 67, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24808, 6448, '860ace25-68bf-4618-a1b2-74f79072ad31', 'deposit', 0.00, '2025-03-01', '15:49:07', 'جوڵە کردن لە FastPay بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:24', '2025-03-01 15:49:24', 68, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24809, 6449, '24bd39d5-b226-489b-8eee-4d3715867e49', 'deposit', 5250.00, '2025-03-01', '15:49:25', 'جوڵە کردن لە  IQD بۆ fast pay card', 250.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:44', '2025-03-01 15:49:44', 964, 998, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24810, 6449, '24bd39d5-b226-489b-8eee-4d3715867e49', 'withdrawal', 5000.00, '2025-03-01', '15:49:25', 'جوڵە کردن لە fast pay card بۆ IQD', 250.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:44', '2025-03-01 15:49:44', 998, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24811, 6449, '24bd39d5-b226-489b-8eee-4d3715867e49', 'withdrawal', 5000.00, '2025-03-01', '15:49:25', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:44', '2025-03-01 15:49:44', 71, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24812, 6449, '24bd39d5-b226-489b-8eee-4d3715867e49', 'deposit', 250.00, '2025-03-01', '15:49:25', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:49:44', '2025-03-01 15:49:44', 72, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24813, 6450, '2d633986-c124-4053-a694-04f296bbc071', 'deposit', 1395000.00, '2025-03-01', '15:49:44', 'جوڵە کردن لە  Qi Card بۆ IQD', 4000.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:50:10', '2025-03-01 15:50:10', 996, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24814, 6450, '2d633986-c124-4053-a694-04f296bbc071', 'withdrawal', 1391000.00, '2025-03-01', '15:49:44', 'جوڵە کردن لە IQD بۆ Qi Card', 4000.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:50:10', '2025-03-01 15:50:10', 964, 996, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24815, 6450, '2d633986-c124-4053-a694-04f296bbc071', 'deposit', 1395000.00, '2025-03-01', '15:49:44', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:50:10', '2025-03-01 15:50:10', 69, 996, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24816, 6450, '2d633986-c124-4053-a694-04f296bbc071', 'deposit', 4000.00, '2025-03-01', '15:49:44', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:50:10', '2025-03-01 15:50:10', 70, 996, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24817, 6451, '942a625f-8a73-47da-9b8e-b4902d9659d3', 'deposit', 7978500.00, '2025-03-01', '15:50:16', 'جوڵە کردن لە  IQD بۆ USD', 1477.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:50:41', '2025-03-01 15:50:41', 731, 730, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24818, 6451, '942a625f-8a73-47da-9b8e-b4902d9659d3', 'withdrawal', 5400.00, '2025-03-01', '15:50:16', 'جوڵە کردن لە USD بۆ IQD', 1477.50, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-01 15:50:41', '2025-03-01 15:50:41', 730, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24819, NULL, '59b2e74a-49fd-476e-9e9d-6a948902b882', 'withdrawal', 520000.00, '2025-03-01', '15:56:28', NULL, 0.00, 134, 'mahmud', NULL, NULL, NULL, NULL, '2025-03-01 15:56:28', '2025-03-01 15:56:28', 513, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24820, NULL, '59b2e74a-49fd-476e-9e9d-6a948902b882', 'withdrawal', 520000.00, '2025-03-01', '15:56:28', NULL, 0.00, 134, 'mahmud', NULL, NULL, NULL, NULL, '2025-03-01 15:56:28', '2025-03-01 15:56:28', 2, 513, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24821, NULL, '59b2e74a-49fd-476e-9e9d-6a948902b882', 'deposit', 0.00, '2025-03-01', '15:56:28', 'Fee collected for withdrawal', 0.00, 134, 'mahmud', NULL, NULL, NULL, NULL, '2025-03-01 15:56:28', '2025-03-01 15:56:28', 23, 513, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24822, NULL, 'c426c117-1c37-4dbb-be4e-fce8e1fadb82', 'withdrawal', 620000.00, '2025-03-01', '15:56:54', NULL, 0.00, 134, 'ibrahim', NULL, NULL, NULL, NULL, '2025-03-01 15:56:54', '2025-03-01 15:56:54', 513, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24823, NULL, 'c426c117-1c37-4dbb-be4e-fce8e1fadb82', 'withdrawal', 620000.00, '2025-03-01', '15:56:54', NULL, 0.00, 134, 'ibrahim', NULL, NULL, NULL, NULL, '2025-03-01 15:56:54', '2025-03-01 15:56:54', 2, 513, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24824, NULL, 'c426c117-1c37-4dbb-be4e-fce8e1fadb82', 'deposit', 0.00, '2025-03-01', '15:56:54', 'Fee collected for withdrawal', 0.00, 134, 'ibrahim', NULL, NULL, NULL, NULL, '2025-03-01 15:56:54', '2025-03-01 15:56:54', 23, 513, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24825, 6452, '32d22e6b-08dc-488b-a7b4-98b72f55e3bb', 'deposit', 150300.00, '2025-03-01', '19:45:13', 'جوڵە کردن لە  IQD بۆ FIB', 300.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 19:45:49', '2025-03-01 19:45:49', 964, 965, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24826, 6452, '32d22e6b-08dc-488b-a7b4-98b72f55e3bb', 'withdrawal', 150000.00, '2025-03-01', '19:45:13', 'جوڵە کردن لە FIB بۆ IQD', 300.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 19:45:49', '2025-03-01 19:45:49', 965, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24827, 6452, '32d22e6b-08dc-488b-a7b4-98b72f55e3bb', 'deposit', 150300.00, '2025-03-01', '19:45:13', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 19:45:49', '2025-03-01 19:45:49', 2, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24828, 6452, '32d22e6b-08dc-488b-a7b4-98b72f55e3bb', 'deposit', 300.00, '2025-03-01', '19:45:13', 'جوڵە کردن لە FIB بۆ IQD', 0.00, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-01 19:45:49', '2025-03-01 19:45:49', 23, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24829, NULL, 'ed2cc970-8b56-4a38-8bfd-e0683d75b6f3', 'withdrawal', 200000.00, '2025-03-01', '20:19:22', NULL, 0.00, 144, 'Payadar', NULL, NULL, NULL, NULL, '2025-03-01 20:19:22', '2025-03-01 20:19:22', 284, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24830, NULL, 'ed2cc970-8b56-4a38-8bfd-e0683d75b6f3', 'withdrawal', 200000.00, '2025-03-01', '20:19:22', NULL, 0.00, 144, 'Payadar', NULL, NULL, NULL, NULL, '2025-03-01 20:19:22', '2025-03-01 20:19:22', 2, 284, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24831, NULL, '741ea0c9-f5f1-4063-85f0-46230c360dd6', 'deposit', 220.00, '2025-03-01', '21:17:06', NULL, 0.00, 136, 'Sousan peivasteh', NULL, NULL, NULL, NULL, '2025-03-01 21:17:06', '2025-03-01 21:17:06', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24832, NULL, '741ea0c9-f5f1-4063-85f0-46230c360dd6', 'deposit', 220.00, '2025-03-01', '21:17:06', NULL, 0.00, 136, 'Sousan peivasteh', NULL, NULL, NULL, NULL, '2025-03-01 21:17:06', '2025-03-01 21:17:06', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24833, NULL, 'efac2f8e-7a1d-4908-bb1c-f314b87e2f0f', 'withdrawal', 20500.00, '2025-03-01', '21:44:32', NULL, 0.00, 144, 'Hozan', NULL, NULL, NULL, NULL, '2025-03-01 21:44:32', '2025-03-01 21:44:32', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24834, NULL, 'efac2f8e-7a1d-4908-bb1c-f314b87e2f0f', 'withdrawal', 20500.00, '2025-03-01', '21:44:32', NULL, 0.00, 144, 'Hozan', NULL, NULL, NULL, NULL, '2025-03-01 21:44:32', '2025-03-01 21:44:32', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24835, NULL, '899ecf87-bbdc-4060-aae1-4b605fca6f97', 'withdrawal', 10000.00, '2025-03-02', '10:42:30', NULL, 0.00, 132, 'Rozh ismahel qadr', NULL, NULL, NULL, NULL, '2025-03-02 10:42:30', '2025-03-02 10:42:30', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24836, NULL, '899ecf87-bbdc-4060-aae1-4b605fca6f97', 'withdrawal', 10000.00, '2025-03-02', '10:42:30', NULL, 0.00, 132, 'Rozh ismahel qadr', NULL, NULL, NULL, NULL, '2025-03-02 10:42:30', '2025-03-02 10:42:30', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24837, NULL, '906a5870-6b54-47b3-89b6-bf07c4c758b6', 'withdrawal', 20000.00, '2025-03-02', '10:58:59', 'test', 0.00, 134, '', NULL, NULL, NULL, NULL, '2025-03-02 10:58:59', '2025-03-02 10:58:59', 1107, 1016, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24838, NULL, '906a5870-6b54-47b3-89b6-bf07c4c758b6', 'deposit', 20000.00, '2025-03-02', '10:58:59', 'test', 0.00, 134, '', NULL, NULL, NULL, NULL, '2025-03-02 10:58:59', '2025-03-02 10:58:59', NULL, 1107, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24839, NULL, 'd091be1c-4bac-495a-8584-cb035416d7b8', 'deposit', 20000.00, '2025-03-02', '10:59:55', 'سفر کردنەوەی بەڵانس', 0.00, 1, 'System', NULL, NULL, NULL, NULL, '2025-03-02 10:59:55', '2025-03-02 10:59:55', 1107, NULL, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24840, NULL, 'cb589847-ff3f-4d8c-bd94-3c2620483568', 'withdrawal', 20000.00, '2025-03-02', '11:02:26', 'test', 0.00, 134, '', NULL, NULL, NULL, NULL, '2025-03-02 11:02:26', '2025-03-02 11:02:26', 1107, 1016, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24841, NULL, 'cb589847-ff3f-4d8c-bd94-3c2620483568', 'deposit', 20000.00, '2025-03-02', '11:02:26', 'test', 0.00, 134, '', NULL, NULL, NULL, NULL, '2025-03-02 11:02:26', '2025-03-02 11:02:26', NULL, 1107, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24842, NULL, '5808e491-20fb-4c8b-93cb-1bc9ac53ca15', 'withdrawal', 11000000.00, '2025-03-02', '11:03:16', 'test', 0.00, 134, '', NULL, NULL, NULL, NULL, '2025-03-02 11:03:16', '2025-03-02 11:03:16', 1108, 1017, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24843, NULL, '5808e491-20fb-4c8b-93cb-1bc9ac53ca15', 'deposit', 11000000.00, '2025-03-02', '11:03:16', 'test', 0.00, 134, '', NULL, NULL, NULL, NULL, '2025-03-02 11:03:16', '2025-03-02 11:03:16', NULL, 1108, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24844, NULL, 'b0dce86b-97f4-4f24-8030-49d8e048a354', 'deposit', 20000.00, '2025-03-02', '11:04:14', 'سفر کردنەوەی بەڵانس', 0.00, 1, 'System', NULL, NULL, NULL, NULL, '2025-03-02 11:04:14', '2025-03-02 11:04:14', 1107, NULL, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24845, NULL, '94b69914-8a15-4f4a-8017-94dfa53cbc69', 'deposit', 11000000.00, '2025-03-02', '11:04:16', 'سفر کردنەوەی بەڵانس', 0.00, 1, 'System', NULL, NULL, NULL, NULL, '2025-03-02 11:04:16', '2025-03-02 11:04:16', 1108, NULL, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24846, NULL, '6ffeab4e-a1b8-43a5-b294-80f25cef9c10', 'deposit', 20000.00, '2025-03-02', '11:06:12', 'سفر کردنەوەی بەڵانس', 0.00, 1, 'System', NULL, NULL, NULL, NULL, '2025-03-02 11:06:12', '2025-03-02 11:06:12', 1016, NULL, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24847, NULL, '948fcb8c-bd94-4109-a02e-effa8674dfeb', 'deposit', 11100000.00, '2025-03-02', '11:06:14', 'سفر کردنەوەی بەڵانس', 0.00, 1, 'System', NULL, NULL, NULL, NULL, '2025-03-02 11:06:14', '2025-03-02 11:06:14', 1017, NULL, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24848, NULL, '69a20a87-bec7-44eb-ad48-8b07e505d22e', 'withdrawal', 20000.00, '2025-03-02', '11:08:56', NULL, 0.00, 134, 'k mder', NULL, NULL, NULL, NULL, '2025-03-02 11:08:56', '2025-03-02 11:08:56', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24849, NULL, '69a20a87-bec7-44eb-ad48-8b07e505d22e', 'withdrawal', 20000.00, '2025-03-02', '11:08:56', NULL, 0.00, 134, 'k mder', NULL, NULL, NULL, NULL, '2025-03-02 11:08:56', '2025-03-02 11:08:56', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24850, NULL, '69a20a87-bec7-44eb-ad48-8b07e505d22e', 'deposit', 0.00, '2025-03-02', '11:08:56', 'Fee collected for withdrawal', 0.00, 134, 'k mder', NULL, NULL, NULL, NULL, '2025-03-02 11:08:56', '2025-03-02 11:08:56', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(24851, NULL, '2c4155b1-14f4-4f8c-a73f-706ef4101b22', 'deposit', 18666012.00, '2025-03-02', '11:10:55', NULL, 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-02 11:10:55', '2025-03-02 11:10:55', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24852, NULL, '2c4155b1-14f4-4f8c-a73f-706ef4101b22', 'deposit', 18666012.00, '2025-03-02', '11:10:55', NULL, 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-02 11:10:55', '2025-03-02 11:10:55', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24853, NULL, '2c4155b1-14f4-4f8c-a73f-706ef4101b22', 'deposit', 0.00, '2025-03-02', '11:10:55', 'Fee collected for deposit', 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-02 11:10:55', '2025-03-02 11:10:55', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24854, NULL, '937b0ab0-fe2a-4aa8-997a-1961e8348440', 'withdrawal', 12634.00, '2025-03-02', '11:11:23', NULL, 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-02 11:11:23', '2025-03-02 11:11:23', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24855, NULL, '937b0ab0-fe2a-4aa8-997a-1961e8348440', 'withdrawal', 12634.00, '2025-03-02', '11:11:23', NULL, 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-02 11:11:23', '2025-03-02 11:11:23', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24856, NULL, '937b0ab0-fe2a-4aa8-997a-1961e8348440', 'deposit', 0.00, '2025-03-02', '11:11:23', 'Fee collected for withdrawal', 0.00, 134, 'alugor', NULL, NULL, NULL, NULL, '2025-03-02 11:11:23', '2025-03-02 11:11:23', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24857, NULL, '368f4bc3-50ca-47b4-8627-43b82c91e23b', 'withdrawal', 12.00, '2025-03-02', '11:11:56', NULL, 0.00, 134, 16, NULL, NULL, NULL, NULL, '2025-03-02 11:11:56', '2025-03-02 11:13:36', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24858, NULL, '368f4bc3-50ca-47b4-8627-43b82c91e23b', 'withdrawal', 12.00, '2025-03-02', '11:11:56', NULL, 0.00, 134, 16, NULL, NULL, NULL, NULL, '2025-03-02 11:11:56', '2025-03-02 11:13:36', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24859, NULL, '368f4bc3-50ca-47b4-8627-43b82c91e23b', 'withdrawal', 12.00, '2025-03-02', '11:11:56', 'Fee collected for withdrawal', 0.00, 134, 16, NULL, NULL, NULL, NULL, '2025-03-02 11:11:56', '2025-03-02 11:13:36', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24860, NULL, '6f2460ae-75b7-45b6-8dd7-808a9d7a93c8', 'withdrawal', 15000000.00, '2025-03-02', '11:14:58', NULL, 0.00, 1, 'sarf bank zain', NULL, NULL, NULL, NULL, '2025-03-02 11:14:58', '2025-03-02 11:14:58', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24861, NULL, '6f2460ae-75b7-45b6-8dd7-808a9d7a93c8', 'withdrawal', 15000000.00, '2025-03-02', '11:14:58', NULL, 0.00, 1, 'sarf bank zain', NULL, NULL, NULL, NULL, '2025-03-02 11:14:58', '2025-03-02 11:14:58', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24862, NULL, '6f2460ae-75b7-45b6-8dd7-808a9d7a93c8', 'deposit', 0.00, '2025-03-02', '11:14:58', 'Fee collected for withdrawal', 0.00, 1, 'sarf bank zain', NULL, NULL, NULL, NULL, '2025-03-02 11:14:58', '2025-03-02 11:14:58', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24863, NULL, 'bc2a6a8b-4c70-453f-bdd1-a01917ad3656', 'deposit', 8030000.00, '2025-03-02', '11:15:36', NULL, 0.00, 1, 'maktab runaki', NULL, NULL, NULL, NULL, '2025-03-02 11:15:36', '2025-03-02 11:15:36', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24864, NULL, 'bc2a6a8b-4c70-453f-bdd1-a01917ad3656', 'deposit', 8030000.00, '2025-03-02', '11:15:36', NULL, 0.00, 1, 'maktab runaki', NULL, NULL, NULL, NULL, '2025-03-02 11:15:36', '2025-03-02 11:15:36', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24865, NULL, 'bc2a6a8b-4c70-453f-bdd1-a01917ad3656', 'deposit', 0.00, '2025-03-02', '11:15:36', 'Fee collected for deposit', 0.00, 1, 'maktab runaki', NULL, NULL, NULL, NULL, '2025-03-02 11:15:36', '2025-03-02 11:15:36', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24866, NULL, '26d7b364-df0a-47fb-97b6-5b7fe46633b6', 'deposit', 2809000.00, '2025-03-02', '11:18:30', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-03-02 11:18:30', '2025-03-02 11:18:30', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24867, NULL, '26d7b364-df0a-47fb-97b6-5b7fe46633b6', 'deposit', 2809000.00, '2025-03-02', '11:18:30', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-03-02 11:18:30', '2025-03-02 11:18:30', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24868, NULL, '26d7b364-df0a-47fb-97b6-5b7fe46633b6', 'deposit', 0.00, '2025-03-02', '11:18:30', 'Fee collected for deposit', 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-03-02 11:18:30', '2025-03-02 11:18:30', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24869, NULL, '803c243a-5548-44ce-9765-a3ebf5212444', 'withdrawal', 5000.00, '2025-03-02', '11:25:01', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-03-02 11:25:01', '2025-03-02 11:25:01', 202, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24870, NULL, '803c243a-5548-44ce-9765-a3ebf5212444', 'withdrawal', 5000.00, '2025-03-02', '11:25:01', NULL, 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-03-02 11:25:01', '2025-03-02 11:25:01', 1, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24871, NULL, '803c243a-5548-44ce-9765-a3ebf5212444', 'deposit', 0.00, '2025-03-02', '11:25:01', 'Fee collected for withdrawal', 0.00, 1, 'k sangar', NULL, NULL, NULL, NULL, '2025-03-02 11:25:01', '2025-03-02 11:25:01', 22, 202, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24872, NULL, '8e5e5646-81aa-44af-af39-0d5b947d959f', 'withdrawal', 8030000.00, '2025-03-02', '11:25:59', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-03-02 11:25:59', '2025-03-02 11:25:59', 171, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24873, NULL, '8e5e5646-81aa-44af-af39-0d5b947d959f', 'withdrawal', 8030000.00, '2025-03-02', '11:25:59', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-03-02 11:25:59', '2025-03-02 11:25:59', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24874, NULL, '8e5e5646-81aa-44af-af39-0d5b947d959f', 'deposit', 0.00, '2025-03-02', '11:25:59', 'Fee collected for withdrawal', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-03-02 11:25:59', '2025-03-02 11:25:59', 23, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24875, NULL, '25da1d9b-d7c8-44fc-bab4-f9af675532e5', 'withdrawal', 2.00, '2025-03-02', '11:27:58', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-03-02 11:27:58', '2025-03-02 11:27:58', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24876, NULL, '25da1d9b-d7c8-44fc-bab4-f9af675532e5', 'withdrawal', 2.00, '2025-03-02', '11:27:58', NULL, 2.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-03-02 11:27:58', '2025-03-02 11:27:58', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24877, NULL, '25da1d9b-d7c8-44fc-bab4-f9af675532e5', 'deposit', 2.00, '2025-03-02', '11:27:58', 'Fee collected for withdrawal', 0.00, 1, 'hmula', NULL, NULL, NULL, NULL, '2025-03-02 11:27:58', '2025-03-02 11:27:58', 22, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24878, NULL, '47e8c67d-50ed-4986-893e-ae9dc2eddafb', 'deposit', 2275.00, '2025-03-02', '11:31:38', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-03-02 11:31:38', '2025-03-02 11:31:38', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24879, NULL, '47e8c67d-50ed-4986-893e-ae9dc2eddafb', 'deposit', 2275.00, '2025-03-02', '11:31:38', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-03-02 11:31:38', '2025-03-02 11:31:38', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24880, NULL, '47e8c67d-50ed-4986-893e-ae9dc2eddafb', 'deposit', 0.00, '2025-03-02', '11:31:38', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-03-02 11:31:38', '2025-03-02 11:31:38', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24881, NULL, '94c5c822-0ee6-458f-9e63-36a75371e5a8', 'withdrawal', 10000000.00, '2025-03-02', '11:32:43', NULL, 0.00, 1, 'sarf k sarmand', NULL, NULL, NULL, NULL, '2025-03-02 11:32:43', '2025-03-02 11:32:43', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24882, NULL, '94c5c822-0ee6-458f-9e63-36a75371e5a8', 'withdrawal', 10000000.00, '2025-03-02', '11:32:43', NULL, 0.00, 1, 'sarf k sarmand', NULL, NULL, NULL, NULL, '2025-03-02 11:32:43', '2025-03-02 11:32:43', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24883, NULL, '94c5c822-0ee6-458f-9e63-36a75371e5a8', 'deposit', 0.00, '2025-03-02', '11:32:43', 'Fee collected for withdrawal', 0.00, 1, 'sarf k sarmand', NULL, NULL, NULL, NULL, '2025-03-02 11:32:43', '2025-03-02 11:32:43', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24884, NULL, '0e177d55-a8fa-47cb-921d-8eb042477efe', 'withdrawal', 3129750.00, '2025-03-02', '11:36:30', NULL, 4750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 11:36:30', '2025-03-02 11:36:30', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24885, NULL, '0e177d55-a8fa-47cb-921d-8eb042477efe', 'withdrawal', 3125000.00, '2025-03-02', '11:36:30', NULL, 4750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 11:36:30', '2025-03-02 11:36:30', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24886, NULL, '0e177d55-a8fa-47cb-921d-8eb042477efe', 'withdrawal', 3129750.00, '2025-03-02', '11:36:30', NULL, 4750.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 11:36:30', '2025-03-02 11:36:30', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24887, NULL, 'e172eebb-dce6-47b2-9ddc-951ded44622a', 'deposit', 15000000.00, '2025-03-02', '11:39:23', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-03-02 11:39:23', '2025-03-02 11:39:23', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24888, NULL, 'e172eebb-dce6-47b2-9ddc-951ded44622a', 'deposit', 15000000.00, '2025-03-02', '11:39:23', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-03-02 11:39:23', '2025-03-02 11:39:23', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24889, NULL, 'e172eebb-dce6-47b2-9ddc-951ded44622a', 'deposit', 15000000.00, '2025-03-02', '11:39:23', NULL, 0.00, 1, 'bank', NULL, NULL, NULL, NULL, '2025-03-02 11:39:23', '2025-03-02 11:39:23', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24890, NULL, '875876de-da8a-48c9-b758-cb693c04ad07', 'withdrawal', 2564000.00, '2025-03-02', '11:40:19', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 11:40:19', '2025-03-02 11:40:19', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24891, NULL, '875876de-da8a-48c9-b758-cb693c04ad07', 'withdrawal', 2560000.00, '2025-03-02', '11:40:19', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 11:40:19', '2025-03-02 11:40:19', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24892, NULL, '875876de-da8a-48c9-b758-cb693c04ad07', 'withdrawal', 2564000.00, '2025-03-02', '11:40:19', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 11:40:19', '2025-03-02 11:40:19', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24893, 6453, '067ac35c-b198-4437-9cfc-3207ca2533e8', 'deposit', 1271000.00, '2025-03-02', '11:01:55', 'جوڵە کردن لە  Qi Card بۆ IQD', 3750.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 11:44:11', '2025-03-02 11:44:11', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24894, 6453, '067ac35c-b198-4437-9cfc-3207ca2533e8', 'withdrawal', 1267250.00, '2025-03-02', '11:01:55', 'جوڵە کردن لە IQD بۆ Qi Card', 3750.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 11:44:11', '2025-03-02 11:44:11', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24895, 6453, '067ac35c-b198-4437-9cfc-3207ca2533e8', 'deposit', 1271000.00, '2025-03-02', '11:01:55', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 11:44:11', '2025-03-02 11:44:11', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24896, 6453, '067ac35c-b198-4437-9cfc-3207ca2533e8', 'deposit', 3750.00, '2025-03-02', '11:01:55', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 11:44:11', '2025-03-02 11:44:11', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24897, 6454, '1bef5345-4c80-4212-b9ac-7882986e7822', 'deposit', 1003000.00, '2025-03-02', '11:44:11', 'جوڵە کردن لە  IQD بۆ Qi Card', 3000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 11:44:35', '2025-03-02 11:44:35', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24898, 6454, '1bef5345-4c80-4212-b9ac-7882986e7822', 'withdrawal', 1000000.00, '2025-03-02', '11:44:11', 'جوڵە کردن لە Qi Card بۆ IQD', 3000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 11:44:35', '2025-03-02 11:44:35', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24899, 6454, '1bef5345-4c80-4212-b9ac-7882986e7822', 'withdrawal', 1000000.00, '2025-03-02', '11:44:11', 'جوڵە کردن لە Qi Card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 11:44:35', '2025-03-02 11:44:35', 69, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24900, 6454, '1bef5345-4c80-4212-b9ac-7882986e7822', 'deposit', 3000.00, '2025-03-02', '11:44:11', 'جوڵە کردن لە Qi Card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 11:44:35', '2025-03-02 11:44:35', 70, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24901, NULL, '00472814-918b-4d33-aa1d-d806d941c7d4', 'deposit', 5015060.00, '2025-03-02', '11:50:03', NULL, 0.00, 1, 'wasil', NULL, NULL, NULL, NULL, '2025-03-02 11:50:03', '2025-03-02 11:50:03', 225, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24902, NULL, '00472814-918b-4d33-aa1d-d806d941c7d4', 'deposit', 5015060.00, '2025-03-02', '11:50:03', NULL, 0.00, 1, 'wasil', NULL, NULL, NULL, NULL, '2025-03-02 11:50:03', '2025-03-02 11:50:03', 2, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24903, NULL, '00472814-918b-4d33-aa1d-d806d941c7d4', 'deposit', 0.00, '2025-03-02', '11:50:03', 'Fee collected for deposit', 0.00, 1, 'wasil', NULL, NULL, NULL, NULL, '2025-03-02 11:50:03', '2025-03-02 11:50:03', 23, 225, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24904, NULL, 'c3d85077-1c4d-434a-bc05-b5ab39e6ec70', 'withdrawal', 3630.00, '2025-03-02', '11:51:43', NULL, 0.00, 1, 'sarf aram', NULL, NULL, NULL, NULL, '2025-03-02 11:51:43', '2025-03-02 11:51:43', 180, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24905, NULL, 'c3d85077-1c4d-434a-bc05-b5ab39e6ec70', 'withdrawal', 3630.00, '2025-03-02', '11:51:43', NULL, 0.00, 1, 'sarf aram', NULL, NULL, NULL, NULL, '2025-03-02 11:51:43', '2025-03-02 11:51:43', 1, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24906, NULL, 'c3d85077-1c4d-434a-bc05-b5ab39e6ec70', 'deposit', 0.00, '2025-03-02', '11:51:43', 'Fee collected for withdrawal', 0.00, 1, 'sarf aram', NULL, NULL, NULL, NULL, '2025-03-02 11:51:43', '2025-03-02 11:51:43', 22, 180, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24907, NULL, '6ffc2c7f-93c2-4499-9e22-2a6264a8d2a0', 'withdrawal', 5713500.00, '2025-03-02', '12:04:53', NULL, 8500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 12:04:53', '2025-03-02 12:04:53', 216, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24908, NULL, '6ffc2c7f-93c2-4499-9e22-2a6264a8d2a0', 'withdrawal', 5705000.00, '2025-03-02', '12:04:53', NULL, 8500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 12:04:53', '2025-03-02 12:04:53', 18, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24909, NULL, '6ffc2c7f-93c2-4499-9e22-2a6264a8d2a0', 'withdrawal', 5713500.00, '2025-03-02', '12:04:53', NULL, 8500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 12:04:53', '2025-03-02 12:04:53', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24910, NULL, '52d03bbd-67c4-4b7c-bbd6-3cedeb56c2a9', 'withdrawal', 50150000.00, '2025-03-02', '12:13:08', NULL, 150000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-02 12:13:08', '2025-03-02 12:13:08', 292, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24911, NULL, '52d03bbd-67c4-4b7c-bbd6-3cedeb56c2a9', 'withdrawal', 50150000.00, '2025-03-02', '12:13:08', NULL, 150000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-02 12:13:08', '2025-03-02 12:13:08', 2, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24912, NULL, '52d03bbd-67c4-4b7c-bbd6-3cedeb56c2a9', 'deposit', 150000.00, '2025-03-02', '12:13:08', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-02 12:13:08', '2025-03-02 12:13:08', 23, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24913, NULL, 'b4ab1e76-d7c0-4158-b225-d6571839ba0a', 'deposit', 49295000.00, '2025-03-02', '12:13:46', NULL, 0.00, 1, 'hatu', NULL, NULL, NULL, NULL, '2025-03-02 12:13:46', '2025-03-02 12:13:46', 292, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24914, NULL, 'b4ab1e76-d7c0-4158-b225-d6571839ba0a', 'deposit', 49295000.00, '2025-03-02', '12:13:46', NULL, 0.00, 1, 'hatu', NULL, NULL, NULL, NULL, '2025-03-02 12:13:46', '2025-03-02 12:13:46', 2, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24915, NULL, 'b4ab1e76-d7c0-4158-b225-d6571839ba0a', 'deposit', 0.00, '2025-03-02', '12:13:46', 'Fee collected for deposit', 0.00, 1, 'hatu', NULL, NULL, NULL, NULL, '2025-03-02 12:13:46', '2025-03-02 12:13:46', 23, 292, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24916, 6455, 'df5b32b7-a532-4a10-87db-c6b73aa88129', 'deposit', 1999880.00, '2025-03-02', '12:26:12', 'جوڵە کردن لە  IQD بۆ USD', 1470.50, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-02 12:26:41', '2025-03-02 12:26:41', 964, 963, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24917, 6455, 'df5b32b7-a532-4a10-87db-c6b73aa88129', 'withdrawal', 1360.00, '2025-03-02', '12:26:12', 'جوڵە کردن لە USD بۆ IQD', 1470.50, 144, NULL, NULL, NULL, NULL, NULL, '2025-03-02 12:26:41', '2025-03-02 12:26:41', 963, 964, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24918, 6456, '358e8752-94fa-40ef-9f23-6fce5aa79884', 'deposit', 249000.00, '2025-03-02', '14:32:16', 'جوڵە کردن لە  Qi Card بۆ IQD', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:32:41', '2025-03-02 14:32:41', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24919, 6456, '358e8752-94fa-40ef-9f23-6fce5aa79884', 'withdrawal', 248000.00, '2025-03-02', '14:32:16', 'جوڵە کردن لە IQD بۆ Qi Card', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:32:41', '2025-03-02 14:32:41', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24920, 6456, '358e8752-94fa-40ef-9f23-6fce5aa79884', 'deposit', 249000.00, '2025-03-02', '14:32:16', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:32:41', '2025-03-02 14:32:41', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24921, 6456, '358e8752-94fa-40ef-9f23-6fce5aa79884', 'deposit', 1000.00, '2025-03-02', '14:32:16', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:32:41', '2025-03-02 14:32:41', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24922, 6457, 'ff328238-2a25-4f38-af64-26337b3e24f0', 'deposit', 747000.00, '2025-03-02', '14:32:42', 'جوڵە کردن لە  Qi Card بۆ IQD', 2250.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:33:30', '2025-03-02 14:33:30', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24923, 6457, 'ff328238-2a25-4f38-af64-26337b3e24f0', 'withdrawal', 744750.00, '2025-03-02', '14:32:42', 'جوڵە کردن لە IQD بۆ Qi Card', 2250.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:33:30', '2025-03-02 14:33:30', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24924, 6457, 'ff328238-2a25-4f38-af64-26337b3e24f0', 'deposit', 747000.00, '2025-03-02', '14:32:42', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:33:30', '2025-03-02 14:33:30', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24925, 6457, 'ff328238-2a25-4f38-af64-26337b3e24f0', 'deposit', 2250.00, '2025-03-02', '14:32:42', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:33:30', '2025-03-02 14:33:30', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24926, NULL, 'bcb7811a-2678-4a02-b542-f5c3c8e376e6', 'withdrawal', 4912500.00, '2025-03-02', '14:36:33', NULL, 7500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 14:36:33', '2025-03-02 14:36:33', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24927, NULL, 'bcb7811a-2678-4a02-b542-f5c3c8e376e6', 'withdrawal', 4905000.00, '2025-03-02', '14:36:33', NULL, 7500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 14:36:33', '2025-03-02 14:36:33', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24928, NULL, 'bcb7811a-2678-4a02-b542-f5c3c8e376e6', 'withdrawal', 4912500.00, '2025-03-02', '14:36:33', NULL, 7500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 14:36:33', '2025-03-02 14:36:33', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24929, NULL, '48be7f54-a9fb-4018-97df-b792f7606088', 'withdrawal', 301000.00, '2025-03-02', '14:37:58', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 14:37:58', '2025-03-02 14:37:58', 183, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24930, NULL, '48be7f54-a9fb-4018-97df-b792f7606088', 'withdrawal', 300000.00, '2025-03-02', '14:37:58', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 14:37:58', '2025-03-02 14:37:58', 18, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24931, NULL, '48be7f54-a9fb-4018-97df-b792f7606088', 'withdrawal', 301000.00, '2025-03-02', '14:37:58', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 14:37:58', '2025-03-02 14:37:58', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24932, NULL, '54e0c687-90e0-4094-9727-64c3451db2f3', 'withdrawal', 502000.00, '2025-03-02', '14:48:34', NULL, 2000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-02 14:48:34', '2025-03-02 14:48:34', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24933, NULL, '54e0c687-90e0-4094-9727-64c3451db2f3', 'withdrawal', 502000.00, '2025-03-02', '14:48:34', NULL, 2000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-02 14:48:34', '2025-03-02 14:48:34', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24934, NULL, '54e0c687-90e0-4094-9727-64c3451db2f3', 'deposit', 2000.00, '2025-03-02', '14:48:34', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-02 14:48:34', '2025-03-02 14:48:34', 23, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24935, NULL, 'b706c5c5-88f6-4cd2-813c-e78a5d342cd0', 'withdrawal', 3093.00, '2025-03-02', '14:52:37', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-03-02 14:52:37', '2025-03-02 14:52:37', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24936, NULL, 'b706c5c5-88f6-4cd2-813c-e78a5d342cd0', 'withdrawal', 3093.00, '2025-03-02', '14:52:37', NULL, 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-03-02 14:52:37', '2025-03-02 14:52:37', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24937, NULL, 'b706c5c5-88f6-4cd2-813c-e78a5d342cd0', 'deposit', 0.00, '2025-03-02', '14:52:37', 'Fee collected for withdrawal', 0.00, 1, 'm.dijla', NULL, NULL, NULL, NULL, '2025-03-02 14:52:37', '2025-03-02 14:52:37', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24938, NULL, '65e2112c-6bea-4d0b-a69f-6aa35b365030', 'deposit', 354.00, '2025-03-02', '14:53:03', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-03-02 14:53:03', '2025-03-02 14:53:03', 446, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24939, NULL, '65e2112c-6bea-4d0b-a69f-6aa35b365030', 'deposit', 354.00, '2025-03-02', '14:53:03', NULL, 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-03-02 14:53:03', '2025-03-02 14:53:03', 1, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24940, NULL, '65e2112c-6bea-4d0b-a69f-6aa35b365030', 'deposit', 0.00, '2025-03-02', '14:53:03', 'Fee collected for deposit', 0.00, 1, 'twman', NULL, NULL, NULL, NULL, '2025-03-02 14:53:03', '2025-03-02 14:53:03', 22, 446, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24941, 6458, 'a1f21b2d-ec7b-4e99-9f91-751e1a19e506', 'deposit', 439750.00, '2025-03-02', '14:33:31', 'جوڵە کردن لە  IQD بۆ Qi Card', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:53:21', '2025-03-02 14:53:21', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24942, 6458, 'a1f21b2d-ec7b-4e99-9f91-751e1a19e506', 'withdrawal', 438750.00, '2025-03-02', '14:33:31', 'جوڵە کردن لە Qi Card بۆ IQD', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:53:21', '2025-03-02 14:53:21', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24943, 6458, 'a1f21b2d-ec7b-4e99-9f91-751e1a19e506', 'withdrawal', 438750.00, '2025-03-02', '14:33:31', 'جوڵە کردن لە Qi Card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:53:21', '2025-03-02 14:53:21', 69, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24944, 6458, 'a1f21b2d-ec7b-4e99-9f91-751e1a19e506', 'deposit', 1000.00, '2025-03-02', '14:33:31', 'جوڵە کردن لە Qi Card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 14:53:21', '2025-03-02 14:53:21', 70, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24945, NULL, '23c49e64-d8bb-411c-91f1-af5c99d72fb3', 'deposit', 3093.00, '2025-03-02', '14:56:23', NULL, 0.00, 1, 'aso twman', NULL, NULL, NULL, NULL, '2025-03-02 14:56:23', '2025-03-02 14:56:23', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24946, NULL, '23c49e64-d8bb-411c-91f1-af5c99d72fb3', 'deposit', 3093.00, '2025-03-02', '14:56:23', NULL, 0.00, 1, 'aso twman', NULL, NULL, NULL, NULL, '2025-03-02 14:56:23', '2025-03-02 14:56:23', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24947, NULL, '23c49e64-d8bb-411c-91f1-af5c99d72fb3', 'deposit', 0.00, '2025-03-02', '14:56:23', 'Fee collected for deposit', 0.00, 1, 'aso twman', NULL, NULL, NULL, NULL, '2025-03-02 14:56:23', '2025-03-02 14:56:23', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24948, NULL, 'ab94fd07-0661-4c35-9741-1b67ae48c6c3', 'withdrawal', 8757.00, '2025-03-02', '14:56:56', NULL, 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-03-02 14:56:56', '2025-03-02 14:56:56', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24949, NULL, 'ab94fd07-0661-4c35-9741-1b67ae48c6c3', 'withdrawal', 8757.00, '2025-03-02', '14:56:56', NULL, 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-03-02 14:56:56', '2025-03-02 14:56:56', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24950, NULL, 'ab94fd07-0661-4c35-9741-1b67ae48c6c3', 'deposit', 0.00, '2025-03-02', '14:56:56', 'Fee collected for withdrawal', 0.00, 1, 'm.salahaden', NULL, NULL, NULL, NULL, '2025-03-02 14:56:56', '2025-03-02 14:56:56', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(24951, NULL, '4be2b92a-dcaf-41fd-89ca-4c5998d4d979', 'withdrawal', 191000.00, '2025-03-02', '15:00:34', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 15:00:34', '2025-03-02 15:00:34', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24952, NULL, '4be2b92a-dcaf-41fd-89ca-4c5998d4d979', 'withdrawal', 190000.00, '2025-03-02', '15:00:34', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 15:00:34', '2025-03-02 15:00:34', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24953, NULL, '4be2b92a-dcaf-41fd-89ca-4c5998d4d979', 'withdrawal', 191000.00, '2025-03-02', '15:00:34', NULL, 1000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 15:00:34', '2025-03-02 15:00:34', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24954, NULL, 'ebc1f43e-72d0-4f2b-9442-4a853d7aa9cc', 'withdrawal', 400000.00, '2025-03-02', '15:13:33', NULL, 0.00, 1, 'sarf k muhamad ismail', NULL, NULL, NULL, NULL, '2025-03-02 15:13:33', '2025-03-02 15:13:33', 417, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24955, NULL, 'ebc1f43e-72d0-4f2b-9442-4a853d7aa9cc', 'withdrawal', 400000.00, '2025-03-02', '15:13:33', NULL, 0.00, 1, 'sarf k muhamad ismail', NULL, NULL, NULL, NULL, '2025-03-02 15:13:33', '2025-03-02 15:13:33', 2, 417, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24956, NULL, 'ebc1f43e-72d0-4f2b-9442-4a853d7aa9cc', 'deposit', 0.00, '2025-03-02', '15:13:33', 'Fee collected for withdrawal', 0.00, 1, 'sarf k muhamad ismail', NULL, NULL, NULL, NULL, '2025-03-02 15:13:33', '2025-03-02 15:13:33', 23, 417, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24957, NULL, '84bc674d-860d-447f-b263-87dd9bea20c0', 'deposit', 11500.00, '2025-03-02', '15:18:04', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-03-02 15:18:04', '2025-03-02 15:18:04', 81, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24958, NULL, '84bc674d-860d-447f-b263-87dd9bea20c0', 'deposit', 11500.00, '2025-03-02', '15:18:04', NULL, 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-03-02 15:18:04', '2025-03-02 15:18:04', 1, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24959, NULL, '84bc674d-860d-447f-b263-87dd9bea20c0', 'deposit', 0.00, '2025-03-02', '15:18:04', 'Fee collected for deposit', 0.00, 1, 'k ahmed', NULL, NULL, NULL, NULL, '2025-03-02 15:18:04', '2025-03-02 15:18:04', 22, 81, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24960, NULL, '47b2d55e-8953-4575-9e48-16cac69c000b', 'withdrawal', 21000.00, '2025-03-02', '15:19:08', NULL, 1000.00, 1, 'kart asia korek', NULL, NULL, NULL, NULL, '2025-03-02 15:19:08', '2025-03-02 15:19:08', 82, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24961, NULL, '47b2d55e-8953-4575-9e48-16cac69c000b', 'withdrawal', 21000.00, '2025-03-02', '15:19:08', NULL, 1000.00, 1, 'kart asia korek', NULL, NULL, NULL, NULL, '2025-03-02 15:19:08', '2025-03-02 15:19:08', 2, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24962, NULL, '47b2d55e-8953-4575-9e48-16cac69c000b', 'deposit', 1000.00, '2025-03-02', '15:19:08', 'Fee collected for withdrawal', 0.00, 1, 'kart asia korek', NULL, NULL, NULL, NULL, '2025-03-02 15:19:08', '2025-03-02 15:19:08', 23, 82, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24963, 6459, '72d3241e-3545-4da0-b1e6-25e7b4ea4e7e', 'deposit', 2004000.00, '2025-03-02', '14:53:21', 'جوڵە کردن لە  FIB بۆ IQD', 4000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 15:36:41', '2025-03-02 15:36:41', 732, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24964, 6459, '72d3241e-3545-4da0-b1e6-25e7b4ea4e7e', 'withdrawal', 2000000.00, '2025-03-02', '14:53:21', 'جوڵە کردن لە IQD بۆ FIB', 4000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 15:36:41', '2025-03-02 15:36:41', 731, 732, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24965, 6459, '72d3241e-3545-4da0-b1e6-25e7b4ea4e7e', 'deposit', 2004000.00, '2025-03-02', '14:53:21', 'جوڵە کردن لە IQD بۆ FIB', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 15:36:41', '2025-03-02 15:36:41', 4, 732, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24966, 6459, '72d3241e-3545-4da0-b1e6-25e7b4ea4e7e', 'deposit', 4000.00, '2025-03-02', '14:53:21', 'جوڵە کردن لە IQD بۆ FIB', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-02 15:36:41', '2025-03-02 15:36:41', 457, 732, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24967, NULL, '1fa56070-17e1-4011-a137-631f8a90937f', 'deposit', 6500.00, '2025-03-02', '15:40:15', NULL, 0.00, 144, 'Mhamad ihsan abdulla ', NULL, NULL, NULL, NULL, '2025-03-02 15:40:15', '2025-03-02 15:40:15', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24968, NULL, '1fa56070-17e1-4011-a137-631f8a90937f', 'deposit', 6500.00, '2025-03-02', '15:40:15', NULL, 0.00, 144, 'Mhamad ihsan abdulla ', NULL, NULL, NULL, NULL, '2025-03-02 15:40:15', '2025-03-02 15:40:15', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24969, NULL, '7a0bbfdd-eb0b-474c-a9ea-b7ef627c8284', 'withdrawal', 2965.00, '2025-03-02', '15:59:52', NULL, 0.00, 132, 'Alas ahmed mohammedmare', NULL, NULL, NULL, NULL, '2025-03-02 15:59:52', '2025-03-02 15:59:52', 261, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24970, NULL, '7a0bbfdd-eb0b-474c-a9ea-b7ef627c8284', 'withdrawal', 2965.00, '2025-03-02', '15:59:52', NULL, 0.00, 132, 'Alas ahmed mohammedmare', NULL, NULL, NULL, NULL, '2025-03-02 15:59:52', '2025-03-02 15:59:52', 1, 261, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24971, NULL, '5c8f582a-32f1-424b-a27c-12f8e455f29a', 'withdrawal', 1110000.00, '2025-03-02', '17:03:56', NULL, 0.00, 132, 'Mahmood azad haji ', NULL, NULL, NULL, NULL, '2025-03-02 17:03:56', '2025-03-02 17:03:56', 726, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24972, NULL, '5c8f582a-32f1-424b-a27c-12f8e455f29a', 'withdrawal', 1110000.00, '2025-03-02', '17:03:56', NULL, 0.00, 132, 'Mahmood azad haji ', NULL, NULL, NULL, NULL, '2025-03-02 17:03:56', '2025-03-02 17:03:56', 2, 726, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24973, NULL, 'c0b0f100-c4b5-4c5f-8485-465980b2f8ca', 'deposit', 800.00, '2025-03-02', '20:10:28', NULL, 0.00, 1, 'hatw badasty haji salm', NULL, NULL, NULL, NULL, '2025-03-02 20:10:28', '2025-03-02 20:10:28', 954, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24974, NULL, 'c0b0f100-c4b5-4c5f-8485-465980b2f8ca', 'deposit', 800.00, '2025-03-02', '20:10:28', NULL, 0.00, 1, 'hatw badasty haji salm', NULL, NULL, NULL, NULL, '2025-03-02 20:10:28', '2025-03-02 20:10:28', 1, 954, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24975, NULL, 'c0b0f100-c4b5-4c5f-8485-465980b2f8ca', 'deposit', 0.00, '2025-03-02', '20:10:28', 'Fee collected for deposit', 0.00, 1, 'hatw badasty haji salm', NULL, NULL, NULL, NULL, '2025-03-02 20:10:28', '2025-03-02 20:10:28', 22, 954, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24976, NULL, 'ab8111ca-ce03-482c-a768-68d39038ff0d', 'deposit', 1048500.00, '2025-03-02', '20:14:30', NULL, 0.00, 144, 'Alan', NULL, NULL, NULL, NULL, '2025-03-02 20:14:30', '2025-03-02 20:14:30', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24977, NULL, 'ab8111ca-ce03-482c-a768-68d39038ff0d', 'deposit', 1048500.00, '2025-03-02', '20:14:30', NULL, 0.00, 144, 'Alan', NULL, NULL, NULL, NULL, '2025-03-02 20:14:30', '2025-03-02 20:14:30', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24978, NULL, '3d7f0076-8105-466f-b223-70adccdcee5e', 'deposit', 2113500.00, '2025-03-02', '20:14:55', '', 0.00, 144, 'Alan', NULL, NULL, NULL, NULL, '2025-03-02 20:14:55', '2025-03-02 20:14:55', 1044, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24979, NULL, '3d7f0076-8105-466f-b223-70adccdcee5e', 'deposit', 2113500.00, '2025-03-02', '20:14:55', '', 0.00, 144, 'Alan', NULL, NULL, NULL, NULL, '2025-03-02 20:14:55', '2025-03-02 20:14:55', 2, 1044, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24980, NULL, 'b3d3ebff-272a-445f-821e-36b311e8a20a', 'deposit', 200.00, '2025-03-02', '20:25:40', '', 0.00, 144, 'Alan', NULL, NULL, NULL, NULL, '2025-03-02 20:25:40', '2025-03-02 20:25:40', 1045, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24981, NULL, 'b3d3ebff-272a-445f-821e-36b311e8a20a', 'deposit', 200.00, '2025-03-02', '20:25:40', '', 0.00, 144, 'Alan', NULL, NULL, NULL, NULL, '2025-03-02 20:25:40', '2025-03-02 20:25:40', 1, 1045, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24982, NULL, '80ff8481-89aa-4839-b762-2a3350637985', 'withdrawal', 502000.00, '2025-03-02', '20:53:15', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:53:15', '2025-03-02 20:53:15', 183, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24983, NULL, '80ff8481-89aa-4839-b762-2a3350637985', 'withdrawal', 502000.00, '2025-03-02', '20:53:15', NULL, 2000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:53:15', '2025-03-02 20:53:15', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24984, NULL, '80ff8481-89aa-4839-b762-2a3350637985', 'deposit', 2000.00, '2025-03-02', '20:53:15', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:53:15', '2025-03-02 20:53:15', 23, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24985, NULL, '11d02f8c-6f29-4fa1-8af8-041896d4e2a3', 'withdrawal', 1363500.00, '2025-03-02', '20:53:41', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:53:41', '2025-03-02 20:53:41', 183, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24986, NULL, '11d02f8c-6f29-4fa1-8af8-041896d4e2a3', 'withdrawal', 1363500.00, '2025-03-02', '20:53:41', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:53:41', '2025-03-02 20:53:41', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24987, NULL, '11d02f8c-6f29-4fa1-8af8-041896d4e2a3', 'deposit', 3500.00, '2025-03-02', '20:53:41', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:53:41', '2025-03-02 20:53:41', 23, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24988, NULL, '8212620b-a441-4123-a5c3-57430031df98', 'deposit', 2165000.00, '2025-03-02', '20:54:03', NULL, 0.00, 1, 'hatw badasty karem', NULL, NULL, NULL, NULL, '2025-03-02 20:54:03', '2025-03-02 20:54:03', 183, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24989, NULL, '8212620b-a441-4123-a5c3-57430031df98', 'deposit', 2165000.00, '2025-03-02', '20:54:03', NULL, 0.00, 1, 'hatw badasty karem', NULL, NULL, NULL, NULL, '2025-03-02 20:54:03', '2025-03-02 20:54:03', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24990, NULL, '8212620b-a441-4123-a5c3-57430031df98', 'deposit', 0.00, '2025-03-02', '20:54:03', 'Fee collected for deposit', 0.00, 1, 'hatw badasty karem', NULL, NULL, NULL, NULL, '2025-03-02 20:54:03', '2025-03-02 20:54:03', 23, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24991, NULL, '3db3aada-8f0b-4fef-ad74-8d9c743466f7', 'deposit', 9015.00, '2025-03-02', '20:54:27', NULL, 0.00, 1, 'hatw badasty karem', NULL, NULL, NULL, NULL, '2025-03-02 20:54:27', '2025-03-02 20:54:27', 1048, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24992, NULL, '3db3aada-8f0b-4fef-ad74-8d9c743466f7', 'deposit', 9015.00, '2025-03-02', '20:54:27', NULL, 0.00, 1, 'hatw badasty karem', NULL, NULL, NULL, NULL, '2025-03-02 20:54:27', '2025-03-02 20:54:27', 1, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24993, NULL, '3db3aada-8f0b-4fef-ad74-8d9c743466f7', 'deposit', 0.00, '2025-03-02', '20:54:27', 'Fee collected for deposit', 0.00, 1, 'hatw badasty karem', NULL, NULL, NULL, NULL, '2025-03-02 20:54:27', '2025-03-02 20:54:27', 22, 1048, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24994, NULL, '65022365-b5b8-4418-bc91-d02ad19e3a8a', 'withdrawal', 1360500.00, '2025-03-02', '20:55:22', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:55:22', '2025-03-02 20:55:22', 183, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24995, NULL, '65022365-b5b8-4418-bc91-d02ad19e3a8a', 'withdrawal', 1360500.00, '2025-03-02', '20:55:22', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:55:22', '2025-03-02 20:55:22', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24996, NULL, '65022365-b5b8-4418-bc91-d02ad19e3a8a', 'deposit', 3500.00, '2025-03-02', '20:55:22', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:55:22', '2025-03-02 20:55:22', 23, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24997, NULL, '2850e1a9-80ec-4bca-b32e-0601e952b961', 'withdrawal', 1360500.00, '2025-03-02', '20:55:38', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:55:38', '2025-03-02 20:55:38', 183, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24998, NULL, '2850e1a9-80ec-4bca-b32e-0601e952b961', 'withdrawal', 1360500.00, '2025-03-02', '20:55:38', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:55:38', '2025-03-02 20:55:38', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(24999, NULL, '2850e1a9-80ec-4bca-b32e-0601e952b961', 'deposit', 3500.00, '2025-03-02', '20:55:38', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:55:38', '2025-03-02 20:55:38', 23, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25000, NULL, '394b6d2a-d9dd-477a-b6ff-f8ca5874e96b', 'withdrawal', 1158000.00, '2025-03-02', '20:56:14', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:56:14', '2025-03-02 20:56:14', 183, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25001, NULL, '394b6d2a-d9dd-477a-b6ff-f8ca5874e96b', 'withdrawal', 1158000.00, '2025-03-02', '20:56:14', NULL, 3000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:56:14', '2025-03-02 20:56:14', 2, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25002, NULL, '394b6d2a-d9dd-477a-b6ff-f8ca5874e96b', 'deposit', 3000.00, '2025-03-02', '20:56:14', 'Fee collected for withdrawal', 0.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-02 20:56:14', '2025-03-02 20:56:14', 23, 183, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25005, 6460, '4119ebae-715b-4e6b-9c61-8549a48b97d3', 'deposit', 711000.00, '2025-03-03', '09:35:30', 'جوڵە کردن لە  Qi Card بۆ IQD', 2133.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:36:20', '2025-03-03 09:36:20', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25006, 6460, '4119ebae-715b-4e6b-9c61-8549a48b97d3', 'withdrawal', 708750.00, '2025-03-03', '09:35:30', 'جوڵە کردن لە IQD بۆ Qi Card', 2133.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:36:20', '2025-03-03 09:36:20', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25007, 6460, '4119ebae-715b-4e6b-9c61-8549a48b97d3', 'deposit', 711000.00, '2025-03-03', '09:35:30', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:36:20', '2025-03-03 09:36:20', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25008, 6460, '4119ebae-715b-4e6b-9c61-8549a48b97d3', 'deposit', 2133.00, '2025-03-03', '09:35:30', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:36:20', '2025-03-03 09:36:20', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25009, 6461, '521c4854-d0f6-4772-834a-2926ca6dc35c', 'deposit', 146000.00, '2025-03-03', '09:51:46', 'جوڵە کردن لە  Qi Card بۆ IQD', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:52:03', '2025-03-03 09:52:03', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25010, 6461, '521c4854-d0f6-4772-834a-2926ca6dc35c', 'withdrawal', 145000.00, '2025-03-03', '09:51:46', 'جوڵە کردن لە IQD بۆ Qi Card', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:52:03', '2025-03-03 09:52:03', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25011, 6461, '521c4854-d0f6-4772-834a-2926ca6dc35c', 'deposit', 146000.00, '2025-03-03', '09:51:46', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:52:03', '2025-03-03 09:52:03', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25012, 6461, '521c4854-d0f6-4772-834a-2926ca6dc35c', 'deposit', 1000.00, '2025-03-03', '09:51:46', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:52:03', '2025-03-03 09:52:03', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25013, 6462, 'a2e71eeb-f388-49dc-94d8-2a860ab73a4a', 'deposit', 798000.00, '2025-03-03', '09:52:04', 'جوڵە کردن لە  IQD بۆ Zaincash', 3000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:57:51', '2025-03-03 09:57:51', 731, 735, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25014, 6462, 'a2e71eeb-f388-49dc-94d8-2a860ab73a4a', 'withdrawal', 795000.00, '2025-03-03', '09:52:04', 'جوڵە کردن لە Zaincash بۆ IQD', 3000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:57:51', '2025-03-03 09:57:51', 735, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25015, 6462, 'a2e71eeb-f388-49dc-94d8-2a860ab73a4a', 'withdrawal', 795000.00, '2025-03-03', '09:52:04', 'جوڵە کردن لە Zaincash بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:57:51', '2025-03-03 09:57:51', 18, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25016, 6462, 'a2e71eeb-f388-49dc-94d8-2a860ab73a4a', 'deposit', 3000.00, '2025-03-03', '09:52:04', 'جوڵە کردن لە Zaincash بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 09:57:51', '2025-03-03 09:57:51', 63, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25017, 6463, 'addb004b-ebfa-4189-85aa-f0b5f29c358c', 'deposit', 701000.00, '2025-03-03', '09:57:52', 'جوڵە کردن لە  Qi Card بۆ IQD', 2250.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 10:15:55', '2025-03-03 10:15:55', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25018, 6463, 'addb004b-ebfa-4189-85aa-f0b5f29c358c', 'withdrawal', 698750.00, '2025-03-03', '09:57:52', 'جوڵە کردن لە IQD بۆ Qi Card', 2250.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 10:15:55', '2025-03-03 10:15:55', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25019, 6463, 'addb004b-ebfa-4189-85aa-f0b5f29c358c', 'deposit', 701000.00, '2025-03-03', '09:57:52', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 10:15:55', '2025-03-03 10:15:55', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25020, 6463, 'addb004b-ebfa-4189-85aa-f0b5f29c358c', 'deposit', 2250.00, '2025-03-03', '09:57:52', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 10:15:55', '2025-03-03 10:15:55', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25021, 6464, '5d1eb551-4139-4c8d-ba89-28f8c1021b04', 'deposit', 296843.00, '2025-03-03', '10:15:56', 'جوڵە کردن لە  FIB بۆ IQD', 593.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 10:54:34', '2025-03-03 10:54:34', 732, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25022, 6464, '5d1eb551-4139-4c8d-ba89-28f8c1021b04', 'withdrawal', 296250.00, '2025-03-03', '10:15:56', 'جوڵە کردن لە IQD بۆ FIB', 593.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 10:54:34', '2025-03-03 10:54:34', 731, 732, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25023, 6464, '5d1eb551-4139-4c8d-ba89-28f8c1021b04', 'deposit', 296843.00, '2025-03-03', '10:15:56', 'جوڵە کردن لە IQD بۆ FIB', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 10:54:34', '2025-03-03 10:54:34', 4, 732, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25024, 6464, '5d1eb551-4139-4c8d-ba89-28f8c1021b04', 'deposit', 593.00, '2025-03-03', '10:15:56', 'جوڵە کردن لە IQD بۆ FIB', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 10:54:34', '2025-03-03 10:54:34', 457, 732, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25025, 6465, '43a57d17-91db-438b-bbec-e830c3118647', 'deposit', 597000.00, '2025-03-03', '10:54:35', 'جوڵە کردن لە  Qi Card بۆ IQD', 1750.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:22:29', '2025-03-03 11:22:29', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25026, 6465, '43a57d17-91db-438b-bbec-e830c3118647', 'withdrawal', 1044750000.00, '2025-03-03', '10:54:35', 'جوڵە کردن لە IQD بۆ Qi Card', 1750.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:22:29', '2025-03-03 11:22:29', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25027, 6466, 'c34ec5aa-efa7-42e3-bb8f-3b6552bc5b56', 'deposit', 2500000.00, '2025-03-03', '11:41:50', 'جوڵە کردن لە  Qi Card بۆ IQD', 7500.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:42:28', '2025-03-03 11:42:28', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25028, 6466, 'c34ec5aa-efa7-42e3-bb8f-3b6552bc5b56', 'withdrawal', 2492500.00, '2025-03-03', '11:41:50', 'جوڵە کردن لە IQD بۆ Qi Card', 7500.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:42:28', '2025-03-03 11:42:28', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25029, 6466, 'c34ec5aa-efa7-42e3-bb8f-3b6552bc5b56', 'deposit', 2500000.00, '2025-03-03', '11:41:50', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:42:28', '2025-03-03 11:42:28', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25030, 6466, 'c34ec5aa-efa7-42e3-bb8f-3b6552bc5b56', 'deposit', 7500.00, '2025-03-03', '11:41:50', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:42:28', '2025-03-03 11:42:28', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25031, 6467, 'e7d62557-8914-4e4b-abf2-2fdd4b0be23f', 'deposit', 596000.00, '2025-03-03', '11:49:00', 'جوڵە کردن لە  Qi Card بۆ IQD', 1750.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:50:41', '2025-03-03 11:50:41', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25032, 6467, 'e7d62557-8914-4e4b-abf2-2fdd4b0be23f', 'withdrawal', 594250.00, '2025-03-03', '11:49:00', 'جوڵە کردن لە IQD بۆ Qi Card', 1750.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:50:41', '2025-03-03 11:50:41', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25033, 6467, 'e7d62557-8914-4e4b-abf2-2fdd4b0be23f', 'deposit', 596000.00, '2025-03-03', '11:49:00', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:50:41', '2025-03-03 11:50:41', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25034, 6467, 'e7d62557-8914-4e4b-abf2-2fdd4b0be23f', 'deposit', 1750.00, '2025-03-03', '11:49:00', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 11:50:41', '2025-03-03 11:50:41', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25035, NULL, '0c2308bd-c422-49ea-90e2-8ce8952de43d', 'withdrawal', 15045000.00, '2025-03-03', '12:02:19', NULL, 45000.00, 134, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 12:02:19', '2025-03-03 12:02:19', 1104, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25036, NULL, '0c2308bd-c422-49ea-90e2-8ce8952de43d', 'withdrawal', 15045000.00, '2025-03-03', '12:02:19', NULL, 45000.00, 134, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 12:02:19', '2025-03-03 12:02:19', 2, 1104, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25037, NULL, '0c2308bd-c422-49ea-90e2-8ce8952de43d', 'deposit', 45000.00, '2025-03-03', '12:02:19', 'Fee collected for withdrawal', 0.00, 134, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 12:02:19', '2025-03-03 12:02:19', 23, 1104, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25038, 6468, '5515086a-1d7c-4749-9942-e4ee261c4353', 'deposit', 401000.00, '2025-03-03', '11:50:42', 'جوڵە کردن لە  Qi Card بۆ IQD', 1203.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:06:50', '2025-03-03 12:06:50', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25039, 6468, '5515086a-1d7c-4749-9942-e4ee261c4353', 'withdrawal', 399750.00, '2025-03-03', '11:50:42', 'جوڵە کردن لە IQD بۆ Qi Card', 1203.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:06:50', '2025-03-03 12:06:50', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25040, 6468, '5515086a-1d7c-4749-9942-e4ee261c4353', 'deposit', 401000.00, '2025-03-03', '11:50:42', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:06:50', '2025-03-03 12:06:50', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25041, 6468, '5515086a-1d7c-4749-9942-e4ee261c4353', 'deposit', 1203.00, '2025-03-03', '11:50:42', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:06:50', '2025-03-03 12:06:50', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25042, 6469, 'e6906b10-dab7-4b6a-be8e-95e6b4584166', 'deposit', 212000.00, '2025-03-03', '12:06:50', 'جوڵە کردن لە  Qi Card بۆ IQD', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:07:17', '2025-03-03 12:07:17', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25043, 6469, 'e6906b10-dab7-4b6a-be8e-95e6b4584166', 'withdrawal', 211000.00, '2025-03-03', '12:06:50', 'جوڵە کردن لە IQD بۆ Qi Card', 1000.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:07:17', '2025-03-03 12:07:17', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25044, 6469, 'e6906b10-dab7-4b6a-be8e-95e6b4584166', 'deposit', 212000.00, '2025-03-03', '12:06:50', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:07:17', '2025-03-03 12:07:17', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25045, 6469, 'e6906b10-dab7-4b6a-be8e-95e6b4584166', 'deposit', 1000.00, '2025-03-03', '12:06:50', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:07:17', '2025-03-03 12:07:17', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25046, 6470, '3723a8f6-85ea-4cb7-b641-75320f35063b', 'deposit', 492000.00, '2025-03-03', '12:07:18', 'جوڵە کردن لە  Qi Card بۆ IQD', 1500.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:08:44', '2025-03-03 12:08:44', 763, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25047, 6470, '3723a8f6-85ea-4cb7-b641-75320f35063b', 'withdrawal', 490500.00, '2025-03-03', '12:07:18', 'جوڵە کردن لە IQD بۆ Qi Card', 1500.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:08:44', '2025-03-03 12:08:44', 731, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25048, 6470, '3723a8f6-85ea-4cb7-b641-75320f35063b', 'deposit', 492000.00, '2025-03-03', '12:07:18', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:08:44', '2025-03-03 12:08:44', 69, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25049, 6470, '3723a8f6-85ea-4cb7-b641-75320f35063b', 'deposit', 1500.00, '2025-03-03', '12:07:18', 'جوڵە کردن لە IQD بۆ Qi Card', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:08:44', '2025-03-03 12:08:44', 70, 763, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25050, 6471, 'f1af6763-f43d-4daa-b90a-3b201559ec26', 'deposit', 40000.00, '2025-03-03', '12:08:45', 'جوڵە کردن لە  IQD بۆ Card Hows', 300.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:48:51', '2025-03-03 12:48:51', 731, 764, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25051, 6471, 'f1af6763-f43d-4daa-b90a-3b201559ec26', 'withdrawal', 39700.00, '2025-03-03', '12:08:45', 'جوڵە کردن لە Card Hows بۆ IQD', 300.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:48:51', '2025-03-03 12:48:51', 764, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25052, 6471, 'f1af6763-f43d-4daa-b90a-3b201559ec26', 'withdrawal', 39700.00, '2025-03-03', '12:08:45', 'جوڵە کردن لە Card Hows بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:48:51', '2025-03-03 12:48:51', 73, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL);

INSERT INTO `account_transactions` (`id`, `transaction_id`, `transaction_group_id`, `transaction_type`, `transaction_amount`, `transaction_date`, `transaction_time`, `note`, `get_fee`, `user_id`, `person_name`, `sender_name`, `receiver_name`, `sender_phone`, `receiver_phone`, `created_at`, `updated_at`, `from_account_id`, `to_account_id`, `exchange_rate`, `transaction_category`, `status`, `is_primary`, `moneyTransferOnly`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`) VALUES
(25053, 6471, 'f1af6763-f43d-4daa-b90a-3b201559ec26', 'deposit', 300.00, '2025-03-03', '12:08:45', 'جوڵە کردن لە Card Hows بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 12:48:51', '2025-03-03 12:48:51', 74, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25054, 6472, '6170fac3-1096-4b86-a898-9ca040252b12', 'deposit', 60000.00, '2025-03-03', '12:48:54', 'جوڵە کردن لە  IQD بۆ Card Hows', 250.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 13:08:55', '2025-03-03 13:08:55', 731, 764, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25055, 6472, '6170fac3-1096-4b86-a898-9ca040252b12', 'withdrawal', 59750.00, '2025-03-03', '12:48:54', 'جوڵە کردن لە Card Hows بۆ IQD', 250.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 13:08:55', '2025-03-03 13:08:55', 764, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25056, 6472, '6170fac3-1096-4b86-a898-9ca040252b12', 'withdrawal', 59750.00, '2025-03-03', '12:48:54', 'جوڵە کردن لە Card Hows بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 13:08:55', '2025-03-03 13:08:55', 73, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25057, 6472, '6170fac3-1096-4b86-a898-9ca040252b12', 'deposit', 250.00, '2025-03-03', '12:48:54', 'جوڵە کردن لە Card Hows بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 13:08:55', '2025-03-03 13:08:55', 74, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25058, 6473, '2b413e4d-5eb4-4f48-bd25-5390984c1ccb', 'deposit', 18250.00, '2025-03-03', '13:08:55', 'جوڵە کردن لە  IQD بۆ fast pay card', 350.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 13:16:44', '2025-03-03 13:16:44', 731, 765, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25059, 6473, '2b413e4d-5eb4-4f48-bd25-5390984c1ccb', 'withdrawal', 17900.00, '2025-03-03', '13:08:55', 'جوڵە کردن لە fast pay card بۆ IQD', 350.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 13:16:44', '2025-03-03 13:16:44', 765, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25060, 6473, '2b413e4d-5eb4-4f48-bd25-5390984c1ccb', 'withdrawal', 17900.00, '2025-03-03', '13:08:55', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 13:16:44', '2025-03-03 13:16:44', 71, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25061, 6473, '2b413e4d-5eb4-4f48-bd25-5390984c1ccb', 'deposit', 350.00, '2025-03-03', '13:08:55', 'جوڵە کردن لە fast pay card بۆ IQD', 0.00, 132, NULL, NULL, NULL, NULL, NULL, '2025-03-03 13:16:44', '2025-03-03 13:16:44', 72, 731, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25062, NULL, '3af1f552-edaa-46ca-b42c-ba21df05628d', 'withdrawal', 12575000.00, '2025-03-03', '14:49:33', NULL, 0.00, 134, 'sarf hsab sardar frsat', NULL, NULL, NULL, NULL, '2025-03-03 14:49:33', '2025-03-03 14:49:33', 171, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25063, NULL, '3af1f552-edaa-46ca-b42c-ba21df05628d', 'withdrawal', 12575000.00, '2025-03-03', '14:49:33', NULL, 0.00, 134, 'sarf hsab sardar frsat', NULL, NULL, NULL, NULL, '2025-03-03 14:49:33', '2025-03-03 14:49:33', 2, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25064, NULL, '3af1f552-edaa-46ca-b42c-ba21df05628d', 'deposit', 0.00, '2025-03-03', '14:49:33', 'Fee collected for withdrawal', 0.00, 134, 'sarf hsab sardar frsat', NULL, NULL, NULL, NULL, '2025-03-03 14:49:33', '2025-03-03 14:49:33', 23, 171, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25065, NULL, 'ef550b67-6427-460b-a8bb-17411998cf1d', 'withdrawal', 9500.00, '2025-03-03', '14:51:45', NULL, 0.00, 134, 'sard ashti', NULL, NULL, NULL, NULL, '2025-03-03 14:51:45', '2025-03-03 14:51:45', 725, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25066, NULL, 'ef550b67-6427-460b-a8bb-17411998cf1d', 'withdrawal', 9500.00, '2025-03-03', '14:51:45', NULL, 0.00, 134, 'sard ashti', NULL, NULL, NULL, NULL, '2025-03-03 14:51:45', '2025-03-03 14:51:45', 1, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25067, NULL, 'ef550b67-6427-460b-a8bb-17411998cf1d', 'deposit', 0.00, '2025-03-03', '14:51:45', 'Fee collected for withdrawal', 0.00, 134, 'sard ashti', NULL, NULL, NULL, NULL, '2025-03-03 14:51:45', '2025-03-03 14:51:45', 22, 725, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25074, NULL, 'dfa8b844-c2cf-4875-b69f-6d18c25b9405', 'withdrawal', 9557000.00, '2025-03-03', '15:01:35', NULL, 57000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 15:01:35', '2025-03-03 15:01:35', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25075, NULL, 'dfa8b844-c2cf-4875-b69f-6d18c25b9405', 'withdrawal', 9557000.00, '2025-03-03', '15:01:35', NULL, 57000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 15:01:35', '2025-03-03 15:01:35', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25076, NULL, 'dfa8b844-c2cf-4875-b69f-6d18c25b9405', 'deposit', 57000.00, '2025-03-03', '15:01:35', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 15:01:35', '2025-03-03 15:01:35', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25077, NULL, '490975ed-9111-4af8-bd20-c433ea70ebc0', 'deposit', 12575000.00, '2025-03-03', '15:02:02', NULL, 0.00, 1, 'm.runaki', NULL, NULL, NULL, NULL, '2025-03-03 15:02:02', '2025-03-03 15:02:02', 85, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25078, NULL, '490975ed-9111-4af8-bd20-c433ea70ebc0', 'deposit', 12575000.00, '2025-03-03', '15:02:02', NULL, 0.00, 1, 'm.runaki', NULL, NULL, NULL, NULL, '2025-03-03 15:02:02', '2025-03-03 15:02:02', 2, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25079, NULL, '490975ed-9111-4af8-bd20-c433ea70ebc0', 'deposit', 0.00, '2025-03-03', '15:02:02', 'Fee collected for deposit', 0.00, 1, 'm.runaki', NULL, NULL, NULL, NULL, '2025-03-03 15:02:02', '2025-03-03 15:02:02', 23, 85, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25080, NULL, '668e18c2-d3c1-4461-bf50-787030e10b54', 'deposit', 1085000.00, '2025-03-03', '15:04:44', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-03-03 15:04:44', '2025-03-03 15:04:44', 1098, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25081, NULL, '668e18c2-d3c1-4461-bf50-787030e10b54', 'deposit', 1085000.00, '2025-03-03', '15:04:44', NULL, 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-03-03 15:04:44', '2025-03-03 15:04:44', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25082, NULL, '668e18c2-d3c1-4461-bf50-787030e10b54', 'deposit', 0.00, '2025-03-03', '15:04:44', 'Fee collected for deposit', 0.00, 1, 'taswea qi', NULL, NULL, NULL, NULL, '2025-03-03 15:04:44', '2025-03-03 15:04:44', 23, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25083, NULL, '215c57b3-ee4b-4286-8f2a-8c9ac8584429', 'withdrawal', 1503500.00, '2025-03-03', '15:05:42', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:05:42', '2025-03-03 15:05:42', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25084, NULL, '215c57b3-ee4b-4286-8f2a-8c9ac8584429', 'withdrawal', 1500000.00, '2025-03-03', '15:05:42', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:05:42', '2025-03-03 15:05:42', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25085, NULL, '215c57b3-ee4b-4286-8f2a-8c9ac8584429', 'withdrawal', 1503500.00, '2025-03-03', '15:05:42', NULL, 3500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:05:42', '2025-03-03 15:05:42', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25086, NULL, '2697ad8b-2668-4879-a413-2be543b39d2e', 'withdrawal', 670000.00, '2025-03-03', '15:10:44', NULL, 0.00, 1, 'sarf ahmed baper hsab', NULL, NULL, NULL, NULL, '2025-03-03 15:10:44', '2025-03-03 15:10:44', 181, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25087, NULL, '2697ad8b-2668-4879-a413-2be543b39d2e', 'withdrawal', 670000.00, '2025-03-03', '15:10:44', NULL, 0.00, 1, 'sarf ahmed baper hsab', NULL, NULL, NULL, NULL, '2025-03-03 15:10:44', '2025-03-03 15:10:44', 2, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25088, NULL, '2697ad8b-2668-4879-a413-2be543b39d2e', 'deposit', 0.00, '2025-03-03', '15:10:44', 'Fee collected for withdrawal', 0.00, 1, 'sarf ahmed baper hsab', NULL, NULL, NULL, NULL, '2025-03-03 15:10:44', '2025-03-03 15:10:44', 23, 181, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25089, NULL, 'bda20ee6-bc2c-4c85-9c09-3fe351e43852', 'deposit', 670000.00, '2025-03-03', '15:12:20', NULL, 0.00, 1, 'hatu hsab mohmaed ibrahem', NULL, NULL, NULL, NULL, '2025-03-03 15:12:20', '2025-03-03 15:12:20', 212, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25090, NULL, 'bda20ee6-bc2c-4c85-9c09-3fe351e43852', 'deposit', 670000.00, '2025-03-03', '15:12:20', NULL, 0.00, 1, 'hatu hsab mohmaed ibrahem', NULL, NULL, NULL, NULL, '2025-03-03 15:12:20', '2025-03-03 15:12:20', 2, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25091, NULL, 'bda20ee6-bc2c-4c85-9c09-3fe351e43852', 'deposit', 0.00, '2025-03-03', '15:12:20', 'Fee collected for deposit', 0.00, 1, 'hatu hsab mohmaed ibrahem', NULL, NULL, NULL, NULL, '2025-03-03 15:12:20', '2025-03-03 15:12:20', 23, 212, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25092, NULL, 'e6e1a880-a812-4587-8992-448c01a726e0', 'withdrawal', 2721500.00, '2025-03-03', '15:15:12', NULL, 5500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:15:12', '2025-03-03 15:15:12', 1098, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25093, NULL, 'e6e1a880-a812-4587-8992-448c01a726e0', 'withdrawal', 2716000.00, '2025-03-03', '15:15:12', NULL, 5500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:15:12', '2025-03-03 15:15:12', 18, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25094, NULL, 'e6e1a880-a812-4587-8992-448c01a726e0', 'withdrawal', 2721500.00, '2025-03-03', '15:15:12', NULL, 5500.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:15:12', '2025-03-03 15:15:12', 2, 1098, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25098, NULL, '0052d8de-4030-47b5-b932-f4daec1fdb6b', 'deposit', 3000.00, '2025-03-03', '15:17:14', NULL, 0.00, 1, 'wasil', NULL, NULL, NULL, NULL, '2025-03-03 15:17:14', '2025-03-03 15:17:14', 237, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25099, NULL, '0052d8de-4030-47b5-b932-f4daec1fdb6b', 'deposit', 3000.00, '2025-03-03', '15:17:14', NULL, 0.00, 1, 'wasil', NULL, NULL, NULL, NULL, '2025-03-03 15:17:14', '2025-03-03 15:17:14', 1, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25100, NULL, '0052d8de-4030-47b5-b932-f4daec1fdb6b', 'deposit', 0.00, '2025-03-03', '15:17:14', 'Fee collected for deposit', 0.00, 1, 'wasil', NULL, NULL, NULL, NULL, '2025-03-03 15:17:14', '2025-03-03 15:17:14', 22, 237, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25101, NULL, 'c8a513d3-ffbd-43e5-be94-35b30cae9340', 'withdrawal', 1003000.00, '2025-03-03', '15:18:53', NULL, 3000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 15:18:53', '2025-03-03 15:18:53', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25102, NULL, 'c8a513d3-ffbd-43e5-be94-35b30cae9340', 'withdrawal', 1003000.00, '2025-03-03', '15:18:53', NULL, 3000.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 15:18:53', '2025-03-03 15:18:53', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25103, NULL, 'c8a513d3-ffbd-43e5-be94-35b30cae9340', 'deposit', 3000.00, '2025-03-03', '15:18:53', 'Fee collected for withdrawal', 0.00, 1, 'super qi', NULL, NULL, NULL, NULL, '2025-03-03 15:18:53', '2025-03-03 15:18:53', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25104, NULL, '05ba098c-8530-4c6f-9943-a6e3ce0c5e03', 'withdrawal', 200500.00, '2025-03-03', '15:19:29', NULL, 500.00, 1, 'fib u fastpay', NULL, NULL, NULL, NULL, '2025-03-03 15:19:29', '2025-03-03 15:19:29', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25105, NULL, '05ba098c-8530-4c6f-9943-a6e3ce0c5e03', 'withdrawal', 200500.00, '2025-03-03', '15:19:29', NULL, 500.00, 1, 'fib u fastpay', NULL, NULL, NULL, NULL, '2025-03-03 15:19:29', '2025-03-03 15:19:29', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25106, NULL, '05ba098c-8530-4c6f-9943-a6e3ce0c5e03', 'deposit', 500.00, '2025-03-03', '15:19:29', 'Fee collected for withdrawal', 0.00, 1, 'fib u fastpay', NULL, NULL, NULL, NULL, '2025-03-03 15:19:29', '2025-03-03 15:19:29', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25107, NULL, 'c21cb5d2-718d-4626-96dc-4c26dcb044b7', 'deposit', 12870000.00, '2025-03-03', '15:20:33', '8755$-147000', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-03-03 15:20:33', '2025-03-03 15:20:33', 216, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25108, NULL, 'c21cb5d2-718d-4626-96dc-4c26dcb044b7', 'deposit', 12870000.00, '2025-03-03', '15:20:33', '8755$-147000', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-03-03 15:20:33', '2025-03-03 15:20:33', 2, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25109, NULL, 'c21cb5d2-718d-4626-96dc-4c26dcb044b7', 'deposit', 0.00, '2025-03-03', '15:20:33', 'Fee collected for deposit', 0.00, 1, 'dubai raj3', NULL, NULL, NULL, NULL, '2025-03-03 15:20:33', '2025-03-03 15:20:33', 23, 216, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25110, NULL, '9ede3077-c7b8-40a3-b3eb-4cdd15c295bc', 'withdrawal', 10385.00, '2025-03-03', '15:22:15', NULL, 10.00, 1, 'zaxo-jutyar faesal', NULL, NULL, NULL, NULL, '2025-03-03 15:22:15', '2025-03-03 15:22:15', 200, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25111, NULL, '9ede3077-c7b8-40a3-b3eb-4cdd15c295bc', 'withdrawal', 10385.00, '2025-03-03', '15:22:15', NULL, 10.00, 1, 'zaxo-jutyar faesal', NULL, NULL, NULL, NULL, '2025-03-03 15:22:15', '2025-03-03 15:22:15', 1, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25112, NULL, '9ede3077-c7b8-40a3-b3eb-4cdd15c295bc', 'deposit', 10.00, '2025-03-03', '15:22:15', 'Fee collected for withdrawal', 0.00, 1, 'zaxo-jutyar faesal', NULL, NULL, NULL, NULL, '2025-03-03 15:22:15', '2025-03-03 15:22:15', 22, 200, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25113, NULL, 'e481bf88-41a2-413b-89e1-7b94e609bc75', 'withdrawal', 2604000.00, '2025-03-03', '15:24:30', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:24:30', '2025-03-03 15:24:30', 162, 18, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25114, NULL, 'e481bf88-41a2-413b-89e1-7b94e609bc75', 'withdrawal', 2600000.00, '2025-03-03', '15:24:30', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:24:30', '2025-03-03 15:24:30', 18, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25115, NULL, 'e481bf88-41a2-413b-89e1-7b94e609bc75', 'withdrawal', 2604000.00, '2025-03-03', '15:24:30', NULL, 4000.00, 1, 'zaincash', NULL, NULL, NULL, NULL, '2025-03-03 15:24:30', '2025-03-03 15:24:30', 2, 162, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25116, NULL, '08db1b7b-3a2d-4fbb-a1c5-1e7afa9b2dc7', 'withdrawal', 3000.00, '2025-03-03', '15:26:44', NULL, 0.00, 1, 'ali hamza', NULL, NULL, NULL, NULL, '2025-03-03 15:26:44', '2025-03-03 15:26:44', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25117, NULL, '08db1b7b-3a2d-4fbb-a1c5-1e7afa9b2dc7', 'withdrawal', 3000.00, '2025-03-03', '15:26:44', NULL, 0.00, 1, 'ali hamza', NULL, NULL, NULL, NULL, '2025-03-03 15:26:44', '2025-03-03 15:26:44', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25118, NULL, '08db1b7b-3a2d-4fbb-a1c5-1e7afa9b2dc7', 'deposit', 0.00, '2025-03-03', '15:26:44', 'Fee collected for withdrawal', 0.00, 1, 'ali hamza', NULL, NULL, NULL, NULL, '2025-03-03 15:26:44', '2025-03-03 15:26:44', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25119, NULL, 'f7453881-4ee1-4c8a-8ae8-ab2c4a17563c', 'deposit', 5127.00, '2025-03-03', '15:27:11', NULL, 2.00, 1, 'dhuk-karzan azad', NULL, NULL, NULL, NULL, '2025-03-03 15:27:11', '2025-03-03 15:27:11', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25120, NULL, 'f7453881-4ee1-4c8a-8ae8-ab2c4a17563c', 'deposit', 5127.00, '2025-03-03', '15:27:11', NULL, 2.00, 1, 'dhuk-karzan azad', NULL, NULL, NULL, NULL, '2025-03-03 15:27:11', '2025-03-03 15:27:11', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25121, NULL, 'f7453881-4ee1-4c8a-8ae8-ab2c4a17563c', 'deposit', 2.00, '2025-03-03', '15:27:11', 'Fee collected for deposit', 0.00, 1, 'dhuk-karzan azad', NULL, NULL, NULL, NULL, '2025-03-03 15:27:11', '2025-03-03 15:27:11', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25122, NULL, '47767166-b6e2-47bf-8d88-91d2085af781', 'deposit', 5002.00, '2025-03-03', '15:27:40', NULL, 2.00, 1, 'slemani-klawesh hasan', NULL, NULL, NULL, NULL, '2025-03-03 15:27:40', '2025-03-03 15:27:40', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25123, NULL, '47767166-b6e2-47bf-8d88-91d2085af781', 'deposit', 5002.00, '2025-03-03', '15:27:40', NULL, 2.00, 1, 'slemani-klawesh hasan', NULL, NULL, NULL, NULL, '2025-03-03 15:27:40', '2025-03-03 15:27:40', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25124, NULL, '47767166-b6e2-47bf-8d88-91d2085af781', 'deposit', 2.00, '2025-03-03', '15:27:40', 'Fee collected for deposit', 0.00, 1, 'slemani-klawesh hasan', NULL, NULL, NULL, NULL, '2025-03-03 15:27:40', '2025-03-03 15:27:40', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25125, NULL, '9cf0d3a6-007d-4f87-a32a-7d84307f10b6', 'deposit', 10381.00, '2025-03-03', '15:28:25', NULL, 6.00, 1, 'jutyar-faesal', NULL, NULL, NULL, NULL, '2025-03-03 15:28:25', '2025-03-03 15:28:25', 169, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25126, NULL, '9cf0d3a6-007d-4f87-a32a-7d84307f10b6', 'deposit', 10381.00, '2025-03-03', '15:28:25', NULL, 6.00, 1, 'jutyar-faesal', NULL, NULL, NULL, NULL, '2025-03-03 15:28:25', '2025-03-03 15:28:25', 1, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25127, NULL, '9cf0d3a6-007d-4f87-a32a-7d84307f10b6', 'deposit', 6.00, '2025-03-03', '15:28:25', 'Fee collected for deposit', 0.00, 1, 'jutyar-faesal', NULL, NULL, NULL, NULL, '2025-03-03 15:28:25', '2025-03-03 15:28:25', 22, 169, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25128, NULL, '69a7b236-2ef6-4fd4-b788-bb01e408f617', 'withdrawal', 12575000.00, '2025-03-03', '15:28:56', NULL, 0.00, 1, 'm.runaki', NULL, NULL, NULL, NULL, '2025-03-03 15:28:56', '2025-03-03 15:28:56', 170, 2, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25129, NULL, '69a7b236-2ef6-4fd4-b788-bb01e408f617', 'withdrawal', 12575000.00, '2025-03-03', '15:28:56', NULL, 0.00, 1, 'm.runaki', NULL, NULL, NULL, NULL, '2025-03-03 15:28:56', '2025-03-03 15:28:56', 2, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25130, NULL, '69a7b236-2ef6-4fd4-b788-bb01e408f617', 'deposit', 0.00, '2025-03-03', '15:28:56', 'Fee collected for withdrawal', 0.00, 1, 'm.runaki', NULL, NULL, NULL, NULL, '2025-03-03 15:28:56', '2025-03-03 15:28:56', 23, 170, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25131, NULL, 'b60cf48c-f10e-4ff3-933a-df93f8977acd', 'deposit', 85194.00, '2025-03-03', '19:33:25', NULL, 0.00, 136, 'Ali abbas', NULL, NULL, NULL, NULL, '2025-03-03 19:33:25', '2025-03-03 19:33:25', 1103, 1, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25132, NULL, 'b60cf48c-f10e-4ff3-933a-df93f8977acd', 'deposit', 85194.00, '2025-03-03', '19:33:25', NULL, 0.00, 136, 'Ali abbas', NULL, NULL, NULL, NULL, '2025-03-03 19:33:25', '2025-03-03 19:33:25', 1, 1103, NULL, NULL, 'approved', 0, 0, NULL, NULL, NULL, NULL),
(25133, NULL, 'cb66af78-dc24-4a70-91c5-5c34eebe31bd', 'withdrawal', 1003000.00, '2025-03-03', '19:41:09', NULL, 0.00, 1, 'sarf bo hisab 